/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.stdrsm.bill;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.Locale;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsrbd.common.enums.BlackListSourceEnum;
import kd.tsc.tstpm.business.domain.stdrsm.helper.BlacklistDataHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmBusiAppHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.CheckPermissionHelper;
import kd.tsc.tstpm.common.utils.ViewUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class BlacklistInfoPlugin
extends HRDynamicFormBasePlugin {
    String BTN_EDIT = "btn_edit";
    String BTN_CANCEL = "btn_cancel";
    String BTN_SAVE = "btn_save";
    String LABEL_ADD_SOURCE = "labelap2";
    String LABEL_CREATOR = "labelap21";
    String LABEL_CREATE_TIME = "labelap22";
    String LABEL_MODIFIER = "labelap23";
    String LABEL_MODIFY_TIME = "labelap24";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{this.BTN_EDIT, this.BTN_CANCEL, this.BTN_SAVE});
    }

    public void afterCreateNewData(EventObject e) {
        long stdRsmId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        DynamicObject blacklistDy = BlacklistDataHelper.loadSingle((long)stdRsmId);
        this.getModel().setValue("blareason", (Object)blacklistDy.getString("blareason"));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Label addSource = (Label)this.getControl(this.LABEL_ADD_SOURCE);
        Label creator = (Label)this.getControl(this.LABEL_CREATOR);
        Label createTime = (Label)this.getControl(this.LABEL_CREATE_TIME);
        Label modifier = (Label)this.getControl(this.LABEL_MODIFIER);
        Label modifyTime = (Label)this.getControl(this.LABEL_MODIFY_TIME);
        addSource.setText(BlackListSourceEnum.getBlackListSourceEnumBySource((String)blacklistDy.getString("addsource")).getName());
        creator.setText(blacklistDy.getDynamicObject("creator").getString("name"));
        createTime.setText(simpleDateFormat.format(blacklistDy.getDate("createtime")));
        modifier.setText(blacklistDy.getDynamicObject("modifier").getString("name"));
        modifyTime.setText(simpleDateFormat.format(blacklistDy.getDate("modifytime")));
    }

    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{this.BTN_CANCEL, this.BTN_SAVE});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{this.BTN_EDIT});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"blareason"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        boolean hasPermission;
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        long stdRsmId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        String checkResult = StdRsmBusiAppHelper.checkBlacklistDetailPageStdRsmDataStatus((long)stdRsmId);
        if (ObjectUtils.isNotEmpty((Object)checkResult)) {
            IFormView mainView = this.getView().getMainView();
            mainView.showErrorNotification(checkResult);
            IFormView parentView = this.getView().getParentView();
            parentView.close();
            this.getView().sendFormAction(mainView);
            this.getView().sendFormAction(parentView);
            evt.setCancel(true);
            return;
        }
        if ((StringUtils.equals((CharSequence)"btn_save", (CharSequence)key) || StringUtils.equals((CharSequence)"btn_edit", (CharSequence)key)) && !(hasPermission = CheckPermissionHelper.getInstance().checkBlackListPermission("0AQ3YJ2LET+U"))) {
            String permissionName = ResManager.loadKDString((String)"\u201c\u7f16\u8f91\u201c", (String)"BlacklistInfoPlugin_0", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709%s\u7684\u6743\u9650\u3002", (String)"CandidateDetailPagePlugin_15", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]), permissionName));
            evt.setCancel(true);
            return;
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (StringUtils.equals((CharSequence)this.BTN_EDIT, (CharSequence)key)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.BTN_EDIT});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.BTN_CANCEL, this.BTN_SAVE});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"blareason"});
        } else if (StringUtils.equals((CharSequence)this.BTN_CANCEL, (CharSequence)key)) {
            if (this.getModel().getDataChanged()) {
                ViewUtils.showDataChangedConfirm((IFormView)this.getView(), (String)this.getModel().getChangeDesc(), (ConfirmCallBackListener)new ConfirmCallBackListener("datachange", (IFormPlugin)this));
            } else {
                this.getView().invokeOperation("refresh");
            }
        } else if (StringUtils.equals((CharSequence)this.BTN_SAVE, (CharSequence)key)) {
            long stdRsmId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
            DynamicObject blacklistDy = BlacklistDataHelper.loadSingle((long)stdRsmId);
            blacklistDy.set("blareason", this.getModel().getValue("blareason"));
            blacklistDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
            blacklistDy.set("modifytime", (Object)new Date());
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"tstpm_blacklist", (DynamicObject[])new DynamicObject[]{blacklistDy}, (OperateOption)OperateOption.create());
            if (operationResult.isSuccess()) {
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        String resultValue = messageBoxClosedEvent.getResultValue();
        if (StringUtils.equals((CharSequence)"datachange", (CharSequence)callBackId) && StringUtils.equals((CharSequence)"Yes", (CharSequence)resultValue)) {
            this.getView().invokeOperation("refresh");
        }
    }
}

