/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.stdrsm.bill;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsrbd.business.domain.label.service.LabelDataHelper;
import kd.tsc.tsrbd.common.entity.label.AiInsightParamEntity;
import kd.tsc.tsrbd.common.enums.LabelTagObjTypeEnum;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmServiceHelper;

public class SimpleStdRsmEdit
extends HRDynamicFormBasePlugin {
    private static final Log logger = LogFactory.getLog(SimpleStdRsmEdit.class);
    private static final String CACHE_KEY = "sharecanditate_";
    private static final String FLEXPANELAP = "flexpanelap";
    private static final String FLEXPANELAP_1 = "flexpanelap1";
    private static final String FLEXPANELAP_2 = "flexpanelap2";
    private static final String FLEXPANELAP_6 = "flexpanelap6";
    private static final String FLEXPANELAP_5 = "flexpanelap5";
    private static final String TABPAGEAP = "tabpageap";
    private static final String TSIRP_LINKINCALID = "tsirp_linkinvalid";
    private static final String IS_SHOW_BUTTON = "isshowbutton";
    private static final String PAGE_TYPE = "pagetype";
    private static final String DETAIL = "detail";
    private static final String IS_SIMPLE_STDRSM = "isSimpleStdRsm";

    public void afterBindData(EventObject e) {
        String token = this.getView().getFormShowParameter().getCustomParam("id").toString();
        DistributeSessionlessCache appCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String cache = (String)appCache.get(CACHE_KEY + token);
        if (null != cache) {
            JSONObject cacheJson = JSONObject.parseObject((String)cache);
            Long stdRsmId = StandardResumeDataHelper.getMasterCandidateId((Long)cacheJson.getLong("id"));
            DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmDy((Long)stdRsmId);
            if (ResumeHisDataStatusEnum.DELETED.getStatus().equals(stdRsmDy.getString("datastatus"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAP_1, FLEXPANELAP_2});
                Container container = (Container)this.getControl(FLEXPANELAP_5);
                FormShowParameter formShowParameter = SimpleStdRsmEdit.setFlexFormShow(container, FLEXPANELAP_6, "tstpm_stdrsmdelete");
                this.getView().showForm(formShowParameter);
            } else {
                Long sourceVid = stdRsmDy.getLong("sourcevid");
                this.loadPage("tstpm_head_template", "flex_head", stdRsmId);
                AiInsightParamEntity aiInsightParamEntity = new AiInsightParamEntity();
                aiInsightParamEntity.setAppRsmId(sourceVid);
                aiInsightParamEntity.setTargetKey("flexpanelap21");
                aiInsightParamEntity.setTypeId(LabelTagObjTypeEnum.OUT_STDRSM.getId());
                aiInsightParamEntity.setShowMyLabel(Boolean.valueOf(true));
                aiInsightParamEntity.setCanEditLabel(Boolean.valueOf(false));
                aiInsightParamEntity.setFold(Boolean.valueOf(false));
                LabelDataHelper.showAppRsmDefaultLabelPage((IFormView)this.getView(), (AiInsightParamEntity)aiInsightParamEntity);
                this.loadPage("tstpm_stdrsm_detail", TABPAGEAP, stdRsmId);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        String token = this.getView().getFormShowParameter().getCustomParam("id").toString();
        DistributeSessionlessCache appCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String cache = (String)appCache.get(CACHE_KEY + token);
        if (null == cache) {
            this.invalidPage();
        } else {
            JSONObject cacheJson = JSONObject.parseObject((String)cache);
            logger.info("appCache:{}", (Object)appCache);
            logger.info("cache:{}", (Object)cache);
            logger.info("cacheJson:{}", (Object)cacheJson);
            long urlValidTime = this.getUrlValidTime(cacheJson);
            if (urlValidTime <= 0L) {
                this.invalidPage();
            }
        }
    }

    private void invalidPage() {
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAP_1, FLEXPANELAP_2});
        Container container = (Container)this.getControl(FLEXPANELAP_5);
        FormShowParameter formShowParameter = SimpleStdRsmEdit.setFlexFormShow(container, FLEXPANELAP_6, TSIRP_LINKINCALID);
        this.getView().showForm(formShowParameter);
    }

    private static FormShowParameter setFlexFormShow(Container flexPanel, String flexKey, String formId) {
        FlexPanelAp flex = new FlexPanelAp();
        flex.setKey(flexKey);
        flexPanel.deleteControls(new String[]{flexKey});
        flexPanel.addControls(Collections.singletonList(flex.createControl()));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(flex.getKey());
        return formShowParameter;
    }

    public long getUrlValidTime(JSONObject cacheJson) {
        Date sendTime = cacheJson.getDate("initiatetime");
        Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        long dateDiff = HRDateTimeUtils.dateDiff((Date)sendTime, (Date)now);
        return 604800L - dateDiff / 1000L;
    }

    private void loadPage(String formId, String targetKey, Long stdRsmId) {
        DynamicObject stdRsmDy = StandardResumeDataHelper.queryOne((Long)stdRsmId);
        long vid = stdRsmDy.getLong("sourcevid");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setTargetKey(targetKey);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        if (StringUtils.equals((CharSequence)"tsrbd_label_show", (CharSequence)formId)) {
            formShowParameter.setCustomParam("type", (Object)String.valueOf(LabelTagObjTypeEnum.OUT_STDRSM.getId()));
            formShowParameter.setCustomParam(IS_SHOW_BUTTON, (Object)Boolean.FALSE);
            formShowParameter.setCustomParam(PAGE_TYPE, (Object)DETAIL);
            formShowParameter.setCustomParam("vid", (Object)vid);
        }
        if (StringUtils.equals((CharSequence)"tstpm_head_template", (CharSequence)formId)) {
            formShowParameter.setCustomParam("page_type", (Object)"2");
        }
        formShowParameter.setCustomParam("id", (Object)stdRsmId);
        formShowParameter.setCustomParam("vid", (Object)vid);
        formShowParameter.setCustomParam(IS_SIMPLE_STDRSM, (Object)"1");
        this.getView().showForm(formShowParameter);
    }
}

