/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.stdrsm.bill;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeUtilsHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmBusiAppHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tstpm.business.infrastructure.utils.ResumeUtil;
import kd.tsc.tstpm.common.utils.ResumeDyUtil;
import kd.tsc.tstpm.common.utils.ViewUtils;

public class StdRsmDetailHeadEditPlugin
extends HRDynamicFormBasePlugin {
    private static final Log logger = LogFactory.getLog(StdRsmDetailHeadEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Long stdRsmId = (Long)showParameter.getCustomParam("stdRsmId");
        DynamicObject rsmDy = StdRsmServiceHelper.getStdRsmDy((Long)stdRsmId);
        HRDynamicObjectUtils.copy((DynamicObject)rsmDy, (DynamicObject)this.getModel().getDataEntity());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Long stdRsmId = (Long)showParameter.getCustomParam("stdRsmId");
        String checkResult = StdRsmBusiAppHelper.checkStdRsmDataStatus((long)stdRsmId);
        if (checkResult.trim().length() > 0) {
            IFormView mainView = this.getView().getMainView();
            mainView.showErrorNotification(checkResult);
            this.getView().sendFormAction(mainView);
            this.getView().getParentView().close();
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        if (!this.checkContactInfo(args)) {
            return;
        }
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"save", (CharSequence)operateKey)) {
            DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmDy((Long)stdRsmId);
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DataEntityPropertyCollection properties = this.getModel().getDataEntity().getDynamicObjectType().getProperties();
            boolean flag = false;
            for (IDataEntityProperty property : properties) {
                Object oldValue;
                Object newValue;
                String name = property.getName();
                logger.info("HeadInfoEdit.beforeDoOperation.property.name:{}", (Object)name);
                if (HRStringUtils.equals((String)name, (String)"tracktime") || !(flag = ResumeDyUtil.isValueChanged((Object)(newValue = dataEntity.get(name)), (Object)(oldValue = stdRsmDy.get(name))))) continue;
                break;
            }
            if (!flag) {
                this.getModel().setDataChanged(false);
                args.setCancel(Boolean.TRUE.booleanValue());
                this.getView().close();
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ResumeUtil_2", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(this.getView().getParentView());
            } else {
                Container block = (Container)this.getView().getControl("fieldsetpanelap");
                List items = block.getItems();
                for (Control item : items) {
                    String key = item.getKey();
                    stdRsmDy.set(key, this.getModel().getValue(key));
                }
                Date partwt = this.getModel().getDataEntity().getDate("partwt");
                stdRsmDy.set("workingyears", (Object)ResumeAnalysisHelper.calMonthByStartDate((Date)partwt));
                OperationServiceHelper.executeOperate((String)"customsave", (String)"tstpm_stdrsm", (DynamicObject[])new DynamicObject[]{stdRsmDy}, (OperateOption)OperateOption.create());
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("close".equals(itemKey)) {
            if (this.getModel().getDataChanged()) {
                this.showCustomConfirm(this.getModel().getChangeDesc(), itemKey, (AbstractFormPlugin)this);
            } else {
                this.getView().close();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String resultValue = messageBoxClosedEvent.getResultValue();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"Yes", (CharSequence)resultValue) && callBackId.contains("close")) {
            this.getView().close();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult result = args.getOperationResult();
        if (result.isSuccess()) {
            IFormView candidateDetailView = this.getView().getParentView().getParentView();
            IFormView headTemplateView = this.getView().getParentView();
            String stdRsmDetailPageId = candidateDetailView.getPageCache().get("tstpm_stdrsm_detailpageid");
            IFormView stdRsmDetailView = this.getView().getView(stdRsmDetailPageId);
            headTemplateView.invokeOperation("refresh");
            stdRsmDetailView.invokeOperation("refresh");
            this.getView().sendFormAction(headTemplateView);
            this.getView().sendFormAction(stdRsmDetailView);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String phone;
        String name = e.getProperty().getName();
        if ("phone".equals(name) && StringUtils.isNotEmpty((CharSequence)(phone = (String)e.getChangeSet()[0].getNewValue())) && !ResumeUtil.checkPhone((String)phone)) {
            String message = ResManager.loadKDString((String)"\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"HeadInfoEdit_1", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]);
            this.getView().showFieldTip(ResumeUtilsHelper.createFieldTip((String)message, (String)"phone"));
        }
    }

    private boolean checkContactInfo(BeforeDoOperationEventArgs args) {
        boolean isCheckOk = true;
        String phone = this.getModel().getDataEntity().getString("phone");
        String email = this.getModel().getDataEntity().getString("email");
        ArrayList checkFailedFieldList = Lists.newArrayListWithExpectedSize((int)2);
        if (phone != null && phone.length() > 0) {
            if (!ResumeUtil.checkPhone((String)phone)) {
                checkFailedFieldList.add(this.getModel().getProperty("phone").getDisplayName().toString());
            } else if (phone.length() > 46) {
                checkFailedFieldList.add(this.getModel().getProperty("phone").getDisplayName().toString());
            }
        }
        if (email != null && email.length() > 100) {
            checkFailedFieldList.add(this.getModel().getProperty("email").getDisplayName().toString());
        }
        if (checkFailedFieldList.size() > 0) {
            isCheckOk = false;
            args.setCancel(Boolean.TRUE.booleanValue());
            String commonTipNotification = ViewUtils.getCommonTipNotification((List)checkFailedFieldList);
            this.getView().showTipNotification(commonTipNotification);
        }
        return isCheckOk;
    }

    private void showCustomConfirm(String detailMessage, String itemKey, AbstractFormPlugin plugin) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(itemKey, (IFormPlugin)plugin);
        HashMap btnNameMaps = Maps.newHashMapWithExpectedSize((int)2);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"BillView_0", (String)"bos-form-mvc", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"BillView_1", (String)"bos-form-mvc", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"BillView_2", (String)"bos-form-mvc", (Object[])new Object[0]);
        msg = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)msg) ? msg.replaceAll("\\\\r\\\\n", "\r\n") : msg;
        plugin.getView().showConfirm(msg, detailMessage, options, ConfirmTypes.Save, confirmCallBacks, (Map)btnNameMaps);
    }
}

