/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.stdrsm.bill;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tsrbd.common.utils.PageUtils;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeUtilsHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.ResumeValidateHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StandardLangAblDataHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StandardRelationWorkDataHelper;
import kd.tsc.tstpm.common.constants.rsm.sr.SrRsmKDString;
import kd.tsc.tstpm.common.utils.ResumeDyUtil;
import org.apache.commons.lang3.StringUtils;

public class StdRsmEntryNotDateEdit
extends HRCoreBaseBillEdit {
    private static final Log logger = LogFactory.getLog(StdRsmEntryNotDateEdit.class);

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object stdRsmIdObj = formShowParameter.getCustomParam("id");
        Long stdRsmId = stdRsmIdObj == null ? null : Long.valueOf(Long.parseLong(stdRsmIdObj.toString()));
        this.getModel().setValue("stdrsm", (Object)stdRsmId);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String formId = this.getView().getFormShowParameter().getFormId();
        if (StringUtils.equals((CharSequence)"tstpm_stdlangabl", (CharSequence)formId)) {
            Object langScore = this.getModel().getDataEntity().get("langcertscore");
            logger.info("StdRsmEntryNotDateEdit.beforeBindData.langScore:{}", langScore);
            if (langScore != null && new BigDecimal(langScore.toString()).compareTo(BigDecimal.ZERO) == 0) {
                this.getModel().setValue("langcertscore", null);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        IFormView view = this.getView();
        FormShowParameter parameter = this.getView().getParentView().getFormShowParameter();
        String dataStatus = (String)parameter.getCustomParam("datastatus");
        Long stdRsmId = (Long)parameter.getCustomParam("id");
        String validate = ResumeValidateHelper.validateResumeDetailStatus((Long)stdRsmId, (String)dataStatus);
        if (HRStringUtils.isNotEmpty((String)validate)) {
            PageUtils.showErrorNotificationAndClosePage((IFormView)view.getMainView(), (IFormView)view, (IFormView)view.getParentView().getParentView(), (String)validate);
            args.setCancel(true);
            return;
        }
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey)) {
            long id;
            String changePageName = this.getModel().getDataEntity().getDynamicObjectType().getName();
            if (HRStringUtils.equals((String)changePageName, (String)"tstpm_stdlangabl")) {
                long id2 = Long.parseLong(String.valueOf(this.getModel().getValue("id")));
                if (id2 != 0L) {
                    DynamicObject stdEduExp = StandardLangAblDataHelper.findStdEduExp((Long)id2);
                    DynamicObject dataEntity = this.getModel().getDataEntity();
                    DataEntityPropertyCollection properties = this.getModel().getDataEntity().getDynamicObjectType().getProperties();
                    boolean flag = false;
                    for (IDataEntityProperty property : properties) {
                        Object oldValue;
                        String name = property.getName();
                        logger.info("StdRsmEntryNotDateEdit.beforeDoOperation.property.name:{}", (Object)name);
                        Object newValue = dataEntity.get(name);
                        flag = ResumeDyUtil.isValueChanged((Object)newValue, (Object)(oldValue = stdEduExp.get(name)));
                        if (!flag) continue;
                        break;
                    }
                    if (!flag) {
                        args.setCancel(Boolean.TRUE.booleanValue());
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ResumeUtil_2", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
                        this.getModel().setDataChanged(false);
                        this.getView().close();
                    }
                }
            } else if (HRStringUtils.equals((String)changePageName, (String)"tstpm_stdrelationwork") && (id = Long.parseLong(String.valueOf(this.getModel().getValue("id")))) != 0L) {
                Object oldValue;
                IDataEntityProperty property;
                String name;
                Object newValue;
                DynamicObject stdPrjExp = StandardRelationWorkDataHelper.findStdRelationWork((Long)id);
                DynamicObject dataEntity = this.getModel().getDataEntity();
                DataEntityPropertyCollection properties = this.getModel().getDataEntity().getDynamicObjectType().getProperties();
                boolean flag = false;
                Iterator iterator = properties.iterator();
                while (iterator.hasNext() && !(flag = ResumeDyUtil.isValueChanged((Object)(newValue = dataEntity.get(name = (property = (IDataEntityProperty)iterator.next()).getName())), (Object)(oldValue = stdPrjExp.get(name))))) {
                }
                if (!flag) {
                    args.setCancel(Boolean.TRUE.booleanValue());
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ResumeUtil_2", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
                    this.getModel().setDataChanged(false);
                    this.getView().close();
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        List successPkIds;
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey) && (successPkIds = afterDoOperationEventArgs.getOperationResult().getSuccessPkIds()) != null && successPkIds.size() > 0) {
            Long stdRsmId = this.getModel().getDataEntity().getLong("stdrsm");
            String headTemplatePageId = this.getView().getParentView().getParentView().getPageCache().get("tstpm_head_templatepageid");
            IFormView headTemplateView = this.getView().getView(headTemplatePageId);
            headTemplateView.invokeOperation("refresh");
            this.getView().sendFormAction(headTemplateView);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String relationPhone;
        String propName = e.getProperty().getName();
        if ("phone".equals(propName) && StringUtils.isNotBlank((CharSequence)(relationPhone = this.getModel().getDataEntity().getString("phone"))) && !ResumeAnalysisHelper.checkPhone((String)relationPhone)) {
            String relationTip = SrRsmKDString.phoneError();
            this.getView().showFieldTip(ResumeUtilsHelper.createFieldTip((String)relationTip, (String)"phone"));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String phone;
        String key = evt.getItemKey();
        if (!HRStringUtils.equals((String)key, (String)"bar_save")) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        IDataEntityProperty property = this.getModel().getProperty("phone");
        if (property != null && StringUtils.isNotBlank((CharSequence)(phone = dataEntity.getString("phone"))) && !ResumeAnalysisHelper.checkPhone((String)phone)) {
            String tip = SrRsmKDString.phoneError();
            this.getView().showFieldTip(ResumeUtilsHelper.createFieldTip((String)tip, (String)"phone"));
        }
    }
}

