/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.stdrsm.list;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsrbd.common.utils.PageUtils;
import kd.tsc.tstpm.business.domain.stdrsm.helper.ResumeValidateHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmBusiAppHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmServiceHelper;

public class DeliveryRecordListPlugin
extends HRDynamicFormBasePlugin
implements HyperLinkClickListener {
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String KEY_VIEW_RESUME = "viewresume";
    private static final String KEY_DELIVERY = "rdelivery";
    public static final String KEY_IS_MERGE = "ismerge";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (KEY_IS_MERGE.equals(e.getProperty().getName())) {
            Boolean merge = (Boolean)this.getModel().getValue(KEY_IS_MERGE);
            Long stdRsmId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
            if (merge.booleanValue()) {
                DynamicObject[] midStdRsmIds = StdRsmServiceHelper.getMidStdRsmIds((Long)stdRsmId);
                List<Long> stdRsmIds = Arrays.stream(midStdRsmIds).map(dy -> dy.getLong("id")).collect(Collectors.toList());
                this.entryDataInit(stdRsmId, stdRsmIds);
            } else {
                this.entryDataInit(stdRsmId, null);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        Long stdRsmId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        this.entryDataInit(Long.valueOf(stdRsmId.toString()), null);
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        IFormView view = this.getView();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String dataStatus = (String)parameter.getCustomParam("datastatus");
        Long stdRsmId = (Long)parameter.getCustomParam("id");
        String validate = ResumeValidateHelper.validateResumeDetailStatus((Long)stdRsmId, (String)dataStatus);
        if (HRStringUtils.isNotEmpty((String)validate)) {
            PageUtils.showErrorNotificationAndClosePage((IFormView)view.getMainView(), (IFormView)view, (IFormView)view.getParentView(), (String)validate);
            return;
        }
        if (HRStringUtils.equals((String)KEY_VIEW_RESUME, (String)arg0.getFieldName())) {
            int rowIndex = arg0.getRowIndex();
            IDataModel entryOperate = this.getModel();
            DynamicObject entity = entryOperate.getEntryRowEntity(KEY_ENTRY_ENTITY, rowIndex);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("tstpm_rdeliverydetails");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            DynamicObject rdelivery = entity.getDynamicObject(KEY_DELIVERY);
            formShowParameter.setCustomParam("id", (Object)rdelivery.getLong("id"));
            String msg = ResManager.loadKDString((String)"\u7b80\u5386", (String)"DeliveryRecordListPlugin_0", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]);
            formShowParameter.setCaption(entity.getString("name") + msg);
            formShowParameter.setPageId(PageUtils.getPageId((String)rdelivery.getString("id"), (String)this.getView().getFormShowParameter().getAppId(), (String)"tstpm_rdeliverydetails", (String)this.getView().getFormShowParameter().getRootPageId()));
            this.getView().showForm(formShowParameter);
        }
    }

    private void entryDataInit(Long mainStdRsmId, List<Long> mergeIds) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(KEY_ENTRY_ENTITY);
        model.beginInit();
        TableValueSetter tableValueSetter = StdRsmBusiAppHelper.getMainStdRsmDeliveryRecordList((Long)mainStdRsmId, mergeIds);
        model.batchCreateNewEntryRow(KEY_ENTRY_ENTITY, tableValueSetter);
        model.endInit();
        this.getView().updateView(KEY_ENTRY_ENTITY);
        this.getView().setEnable(Boolean.FALSE, new String[]{KEY_ENTRY_ENTITY});
    }
}

