/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.stdrsm.list;

import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.mvc.list.ListDataProvider;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.ResumeFormHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.ResumeValidateHelper;

public class RecycleListPlugin
extends HRDataBaseList {
    private static final String SHOW_WORK_YEAR = "showworkingyears";

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        args.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u7b80\u5386\u56de\u6536\u7ad9", (String)"RecycleListPlugin_01", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection data = super.getData(start, limit);
                DynamicSimpleProperty property = new DynamicSimpleProperty(RecycleListPlugin.SHOW_WORK_YEAR, String.class, null);
                property.setName(RecycleListPlugin.SHOW_WORK_YEAR);
                data.getDynamicObjectType().addProperty((DynamicProperty)property);
                data.forEach(rowData -> {
                    int workingYears = rowData.getInt("workingyears");
                    String yearShow = ResumeAnalysisHelper.getWorkYearShow((int)workingYears);
                    rowData.set(RecycleListPlugin.SHOW_WORK_YEAR, (Object)yearShow);
                });
                return data;
            }
        });
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        ListSelectedRowCollection collection = this.getSelectedRows();
        Long primaryKeyValue = (Long)collection.get(0).getPrimaryKeyValue();
        String message = ResumeValidateHelper.recycleResumeValidate((IFormView)this.getView(), (long)primaryKeyValue);
        if (HRStringUtils.isEmpty((String)message)) {
            ResumeFormHelper.openShowRecycleFrom((IFormView)this.getView(), (Long)primaryKeyValue);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if ("recover".equals(args.getOperateKey())) {
            this.getView().invokeOperation("refresh");
        }
    }
}

