/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.talentpool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tsrbd.common.utils.PageUtils;
import kd.tsc.tstpm.business.domain.stdrsm.helper.ResumeValidateHelper;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.oprecord.TalentPoolOperateRecordService;
import kd.tsc.tstpm.business.domain.talentpool.helper.TalentPoolFunHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.CheckPermissionHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentListFunService;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentListServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ReserveReListPlugin
extends HRDynamicFormBasePlugin {
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String KEY_RESERVETIME = "reservetime";
    private static final String KEY_TALENTPOOL = "talentpool";
    private static final String KEY_TALENTPOOLNAME = "talentpoolname";
    private static final String KEY_RESERVEPER = "reserveper";
    private static final String REMOVE = "remove";
    private static final String TRANSFER = "transfer";
    private static final String TRANSFERCANDIDATEID = "transfercandidateid";
    private static final String TRANSFERTALENTPOOLID = "transfertalentpoolid";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        IFormView view = this.getView();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String dataStatus = (String)parameter.getCustomParam("datastatus");
        Long stdRsmId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        IDataModel iEntryOperate = this.getModel();
        int entryCurrentRowIndex = iEntryOperate.getEntryCurrentRowIndex(KEY_ENTRY_ENTITY);
        DynamicObject entryRowEntity = iEntryOperate.getEntryRowEntity(KEY_ENTRY_ENTITY, entryCurrentRowIndex);
        if (entryRowEntity == null) {
            return;
        }
        long stdId = entryRowEntity.getLong("id");
        long talentId = entryRowEntity.getDynamicObject(KEY_TALENTPOOL).getLong("id");
        ArrayList<Long> candidateIds = new ArrayList<Long>(1);
        ArrayList<Long> talentPoolIds = new ArrayList<Long>(1);
        ArrayList<Long> OperateUserIds = new ArrayList<Long>(1);
        candidateIds.add(stdId);
        talentPoolIds.add(talentId);
        OperateUserIds.add(talentId);
        if (HRStringUtils.equals((String)operate.getOperateKey(), (String)REMOVE)) {
            String validate = ResumeValidateHelper.validateResumeDetailStatus((Long)stdRsmId, (String)dataStatus);
            if (HRStringUtils.isNotEmpty((String)validate)) {
                PageUtils.showErrorNotificationAndClosePage((IFormView)view.getMainView(), (IFormView)view, (IFormView)view.getParentView(), (String)validate);
                return;
            }
            if (CheckPermissionHelper.getInstance().hasOperateAuth(talentId, "2/57Q834RUB41")) {
                TalentPoolOperateRecordService.getInstance().removeTalentPoolOp(candidateIds, TalentPoolOperateRecordService.getInstance().removePrePrivateTalPoo(OperateUserIds));
                Object[] reserveRecordDtArrays = TalentListFunService.removeReserveRecord(talentPoolIds, candidateIds);
                if (!HRArrayUtils.isEmpty((Object[])reserveRecordDtArrays)) {
                    this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u79fb\u9664\u6210\u529f\u3002", (String)"ReserveReListPlugin_0", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
                    this.getModel().deleteEntryRow(KEY_ENTRY_ENTITY, entryCurrentRowIndex);
                    this.getView().sendFormAction(this.getView().getParentView());
                } else {
                    this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u79fb\u9664\u5931\u8d25\uff0c\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\u3002", (String)"ReserveReListPlugin_1", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
                    this.getView().sendFormAction(this.getView().getParentView());
                }
            } else {
                this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u4eba\u624d\u5e93\u7684\"\u79fb\u9664\"\u6743\u9650\u3002", (String)"ReserveReListPlugin_2", (String)"tsc-tstpm-business", (Object[])new Object[0]));
                this.getView().sendFormAction(this.getView().getParentView());
            }
            List unClassifiedCandidateIds = TalentPoolFunHelper.queryCandidateReserve(candidateIds);
            if (CollectionUtils.isEmpty((Collection)unClassifiedCandidateIds)) {
                return;
            }
            TalentListFunService.saveCandidate2UnClassFy((List)unClassifiedCandidateIds);
        } else if (HRStringUtils.equals((String)operate.getOperateKey(), (String)TRANSFER)) {
            String validate = ResumeValidateHelper.validateResumeDetailStatus((Long)stdRsmId, (String)dataStatus);
            if (HRStringUtils.isNotEmpty((String)validate)) {
                PageUtils.showErrorNotificationAndClosePage((IFormView)view.getMainView(), (IFormView)view, (IFormView)view.getParentView(), (String)validate);
                return;
            }
            if (CheckPermissionHelper.getInstance().hasOperateAuth(talentId, "1Y+/KS0+9C8I1")) {
                this.getPageCache().put(TRANSFERCANDIDATEID, ((Object)candidateIds).toString().replaceAll("\\[|\\]", ""));
                this.getPageCache().put(TRANSFERTALENTPOOLID, ((Object)talentPoolIds).toString().replaceAll("\\[|\\]", ""));
                DynamicObject[] reserveRecordDtArrays = TalentPoolFunHelper.queryReserveDtArrays(talentPoolIds, candidateIds);
                if (reserveRecordDtArrays.length == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8f6c\u5e93\u5931\u8d25\uff0c\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\u3002", (String)"TalentListFunService_8", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
                    this.getView().updateView();
                    this.getView().invokeOperation("refresh");
                    return;
                }
                List reserveTalentPoolIds = TalentListFunService.getReserveByCandidateId(candidateIds);
                this.selectTalentPool(reserveTalentPoolIds);
                this.getView().sendFormAction(this.getView().getParentView());
            } else {
                this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u4eba\u624d\u5e93\u7684\"\u8f6c\u5e93\"\u6743\u9650\u3002", (String)"ReserveReListPlugin_5", (String)"tsc-tstpm-business", (Object[])new Object[0]));
                this.getView().sendFormAction(this.getView().getParentView());
            }
        }
    }

    private void selectTalentPool(List<Long> reserveTalentPoolIds) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("tstpm_talentpoolmgt");
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        listShowParameter.getOpenStyle().setInlineStyleCss(css);
        listShowParameter.setShowTitle(false);
        listShowParameter.setLookUp(true);
        listShowParameter.setMultiSelect(false);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setCustomParam("openFormSource", (Object)"1");
        listShowParameter.setFormId("tstpm_talenttreelistf7");
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u8f6c\u79fb\u4eba\u624d\u5e93", (String)"TALENTLIST_17", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "savetalent"));
        listShowParameter.setCustomParam("pageNumber", (Object)"tstpm_stdrsm");
        listShowParameter.setCustomParam("permissionItem", (Object)"1Y+/5TTR4HPX1");
        if (reserveTalentPoolIds != null) {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
            QFilter qFilter = new QFilter("id", "not in", reserveTalentPoolIds);
            qFilterList.add(qFilter);
            listShowParameter.getListFilterParameter().setQFilters(qFilterList);
        }
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (HRObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "savetalent": {
                this.transferTalentPool(returnData);
                break;
            }
        }
    }

    public void transferTalentPool(Object returnData) {
        ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
        ArrayList<Long> talentPoolIds = new ArrayList<Long>(listSelectedRows.size());
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            Long talentPoolId = (Long)listSelectedRow.getPrimaryKeyValue();
            talentPoolIds.add(talentPoolId);
        }
        String candidateIdsStr = this.getPageCache().get(TRANSFERCANDIDATEID);
        String oldTalentPoolIdsStr = this.getPageCache().get(TRANSFERTALENTPOOLID);
        if (HRStringUtils.isEmpty((String)candidateIdsStr) || HRStringUtils.isEmpty((String)oldTalentPoolIdsStr)) {
            return;
        }
        List candidateIds = TalentListFunService.stringToLongList((String)candidateIdsStr);
        List oldTalentPoolIds = TalentListFunService.stringToLongList((String)oldTalentPoolIdsStr);
        TalentListFunService.transferTalentPool((List)candidateIds, (List)oldTalentPoolIds, talentPoolIds, (IFormView)this.getView());
    }

    public void afterCreateNewData(EventObject eventObject) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.size() != 0) {
            Object stdIdObj = this.getView().getFormShowParameter().getCustomParam("id");
            Long stdId = stdIdObj == null ? null : Long.valueOf(Long.parseLong(stdIdObj.toString()));
            DynamicObject[] resDynObj = TalentListServiceHelper.getInstance().getReserveReListInfo(stdId);
            if (resDynObj.length == 0) {
                return;
            }
            this.getModel().deleteEntryData(KEY_ENTRY_ENTITY);
            this.getModel().batchCreateNewEntryRow(KEY_ENTRY_ENTITY, resDynObj.length);
            this.setResInfoEntity(resDynObj);
        }
    }

    public void afterBindData(EventObject event) {
        if (this.getView().getParentView() != null) {
            String dataStatus = (String)this.getView().getParentView().getFormShowParameter().getCustomParam("datastatus");
            if (StringUtils.equals((CharSequence)ResumeHisDataStatusEnum.BLACK_LIST.getStatus(), (CharSequence)dataStatus)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"operationcolumnap"});
            }
        }
    }

    private void setResInfoEntity(DynamicObject[] resDynObj) {
        for (int i = 0; i < resDynObj.length; ++i) {
            this.getModel().setValue("id", (Object)resDynObj[i].getLong("stdrsm.id"), i);
            this.getModel().setValue(KEY_RESERVETIME, resDynObj[i].get(KEY_RESERVETIME), i);
            this.getModel().setValue(KEY_TALENTPOOL, resDynObj[i].get(KEY_TALENTPOOL), i);
            this.getModel().setValue(KEY_TALENTPOOLNAME, resDynObj[i].get("talentpool.name"), i);
            this.getModel().setValue(KEY_RESERVEPER, resDynObj[i].get(KEY_RESERVEPER), i);
        }
    }
}

