/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.talentpool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.label.service.LabelDataHelper;
import kd.tsc.tsrbd.common.enums.LabelTagObjTypeEnum;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tsrbd.common.kdstring.TSCBaseKDString;
import kd.tsc.tsrbs.common.utils.GenerateFormShowParamUtils;
import kd.tsc.tstpm.business.domain.stdrsm.helper.ResumeAttentionHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.oprecord.TalentPoolOperateRecordService;
import kd.tsc.tstpm.business.domain.stdrsm.util.CandidateDetailPageHelper;
import kd.tsc.tstpm.business.domain.talentpool.entity.TalentPoolFallMessage;
import kd.tsc.tstpm.business.domain.talentpool.entity.TalentPoolPermEntity;
import kd.tsc.tstpm.business.domain.talentpool.helper.TalentPoolFunHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.CheckPermissionHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentListDaoHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentListFunService;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentListServiceHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtQFilterHelper;
import kd.tsc.tstpm.common.enums.stdrsm.MsgSceneEnum;
import kd.tsc.tstpm.common.enums.stdrsm.ResumeAttentionEnum;
import kd.tsc.tstpm.formplugin.web.talentpool.TalentPoolListPlugin;

public class TalentPoolListBtnPlugin
extends TalentPoolListPlugin {
    private static final String NOTBTNKEY = "<>";
    private static final int FULLNAMEMAXLENGTG = 40;
    private static final String CANDIDATEIDSWITHRIGHTS = "candidateidswithrights";
    private static final Integer MAX_SELECT_QUA = 3000;
    private static final Integer MAX_SELECT_SHARE = 100;

    @Override
    public void registerListener(EventObject eventObject) {
        Search searchListener = (Search)this.getControl("searchap");
        searchListener.addEnterListener((SearchEnterListener)this);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        long candidateId = (Long)billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        this.openStdRsmDetails(candidateId);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        args.setCancel(true);
        IListView listView = (IListView)this.getView();
        String candidateId = listView.getFocusRowPkId().toString();
        Long candiDateL = Long.parseLong(candidateId);
        switch (fieldName = args.getHyperLinkClickEvent().getFieldName()) {
            case "fullname": {
                long resumeId = Long.parseLong(candidateId);
                this.openStdRsmDetails(resumeId);
                break;
            }
            case "susphoto": {
                this.openSusPhotoDetails(candidateId);
                break;
            }
            case "positionnum": {
                this.showApplyPositionList(candidateId);
                break;
            }
            case "talentpoolnum": {
                this.showTalentPoolList(candidateId);
                break;
            }
            case "porphoto": {
                DynamicObject stdRsmDy = StandardResumeDataHelper.queryOne((Long)Long.valueOf(candidateId));
                Long sourceVid = stdRsmDy.getLong("sourcevid");
                LabelDataHelper.showAppRsmPortraitPage((IFormView)this.getView(), (Long)sourceVid, (Long)LabelTagObjTypeEnum.OUT_STDRSM.getId());
                break;
            }
        }
    }

    private void openStdRsmDetails(long candidateId) {
        String status = this.getView().getPageCache().get("OTHERS");
        DynamicObject[] stdRsmStatusData = TalentListDaoHelper.getInstance().getStdRsmStatusData(Long.valueOf(candidateId), status);
        if (stdRsmStatusData != null && stdRsmStatusData.length > 0) {
            if (CheckPermissionHelper.getInstance().isCurTalentAuth(candidateId) || ResumeHisDataStatusEnum.BLACK_LIST.getStatus().equals(stdRsmStatusData[0].getString("datastatus"))) {
                CloseCallBack closeCallBackSend = new CloseCallBack((IFormPlugin)this, "fullname");
                TalentListServiceHelper.getInstance().formShowCandidate(Long.valueOf(candidateId), this.getView(), closeCallBackSend);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u5019\u9009\u4eba\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"TalentPoolListBtnPlugin_0", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.showRefreshPageTips();
            return;
        }
    }

    private void openSusPhotoDetails(String candidateId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tstpm_suspected");
        showParameter.setCustomParam("id", (Object)candidateId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    public void itemClick(ItemClickEvent evt) {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection listSelectedRows = listView.getSelectedRows();
        ArrayList<Long> candidateIds = new ArrayList<Long>(listSelectedRows.size());
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            Long candidateId = (Long)listSelectedRow.getPrimaryKeyValue();
            candidateIds.add(candidateId);
        }
        this.handleOpButton(evt.getItemKey(), candidateIds);
        super.itemClick(evt);
    }

    private void handleOpButton(String key, List<Long> candidateIds) {
        switch (key) {
            case "savetalent": {
                if (candidateIds.size() <= 0) break;
                this.judgeIsEjectTips(key, candidateIds, "savetalent");
                break;
            }
            case "removetalent": {
                if (this.judgeIsSelectCandidate(candidateIds)) break;
                this.judgeIsEjectTips(key, candidateIds, "removetalent");
                break;
            }
            case "selectposition": {
                if (this.judgeIsSelectCandidate(candidateIds)) break;
                this.judgeIsEjectTips(key, candidateIds, "selectposition");
                break;
            }
            case "addlable": {
                if (candidateIds.size() <= 0) break;
                if (CheckPermissionHelper.getInstance().checkDelBlackPermission(candidateIds)) {
                    this.showRefreshPageTips();
                    break;
                }
                LabelDataHelper.showAddLabelPage((IFormPlugin)this, (IFormView)this.getView(), (List)StdRsmServiceHelper.getStdRsmSouId(candidateIds), (Long)LabelTagObjTypeEnum.OUT_STDRSM.getId(), (String)"list");
                break;
            }
            case "removetag": {
                if (this.judgeIsSelectCandidate(candidateIds)) break;
                if (CheckPermissionHelper.getInstance().checkDelBlackPermission(candidateIds)) {
                    this.showRefreshPageTips();
                    break;
                }
                LabelDataHelper.showRemoveLabelPage((IFormPlugin)this, (IFormView)this.getView(), (List)StdRsmServiceHelper.getStdRsmSouId(candidateIds), (Long)LabelTagObjTypeEnum.OUT_STDRSM.getId(), (String)"list");
                break;
            }
            case "tblrefresh": {
                this.refreshChildViews();
                this.getTreeListView().refreshTreeNode(this.getTreeModel().getCurrentNodeId().toString());
                break;
            }
            case "tblclose": {
                this.getView().close();
                break;
            }
            case "btn_sendntfc": {
                if (this.judgeIsSelectNumCandidate(candidateIds)) break;
                this.judgeIsEjectTips(key, candidateIds, "btn_sendntfc");
                break;
            }
            case "btn_invite": {
                if (this.judgeIsSelectNumCandidate(candidateIds)) break;
                this.judgeIsEjectTips(key, candidateIds, "btn_invite");
                break;
            }
            case "remattention": {
                if (this.judgeIsSelectCandidate(candidateIds)) break;
                this.getModel().getDataEntityType();
                ResumeAttentionHelper.remAttention(candidateIds, (String)ResumeAttentionEnum.getNumberByName((String)"tstpm_stdrsm"));
                this.getTreeListView().refreshTreeNode(this.getTreeModel().getCurrentNodeId().toString());
                break;
            }
            case "btn_invitedelivery": {
                if (this.judgeIsSelectNumCandidate(candidateIds)) break;
                this.judgeIsEjectTips(key, candidateIds, "btn_invitedelivery");
                break;
            }
            case "btn_share": {
                if (this.judgeSelectNumShareCandidate(candidateIds)) break;
                this.judgeIsEjectTips(key, candidateIds, "btn_share");
                break;
            }
        }
    }

    private boolean judgeIsSelectCandidate(List<Long> candidateIds) {
        if (candidateIds.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TALENTLIST_9", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean judgeIsSelectNumCandidate(List<Long> candidateIds) {
        if (candidateIds.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TALENTLIST_9", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (candidateIds.size() > MAX_SELECT_QUA) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u9009\u62e93000\u6761\u6570\u636e\u6267\u884c\u3002", (String)"TALENTLIST_21", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean judgeSelectNumShareCandidate(List<Long> candidateIds) {
        if (candidateIds.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TALENTLIST_9", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (candidateIds.size() > MAX_SELECT_SHARE) {
            this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6700\u591a\u53ef\u9009\u62e9%s\u6761\u6570\u636e\u6267\u884c\u3002", (String)"TALENTLIST_24", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]), MAX_SELECT_SHARE));
            return true;
        }
        return false;
    }

    private void judgeIsEjectTips(String key, List<Long> candidateIds, String btnNum) {
        String btnName;
        ArrayList messageEntityList = new ArrayList(candidateIds.size());
        String pageNumber = null;
        switch (btnNum) {
            case "savetalent": {
                pageNumber = "tstpm_stdrsm";
                btnName = ResManager.loadKDString((String)"\u50a8\u5907\u5230\u4eba\u624d\u5e93", (String)"TALENTLIST_12", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "removetalent": {
                pageNumber = "tstpm_stdrsm";
                btnName = ResManager.loadKDString((String)"\u79fb\u9664\u4eba\u624d\u5e93", (String)"TALENTLIST_13", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "selectposition": {
                btnName = ResManager.loadKDString((String)"\u63a8\u8350\u5230\u804c\u4f4d", (String)"TALENTLIST_14", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "btn_sendntfc": {
                btnName = ResManager.loadKDString((String)"\u53d1\u901a\u77e5", (String)"TALENTLIST_15", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "btn_invite": {
                btnName = ResManager.loadKDString((String)"\u9080\u8bf7\u66f4\u65b0\u7b80\u5386", (String)"TALENTLIST_16", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "btn_invitedelivery": {
                btnName = ResManager.loadKDString((String)"\u9080\u8bf7\u6295\u9012\u7b80\u5386", (String)"TALENTLIST_19", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "btn_share": {
                btnName = ResManager.loadKDString((String)"\u5206\u4eab\u5019\u9009\u4eba", (String)"TALENTLIST_20", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]);
                break;
            }
            default: {
                btnName = null;
            }
        }
        this.getView().getPageCache().put("key", key);
        String cacheString = SerializationUtils.serializeToBase64(candidateIds);
        this.getView().getPageCache().put("cacheString", cacheString);
        if (CheckPermissionHelper.getInstance().checkDelBlackPermission(candidateIds)) {
            this.showRefreshPageTips();
            return;
        }
        TalentListFunService.splicingPromptInfo(candidateIds, messageEntityList);
        TalentPoolFallMessage talentPoolFallMessage = CheckPermissionHelper.getInstance().checkPermission(candidateIds, btnName, btnNum, messageEntityList, pageNumber);
        List listWithoutDuplicates = talentPoolFallMessage.getCandidateIds();
        String cacheEffString = SerializationUtils.serializeToBase64((Object)listWithoutDuplicates);
        this.getView().getPageCache().put("cacheEffString", cacheEffString);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, btnNum + NOTBTNKEY);
        boolean flag = TalentListFunService.setEjectPromptInfo(candidateIds, (IFormView)this.getView(), (TalentPoolFallMessage)talentPoolFallMessage, (List)listWithoutDuplicates, (CloseCallBack)closeCallBack);
        if (flag) {
            switch (btnNum) {
                case "savetalent": 
                case "removetalent": {
                    this.selectTalentPool(key, listWithoutDuplicates);
                    break;
                }
                case "selectposition": {
                    this.selectPositions(listWithoutDuplicates);
                    break;
                }
                case "btn_sendntfc": {
                    CloseCallBack closeCallBackSend = new CloseCallBack((IFormPlugin)this, "btn_sendntfc");
                    CandidateDetailPageHelper.openSendMessagePage((IFormView)this.getView(), (MsgSceneEnum)MsgSceneEnum.SEND_NOTIFICATION, candidateIds, (CloseCallBack)closeCallBackSend);
                    break;
                }
                case "btn_invite": {
                    CloseCallBack closeCallBackUpdate = new CloseCallBack((IFormPlugin)this, "btn_invite");
                    CandidateDetailPageHelper.openSendMessagePage((IFormView)this.getView(), (MsgSceneEnum)MsgSceneEnum.INVITE_UPDATE_RESUME, candidateIds, (CloseCallBack)closeCallBackUpdate);
                    break;
                }
                case "btn_invitedelivery": {
                    CloseCallBack closeCallBackDelivery = new CloseCallBack((IFormPlugin)this, "btn_invitedelivery");
                    CandidateDetailPageHelper.openSendMessagePage((IFormView)this.getView(), (MsgSceneEnum)MsgSceneEnum.INVITE_DELIVERY_RESUME, candidateIds, (CloseCallBack)closeCallBackDelivery);
                    break;
                }
                case "btn_share": {
                    CloseCallBack closeCallBackShare = new CloseCallBack((IFormPlugin)this, "btn_invitedelivery");
                    CandidateDetailPageHelper.openSendMessagePage((IFormView)this.getView(), (MsgSceneEnum)MsgSceneEnum.SHARE_CANDIDATE, candidateIds, (CloseCallBack)closeCallBackShare);
                    break;
                }
            }
        }
    }

    private void getPageJurisData(List<Long> candidateIds, List<Long> listWithoutDuplicates) {
        String cacheString = this.getView().getPageCache().get("cacheString");
        String cacheEffString = this.getView().getPageCache().get("cacheEffString");
        candidateIds.addAll((Collection)SerializationUtils.deSerializeFromBase64((String)cacheString));
        listWithoutDuplicates.addAll((Collection)SerializationUtils.deSerializeFromBase64((String)cacheEffString));
    }

    private void selectTalentPool(String key, List<Long> listWithoutDuplicates) {
        this.getPageCache().put(CANDIDATEIDSWITHRIGHTS, listWithoutDuplicates.toString().replaceAll("\\[|\\]", ""));
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("tstpm_talentpoolmgt");
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        listShowParameter.getOpenStyle().setInlineStyleCss(css);
        listShowParameter.setShowTitle(false);
        listShowParameter.setLookUp(true);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setFormId("tstpm_talenttreelistf7");
        listShowParameter.setCustomParam("pageNumber", (Object)"tstpm_stdrsm");
        if (HRStringUtils.equals((String)key, (String)"savetalent")) {
            listShowParameter.setCustomParam("permissionItem", (Object)"1Y+/5TTR4HPX1");
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u50a8\u5907\u5230\u4eba\u624d\u5e93", (String)"TALENTLIST_12", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "savetalent"));
        } else {
            listShowParameter.setCustomParam("containLower", (Object)"0");
            listShowParameter.setCustomParam("permissionItem", (Object)"2/57Q834RUB41");
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u79fb\u9664\u4eba\u624d\u5e93", (String)"TALENTLIST_13", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
            List repeatIds = StandardResumeDataHelper.getMergeStdIds(listWithoutDuplicates);
            listWithoutDuplicates.addAll(repeatIds);
            Set talentPoolIds = TalentPoolFunHelper.queryTalentPoolIds(listWithoutDuplicates);
            QFilter qFilter = new QFilter("id", "in", (Object)talentPoolIds);
            listShowParameter.getListFilterParameter().setFilter(qFilter);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "removetalent"));
        }
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void selectPositions(List<Long> listWithoutDuplicates) {
        this.getPageCache().put(CANDIDATEIDSWITHRIGHTS, listWithoutDuplicates.toString().replaceAll("\\[|\\]", ""));
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("tssrm_position_add");
        listShowParameter.setFormId("bos_listf7");
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        listShowParameter.getOpenStyle().setInlineStyleCss(css);
        listShowParameter.setShowTitle(false);
        listShowParameter.setLookUp(true);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u62db\u8058\u804c\u4f4d", (String)"TALENTLIST_11", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
        QFilter statusFilter = new QFilter("positionstatus", "in", (Object)new String[]{"A", "C"});
        qFilterList.add(statusFilter);
        listShowParameter.getListFilterParameter().setQFilters(qFilterList);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectposition"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        String key = this.getView().getPageCache().get("key");
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "btn_invite": 
            case "btn_invitedelivery": 
            case "fullname": {
                this.getTreeListView().refreshTreeNode(this.getTreeModel().getCurrentNodeId().toString());
                break;
            }
        }
        ArrayList<Long> candidateIds = new ArrayList<Long>();
        ArrayList<Long> listWithoutDuplicates = new ArrayList<Long>();
        if (HRObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        switch (actionId) {
            case "savetalent": 
            case "removetalent": {
                this.operateReserveRecord(actionId, returnData);
                this.getTreeListView().refreshTreeNode(this.getTreeModel().getCurrentNodeId().toString());
                break;
            }
            case "selectposition": {
                this.recommend2Position(returnData);
                this.getTreeListView().refreshTreeNode(this.getTreeModel().getCurrentNodeId().toString());
                break;
            }
            case "tsrbd_addtag": 
            case "tsrbd_removetag": {
                LabelDataHelper.handleCloseCallBack((ClosedCallBackEvent)closedCallBackEvent, (IFormView)this.getView());
                this.refreshChildViews();
                break;
            }
            case "savetalent<>": {
                this.getPageJurisData(candidateIds, listWithoutDuplicates);
                this.selectTalentPool(key, listWithoutDuplicates);
                break;
            }
            case "removetalent<>": {
                this.getPageJurisData(candidateIds, listWithoutDuplicates);
                this.selectTalentPool(key, listWithoutDuplicates);
                break;
            }
            case "selectposition<>": {
                this.getPageJurisData(candidateIds, listWithoutDuplicates);
                this.selectPositions(listWithoutDuplicates);
                break;
            }
            case "btn_sendntfc<>": {
                this.getPageJurisData(candidateIds, listWithoutDuplicates);
                CloseCallBack closeCallBackSend = new CloseCallBack((IFormPlugin)this, "btn_sendntfc");
                CandidateDetailPageHelper.openSendMessagePage((IFormView)this.getView(), (MsgSceneEnum)MsgSceneEnum.SEND_NOTIFICATION, listWithoutDuplicates, (CloseCallBack)closeCallBackSend);
                break;
            }
            case "btn_invite<>": {
                this.getPageJurisData(candidateIds, listWithoutDuplicates);
                CloseCallBack closeCallBackUpdate = new CloseCallBack((IFormPlugin)this, "btn_invite");
                CandidateDetailPageHelper.openSendMessagePage((IFormView)this.getView(), (MsgSceneEnum)MsgSceneEnum.INVITE_UPDATE_RESUME, listWithoutDuplicates, (CloseCallBack)closeCallBackUpdate);
                break;
            }
            case "btn_invitedelivery<>": {
                this.getPageJurisData(candidateIds, listWithoutDuplicates);
                CloseCallBack closeCallBackDelivery = new CloseCallBack((IFormPlugin)this, "btn_invitedelivery");
                CandidateDetailPageHelper.openSendMessagePage((IFormView)this.getView(), (MsgSceneEnum)MsgSceneEnum.INVITE_DELIVERY_RESUME, listWithoutDuplicates, (CloseCallBack)closeCallBackDelivery);
                break;
            }
            case "btn_share<>": {
                this.getPageJurisData(candidateIds, listWithoutDuplicates);
                CloseCallBack closeCallBackShare = new CloseCallBack((IFormPlugin)this, "btn_share");
                CandidateDetailPageHelper.openSendMessagePage((IFormView)this.getView(), (MsgSceneEnum)MsgSceneEnum.SHARE_CANDIDATE, listWithoutDuplicates, (CloseCallBack)closeCallBackShare);
                break;
            }
        }
    }

    private void refreshChildViews() {
        String childPageStr = this.getView().getPageCache().get("childpages");
        if (HRStringUtils.isNotEmpty((String)childPageStr)) {
            Map childPages = (Map)SerializationUtils.fromJsonString((String)childPageStr, Map.class);
            for (String childPageId : childPages.values()) {
                IFormView view = this.getView().getView(childPageId);
                if (view == null) continue;
                view.invokeOperation("refresh");
                this.getView().sendFormAction(view);
            }
        }
    }

    private void operateReserveRecord(String actionId, Object returnData) {
        String candidateIdsWithRightsStr = this.getPageCache().get(CANDIDATEIDSWITHRIGHTS);
        if (HRStringUtils.isEmpty((String)candidateIdsWithRightsStr)) {
            return;
        }
        List candidateIds = TalentListFunService.stringToLongList((String)candidateIdsWithRightsStr);
        ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
        ArrayList<Long> talentPoolIds = new ArrayList<Long>(listSelectedRows.size());
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            Long talentPoolId = (Long)listSelectedRow.getPrimaryKeyValue();
            talentPoolIds.add(talentPoolId);
        }
        int totalCount = talentPoolIds.size() * candidateIds.size();
        boolean flag = TalentPoolMgtHelper.getInstance().isExists(TalentPoolMgtQFilterHelper.getQFilter(talentPoolIds, (String)"id"));
        switch (actionId) {
            case "savetalent": {
                if (!flag) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u50a8\u5907\u5931\u8d25\uff0c\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\u3002", (String)"TALENTLIST_22", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
                    return;
                }
                Object[] addReserveDtArrays = TalentListFunService.saveReserveRecord(talentPoolIds, (List)candidateIds);
                if (HRArrayUtils.isEmpty((Object[])addReserveDtArrays)) {
                    return;
                }
                OperationResult addOperationResult = SaveServiceHelper.saveOperate((String)"save", (String)"tstpm_reservere", (DynamicObject[])addReserveDtArrays, (OperateOption)OperateOption.create());
                StandardResumeDataHelper.updateStdRsmTalentPool((List)candidateIds);
                int errorCount = addOperationResult.getValidateResult().errorSize();
                if (totalCount > 1) {
                    if (errorCount > 0) {
                        this.showReserveRecordMessage((DynamicObject[])addReserveDtArrays, addOperationResult);
                    } else {
                        TalentListFunService.showPageNotification((IFormView)this.getView(), (boolean)true, (String)"savetalent");
                    }
                } else if (errorCount > 0) {
                    TalentListFunService.showPageNotification((IFormView)this.getView(), (boolean)false, (String)"savetalent");
                } else {
                    TalentListFunService.showPageNotification((IFormView)this.getView(), (boolean)true, (String)"savetalent");
                }
                StandardResumeDataHelper.updateModifyTime((List)candidateIds);
                ArrayList<Long> unClassifiedCTalentPools = new ArrayList<Long>(1);
                unClassifiedCTalentPools.add(1010L);
                TalentListFunService.removeReserveRecord(unClassifiedCTalentPools, (List)candidateIds);
                TalentPoolOperateRecordService.getInstance().reserveOpRecord((DynamicObject[])addReserveDtArrays, addOperationResult);
                break;
            }
            case "removetalent": {
                if (!flag) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u79fb\u9664\u5931\u8d25\uff0c\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\u3002", (String)"TALENTLIST_23", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
                    return;
                }
                TalentPoolPermEntity talentPoolPermEntity = CheckPermissionHelper.getInstance().hasOperateAuthForList(talentPoolIds, "2/57Q834RUB41");
                if (talentPoolPermEntity.isFlag()) {
                    ArrayList removeTalentPoolIds = new ArrayList(talentPoolPermEntity.getIdsWithPerm().size());
                    removeTalentPoolIds.addAll(talentPoolPermEntity.getIdsWithPerm());
                    TalentPoolOperateRecordService.getInstance().removeTalentPoolOp(candidateIds, TalentPoolOperateRecordService.getInstance().removePrePrivateTalPoo(removeTalentPoolIds));
                    DynamicObject[] reserveRecordDtArrays = TalentListFunService.removeReserveRecord((List)talentPoolPermEntity.getIdsWithPerm(), (List)candidateIds);
                    int successCount = reserveRecordDtArrays.length;
                    int errorCount = totalCount - successCount;
                    if (totalCount > 1) {
                        TalentListFunService.showPageNotification((IFormView)this.getView(), (boolean)true, (String)"removetalent");
                    } else if (errorCount > 0) {
                        TalentListFunService.showPageNotification((IFormView)this.getView(), (boolean)false, (String)"removetalent");
                    } else {
                        TalentListFunService.showPageNotification((IFormView)this.getView(), (boolean)true, (String)"removetalent");
                    }
                } else {
                    TalentListFunService.removeReserveRecord((List)talentPoolPermEntity.getIdsWithPerm(), (List)candidateIds);
                    int successCount = talentPoolPermEntity.getIdsWithPerm().size();
                    int errorCount = talentPoolPermEntity.getIdsWithoutPerm().size();
                    if (totalCount > 1) {
                        if (errorCount > 0) {
                            Map returnMap = TalentListFunService.showTalentPoolPermMessage((List)talentPoolPermEntity.getIdsWithoutPerm(), (int)listSelectedRows.size(), (int)successCount);
                            if (returnMap.isEmpty()) {
                                return;
                            }
                            FormShowParameter formShowParameter = GenerateFormShowParamUtils.generateBosOperationResultFormShowParam(returnMap.get("titleMsg"), returnMap.get("errorMsgTotal"), (boolean)false);
                            this.getView().showForm(formShowParameter);
                        } else {
                            TalentListFunService.showPageNotification((IFormView)this.getView(), (boolean)true, (String)"removetalent");
                        }
                    } else if (errorCount > 0) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u79fb\u9664\u4eba\u624d\u5e93\u201d\u7684\u6743\u9650\u3002", (String)"TALENTLIST_18", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
                    } else {
                        TalentListFunService.showPageNotification((IFormView)this.getView(), (boolean)true, (String)"removetalent");
                    }
                }
                List unClassifiedCandidateIds = TalentPoolFunHelper.queryCandidateReserve((List)candidateIds);
                if (CollectionUtils.isEmpty((Collection)unClassifiedCandidateIds)) break;
                TalentListFunService.saveCandidate2UnClassFy((List)unClassifiedCandidateIds);
                break;
            }
        }
    }

    private void showReserveRecordMessage(DynamicObject[] reserveDtArrays, OperationResult operationResult) {
        Map returnMap = TalentListFunService.showReserveRecordMessage((DynamicObject[])reserveDtArrays, (OperationResult)operationResult);
        if (returnMap.isEmpty()) {
            return;
        }
        FormShowParameter formShowParameter = GenerateFormShowParamUtils.generateBosOperationResultFormShowParam(returnMap.get("titleMsg"), returnMap.get("errorMsgTotal"), (boolean)false);
        this.getView().showForm(formShowParameter);
    }

    private void recommend2Position(Object returnData) {
        String candidateIdsWithRightsStr = this.getPageCache().get(CANDIDATEIDSWITHRIGHTS);
        if (HRStringUtils.isEmpty((String)candidateIdsWithRightsStr)) {
            return;
        }
        List candidateIds = TalentListFunService.stringToLongList((String)candidateIdsWithRightsStr);
        ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
        ArrayList<Long> positionIds = new ArrayList<Long>(listSelectedRows.size());
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            Long positionId = (Long)listSelectedRow.getPrimaryKeyValue();
            positionIds.add(positionId);
        }
        TalentPoolFallMessage talentPoolFallMessage = TalentListFunService.saveAppFile((List)candidateIds, positionIds);
        if (talentPoolFallMessage.getFlag()) {
            this.getView().showSuccessNotification(talentPoolFallMessage.getTitleMsg());
            return;
        }
        if (HRStringUtils.isEmpty((String)talentPoolFallMessage.getErrorMsgTotal())) {
            this.getView().showErrorNotification(talentPoolFallMessage.getTitleMsg());
        } else {
            FormShowParameter formShowParameter = GenerateFormShowParamUtils.generateBosOperationResultFormShowParam((Object)talentPoolFallMessage.getTitleMsg(), (Object)talentPoolFallMessage.getErrorMsgTotal(), (boolean)false);
            this.getView().showForm(formShowParameter);
        }
    }

    private void showApplyPositionList(String candidateId) {
        DynamicObject candidateDt = TalentPoolFunHelper.queryCandidateNumber((String)candidateId);
        if (HRObjectUtils.isEmpty((Object)candidateDt)) {
            return;
        }
        FormShowParameter listShowParameter = new FormShowParameter();
        listShowParameter.setFormId("tstpm_talentpositionlist");
        String fullName = candidateDt.getString("fullname");
        if (fullName.length() >= 40) {
            fullName = fullName.substring(0, 40);
        }
        listShowParameter.setCaption(fullName + "-" + ResManager.loadKDString((String)"\u5e94\u8058\u804c\u4f4d", (String)"TALENTLIST_7", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        listShowParameter.getOpenStyle().setInlineStyleCss(css);
        listShowParameter.setCustomParam("id", (Object)Long.valueOf(candidateId));
        this.getView().showForm(listShowParameter);
    }

    private void showTalentPoolList(String candidateId) {
        DynamicObject candidateDt = TalentPoolFunHelper.queryCandidateNumber((String)candidateId);
        if (HRObjectUtils.isEmpty((Object)candidateDt)) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tstpm_showreservecord");
        String fullName = candidateDt.getString("fullname");
        if (fullName.length() >= 40) {
            fullName = fullName.substring(0, 40);
        }
        showParameter.setCaption(fullName + "-" + ResManager.loadKDString((String)"\u50a8\u5907\u4eba\u624d\u5e93", (String)"TALENTLIST_8", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("id", (Object)candidateId);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        this.getView().showForm(showParameter);
    }

    private void showRefreshPageTips() {
        this.getView().showErrorNotification(TSCBaseKDString.dataChangedTip());
    }
}

