/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.talentpool;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.tsc.tsrbd.business.domain.label.service.LabelDataHelper;
import kd.tsc.tsrbd.common.enums.LabelTagObjTypeEnum;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsrbs.common.utils.TscTreeUtils;
import kd.tsc.tstpm.business.domain.stdrsm.helper.ResumeAttentionHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.SimilarServiceHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.CheckPermissionHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentListDaoHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentListFilterServiceHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentListServiceHelper;
import kd.tsc.tstpm.common.enums.stdrsm.ResumeAttentionEnum;
import kd.tsc.tstpm.common.utils.TalentPoolDeseUtil;

public class TalentPoolListPlugin
extends AbstractTreeListPlugin {
    private static final Log logger = LogFactory.getLog(SimilarServiceHelper.class);
    private static final String CUSTOM_STYLE = "eyJ0eXBlIjowLCJjb250ZW50IjoiwqAvKiogXG4qIOagt+S+i1xuKiDmlK/mjIHljp/nlJ9jc3PmoLflvI/lhpnms5Vcbiog5b2T5YmN5YWD57Sg55qEY2xhc3NOYW1l5L2/55SoIFwiJFwiIOS7o+abv++8jOS4jeaUr+aMgeiHquWumuS5ieWFg+e0oGNsYXNzTmFtZVxuKiDnm67liY3mj5DkvpvkuInkuKrmoLfmnb/vvIzmiZPlvIDms6jph4rljbPlj6/kvb/nlKhcbiog5rOo6YeK5YaF5a655Lya6KKr6L+H5ruk5LiN5bGV56S6XG4qIOWmgumcgOS9v+eUqOW5s+WPsOS4u+mimOiJsu+8jOWPr+S7peS9v+eUqCd0aGVtZUNvbG9yJ+adpeS7o+aMh1xuICovXG4vKipcbiog5b2T5YmN5YWD57Sg6IOM5pmv6aKc6Imy6Lef6ZqP5Li76aKY6ImyXG4qL1xuLyoqXG4kIHtcbsKgwqBiYWNrZ3JvdW5kOid0aGVtZUNvbG9yJztcbsKgfVxuKi9cbsKgLyoqXG4qIOS/ruaUueW9k+WJjeWFg+e0oOiDjOaZr+minOiJslxuKi9cbi8qKlxuJCB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG7CoC8qKlxuKiDkv67mlLnlvZPliY3lhYPntKBob3ZlcuaViOaenFxuwqAgKi9cbi8qKlxuJDpob3ZlciB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG4vKipcbiAqIOS/ruaUueW9k+WJjeWFg+e0oOS4umRpduagh+etvuWtkOWFg+e0oFxuKi9cbi8qKlxuJCA+IGRpdiB7XG7CoGJhY2tncm91bmQ6cmVkO1xuwqB9XG4gKi9cbltjb2wtaWQ9J21lcmdlbGlzdGNvbHVtbmFwJ10gLkNlbGxDbGFzc19jb21iaW5lZEZpZWxkX3JlbmRlcl8yWGxxIC5DZWxsQ2xhc3NfY29tYmluZWRJdGVtXzIxVWkge1xub3ZlcmZsb3c6aGlkZGVuO1xuZmxleC1ncm93OiAwO1xufVxuW2NvbC1pZD0nbWVyZ2VsaXN0Y29sdW1uYXAnXSAuQ2VsbENsYXNzX2NvbWJpbmVkRmllbGRfcmVuZGVyXzJYbHEgLkNlbGxDbGFzc19jb21iaW5lZEl0ZW1fMjFVaTpudGgtY2hpbGQoMiksXG5bY29sLWlkPSdtZXJnZWxpc3Rjb2x1bW5hcCddIC5DZWxsQ2xhc3NfY29tYmluZWRGaWVsZF9yZW5kZXJfMlhscSAuQ2VsbENsYXNzX2NvbWJpbmVkSXRlbV8yMVVpOm50aC1jaGlsZCgzKSAge1xuZmxleC1zaHJpbms6IDA7XG5mbGV4LWdyb3c6IDA7XG59XG5bY29sLWlkPSdtZXJnZWxpc3Rjb2x1bW5hcCddIC5DZWxsQ2xhc3NfY29tYmluZWRGaWVsZF9yZW5kZXJfMlhscSAuQ2VsbENsYXNzX2NvbWJpbmVkSXRlbV8yMVVpOm50aC1jaGlsZCgyKSBpbWd7XG53aWR0aDogMTJweDtcbmhlaWdodDogMTJweDtcbm1hcmdpbi1yaWdodDogLTFweDtcbn0ifQ==";
    private static final String NOTBTNKEY = "<>";
    private List<String> blackListFlag = Arrays.asList("mergelistcolumnap", "phone", "email", "gender", "addsource", "blatime", "blareason");

    public void registerListener(EventObject eventObject) {
        this.addClickListeners(new String[]{"filtercontainerap"});
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        HashMap<String, String> ctrl = new HashMap<String, String>(1);
        ctrl.put("cstyles", CUSTOM_STYLE);
        this.getView().updateControlMetadata("splitpanelap1", ctrl);
        Object currentNodeId = this.getTreeModel().getCurrentNodeId();
        logger.info("TalentPoolListPlugin.createTalentTree.CurrentNodeId {}}", currentNodeId);
        this.getTreeModel().setCurrentNodeId((Object)"1");
        Object currentNodeIdSet = this.getTreeModel().getCurrentNodeId();
        logger.info("TalentPoolListPlugin.createTalentTree.CurrentNodeId {}}", currentNodeIdSet);
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
        TreeListModel treeListModel = (TreeListModel)this.treeListView.getTreeModel();
        treeListModel.setGobackToRoot(false);
    }

    public void preOpenForm(PreOpenFormEventArgs preOpenFormEventArgs) {
        super.preOpenForm(preOpenFormEventArgs);
        if (!CheckPermissionHelper.getInstance().checkTstpmPermission()) {
            preOpenFormEventArgs.setCancel(true);
        }
        ListShowParameter parameter = (ListShowParameter)preOpenFormEventArgs.getSource();
        parameter.setFormId("tstpm_talenttemtreelist");
    }

    public void initializeTree(EventObject eventObject) {
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        logger.info("TalentPoolListPlugin.createTalentTree.starttime {}}", (Object)System.currentTimeMillis());
        this.createTalentTree(treeView);
        logger.info("TalentPoolListPlugin.createTalentTree.endtime {}}", (Object)System.currentTimeMillis());
        RequestContext requestContext = RequestContext.get();
        logger.info("TalentPoolListPlugin.requestContext.getCurrUserId {}}", (Object)requestContext.getCurrUserId());
        logger.info("TalentPoolListPlugin.requestContext.getAccountId {}}", (Object)requestContext.getAccountId());
        logger.info("TalentPoolListPlugin.requestContext.getTenantId {}}", (Object)requestContext.getTenantId());
        logger.info("TalentPoolListPlugin.requestContext.getOrgId {}}", (Object)requestContext.getOrgId());
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        CommonFilterColumn labelColumn = (CommonFilterColumn)args.getFilterColumn("lableinfo.name");
        List commonFilterColumns = args.getCommonFilterColumns();
        if (commonFilterColumns.size() > 0) {
            commonFilterColumns.remove(labelColumn);
        }
        CommonFilterColumn labColumn = TalentListFilterServiceHelper.getInstance().addLabelFilterColumn(labelColumn);
        args.addFilterColumn((FilterColumn)labColumn);
        super.filterContainerInit(args);
        this.setHomePageJumpParam(args);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        if ("lableinfo.id".equals(args.getFieldName()) || "lableinfo.name".equals(args.getFieldName())) {
            ArrayList<Long> tagObjTypeIds = new ArrayList<Long>(1);
            tagObjTypeIds.add(LabelTagObjTypeEnum.OUT_STDRSM.getId());
            QFilter labelQFilter = LabelDataHelper.getLabelQfilter(tagObjTypeIds);
            args.addCustomQFilter(labelQFilter);
        }
        super.filterContainerBeforeF7Select(args);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new BillListDataProvider());
        super.beforeCreateListDataProvider(args);
        this.setListDataBlackListFlag();
    }

    public void search(SearchEnterEvent event) {
        super.search(event);
        String searchText = event.getText();
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        ITreeListView treeListView = this.getTreeListView();
        TscTreeUtils.searchTalentTree((String)searchText, (IFormView)view, (IPageCache)pageCache, (ITreeListView)treeListView);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent buildTreeListFilterEvent) {
        super.buildTreeListFilter(buildTreeListFilterEvent);
        String talentPoolId = (String)buildTreeListFilterEvent.getNodeId();
        this.treeListView.getTreeModel().getGroupProp();
        if ("1".equals(talentPoolId)) {
            this.getView().getPageCache().put("OTHERS", ResumeHisDataStatusEnum.EFFECTING.getStatus());
            this.setBtnVisible(true);
        } else if ("2".equals(talentPoolId)) {
            this.getView().getPageCache().put("OTHERS", ResumeHisDataStatusEnum.EFFECTING.getStatus());
            List retList = ResumeAttentionHelper.getMyAttention((String)ResumeAttentionEnum.getNumberByName((String)"tstpm_stdrsm"));
            List idLists = StandardResumeDataHelper.getMainStdIds((List)retList);
            QFilter treeFilter = new QFilter("id", "in", (Object)idLists);
            buildTreeListFilterEvent.addQFilter(treeFilter);
            this.setBtnVisible(false);
        } else if ("3".equals(talentPoolId)) {
            this.getView().getPageCache().put("OTHERS", ResumeHisDataStatusEnum.BLACK_LIST.getStatus());
            this.setBlackListBtnVisible(false);
        } else {
            DynamicObject[] dynObjAllChild;
            this.getView().getPageCache().put("OTHERS", ResumeHisDataStatusEnum.EFFECTING.getStatus());
            DynamicObject dynObj = TalentListDaoHelper.getInstance().getTalentPool(talentPoolId);
            if (dynObj == null || dynObj.get("number") == null) {
                return;
            }
            long creator = -9999999999L;
            if (dynObj.getDynamicObject("creator") != null) {
                creator = dynObj.getDynamicObject("creator").getLong("id");
            }
            if ((dynObjAllChild = TalentListDaoHelper.getInstance().getSubTalentPool(talentPoolId, dynObj, Long.valueOf(creator))) == null) {
                return;
            }
            ArrayList childIdList = Lists.newArrayListWithCapacity((int)dynObjAllChild.length);
            for (DynamicObject dynamicObject : dynObjAllChild) {
                childIdList.add(dynamicObject.getLong("id"));
            }
            DynamicObject[] dynamicObjects = TalentListDaoHelper.getInstance().getStdReserve((List)childIdList);
            ArrayList idList = Lists.newArrayListWithCapacity((int)dynamicObjects.length);
            for (DynamicObject dy : dynamicObjects) {
                if (dy.getDynamicObject("stdrsm") == null) continue;
                long id = dy.getDynamicObject("stdrsm").getLong("id");
                idList.add(id);
            }
            List idLists = StandardResumeDataHelper.getMainStdIds((List)idList);
            QFilter treeFilter = new QFilter("id", "in", (Object)idLists);
            buildTreeListFilterEvent.addQFilter(treeFilter);
            this.setBtnVisible(true);
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        List oldFilters = setFilterEvent.getQFilters();
        logger.info("TalentPoolListPlugin.setFilter.oldFilters {}}", (Object)oldFilters);
        ArrayList<QFilter> oldFilterNotNulls = new ArrayList<QFilter>();
        for (QFilter qFilter : oldFilters) {
            if (qFilter == null) continue;
            oldFilterNotNulls.add(qFilter);
        }
        String status = this.getView().getPageCache().get("OTHERS");
        if (ResumeHisDataStatusEnum.BLACK_LIST.getStatus().equals(status)) {
            setFilterEvent.setMainOrgQFilter(new QFilter("datastatus", "=", (Object)ResumeHisDataStatusEnum.BLACK_LIST.getStatus()));
            setFilterEvent.setOrderBy("blatime desc");
            QFilter dataRangeFilter = null;
            for (QFilter qFilter : oldFilterNotNulls) {
                if (!"datarange".equals(qFilter.getProperty())) continue;
                dataRangeFilter = qFilter;
            }
            oldFilterNotNulls.remove(dataRangeFilter);
            setFilterEvent.getQFilters().remove(dataRangeFilter);
        } else {
            setFilterEvent.setMainOrgQFilter(new QFilter("datastatus", "!=", (Object)ResumeHisDataStatusEnum.BLACK_LIST.getStatus()));
            setFilterEvent.setOrderBy("modifytime desc");
        }
        HashMap map = new HashMap(16);
        int filterSize = oldFilterNotNulls.size();
        logger.info("TalentPoolListPlugin.setFilter.oldFiltersAfter {}}", oldFilterNotNulls);
        logger.info("TalentPoolListPlugin.setFilter.starttime {}}", (Object)System.currentTimeMillis());
        for (int i = 0; i < filterSize; ++i) {
            String property = ((QFilter)oldFilterNotNulls.get(i)).getProperty();
            TalentListFilterServiceHelper.getInstance().handlePageFilter(oldFilterNotNulls, i, map, property);
        }
        for (Map.Entry entry : map.entrySet()) {
            setFilterEvent.getQFilters().remove(entry.getKey());
            QFilter newFilter = (QFilter)entry.getValue();
            setFilterEvent.getQFilters().add(newFilter);
        }
        logger.info("TalentPoolListPlugin.setFilter.endtime {}}", (Object)System.currentTimeMillis());
        super.setFilter(setFilterEvent);
        setFilterEvent.getQFilters().add(new QFilter("tpsys", "=", (Object)Character.valueOf(' ')));
    }

    private void setHomePageJumpParam(FilterContainerInitArgs args) {
        ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (parameter.isLookUp()) {
            return;
        }
        Map map = parameter.getCustomParams();
        if (map != null && map.size() > 0) {
            Object search = map.get("combofield");
            if (search == null) {
                return;
            }
            List fastFilterColumns = args.getFastFilterColumns();
            int index = Integer.parseInt(search.toString());
            ((FilterColumn)fastFilterColumns.get(index)).setDefaultValues(new Object[]{map.get("searchtext")});
        }
    }

    private void createTalentTree(TreeView treeView) {
        TreeNode root = TalentListServiceHelper.getInstance().createTalentTree();
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setRootVisable(false);
        treeView.addNode(root);
        treeView.focusNode((TreeNode)root.getChildren().get(0));
        this.getPageCache().put(treeView.getKey(), SerializationUtils.toJsonString((Object)root));
        this.getTreeModel().setCurrentNodeId((Object)"1");
        logger.info("TalentPoolListPlugin.createTalentTree.CurrentNodeId {}}", (Object)((TreeNode)root.getChildren().get(0)).getId());
    }

    private void setListDataBlackListFlag() {
        BillList billList = (BillList)this.getControl("billlistap");
        List listFieldsControlColumns = billList.getListFieldsControlColumns();
        String status = this.getView().getPageCache().get("OTHERS");
        if (ResumeHisDataStatusEnum.BLACK_LIST.getStatus().equals(status)) {
            for (Map column : listFieldsControlColumns) {
                if (this.blackListFlag.contains(column.get("listFieldKey"))) {
                    column.put("visible", 11);
                    continue;
                }
                column.put("visible", 10);
            }
        }
    }

    private void setBtnVisible(boolean flag) {
        this.getView().setVisible(Boolean.valueOf(flag), new String[]{"savetalent", "selectposition", "addlable", "btn_invitedelivery", "btn_sendntfc", "btn_invite", "btn_share"});
        this.getView().setVisible(Boolean.valueOf(!flag), new String[]{"remattention"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"filtergridview", "schemefilterview"});
    }

    private void setBlackListBtnVisible(boolean flag) {
        this.getView().setVisible(Boolean.valueOf(flag), new String[]{"savetalent", "selectposition", "addlable", "btn_invitedelivery", "btn_sendntfc", "btn_invite", "btn_share", "remattention"});
        this.getView().setVisible(Boolean.valueOf(!flag), new String[]{"tblclose"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"filtergridview", "schemefilterview"});
    }

    static class BillListDataProvider
    extends ListDataProvider {
        BillListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            logger.info("TalentPoolListPlugin.dynObjGetData.starttime {}}", (Object)System.currentTimeMillis());
            DynamicObjectCollection coll = super.getData(start, limit);
            logger.info("TalentPoolListPlugin.dynObjGetData.endtime {}}", (Object)System.currentTimeMillis());
            if (coll == null) {
                return new DynamicObjectCollection();
            }
            int collSize = coll.size();
            ArrayList<Long> list = new ArrayList<Long>(collSize);
            ArrayList<Long> desList = new ArrayList<Long>(collSize);
            for (DynamicObject dynamicObject : coll) {
                list.add(dynamicObject.getLong("id"));
                desList.add(dynamicObject.getLong("id"));
            }
            if (list.size() < 1) {
                return coll;
            }
            logger.info("TalentPoolListPlugin.setDeseField.starttime {}}", (Object)System.currentTimeMillis());
            this.setDesField(coll, desList);
            logger.info("TalentPoolListPlugin.setDeseField.endtime {}}", (Object)System.currentTimeMillis());
            logger.info("TalentPoolListPlugin.setSusPicture.starttime {}}", (Object)System.currentTimeMillis());
            this.setSusPicture(coll, list);
            logger.info("TalentPoolListPlugin.setSusPicture.endtime {}}", (Object)System.currentTimeMillis());
            logger.info("TalentPoolListPlugin.setSusPicture.starttime {}}", (Object)System.currentTimeMillis());
            this.setRecruitStatus(coll);
            logger.info("TalentPoolListPlugin.setSusPicture.endtime {}}", (Object)System.currentTimeMillis());
            logger.info("TalentPoolListPlugin.setWorkYear.starttime {}}", (Object)System.currentTimeMillis());
            this.setWorkYear(coll);
            logger.info("TalentPoolListPlugin.setWorkYear.endtime {}}", (Object)System.currentTimeMillis());
            this.setAttPicture(coll, list);
            return coll;
        }

        private void setDesField(DynamicObjectCollection coll, List<Long> list) {
            List seeCandidateIds = CheckPermissionHelper.getInstance().getCurTalentAuth(TalentPoolListPlugin.NOTBTNKEY, list, "tstpm_stdrsm");
            List blackListStdRsmIds = StdRsmServiceHelper.getBlackListStdRsmId(list);
            list.removeAll(seeCandidateIds);
            list.removeAll(blackListStdRsmIds);
            coll.stream().forEach(collect -> {
                Long stdId = collect.getLong("id");
                if (list.contains(stdId)) {
                    collect.set("fullname", (Object)TalentPoolDeseUtil.replacePartName(collect.get("fullname") == null ? null : collect.get("fullname").toString()));
                    collect.set("phone", (Object)TalentPoolDeseUtil.replacePhoneX(collect.get("phone") == null ? null : collect.get("phone").toString()));
                    collect.set("email", (Object)TalentPoolDeseUtil.replaceEmailX(collect.get("email") == null ? null : collect.get("email").toString()));
                }
            });
        }

        private void setSusPicture(DynamicObjectCollection coll, List<Long> list) {
            Set similarList = SimilarServiceHelper.querySimilarList(list);
            coll.forEach(dy -> {
                long mid = dy.getLong("id");
                if (similarList.contains(mid)) {
                    dy.set("susphoto", (Object)"1");
                }
            });
        }

        private void setRecruitStatus(DynamicObjectCollection coll) {
            DynamicObject recStgDynObj = new DynamicObject(new DynamicObjectType("tsrbd_recrustgnew"));
            DynamicObject recStatDynObj = new DynamicObject(new DynamicObjectType("tsrbd_recrustatnew"));
            coll.forEach(dy -> {
                if (dy.getDynamicObject("recrustg") != null && dy.getDynamicObject("recrustat") != null) {
                    dy.set("recstatus", (Object)"-");
                } else {
                    dy.set("recrustg", (Object)recStgDynObj);
                    dy.set("recrustat", (Object)recStatDynObj);
                }
            });
        }

        private void setAttPicture(DynamicObjectCollection coll, List<Long> list) {
            Map idMap = ResumeAttentionHelper.queryAttentionList(list, (String)ResumeAttentionEnum.getNumberByName((String)"tstpm_stdrsm"));
            int collSize = coll.size();
            for (int i = 0; i < collSize; ++i) {
                ((DynamicObject)coll.get(i)).set("porphoto", (Object)"1");
                if (idMap.size() < 1 || ((DynamicObject)coll.get(i)).get("id") == null) {
                    ((DynamicObject)coll.get(i)).set("attention", null);
                    continue;
                }
                if (idMap.get(((DynamicObject)coll.get(i)).getLong("id")) == null) continue;
                ((DynamicObject)coll.get(i)).set("attention", (Object)"1");
            }
        }

        private void setWorkYear(DynamicObjectCollection coll) {
            int collSize = coll.size();
            for (int i = 0; i < collSize; ++i) {
                if (((DynamicObject)coll.get(i)).get("workingyears") == null) continue;
                ((DynamicObject)coll.get(i)).set("workingyear", (Object)ResumeAnalysisHelper.getWorkYearShow((int)((DynamicObject)coll.get(i)).getInt("workingyears")));
            }
        }
    }
}

