/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.talentpool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListColumn;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtEnum;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtF7Helper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtPermHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtPubHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtQFilterHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtTreeHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentSharHelper;
import kd.tsc.tstpm.common.talentpool.TPMTreeDto;
import kd.tsc.tstpm.formplugin.web.talentpool.talentpoolmgt.TalentPoolMgtBaseListPlugin;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class TalentPoolMgF7ListPlugin
extends AbstractTreeListPlugin {
    private static final Log LOGGER = LogFactory.getLog(TalentPoolMgF7ListPlugin.class);
    private Pair<Boolean, List<Long>> permOrgResult = null;
    private final TPMTreeDto treeDto = new TPMTreeDto();

    private void checkHasPermOrgResult() {
        if (this.permOrgResult == null) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String containLower = (String)formShowParameter.getCustomParam("containLower");
            this.treeDto.setContainLower(!HRStringUtils.equals((String)containLower, (String)"0"));
            this.treeDto.setPageNumber((String)formShowParameter.getCustomParam("pageNumber"));
            this.treeDto.setAppId((String)formShowParameter.getCustomParam("appID"));
            this.treeDto.setPermissionItem((String)formShowParameter.getCustomParam("permissionItem"));
            this.permOrgResult = TalentPoolMgtPermHelper.getAllPermOrg((String)this.treeDto.getAppId(), (String)this.treeDto.getPageNumber(), (String)this.treeDto.getPermissionItem());
        }
    }

    public void initializeTree(EventObject evt) {
        this.checkHasPermOrgResult();
        this.initRootTreeNode();
    }

    private void initRootTreeNode() {
        TreeNode root = TalentPoolMgtTreeHelper.createRoot();
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)"0");
    }

    public void refreshNode(RefreshNodeEvent e) {
        TreeNode root = this.getTreeModel().getRoot();
        String currNodeId = (String)e.getNodeId();
        TreeNode currNode = root.getTreeNode(currNodeId, 20);
        this.checkHasPermOrgResult();
        TalentPoolMgtBaseListPlugin.defaultRefreshNode(e, root, currNodeId, currNode, this.treeDto);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (HRStringUtils.equals((String)e.getProperty().getName(), (String)"iscontainlower1")) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
        TalentPoolMgtBaseListPlugin.buildTreeListFilter(e);
    }

    public void setFilter(SetFilterEvent e) {
        this.checkHasPermOrgResult();
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        String pageParam = TalentPoolMgtHelper.getInstance().getPageParam(this.getView());
        qFilter.and(TalentPoolMgtQFilterHelper.getRecrutypQFilter((String)pageParam, (boolean)false));
        String nodeId = this.getTreeModel().getCurrentNodeId().toString();
        if (StringUtils.equals((CharSequence)"0", (CharSequence)nodeId)) {
            List allTalentPoolList = TalentPoolMgtF7Helper.getAllTalentPoolList(this.permOrgResult);
            qFilter.and(TalentPoolMgtQFilterHelper.getQFilter((List)allTalentPoolList, (String)"id"));
            e.setOrderBy("pooltype asc,level asc ,modifytime desc");
        } else {
            boolean isContainLower;
            e.setOrderBy("level asc ,modifytime desc");
            DynamicObject[] dynamicObject = TalentPoolMgtHelper.getDynamicObjects((Long)Long.valueOf(nodeId));
            if (dynamicObject.length == 0) {
                this.getView().showTipNotification(TalentPoolMgtEnum.TPM_23.getValue());
                return;
            }
            String longNumber = dynamicObject[0].getString("longnumber");
            if (longNumber.contains("1020")) {
                qFilter.and(TalentPoolMgtF7Helper.getDefaultPubFilter((List)((List)this.permOrgResult.getRight())));
            } else if (longNumber.contains("1030")) {
                qFilter.and(TalentPoolMgtQFilterHelper.privateTalentPoolQFilter());
            } else if (longNumber.contains("1040")) {
                QFilter sharQFilter = TalentPoolMgtQFilterHelper.sharTalentPoolQFilter();
                DynamicObject[] sharPoolObj = TalentSharHelper.querySharPool(null, (QFilter)sharQFilter, null);
                ArrayList<Long> sharList = new ArrayList<Long>(sharPoolObj.length);
                for (DynamicObject shar : sharPoolObj) {
                    sharList.add(shar.getLong("talentpool.id"));
                }
                qFilter.and(TalentPoolMgtQFilterHelper.getQFilter(sharList, (String)"id"));
            }
            if (this.treeDto.isContainLower() && !StringUtils.equals((CharSequence)"1040", (CharSequence)nodeId) && !(isContainLower = ((Boolean)this.getModel().getValue("iscontainlower1")).booleanValue())) {
                long level = dynamicObject[0].getLong("level");
                qFilter.and(TalentPoolMgtQFilterHelper.getQFilter(Arrays.asList(level, level + 1L), (String)"level"));
            }
        }
        e.setCustomQFilters(Collections.singletonList(qFilter));
        LOGGER.info("TalentPoolManagementListPlugin.setFilter.CustomQFilters : {}", (Object)SerializationUtils.toJsonString((Object)e.getCustomQFilters()));
    }

    public void packageData(PackageDataEvent e) {
        TalentSharHelper.getInstance().packageSharData(e);
    }

    public void afterBindData(EventObject e) {
        this.checkHasPermOrgResult();
        String currentNodeId = String.valueOf(this.getTreeModel().getCurrentNodeId());
        this.getView().setVisible(Boolean.valueOf(this.treeDto.isContainLower() && !StringUtils.equals((CharSequence)currentNodeId, (CharSequence)"0")), new String[]{"iscontainlower1"});
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        if (TalentPoolMgtPermHelper.querySecurityConf()) {
            List listColumns = args.getListColumns();
            ListColumn secLevel = TalentPoolMgtPubHelper.createListColumn((String)"seclevel.codelevel", (String)TalentPoolMgtEnum.TPM_25.getValue(), (int)1);
            listColumns.add(listColumns.size() - 3, secLevel);
        }
    }
}

