/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.talentpool.talentpoolhome;

import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtEnum;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtF7Helper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtPermHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ChannelSourceCardPlugin
extends AbstractFormPlugin
implements ClickListener,
ListboxClickListener {
    private DataSet dataSet = null;
    private static final Log LOGGER = LogFactory.getLog(ChannelSourceCardPlugin.class);
    private TalentPoolMgtHelper talentPoolMgtHelper = TalentPoolMgtHelper.getInstance();
    private final QFilter defaultFilter = new QFilter("enable", "=", (Object)"1");
    private Pair<Boolean, List<Long>> hasPermOrgResult = null;

    public void registerListener(EventObject event) {
        Listbox box = (Listbox)this.getView().getControl("listboxap");
        box.addListboxClickListener((ListboxClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultDate();
        this.getPageCache().put("appmthd", "btn_all");
        Listbox box = (Listbox)this.getView().getControl("listboxap");
        ArrayList<ListboxItem> itemList = new ArrayList<ListboxItem>();
        itemList.add(this.getDefaultBoxItem());
        this.checkDataSet();
        itemList.addAll(this.getListBoxItemByDataSet(this.dataSet));
        box.addItems(itemList);
        this.drawChart();
    }

    public ListboxItem getDefaultBoxItem() {
        return new ListboxItem("btn_all", TalentPoolMgtEnum.TPM_21.getValue());
    }

    public List<ListboxItem> getListBoxItemByDataSet(DataSet dataSet) {
        ArrayList<ListboxItem> itemList = new ArrayList<ListboxItem>();
        if (dataSet != null) {
            GroupbyDataSet groupbyDataSet = dataSet.copy().groupBy(new String[]{"appmthdId", "appmthdName"});
            try (DataSet finish = groupbyDataSet.count().finish().orderBy(new String[]{"appmthdId asc"});){
                for (Row row : finish) {
                    ListboxItem listboxItem = new ListboxItem("btn_" + row.getLong("appmthdId"), this.getLoadKDString(row.getString("appmthdName"), "\u672a\u77e5", "ChannelSourceCardPlugin_0"));
                    itemList.add(listboxItem);
                }
            }
        }
        return itemList;
    }

    public List<Long> allTalentPoolList(Pair<Boolean, List<Long>> hasPermOrgResult) {
        if (((List)hasPermOrgResult.getRight()).isEmpty()) {
            return Collections.singletonList(-1L);
        }
        List allTalentPoolList = TalentPoolMgtF7Helper.getAllTalentPoolList(hasPermOrgResult);
        allTalentPoolList.add(1010L);
        return allTalentPoolList;
    }

    public StringBuilder getStringBuilder(Pair<Boolean, List<Long>> hasPermOrgResult) {
        StringBuilder stringBuilder = new StringBuilder("SELECT M.FID id,\n");
        stringBuilder.append("       M.FAPPLYTIME applytime,\n");
        stringBuilder.append("       R.FID    recruchnlnmId,\n");
        stringBuilder.append("       R.FNAME  recruchnlnmName,\n");
        stringBuilder.append("       P.FID    appmthdId,\n");
        stringBuilder.append("       P.FNAME  appmthdName\n");
        stringBuilder.append("  FROM T_TSTPM_RDELIVERY M\n");
        stringBuilder.append(" INNER JOIN (SELECT E.FSTDRSMID, MIN(E.FDELIVERYID) FDELIVERYID\n");
        stringBuilder.append("               FROM T_TSTPM_RSM E\n");
        stringBuilder.append("               INNER JOIN (SELECT  FID\n");
        stringBuilder.append("                              FROM T_TSTPM_STDRSM_A S\n");
        stringBuilder.append("                              INNER JOIN (SELECT DISTINCT A.FSTDRSMID\n");
        stringBuilder.append("                                              FROM T_TSTPM_RESERVERE A\n");
        stringBuilder.append("                                              INNER JOIN (SELECT FID\n");
        stringBuilder.append("                                                   FROM T_TSTPM_TALENTPOOLMGT\n");
        stringBuilder.append("                          WHERE FID  IN (");
        for (Long talentPool : this.allTalentPoolList(hasPermOrgResult)) {
            stringBuilder.append(talentPool);
            stringBuilder.append(',');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append("                                         )");
        stringBuilder.append("                                                   ) B\n");
        stringBuilder.append("                                         ON A.FTALPOOLID = B.FID) D\n");
        stringBuilder.append("                              ON D.FSTDRSMID = S.FID WHERE S.FDATASTATUS != '-2') F\n");
        stringBuilder.append("                 ON F.FID = E.FSTDRSMID\n");
        stringBuilder.append("              GROUP BY E.FSTDRSMID) N\n");
        stringBuilder.append("    ON M.FID = N.FDELIVERYID\n");
        stringBuilder.append("  LEFT JOIN T_TSRBD_RECRUCHNLNM R\n");
        stringBuilder.append("    ON M.FRECRUCHNLNMID = R.FID\n");
        stringBuilder.append("  LEFT JOIN T_TSRBD_APPMTHD P\n");
        stringBuilder.append("    ON M.FAPPMTHDID = P.FID\n");
        return stringBuilder;
    }

    public DynamicObject[] queryRecruchnlnm() {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_recruchnlnm");
        this.defaultFilter.and("issyspreset", "=", (Object)"1");
        return hrBaseServiceHelper.query("name", this.defaultFilter.toArray(), "id", 10);
    }

    public Object[] setXAxisTextStyle(List<String> recruchnlnmName, String color) {
        HashMap<String, String> textStyle = new HashMap<String, String>();
        textStyle.put("color", color);
        Object[] data = new Object[recruchnlnmName.size()];
        for (int i = 0; i < recruchnlnmName.size(); ++i) {
            HashMap<String, Object> data1 = new HashMap<String, Object>();
            data1.put("value", recruchnlnmName.get(i));
            data1.put("textStyle", textStyle);
            data[i] = data1;
        }
        return data;
    }

    public void setLineColor(Axis axix, String color) {
        HashMap lineStyleMap = Maps.newHashMapWithExpectedSize((int)2);
        HashMap axisLineMap = Maps.newHashMapWithExpectedSize((int)2);
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", (Object)axisLineMap);
    }

    private void setDefaultDate() {
        Date end = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        Date start = HRDateTimeUtils.addMonth((Date)end, (int)-6);
        DateRangeEdit dateFieldEdit = (DateRangeEdit)this.getView().getControl("daterangefield");
        dateFieldEdit.setMaxDate(end);
        this.getModel().setValue("dtstartdate", (Object)start);
        this.getModel().setValue("dtenddate", (Object)end);
    }

    public void listboxClick(ListboxEvent event) {
        String source = event.getItemId();
        if (source.contains("btn_")) {
            LOGGER.info("ChannelSourceCardPlugin.click.appmthd : {}", (Object)source);
            this.checkDataSet();
            String oldAppmthd = this.getPageCache().get("appmthd");
            if (StringUtils.equals((String)oldAppmthd, (String)source)) {
                return;
            }
            this.getPageCache().put("appmthd", source);
            this.drawChart();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (StringUtils.equals((String)"dtstartdate", (String)fieldName) || StringUtils.equals((String)"dtenddate", (String)fieldName)) {
            LOGGER.info("ChannelSourceCardPlugin.propertyChanged.datename : {}", (Object)fieldName);
            if (changeData.getNewValue() == null) {
                this.getView().showErrorNotification("\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                return;
            }
            Date startdate = (Date)this.getModel().getValue("dtstartdate");
            Date enddate = (Date)this.getModel().getValue("dtenddate");
            if (startdate == null || enddate == null) {
                return;
            }
            this.checkDataSet();
            this.drawChart();
        }
    }

    private void checkDataSet() {
        if (this.dataSet == null) {
            this.dataSet = this.getRdeliveryDataSet();
        }
    }

    private DataSet getRdeliveryDataSet() {
        this.hasPermOrgResult = TalentPoolMgtPermHelper.getAllPermOrg((String)"tstpm_stdrsm", (String)"47150e89000000ac");
        StringBuilder stringBuilder = this.getStringBuilder(this.hasPermOrgResult);
        DBRoute dbRoute = new DBRoute("tsc");
        return DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)dbRoute, (String)stringBuilder.toString());
    }

    private LinkedHashMap<String, Number> getRecruchnlnmName() {
        this.checkDataSet();
        DynamicObject[] dynamicObjects = this.queryRecruchnlnm();
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMapWithExpectedSize((int)dynamicObjects.length);
        if (this.dataSet != null) {
            Date startDate = (Date)this.getModel().getValue("dtstartdate");
            Date endDate = (Date)this.getModel().getValue("dtenddate");
            LOGGER.info("ChannelSourceCardPlugin.getRecruchnlnmName.date :[ start:{},end:{}]", (Object)startDate, (Object)endDate);
            String appmthd = this.getPageCache().get("appmthd");
            LOGGER.info("ChannelSourceCardPlugin.getRecruchnlnmName.appmthd :[ appmthd:{}]", (Object)appmthd);
            StringBuilder filter = new StringBuilder();
            HashMap<String, Date> map = new HashMap<String, Date>();
            map.put("startDate", startDate);
            map.put("endDate", endDate);
            filter.append("applytime >= startDate");
            filter.append(" and applytime <= endDate");
            if (appmthd != null && !StringUtils.equals((String)"btn_all", (String)appmthd)) {
                filter.append(" and appmthdId = ").append(appmthd.replaceAll("btn_", ""));
            }
            GroupbyDataSet groupbyDataSet = this.dataSet.copy().filter(filter.toString(), map).groupBy(new String[]{"recruchnlnmId", "recruchnlnmName"});
            try (DataSet finish = groupbyDataSet.count().finish().orderBy(new String[]{"count desc", "recruchnlnmId asc"}).top(10);){
                for (Row row : finish) {
                    linkedHashMap.put(this.getLoadKDString(row.getString("recruchnlnmName"), "\u672a\u77e5", "ChannelSourceCardPlugin_0"), row.getLong("count"));
                }
            }
        }
        LOGGER.info("ChannelSourceCardPlugin.getRecruchnlnmName.linkedHashMap:{},size:{}", (Object)linkedHashMap, (Object)linkedHashMap.size());
        if (linkedHashMap.size() == 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                linkedHashMap.put(dynamicObject.getString("name"), 0L);
            }
        }
        return linkedHashMap;
    }

    private String getLoadKDString(String param, String desc, String resourceID) {
        return HRStringUtils.isEmpty((String)param) ? ResManager.loadKDString((String)desc, (String)resourceID, (String)"tsc-tstpm-formplugin", (Object[])new Object[0]) : param;
    }

    private void drawChart() {
        LinkedHashMap<String, Number> recruchnlnmLinkedHashMap;
        HistogramChart customchart = this.getMainChart();
        customchart.clearData();
        try {
            recruchnlnmLinkedHashMap = this.getRecruchnlnmName();
        }
        catch (Exception exp) {
            throw new KDException((Throwable)exp, new ErrorCode("ChannelSourceCardPlugin", exp.getMessage()), new Object[0]);
        }
        finally {
            LOGGER.info("ChannelSourceCardPlugin.drawChart.dataSet.close.");
            if (this.dataSet != null) {
                this.dataSet.close();
                this.dataSet = null;
            }
        }
        ArrayList<String> recruchnlnmName = new ArrayList<String>(recruchnlnmLinkedHashMap.size());
        ArrayList<Number> recruchnlnmNumber = new ArrayList<Number>(recruchnlnmLinkedHashMap.size());
        recruchnlnmLinkedHashMap.forEach((key, value) -> {
            recruchnlnmName.add((String)key);
            recruchnlnmNumber.add((Number)value);
        });
        this.createBarSeries(recruchnlnmNumber);
        this.createCategoryAxis(recruchnlnmName);
        this.createValueAxis();
        customchart.refresh();
    }

    private void createBarSeries(List<Number> data) {
        BarSeries barSeries = this.getMainChart().createBarSeries(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u6570", (String)"TalentPoolMgtHome_0", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
        barSeries.setBarWidth("19px");
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> normap = new HashMap<String, HashMap<String, String>>();
        map.put("color", "new echarts.graphic.LinearGradient(0, 0, 0, 1, [{\"offset\": 1,\"color\": '#8CA9F5'}, {\"offset\": 0, \"color\": '#648CF9'}])");
        normap.put("normal", map);
        barSeries.setPropValue("itemStyle", normap);
        HashMap<String, Object> numColorMap = new HashMap<String, Object>();
        HashMap<String, HashMap<String, Object>> norColorMap = new HashMap<String, HashMap<String, Object>>();
        numColorMap.put("color", "#999999");
        numColorMap.put("show", Boolean.TRUE);
        numColorMap.put("position", "top");
        norColorMap.put("normal", numColorMap);
        barSeries.setPropValue("label", norColorMap);
        ArrayList<String> list = new ArrayList<String>();
        list.add("itemStyle");
        list.add("normal");
        list.add("color");
        barSeries.addFuncPath(list);
        barSeries.setType(ChartType.bar);
        barSeries.setAnimationDuration(1000);
        barSeries.setData(data.toArray(new Number[0]));
    }

    private Axis createCategoryAxis(List<String> recruchnlnmName) {
        Axis axis = this.getMainChart().createXAxis("", AxisType.category);
        HashMap axisTick = Maps.newHashMapWithExpectedSize((int)2);
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", (Object)axisTick);
        this.setLineColor(axis, "#CCCCCC");
        axis.setPropValue("data", (Object)this.setXAxisTextStyle(recruchnlnmName, "#666666"));
        HashMap xAxisPointer = Maps.newHashMapWithExpectedSize((int)8);
        xAxisPointer.put("show", Boolean.TRUE);
        xAxisPointer.put("type", "shadow");
        Label xAxisLabel = new Label();
        axis.setPropValue("axisPointer", (Object)xAxisPointer);
        return axis;
    }

    private Axis createValueAxis() {
        Axis axis = this.getMainChart().createYAxis("", AxisType.value);
        HashMap axisTick = Maps.newHashMapWithExpectedSize((int)2);
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", (Object)axisTick);
        HashMap axisLabel = Maps.newHashMapWithExpectedSize((int)2);
        axisLabel.put("color", "#999999");
        axis.setPropValue("axisLabel", (Object)axisLabel);
        HashMap splitLine = Maps.newHashMapWithExpectedSize((int)2);
        HashMap lineStyle = Maps.newHashMapWithExpectedSize((int)4);
        lineStyle.put("type", "dashed");
        lineStyle.put("color", "#E5E5E5");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", (Object)splitLine);
        axis.setPropValue("minInterval", (Object)1);
        this.setLineColor(axis, "#CCCCCC");
        this.getMainChart().setShowTooltip(true);
        return axis;
    }

    private HistogramChart getMainChart() {
        return (HistogramChart)this.getControl("histogramchartap");
    }
}

