/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.talentpool.talentpoolhome;

import java.time.LocalDate;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.MailInfoService;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.recycle.domain.MailRecycleCount;
import kd.tsc.tsrbd.common.enums.DatePeriodEnum;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbs.common.enums.MailStatusEnum;
import kd.tsc.tstpm.business.domain.talentpool.helper.TalentPoolFunHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentListFunService;

public class EmailCollectResumePlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("emailresumeentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject[] appResumeDtArrays = TalentPoolFunHelper.queryApplyResumeDtArrays();
        LocalDate startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)"past_half_year"));
        this.queryEmailCollectResumeCount(appResumeDtArrays, startDate);
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        ChangeData changeData;
        String newValue;
        String fieldName = propertyChangedArgs.getProperty().getName();
        if (HRStringUtils.equals((String)"dataselect", (String)fieldName) && HRStringUtils.isNotEmpty((String)(newValue = (String)(changeData = propertyChangedArgs.getChangeSet()[0]).getNewValue()))) {
            DynamicObject[] appResumeDtArrays = TalentPoolFunHelper.queryApplyResumeDtArrays();
            LocalDate startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)newValue));
            this.queryEmailCollectResumeCount(appResumeDtArrays, startDate);
        }
    }

    private void queryEmailCollectResumeCount(DynamicObject[] appResumeDtArrays, LocalDate startDate) {
        List mailRecycleCountList = TalentListFunService.queryEmailCollectResumeCount((DynamicObject[])appResumeDtArrays, (LocalDate)startDate);
        this.getModel().deleteEntryData("emailresumeentity");
        if (mailRecycleCountList.size() < 1) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("emailresumeentity", mailRecycleCountList.size());
        EntryGrid dataEntity = (EntryGrid)this.getControl("emailresumeentity");
        dataEntity.setPageIndex(1);
        int emailIndex = 0;
        for (MailRecycleCount mailRecycleCount : mailRecycleCountList) {
            this.getModel().setValue("mailid", (Object)mailRecycleCount.getMailId(), emailIndex);
            this.getModel().setValue("mailaddress", (Object)mailRecycleCount.getMailAddress(), emailIndex);
            this.getModel().setValue("source", (Object)mailRecycleCount.getSource(), emailIndex);
            this.getModel().setValue("resumecount", (Object)mailRecycleCount.getResumeCount(), emailIndex);
            this.getModel().setValue("mailstatus", (Object)MailStatusEnum.valuesOf((String)mailRecycleCount.getMailStatus()), emailIndex);
            ++emailIndex;
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        EntryGrid entryGrid = (EntryGrid)arg0.getSource();
        DynamicObject[] dynamicObject = entryGrid.getEntryData().getDataEntitys();
        int rowIndex = arg0.getRowIndex();
        MailInfoService.getInstance().openMailConfigPage(this.getView(), Long.valueOf(dynamicObject[rowIndex].getLong("mailid")), OperationStatus.EDIT, BillOperationStatus.EDIT, (IFormPlugin)this);
    }
}

