/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.talentpool.talentpoolhome;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentListFunService;

public class PositionListPlugin
extends HRDynamicFormBasePlugin
implements SearchEnterListener {
    private static final String SEARCHAP = "searchap";
    private static final String POSITION_STATUS_OPEN = "A";
    private static final String POSITION_STATUS_DRAFT = "B";
    private static final String POSITION_STATUS_STOP = "C";
    private static final String POSITION_STATUS_CLOSE = "D";
    private static final String POSITION_STATUS_INVALID = "E";
    private static final String POSITION_STATUS_AUDITING = "F";
    private static final String POSITION_ADMINORG = "adminorg";
    private static final String RECRUIT_CATEGORY = "reccategory";
    private static final String WORK_ADDR = "workaddr";
    private static final String CITY_NAME = "city.name";
    private static final String POSITION_RECRUIT_NUM = "recruitnum";
    private static final String POSITION_STATUS = "positionstatus";
    private static final String POSITION_PRINCIPLE = "posprin";

    public void registerListener(EventObject event) {
        Search search = (Search)this.getControl(SEARCHAP);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject event) {
        DynamicObject[] resDynObj = TalentListFunService.getPositionDts(null);
        this.getModel().deleteEntryData("entryentity");
        if (resDynObj.length == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("entryentity", resDynObj.length);
        this.setPositionEntity(resDynObj);
    }

    public void search(SearchEnterEvent event) {
        List searchFieldsList = event.getSearchFields();
        this.searchEnter(searchFieldsList);
    }

    private void searchEnter(List<Map<String, Object>> searchFieldsList) {
        this.getModel().deleteEntryData("entryentity");
        DynamicObject[] resDynObj = TalentListFunService.getPositionDts(searchFieldsList);
        if (resDynObj.length == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("entryentity", resDynObj.length);
        this.setPositionEntity(resDynObj);
    }

    private void setPositionEntity(DynamicObject[] resDynObj) {
        int resDynObjLength = resDynObj.length;
        for (int i = 0; i < resDynObjLength; ++i) {
            this.getModel().setValue("number", (Object)resDynObj[i].getString("number"), i);
            this.getModel().setValue("name", (Object)resDynObj[i].getString("name"), i);
            this.getModel().setValue(POSITION_ADMINORG, (Object)this.getDynamicValue(resDynObj[i], POSITION_ADMINORG, "name"), i);
            this.getModel().setValue(RECRUIT_CATEGORY, (Object)this.getDynamicValue(resDynObj[i], RECRUIT_CATEGORY, "name"), i);
            this.getModel().setValue(WORK_ADDR, (Object)this.getDynamicCollectionValue(resDynObj[i], WORK_ADDR, "fbasedataid", CITY_NAME), i);
            this.getModel().setValue(POSITION_RECRUIT_NUM, (Object)resDynObj[i].getInt(POSITION_RECRUIT_NUM), i);
            this.getModel().setValue(POSITION_STATUS, (Object)this.transStatus(resDynObj[i].getString(POSITION_STATUS)), i);
            this.getModel().setValue(POSITION_PRINCIPLE, (Object)this.getDynamicCollectionValue(resDynObj[i], POSITION_PRINCIPLE, "fbasedataid", "name"), i);
            this.getModel().setValue("creator", (Object)this.getDynamicValue(resDynObj[i], "creator", "name"), i);
            this.getModel().setValue("createtime", (Object)resDynObj[i].getString("createtime").substring(0, 10), i);
        }
    }

    private String transStatus(String status) {
        String reStatus = "";
        switch (status) {
            case "A": {
                reStatus = ResManager.loadKDString((String)"\u62db\u8058\u4e2d", (String)"PositionList_0", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "B": {
                reStatus = ResManager.loadKDString((String)"\u8349\u7a3f", (String)"PositionList_1", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "C": {
                reStatus = ResManager.loadKDString((String)"\u5df2\u6682\u505c", (String)"PositionList_2", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "D": {
                reStatus = ResManager.loadKDString((String)"\u5df2\u5173\u95ed", (String)"PositionList_3", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "E": {
                reStatus = ResManager.loadKDString((String)"\u672a\u751f\u6548", (String)"PositionList_4", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "F": {
                reStatus = ResManager.loadKDString((String)"\u5ba1\u6279\u4e2d", (String)"PositionList_5", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        return reStatus;
    }

    private String getDynamicValue(DynamicObject dy, String dyStr, String str) {
        DynamicObject resDy = dy.getDynamicObject(dyStr);
        if (resDy != null) {
            return resDy.getString(str);
        }
        return "";
    }

    private String getDynamicCollectionValue(DynamicObject dy, String dyCollStr, String dyStr, String str) {
        DynamicObjectCollection dynamicCollection = dy.getDynamicObjectCollection(dyCollStr);
        if (dynamicCollection != null && dynamicCollection.size() > 0) {
            List notNullDyList = dynamicCollection.stream().filter(pvalue -> pvalue.getDynamicObject(dyStr) != null).collect(Collectors.toList());
            List names = notNullDyList.stream().map(pvalue -> pvalue.getDynamicObject(dyStr).getString(str)).collect(Collectors.toList());
            return StringUtils.join((Object[])names.toArray(), (String)", ");
        }
        return "";
    }
}

