/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.talentpool.talentpoolhome;

import java.io.Serializable;
import java.lang.constant.Constable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.common.enums.DatePeriodEnum;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tstpm.business.domain.talentpool.service.TrackRecSumServiceHelper;

public class TrackRecSumPlugin
extends AbstractFormPlugin {
    private TrackRecSumServiceHelper trackRecSumServiceHelper = new TrackRecSumServiceHelper();

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        BarChart customChart = (BarChart)this.getControl("barchartap");
        LocalDate startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)"today"));
        this.drawChart(customChart, startDate);
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        ChangeData changeData;
        String newValue;
        String fieldName = propertyChangedArgs.getProperty().getName();
        BarChart customChart = (BarChart)this.getControl("barchartap");
        if (HRStringUtils.equals((String)"dataselect", (String)fieldName) && HRStringUtils.isNotEmpty((String)(newValue = (String)(changeData = propertyChangedArgs.getChangeSet()[0]).getNewValue()))) {
            LocalDate startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)newValue));
            this.drawChart(customChart, startDate);
        }
    }

    private void drawChart(BarChart customChart, LocalDate startDate) {
        customChart.clearData();
        LinkedHashMap<String, Number> salesman = this.getData(startDate);
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<Number> values = new ArrayList<Number>();
        salesman.forEach((saleName, saleQuantity) -> {
            keys.add((String)saleName);
            values.add((Number)saleQuantity);
        });
        Collections.reverse(keys);
        Collections.reverse(values);
        this.createCategoryAxis(customChart, "", keys, false);
        this.createValueAxis(customChart, "", true);
        this.createBarSeries(customChart, "", values, "#2ec5cb");
        customChart.setMargin(Position.right, "90px");
        customChart.setMargin(Position.top, "0px");
        customChart.setLegendPropValue("itemWidth", (Object)30);
        customChart.setLegendPropValue("itemHeight", (Object)30);
        customChart.setLegendPropValue("top", (Object)"0");
        HashMap<String, Object> textStyle = new HashMap<String, Object>(2);
        textStyle.put("color", "#514e52");
        textStyle.put("fontSize", 16);
        customChart.setLegendPropValue("textStyle", textStyle);
        customChart.refresh();
    }

    private LinkedHashMap<String, Number> getData(LocalDate startDate) {
        LinkedHashMap<String, Number> results = new LinkedHashMap<String, Number>(3);
        List trackSumPer = this.trackRecSumServiceHelper.calTrackSumPer(startDate);
        results.put(ResManager.loadKDString((String)"\u8ddf\u8e2a\u603b\u4eba\u6570", (String)"BarChartHelper_0", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), trackSumPer.size());
        List jobIntentionPer = this.trackRecSumServiceHelper.calJobIntention(trackSumPer);
        results.put(ResManager.loadKDString((String)"\u6709\u6c42\u804c\u610f\u5411\u4eba\u6570", (String)"BarChartHelper_1", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), jobIntentionPer.size());
        List sucDeliveryPer = this.trackRecSumServiceHelper.calSucDelivery(startDate, jobIntentionPer);
        results.put(ResManager.loadKDString((String)"\u6210\u529f\u6295\u9012\u4eba\u6570", (String)"BarChartHelper_2", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), sucDeliveryPer.size());
        return results;
    }

    private Axis createCategoryAxis(BarChart customChart, String name, List<String> dimensions, boolean isX) {
        Axis axis = null;
        axis = isX ? customChart.createXAxis(name, AxisType.category) : customChart.createYAxis(name, AxisType.category);
        axis.setCategorys(dimensions);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>(2);
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        this.setLineColor(false, axis, "#514e52");
        return axis;
    }

    private Axis createValueAxis(BarChart customChart, String name, boolean isX) {
        Axis axis = null;
        axis = isX ? customChart.createXAxis(name, AxisType.value) : customChart.createYAxis(name, AxisType.value);
        HashMap<String, Serializable> splitLine = new HashMap<String, Serializable>(2);
        HashMap<String, String> lineStyle = new HashMap<String, String>(2);
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#ffffff");
        splitLine.put("lineStyle", lineStyle);
        splitLine.put("show", Boolean.TRUE);
        axis.setPropValue("splitLine", splitLine);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>(2);
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        this.setLineColor(true, axis, "#ffffff");
        customChart.setShowTooltip(true);
        return axis;
    }

    private void setLineColor(boolean isX, Axis axis, String color) {
        HashMap<String, Serializable> axisLineMap = new HashMap<String, Serializable>(2);
        HashMap<String, String> lineStyleMap = new HashMap<String, String>(2);
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        if (isX) {
            axisLineMap.put("show", Boolean.FALSE);
            axis.setPropValue("axisLine", axisLineMap);
            axis.setPropValue("axisLabel", axisLineMap);
        } else {
            axisLineMap.put("show", Boolean.FALSE);
            axis.setPropValue("axisLine", axisLineMap);
        }
    }

    private void createBarSeries(BarChart customChart, String name, List<Number> values, String axisColor) {
        BarSeries barSeries = customChart.createBarSeries(name);
        barSeries.setBarWidth("10px");
        barSeries.setColor(axisColor);
        Label label = barSeries.getLabel();
        label.setColor("#514e52");
        label.setPosition(Position.right);
        barSeries.setLabel(label);
        barSeries.setAnimationDuration(100);
        barSeries.setData(values.toArray(new Number[0]));
    }
}

