/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.talentpool.talentpoolmgt;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ITreeListView;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbs.business.domain.common.service.ListFilterCommonHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtEnum;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtPermHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtQFilterHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtTreeHelper;
import kd.tsc.tstpm.common.talentpool.TPMTreeDto;
import org.apache.commons.lang3.StringUtils;

public class TalentPoolMgtBaseListPlugin {
    public static void defaultRefreshNode(RefreshNodeEvent re, TreeNode root, String currNodeId, TreeNode currNode, TPMTreeDto tpmTreeDto) {
        if (currNode.getChildren() != null && !currNode.getChildren().isEmpty()) {
            re.setChildNodes(currNode.getChildren());
        } else if (StringUtils.equals((CharSequence)currNodeId, (CharSequence)root.getId())) {
            re.setChildNodes(TalentPoolMgtBaseListPlugin.loadTalentPoolListNode(tpmTreeDto));
        } else {
            re.setChildNodes(new ArrayList());
        }
    }

    public static List<TreeNode> loadTalentPoolListNode(TPMTreeDto treeDto) {
        List<TreeNode> treeNodes;
        TreeNode parentNode;
        ArrayList<TreeNode> treeSysPresetNodes = new ArrayList<TreeNode>();
        if (treeDto.isPubTPM()) {
            parentNode = TalentPoolMgtTreeHelper.getPublicTalentPoolTreeNode();
            treeDto.setEncryption(!TalentPoolMgtPermHelper.isSuperUser() && TalentPoolMgtPermHelper.querySecurityConf());
            treeNodes = TalentPoolMgtBaseListPlugin.loadSubNode(treeDto, "A");
            if (treeNodes.size() != 0) {
                parentNode.addChildren(treeNodes);
            }
            treeSysPresetNodes.add(parentNode);
        }
        if (treeDto.isPriTPM()) {
            parentNode = TalentPoolMgtTreeHelper.getPrivateTalentPoolTreeNode();
            parentNode.setIsOpened(!treeDto.isPubTPM());
            treeDto.setEncryption(false);
            treeNodes = TalentPoolMgtBaseListPlugin.loadSubNode(treeDto, "B");
            if (treeNodes.size() != 0) {
                parentNode.addChildren(treeNodes);
            }
            treeSysPresetNodes.add(parentNode);
        }
        if (treeDto.isSharTPM()) {
            treeSysPresetNodes.add(TalentPoolMgtTreeHelper.getSharTalentPoolTreeNode());
        }
        return treeSysPresetNodes;
    }

    public static List<TreeNode> loadSubNode(TPMTreeDto treeDto, String poolType) {
        return treeDto.isContainLower() ? TalentPoolMgtBaseListPlugin.getTalentPoolListNode(TalentPoolMgtQFilterHelper.getSubQFilter((TPMTreeDto)treeDto, (String)poolType), treeDto) : new ArrayList<TreeNode>();
    }

    public static List<TreeNode> getTalentPoolListNode(QFilter qFilter, TPMTreeDto treeDto) {
        DynamicObject[] objects = TalentPoolMgtHelper.talentPoolMgtServiceHelper.query(TalentPoolMgtHelper.selectProperties(), new QFilter[]{qFilter}, "createtime");
        LinkedHashMap<Long, TreeNode> nodeHashMap = TalentPoolMgtBaseListPlugin.objToTreeNodeMap(objects, treeDto.isEncryption());
        return TalentPoolMgtBaseListPlugin.getChildrenNodeList(nodeHashMap, treeDto.getTreeNode());
    }

    public static List<TreeNode> getChildrenNodeList(LinkedHashMap<Long, TreeNode> maps, TreeNode currNode) {
        ArrayList<TreeNode> parentNodes = new ArrayList<TreeNode>(maps.size());
        for (Map.Entry<Long, TreeNode> map : maps.entrySet()) {
            TreeNode value = map.getValue();
            if (maps.get(Long.parseLong(value.getParentid())) == null) {
                if (currNode != null && !HRStringUtils.equals((String)currNode.getId(), (String)value.getParentid())) continue;
                parentNodes.add(value);
                continue;
            }
            maps.get(Long.parseLong(value.getParentid())).addChild(value);
        }
        return parentNodes;
    }

    public static LinkedHashMap<Long, TreeNode> objToTreeNodeMap(DynamicObject[] objects, boolean originalEncryption) {
        LinkedHashMap nodeHashMap = Maps.newLinkedHashMapWithExpectedSize((int)objects.length);
        boolean encryption = originalEncryption;
        DynamicObject userSecurityObj = TalentPoolMgtPermHelper.queryUserSecurityLevel();
        for (DynamicObject dynamicObject : objects) {
            if (originalEncryption && userSecurityObj != null && dynamicObject.getLong("seclevel.index") >= userSecurityObj.getLong("index")) {
                encryption = false;
            }
            TreeNode treeNode = TalentPoolMgtTreeHelper.getTreeNode((DynamicObject)dynamicObject, (boolean)encryption);
            nodeHashMap.put(dynamicObject.getLong("id"), treeNode);
            encryption = originalEncryption;
        }
        return nodeHashMap;
    }

    public static void commonRecrutypColumnInit(FilterContainerInitArgs args, IFormView view) {
        CommonFilterColumn orgColumn = (CommonFilterColumn)args.getFilterColumn("recrutyp.name");
        String pageParam = TalentPoolMgtHelper.getInstance().getPageParam(view);
        QFilter qFilter = TalentPoolMgtQFilterHelper.getRecrutypQFilter((String)pageParam, (boolean)true);
        ListFilterCommonHelper.generalCommonColumnInit((CommonFilterColumn)orgColumn, (QFilter[])qFilter.toArray(), (String)"hbss_recrutyp", (String)"id");
    }

    public static void buildTreeListFilter(BuildTreeListFilterEvent ble) {
        String nodeId = ble.getNodeId().toString();
        DynamicObject[] dynamicObject = TalentPoolMgtHelper.getDynamicObjects((Long)Long.valueOf(nodeId));
        if (dynamicObject.length == 0) {
            return;
        }
        if (HRStringUtils.equals((String)nodeId, (String)"0") || HRStringUtils.equals((String)nodeId, (String)"1040")) {
            ble.setCancel(true);
            return;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(nodeId));
        String longNumber = dynamicObject[0].getString("longnumber");
        qFilter.or("longnumber", "like", (Object)(longNumber + "%"));
        ble.addQFilter(qFilter);
        ble.setCancel(true);
    }

    public static void saveCheck(IFormView view, ITreeModel model, String poolType) {
        String currentNodeId = (String)model.getCurrentNodeId();
        if (!HRStringUtils.equals((String)currentNodeId, (String)"0")) {
            DynamicObject[] dynamicObjects = TalentPoolMgtHelper.getDynamicObjects((Long)Long.parseLong(currentNodeId));
            if (dynamicObjects.length == 0) {
                view.showErrorNotification(TalentPoolMgtEnum.TPM_23.getValue());
                return;
            }
            if (dynamicObjects[0].getLong("level") == 10L) {
                view.showErrorNotification(TalentPoolMgtEnum.TPM_6.getValue());
                return;
            }
        }
        view.getPageCache().put("currentNodeId", currentNodeId);
        view.getPageCache().put("pooltype", poolType);
        view.invokeOperation("new");
    }

    public static void afterBindData(IFormView view, ITreeModel treeModel, ITreeListView treeListView) {
        String currentNodeId = String.valueOf(treeModel.getCurrentNodeId());
        IPageCache pageCache = view.getPageCache();
        if (HRStringUtils.equals((String)pageCache.get("operation"), (String)"new")) {
            String newID = pageCache.get("insertId");
            TreeNode root = treeModel.getRoot();
            TreeNode newTreeNode = root.getTreeNode(newID, 20);
            if (newTreeNode == null) {
                String parentID = pageCache.get("parentID");
                view.getPageCache().remove("parentID");
                treeModel.setCurrentNodeId((Object)parentID);
                treeListView.refresh();
            } else {
                view.getPageCache().remove("parentID");
                view.getPageCache().remove("operation");
                view.getPageCache().remove("insertId");
                treeModel.setCurrentNodeId((Object)newID);
                treeListView.refreshTreeNode(newID);
            }
        } else {
            treeListView.getTreeView().showNode(currentNodeId);
            view.setVisible(Boolean.valueOf(!StringUtils.equals((CharSequence)currentNodeId, (CharSequence)"0")), new String[]{"iscontainlower1"});
            view.getPageCache().remove("operation");
        }
    }

    public static void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args, IFormView view) {
        if (args.getFieldName().contains("recrutyp")) {
            String pageParam = TalentPoolMgtHelper.getInstance().getPageParam(view.getParentView());
            args.addCustomQFilter(TalentPoolMgtQFilterHelper.getRecrutypQFilter((String)pageParam, (boolean)true));
        }
    }
}

