/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.talentpool.talentpoolmgt;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.base.BaseView;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtPermHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtPubHelper;
import kd.tsc.tstpm.formplugin.web.talentpool.talentpoolmgt.TalentPoolMgtEditPlugin;
import org.apache.commons.lang3.tuple.Pair;

public class TalentPoolMgtPubEditPlugin
extends TalentPoolMgtEditPlugin {
    private static final Log LOGGER = LogFactory.getLog(TalentPoolMgtPubEditPlugin.class);
    private final TalentPoolMgtPubHelper talentPoolMgtPubHelper = TalentPoolMgtPubHelper.getInstance();
    private final String CUSTOM_STYLE_STR = "eyJ0eXBlIjowLCJjb250ZW50IjoiJHtcbm9yZGVyOjAgIWltcG9ydGFudDtcbn0ifQ==";

    @Override
    public void registerListener(EventObject eo) {
        super.registerListener(eo);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs pre) {
        BaseShowParameter showParameter = (BaseShowParameter)pre.getSource();
        if (showParameter.getCustomParam("iscopy") == null) {
            String pkId = showParameter.getPkId() == null ? null : showParameter.getPkId().toString();
            LOGGER.info("preOpenForm.pkId:{}", (Object)pkId);
            if (pkId != null) {
                DynamicObject[] dynamicObjects = TalentPoolMgtHelper.getDynamicObjects((Long)Long.parseLong(pkId));
                Long org = dynamicObjects[0].getLong("org.id");
                Pair permOrgResult = TalentPoolMgtPermHelper.getAllPermOrg((String)"1VTQHS13/SXY1");
                if (!((Boolean)permOrgResult.getLeft()).booleanValue() && !((List)permOrgResult.getRight()).contains(org)) {
                    showParameter.setBillStatus(BillOperationStatus.VIEW);
                    showParameter.setStatus(OperationStatus.VIEW);
                }
            }
        }
        super.preOpenForm(pre);
    }

    public void afterCreateNewData(EventObject eo) {
        super.afterCreateNewData(eo);
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        LOGGER.info("afterCreateNewData.currentNodeId:{}", (Object)pageCache.get("currentNodeId"));
        long currentNodeId = Long.parseLong(pageCache.get("currentNodeId"));
        OperationStatus status = ((BaseView)this.getView()).getStatus();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Pair addPermItem = TalentPoolMgtPermHelper.getAllPermOrg((String)"1VTQC/MT+XX11");
        if (OperationStatus.ADDNEW == status) {
            if (currentNodeId == 0L) {
                currentNodeId = 1020L;
                this.getModel().setValue("parent", (Object)1020L);
            }
            if (currentNodeId == 1020L) {
                this.getModel().setValue("nodetype", (Object)"A");
            } else {
                this.getModel().setValue("nodetype", (Object)"B");
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("cstyles", "eyJ0eXBlIjowLCJjb250ZW50IjoiJHtcbm9yZGVyOjAgIWltcG9ydGFudDtcbn0ifQ==");
                this.getView().updateControlMetadata("parent", data);
                this.talentPoolMgtPubHelper.setParentValue(this.getModel(), addPermItem);
            }
        }
        this.talentPoolMgtPubHelper.setOrgValue(this.getModel(), addPermItem, dataEntity.getLong("parent.org.id"));
    }

    public void afterLoadData(EventObject event) {
        super.afterLoadData(event);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (HRStringUtils.equals((String)dataEntity.getString("nodetype"), (String)"B")) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("cstyles", "eyJ0eXBlIjowLCJjb250ZW50IjoiJHtcbm9yZGVyOjAgIWltcG9ydGFudDtcbn0ifQ==");
            this.getView().updateControlMetadata("parent", data);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        this.getPageCache().put("pooltype", "A");
        super.beforeF7Select(beforeF7SelectEvent);
        String name = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"org")) {
            this.talentPoolMgtPubHelper.beforeF7SelectOrg(beforeF7SelectEvent);
        } else if (HRStringUtils.equals((String)name, (String)"parent")) {
            this.talentPoolMgtPubHelper.beforeF7SelectParent(beforeF7SelectEvent, this.getView().getParentView().getParentView());
        }
    }

    public void propertyChanged(PropertyChangedArgs pca) {
        super.propertyChanged(pca);
        String propertyName = pca.getProperty().getName();
        ChangeData[] changeSet = pca.getChangeSet();
        if (HRStringUtils.equals((String)propertyName, (String)"nodetype")) {
            this.setPluginOrderAndValue(changeSet[0]);
        } else if (HRStringUtils.equals((String)propertyName, (String)"parent")) {
            this.getModel().setValue("org", (Object)this.getModel().getDataEntity().getLong("parent.org.id"));
        } else if (HRStringUtils.equals((String)propertyName, (String)"secselect")) {
            if (this.getPageCache().get("oldSecLevel") == null) {
                this.getPageCache().put("oldSecLevel", (String)changeSet[0].getOldValue());
            }
            String newValue = (String)changeSet[0].getNewValue();
            this.getPageCache().put("newSecLevel", newValue);
        }
    }

    private void setPluginOrderAndValue(ChangeData changeData) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        DynamicObject dataEntity = model.getDataEntity();
        String newValue = (String)changeData.getNewValue();
        String customStyleStr = "";
        String ROOT_ORG = "rootOrg";
        String SUB_ORG = "subOrg";
        String SUB_PARENT = "subParent";
        if (HRStringUtils.equals((String)newValue, (String)"A")) {
            pageCache.put(SUB_ORG, String.valueOf(dataEntity.getLong("org.id")));
            pageCache.put(SUB_PARENT, String.valueOf(dataEntity.getLong("parent.id")));
            model.setValue("parent", (Object)1020L);
            boolean isEmpty = HRStringUtils.equals((String)pageCache.get(ROOT_ORG), (String)"0");
            model.setValue("org", isEmpty ? null : pageCache.get(ROOT_ORG));
        } else {
            pageCache.put(ROOT_ORG, String.valueOf(dataEntity.getLong("org.id")));
            boolean parentIsEmpty = HRStringUtils.equals((String)pageCache.get(SUB_PARENT), (String)"0");
            boolean orgIsEmpty = HRStringUtils.equals((String)pageCache.get(SUB_ORG), (String)"0");
            model.setValue("parent", parentIsEmpty ? null : pageCache.get(SUB_PARENT));
            model.setValue("org", orgIsEmpty ? null : pageCache.get(SUB_ORG));
            customStyleStr = "eyJ0eXBlIjowLCJjb250ZW50IjoiJHtcbm9yZGVyOjAgIWltcG9ydGFudDtcbn0ifQ==";
        }
        HashMap<String, String> data = new HashMap<String, String>(4);
        data.put("cstyles", customStyleStr);
        view.updateControlMetadata("parent", data);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (HRStringUtils.equals((String)"btnsave", (String)source.getKey())) {
            OperationStatus status = ((BaseView)this.getView()).getStatus();
            boolean isOperation = true;
            if (OperationStatus.EDIT == status) {
                this.getPageCache().put("OperationStatus", OperationStatus.EDIT.toString());
                isOperation = this.talentPoolMgtPubHelper.edit(this.getView(), this.getModel(), (IFormPlugin)this);
            } else if (OperationStatus.ADDNEW == status) {
                this.getPageCache().put("OperationStatus", OperationStatus.ADDNEW.toString());
                isOperation = this.talentPoolMgtPubHelper.add(this.getView(), this.getModel());
            }
            if (isOperation) {
                this.getView().invokeOperation("save");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        this.talentPoolMgtPubHelper.afterDoOperation(afterDoOperationEventArgs, this.getView(), this.getModel());
    }

    public void afterCopyData(EventObject eo) {
        super.afterCopyData(eo);
        long orgID = this.getModel().getDataEntity().getLong("org.id");
        String nodeType = this.getModel().getDataEntity().getString("nodetype");
        LOGGER.info("afterCopyData.orgID:{},nodeType:{}", (Object)orgID, (Object)nodeType);
        Pair addPermItem = TalentPoolMgtPermHelper.getAllPermOrg((String)"1VTQC/MT+XX11");
        LOGGER.info("afterCopyData.addPermItem.Left:{},Right:{}", addPermItem.getLeft(), addPermItem.getRight());
        if (HRStringUtils.equals((String)nodeType, (String)"B")) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("cstyles", "eyJ0eXBlIjowLCJjb250ZW50IjoiJHtcbm9yZGVyOjAgIWltcG9ydGFudDtcbn0ifQ==");
            this.getView().updateControlMetadata("parent", data);
            this.talentPoolMgtPubHelper.setParentValue(this.getModel(), addPermItem);
        }
        this.talentPoolMgtPubHelper.setOrgValue(this.getModel(), addPermItem, orgID);
    }
}

