/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.talentpool.talentpoolmgt;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListColumn;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.common.service.ListFilterCommonHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtEnum;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtPermHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtPubHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtQFilterHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtTreeHelper;
import kd.tsc.tstpm.common.talentpool.TPMTreeDto;
import kd.tsc.tstpm.formplugin.web.talentpool.talentpoolmgt.TalentPoolMgtBaseListPlugin;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class TalentPoolMgtPubListPlugin
extends StandardTreeListPlugin {
    private static final Log LOGGER = LogFactory.getLog(TalentPoolMgtPubListPlugin.class);
    private final TalentPoolMgtPubHelper talentPoolMgtPubHelper = TalentPoolMgtPubHelper.getInstance();
    private static final HashMap<String, Consumer<ItemClickEvent>> OPERATION_MAP = new HashMap(4);

    public TalentPoolMgtPubListPlugin() {
        OPERATION_MAP.put("tblnew", evt -> this.tblNew());
        OPERATION_MAP.put("tbldel", evt -> this.tblDel());
        OPERATION_MAP.put("tblrefresh", evt -> this.tblRefresh());
        OPERATION_MAP.put("tblcopy", evt -> this.tblCopy());
        OPERATION_MAP.put("exportbylist", evt -> this.tblExportListBySelectFields());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    private void initTreeNode() {
        TreeNode root = TalentPoolMgtTreeHelper.createRoot();
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)"0");
    }

    public void refreshNode(RefreshNodeEvent e) {
        TreeNode root = this.getTreeModel().getRoot();
        String currNodeId = (String)e.getNodeId();
        TreeNode currNode = root.getTreeNode(currNodeId, 20);
        IPageCache pageCache = this.getPageCache();
        String operation = pageCache.get("operation");
        TPMTreeDto tpmTreeDto = new TPMTreeDto(true, false, false);
        tpmTreeDto.setPermissionItem(TalentPoolMgtPubHelper.getPermissionItem((IFormView)this.getView()));
        if (operation != null) {
            if (StringUtils.equals((CharSequence)currNodeId, (CharSequence)root.getId())) {
                e.setChildNodes(TalentPoolMgtBaseListPlugin.loadTalentPoolListNode(tpmTreeDto));
            } else {
                tpmTreeDto.setTreeNode(currNode);
                tpmTreeDto.setEncryption(!TalentPoolMgtPermHelper.isSuperUser() && TalentPoolMgtPermHelper.querySecurityConf());
                e.setChildNodes(TalentPoolMgtBaseListPlugin.loadSubNode(tpmTreeDto, "A"));
            }
        } else {
            TalentPoolMgtBaseListPlugin.defaultRefreshNode(e, root, currNodeId, currNode, tpmTreeDto);
        }
    }

    public void initializeTree(EventObject e) {
        IPageCache iPageCache = this.getPageCache();
        if (!HRStringUtils.equals((String)"1", (String)iPageCache.get("isFirst"))) {
            long orgId = TSCRequestContext.getOrgId();
            Pair permOrgResult = this.talentPoolMgtPubHelper.checkHasPermOrgResult(this.getView());
            if (!((List)permOrgResult.getRight()).contains(orgId)) {
                orgId = ((List)permOrgResult.getRight()).size() > 0 ? (Long)((List)permOrgResult.getRight()).get(0) : 0L;
            }
            this.getPageCache().put("org", String.valueOf(orgId));
            this.initTreeNode();
            iPageCache.put("isFirst", "1");
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        if (TalentPoolMgtPubHelper.isLookUp((IFormView)this.getView())) {
            return;
        }
        this.commonOrgColumnInit(args, this.getView());
        TalentPoolMgtBaseListPlugin.commonRecrutypColumnInit(args, this.getView());
    }

    public void commonOrgColumnInit(FilterContainerInitArgs args, IFormView view) {
        CommonFilterColumn orgColumn = (CommonFilterColumn)args.getFilterColumn("org.name");
        if (!TalentPoolMgtPermHelper.isSuperUser()) {
            Pair permOrgResult = this.talentPoolMgtPubHelper.checkHasPermOrgResult(view);
            ListFilterCommonHelper.generalCommonColumnInit((CommonFilterColumn)orgColumn, (QFilter[])new QFilter[]{TalentPoolMgtQFilterHelper.getQFilter((List)((List)permOrgResult.getRight()), (String)"id")}, (String)"bos_org", (String)"id");
        }
        if (view.getPageCache().get("orgColumn") == null && !"0".equals(view.getPageCache().get("org"))) {
            orgColumn.setDefaultValue(view.getPageCache().get("org"));
        }
        view.getPageCache().put("orgColumn", "orgColumn");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (HRStringUtils.equals((String)e.getProperty().getName(), (String)"iscontainlower1")) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        String filterValue = String.valueOf(args.getFilterValue("org.id")).replaceAll("[\\[\\]]", "");
        IPageCache iPageCache = this.getPageCache();
        iPageCache.put("org", filterValue);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        if (TalentPoolMgtPermHelper.querySecurityConf()) {
            List listColumns = args.getListColumns();
            ListColumn secLevel = TalentPoolMgtPubHelper.createListColumn((String)"seclevel.codelevel", (String)TalentPoolMgtEnum.TPM_25.getValue(), (int)1);
            listColumns.add(listColumns.size() - 2, secLevel);
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent evt) {
        super.buildTreeListFilter(evt);
        TalentPoolMgtBaseListPlugin.buildTreeListFilter(evt);
    }

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("level asc ,modifytime desc");
        QFilter qFilter = this.talentPoolMgtPubHelper.getDefaultFilter(this.getView());
        String nodeId = this.getTreeModel().getCurrentNodeId().toString();
        this.talentPoolMgtPubHelper.notRootAddQFilter(qFilter, nodeId, this.getView(), this.getModel());
        e.setCustomQFilters(Collections.singletonList(qFilter));
        LOGGER.info("TalentPoolMgtPriListPlugin.setFilter.CustomQFilters : {}", (Object)SerializationUtils.toJsonString((Object)e.getCustomQFilters()));
    }

    public void afterBindData(EventObject e) {
        TalentPoolMgtBaseListPlugin.afterBindData(this.getView(), this.getTreeModel(), this.treeListView);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        TalentPoolMgtBaseListPlugin.filterContainerBeforeF7Select(args, this.getView());
        if (args.getFieldName().contains("org")) {
            Pair permOrgResult = this.talentPoolMgtPubHelper.checkHasPermOrgResult(this.getView());
            args.addCustomQFilter(TalentPoolMgtQFilterHelper.getQFilter((List)((List)permOrgResult.getRight()), (String)"id"));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        Object primaryKeyValue = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
        DynamicObject[] dynamicObjects = TalentPoolMgtHelper.getDynamicObjects((Long)((Long)primaryKeyValue));
        if (dynamicObjects.length == 0) {
            this.getView().showTipNotification(TalentPoolMgtEnum.TPM_23.getValue());
            args.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        Consumer<ItemClickEvent> consumer = OPERATION_MAP.get(evt.getItemKey());
        if (consumer != null) {
            consumer.accept(evt);
        }
    }

    private void tblNew() {
        if (!TalentPoolMgtPermHelper.checkPerm((String)"1VTQC/MT+XX11")) {
            this.getView().showErrorNotification(TalentPoolMgtEnum.TPM_18.getValue());
            return;
        }
        TalentPoolMgtBaseListPlugin.saveCheck(this.getView(), this.getTreeModel(), "A");
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (this.talentPoolMgtPubHelper.isDeleteConfirmOperation(event)) {
            this.tblDel();
        }
    }

    private void tblDel() {
        if (!TalentPoolMgtPermHelper.checkPerm((String)"1VTQEQU9XDP41")) {
            this.getView().showErrorNotification(TalentPoolMgtEnum.TPM_34.getValue());
            return;
        }
        this.getPageCache().put("operation", "delete");
        this.getView().invokeOperation("delete");
    }

    private void tblRefresh() {
        this.getPageCache().put("operation", "refresh");
        this.getView().invokeOperation("refresh");
    }

    private void tblCopy() {
        if (!TalentPoolMgtPermHelper.checkPerm((String)"1VTQC/MT+XX11")) {
            this.getView().showErrorNotification(TalentPoolMgtEnum.TPM_18.getValue());
            return;
        }
        this.getView().invokeOperation("copy");
    }

    private void tblExportListBySelectFields() {
        if (this.talentPoolMgtPubHelper.isDeleteData(this.getTreeModel())) {
            this.getView().showTipNotification(TalentPoolMgtEnum.TPM_23.getValue());
            return;
        }
        this.getView().invokeOperation("exportlistbyselectfields");
    }
}

