/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.talentpool.tracerecord;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtHomeHelper;
import kd.tsc.tstpm.business.domain.tracerecord.service.TraceRecordHelper;
import org.apache.commons.lang.StringUtils;

public class TraceRecordListPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOGGER = LogFactory.getLog(TraceRecordListPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        LOGGER.info("TraceRecordListPlugin.afterCreateNewData.Map:{}", (Object)SerializationUtils.toJsonString((Object)customParams));
        if (customParams.size() > 0) {
            this.packageData(customParams);
        }
    }

    private void packageData(Map<String, Object> customParams) {
        long stdrsmId = Long.parseLong(customParams.get("id").toString());
        List dynamicObjects = TraceRecordHelper.queryTraceRecordByStdrsmId((Long)stdrsmId);
        Boolean switchBtn = Boolean.FALSE;
        String cacheSwitchBtn = this.getPageCache().get("switchbtn");
        if (StringUtils.isNotEmpty((String)cacheSwitchBtn)) {
            switchBtn = Boolean.parseBoolean(cacheSwitchBtn);
            this.getModel().setValue("switchbtn", (Object)switchBtn);
        }
        IFormView view = this.getView();
        IFormView statisticsView = view.getView(view.getParentView().getPageCache().get("statistics"));
        statisticsView.invokeOperation("refresh");
        this.getView().sendFormAction(statisticsView);
        if (switchBtn.booleanValue()) {
            List list = StandardResumeDataHelper.getMergeStdIds(Collections.singletonList(stdrsmId));
            List dynamicObjectSuspected = TraceRecordHelper.queryTraceRecord((String)TraceRecordHelper.getSelectProperties(), (QFilter)TraceRecordHelper.getQFilterByStdrsmId(null, (List)list), null);
            for (DynamicObject dynamicObject : dynamicObjectSuspected) {
                dynamicObject.set("mid", (Object)Boolean.TRUE);
            }
            dynamicObjects.addAll(dynamicObjectSuspected);
        }
        TalentPoolMgtHomeHelper.sortDynamicObject((List)dynamicObjects);
        TalentPoolMgtHomeHelper.setTraceRecordEntryEntity((IDataModel)this.getModel(), (List)dynamicObjects);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        if (StringUtils.equals((String)"switchbtn", (String)fieldName)) {
            Boolean newValue = (Boolean)e.getChangeSet()[0].getNewValue();
            this.getPageCache().put("switchbtn", String.valueOf(newValue));
            this.getView().invokeOperation("refresh");
        }
    }
}

