/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.mservice.rsm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.rsmmetadata.service.ResumeMetadataService;
import kd.tsc.tsrbd.common.constants.deserializer.DefaultDeserializer;
import kd.tsc.tsrbd.common.enums.TSRBDPreDataEnum;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.entity.SaveCandidateResult;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeExpSortHelper;
import kd.tsc.tsrbs.common.exception.TSCBizException;
import kd.tsc.tstpm.business.domain.rsm.arf.ARFAttachmentHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.SpecialValueConvertHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.arf.ARFRsmHelper;
import kd.tsc.tstpm.business.domain.rsm.common.mservice.AppFileMService;
import kd.tsc.tstpm.business.domain.rsm.common.mservice.PositionMService;
import kd.tsc.tstpm.business.domain.rsm.common.service.BosAttachmentService;
import kd.tsc.tstpm.business.domain.rsm.sr.service.AddResumeHandleService;
import kd.tsc.tstpm.business.domain.rsm.sr.service.AddResumeService;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.oprecord.ResumeTypeEnum;
import kd.tsc.tstpm.common.utils.AttachmentUtil;
import kd.tsc.tstpm.mservice.rsm.AddCandidateServiceApi;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.curator.shaded.com.google.common.collect.Lists;

public class AddCandidateServiceImpl
implements AddCandidateServiceApi {
    private static final Log log = LogFactory.getLog(AddCandidateServiceImpl.class);
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"saveOfferFile_pool", (int)10, (int)200);
    private static String TP_STDRSM_ID = "tpStdRsmId";

    public Long addCandidate(Map<String, Object> resumeInfoMap, Long positionId, Map<String, Object> delivery, Map<String, Object> tpInfo) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tstpm_rsm");
        DynamicObject resumeDy = serviceHelper.generateEmptyDynamicObject();
        for (Map.Entry<String, Object> entry : resumeInfoMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            resumeDy.set(key, value);
        }
        resumeDy.set("tpsys", (Object)((String)tpInfo.get("tpsys")));
        DynamicObject deliveryDy = this.getDelivery(delivery);
        deliveryDy.set("tpsys", (Object)((String)tpInfo.get("tpsys")));
        DynamicObject positionDy = PositionMService.queryOneByPositionId((Long)positionId);
        AppResumeBo appResumeBo = new AppResumeBo(resumeDy, deliveryDy);
        appResumeBo.setTpAppfileId((String)tpInfo.get("tpAppfileId"));
        appResumeBo.setTpStdRsmId((String)tpInfo.get("tpStdRsmId"));
        appResumeBo.setTpSys((String)tpInfo.get("tpsys"));
        SaveCandidateResult result = AddResumeHandleService.getInstance().handle(appResumeBo, positionDy, Boolean.valueOf(false), ResumeTypeEnum.FROM);
        return result.getAppFileId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long addArf(Map<String, Object> resumeInfoMap, Long appfileId, String mainEntityId, int type) {
        Long l;
        DLock lock = DLock.create((String)("addArf-" + appfileId), (String)"desc");
        lock.lock();
        log.info("addarf get lock key {},mainEntityId {},type{},appfileId{}", new Object[]{"addArf-" + appfileId, mainEntityId, type, appfileId});
        try {
            l = this.extracted(resumeInfoMap, appfileId, mainEntityId, type);
        }
        catch (Throwable throwable) {
            lock.unlock();
            log.info("addarf unlock key {},mainEntityId {},type{},appfileId{}", new Object[]{"addArf-" + appfileId, mainEntityId, type, appfileId});
            throw throwable;
        }
        lock.unlock();
        log.info("addarf unlock key {},mainEntityId {},type{},appfileId{}", new Object[]{"addArf-" + appfileId, mainEntityId, type, appfileId});
        return l;
    }

    private long extracted(Map<String, Object> resumeInfoMap, Long appfileId, String mainEntityId, int type) {
        long rsmId = ID.genLongId();
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tspr_appfile");
        DynamicObject appfile = helper.queryOne("id,arfrsm,filestatus,tpsys,recrutyp", (Object)appfileId);
        if (!Objects.isNull(appfile)) {
            String fileStatus = appfile.getString("filestatus");
            if ("E".equals(fileStatus)) {
                return 0L;
            }
            DynamicObject arfRsmObject = appfile.getDynamicObject("arfrsm");
            if (!Objects.isNull(arfRsmObject) && arfRsmObject.getLong("id") != 0L && type == 1) {
                type = 2;
            }
            if (!Objects.isNull(appfile.getDynamicObject("arfrsm"))) {
                rsmId = type == 2 ? appfile.getDynamicObject("arfrsm").getLong("id") : rsmId;
            }
        } else {
            log.warn("addArf warn:appfile not exist , return 0L,appfileId{},mainEntityId{},type{}", new Object[]{appfileId, mainEntityId, type});
            return 0L;
        }
        Map entryInfoMap = ResumeMetadataService.getEntryInfoMap((String)"7", (Long)appfile.getLong("recrutyp.id"), (String)appfile.getString("tpsys"), (boolean)false);
        for (Map.Entry<String, Object> entry : resumeInfoMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (Objects.isNull(value)) continue;
            if (mainEntityId.equals(key)) {
                this.handleArfRsmObject(type, rsmId, appfile, (Map)value, mainEntityId);
            }
            if (!(value instanceof List)) continue;
            this.handleArfOtherObject(resumeInfoMap, type, rsmId, key, (List)value, mainEntityId, entryInfoMap);
        }
        if (type == 2) {
            DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tspr", (String)"SyncHcfFromArfServiceApi", (String)"updateArfToHcf", (Object[])new Object[]{appfileId, false});
        }
        return rsmId;
    }

    private void handleArfOtherObject(Map<String, Object> resumeInfoMap, int type, long rsmId, String key, List<Map<String, Object>> value, String mainEntityId, Map<Long, String> entryInfoMap) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(key);
        List otherObjects = Lists.newArrayListWithCapacity((int)(CollectionUtils.isNotEmpty(value) ? value.size() : 10));
        String stageType = String.valueOf(resumeInfoMap.get("stageType"));
        if (!"tstpm_arfattachment".equals(key) && type == 1) {
            for (Map<String, Object> map : value) {
                this.generateOtherObjects(rsmId, helper, otherObjects, map, resumeInfoMap, entryInfoMap);
            }
            if (entryInfoMap.get(TSRBDPreDataEnum.ARF_EDU_ID.getId()).equals(key)) {
                otherObjects = ResumeExpSortHelper.sortRsmEduExp((List)otherObjects);
            }
            helper.save(otherObjects.toArray(new DynamicObject[0]));
        } else if ("tstpm_arfattachment".equals(key) && type == 1) {
            THREAD_POOL.execute(() -> {
                for (Map map : value) {
                    this.saveAttachments(rsmId, stageType, map, mainEntityId);
                }
            });
        } else if (!"tstpm_arfattachment".equals(key) && type == 2) {
            for (Map<String, Object> map : value) {
                this.generateOtherObjects(rsmId, helper, otherObjects, map, resumeInfoMap, entryInfoMap);
            }
            helper.deleteByFilter(new QFilter("rsm", "=", (Object)rsmId).toArray());
            if (entryInfoMap.get(TSRBDPreDataEnum.ARF_EDU_ID.getId()).equals(key)) {
                otherObjects = ResumeExpSortHelper.sortRsmEduExp((List)otherObjects);
            }
            helper.save(otherObjects.toArray(new DynamicObject[0]));
        } else if ("tstpm_arfattachment".equals(key) && type == 2) {
            log.info("sys remove attachment param rsmId{},mainEntityId{} ", (Object)rsmId, (Object)mainEntityId);
            AttachmentServiceHelper.remove((String)mainEntityId, (Object)rsmId);
            ARFAttachmentHelper.getInstance().deleteByFilter(new QFilter("rsm", "=", (Object)rsmId).toArray());
            THREAD_POOL.execute(() -> {
                for (Map map : value) {
                    this.saveAttachments(rsmId, stageType, map, mainEntityId);
                }
            });
        }
    }

    private void handleArfRsmObject(int type, long rsmId, DynamicObject appfile, Map<String, Object> value, String mainEntityId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(mainEntityId);
        DynamicObject rsmObject = type == 1 ? helper.generateEmptyDynamicObject() : helper.queryOne((Object)rsmId);
        rsmObject.set("id", (Object)rsmId);
        for (Map.Entry<String, Object> rsmEntry : value.entrySet()) {
            String fieldKey = rsmEntry.getKey();
            Object fieldValue = rsmEntry.getValue();
            if (!rsmObject.containsProperty(fieldKey) || !this.hasTrueValue(fieldValue)) continue;
            String fieldClassSimpleName = ((IDataEntityProperty)rsmObject.getDataEntityType().getProperties().get((Object)fieldKey)).getPropertyType().getSimpleName();
            DefaultDeserializer.getDeserializer((String)fieldClassSimpleName).parserValue(rsmObject, fieldKey, fieldValue, new String[0]);
        }
        if (type == 1) {
            ARFRsmHelper.getInstance().saveOne(rsmObject);
            appfile.set("arfrsm", (Object)new Object[]{rsmId});
            AppFileMService.updateOne((DynamicObject)appfile);
        } else if (type == 2) {
            ARFRsmHelper.getInstance().updateOne(rsmObject);
        }
    }

    private void saveAttachments(long rsmId, String stageType, Map<String, Object> map, String mainEntityId) {
        String attachmentName = (String)map.get("attachmentname");
        if (this.isFlag(attachmentName)) {
            String downloadUrl = (String)map.get("downloadurl");
            log.info("AddCandidateServiceImpl.saveAttachments, downloadUrl:{}", (Object)downloadUrl);
            int attachmentsize = Objects.isNull(map.get("attachmentsize")) ? 0 : (Integer)map.get("attachmentsize");
            String customFileName = Objects.isNull(map.get("customfilename")) || StringUtils.isBlank((CharSequence)((String)map.get("customfilename"))) ? " " : (String)map.get("customfilename");
            String path = AttachmentUtil.upLoadFile((String)downloadUrl, (Long)rsmId, (String)attachmentName, (String)"tstpm", (String)"tstpm_srscarfmrsm", (int)0);
            log.info("attachment, path{}", (Object)path);
            if (HRStringUtils.isNotEmpty((String)path)) {
                BosAttachmentService.getInstance().saveAttachmentInfo(path, mainEntityId, Long.valueOf(rsmId), attachmentName, String.valueOf(attachmentsize), "attachmentpanelap", Integer.valueOf(stageType), customFileName);
                log.info("attachmentName already save2bas_attachment, attachmentName{}", (Object)attachmentName);
                DynamicObject attachment = ARFAttachmentHelper.getInstance().generateEmptyDynamicObject();
                attachment.set("rsm", (Object)rsmId);
                attachment.set("ffileid", (Object)path);
                attachment.set("stagetype", (Object)stageType);
                for (Map.Entry<String, Object> objectEntry : map.entrySet()) {
                    if (!attachment.containsProperty(objectEntry.getKey()) || !this.hasTrueValue(objectEntry.getValue())) continue;
                    attachment.set(objectEntry.getKey(), objectEntry.getValue());
                }
                log.info("attachmentName already save2tstpm_attachment, attachmentName{},stagetype{}", (Object)attachmentName, (Object)stageType);
                ARFAttachmentHelper.getInstance().saveOne(attachment);
            }
        }
    }

    private boolean isFlag(String attachmentName) {
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{attachmentName}) && !attachmentName.endsWith("html");
    }

    private void generateOtherObjects(long rsmId, HRBaseServiceHelper helper, List<DynamicObject> otherObjects, Map<String, Object> map, Map<String, Object> resumeInfoMap, Map<Long, String> entryInfoMap) {
        long cityId;
        boolean addressFlag;
        long industryTypeId;
        boolean flag;
        long languageName;
        DynamicObject otherObject = helper.generateEmptyDynamicObject();
        otherObject.set("id", (Object)ID.genLongId());
        otherObject.set("rsm", (Object)rsmId);
        if (entryInfoMap.get(TSRBDPreDataEnum.ARF_CRT_ID.getId()).equals(helper.getEntityName())) {
            if (null != resumeInfoMap.get("signoffice")) {
                resumeInfoMap.put("signoffice", StringUtils.substring((String)resumeInfoMap.get("signoffice").toString(), (int)0, (int)255));
            }
            String idCardValidity = (String)resumeInfoMap.get("idCardValidity");
            boolean flag2 = map.entrySet().stream().anyMatch(objectEntry -> this.hasTrueValue(objectEntry.getValue()));
            if (!flag2 && !this.hasTrueValue(idCardValidity)) {
                return;
            }
            this.convertIDCardDate(otherObject, idCardValidity);
            this.convertMokaIDUrl2Kd(rsmId, map);
        }
        for (Map.Entry<String, Object> objectEntry2 : map.entrySet()) {
            if (!otherObject.containsProperty(objectEntry2.getKey())) continue;
            String fieldKey = objectEntry2.getKey();
            Object fieldValue = objectEntry2.getValue();
            if (!otherObject.containsProperty(fieldKey) || !this.hasTrueValue(fieldValue)) continue;
            String fieldClassSimpleName = ((IDataEntityProperty)otherObject.getDataEntityType().getProperties().get((Object)fieldKey)).getPropertyType().getSimpleName();
            DefaultDeserializer.getDeserializer((String)fieldClassSimpleName).parserValue(otherObject, fieldKey, fieldValue, new String[0]);
        }
        if (entryInfoMap.get(TSRBDPreDataEnum.ARF_EDU_ID.getId()).equals(helper.getEntityName()) && otherObject.containsProperty("schoolname")) {
            long schoolName = otherObject.getLong("schoolname");
            if (1386848073895945216L != schoolName) {
                otherObject.set("othschname", (Object)"");
            }
            if (otherObject.containsProperty("education")) {
                Long eduCation;
                Object edu = otherObject.get("education");
                if (edu instanceof String) {
                    eduCation = Long.valueOf((String)edu);
                } else if (edu instanceof Long) {
                    eduCation = (Long)edu;
                } else {
                    return;
                }
                if (ObjectUtils.isNotEmpty((Object)eduCation)) {
                    HRBaseServiceHelper eduHelper = new HRBaseServiceHelper("hbss_diploma");
                    otherObject.set("education", (Object)eduHelper.loadSingle((Object)eduCation));
                }
            }
        }
        if (entryInfoMap.get(TSRBDPreDataEnum.ARF_LANGUAGE_ID.getId()).equals(helper.getEntityName()) && otherObject.containsProperty("languagename") && 1472453873053588480L != (languageName = otherObject.getLong("languagename"))) {
            otherObject.set("othlanguagetype", (Object)"");
        }
        boolean bl = flag = (entryInfoMap.get(TSRBDPreDataEnum.ARF_WORK_ID.getId()).equals(helper.getEntityName()) || entryInfoMap.get(TSRBDPreDataEnum.ARF_INTER_ID.getId()).equals(helper.getEntityName())) && otherObject.containsProperty("industrytype");
        if (flag && 1210L != (industryTypeId = otherObject.getLong("industrytype"))) {
            otherObject.set("industrytypetxt", (Object)"");
        }
        boolean bl2 = addressFlag = (entryInfoMap.get(TSRBDPreDataEnum.ARF_WORK_ID.getId()).equals(helper.getEntityName()) || entryInfoMap.get(TSRBDPreDataEnum.ARF_INTER_ID.getId()).equals(helper.getEntityName())) && otherObject.containsProperty("city");
        if (addressFlag && (cityId = otherObject.getLong("city")) != 0L) {
            otherObject.set("workaddress", (Object)"");
        }
        otherObjects.add(otherObject);
    }

    private void convertIDCardDate(DynamicObject otherObject, String idCardValidity) {
        if (StringUtils.isNotEmpty((CharSequence)idCardValidity)) {
            JSONArray array = JSON.parseArray((String)idCardValidity);
            try {
                Date start = DateUtils.parseDate((String)((String)array.get(0)), (String[])new String[]{"yyyy-MM-dd"});
                otherObject.set("certstarttime", (Object)start);
                if ("\u957f\u671f".equals(String.valueOf(array.get(1)))) {
                    otherObject.set("islongvalid", (Object)true);
                    otherObject.set("certendtime", null);
                } else {
                    Date end = DateUtils.parseDate((String)((String)array.get(1)), (String[])new String[]{"yyyy-MM-dd"});
                    otherObject.set("certendtime", (Object)end);
                }
            }
            catch (ParseException e) {
                log.error(" param:{} throw expection{}", (Object)idCardValidity, (Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    private void convertMokaIDUrl2Kd(long rsmId, Map<String, Object> map) {
        map.forEach((key, value1) -> {
            if (!Objects.isNull(value1) && value1 instanceof List && CollectionUtils.isNotEmpty((Collection)((List)value1))) {
                Map result = (Map)((List)value1).get(0);
                String name = (String)result.get("name");
                String url = (String)result.get("url");
                if ("certfrontimg".equals(key) || "certbackimg".equals(key)) {
                    map.put((String)key, AttachmentUtil.upLoadFile((String)url, (Long)rsmId, (String)name, (String)"tstpm", (String)"tstpm_srscarfmcertificate", (int)0));
                }
            }
        });
    }

    public Long handleCandidate(Map<String, Object> resumeInfoMap, Map<String, Object> otherInfoMap) {
        log.info("AddResumeHandleService.handleCandidate begin");
        Long resultAppFileId = 0L;
        AppResumeBo appResumeBo = new AppResumeBo();
        String mainEntityKey = (String)otherInfoMap.get("mainEntityKey");
        this.setResumeInfo(appResumeBo, resumeInfoMap, mainEntityKey);
        this.sortEduExp(appResumeBo);
        this.setOtherInfo(appResumeBo, otherInfoMap);
        Long positionId = this.conversionToLong(otherInfoMap.get("positionId"));
        DynamicObject positionDy = PositionMService.queryOneByPositionId((Long)positionId);
        int type = this.conversionToInt(otherInfoMap.get("type"));
        SaveCandidateResult result = null;
        if (1 == type) {
            try {
                result = AddResumeHandleService.getInstance().newCandidate(appResumeBo, positionDy, Boolean.TRUE, ResumeTypeEnum.FROM, otherInfoMap);
            }
            catch (Exception ex) {
                if (ex instanceof KDException) {
                    ErrorCode errorCode = ((KDException)ex).getErrorCode();
                    String code = errorCode.getCode();
                    if (ObjectUtils.isEmpty((Object)code) || !code.contains("sQLDuplicateKey")) {
                        throw new TSCBizException((Throwable)ex);
                    }
                    log.warn("AddCandidateServiceImpl.handleCandidate.DuplicateKey");
                }
                throw new TSCBizException((Throwable)ex);
            }
        } else if (2 == type) {
            Long appFileId = this.conversionToLong(otherInfoMap.get("appfileId"));
            DynamicObject appfileDy = AppFileMService.queryAppfileById((Long)appFileId, (String)"filestatus, stdrsm, isdelete");
            String fileStatus = appfileDy.getString("filestatus");
            if ("E".equals(fileStatus) || "F".equals(fileStatus)) {
                return appfileDy.getLong("id");
            }
            appResumeBo.getRsm().set("stdrsm", (Object)appfileDy.getDynamicObject("stdrsm").getLong("id"));
            appResumeBo.getRsm().set("appfile", (Object)appfileDy.getLong("id"));
            result = AddResumeHandleService.getInstance().updateCandidate(appResumeBo, positionDy, Boolean.TRUE, ResumeTypeEnum.FROM, otherInfoMap);
            appfileDy.set("isdelete", (Object)Character.valueOf('0'));
            AppFileMService.updateOne((DynamicObject)appfileDy);
        }
        if (result != null) {
            resultAppFileId = result.getAppFileId();
        }
        return resultAppFileId;
    }

    private void sortEduExp(AppResumeBo appResumeBo) {
        Map resumeMapping = ResumeMetadataService.getTargetKeyByMtd((String)appResumeBo.getRsm().getDataEntityType().getName(), (String)"10040_S");
        String eduExpKey = (String)resumeMapping.entrySet().iterator().next().getKey();
        DynamicObjectCollection rsmEduExp = (DynamicObjectCollection)appResumeBo.getDyoCollMap().get(eduExpKey);
        if (ObjectUtils.isNotEmpty((Object)rsmEduExp)) {
            List sortRsmEduExp = ResumeExpSortHelper.sortRsmEduExp((List)rsmEduExp);
            DynamicObjectCollection eduCCollection = new DynamicObjectCollection();
            for (DynamicObject eduExpDy : sortRsmEduExp) {
                eduCCollection.add((Object)eduExpDy);
            }
            appResumeBo.getDyoCollMap().put(eduExpKey, eduCCollection);
            appResumeBo.getRsm().set("highesteduschool", ((DynamicObject)sortRsmEduExp.get(0)).get("schoolname"));
        }
    }

    private void setResumeInfo(AppResumeBo appResumeBo, Map<String, Object> resumeInfoMap, String mainEntityKey) {
        HRBaseServiceHelper rsmHelper = new HRBaseServiceHelper(mainEntityKey);
        DynamicObject resumeDy = rsmHelper.generateEmptyDynamicObject();
        long resumeId = ID.genLongId();
        for (Map.Entry<String, Object> entry : resumeInfoMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (mainEntityKey.equals(key)) {
                resumeDy.set("id", (Object)resumeId);
                Map actualValue = (Map)value;
                for (Map.Entry rsmEntry : actualValue.entrySet()) {
                    String fieldKey = (String)rsmEntry.getKey();
                    Object fieldValue = rsmEntry.getValue();
                    if (!resumeDy.containsProperty(fieldKey) || Objects.isNull(fieldValue)) continue;
                    String fieldClassSimpleName = ((IDataEntityProperty)resumeDy.getDataEntityType().getProperties().get((Object)fieldKey)).getPropertyType().getSimpleName();
                    DefaultDeserializer.getDeserializer((String)fieldClassSimpleName).parserValue(resumeDy, fieldKey, fieldValue, new String[0]);
                }
                Date birthDay = resumeDy.getDate("birthday");
                resumeDy.set("age", (Object)ResumeAnalysisHelper.calculateAge((Date)birthDay));
                appResumeBo.setRsm(resumeDy);
                String name = resumeDy.getString("fullname");
                this.setPictureConversionUrl(resumeDy, "photo", name);
                SpecialValueConvertHelper.afterHandleOtherTxt((Pair)Pair.of((Object)"expectindustry", (Object)"othexpectindustry"), (Long)1210L, (DynamicObject)resumeDy);
                continue;
            }
            List otherEntityList = (List)value;
            HRBaseServiceHelper helper = new HRBaseServiceHelper(key);
            DynamicObjectCollection otherDyCollection = new DynamicObjectCollection();
            for (Map otherEntity : otherEntityList) {
                long city;
                Long eduCation;
                Long languageName;
                Long schoolName;
                DynamicObject otherDy = helper.generateEmptyDynamicObject();
                for (Map.Entry otherEntry : otherEntity.entrySet()) {
                    String fieldKey = (String)otherEntry.getKey();
                    Object fieldValue = otherEntry.getValue();
                    otherDy.set("id", (Object)ID.genLongId());
                    if (!otherDy.containsProperty(fieldKey) || Objects.isNull(fieldValue)) continue;
                    String fieldClassSimpleName = ((IDataEntityProperty)otherDy.getDataEntityType().getProperties().get((Object)fieldKey)).getPropertyType().getSimpleName();
                    DefaultDeserializer.getDeserializer((String)fieldClassSimpleName).parserValue(otherDy, fieldKey, fieldValue, new String[0]);
                }
                if (otherDy.containsProperty("schoolname") && 1386848073895945216L != (schoolName = Long.valueOf(otherDy.getLong("schoolname")))) {
                    otherDy.set("othschname", (Object)"");
                }
                if (otherDy.containsProperty("languagename") && 1472453873053588480L != (languageName = Long.valueOf(otherDy.getLong("languagename")))) {
                    otherDy.set("othlanguagetype", (Object)"");
                }
                if (otherDy.containsProperty("education") && ObjectUtils.isNotEmpty((Object)(eduCation = Long.valueOf(otherDy.getLong("education"))))) {
                    HRBaseServiceHelper eduHelper = new HRBaseServiceHelper("hbss_diploma");
                    otherDy.set("education", (Object)eduHelper.loadSingle((Object)eduCation));
                }
                if (otherDy.containsProperty("industrytype")) {
                    SpecialValueConvertHelper.afterHandleOtherTxt((Pair)Pair.of((Object)"industrytype", (Object)"othindustry"), (Long)1210L, (DynamicObject)otherDy);
                }
                if (otherDy.containsProperty("city") && (city = otherDy.getLong("city")) != 0L) {
                    otherDy.set("workaddress", (Object)"");
                }
                if (otherDy.containsProperty("langcertscore")) {
                    otherDy.set("langcertscore", (Object)0);
                }
                otherDy.set("rsm", (Object)resumeId);
                otherDyCollection.add((Object)otherDy);
            }
            appResumeBo.setEntry(key, otherDyCollection);
        }
    }

    private void setPictureConversionUrl(DynamicObject dynamicObject, String fieldKey, String fileName) {
        try {
            String tpUrl = dynamicObject.getString(fieldKey);
            log.info("AddCandidateServiceImpl.setPictureConversionUrl.tpUrl: {}", (Object)tpUrl);
            if (ObjectUtils.isNotEmpty((Object)tpUrl)) {
                String filenameExtensionStr = tpUrl.substring(0, tpUrl.indexOf(63));
                String filenameExtension = filenameExtensionStr.substring(filenameExtensionStr.lastIndexOf(46));
                String transUrl = AttachmentUtil.upLoadFile((String)tpUrl, (Long)dynamicObject.getLong("id"), (String)(fileName + filenameExtension), (String)"tstpm", (String)"tstpm_rsm", (int)0);
                if (HRStringUtils.isNotEmpty((String)transUrl) && transUrl.length() > 500) {
                    transUrl = transUrl.substring(0, 501);
                }
                dynamicObject.set(fieldKey, (Object)transUrl);
                log.info("AddCandidateServiceImpl.setPictureConversionUrl.newTpUrl: {}", dynamicObject.get(fieldKey));
            }
        }
        catch (Exception exception) {
            log.error("AddCandidateServiceImpl.setResumeInfo.uploadFile error:", (Throwable)exception);
        }
    }

    private void setOtherInfo(AppResumeBo appResumeBo, Map<String, Object> otherInfoMap) {
        DynamicObject deliveryDy = this.getDelivery((Map)otherInfoMap.get("tstpm_rdelivery"));
        appResumeBo.setDelivery(deliveryDy);
        String tpAppFileId = String.valueOf(otherInfoMap.get("tpAppfileId"));
        String tpStdRsmId = String.valueOf(otherInfoMap.get("tpStdRsmId"));
        String tpSys = String.valueOf(otherInfoMap.get("tpsys"));
        appResumeBo.setTpAppfileId(tpAppFileId);
        appResumeBo.setTpStdRsmId(tpStdRsmId);
        appResumeBo.setTpSys(tpSys);
        appResumeBo.getRsm().set("tpsys", (Object)tpSys);
    }

    private DynamicObject getDelivery(Map<String, Object> delivery) {
        Object appmthd = delivery.get("appmthd");
        Long appmthdId = appmthd instanceof Long ? Long.valueOf(Long.parseLong(String.valueOf(appmthd))) : Long.valueOf(Long.parseLong((String)((Map)appmthd).get("id")));
        Map recruchnlnmMap = (Map)delivery.get("recruchnlnm");
        Long recruchnlnmId = Long.parseLong((String)recruchnlnmMap.get("id"));
        HRBaseServiceHelper recruchnlnmHelper = new HRBaseServiceHelper("tsrbd_recruchnlnm");
        DynamicObject recruchnlnmDy = recruchnlnmHelper.loadSingle((Object)recruchnlnmId);
        long resacqmthd = recruchnlnmDy.getDynamicObject("resacqmthd").getLong("id");
        return AddResumeService.generateDeliveryDt((Object)1040L, (Object)appmthdId, (Object)resacqmthd, (Object)recruchnlnmId);
    }

    private boolean hasTrueValue(Object object) {
        if (Objects.isNull(object)) {
            return false;
        }
        if (object instanceof String) {
            return StringUtils.isNotBlank((CharSequence)((String)object)) || !Objects.equals(object, "null");
        }
        if (object instanceof Map) {
            return ((Map)object).size() > 0 && StringUtils.isNotBlank((CharSequence)((String)((Map)object).get("zh_CN")));
        }
        return true;
    }

    private int conversionToInt(Object object) {
        int result = 0;
        if (object instanceof String) {
            result = Integer.parseInt(object.toString());
        } else if (object instanceof Integer) {
            result = (Integer)object;
        }
        return result;
    }

    private Long conversionToLong(Object object) {
        Long result = 0L;
        if (object instanceof String) {
            result = Long.valueOf(object.toString());
        } else if (object instanceof Long) {
            result = (Long)object;
        }
        return result;
    }
}

