/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.mservice.talentpool;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmBusiAppHelper;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.oprecord.TalentPoolOperateRecordService;
import kd.tsc.tstpm.business.domain.talentpool.entity.TalentPoolFallMessage;
import kd.tsc.tstpm.business.domain.talentpool.service.CheckPermissionHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentListFunService;
import kd.tsc.tstpm.business.domain.tracerecord.service.TraceRecordHelper;
import kd.tsc.tstpm.mservice.talentpool.TalentPoolServiceApi;

public class TalentPoolServiceImpl
implements TalentPoolServiceApi {
    private static final Log logger = LogFactory.getLog(TalentPoolServiceImpl.class);

    public boolean checkTstpmPermission() {
        return CheckPermissionHelper.getInstance().checkTstpmPermission();
    }

    public boolean checkBlackListPermission() {
        return CheckPermissionHelper.getInstance().checkBlackListPermission("47150e89000000ac");
    }

    public boolean isCurTalentAuth(Long candidateId) {
        return CheckPermissionHelper.getInstance().isCurTalentAuth(candidateId.longValue());
    }

    public String checkPermission(List<Long> appFileIds, String btnNum, String pageNumber) {
        if (!CheckPermissionHelper.getInstance().checkTstpmPermission()) {
            TalentPoolFallMessage talentPoolFallMessage = new TalentPoolFallMessage();
            talentPoolFallMessage.setFlag(false);
            talentPoolFallMessage.setCandidateIds(new ArrayList());
            talentPoolFallMessage.setErrorMsgNum(1);
            talentPoolFallMessage.setTitleMsg(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\"\u67e5\u770b\u5019\u9009\u4eba\"\u548c\"\u50a8\u5907\u5230\u4eba\u624d\u5e93\"\u7684\u6743\u9650\u3002", (String)"CheckPermissionHelper_10", (String)"tsc-tstpm-business", (Object[])new Object[0]));
            return SerializationUtils.toJsonString((Object)talentPoolFallMessage);
        }
        if (appFileIds == null || HRStringUtils.isEmpty((String)pageNumber)) {
            return null;
        }
        return CheckPermissionHelper.getInstance().getCandidateIdsFromAppFile(appFileIds, btnNum, pageNumber);
    }

    public String saveReserveRecord(List<Long> talentPoolIds, List<Long> candidateIds) {
        Object[] addReserveDtArrays = TalentListFunService.saveReserveRecord(talentPoolIds, candidateIds);
        if (HRArrayUtils.isEmpty((Object[])addReserveDtArrays)) {
            return null;
        }
        OperationResult addOperationResult = SaveServiceHelper.saveOperate((String)"save", (String)"tstpm_reservere", (DynamicObject[])addReserveDtArrays, (OperateOption)OperateOption.create());
        StandardResumeDataHelper.updateStdRsmTalentPool(candidateIds);
        StandardResumeDataHelper.updateModifyTime(candidateIds);
        ArrayList<Long> unClassifiedCTalentPools = new ArrayList<Long>(1);
        unClassifiedCTalentPools.add(1010L);
        TalentListFunService.removeReserveRecord(unClassifiedCTalentPools, candidateIds);
        TalentPoolOperateRecordService.getInstance().reserveOpRecord((DynamicObject[])addReserveDtArrays, addOperationResult);
        return TalentListFunService.returnSaveResult();
    }

    public boolean queryCandidateDeliveryStatus(long stdRsmId, long positionId) {
        return StdRsmBusiAppHelper.queryCandidateDeliveryStatus((long)stdRsmId, (long)positionId);
    }

    public boolean updateComRecordInfo(Long stdRsmId, Map<String, Object> updateMap) {
        logger.info("TalentPoolServiceImpl.updateComRecordInfo.stdRsmId:{}", (Object)stdRsmId);
        logger.info("TalentPoolServiceImpl.updateComRecordInfo.updateMap:{}", updateMap);
        try (TXHandle tx = TX.required();){
            TraceRecordHelper.SaveTraceRecord((Long)stdRsmId);
            StandardResumeDataHelper.updateStdRsmTalent((Long)stdRsmId, updateMap);
        }
        return true;
    }

    public boolean updateMesTrackInfo(Map<Long, Map<String, Object>> updateMap) {
        Set<Map.Entry<Long, Map<String, Object>>> entrySet = updateMap.entrySet();
        for (Map.Entry<Long, Map<String, Object>> next : entrySet) {
            StandardResumeDataHelper.updateStdRsmTalent((Long)next.getKey(), next.getValue());
        }
        return true;
    }

    public String checkStdRsmDataStatus(Long stdRsmId) {
        return StdRsmBusiAppHelper.checkStdRsmDataStatus((long)stdRsmId);
    }

    public Boolean checkStdRsmDataStatus(IFormView candidateView, IFormView currentView) {
        return StdRsmBusiAppHelper.checkStdRsmDataStatus((IFormView)candidateView, (IFormView)currentView);
    }
}

