/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.opplugin.web.vaapply;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.wtc.wtabm.business.vaapply.VaApplyService;
import kd.wtc.wtabm.business.vaapply.VaBaseService;
import kd.wtc.wtabm.opplugin.web.validate.VaBaseSetValidate;
import kd.wtc.wtbs.business.web.applybill.operatecore.va.VaAutoOperator;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class VaApplyOp
extends HRDataBaseOp {
    private static final Log LOGGER = LogFactory.getLog(VaApplyOp.class);
    private VaAutoOperator vaAutoOperator = null;

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        LOGGER.info("VaApplyOp onPreparePropertys, time", (Object)System.currentTimeMillis());
        List fieldKeys = args.getFieldKeys();
        VaBaseService.getInstance().addOpFields(fieldKeys);
        fieldKeys.add("attfilebasef7_id");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new VaBaseSetValidate(this));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs operationArgs) {
        DynamicObject[] dataEntities;
        Date now = new Date();
        LOGGER.info("VaApplyOp.beforeExecuteOperationTransaction.");
        long userId = RequestContext.get().getCurrUserId();
        for (DynamicObject dynamicObject : dataEntities = operationArgs.getDataEntities()) {
            this.resetCommitMessage(operationArgs.getOperationKey(), dynamicObject, now, userId);
            this.resetVaTypeToMain(operationArgs.getOperationKey(), dynamicObject);
        }
    }

    private void resetCommitMessage(String operateKey, DynamicObject formEntity, Date now, long userId) {
        if (StringUtils.equalsAny((CharSequence)operateKey, (CharSequence[])new CharSequence[]{"submit", "submiteffect"})) {
            formEntity.set("submitter", (Object)userId);
            formEntity.set("submitdate", (Object)now);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        LOGGER.info("beginOperationTransaction.");
        super.beginOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        if (dataEntities.length > 0) {
            UnifyBillApplyAttr applyAttr = null;
            if (this.getOption().containsVariable("appnumber")) {
                applyAttr = new UnifyBillApplyAttr(this.getOption().getVariableValue("appnumber"), args.getDataEntities()[0].getDataEntityType().getName());
            }
            List<DynamicObject> billDys = Arrays.asList(args.getDataEntities());
            if (this.vaAutoOperator == null) {
                this.vaAutoOperator = VaBaseService.getInstance().getVaAutoOperator(billDys, applyAttr);
            }
            VaApplyService vaApplyService = new VaApplyService();
            vaApplyService.resetBillEntryDisposable(billDys, this.vaAutoOperator);
            if (!WTCStringUtils.equals((String)"save", (String)args.getOperationKey())) {
                VaBaseService.getInstance().invokeQuotaInterface(args.getOperationKey(), Arrays.asList(args.getDataEntities()), this.vaAutoOperator, applyAttr);
            }
        }
    }

    public void setVaAutoOperator(List<DynamicObject> billDys, UnifyBillApplyAttr applyAttr) {
        if (this.vaAutoOperator == null) {
            this.vaAutoOperator = VaBaseService.getInstance().getVaAutoOperator(billDys, applyAttr);
        }
    }

    public VaAutoOperator getVaAutoOperator() {
        return this.vaAutoOperator;
    }

    private void resetVaTypeToMain(String operateKey, DynamicObject formEntity) {
        if (StringUtils.equalsAny((CharSequence)operateKey, (CharSequence[])new CharSequence[]{"save", "submit", "submiteffect"})) {
            DynamicObjectCollection collection = formEntity.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection vaTypeCollection = new DynamicObjectCollection();
            for (DynamicObject dynamicObject : collection) {
                vaTypeCollection.add((Object)dynamicObject.getDynamicObject("entryvacationtype"));
            }
            DynamicObjectCollection vacationTypeList = formEntity.getDynamicObjectCollection("vacationtypelist");
            if (!vaTypeCollection.isEmpty()) {
                vacationTypeList.clear();
                for (DynamicObject vaType : vaTypeCollection) {
                    DynamicObject dynamicObject = vacationTypeList.addNew();
                    dynamicObject.set("fbasedataid", (Object)vaType);
                }
            }
        }
    }
}

