/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.opplugin.web.validate;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtabm.business.va.OnCheckVaApplyOverlapEvent;
import kd.wtc.wtabm.business.bo.VaRepeatExtensionParam;
import kd.wtc.wtabm.business.vaapply.VaApplyExtHelper;
import kd.wtc.wtabm.business.vaapply.VaBaseService;
import kd.wtc.wtabm.business.vaapply.VaBillRepeatService;
import kd.wtc.wtabm.business.vaapply.checker.VaBillCheckService;
import kd.wtc.wtabm.common.entity.VacationValidResult;
import kd.wtc.wtabm.common.entity.vaapply.EndTimeVo;
import kd.wtc.wtabm.common.entity.vaapply.StartTimeVo;
import kd.wtc.wtabm.opplugin.web.vaapply.VaApplyOp;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyKDStringHelper;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.business.web.applybill.operatecore.va.VaAutoOperator;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.enums.bill.unify.BillSourceTypeEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.bill.BillFailInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.BooleanUtils;
import kd.wtc.wtbs.common.util.third.util.DateUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtp.enums.vaplan.BaseSetTimeUnitEnum;

public class VaBaseSetValidate
extends AbstractValidator {
    private static final Log LOG = LogFactory.getLog(VaBaseSetValidate.class);
    private VaApplyOp vaApplyPlugin;

    public VaBaseSetValidate(VaApplyOp vaApplyPlugin) {
        this.vaApplyPlugin = vaApplyPlugin;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void validate() {
        HashMap<DynamicObject, ExtendedDataEntity> dynamicObjectsMap;
        HashSet<ExtendedDataEntity> isNotLeaveDataEntities;
        block24: {
            Iterator vaBillCheckService2;
            UnifyBillApplyAttr applyAttr;
            ArrayList<DynamicObject> arrayList;
            block25: {
                BillResponse billResponse;
                block23: {
                    block22: {
                        int formEntity2;
                        ExtendedDataEntity[] extendedDataEntityArray;
                        Map discardAttFileBoIdMap;
                        long startTime = System.currentTimeMillis();
                        LOG.info("VaBaseSetValidate validate begin ,startTime:{}", (Object)startTime);
                        HashSet<ExtendedDataEntity> dataEntities = new HashSet<ExtendedDataEntity>(10);
                        isNotLeaveDataEntities = new HashSet<ExtendedDataEntity>(10);
                        ExtendedDataEntity[] extendedDataEntityArray2 = this.getDataEntities();
                        int n = extendedDataEntityArray2.length;
                        int n2 = 0;
                        while (true) {
                            Iterator iterator;
                            boolean mustInputcheckSuccess;
                            DynamicObject formEntity2;
                            ExtendedDataEntity extendedDataEntity;
                            if (n2 < n) {
                                extendedDataEntity = extendedDataEntityArray2[n2];
                                formEntity2 = extendedDataEntity.getDataEntity();
                                DynamicObjectCollection entryEntitys = formEntity2.getDynamicObjectCollection("entryentity");
                                mustInputcheckSuccess = !CollectionUtils.isEmpty((Collection)entryEntitys);
                                iterator = entryEntitys.iterator();
                            } else {
                                if (WTCCollections.isNotEmpty(isNotLeaveDataEntities)) {
                                    this.checkChangeBill(isNotLeaveDataEntities);
                                }
                                if (CollectionUtils.isEmpty(dataEntities)) {
                                    this.updateBillInfo(isNotLeaveDataEntities);
                                    return;
                                }
                                ExtendedDataEntity[] dataEntityArr = dataEntities.toArray(new ExtendedDataEntity[0]);
                                discardAttFileBoIdMap = BillCommonService.getInstance().getDiscardAttFileBoId(dataEntityArr);
                                dynamicObjectsMap = new HashMap<DynamicObject, ExtendedDataEntity>(this.getDataEntities().length);
                                extendedDataEntityArray = dataEntityArr;
                                formEntity2 = extendedDataEntityArray.length;
                                break;
                            }
                            while (iterator.hasNext()) {
                                DynamicObject entryEntity = (DynamicObject)iterator.next();
                                mustInputcheckSuccess = mustInputcheckSuccess && this.checkCoreMust(extendedDataEntity, entryEntity);
                            }
                            LOG.info("checkCoreMustSuccess:{}", (Object)mustInputcheckSuccess);
                            boolean isNotLeave = formEntity2.getBoolean("isnotleave");
                            if (isNotLeave) {
                                isNotLeaveDataEntities.add(extendedDataEntity);
                            } else if (mustInputcheckSuccess) {
                                dataEntities.add(extendedDataEntity);
                            }
                            ++n2;
                        }
                        for (int entryEntitys = 0; entryEntitys < formEntity2; ++entryEntitys) {
                            ExtendedDataEntity dataEntity = extendedDataEntityArray[entryEntitys];
                            DynamicObject formEntity3 = dataEntity.getDataEntity();
                            DynamicObject attFile = formEntity3.getDynamicObject("attfile");
                            String attFileNumber = (String)discardAttFileBoIdMap.get(attFile.getLong("id"));
                            if (HRStringUtils.isNotEmpty((String)attFileNumber)) {
                                this.addErrorMessage(dataEntity, BillUnifyKDStringHelper.notEffAttFile((String)BillTypeEnum.VACATIONBILL.getBillName(), (String)attFileNumber));
                                continue;
                            }
                            dynamicObjectsMap.put(formEntity3, dataEntity);
                            this.syncEntryTimeToMain(formEntity3);
                        }
                        arrayList = new ArrayList<DynamicObject>(dynamicObjectsMap.keySet());
                        if (arrayList.isEmpty()) {
                            return;
                        }
                        boolean fromImport = this.getOption().containsVariable("importtag_of_datasource");
                        boolean fromOpenApi = this.getOption().containsVariable("wtc_wtabm_openapi");
                        applyAttr = this.createUnifyBillApplyAttr(fromImport, fromOpenApi);
                        this.vaApplyPlugin.setVaAutoOperator(arrayList, applyAttr);
                        if (fromImport) {
                            LOG.info("VaBaseSetValidate validate4Import begin ,startTime(millis):{}", (Object)System.currentTimeMillis());
                            this.validate4Import(dynamicObjectsMap.values(), this.vaApplyPlugin.getVaAutoOperator(), applyAttr);
                            ArrayList checkRepeatDyns = Lists.newArrayList(dynamicObjectsMap.keySet());
                            BillFailInfo billFailInfo = this.checkRepeat(checkRepeatDyns, this.vaApplyPlugin.getVaAutoOperator(), applyAttr);
                            if (!billFailInfo.getErrorInfos().isEmpty()) {
                                for (DynamicObject dynamicObject : checkRepeatDyns) {
                                    ExtendedDataEntity dataEntity = (ExtendedDataEntity)dynamicObjectsMap.get(dynamicObject);
                                    if (!billFailInfo.getErrorInfos().containsKey(dynamicObject.getLong("id"))) continue;
                                    String errorMsg = (String)billFailInfo.getErrorInfos().get(dynamicObject.getLong("id"));
                                    this.addErrorMessage(dataEntity, errorMsg);
                                }
                            }
                            this.validateQuotaTryFrozen(applyAttr);
                            LOG.info("VaBaseSetValidate validate4Import end ,endTime(millis):{}", (Object)System.currentTimeMillis());
                            return;
                        }
                        if (!fromOpenApi) break block22;
                        VaBillCheckService vaBillCheckService2 = new VaBillCheckService(ApplyBillCheckEnum.VACATION, UnifyBillEnum.VA, arrayList, (WtcAbstractUnityBillOperator)this.vaApplyPlugin.getVaAutoOperator(), applyAttr);
                        billResponse = vaBillCheckService2.checkAllForOpenApi();
                        long afterCheck = System.currentTimeMillis();
                        LOG.info("VaBaseSetValidate validate afterCheck vaBillCheckService ,startTime:{}", (Object)afterCheck);
                        if (!billResponse.isSuccess()) break block23;
                        BillFailInfo billFailInfo = this.checkRepeat(arrayList, this.vaApplyPlugin.getVaAutoOperator(), applyAttr);
                        if (!billFailInfo.getErrorInfos().isEmpty()) {
                            for (ExtendedDataEntity dataEntity : dynamicObjectsMap.values()) {
                                long billId = dataEntity.getDataEntity().getLong("id");
                                String message = (String)billFailInfo.getErrorInfos().get(billId);
                                this.addErrorMessage(dataEntity, message);
                            }
                        }
                        break block24;
                    }
                    vaBillCheckService2 = arrayList.iterator();
                    break block25;
                }
                Iterator billFailInfo = dynamicObjectsMap.values().iterator();
                while (true) {
                    if (!billFailInfo.hasNext()) {
                        return;
                    }
                    ExtendedDataEntity dataEntity = (ExtendedDataEntity)billFailInfo.next();
                    String message = CollectionUtils.isEmpty((Collection)billResponse.getMessage()) ? "" : (String)billResponse.getMessage().get(0);
                    this.addErrorMessage(dataEntity, message);
                }
            }
            while (vaBillCheckService2.hasNext()) {
                DynamicObject dynamicObject = (DynamicObject)vaBillCheckService2.next();
                VaBillCheckService vaBillCheckService3 = new VaBillCheckService(ApplyBillCheckEnum.VACATION, UnifyBillEnum.VA, (List)Lists.newArrayList((Object[])new DynamicObject[]{dynamicObject}), (WtcAbstractUnityBillOperator)this.vaApplyPlugin.getVaAutoOperator(), applyAttr);
                BillResponse billResponse = vaBillCheckService3.checkAll();
                if (billResponse.isSuccess()) continue;
                ExtendedDataEntity dataEntity = (ExtendedDataEntity)dynamicObjectsMap.get(dynamicObject);
                String message = CollectionUtils.isEmpty((Collection)billResponse.getMessage()) ? "" : (String)billResponse.getMessage().get(0);
                this.addErrorMessage(dataEntity, message);
            }
            BillFailInfo billFailInfo = this.checkRepeat(arrayList, this.vaApplyPlugin.getVaAutoOperator(), applyAttr);
            if (!billFailInfo.getErrorInfos().isEmpty()) {
                for (DynamicObject dynamicObject : arrayList) {
                    ExtendedDataEntity dataEntity = (ExtendedDataEntity)dynamicObjectsMap.get(dynamicObject);
                    if (!billFailInfo.getErrorInfos().containsKey(dynamicObject.getLong("id"))) continue;
                    String errorMsg = (String)billFailInfo.getErrorInfos().get(dynamicObject.getLong("id"));
                    this.addErrorMessage(dataEntity, errorMsg);
                }
            }
            this.validateQuotaTryFrozen(applyAttr);
        }
        this.updateBillInfo(dynamicObjectsMap.values());
        this.updateBillInfo(isNotLeaveDataEntities);
    }

    private void validateQuotaTryFrozen(UnifyBillApplyAttr applyAttr) {
        if (WTCStringUtils.equals((String)this.getOperateKey(), (String)"save")) {
            List<ExtendedDataEntity> validateSuccessData = this.getValidateSuccessData();
            Map<DynamicObject, ExtendedDataEntity> succeedMap = validateSuccessData.stream().collect(Collectors.toMap(ExtendedDataEntity::getDataEntity, edt -> edt, (d1, d2) -> d1));
            ArrayList successBillDyns = Lists.newArrayList(succeedMap.keySet());
            List billResponses = VaBaseService.getInstance().invokeTryFrozenQuota((List)successBillDyns, this.vaApplyPlugin.getVaAutoOperator(), applyAttr);
            for (BillResponse billResponse : billResponses) {
                if (billResponse.isSuccess()) continue;
                DynamicObject billDy = (DynamicObject)billResponse.getData();
                String message = CollectionUtils.isEmpty((Collection)billResponse.getMessage()) ? "" : (String)billResponse.getMessage().get(0);
                this.addErrorMessage(succeedMap.get(billDy), message);
            }
        }
    }

    private List<ExtendedDataEntity> getValidateSuccessData() {
        List successList = WTCCollections.modifiableList((Object[])this.dataEntities);
        List falseDataEntities = this.getFalseDataEntities();
        if (WTCCollections.isNotEmpty((Collection)falseDataEntities)) {
            successList.removeAll(falseDataEntities);
        }
        return successList;
    }

    private BillFailInfo checkRepeat(List<DynamicObject> dyList, VaAutoOperator vaAutoOperator, UnifyBillApplyAttr applyAttr) {
        Map<DynamicObject, DynamicObject> checkedFalseDataEntityMap = this.getFalseDataEntities().stream().collect(Collectors.toMap(ExtendedDataEntity::getDataEntity, ExtendedDataEntity::getDataEntity, (d1, d2) -> d1));
        List dynamicObjects = dyList.stream().filter(dynamicObject -> checkedFalseDataEntityMap.get(dynamicObject) == null).collect(Collectors.toList());
        VaBillRepeatService repeatService = new VaBillRepeatService();
        OnCheckVaApplyOverlapEvent onCheckVaApplyOverlapEvent = VaApplyExtHelper.onCalVaRepeat();
        VaRepeatExtensionParam repeatParam = new VaRepeatExtensionParam(dynamicObjects, applyAttr, onCheckVaApplyOverlapEvent.getNeedNotCheckedOverlapVaTypes());
        repeatParam.setVaAutoOperator(vaAutoOperator);
        repeatParam.setUseStartOrEnd(vaAutoOperator.isUseStartOrEnd());
        BillFailInfo response = repeatService.checkStagingBillRepeat(repeatParam);
        if (response.getErrorInfos().isEmpty()) {
            response = repeatService.checkHisBillRepeat(repeatParam);
        }
        return response;
    }

    private UnifyBillApplyAttr createUnifyBillApplyAttr(boolean fromImport, boolean fromOpenApi) {
        String attFileF7AuthEntity = "";
        attFileF7AuthEntity = WTCCollectionIndexUtil.getEleFromArr((Object[])this.getDataEntities(), (int)0).isPresent() ? ((ExtendedDataEntity)WTCCollectionIndexUtil.getEleFromArr((Object[])this.getDataEntities(), (int)0).get()).getDataEntity().getDataEntityType().getName() : "";
        String attachmentCache = this.getAttachmentInfo();
        String appId = BillCommonService.getInstance().getAppIdFromOp(this.getOption());
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(appId, attFileF7AuthEntity).setAttachmentCache(attachmentCache);
        if (fromImport) {
            applyAttr.setSourceType(BillSourceTypeEnum.IMPORT);
        }
        if (fromOpenApi) {
            applyAttr.setSourceType(BillSourceTypeEnum.OPENAPI);
        }
        return applyAttr;
    }

    private void validate4Import(Collection<ExtendedDataEntity> dataEntities, VaAutoOperator vaAutoOperator, UnifyBillApplyAttr applyAttr) {
        Iterator<ExtendedDataEntity> iterator = dataEntities.iterator();
        while (iterator.hasNext()) {
            ExtendedDataEntity billExt = iterator.next();
            DynamicObject bill = billExt.getDataEntity();
            List<DynamicObject> billDys = Collections.singletonList(bill);
            if (!BooleanUtils.isFalse((Boolean)bill.getBoolean("isnotleave"))) continue;
            VaBillCheckService vaBillCheckService = new VaBillCheckService(ApplyBillCheckEnum.VACATION, UnifyBillEnum.VA, billDys, (WtcAbstractUnityBillOperator)vaAutoOperator, applyAttr);
            BillResponse billResponse = vaBillCheckService.checkAllForImp();
            Object data = billResponse.getData();
            if (billResponse.isSuccess()) continue;
            if (data instanceof BillFailInfo) {
                BillFailInfo billFailInfo = (BillFailInfo)data;
                Object value = billExt.getValue("id");
                if (!billFailInfo.getErrorInfos().containsKey(value)) continue;
                this.addErrorMessage(billExt, (String)billFailInfo.getErrorInfos().get(value));
                iterator.remove();
                continue;
            }
            String message = CollectionUtils.isEmpty((Collection)billResponse.getMessage()) ? "" : (String)billResponse.getMessage().get(0);
            this.addErrorMessage(billExt, message);
            iterator.remove();
        }
        this.updateBillInfo(dataEntities);
    }

    private void updateBillInfo(Collection<ExtendedDataEntity> dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            VacationValidResult result = this.validateNeedHand(dynamicObject);
            if (!result.isSuccess()) {
                this.addFatalErrorMessage(dataEntity, result.getFailMsg());
            }
            this.syncEntryToMain(dynamicObject);
        }
    }

    private String getAttachmentInfo() {
        OperateOption option = this.getValidateContext().getOption();
        return option.getVariableValue("ATTACHMENT_COUNT", null);
    }

    private VacationValidResult validateNeedHand(DynamicObject dynamicObject) {
        boolean isNeedHand = dynamicObject.getBoolean("isneedhand");
        VacationValidResult result = VacationValidResult.success();
        if (isNeedHand) {
            String handPerson = dynamicObject.getString("handperson");
            String handReason = dynamicObject.getString("handreason");
            if (HRStringUtils.isEmpty((String)handPerson) || HRStringUtils.isEmpty((String)handReason)) {
                result = VacationValidResult.fail((String)ResManager.loadKDString((String)"\u672a\u586b\u5199\u4ea4\u63a5\u4fe1\u606f\u3002", (String)"VaBaseSetValidate_07", (String)"wtc-wtabm-opplugin", (Object[])new Object[0]));
            }
        }
        return result;
    }

    private void syncEntryTimeToMain(DynamicObject dynamicObject) {
        DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return;
        }
        List<DynamicObject> dynamicObjects = this.reSort((List<DynamicObject>)collection);
        DynamicObject startEntry = dynamicObjects.get(0);
        DynamicObject endEntry = dynamicObjects.get(collection.size() - 1);
        StartTimeVo startTimeVo = new StartTimeVo(startEntry.getDate("entrystartdate"), startEntry.getString("entrystartmethod"));
        EndTimeVo endTimeVo = new EndTimeVo(endEntry.getDate("entryenddate"), endEntry.getString("entryendmethod"));
        dynamicObject.set("startdatestr", (Object)JSON.toJSONString((Object)startTimeVo));
        dynamicObject.set("enddatestr", (Object)JSON.toJSONString((Object)endTimeVo));
        dynamicObject.set("startdate", (Object)startTimeVo.getMinStartDateTime());
        dynamicObject.set("enddate", (Object)endTimeVo.getMaxEndDateTime());
    }

    private void syncEntryToMain(DynamicObject dynamicObject) {
        DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return;
        }
        String unit = null;
        BigDecimal totalHours = BigDecimal.ZERO;
        BigDecimal totalDays = BigDecimal.ZERO;
        BigDecimal totalValidHours = BigDecimal.ZERO;
        BigDecimal totalValidDays = BigDecimal.ZERO;
        for (DynamicObject row : collection) {
            String entryUnit = row.getString("entryunit");
            totalHours = totalHours.add(row.getBigDecimal("entryvatimehour"));
            totalDays = totalDays.add(row.getBigDecimal("entryvatimeday"));
            totalValidHours = totalValidHours.add(row.getBigDecimal("entryvalidtimehour"));
            totalValidDays = totalValidDays.add(row.getBigDecimal("entryvalidtimeday"));
            if (HRStringUtils.isEmpty(unit)) {
                unit = entryUnit;
                continue;
            }
            if (!StringUtils.equals((CharSequence)BaseSetTimeUnitEnum.DATE.code, (CharSequence)entryUnit)) continue;
            unit = BaseSetTimeUnitEnum.DATE.code;
        }
        dynamicObject.set("vatime", (Object)(StringUtils.equals((CharSequence)BaseSetTimeUnitEnum.DATE.code, unit) ? totalValidDays : totalValidHours));
        dynamicObject.set("applytime", (Object)(StringUtils.equals((CharSequence)BaseSetTimeUnitEnum.DATE.code, unit) ? totalDays : totalHours));
        dynamicObject.set("unit", unit);
        this.syncEntryTimeToMain(dynamicObject);
    }

    private List<DynamicObject> reSort(List<DynamicObject> dynamicObjectList) {
        ArrayList<DynamicObject> collection = new ArrayList<DynamicObject>(dynamicObjectList.size());
        collection.addAll(dynamicObjectList);
        collection.sort((row1, row2) -> {
            Date startOwnDate2;
            String entryStartMethod1 = row1.getString("entrystartmethod");
            String entryStartMethod2 = row2.getString("entrystartmethod");
            Date entryStartDateTime1 = row1.getDate("entrystartdate");
            Date entryStartDateTime2 = row2.getDate("entrystartdate");
            Date startOwnDate1 = StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence)entryStartMethod1) ? row1.getDate("owndate") : entryStartDateTime1;
            Date date = startOwnDate2 = StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence)entryStartMethod2) ? row2.getDate("owndate") : entryStartDateTime2;
            if (DateUtils.isSameDay((Date)startOwnDate1, (Date)startOwnDate2)) {
                if (StringUtils.equals((CharSequence)entryStartMethod1, (CharSequence)WtcTimeRangeBtnTypeEnum.HALF_UP.value)) {
                    return -1;
                }
                if (StringUtils.equals((CharSequence)entryStartMethod1, (CharSequence)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value)) {
                    return 1;
                }
                if (StringUtils.equals((CharSequence)entryStartMethod2, (CharSequence)WtcTimeRangeBtnTypeEnum.HALF_UP.value)) {
                    return 1;
                }
                if (StringUtils.equals((CharSequence)entryStartMethod2, (CharSequence)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value)) {
                    return -1;
                }
                return entryStartDateTime1.after(entryStartDateTime2) ? 1 : -1;
            }
            return startOwnDate1.compareTo(startOwnDate2);
        });
        return collection;
    }

    private boolean checkCoreMust(ExtendedDataEntity dataEntity, DynamicObject dynamicObject) {
        DynamicObject type = dynamicObject.getDynamicObject("entryvacationtype");
        Date startDate = dynamicObject.getDate("entrystartdate");
        Date endDate = dynamicObject.getDate("entryenddate");
        LOG.info("checkCoreMust:type:{}, startDate:{}, endDate:{}", new Object[]{type == null, startDate, endDate});
        boolean result = true;
        if (type == null || (Long)type.getPkValue() == 0L) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4f11\u5047\u7c7b\u578b\u201d\u3002", (String)"VaBaseSetValidate_04", (String)"wtc-wtabm-opplugin", (Object[])new Object[0]));
            result = false;
        }
        if (startDate == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5f00\u59cb\u65e5\u671f\u201d\u3002", (String)"VaBaseSetValidate_05", (String)"wtc-wtabm-opplugin", (Object[])new Object[0]));
            result = false;
        }
        if (endDate == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7ed3\u675f\u65e5\u671f\u201d\u3002", (String)"VaBaseSetValidate_06", (String)"wtc-wtabm-opplugin", (Object[])new Object[0]));
            result = false;
        }
        return result;
    }

    private void checkChangeBill(Set<ExtendedDataEntity> dataEntities) {
        QFilter qFilter;
        String properties;
        HRBaseServiceHelper baseServiceHelper;
        DynamicObject[] parentDyns;
        LOG.info("\u5931\u6548\u7684\u4f11\u5047\u53d8\u66f4\u5355\u63d0\u4ea4\u524d\u6821\u9a8c\u53d8\u66f4\u5f00\u59cb\u3002");
        Map<Long, ExtendedDataEntity> collectedDataEntities = dataEntities.stream().filter(dy -> dy.getDataEntity().getBoolean("ischange") && !dy.getDataEntity().getDataEntityState().getFromDatabase() && dy.getDataEntity().getLong("parentid") != 0L).collect(Collectors.toMap(dynamicObject -> dynamicObject.getDataEntity().getLong("parentid"), dy -> dy, (dy1, dy2) -> dy1));
        if (WTCCollections.isNotEmpty(collectedDataEntities.keySet()) && (parentDyns = (baseServiceHelper = new HRBaseServiceHelper("wtabm_vaapply")).queryOriginalArray(properties = String.join((CharSequence)",", "id", "isnotleave", "ishavechange"), new QFilter[]{qFilter = new QFilter("id", "in", collectedDataEntities.keySet())})) != null && parentDyns.length != 0) {
            for (DynamicObject parentDyn : parentDyns) {
                String message;
                boolean isHaveChange = parentDyn.getBoolean("ishavechange");
                boolean isNotLeave = parentDyn.getBoolean("isnotleave");
                if (isHaveChange) {
                    message = ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u4e0d\u80fd\u518d\u6b21\u53d8\u66f4\u3002", (String)"VaBaseSetValidate_08", (String)"wtc-wtabm-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(collectedDataEntities.get(parentDyn.getLong("id")), message);
                    continue;
                }
                if (!isNotLeave) continue;
                message = ResManager.loadKDString((String)"\u5df2\u9500\u5047\u7684\u6570\u636e\u4e0d\u80fd\u53d8\u66f4\u3002", (String)"VaBaseSetValidate_09", (String)"wtc-wtabm-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(collectedDataEntities.get(parentDyn.getLong("id")), message);
            }
        }
    }
}

