/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.opplugin.web.validate.batchbill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtabm.business.vaapply.batch.BatchVaCheckService;
import kd.wtc.wtabm.common.constants.batch.BatchVaInfoConstants;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.common.bill.batchbill.BatchBillCheckResult;
import kd.wtc.wtbs.common.util.WTCCollections;

public class BatchVaInfoValidator
extends AbstractValidator
implements BatchVaInfoConstants {
    private static final Log LOG = LogFactory.getLog(BatchVaInfoValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        ExtendedDataEntity extendedDataEntity = dataEntities[0];
        this.beginValidate(extendedDataEntity);
    }

    private void beginValidate(ExtendedDataEntity extendedDataEntity) {
        DynamicObject batchVaInfoDyn = extendedDataEntity.getDataEntity();
        OperateOption option = this.getOption();
        DynamicObject mainBillDy = null;
        if (option.containsVariable("parentbillmodel")) {
            String mainBillModelStr = option.getVariableValue("parentbillmodel");
            mainBillDy = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)mainBillModelStr);
        }
        int editRowIndex = -1;
        if (option.containsVariable("entryCurrentRowIndex")) {
            String editRowIndexStr = option.getVariableValue("entryCurrentRowIndex");
            editRowIndex = Integer.parseInt(editRowIndexStr);
        }
        LOG.info("BatchVaInfoValidator.beginValidate editRowIndex:{}", (Object)editRowIndex);
        String appId = BillCommonService.getInstance().getAppIdFromOp(this.getOption());
        String authEntityId = "wtabm_batchvaapply";
        long orgId = batchVaInfoDyn.getLong("org.id");
        long adminOrgId = batchVaInfoDyn.getLong("adminorg.id");
        if (adminOrgId == 0L && mainBillDy != null) {
            adminOrgId = mainBillDy.getLong("adminorg.id");
        }
        LOG.info("BatchVaInfoValidator.beginValidate appId:{},orgId:{},adminOrgId:{}", new Object[]{appId, orgId, adminOrgId});
        BatchVaCheckService vaCheckService = new BatchVaCheckService(appId, authEntityId, orgId, adminOrgId);
        BatchBillCheckResult billCheckResult = vaCheckService.checkBatchVaInfo(batchVaInfoDyn, mainBillDy, editRowIndex, "save");
        List failDataIds = billCheckResult.getFailDataIds();
        ArrayList billDys = (ArrayList)billCheckResult.getData();
        DynamicObjectCollection batchVaInfoEntryDyns = batchVaInfoDyn.getDynamicObjectCollection("entryentity");
        for (int index = 0; index < batchVaInfoEntryDyns.size(); ++index) {
            DynamicObjectCollection entries;
            DynamicObject batchVaInfoEntryDyn = (DynamicObject)batchVaInfoEntryDyns.get(index);
            if (billDys.size() <= index) {
                batchVaInfoEntryDyn.set("checksuccess", (Object)false);
                continue;
            }
            DynamicObject billDy = (DynamicObject)billDys.get(index);
            long pkId = billDy.getLong("id");
            if (failDataIds.contains(pkId)) {
                batchVaInfoEntryDyn.set("checksuccess", (Object)false);
            }
            if (!WTCCollections.isNotEmpty((Collection)(entries = billDy.getDynamicObjectCollection("entryentity")))) continue;
            DynamicObject entry = (DynamicObject)entries.get(0);
            batchVaInfoEntryDyn.set("vatimeday", (Object)entry.getBigDecimal("entryvatimeday"));
            batchVaInfoEntryDyn.set("vatimehour", (Object)entry.getBigDecimal("entryvatimehour"));
            batchVaInfoEntryDyn.set("owndate", (Object)entry.getDate("owndate"));
            batchVaInfoEntryDyn.set("unit", (Object)entry.getString("entryunit"));
        }
        for (String message : billCheckResult.getFailMessages()) {
            this.addErrorMessage(extendedDataEntity, message);
        }
    }
}

