/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.opplugin.web.validate.batchbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.wtc.wtabm.business.vaapply.batch.BatchVaApplyService;
import kd.wtc.wtabm.business.vaapply.batch.BatchVaCheckService;
import kd.wtc.wtabm.common.constants.batch.BatchVaApplyConstants;
import kd.wtc.wtabm.common.constants.batch.BatchVaKDString;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.batchbill.BatchBillUnifyService;
import kd.wtc.wtbs.common.bill.batchbill.BatchBillCheckResult;
import kd.wtc.wtbs.common.lang.WTCBizException;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.wtp.enums.vaplan.BaseSetTimeUnitEnum;

public class BatchVaSaveApplyValidator
extends AbstractValidator
implements BatchVaApplyConstants {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        List successDataEntities = BatchBillUnifyService.getInstance().getSuccessDataEntities(this.getDataEntities(), this.getValidateContext().getValidateResults().getValidateErrors());
        if (WTCCollections.isNotEmpty((Collection)successDataEntities)) {
            this.beginValidate((ExtendedDataEntity)successDataEntities.get(0));
        } else {
            OperateOption option = this.getOption();
            option.setVariableValue("not_check_biz_allfail", "1");
        }
    }

    private void beginValidate(ExtendedDataEntity extendedDataEntity) {
        BatchBillCheckResult billCheckResult;
        DynamicObject batchVaDy = extendedDataEntity.getDataEntity();
        BillResponse billResponse = BatchVaApplyService.INSTANCE.checkDataRule(batchVaDy);
        if (!billResponse.isSuccess()) {
            this.addErrorMessage(extendedDataEntity, billResponse.topErrMsg());
            return;
        }
        OperateOption option = this.getOption();
        boolean isChangeBill = batchVaDy.getBoolean("ischangebill");
        String appId = BillCommonService.getInstance().getAppIdFromOp(option);
        String authEntityId = "wtabm_batchvaapply";
        long orgId = batchVaDy.getLong("org.id");
        long adminOrgId = batchVaDy.getLong("adminorg.id");
        BatchVaCheckService vaCheckService = new BatchVaCheckService(appId, authEntityId, orgId, adminOrgId);
        int editRowIndex = -1;
        if (!isChangeBill) {
            billCheckResult = vaCheckService.checkBatchApply(batchVaDy, this.getOperateKey());
        } else {
            if (option.containsVariable("entryCurrentRowIndex")) {
                String editRowIndexStr = option.getVariableValue("entryCurrentRowIndex");
                editRowIndex = Integer.parseInt(editRowIndexStr);
            }
            String opKey = this.getOperateKey();
            if (editRowIndex > -1) {
                opKey = "save";
            }
            billCheckResult = vaCheckService.checkChange(batchVaDy, editRowIndex, opKey);
        }
        List failDataIds = billCheckResult.getFailDataIds();
        ArrayList billDys = (ArrayList)billCheckResult.getData();
        DynamicObjectCollection batchVaInfoEntryDyns = batchVaDy.getDynamicObjectCollection("entryentity");
        for (int index = 0; index < batchVaInfoEntryDyns.size(); ++index) {
            long billId;
            DynamicObject batchVaInfoEntryDyn = (DynamicObject)batchVaInfoEntryDyns.get(index);
            DynamicObject billDy = null;
            if (editRowIndex >= 0) {
                if (editRowIndex != index || !WTCCollections.isNotEmpty((Collection)billDys)) continue;
                billDy = (DynamicObject)billDys.get(0);
            } else if (WTCCollections.isNotEmpty((Collection)billDys) && billDys.size() > index) {
                billDy = (DynamicObject)billDys.get(index);
            }
            if (billDy == null) {
                throw new WTCBizException(BatchVaKDString.exception());
            }
            if (billDy.getBoolean("isnotleave") || failDataIds.contains(billId = billDy.getLong("id"))) continue;
            DynamicObjectCollection entries = billDy.getDynamicObjectCollection("entryentity");
            DynamicObject entry = (DynamicObject)entries.get(0);
            if (WTCCollections.isEmpty((Collection)entries)) continue;
            String unit = entry.getString("entryunit");
            BigDecimal timeDay = entry.getBigDecimal("entryvatimeday");
            BigDecimal timeHour = entry.getBigDecimal("entryvatimehour");
            batchVaInfoEntryDyn.set("applytime", (Object)(BaseSetTimeUnitEnum.DATE.code.equals(unit) ? timeDay : timeHour));
            batchVaInfoEntryDyn.set("unit", (Object)unit);
            DynamicObjectCollection subEntryEntityColl = batchVaInfoEntryDyn.getDynamicObjectCollection("subentryentity");
            if (!WTCCollections.isNotEmpty((Collection)subEntryEntityColl)) continue;
            DynamicObject subEntryDy = (DynamicObject)subEntryEntityColl.get(0);
            subEntryDy.set("entryvatimeday", (Object)timeDay);
            subEntryDy.set("entryvatimehour", (Object)timeHour);
            subEntryDy.set("owndate", (Object)entry.getDate("owndate"));
            subEntryDy.set("entryunit", (Object)unit);
            subEntryDy.set("specialvatype", entry.get("specialvatype"));
            subEntryDy.set("specialvamethod", entry.get("specialvamethod"));
            subEntryDy.set("specialextjson", entry.get("specialextjson"));
            subEntryDy.set("isdisposable", entry.get("isdisposable"));
        }
        for (String message : billCheckResult.getFailMessages()) {
            this.addErrorMessage(extendedDataEntity, message);
        }
    }
}

