/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.mservice;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtabm.business.helper.VaBillDto;
import kd.sdk.wtc.wtabm.business.helper.VaBillsWithTimeInfoParam;
import kd.wtc.wtabm.business.vaapply.BreastfeedingLeaveService;
import kd.wtc.wtabm.business.vaapply.VaApplyServiceHelper;
import kd.wtc.wtabm.business.vaapply.VaBillTimeService;
import kd.wtc.wtabm.business.vaapply.batch.BatchVaApplyHelper;
import kd.wtc.wtabm.mservice.api.IVaApplyBillService;
import kd.wtc.wtbs.business.auth.WTCBizDataPermissionServiceImpl;
import kd.wtc.wtbs.business.model.EffectiveEntityVo;
import kd.wtc.wtbs.business.model.PersonHasBillVo;
import kd.wtc.wtbs.business.util.ApplyUtil;
import kd.wtc.wtbs.common.enums.bill.va.SpecialVaTypeEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.lang.WTCBizException;
import kd.wtc.wtbs.common.model.bill.BillVo;
import kd.wtc.wtbs.common.model.bill.va.VaBillEntryEntityVo;
import kd.wtc.wtbs.common.model.bill.va.VaBillSubEntryVo;
import kd.wtc.wtbs.common.model.bill.va.VaBillVo;
import kd.wtc.wtbs.common.model.bill.va.rpc.AttFilesVaBillReq;
import kd.wtc.wtbs.common.model.bill.va.rpc.AttPersonVaBillReq;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.ObjectUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtabm.common.entity.VaSubBillInfoEntry;
import kd.wtc.wtbs.wtabm.common.entity.VacationReqDto;
import kd.wtc.wtbs.wtabm.common.entity.VacationRspDto;
import kd.wtc.wtbs.wtp.enums.vaplan.BaseSetTimeBreastDayTypeEnum;
import kd.wtc.wtbs.wtp.enums.vaplan.BaseSetTimeUnitEnum;

public class VaApplyBillServiceImpl
implements IVaApplyBillService {
    private final String CAL_WAY = WTCAppContextHelper.getSysParams().getString("wtc.wtabm.breastfeedingleave.generateway", "1");
    private final List<String> auditingStatusList = Collections.unmodifiableList(Arrays.asList("D", "B", "C"));
    private final HRBaseServiceHelper vaApplyServiceHelper = new HRBaseServiceHelper("wtabm_vaapply");
    private final HRBaseServiceHelper vaDetailServiceHelper = new HRBaseServiceHelper("wtabm_vadetail");
    private final List<String> auditedStatusList = Collections.singletonList("C");
    private static final String VA_BILL_PROPS = String.join((CharSequence)",", "id", "attfile.id", "personid.id", "billno", "ischange", "ishavechange", "attfilebasef7.id", "applytyperadio", "billstatus", "org", "barcode", "inputdevicetype", "isexistsworkflow", "auditstatus", "isneedhand", "handperson", "handreason", "parentid", "submitter", "submitdate", "isnotleave");
    private static final String BILL_COMMON_PROPS = String.join((CharSequence)",", "creator", "modifier", "auditor", "auditdate", "createtime", "modifytime");
    private static final String VA_ENTRY_PROPS = String.join((CharSequence)",", "entryentity.entryvacationtype.id", "entryentity.entrystartdate", "entryentity.entryenddate", "entryentity.entryvatimeday", "entryentity.entryvatimehour", "entryentity.entrystartmethod", "entryentity.entryendmethod", "entryentity.entryunit", "entryentity.entryparentid", "entryentity.specialvatype", "entryentity.specialextjson", "entryentity.isdisposable", "entryentity.specialvamethod", "entryentity.storageto");
    private final Log LOG = LogFactory.getLog(VaApplyBillServiceImpl.class);

    public List<EffectiveEntityVo> getVaApplyBill(Long fileId, Date startDate, Date endDate) {
        endDate = WTCDateUtils.getDayEndTime((Date)endDate);
        HRBaseServiceHelper vaApplyServiceelper = new HRBaseServiceHelper("wtabm_vaapply");
        QFilter filter = new QFilter("attfile.id", "=", (Object)fileId).and("billstatus", "=", (Object)"C").and("isnotleave", "=", (Object)Boolean.FALSE);
        WTCBizDataPermissionServiceImpl wtcBizDataPermissionService = new WTCBizDataPermissionServiceImpl();
        HasPermOrgResult allPermOrgs = wtcBizDataPermissionService.getAllPermOrgs("wtam", "wtabm_vaapply");
        if (!allPermOrgs.hasAllOrgPerm() && allPermOrgs.getHasPermOrgs() != null) {
            filter.and("org", "in", (Object)allPermOrgs.getHasPermOrgs());
        }
        QFilter dateTimeFilter = new QFilter("enddate", ">=", (Object)startDate).and(new QFilter("startdate", "<=", (Object)endDate));
        filter.and(dateTimeFilter);
        String queryFields = "id, billno, ischange, applytyperadio, entryentity.entryvacationtype, entryentity.entrystartdate,entryentity.entryenddate,entryentity.owndate, entryentity.entrystartmethod,entryentity.entryapplytime,entryentity.entryunit,entryentity.entryvatimeday,entryentity.entryvatimehour";
        DynamicObject[] vaapplyDys = vaApplyServiceelper.query(queryFields, new QFilter[]{filter});
        ArrayList<EffectiveEntityVo> effectiveEntityVoList = new ArrayList<EffectiveEntityVo>(10);
        for (DynamicObject vaapplyDy : vaapplyDys) {
            String formId = this.getFormId(vaapplyDy);
            DynamicObjectCollection entryentity = vaapplyDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryentity) {
                Date entryStartDate = dynamicObject.getDate("entrystartdate");
                Date entryEndDate = dynamicObject.getDate("entryenddate");
                boolean entryDateBetween = !entryStartDate.after(endDate) && !entryEndDate.before(startDate);
                if (!entryDateBetween) continue;
                EffectiveEntityVo effectiveEntityVo = new EffectiveEntityVo();
                effectiveEntityVo.setId(Long.valueOf(vaapplyDy.getLong("id")));
                effectiveEntityVo.setBillno(vaapplyDy.getString("billno"));
                effectiveEntityVo.setChildType(dynamicObject.getString("entryvacationtype.name"));
                effectiveEntityVo.setStartDate(dynamicObject.getDate("entrystartdate"));
                effectiveEntityVo.setEndDate(dynamicObject.getDate("entryenddate"));
                effectiveEntityVo.setFormId(formId);
                String unit = dynamicObject.getString("entryunit");
                if (HRStringUtils.equals((String)unit, (String)BaseSetTimeUnitEnum.DATE.code)) {
                    effectiveEntityVo.setApplyTime(dynamicObject.getBigDecimal("entryvatimeday"));
                } else {
                    effectiveEntityVo.setApplyTime(dynamicObject.getBigDecimal("entryvatimehour"));
                }
                effectiveEntityVo.setUnit(unit);
                effectiveEntityVoList.add(effectiveEntityVo);
            }
        }
        effectiveEntityVoList.sort(Comparator.comparing(EffectiveEntityVo::getStartDate));
        return effectiveEntityVoList;
    }

    public Map<Long, Boolean> hasVaBill(List<Long> attfileboIds, Date effectdate) {
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(4);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtabm_vaapply");
        QFilter filter = this.getBillStatusFilter(attfileboIds);
        QFilter startFilter = new QFilter("entryentity.entrystartdate", ">=", (Object)effectdate);
        QFilter endFilter = new QFilter("entryentity.entryenddate", ">=", (Object)effectdate);
        QFilter dateFilter = startFilter.or(endFilter);
        ArrayList startMethodList = Lists.newArrayListWithCapacity((int)16);
        startMethodList.add("1");
        startMethodList.add("2");
        QFilter noCustomFilter = new QFilter("entryentity.entrystartmethod", "in", (Object)startMethodList);
        filter.and(noCustomFilter);
        DynamicObject[] query = helper.query("attfile.id", new QFilter[]{filter.and(dateFilter)});
        List<Long> hasbill = this.getHasBill(attfileboIds, query, effectdate, helper);
        if (!WTCCollections.isEmpty(hasbill)) {
            for (Long attfilebo : attfileboIds) {
                result.put(attfilebo, hasbill.contains(attfilebo));
            }
        }
        return result;
    }

    private List<Long> getHasBill(List<Long> attfileboIds, DynamicObject[] query, Date effectdate, HRBaseServiceHelper helper) {
        ArrayList hasBillList = Lists.newArrayListWithCapacity((int)16);
        QFilter qFilter = this.getBillStatusFilter(attfileboIds);
        DynamicObject[] dynamicObjects = this.getCustomData(qFilter, effectdate, helper);
        if (dynamicObjects != null && dynamicObjects.length != 0) {
            hasBillList.addAll(Arrays.stream(dynamicObjects).map(e -> e.getLong("attfile.id")).collect(Collectors.toList()));
        }
        if (query != null && query.length != 0) {
            hasBillList.addAll(Arrays.stream(query).map(e -> e.getLong("attfile.id")).collect(Collectors.toList()));
        }
        return hasBillList;
    }

    private QFilter getBillStatusFilter(List<Long> attfileboIds) {
        return new QFilter("attfile.id", "in", attfileboIds).and("billstatus", "in", this.auditingStatusList).and("isnotleave", "=", (Object)Boolean.FALSE);
    }

    private DynamicObject[] getCustomData(QFilter qFilter, Date effectdate, HRBaseServiceHelper helper) {
        QFilter ownDateFilter = new QFilter("entryentity.owndate", ">=", (Object)effectdate);
        QFilter customFilter = new QFilter("entryentity.entrystartmethod", "=", (Object)"3");
        qFilter.and(customFilter).and(ownDateFilter);
        return helper.query("attfile.id", new QFilter[]{qFilter});
    }

    public Map<Long, String> getVaApplyBillType(List<Long> billIds) {
        VaApplyServiceHelper vaApplyServiceHelper = (VaApplyServiceHelper)WTCAppContextHelper.getBean(VaApplyServiceHelper.class);
        QFilter filter = new QFilter("id", "in", billIds);
        String params = String.join((CharSequence)",", "ischange", "applytyperadio");
        DynamicObject[] result = vaApplyServiceHelper.query(params, new QFilter[]{filter});
        return Arrays.stream(result).collect(Collectors.toMap(dyn -> dyn.getLong("id"), this::getFormId));
    }

    private String getFormId(DynamicObject billDyn) {
        boolean isChange = billDyn.getBoolean("ischange");
        String applyTypeRadio = billDyn.getString("applytyperadio");
        String formId = null;
        formId = StringUtils.equals((CharSequence)applyTypeRadio, (CharSequence)"0") ? (isChange ? "wtabm_vaupdateself" : "wtabm_vaapplyself") : (isChange ? "wtabm_vaupdate" : "wtabm_vaapply");
        return formId;
    }

    public Map<Long, Boolean> personHasVaBill(List<PersonHasBillVo> personHasBillVoList) {
        Date minDate = null;
        Date maxDate = null;
        for (PersonHasBillVo personHasBillVo : personHasBillVoList) {
            Date startDate = personHasBillVo.getStartDate();
            if (minDate == null || minDate.compareTo(startDate) > 0) {
                minDate = startDate;
            }
            Date endDate = personHasBillVo.getEndDate();
            if (maxDate != null && maxDate.compareTo(endDate) >= 0) continue;
            maxDate = endDate;
        }
        List personIdList = personHasBillVoList.stream().map(PersonHasBillVo::getAttPersonId).collect(Collectors.toList());
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtabm_vaapply");
        QFilter filter = new QFilter("personid.id", "in", personIdList).and("billstatus", "in", this.auditingStatusList).and("isnotleave", "=", (Object)Boolean.FALSE);
        QFilter startFilter = new QFilter("entryentity.entrystartdate", "<=", (Object)maxDate);
        QFilter endFilter = new QFilter("entryentity.entryenddate", ">=", (Object)minDate);
        QFilter dateFilter = startFilter.and(endFilter);
        DynamicObject[] dys = helper.query("personid.id, entryentity.entrystartdate, entryentity.entryenddate", new QFilter[]{filter.and(dateFilter)});
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)dys.length);
        for (DynamicObject dy : dys) {
            long billPersonId = dy.getLong("personid.id");
            for (PersonHasBillVo personHasBillVo : personHasBillVoList) {
                if (personHasBillVo.getAttPersonId() != billPersonId || personHasBillVo.getStartDate() == null || personHasBillVo.getEndDate() == null) continue;
                DynamicObjectCollection entryDys = dy.getDynamicObjectCollection("entryentity");
                for (DynamicObject entryDy : entryDys) {
                    Date billStartDate = entryDy.getDate("entrystartdate");
                    Date billEndDate = entryDy.getDate("entryenddate");
                    if (personHasBillVo.getEndDate().compareTo(billStartDate) < 0 || personHasBillVo.getStartDate().compareTo(billEndDate) > 0) continue;
                    resultMap.put(personHasBillVo.getId(), Boolean.TRUE);
                }
            }
        }
        return resultMap;
    }

    public Map<Long, List<VaBillVo>> getVaBillsByAttPersons(List<AttPersonVaBillReq> attFileReq) {
        VaApplyServiceHelper vaApplyServiceHelper = (VaApplyServiceHelper)WTCAppContextHelper.getBean(VaApplyServiceHelper.class);
        QFilter qFilter = new QFilter("billstatus", "in", this.auditingStatusList).and("isnotleave", "=", (Object)Boolean.FALSE);
        ArrayList dynList = Lists.newArrayListWithCapacity((int)attFileReq.size());
        Date startDate = null;
        Date endDate = null;
        HashSet personIds = Sets.newHashSetWithExpectedSize((int)attFileReq.size());
        for (AttPersonVaBillReq req : attFileReq) {
            personIds.add(req.getAttPersonId());
            if (startDate == null || startDate.after(req.getStartDate())) {
                startDate = req.getStartDate();
            }
            if (endDate != null && !endDate.before(req.getEndDate())) continue;
            endDate = req.getEndDate();
        }
        ArrayList personList = Lists.newArrayList((Iterable)personIds);
        QFilter filter = new QFilter("enddate", ">=", startDate).and("startdate", "<=", endDate).and("entryentity.entryenddate", ">=", (Object)startDate).and("entryentity.entrystartdate", "<=", (Object)endDate).and("personid.id", "in", (Object)personList);
        DynamicObject[] result = vaApplyServiceHelper.loadDynamicObjectArray(new QFilter[]{qFilter, filter});
        dynList.addAll(Arrays.asList(result));
        Set mids = Arrays.stream(result).map(item -> item.getLong("mid")).collect(Collectors.toSet());
        String queryProp = "id,billno";
        Map batchVaMap = BatchVaApplyHelper.INSTANCE.queryBatchVaBillByIds(mids, queryProp);
        Map<Long, List<DynamicObject>> grouping = dynList.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong("personid.id")));
        HashMap vaBillVoMap = Maps.newHashMapWithExpectedSize((int)16);
        Set attFileBoIdSet = WTCCollections.modifiableEmptySet();
        Date minBeginDate = null;
        Date maxEndDate = null;
        List resetSubEntryVoList = WTCCollections.modifiableEmptyList();
        for (Map.Entry<Long, List<DynamicObject>> mapEntry : grouping.entrySet()) {
            long personId = mapEntry.getKey();
            List<DynamicObject> billDyns = mapEntry.getValue();
            ArrayList vaBillVos = Lists.newArrayListWithExpectedSize((int)billDyns.size());
            vaBillVoMap.put(personId, vaBillVos);
            billDyns.stream().sorted((c1, c2) -> c2.getDate("createtime").compareTo(c1.getDate("createtime")));
            for (DynamicObject billDyn : billDyns) {
                VaBillVo billVo = new VaBillVo();
                vaBillVos.add(billVo);
                ArrayList<VaBillEntryEntityVo> entryVos = new ArrayList<VaBillEntryEntityVo>(10);
                billVo.setBillNo(billDyn.getString("billno")).setAttPersonId(personId).setAttFileBoId(billDyn.getLong("attfile.id")).setAttFileVid(billDyn.getLong("attfilebasef7.id")).setParentId(billDyn.getLong("parentid"));
                billVo.setEntryEntities(entryVos);
                DynamicObjectCollection entryEntities = billDyn.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryEntities) {
                    long spVaMethodId;
                    VaBillEntryEntityVo entityVo = new VaBillEntryEntityVo();
                    entryVos.add(entityVo);
                    long mid = billDyn.getLong("mid");
                    DynamicObject batchBill = (DynamicObject)batchVaMap.get(mid);
                    entityVo.setBatchBillDy(batchBill);
                    entityVo.setSpecialVaType(entry.getString("specialvatype"));
                    entityVo.setSpVaMethodId(entry.getLong("specialvamethod.id"));
                    entityVo.setStartDate(entry.getDate("entrystartdate"));
                    entityVo.setEndDate(entry.getDate("entryenddate"));
                    entityVo.setStartMethod(entry.getString("entrystartmethod"));
                    entityVo.setEndMethod(entry.getString("entryendmethod"));
                    entityVo.setAttFileBoid(billDyn.getLong("attfile.id"));
                    entityVo.setStorageTo(entry.getDate("storageto"));
                    entityVo.setSpecialExtJson(entry.getString("specialextjson"));
                    DynamicObjectCollection vadetailentries = entry.getDynamicObjectCollection("vadetailentry");
                    ArrayList subEntryVos = Lists.newArrayList();
                    entityVo.setVaSubEntryVoList((List)subEntryVos);
                    if (!CollectionUtils.isNotEmpty((Collection)vadetailentries)) continue;
                    if ((WTCStringUtils.equals((String)this.CAL_WAY, (String)"1") || WTCStringUtils.equals((String)this.CAL_WAY, (String)"2")) && ((spVaMethodId = entityVo.getSpVaMethodId()) == BaseSetTimeBreastDayTypeEnum.COME_LATE.id || spVaMethodId == BaseSetTimeBreastDayTypeEnum.GO_EARLY.id)) {
                        attFileBoIdSet.add(entityVo.getAttFileBoid());
                        minBeginDate = minBeginDate == null ? entityVo.getStartDate() : WTCDateUtils.getMinDate((Date)minBeginDate, (Date)entityVo.getStartDate());
                        maxEndDate = maxEndDate == null ? entityVo.getEndDate() : WTCDateUtils.getMaxDate((Date)maxEndDate, (Date)entityVo.getEndDate());
                        resetSubEntryVoList.add(entityVo);
                    }
                    for (DynamicObject vaDetailEntry : vadetailentries) {
                        VaBillSubEntryVo subEntryVo = new VaBillSubEntryVo();
                        subEntryVo.setStartDateTime(vaDetailEntry.getDate("vaentrystarttime")).setEndDateTime(vaDetailEntry.getDate("vaentryendtime")).setVaEntryDate(vaDetailEntry.getDate("vaentrydate")).setDetailId(((Long)vaDetailEntry.getPkValue()).longValue());
                        subEntryVos.add(subEntryVo);
                    }
                }
            }
        }
        if (WTCCollections.isNotEmpty((Collection)attFileBoIdSet)) {
            DutyShiftResponse shiftResponse = ApplyUtil.getShift((List)Lists.newArrayList((Iterable)attFileBoIdSet), minBeginDate, maxEndDate);
            for (VaBillEntryEntityVo vaBillEntryEntityVo : resetSubEntryVoList) {
                List subEntryVos = BreastfeedingLeaveService.generateBreastfeedingTimeRange((VaBillEntryEntityVo)vaBillEntryEntityVo, (DutyShiftResponse)shiftResponse);
                vaBillEntryEntityVo.setVaSubEntryVoList(subEntryVos);
            }
        }
        return vaBillVoMap;
    }

    public List<VacationRspDto> getVaBillInfoByAttPersons(VacationReqDto vacationReqDto) {
        ArrayList billInfoList = Lists.newArrayListWithExpectedSize((int)16);
        this.LOG.info("input param vacationReqDto:{}", (Object)vacationReqDto);
        Date endDate = vacationReqDto.getEndDate();
        if (endDate == null) {
            return billInfoList;
        }
        Date startDate = vacationReqDto.getStartDate();
        if (startDate == null) {
            return billInfoList;
        }
        List personList = vacationReqDto.getPersonList();
        if (WTCCollections.isEmpty((Collection)personList)) {
            return billInfoList;
        }
        DynamicObject[] dynamicObjects = this.queryVaInfo(startDate, endDate, personList);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return billInfoList;
        }
        Map<Long, List<DynamicObject>> vaDynamicMap = this.queryVaDetailInfo(dynamicObjects);
        for (DynamicObject billDyn : dynamicObjects) {
            Long personId = billDyn.getLong("personid.id");
            VacationRspDto vaBillInfoEntry = new VacationRspDto();
            vaBillInfoEntry.setPersonId(personId);
            vaBillInfoEntry.setBillId(Long.valueOf(billDyn.getLong("id")));
            vaBillInfoEntry.setBillNo(billDyn.getString("billno"));
            vaBillInfoEntry.setStartDate(billDyn.getDate("entryentity.entrystartdate"));
            vaBillInfoEntry.setEndDate(billDyn.getDate("entryentity.entryenddate"));
            vaBillInfoEntry.setStartMethod(billDyn.getString("entryentity.entrystartmethod"));
            vaBillInfoEntry.setEndMethod(billDyn.getString("entryentity.entryendmethod"));
            Long entryId = billDyn.getLong("entryentity.id");
            vaBillInfoEntry.setEntryId(entryId);
            List<DynamicObject> dynamicObjectList = vaDynamicMap.get(entryId);
            if (!WTCCollections.isEmpty(dynamicObjectList)) {
                ArrayList subBillInfoList = Lists.newArrayListWithExpectedSize((int)16);
                for (DynamicObject subDy : dynamicObjectList) {
                    VaSubBillInfoEntry subVaBillInfoEntry = new VaSubBillInfoEntry();
                    subVaBillInfoEntry.setStartDate(subDy.getDate("vaentrystarttime"));
                    subVaBillInfoEntry.setEndDate(subDy.getDate("vaentryendtime"));
                    subBillInfoList.add(subVaBillInfoEntry);
                }
                vaBillInfoEntry.setVaSubBillInfoEntryList((List)subBillInfoList);
            }
            billInfoList.add(vaBillInfoEntry);
        }
        this.LOG.info("out param billInfoList:{}", (Object)billInfoList);
        return billInfoList;
    }

    private DynamicObject[] queryVaInfo(Date startDate, Date endDate, List<Long> personIdList) {
        String selectProps = "createtime, personid.id, id, billno, entryentity.specialvatype, entryentity.id, entryentity.entryvacationtype, entryentity.entrystartdate,entryentity.entryenddate, entryentity.entrystartmethod, entryentity.entryendmethod, entryentity.entryunit,entryentity.entryvatimeday, entryentity.entryvatimehour";
        QFilter dateTimeFilter = new QFilter("enddate", ">=", (Object)startDate).and(new QFilter("startdate", "<", (Object)endDate));
        QFilter billStatusFilter = new QFilter("billstatus", "in", this.auditingStatusList).and("isnotleave", "=", (Object)Boolean.FALSE);
        HashSet personIdSet = Sets.newHashSetWithExpectedSize((int)personIdList.size());
        personIdSet.addAll(personIdList);
        QFilter personIdFilter = new QFilter("personid", "in", (Object)personIdSet);
        return this.vaApplyServiceHelper.queryOriginalArray(selectProps, new QFilter[]{dateTimeFilter, billStatusFilter, personIdFilter});
    }

    private Map<Long, List<DynamicObject>> queryVaDetailInfo(DynamicObject[] dynamicObjects) {
        QFilter entryIdFilter;
        String selectSpecaliProps;
        DynamicObject[] vaDynamicObjects;
        List entryIdList = Arrays.asList(dynamicObjects).stream().filter(entry -> HRStringUtils.equals((String)entry.getString("entryentity.specialvatype"), (String)"A")).map(ob -> ob.getLong("entryentity.id")).collect(Collectors.toList());
        HashMap vaDynamicMap = Maps.newHashMapWithExpectedSize((int)16);
        if (WTCCollections.isNotEmpty(entryIdList) && (vaDynamicObjects = this.vaDetailServiceHelper.queryOriginalArray(selectSpecaliProps = "entryid, vaentrystarttime, vaentryendtime, vaentryapplytimehour, vaentryapplytimeday, unit", new QFilter[]{entryIdFilter = new QFilter("entryid", "in", entryIdList)})) != null && vaDynamicObjects.length != 0) {
            for (DynamicObject dynamicObject : vaDynamicObjects) {
                List dynamicObjectList = vaDynamicMap.computeIfAbsent(dynamicObject.getLong("entryid"), key -> new ArrayList());
                dynamicObjectList.add(dynamicObject);
            }
        }
        return vaDynamicMap;
    }

    public List<VaBillDto> getVaBillsWithTime(VaBillsWithTimeInfoParam attReq) {
        VaBillTimeService vaBillTimeService = (VaBillTimeService)WTCAppContextHelper.getBean(VaBillTimeService.class);
        return vaBillTimeService.getVaBills(attReq);
    }

    public Map<Long, List<VaBillVo>> getVaBillInfoByAttFileBoids(AttFilesVaBillReq requestParam) {
        Date startDate = requestParam.getStartDate();
        Date endDate = requestParam.getEndDate();
        if (CollectionUtils.isEmpty((Collection)requestParam.getAttFileBoIds()) || ObjectUtils.anyNull((Object[])new Object[]{startDate, endDate, requestParam.getBillStateEnum()})) {
            this.LOG.warn("requestParam \u53c2\u6570\u4e0d\u5408\u6cd5\uff01{}", (Object)JSON.toJSONString((Object)requestParam));
            throw new WTCBizException("requestParam param err.");
        }
        startDate = WTCDateUtils.addDays((Date)startDate, (int)-1);
        endDate = WTCDateUtils.addDays((Date)endDate, (int)1);
        String props = String.join((CharSequence)",", VA_BILL_PROPS, BILL_COMMON_PROPS, VA_ENTRY_PROPS);
        QFilter dateTimeFilter = new QFilter("enddate", ">=", (Object)startDate).and(new QFilter("startdate", "<", (Object)endDate));
        List<String> billStatusList = this.auditingStatusList;
        if (requestParam.getBillStateEnum() == AttFilesVaBillReq.BILL_STATE.VALIDATED) {
            billStatusList = this.auditedStatusList;
        }
        QFilter billStatusFilter = new QFilter("billstatus", "in", billStatusList).and("isnotleave", "=", (Object)Boolean.FALSE);
        QFilter attFileBoFilter = new QFilter("attfile", "in", (Object)requestParam.getAttFileBoIds());
        DynamicObject[] vaBillDyns = this.vaApplyServiceHelper.query(props, new QFilter[]{dateTimeFilter, billStatusFilter, attFileBoFilter});
        List<VaBillVo> vaBillVos = this.convertToVo(vaBillDyns);
        Map<Long, List<VaBillVo>> vaBillVoMap = vaBillVos.stream().collect(Collectors.groupingBy(BillVo::getAttFileBoId));
        return vaBillVoMap;
    }

    private List<VaBillVo> convertToVo(DynamicObject[] dyns) {
        long spVaMethodId;
        ArrayList vaBillVos = Lists.newArrayListWithExpectedSize((int)dyns.length);
        HashMap vaBillEntryMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList lactationEntryIds = Lists.newArrayListWithExpectedSize((int)10);
        Date minBeginDate = null;
        Date maxEndDate = null;
        List attFileBoIdList = WTCCollections.modifiableEmptyList();
        for (DynamicObject dyn : dyns) {
            VaBillVo vaBillVo = new VaBillVo();
            vaBillVo.setId(dyn.getLong("id"));
            vaBillVo.setBillNo(dyn.getString("billno"));
            vaBillVo.setAttPersonId(dyn.getLong("personid.id"));
            vaBillVo.setParentId(dyn.getLong("parentid"));
            vaBillVo.setAttFileBoId(dyn.getLong("attfile.id"));
            vaBillVo.setAttFileVid(dyn.getLong("attfilebasef7.id"));
            DynamicObjectCollection entryEntities = dyn.getDynamicObjectCollection("entryentity");
            ArrayList entities = Lists.newArrayListWithCapacity((int)entryEntities.size());
            vaBillVo.setEntryEntities((List)entities);
            for (DynamicObject entryEntity : entryEntities) {
                VaBillEntryEntityVo vaBillEntryEntityVo = new VaBillEntryEntityVo();
                vaBillEntryEntityVo.setBillNo(vaBillVo.getBillNo());
                vaBillEntryEntityVo.setAttFileBoid(vaBillVo.getAttFileBoId());
                this.convertToEntryVo(entryEntity, vaBillEntryEntityVo, lactationEntryIds);
                String specialVaType = vaBillEntryEntityVo.getSpecialVaType();
                if (StringUtils.equals((CharSequence)SpecialVaTypeEnum.LACTATION_TYPE.vaType, (CharSequence)specialVaType) && (WTCStringUtils.equals((String)this.CAL_WAY, (String)"1") || WTCStringUtils.equals((String)this.CAL_WAY, (String)"2")) && ((spVaMethodId = vaBillEntryEntityVo.getSpVaMethodId()) == BaseSetTimeBreastDayTypeEnum.COME_LATE.id || spVaMethodId == BaseSetTimeBreastDayTypeEnum.GO_EARLY.id)) {
                    minBeginDate = minBeginDate == null ? vaBillEntryEntityVo.getStartDate() : WTCDateUtils.getMinDate((Date)minBeginDate, (Date)vaBillEntryEntityVo.getStartDate());
                    maxEndDate = maxEndDate == null ? vaBillEntryEntityVo.getEndDate() : WTCDateUtils.getMaxDate((Date)maxEndDate, (Date)vaBillEntryEntityVo.getEndDate());
                    attFileBoIdList.add(vaBillEntryEntityVo.getAttFileBoid());
                }
                vaBillEntryMap.put(vaBillEntryEntityVo.getId(), vaBillEntryEntityVo);
                entities.add(vaBillEntryEntityVo);
            }
            vaBillVos.add(vaBillVo);
        }
        if (CollectionUtils.isNotEmpty((Collection)lactationEntryIds)) {
            DynamicObject[] vaDynamicObjects;
            DutyShiftResponse shiftResponse = null;
            if (StringUtils.equalsAny((CharSequence)this.CAL_WAY, (CharSequence[])new CharSequence[]{"1", "2"})) {
                shiftResponse = ApplyUtil.getShift((List)attFileBoIdList, minBeginDate, maxEndDate);
            }
            QFilter entryIdFilter = new QFilter("entryid", "in", (Object)lactationEntryIds);
            String selectSpecaliProps = "id, entryid, vaentrydate, vaentrystarttime, vaentryendtime, vaentryapplytimehour, vaentryapplytimeday, unit";
            for (DynamicObject dyn : vaDynamicObjects = this.vaDetailServiceHelper.queryOriginalArray(selectSpecaliProps, new QFilter[]{entryIdFilter})) {
                VaBillEntryEntityVo vaBillEntryEntityVo = (VaBillEntryEntityVo)vaBillEntryMap.get(dyn.getLong("entryid"));
                VaBillSubEntryVo subEntryVo = new VaBillSubEntryVo();
                this.convertToSubEntryVo(vaBillEntryEntityVo, dyn, subEntryVo);
                if (vaBillEntryEntityVo == null) continue;
                List vaSubEntryVoList = vaBillEntryEntityVo.getVaSubEntryVoList();
                vaSubEntryVoList.add(subEntryVo);
                spVaMethodId = vaBillEntryEntityVo.getSpVaMethodId();
                if (BaseSetTimeBreastDayTypeEnum.COME_LATE.id != spVaMethodId && BaseSetTimeBreastDayTypeEnum.GO_EARLY.id != spVaMethodId) continue;
                List subEntryVos = BreastfeedingLeaveService.generateBreastfeedingTimeRange((VaBillEntryEntityVo)vaBillEntryEntityVo, (DutyShiftResponse)shiftResponse);
                vaBillEntryEntityVo.setVaSubEntryVoList(subEntryVos);
            }
        }
        return vaBillVos;
    }

    private void convertToEntryVo(DynamicObject entryDyn, VaBillEntryEntityVo vo, List<Long> lactationEntryIds) {
        vo.setId(entryDyn.getLong("id"));
        vo.setStartMethod(entryDyn.getString("entrystartmethod"));
        vo.setEndMethod(entryDyn.getString("entryendmethod"));
        vo.setStartDate(entryDyn.getDate("entrystartdate"));
        vo.setEndDate(entryDyn.getDate("entryenddate"));
        vo.setSpVaMethodId(entryDyn.getLong("specialvamethod.id"));
        String specialVaType = entryDyn.getString("specialvatype");
        vo.setSpecialExtJson(entryDyn.getString("specialextjson"));
        vo.setSpecialVaType(specialVaType);
        if (StringUtils.equals((CharSequence)SpecialVaTypeEnum.LACTATION_TYPE.vaType, (CharSequence)specialVaType)) {
            vo.setStorageTo(entryDyn.getDate("storageto"));
            lactationEntryIds.add(vo.getId());
        }
    }

    private void convertToSubEntryVo(VaBillEntryEntityVo vaBillEntryEntityVo, DynamicObject dyn, VaBillSubEntryVo subEntryVo) {
        subEntryVo.setDetailId(dyn.getLong("id"));
        subEntryVo.setEntryId(dyn.getLong("entryid"));
        subEntryVo.setVaEntryDate(dyn.getDate("vaentrydate"));
        subEntryVo.setStartDateTime(dyn.getDate("vaentrystarttime"));
        subEntryVo.setEndDateTime(dyn.getDate("vaentryendtime"));
    }
}

