/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.mservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtabm.business.vaapply.VaBillUnifyQueryService;
import kd.wtc.wtabm.mservice.api.IVaBatchBillService;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.common.bill.BillPermQueryParam;
import kd.wtc.wtbs.common.bill.VaBatchBillQueryParam;
import kd.wtc.wtbs.common.bill.VaBillQueryParam;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class VaBatchBillService
implements IVaBatchBillService {
    private static final Log LOG = LogFactory.getLog(VaBatchBillService.class);

    public List<DynamicObject> defaultQuery(VaBatchBillQueryParam param) {
        if (param == null || param.getSingleQueryParam() == null) {
            return Collections.emptyList();
        }
        List<DynamicObject> singleVaDyList = this.getSingleVaDy(param);
        if (WTCCollections.isEmpty(singleVaDyList)) {
            return Collections.emptyList();
        }
        Set<Long> batchIds = singleVaDyList.stream().map(bi -> bi.getLong("mid")).collect(Collectors.toSet());
        return this.getBatchDyById(batchIds, param.getBillPermQueryParam());
    }

    private List<DynamicObject> getSingleVaDy(VaBatchBillQueryParam param) {
        if (param == null || param.getSingleQueryParam() == null) {
            return Collections.emptyList();
        }
        VaBillQueryParam singleQueryParam = param.getSingleQueryParam();
        singleQueryParam.setApplyTypeVal((List)Lists.newArrayList((Object[])new String[]{BillApplyTypeEnum.BATCH.getCode()}));
        singleQueryParam.setBillPermQueryParam(null);
        return new VaBillUnifyQueryService(singleQueryParam).getBillOfDefault();
    }

    private List<DynamicObject> getBatchDyById(Set<Long> batchIds, BillPermQueryParam billPermQueryParam) {
        QFilter idQFilter;
        Object[] dynamicObjects;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtabm_batchvaapply");
        QFilter billPermQFilter = new QFilter("id", "!=", (Object)0L);
        if (billPermQueryParam != null) {
            BillCommonService billCommonService = new BillCommonService();
            billPermQFilter = billCommonService.getBillPermQFilter(billPermQueryParam.getUserId().longValue(), billPermQueryParam.getAppNumber(), billPermQueryParam.getEntityNumber(), billPermQueryParam.getOrgKey(), billPermQueryParam.getPerm(), billPermQueryParam.getCustomParam());
        }
        if ((dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{idQFilter = new QFilter("id", "in", batchIds), billPermQFilter})) == null || dynamicObjects.length == 0) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])dynamicObjects);
    }

    public List<DynamicObject> queryRealTimeByDutyDate(VaBatchBillQueryParam batchBillQueryParam) {
        boolean unPassDateCheck;
        if (batchBillQueryParam == null || batchBillQueryParam.getSingleQueryParam() == null) {
            return Collections.emptyList();
        }
        VaBillQueryParam param = batchBillQueryParam.getSingleQueryParam();
        if (param.getStartDate() == null || param.getEndDate() == null) {
            return this.defaultQuery(batchBillQueryParam);
        }
        boolean bl = unPassDateCheck = param.getStartDate() != null && param.getEndDate() == null || param.getEndDate() != null && param.getStartDate() == null;
        if (unPassDateCheck) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0e\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5176\u4e2d\u4e00\u4e2a\u4e3a\u7a7a\u3002", (String)"VaBillService_0", (String)"wtc-wtabm-mservice", (Object[])new Object[0]));
        }
        Date startDate = param.getStartDate();
        Date endDate = param.getEndDate();
        param.setStartDate(WTCDateUtils.addDays((Date)startDate, (int)-2));
        param.setEndDate(WTCDateUtils.addDays((Date)endDate, (int)2));
        String properties = param.getProperties();
        if (HRStringUtils.isNotEmpty((String)properties)) {
            String newProperties = WTCStringUtils.joinOnComma((String[])new String[]{properties, "attfile", "entryentity", "entryentity.entrystartdate", "entryentity.entryenddate", "entryentity.specialvatype", "entryentity.specialvamethod", "entryentity.entrystartmethod", "entryentity.vadetailentry", "vadetailentry.vaentrystarttime", "vadetailentry.vaentryendtime"});
            Object[] split = newProperties.split(",");
            HashSet newPropertiesSet = Sets.newHashSet((Object[])split);
            param.setProperties(String.join((CharSequence)",", newPropertiesSet));
            param.setQueryOriginal(false);
        }
        List<DynamicObject> billOfDefault = this.getSingleVaDy(batchBillQueryParam);
        LOG.info("VaBatchBillService_queryRealTimeByDutyDate default.size = {}", (Object)billOfDefault.size());
        VaBillUnifyQueryService vaBillUnifyQueryService = new VaBillUnifyQueryService(param);
        List afterFilterDy = vaBillUnifyQueryService.filterRealTimeByDutyDate(billOfDefault, WTCDateUtils.toLocalDate((Date)startDate), WTCDateUtils.toLocalDate((Date)endDate));
        LOG.info("VaBatchBillService_queryRealTimeByDutyDate afterFilterDy.size = {}", (Object)afterFilterDy.size());
        Set<Long> batchIds = afterFilterDy.stream().map(bi -> bi.getLong("mid")).collect(Collectors.toSet());
        List<DynamicObject> batchDyAfterPerm = this.getBatchDyById(batchIds, batchBillQueryParam.getBillPermQueryParam());
        LOG.info("VaBatchBillService_queryRealTimeByDutyDate batchDyAfterPerm.size = {}", (Object)batchDyAfterPerm.size());
        param.setStartDate(startDate);
        param.setEndDate(endDate);
        return batchDyAfterPerm;
    }

    public BillPermQueryParam getDefaultPerm() {
        return new BillPermQueryParam(Long.valueOf(RequestContext.get().getCurrUserId()), "wtam", "wtabm_batchvaapply", "org", "47150e89000000ac", Collections.emptyMap());
    }
}

