/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.mservice.openapi.vaapply;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.Valid;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiErrorCode;
import kd.bos.openapi.common.custom.annotation.ApiErrorCodes;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtabm.business.vaapply.VaKDStringHelper;
import kd.wtc.wtabm.mservice.openapi.vaapply.VaApplyBillEntryModel;
import kd.wtc.wtabm.mservice.openapi.vaapply.VaApplyBillReqModel;
import kd.wtc.wtabm.mservice.openapi.vaapply.VaApplyBillRespModel;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.DateUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

@ApiController(desc="VaApply OpenApi", value="VaApply OpenApi")
@ApiMapping(value="/vaapply")
@ApiErrorCodes(value={@ApiErrorCode(code="0-999", desc="api system error"), @ApiErrorCode(code="10000-99999", desc="BOS\u5e73\u53f0\u5f02\u5e38"), @ApiErrorCode(code="wtabm.100001", desc="\u5165\u53c2\u4e0d\u5408\u6cd5\u3002"), @ApiErrorCode(code="wtabm.100002", desc="\u7cfb\u7edf\u5185\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u57fa\u7840\u8d44\u6599\u3002"), @ApiErrorCode(code="wtabm.100003", desc="\u4e1a\u52a1\u6570\u636e\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002")})
public class VaApplyOtherBillOpenApi
implements Serializable {
    private static final long serialVersionUID = -2336074825757854621L;
    private static final Log LOG = LogFactory.getLog(VaApplyOtherBillOpenApi.class);
    private static final int MAX_BILL_SIZE = 50;
    private static final int ONE_BILL_MAX_ENTRY_SIZE = 10;
    private static final String DATE_PATTERN = "\\d{4}?-([0][1-9]|1[0-2])-\\d{2}?";
    private static final String DATETIME_PATTERN = "\\d{4}?-([0][1-9]|1[0-2])-\\d{2}? ([01][0-9]|2[0-3]):[0-5][0-9]";

    @ApiPostMapping(desc="vaApplyOtherBill", value="/vaApplyOtherBill")
    public CustomApiResult<List<VaApplyBillRespModel>> vaApplyOtherBill(@ApiParam(value="\u8bf7\u6c42\u53c2\u6570") @Valid @ApiParam(value="\u8bf7\u6c42\u53c2\u6570") @Valid ArrayList<VaApplyBillReqModel> request) {
        ArrayList<VaApplyBillRespModel> res;
        LOG.info("\u3010\u4f11\u5047OPENAPI\u3011\u8c03\u7528\u5f00\u59cb\uff0c\u7533\u8bf7\u4fe1\u606f\uff1a{}", (Object)request.size());
        if (request.isEmpty()) {
            return CustomApiResult.success(new LinkedList());
        }
        if (request.size() > 50) {
            String errorMsg = ResManager.loadKDString((String)"1\u6b21\u63a5\u53e3\u8c03\u7528\u4e0d\u80fd\u4f20\u5165\u8d85\u8fc7{0}\u4e2a{1}\u5355\u3002", (String)"VaApplyOtherBillOpenApi_1", (String)"wtc-wtabm-mservice", (Object[])new Object[]{50, BillTypeEnum.VACATIONBILL.getBillName()});
            return CustomApiResult.fail((String)"wtabm.100001", (String)errorMsg);
        }
        HashMap<Integer, String> errorMap = new HashMap<Integer, String>(16);
        Map<Integer, DynamicObject> legalBillMap = this.checkParamAndGetSuccessInfo(request, errorMap);
        DynamicObject[] billArr = new DynamicObject[legalBillMap.size()];
        HashMap<Object, Integer> pk2ReqIndexMap = new HashMap<Object, Integer>(legalBillMap.size());
        int arrIdx = 0;
        for (Map.Entry<Integer, DynamicObject> entry : legalBillMap.entrySet()) {
            pk2ReqIndexMap.put(entry.getValue().get("id"), entry.getKey());
            billArr[arrIdx++] = entry.getValue();
        }
        if (billArr.length > 0) {
            this.handleTx(billArr, pk2ReqIndexMap, errorMap);
        }
        if (errorMap.isEmpty()) {
            res = new ArrayList<VaApplyBillRespModel>(request.size());
            for (int index = 0; index < request.size(); ++index) {
                VaApplyBillRespModel billRes = new VaApplyBillRespModel();
                billRes.setIndex(index);
                billRes.setBillNo(legalBillMap.get(index).getString("billno"));
                res.add(billRes);
            }
            return CustomApiResult.success(res);
        }
        res = new ArrayList(request.size());
        for (int index = 0; index < request.size(); ++index) {
            VaApplyBillRespModel billRes = new VaApplyBillRespModel();
            billRes.setIndex(index + 1);
            String errMsg = (String)errorMap.get(index);
            if (errMsg != null) {
                billRes.setErrMsg(errMsg);
            }
            res.add(billRes);
        }
        CustomApiResult customApiResult = new CustomApiResult();
        customApiResult.setStatus(false);
        customApiResult.setErrorCode("wtabm.100003");
        customApiResult.setData(res);
        return customApiResult;
    }

    private Map<Integer, DynamicObject> checkParamAndGetSuccessInfo(ArrayList<VaApplyBillReqModel> billList, Map<Integer, String> errorMap) {
        DynamicObject[] arr;
        HashSet occurBillNoSet = Sets.newHashSetWithExpectedSize((int)billList.size());
        HashMap billNo2ReqIdxMap = Maps.newHashMapWithExpectedSize((int)billList.size());
        HashSet attFileNumberSet = Sets.newHashSetWithExpectedSize((int)billList.size());
        HashSet orgNumberSet = Sets.newHashSetWithExpectedSize((int)billList.size());
        HashSet vaTypeNumberSet = Sets.newHashSetWithExpectedSize((int)billList.size());
        for (int reqIndex = 0; reqIndex < billList.size(); ++reqIndex) {
            VaApplyBillReqModel bill = billList.get(reqIndex);
            if (errorMap.containsKey(reqIndex)) continue;
            if (WTCStringUtils.isNotEmpty((String)bill.getBillNo()) && !occurBillNoSet.add(bill.getBillNo())) {
                errorMap.put(reqIndex, ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u201c%s\u201d\u91cd\u590d\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"VaApplyOtherBillOpenApi_2", (String)"wtc-wtabm-mservice", (Object[])new Object[]{bill.getBillNo()}));
                continue;
            }
            if (WTCCollections.isEmpty(bill.getEntryEntity())) {
                errorMap.put(reqIndex, ResManager.loadKDString((String)"\u201c{0}\u4fe1\u606f\u201d\u4e3a\u5fc5\u586b\u9879\u3002", (String)"VaApplyOtherBillOpenApi_3", (String)"wtc-wtabm-mservice", (Object[])new Object[]{BillTypeEnum.VACATIONBILL.getBillName()}));
                continue;
            }
            if (bill.getEntryEntity().size() > 10) {
                errorMap.put(reqIndex, ResManager.loadKDString((String)"1\u4e2a{0}\u5355\u6700\u591a\u5141\u8bb8\u4e0a\u4f20{1}\u6761\u5206\u5f55\u3002", (String)"VaApplyOtherBillOpenApi_4", (String)"wtc-wtabm-mservice", (Object[])new Object[]{BillTypeEnum.VACATIONBILL.getBillName(), 10}));
                continue;
            }
            boolean billEntryCheckFail = false;
            for (VaApplyBillEntryModel billEntry : bill.getEntryEntity()) {
                if (HRStringUtils.isBlank((CharSequence)billEntry.getVacationType())) {
                    billEntryCheckFail = true;
                    errorMap.put(reqIndex, ResManager.loadKDString((String)"\u53c2\u6570\u201cvacationType\u201d\u5fc5\u586b\uff0c\u8bf7\u586b\u5199\u3002", (String)"VaApplyOtherBillOpenApi_25", (String)"wtc-wtabm-mservice", (Object[])new Object[0]));
                    break;
                }
                if (!StringUtils.equalsAny((CharSequence)billEntry.getStartMethod(), (CharSequence[])new CharSequence[]{WtcTimeRangeBtnTypeEnum.HALF_UP.value, WtcTimeRangeBtnTypeEnum.HALF_DOWN.value, WtcTimeRangeBtnTypeEnum.DAY.value, WtcTimeRangeBtnTypeEnum.CUSTOM.value})) {
                    billEntryCheckFail = true;
                    errorMap.put(reqIndex, ResManager.loadKDString((String)"\u8bf7\u6309\u89c4\u8303\u586b\u5199\u201d{0}\u65b9\u5f0f(\u5f00\u59cb)\u201c 0:\u4e0a\u534a\u5929, 1:\u4e0b\u534a\u5929, 2:\u5168\u5929, 3:\u65f6\u5206\u3002", (String)"VaApplyOtherBillOpenApi_5", (String)"wtc-wtabm-mservice", (Object[])new Object[]{BillTypeEnum.VACATIONBILL.getBillName()}));
                    break;
                }
                if (StringUtils.equalsAny((CharSequence)billEntry.getEndMethod(), (CharSequence[])new CharSequence[]{WtcTimeRangeBtnTypeEnum.HALF_UP.value, WtcTimeRangeBtnTypeEnum.HALF_DOWN.value, WtcTimeRangeBtnTypeEnum.DAY.value, WtcTimeRangeBtnTypeEnum.CUSTOM.value})) continue;
                billEntryCheckFail = true;
                errorMap.put(reqIndex, ResManager.loadKDString((String)"\u8bf7\u6309\u89c4\u8303\u586b\u5199\u201d{0}\u65b9\u5f0f(\u7ed3\u675f)\u201c 0:\u4e0a\u534a\u5929, 1:\u4e0b\u534a\u5929, 2:\u5168\u5929, 3:\u65f6\u5206\u3002", (String)"VaApplyOtherBillOpenApi_6", (String)"wtc-wtabm-mservice", (Object[])new Object[]{BillTypeEnum.VACATIONBILL.getBillName()}));
                break;
            }
            if (billEntryCheckFail) continue;
            if (WTCStringUtils.isNotEmpty((String)bill.getBillNo())) {
                billNo2ReqIdxMap.put(bill.getBillNo(), reqIndex);
            }
            attFileNumberSet.add(bill.getAttFileNumber());
            orgNumberSet.add(bill.getOrg());
            for (VaApplyBillEntryModel billEntry : bill.getEntryEntity()) {
                vaTypeNumberSet.add(billEntry.getVacationType());
            }
        }
        HRBaseServiceHelper billDao = new HRBaseServiceHelper("wtabm_vaapply");
        for (DynamicObject existBillNo : arr = billDao.query("billno", new QFilter("billno", "in", billNo2ReqIdxMap.keySet()).toArray())) {
            String billNo = existBillNo.getString("billno");
            Integer integer = (Integer)billNo2ReqIdxMap.get(billNo);
            if (integer == null || errorMap.containsKey(integer)) continue;
            errorMap.put(integer, ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u201c%s\u201d\u91cd\u590d\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"VaApplyOtherBillOpenApi_2", (String)"wtc-wtabm-mservice", (Object[])new Object[]{billNo}));
        }
        HashMap fileNumber2Top1Map = new HashMap(16);
        HashMap fileNumber2PersonMap = new HashMap(16);
        HashMap fileNumber2AttFileBoMap = new HashMap(16);
        new BillCommonService().initBillImportData("wtam", "wtabm_vaapply", (Set)attFileNumberSet, fileNumber2Top1Map, fileNumber2PersonMap, fileNumber2AttFileBoMap);
        Map<String, DynamicObject> orgNumberMap = this.queryOrgByNumber(orgNumberSet);
        Map<String, DynamicObject> travelTypeNumberMap = this.queryVaTypeByNumber(vaTypeNumberSet);
        block4: for (int reqIndex = 0; reqIndex < billList.size(); ++reqIndex) {
            VaApplyBillReqModel bill = billList.get(reqIndex);
            if (errorMap.containsKey(reqIndex)) continue;
            if (!fileNumber2AttFileBoMap.containsKey(bill.getAttFileNumber())) {
                errorMap.put(reqIndex, ResManager.loadKDString((String)"{0}\u5458\u5de5.\u6863\u6848\u7f16\u53f7\u201c{1}\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"VaApplyOtherBillOpenApi_7", (String)"wtc-wtabm-mservice", (Object[])new Object[]{BillTypeEnum.VACATIONBILL.getBillName(), bill.getAttFileNumber()}));
                continue;
            }
            if (!fileNumber2PersonMap.containsKey(bill.getAttFileNumber())) {
                errorMap.put(reqIndex, ResManager.loadKDString((String)"{0}\u5458\u5de5.\u6863\u6848\u7f16\u53f7\u201c{1}\u201d\u5bf9\u5e94\u7684\u8003\u52e4\u4eba\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"VaApplyOtherBillOpenApi_8", (String)"wtc-wtabm-mservice", (Object[])new Object[]{BillTypeEnum.VACATIONBILL.getBillName(), bill.getAttFileNumber()}));
                continue;
            }
            if (!orgNumberMap.containsKey(bill.getOrg())) {
                errorMap.put(reqIndex, ResManager.loadKDString((String)"\u8003\u52e4\u7ba1\u7406\u7ec4\u7ec7.\u7f16\u7801\u201c{0}\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"VaApplyOtherBillOpenApi_10", (String)"wtc-wtabm-mservice", (Object[])new Object[]{bill.getOrg()}));
                continue;
            }
            if (StringUtils.equals((CharSequence)bill.getNeedHand(), (CharSequence)"0") && StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{bill.getHandPerson(), bill.getHandPerson()})) {
                errorMap.put(reqIndex, ResManager.loadKDString((String)"\u4ea4\u63a5\u4eba\u6216\u4ea4\u63a5\u8bf4\u660e\u672a\u586b\u5199\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"VaApplyOtherBillOpenApi_11", (String)"wtc-wtabm-mservice", (Object[])new Object[0]));
                continue;
            }
            for (VaApplyBillEntryModel billEntry : bill.getEntryEntity()) {
                String travelType = billEntry.getVacationType();
                if (travelTypeNumberMap.containsKey(travelType)) continue;
                errorMap.put(reqIndex, ResManager.loadKDString((String)"{0}\u7c7b\u578b.\u7f16\u7801\u201c{1}\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"VaApplyOtherBillOpenApi_12", (String)"wtc-wtabm-mservice", (Object[])new Object[]{BillTypeEnum.VACATIONBILL.getBillName(), travelType}));
                continue block4;
            }
        }
        LOG.info("\u3010\u4f11\u5047OPENAPI\u3011\u8f6c\u6362\u4e3a\u52a8\u6001\u5bf9\u8c61\u6821\u9a8c\u5f00\u59cb");
        IDGenerator idGenerator = new IDGenerator();
        HashMap<Integer, DynamicObject> reqIdx2BillDynMap = new HashMap<Integer, DynamicObject>(billList.size());
        MainEntityType userMET = MetadataServiceHelper.getDataEntityType((String)"bos_user");
        MainEntityType billMET = MetadataServiceHelper.getDataEntityType((String)"wtabm_vaapply");
        for (int index = 0; index < billList.size(); ++index) {
            if (errorMap.containsKey(index)) continue;
            VaApplyBillReqModel bill = billList.get(index);
            DynamicObject billDyn = new DynamicObject((DynamicObjectType)billMET);
            billDyn.set("id", (Object)idGenerator.getId());
            if (WTCStringUtils.isNotEmpty((String)bill.getBillNo())) {
                billDyn.set("billno", (Object)bill.getBillNo());
            }
            billDyn.set("org", (Object)orgNumberMap.get(bill.getOrg()));
            billDyn.set("attfilebasef7", fileNumber2Top1Map.get(bill.getAttFileNumber()));
            DynamicObject attFileDy = (DynamicObject)fileNumber2AttFileBoMap.get(bill.getAttFileNumber());
            String attFileError = BillCommonService.getInstance().judgeAttFile(attFileDy, BillTypeEnum.VACATIONBILL.getBillName());
            if (HRStringUtils.isNotEmpty((String)attFileError)) {
                errorMap.put(index, attFileError);
                continue;
            }
            billDyn.set("attfile", (Object)attFileDy);
            billDyn.set("personid", fileNumber2PersonMap.get(bill.getAttFileNumber()));
            billDyn.set("applytyperadio", (Object)"1");
            DynamicObject user = new DynamicObject((DynamicObjectType)userMET);
            user.set("id", (Object)RequestContext.get().getCurrUserId());
            billDyn.set("creator", (Object)user);
            billDyn.set("auditstatus", (Object)"A");
            billDyn.set("billstatus", (Object)"A");
            boolean isNeedHand = StringUtils.equals((CharSequence)"0", (CharSequence)bill.getNeedHand());
            billDyn.set("isneedhand", (Object)isNeedHand);
            if (isNeedHand && StringUtils.isNotBlank((CharSequence)bill.getHandPerson())) {
                billDyn.set("handperson", (Object)bill.getHandPerson());
            }
            if (isNeedHand && StringUtils.isNotBlank((CharSequence)bill.getHandReason())) {
                billDyn.set("handreason", (Object)bill.getHandReason());
            }
            EntryProp entryProp = (EntryProp)billDyn.getDataEntityType().getProperties().get((Object)"entryentity");
            EntryType entryType = (EntryType)entryProp.getItemType();
            DynamicObjectCollection entries = billDyn.getDynamicObjectCollection("entryentity");
            int entryCount = bill.getEntryEntity().size();
            for (int entrySeq = 1; entrySeq <= bill.getEntryEntity().size(); ++entrySeq) {
                VaApplyBillEntryModel billEntry = bill.getEntryEntity().get(entrySeq - 1);
                DynamicObject newRow = new DynamicObject((DynamicObjectType)entryType);
                newRow.set("entryvacationtype", (Object)travelTypeNumberMap.get(billEntry.getVacationType()));
                String startMethod = billEntry.getStartMethod();
                String endMethod = billEntry.getEndMethod();
                newRow.set("entrystartmethod", (Object)startMethod);
                newRow.set("entryendmethod", (Object)endMethod);
                Date startDate = this.getDate(billEntry.getStartDateStr(), startMethod);
                Date endDate = this.getDate(billEntry.getEndDateStr(), endMethod);
                boolean checkSuccess = this.validateDate(billEntry, startDate, endDate, index, entryCount, entrySeq, errorMap);
                if (!checkSuccess || !(checkSuccess = this.validateVaMethod(startDate, endDate, startMethod, endMethod, index, entryCount, entrySeq, errorMap))) break;
                newRow.set("seq", (Object)entrySeq);
                newRow.set("entrystartdate", (Object)startDate);
                newRow.set("entryenddate", (Object)endDate);
                newRow.set("owndate", (Object)endDate);
                if (WTCStringUtils.isNotEmpty((String)billEntry.getVaReason())) {
                    newRow.set("entryreason", (Object)billEntry.getVaReason());
                }
                entries.add((Object)newRow);
            }
            reqIdx2BillDynMap.put(index, billDyn);
        }
        errorMap.keySet().forEach(reqIdx2BillDynMap::remove);
        return reqIdx2BillDynMap;
    }

    private Map<String, DynamicObject> queryOrgByNumber(Set<String> orgNumberSet) {
        HRBaseServiceHelper orgDao = new HRBaseServiceHelper("bos_org");
        DynamicObject[] orgArr = orgDao.loadDynamicObjectArray(new QFilter("number", "in", orgNumberSet).toArray());
        HashMap<String, DynamicObject> orgNumberMap = new HashMap<String, DynamicObject>(orgArr.length);
        for (DynamicObject org : orgArr) {
            orgNumberMap.put(org.getString("number"), org);
        }
        return orgNumberMap;
    }

    private Map<String, DynamicObject> queryVaTypeByNumber(Set<String> vaTypeSet) {
        HRBaseServiceHelper vaTypeServiceHelper = new HRBaseServiceHelper("wtbd_vacationtype");
        DynamicObject[] travelTypeArr = vaTypeServiceHelper.loadDynamicObjectArray(new QFilter("number", "in", vaTypeSet).toArray());
        Map<String, DynamicObject> travelTypeNumberMap = Arrays.stream(travelTypeArr).collect(Collectors.toMap(vaType -> vaType.getString("number"), vaType -> vaType, (type1, type2) -> type2));
        return travelTypeNumberMap;
    }

    private void handleTx(DynamicObject[] billArr, Map<Object, Integer> pk2ReqIndexMap, Map<Integer, String> errorMap) {
        try (TXHandle handle = TX.requiresNew();){
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("currbizappid", "wtam");
            operateOption.setVariableValue("wtc_wtabm_openapi", "wtc_wtabm_openapi");
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"submiteffect", (String)"wtabm_vaapply", (DynamicObject[])billArr, (OperateOption)operateOption);
            if (!operationResult.isSuccess()) {
                LOG.warn("vaApplyOtherBill executeOperate fail. operationResult:{}", (Object)operationResult);
                ValidateResultCollection validateResColl = operationResult.getValidateResult();
                for (ValidateResult validateResult : validateResColl.getValidateErrors()) {
                    if (validateResult.isSuccess()) continue;
                    for (OperateErrorInfo operateErrorInfo : validateResult.getAllErrorInfo()) {
                        Object billPK = operateErrorInfo.getPkValue();
                        Integer reqIndex = pk2ReqIndexMap.get(billPK);
                        String errMsg = errorMap.get(reqIndex);
                        if (!WTCStringUtils.isEmpty((String)errMsg) && !errMsg.equals(operationResult.getMessage())) continue;
                        errorMap.put(reqIndex, operateErrorInfo.getMessage());
                    }
                }
                List successPkIds = operationResult.getSuccessPkIds();
                for (DynamicObject bill : billArr) {
                    Integer reqIndex;
                    Object billPK = bill.get("id");
                    if (successPkIds.contains(billPK) || errorMap.containsKey(reqIndex = pk2ReqIndexMap.get(billPK))) continue;
                    errorMap.put(reqIndex, operationResult.getMessage());
                }
            }
            if (!errorMap.isEmpty()) {
                handle.markRollback();
            }
        }
    }

    private Date getDate(String dateStr, String vaMethod) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Date date = null;
        try {
            date = !StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence)vaMethod) ? simpleDateFormat.parse(dateStr) : simpleDateFormat2.parse(dateStr);
        }
        catch (ParseException e) {
            LOG.warn("\u5165\u53c2\u65e5\u671f\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)dateStr);
        }
        return date;
    }

    private boolean validateDate(VaApplyBillEntryModel billEntry, Date startDate, Date endDate, Integer index, int entryCount, int curSeq, Map<Integer, String> errorMap) {
        boolean startdateValidated = VaApplyOtherBillOpenApi.datePatternFormated(billEntry.getStartDateStr(), billEntry.getStartMethod());
        if (!startdateValidated || startDate == null) {
            String errMsg = StringUtils.equals((CharSequence)billEntry.getStartMethod(), (CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value) ? VaKDStringHelper.startMethodCustomDatePattern() : VaKDStringHelper.startMethodNoCustomDatePattern();
            errorMap.put(index, this.getMsg(entryCount, curSeq, errMsg));
            return false;
        }
        boolean endDateValidated = VaApplyOtherBillOpenApi.datePatternFormated(billEntry.getEndDateStr(), billEntry.getEndMethod());
        if (!endDateValidated || endDate == null) {
            String errMsg = StringUtils.equals((CharSequence)billEntry.getEndMethod(), (CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value) ? ResManager.loadKDString((String)"\u4f11\u5047\u65b9\u5f0f\uff08\u7ed3\u675f\uff09\u201c\u7b49\u4e8e\u65f6\u5206\uff0c\u201d\u4f11\u5047\u7ed3\u675f\u65f6\u95f4\u201c\u683c\u5f0f\u4ec5\u80fd\u4e3a\u957f\u65e5\u671f\uff08\u5982\uff1a2023-03-01 09:00\uff09\u3002", (String)"VaApplyOtherBillOpenApi_15", (String)"wtc-wtabm-mservice", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f11\u5047\u65b9\u5f0f\uff08\u7ed3\u675f\uff09\u7b49\u4e8e\u5168\u5929/\u4e0a\u534a\u5929/\u4e0b\u534a\u5929\u65f6\uff0c\u201c\u4f11\u5047\u7ed3\u675f\u65f6\u95f4\u201d\u683c\u5f0f\u4ec5\u80fd\u4e3a\u77ed\u65e5\u671f\uff08\u5982\uff1a2023-03-01\uff09\u3002", (String)"VaApplyOtherBillOpenApi_16", (String)"wtc-wtabm-mservice", (Object[])new Object[0]);
            errorMap.put(index, this.getMsg(entryCount, curSeq, errMsg));
            return false;
        }
        if (endDate.before(startDate)) {
            String errMsg = VaKDStringHelper.startTimeAfterEndTime();
            errorMap.put(index, this.getMsg(entryCount, curSeq, errMsg));
            return false;
        }
        return true;
    }

    private boolean validateVaMethod(Date startDate, Date endDate, String startMethod, String endMethod, Integer index, int entryCount, int curSeq, Map<Integer, String> errorMap) {
        if (StringUtils.equals((CharSequence)startMethod, (CharSequence)WtcTimeRangeBtnTypeEnum.DAY.value) && !StringUtils.equals((CharSequence)endMethod, (CharSequence)WtcTimeRangeBtnTypeEnum.DAY.value)) {
            String errMsg = VaKDStringHelper.startMethodDayCheck();
            errorMap.put(index, this.getMsg(entryCount, curSeq, errMsg));
            return false;
        }
        if (StringUtils.equalsAny((CharSequence)startMethod, (CharSequence[])new CharSequence[]{WtcTimeRangeBtnTypeEnum.HALF_UP.value}) && !StringUtils.equalsAny((CharSequence)endMethod, (CharSequence[])new CharSequence[]{WtcTimeRangeBtnTypeEnum.HALF_UP.value, WtcTimeRangeBtnTypeEnum.HALF_DOWN.value})) {
            String errMsg = VaKDStringHelper.startMethodHalfUpCheck();
            errorMap.put(index, this.getMsg(entryCount, curSeq, errMsg));
            return false;
        }
        if (StringUtils.equals((CharSequence)startMethod, (CharSequence)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value)) {
            if (DateUtils.isSameDay((Date)startDate, (Date)endDate) && !StringUtils.equals((CharSequence)endMethod, (CharSequence)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value)) {
                String errMsg = VaKDStringHelper.startMethodHalfDownNoCrossDayCheck();
                errorMap.put(index, this.getMsg(entryCount, curSeq, errMsg));
                return false;
            }
            if (!StringUtils.equalsAny((CharSequence)endMethod, (CharSequence[])new CharSequence[]{WtcTimeRangeBtnTypeEnum.HALF_UP.value, WtcTimeRangeBtnTypeEnum.HALF_DOWN.value})) {
                String errMsg = VaKDStringHelper.startMethodHalfDownCheck();
                errorMap.put(index, this.getMsg(entryCount, curSeq, errMsg));
                return false;
            }
        }
        if (StringUtils.equals((CharSequence)startMethod, (CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value) && !StringUtils.equalsAny((CharSequence)endMethod, (CharSequence[])new CharSequence[]{WtcTimeRangeBtnTypeEnum.CUSTOM.value})) {
            String errMsg = ResManager.loadKDString((String)"\u4f11\u5047\u65b9\u5f0f\uff08\u5f00\u59cb\uff09\u201c\u7b49\u4e8e\u65f6\u5206\uff0c\u201d\u4f11\u5047\u65b9\u5f0f\uff08\u7ed3\u675f\uff09\u201d\u53ea\u53ef\u7b49\u4e8e\u65f6\u5206\u3002", (String)"VaApplyOtherBillOpenApi_19", (String)"wtc-wtabm-mservice", (Object[])new Object[0]);
            errorMap.put(index, this.getMsg(entryCount, curSeq, errMsg));
            return false;
        }
        return true;
    }

    private String getMsg(int count, int curSeq, String curMsg) {
        if (count <= 1) {
            return curMsg;
        }
        StringBuilder sb = new StringBuilder();
        String otherErrMsg = ResManager.loadKDString((String)"\u56e0\u5176\u4ed6\u5206\u5f55\u5bfc\u5165\u5931\u8d25\u3002", (String)"VaApplyOtherBillOpenApi_24", (String)"wtc-wtabm-mservice", (Object[])new Object[0]);
        for (int seq = 1; seq <= count; ++seq) {
            if (seq == curSeq) {
                sb.append(ResManager.loadKDString((String)"\u5206\u5f55{0}\uff1a{1}\u3002", (String)"VaApplyOtherBillOpenApi_23", (String)"wtc-wtabm-mservice", (Object[])new Object[]{seq, curMsg}));
                continue;
            }
            sb.append(ResManager.loadKDString((String)"\u5206\u5f55{0}\uff1a{1}\u3002", (String)"VaApplyOtherBillOpenApi_23", (String)"wtc-wtabm-mservice", (Object[])new Object[]{seq, otherErrMsg}));
        }
        return sb.toString();
    }

    private static boolean datePatternFormated(String datePattern, String method) {
        Pattern pattern = StringUtils.equals((CharSequence)method, (CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value) ? Pattern.compile(DATETIME_PATTERN) : Pattern.compile(DATE_PATTERN);
        Matcher match = pattern.matcher(datePattern);
        return match.matches();
    }

    private static class IDGenerator {
        private long[] idArr = null;
        private int idx = 0;

        private IDGenerator() {
        }

        public long getId() {
            if (this.idArr == null || this.idx >= this.idArr.length) {
                this.idArr = DB.genGlobalLongIds((int)50);
                this.idx = 0;
            }
            return this.idArr[this.idx++];
        }
    }
}

