/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.servicehelper;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;

public class ServiceFactory {
    private static final Map<String, String> SERVICE_MAP = new HashMap<String, String>();

    public static <T> T getService(Class<T> clazz) {
        return (T)ServiceFactory.getService(clazz.getSimpleName());
    }

    public static Object getService(String serviceName) {
        String className = SERVICE_MAP.get(serviceName);
        if (className == null) {
            throw new RuntimeException(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230\u3002", (String)"ServiceFactory_0", (String)"wtc-wtabm-servicehelper", (Object[])new Object[0]), serviceName));
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    private ServiceFactory() {
    }

    static {
        SERVICE_MAP.put("IVaApplyBillService", "kd.wtc.wtabm.mservice.VaApplyBillServiceImpl");
        SERVICE_MAP.put("IVaBillService", "kd.wtc.wtabm.mservice.VaBillService");
        SERVICE_MAP.put("IVaPlanService", "kd.wtc.wtabm.mservice.VaPlanServiceImpl");
        SERVICE_MAP.put("IVaBatchBillService", "kd.wtc.wtabm.mservice.VaBatchBillService");
    }
}

