/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.business.ext;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.sdk.wtc.wtabm.business.spva.SpecialVaTimeDto;
import kd.sdk.wtc.wtabm.business.va.OnCalVaApplyTimeEvent;
import kd.sdk.wtc.wtabm.business.va.VaTimeResult;
import kd.sdk.wtc.wtbs.common.dto.shift.ShiftDto;
import kd.wtc.wtabm.business.vaapply.ConvertUtils;
import kd.wtc.wtbs.common.model.bill.BillApplyTimeResult;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class OnCalVaApplyTimeEventExtImpl
implements OnCalVaApplyTimeEvent {
    private final long attFileBoId;
    private final DynamicObject billEntryDyn;
    private final DynamicObject matchedBaseSet;
    private final BillApplyTimeResult standardResult;
    private final List<Tuple<DutyShift, Shift>> dutyShiftsRange;
    private Map<Date, ShiftDto> rosterShiftDtoMap;
    private final SpecialVaTimeDto specialVaTimeDto;
    private boolean cancel = false;
    private VaTimeResult vaTimeResult;

    public OnCalVaApplyTimeEventExtImpl(long attFileBoId, DynamicObject billEntryDyn, DynamicObject matchedBaseSet, List<Tuple<DutyShift, Shift>> dutyShiftsRange, SpecialVaTimeDto specialVaTimeDto) {
        this.attFileBoId = attFileBoId;
        this.billEntryDyn = billEntryDyn;
        this.matchedBaseSet = matchedBaseSet;
        this.dutyShiftsRange = dutyShiftsRange;
        this.specialVaTimeDto = specialVaTimeDto;
        this.standardResult = null;
    }

    public OnCalVaApplyTimeEventExtImpl(long attFileBoId, DynamicObject billEntryDyn, DynamicObject matchedBaseSet, List<Tuple<DutyShift, Shift>> dutyShiftsRange, SpecialVaTimeDto specialVaTimeDto, BillApplyTimeResult standardResult) {
        this.attFileBoId = attFileBoId;
        this.billEntryDyn = billEntryDyn;
        this.matchedBaseSet = matchedBaseSet;
        this.dutyShiftsRange = dutyShiftsRange;
        this.specialVaTimeDto = specialVaTimeDto;
        this.standardResult = standardResult;
    }

    private Map<Date, ShiftDto> parse(List<Tuple<DutyShift, Shift>> dutyShiftsRange) {
        HashMap shiftDtoMap = Maps.newHashMapWithExpectedSize((int)dutyShiftsRange.size());
        HashMap rosterShiftDtoMap = Maps.newHashMapWithExpectedSize((int)dutyShiftsRange.size());
        for (Tuple<DutyShift, Shift> dutyShiftShiftTuple : dutyShiftsRange) {
            if (dutyShiftShiftTuple.item2 == null) continue;
            Long shiftId = ((Shift)dutyShiftShiftTuple.item2).getId();
            ShiftDto shiftDto = (ShiftDto)shiftDtoMap.get(shiftId);
            if (shiftDto == null) {
                shiftDto = ConvertUtils.convertShift((Shift)dutyShiftShiftTuple.item2);
                shiftDtoMap.put(shiftId, shiftDto);
            }
            Date rosterDate = ((DutyShift)dutyShiftShiftTuple.item1).getRosterDate();
            rosterShiftDtoMap.put(rosterDate, shiftDto);
        }
        return rosterShiftDtoMap;
    }

    public long getAttFileBoId() {
        return this.attFileBoId;
    }

    public DynamicObject getBillEntryDyn() {
        return this.billEntryDyn;
    }

    public DynamicObject getMatchedBaseSet() {
        return this.matchedBaseSet;
    }

    public VaTimeResult getStandardResult() {
        if (this.standardResult == null) {
            return null;
        }
        return new VaTimeResult(this.standardResult.getUnit(), this.standardResult.getValHour(), this.standardResult.getValDay());
    }

    public Map<Date, ShiftDto> getRosterShiftDtoMap() {
        if (this.rosterShiftDtoMap == null) {
            this.rosterShiftDtoMap = this.parse(this.dutyShiftsRange);
        }
        return this.rosterShiftDtoMap;
    }

    public SpecialVaTimeDto getSpecialVaTimeDto() {
        return this.specialVaTimeDto;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public void setCancel(boolean cancel) {
        this.cancel = cancel;
    }

    public VaTimeResult getVaTimeResult() {
        return this.vaTimeResult;
    }

    public void setVaTimeResult(VaTimeResult vaTimeResult) {
        this.vaTimeResult = vaTimeResult;
    }
}

