/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.business.task.upgrade;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.wtc.wtbs.business.task.upgrade.AbstractWtcTaskUpgrade;
import kd.wtc.wtbs.common.enums.bill.va.SpecialVaTypeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtp.business.attstateinfo.AttStateInfoService;

public class VaBreastfeedingUpgradeImpl
extends AbstractWtcTaskUpgrade {
    private static final Log LOG = LogFactory.getLog(VaBreastfeedingUpgradeImpl.class);
    private static final String UPDATESQL = "UPDATE t_wtabm_vaapplyentry SET fstorageto = ? where fid = ? and fspecialvatype = 'A' and fstorageto is null;";
    private HRBaseServiceHelper VA_APPLY_SERVICE = new HRBaseServiceHelper("wtabm_vaapply");

    protected String getJobId() {
        return "48LTLF=SNJSF";
    }

    protected String getScheduleId() {
        return "48LU5MQBEPRC";
    }

    protected boolean process() {
        LOG.info("\u3010\u5347\u7ea7\u54fa\u4e73\u5047\u5c01\u5b58\u81f3\u3011\u5f00\u59cb");
        long startNanoTime = System.nanoTime();
        String properties = "attfile.id, id, entryentity.id, entryentity.specialvatype";
        List billStatusList = WTCCollections.modifiableList((Object[])new String[]{"C"});
        QFilter[] qFilters = new QFilter[]{new QFilter("billstatus", "in", (Object)billStatusList).and("entryentity.specialvatype", "=", (Object)SpecialVaTypeEnum.LACTATION_TYPE.vaType).and("entryentity.storageto", "is null", null)};
        DynamicObject[] vaBills = this.VA_APPLY_SERVICE.queryOriginalArray(properties, qFilters);
        if (vaBills.length == 0) {
            LOG.info("\u65e0\u9700\u8981\u5347\u7ea7\u7684\u54fa\u4e73\u5047\uff0c\u76f4\u63a5\u8fd4\u56de\u3002");
            return true;
        }
        try (TXHandle txHandle = TX.required();){
            DBRoute dbRoute = new DBRoute("wtc");
            List fileBoidList = Arrays.stream(vaBills).map(dy -> dy.getLong("attfile.id")).collect(Collectors.toList());
            AttStateInfoService attStateInfoService = AttStateInfoService.INSTANCE;
            List attStateInfos = attStateInfoService.queryAttStateInfoByBoid(fileBoidList);
            Map attFileStorageMap = WTCCollections.modifiableEmptyMap();
            for (DynamicObject[] info : attStateInfos) {
                if (info.getStorageTo() == null) continue;
                attFileStorageMap.put(info.getFileBoid(), info.getStorageTo());
            }
            List params = WTCCollections.modifiableListWithCap((int)vaBills.length);
            for (DynamicObject vaBill : vaBills) {
                long billId = vaBill.getLong("id");
                long attFileBoid = vaBill.getLong("attfile.id");
                Date storageTo = (Date)attFileStorageMap.get(attFileBoid);
                if (storageTo == null) continue;
                params.add(new Object[]{storageTo, billId});
            }
            HRDBUtil.executeBatch((DBRoute)dbRoute, (String)UPDATESQL, (List)params);
            long nanoTimes = System.nanoTime() - startNanoTime;
            float value = (float)nanoTimes / 1000000.0f;
            LOG.info("\u3010\u5347\u7ea7\u54fa\u4e73\u5047\u5c01\u5b58\u81f3\u3011\u7ed3\u675f\uff0c\u8017\u65f6\uff1a{}ms", (Object)Float.valueOf(value));
        }
        return true;
    }
}

