/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.business.vaapply;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.wtc.wtabm.business.helper.VaBillEntryEntityDto;
import kd.sdk.wtc.wtabm.business.helper.VaBillSubEntryDto;
import kd.wtc.wtbs.business.util.ShiftParseUtil;
import kd.wtc.wtbs.common.enums.bill.va.SpecialVaTypeEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.bill.va.VaBillEntryEntityVo;
import kd.wtc.wtbs.common.model.bill.va.VaBillSubEntryVo;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.wtabm.common.entity.VaLactationTimeStorage;
import kd.wtc.wtbs.wtp.enums.vaplan.BaseSetTimeBreastDayTypeEnum;

public class BreastfeedingLeaveService {
    private static final Log LOG = LogFactory.getLog(BreastfeedingLeaveService.class);

    public static List<VaBillSubEntryVo> generateBreastfeedingTimeRange(VaBillEntryEntityVo targetEntry, DutyShiftResponse shiftInfo) {
        String specialVaType = targetEntry.getSpecialVaType();
        if (!WTCStringUtils.equals((String)SpecialVaTypeEnum.LACTATION_TYPE.vaType, (String)specialVaType)) {
            return WTCCollections.modifiableEmptyList();
        }
        List vaSubEntryVoList = targetEntry.getVaSubEntryVoList();
        long spVaMethodId = targetEntry.getSpVaMethodId();
        if (spVaMethodId == BaseSetTimeBreastDayTypeEnum.COME_LATE.id || spVaMethodId == BaseSetTimeBreastDayTypeEnum.GO_EARLY.id) {
            Date generateStartDate = BreastfeedingLeaveService.getGenerateStartDate(targetEntry.getStorageTo(), targetEntry.getStartDate(), targetEntry.getEndDate());
            Date preDate = WTCDateUtils.addDays((Date)generateStartDate, (int)-1);
            Shift preShift = null;
            if (shiftInfo != null) {
                VaLactationTimeStorage storage;
                Optional optionalPreShift = shiftInfo.getCurrShiftHis(Long.valueOf(targetEntry.getAttFileBoid()), preDate);
                if (optionalPreShift.isPresent()) {
                    preShift = (Shift)optionalPreShift.get();
                }
                if ((storage = (VaLactationTimeStorage)JSON.parseObject((String)targetEntry.getSpecialExtJson(), VaLactationTimeStorage.class)) != null) {
                    List<VaBillSubEntryVo> generatedSubEntryVoList = vaSubEntryVoList.stream().filter(subEntryVo -> subEntryVo.getVaEntryDate().before(generateStartDate)).collect(Collectors.toList());
                    Date date = generateStartDate;
                    while (!date.after(targetEntry.getEndDate())) {
                        Optional optionalShift = shiftInfo.getCurrShiftHis(Long.valueOf(targetEntry.getAttFileBoid()), date);
                        if (optionalShift.isPresent()) {
                            Shift shift = (Shift)optionalShift.get();
                            Tuple<Date, Date> dateDateTuple = BreastfeedingLeaveService.fillSubEntry(storage, spVaMethodId, shift, preShift, date);
                            VaBillSubEntryVo subEntryVo2 = new VaBillSubEntryVo();
                            subEntryVo2.setEntryId(targetEntry.getId());
                            subEntryVo2.setVaEntryDate(date);
                            subEntryVo2.setStartDateTime((Date)dateDateTuple.getKey());
                            subEntryVo2.setEndDateTime((Date)dateDateTuple.getValue());
                            generatedSubEntryVoList.add(subEntryVo2);
                            preShift = shift;
                        } else {
                            preShift = null;
                        }
                        date = WTCDateUtils.addDays((Date)date, (int)1);
                    }
                    return generatedSubEntryVoList;
                }
            }
        }
        return vaSubEntryVoList;
    }

    protected static List<VaBillSubEntryDto> generateBreastfeedingTimeRange(VaBillEntryEntityDto targetEntry, DutyShiftResponse shiftInfo) {
        List vaSubEntryVoList = targetEntry.getVaSubEntryVoList();
        long spVaMethodId = targetEntry.getSpVaMethodId();
        if (spVaMethodId == BaseSetTimeBreastDayTypeEnum.COME_LATE.id || spVaMethodId == BaseSetTimeBreastDayTypeEnum.GO_EARLY.id) {
            VaLactationTimeStorage storage;
            Date generateStartDate = BreastfeedingLeaveService.getGenerateStartDate(targetEntry.getStorageTo(), targetEntry.getStartDate(), targetEntry.getEndDate());
            Date preDate = WTCDateUtils.addDays((Date)generateStartDate, (int)-1);
            Shift preShift = null;
            Optional optionalPreShift = shiftInfo.getCurrShiftHis(Long.valueOf(targetEntry.getAttFileBoid()), preDate);
            if (optionalPreShift.isPresent()) {
                preShift = (Shift)optionalPreShift.get();
            }
            if ((storage = (VaLactationTimeStorage)JSON.parseObject((String)targetEntry.getSpecialExtJson(), VaLactationTimeStorage.class)) != null) {
                List<VaBillSubEntryDto> generatedSubEntryVoList = vaSubEntryVoList.stream().filter(subEntryVo -> subEntryVo.getVaEntryDate().before(generateStartDate)).collect(Collectors.toList());
                Date date = generateStartDate;
                while (!date.after(targetEntry.getEndDate())) {
                    Optional optionalShift = shiftInfo.getCurrShiftHis(Long.valueOf(targetEntry.getAttFileBoid()), date);
                    if (optionalShift.isPresent()) {
                        Shift shift = (Shift)optionalShift.get();
                        Tuple<Date, Date> dateDateTuple = BreastfeedingLeaveService.fillSubEntry(storage, spVaMethodId, shift, preShift, date);
                        VaBillSubEntryDto subEntryDto = new VaBillSubEntryDto();
                        subEntryDto.setVaEntryDate(date);
                        subEntryDto.setStartDateTime((Date)dateDateTuple.getKey());
                        subEntryDto.setEndDateTime((Date)dateDateTuple.getValue());
                        generatedSubEntryVoList.add(subEntryDto);
                        preShift = shift;
                    } else {
                        LOG.info("\u3010\u91cd\u65b0\u751f\u6210\u54fa\u4e73\u5047\u4f11\u5047\u65f6\u6bb5\u3011\u5bf9\u5e94\u65e5\u65e0\u6392\u73ed\u3002attFileBoId:{}, rosterDate:{}", (Object)targetEntry.getAttFileBoid(), (Object)date);
                        preShift = null;
                    }
                    date = WTCDateUtils.addDays((Date)date, (int)1);
                }
                return generatedSubEntryVoList;
            }
        }
        return vaSubEntryVoList;
    }

    protected static Date getGenerateStartDate(Date storageTo, Date startDate, Date endDate) {
        String calWay = WTCAppContextHelper.getSysParams().getString("wtc.wtabm.breastfeedingleave.generateway", "1");
        Date generateStartDate = startDate;
        if (WTCStringUtils.equals((String)calWay, (String)"0")) {
            generateStartDate = WTCDateUtils.addDays((Date)endDate, (int)1);
        } else if (WTCStringUtils.equals((String)calWay, (String)"1") && storageTo != null) {
            generateStartDate = WTCDateUtils.getMaxDate((Date)WTCDateUtils.addDays((Date)storageTo, (int)1), (Date)generateStartDate);
        }
        return generateStartDate;
    }

    protected static Tuple<Date, Date> fillSubEntry(VaLactationTimeStorage storage, long specialVaMethodId, Shift shift, Shift prevShift, Date rosterDate) {
        Date endDate;
        Date startDate;
        BigDecimal offTimePerDay = storage.getOffTimePerDay();
        long offMillSecondTimePerDay = 0L;
        if (offTimePerDay != null) {
            offMillSecondTimePerDay = offTimePerDay.multiply(BigDecimal.valueOf(3600000L)).longValue();
        }
        Date prevShiftEnd = prevShift == null ? rosterDate : ShiftParseUtil.getRosterEndDate((Shift)prevShift, (Date)WTCDateUtils.addDays((Date)rosterDate, (int)-1), (boolean)true);
        Date shiftStartDate = ShiftParseUtil.getRosterStartDate((Shift)shift, (Date)rosterDate, (Date)prevShiftEnd);
        Date shiftEndDate = ShiftParseUtil.getRosterEndDate((Shift)shift, (Date)rosterDate, (boolean)true);
        if (specialVaMethodId == BaseSetTimeBreastDayTypeEnum.COME_LATE.id) {
            startDate = shiftStartDate;
            endDate = WTCDateUtils.getMinDate((Date)new Date(shiftStartDate.getTime() + offMillSecondTimePerDay), (Date)shiftEndDate);
        } else {
            startDate = WTCDateUtils.getMaxDate((Date)new Date(shiftEndDate.getTime() - offMillSecondTimePerDay), (Date)shiftStartDate);
            endDate = shiftEndDate;
        }
        return new Tuple((Object)startDate, (Object)endDate);
    }
}

