/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.business.vaapply;

import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.wtc.wtbs.common.dto.shift.BaseDataDto;
import kd.sdk.wtc.wtbs.common.dto.shift.ShiftDetailDto;
import kd.sdk.wtc.wtbs.common.dto.shift.ShiftDto;
import kd.sdk.wtc.wtbs.common.dto.shift.ShiftMiddleRuleDto;
import kd.sdk.wtc.wtbs.common.dto.shift.TakeCardRuleDto;
import kd.sdk.wtc.wtbs.common.dto.shift.TimeSeqDto;
import kd.sdk.wtc.wtbs.common.enums.RefDateType;
import kd.wtc.wtbs.common.model.evaluation.BaseDataVo;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.model.evaluation.ShiftDetail;
import kd.wtc.wtbs.common.model.evaluation.ShiftMiddleRule;
import kd.wtc.wtbs.common.model.sign.TakeCardRule;
import kd.wtc.wtbs.common.model.sign.TimeSeq;
import kd.wtc.wtbs.common.util.third.util.BeanUtils;

public class ConvertUtils {
    private static final Log LOG = LogFactory.getLog(ConvertUtils.class);

    public static ShiftDto convertShift(Shift shift) {
        ShiftDto shiftDto = new ShiftDto();
        try {
            BeanUtils.copyProperties((Object)shiftDto, (Object)shift);
        }
        catch (Exception ex) {
            LOG.warn("\u590d\u5236\u5c5e\u6027shiftmiddlerule\u5f02\u5e38\u3002", (Throwable)ex);
        }
        List shiftDetailList = shift.getShiftDetailList();
        shiftDto.setShiftDetailDtoList(ConvertUtils.convertShiftDetails(shiftDetailList));
        List flexShift = shift.getFlexShift();
        shiftDto.setFlexShiftDto(ConvertUtils.convertShiftDetails(flexShift));
        shiftDto.setShiftMiddleRuleDto(ConvertUtils.convertShiftMiddleRule(shift.getShiftMiddleRule()));
        shiftDto.setTakeCardRuleDto(ConvertUtils.convertTakeCardRule(shift.getTakeCardRule()));
        return shiftDto;
    }

    private static List<ShiftDetailDto> convertShiftDetails(List<ShiftDetail> shiftDetails) {
        if (shiftDetails == null) {
            return null;
        }
        ArrayList<ShiftDetailDto> result = new ArrayList<ShiftDetailDto>(shiftDetails.size());
        for (ShiftDetail shiftDetail : shiftDetails) {
            ShiftDetailDto shiftDetailDto = new ShiftDetailDto();
            shiftDetailDto.setShiftPeriod(ConvertUtils.copyBaseData(shiftDetail.getShiftPeriod()));
            shiftDetailDto.setCheckDate(shiftDetail.getCheckDate());
            shiftDetailDto.setShiftStartDate(shiftDetail.getShiftStartDate());
            shiftDetailDto.setShiftEndDate(shiftDetail.getShiftEndDate());
            shiftDetailDto.setShiftStartDateStr(shiftDetail.getShiftStartDateStr());
            shiftDetailDto.setShiftEndDateStr(shiftDetail.getShiftEndDateStr());
            shiftDetailDto.setRefStartDay(shiftDetail.getRefStartDay());
            shiftDetailDto.setRefEndDay(shiftDetail.getRefEndDay());
            shiftDetailDto.setOutWorkType(shiftDetail.getOutWorkType());
            shiftDetailDto.setEndPunchCardPointEntryId(shiftDetail.getEndPunchCardPointEntryId());
            shiftDetailDto.setStartPunchCardPointEntryId(shiftDetail.getStartPunchCardPointEntryId());
            shiftDetailDto.setWorkTimeStart(shiftDetail.isWorkTimeStart());
            shiftDetailDto.setWorkTimeEnd(shiftDetail.isWorkTimeEnd());
            shiftDetailDto.setWorkTime(shiftDetail.getWorkTime());
            result.add(shiftDetailDto);
        }
        return result;
    }

    private static BaseDataDto copyBaseData(BaseDataVo baseDataVo) {
        if (baseDataVo == null) {
            return null;
        }
        BaseDataDto baseDataDto = new BaseDataDto();
        try {
            BeanUtils.copyProperties((Object)baseDataDto, (Object)baseDataVo);
        }
        catch (Exception ex) {
            LOG.warn("\u590d\u5236\u5c5e\u6027basedatavo\u5f02\u5e38.", (Throwable)ex);
        }
        return baseDataDto;
    }

    private static ShiftMiddleRuleDto convertShiftMiddleRule(ShiftMiddleRule shiftMiddleRule) {
        ShiftMiddleRuleDto shiftMiddleRuleDto = new ShiftMiddleRuleDto();
        if (shiftMiddleRule != null) {
            try {
                BeanUtils.copyProperties((Object)shiftMiddleRuleDto, (Object)shiftMiddleRule);
                shiftMiddleRuleDto.setRefDateType(RefDateType.of((String)shiftMiddleRule.getMiddleRefDate().code));
            }
            catch (Exception ex) {
                LOG.warn("\u590d\u5236\u5c5e\u6027shiftmiddlerule\u5f02\u5e38\u3002", (Throwable)ex);
            }
        }
        return shiftMiddleRuleDto;
    }

    private static TakeCardRuleDto convertTakeCardRule(TakeCardRule takeCardRule) {
        if (takeCardRule == null) {
            return null;
        }
        TakeCardRuleDto takeCardRuleDto = new TakeCardRuleDto();
        try {
            BeanUtils.copyProperties((Object)takeCardRuleDto, (Object)takeCardRule);
            takeCardRuleDto.setTimeSeqDtoList(ConvertUtils.convertTimeSeqs(takeCardRule.getTimeSeqList()));
        }
        catch (Exception ex) {
            LOG.warn("\u590d\u5236\u5c5e\u6027takecardrule\u5f02\u5e38\u3002", (Throwable)ex);
        }
        return takeCardRuleDto;
    }

    private static List<TimeSeqDto> convertTimeSeqs(List<TimeSeq> timeSeqList) {
        if (timeSeqList == null) {
            return null;
        }
        ArrayList<TimeSeqDto> timeSeqDtos = new ArrayList<TimeSeqDto>(timeSeqList.size());
        for (TimeSeq timeSeq : timeSeqList) {
            TimeSeqDto timeSeqDto = new TimeSeqDto();
            try {
                BeanUtils.copyProperties((Object)timeSeqDto, (Object)timeSeq);
            }
            catch (Exception ex) {
                LOG.warn("\u590d\u5236\u5c5e\u6027timeseq\u5f02\u5e38\u3002", (Throwable)ex);
            }
            timeSeqDtos.add(timeSeqDto);
        }
        return timeSeqDtos;
    }
}

