/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.business.vaapply;

import com.alibaba.fastjson.JSON;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.support.util.Assert;
import kd.bos.exception.KDBizException;
import kd.bos.form.AbstractFormView;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtabm.business.quota.OnRenameVaTypeEvent;
import kd.sdk.wtc.wtabm.business.quota.VaTypeRenamePlugin;
import kd.wtc.wtabm.business.vaapply.VaApplyExtHelper;
import kd.wtc.wtabm.business.vaapply.VaApplyService;
import kd.wtc.wtabm.business.vaapply.VaApplyServiceHelper;
import kd.wtc.wtabm.business.vaapply.VaBaseService;
import kd.wtc.wtabm.business.vaapply.VaInfoService;
import kd.wtc.wtabm.business.vaapply.VaKDStringHelper;
import kd.wtc.wtabm.business.vaapply.checker.VaBillCheckService;
import kd.wtc.wtabm.business.vaapply.checker.VaEntityCheckService;
import kd.wtc.wtabm.common.entity.vaapply.SummaryVaTypeVo;
import kd.wtc.wtabm.common.entity.vaapply.VaQuotaResInfo;
import kd.wtc.wtabm.common.entity.vaapply.VaTypeSelectVo;
import kd.wtc.wtabm.common.vaapply.VaApplyMobConstants;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.mobile.BillContainerService;
import kd.wtc.wtbs.common.concurrent.WTCMutexHelper;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.ArrayUtils;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtbs.common.util.third.util.NumberUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtabm.common.constants.VaApplyConstants;
import kd.wtc.wtbs.wtabm.common.entity.VaLactationTimeStorage;
import kd.wtc.wtbs.wtp.enums.vaplan.BaseSetTimeBreastDayTypeEnum;
import kd.wtc.wtbs.wtp.enums.vaplan.BaseSetTimeUnitEnum;

public class VaApplyMobBusiness
implements VaApplyMobConstants,
VaApplyConstants {
    private static final Log LOG = LogFactory.getLog(VaApplyMobBusiness.class);
    private final VaBaseService vaBaseService = VaBaseService.getInstance();
    private final HRBaseServiceHelper vaApplyServiceHelper = (HRBaseServiceHelper)WTCAppContextHelper.getBean(VaApplyServiceHelper.class);
    private static final String SYSTEM_TYPE = "wtc-wtabm-business";

    private VaApplyMobBusiness() {
    }

    public static VaApplyMobBusiness getInstance() {
        return Instance.INSTANCE;
    }

    public void showEntryCardHeader(IFormView iFormView) {
        CardEntry entryGrid = (CardEntry)iFormView.getControl("entryentity");
        Object[] items = entryGrid.getEntryData().getDataEntitys();
        Boolean moreThanOne = Boolean.TRUE;
        if (ArrayUtils.isNotEmpty((Object[])items) && items.length == 1) {
            moreThanOne = Boolean.FALSE;
        }
        entryGrid.setChildVisible(moreThanOne.booleanValue(), 0, new String[]{"cardentryheadflex"});
        if (moreThanOne.booleanValue()) {
            IDataModel model = iFormView.getModel();
            for (int index = 0; index < items.length; ++index) {
                String billEntryName = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4f11\u5047\u660e\u7ec6%d", (String)"VaApplyMobBusiness_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), index + 1);
                model.setValue("billentryname", (Object)billEntryName, index);
            }
        } else {
            IDataModel model = iFormView.getModel();
            model.setValue("billentryname", (Object)"", 0);
        }
    }

    public void deleteEntry(IFormView view) {
        CardEntry entryGrid = (CardEntry)view.getControl("entryentity");
        int focusRow = entryGrid.getEntryState().getFocusRow();
        LOG.info("VaApplyMobBusiness.deleteEntry.focusRow:{}", (Object)focusRow);
        view.getModel().deleteEntryRow("entryentity", focusRow);
    }

    public List<Map<String, String>> queryVaApplyType(IFormView view) {
        DynamicObject mainDataEntity = view.getModel().getDataEntity(true);
        long attFileBo = mainDataEntity.getLong("attfile.id");
        DynamicObject entryClickRowData = this.getEntryClickRowData(view);
        DynamicObject vaType = entryClickRowData.getDynamicObject("entryvacationtype");
        Long vaTypeId = vaType != null ? Long.valueOf(vaType.getLong("id")) : null;
        LOG.info("VaApplyMobBusiness.queryBusTripType.attFileBo:{}", (Object)attFileBo);
        long parentBillId = mainDataEntity.getLong("parentid");
        long entryParentId = entryClickRowData.getLong("entryparentid");
        DynamicObject parentBillDyn = null;
        if (parentBillId != 0L) {
            parentBillDyn = this.vaApplyServiceHelper.loadSingle((Object)parentBillId);
        }
        List<Object> vaTypes = VaApplyService.getVaTypes(attFileBo, parentBillDyn, entryParentId, view.getEntityId(), BillCommonService.getInstance().getAuthAppIdForFormPlugin(view));
        List idList = vaTypes.stream().map(VaTypeSelectVo::getVaTypeId).collect(Collectors.toList());
        QFilter audit = new QFilter("id", "in", idList);
        audit.and(WTCHisServiceHelper.statusValidQFilter());
        DynamicObject orgDy = mainDataEntity.getDynamicObject("org");
        if (orgDy != null) {
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"wtbd_vacationtype", (Long)orgDy.getLong("id"));
            if (baseDataFilter != null) {
                audit.and(baseDataFilter);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8003\u52e4\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"VaApplyService_08", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        HRBaseServiceHelper typeHelper = new HRBaseServiceHelper("wtbd_vacationtype");
        DynamicObject[] query = typeHelper.query(new QFilter[]{audit});
        Set typeIdSet = Arrays.stream(query).map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
        Map<Long, VaTypeSelectVo> vaTypeMap = vaTypes.stream().filter(type -> typeIdSet.contains(type.getVaTypeId())).collect(Collectors.toMap(VaTypeSelectVo::getVaTypeId, vaTypeSelectVo -> vaTypeSelectVo));
        vaTypes = vaTypes.stream().filter(vaTypeVo -> vaTypeMap.get(vaTypeVo.getVaTypeId()) != null).collect(Collectors.toList());
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(BillCommonService.getInstance().getAuthAppIdForFormPlugin(view), view.getEntityId());
        vaTypes = this.vaBaseService.getVaTypeSelectVos(vaTypes, attFileBo, entryClickRowData, parentBillDyn, applyAttr);
        LOG.info("VaApplyMobBusiness.queryBusTripType.typeRegulation:{}", vaTypes);
        Map<Long, String> vacationType = this.getVacationType();
        ArrayList result = Lists.newArrayListWithExpectedSize((int)vaTypes.size());
        if (vaTypes.size() == 0) {
            return result;
        }
        for (VaTypeSelectVo vaTypeSelectVo2 : vaTypes) {
            HashMap param = Maps.newHashMapWithExpectedSize((int)16);
            long id = vaTypeSelectVo2.getVaTypeId();
            if (vaTypeId != null && id == vaTypeId) {
                param.put("select", "1");
            }
            param.put("text", vacationType.get(id));
            param.put("id", String.valueOf(id));
            LOG.info("VaApplyMobBusiness.queryBusTripType.types.getAttpolicyId():{}", (Object)vaTypeSelectVo2.getAttpolicyId());
            if (vaTypeSelectVo2.getAttpolicyId() != 0L) {
                param.put("formid", String.valueOf(vaTypeSelectVo2.getAttpolicyId()));
            }
            param.put("unit", vaTypeSelectVo2.getUnit());
            if (vaTypeSelectVo2.getMinApplyTime() != null) {
                param.put("minApplyTime", vaTypeSelectVo2.getMinApplyTime().setScale(2, RoundingMode.HALF_UP).toString());
            } else {
                param.put("minApplyTime", null);
            }
            if (vaTypeSelectVo2.getIsDeduction()) {
                String remainTime = String.valueOf(vaTypeSelectVo2.getRemainTime().setScale(2, RoundingMode.HALF_UP));
                String formId = view.getFormShowParameter().getFormId();
                VaQuotaResInfo vaTypeQuotaInfo = new VaQuotaResInfo(remainTime, vaTypeSelectVo2.getRemainUnit(), BaseSetTimeUnitEnum.getLocalName((String)vaTypeSelectVo2.getRemainUnit()), null);
                OnRenameVaTypeEvent onRenameVaTypeEvent = VaApplyExtHelper.onRenameVaTypeEvent(null, id, formId, vaTypeQuotaInfo);
                boolean showQuota = true;
                if (onRenameVaTypeEvent != null) {
                    if (!onRenameVaTypeEvent.isCancel()) {
                        param.put("text", onRenameVaTypeEvent.getVaTypeName());
                        showQuota = onRenameVaTypeEvent.isShowQuotas();
                    } else {
                        showQuota = false;
                    }
                }
                if (showQuota) {
                    param.put("isdeduction", Boolean.TRUE.toString());
                    param.put("remaintime", remainTime);
                    param.put("remainunit", vaTypeSelectVo2.getRemainUnit());
                }
            }
            result.add(param);
        }
        return result;
    }

    public List<Map<String, String>> querySpeMeth(IFormView view) {
        String lactationTypeStr = view.getPageCache().get("breastdaytypedata");
        LOG.info("VaApplyMobBusiness.querySpeMeth.lactationTypeStr:{}", (Object)lactationTypeStr);
        if (!WTCStringUtils.isEmpty((String)lactationTypeStr)) {
            DynamicObject entryClickRowData = this.getEntryClickRowData(view);
            DynamicObject busTripType = entryClickRowData.getDynamicObject("specialvamethod");
            Long vaMethodId = busTripType != null ? Long.valueOf(busTripType.getLong("id")) : null;
            Set lactationTypeSet = Arrays.stream(lactationTypeStr.split(",")).filter(WTCStringUtils::isNotEmpty).map(Long::valueOf).collect(Collectors.toSet());
            HRBaseServiceHelper methodHelper = new HRBaseServiceHelper("wtbd_breastdaytype");
            QFilter qFilter = new QFilter("id", "in", lactationTypeSet);
            DynamicObject[] query = methodHelper.query(new QFilter[]{qFilter});
            ArrayList result = Lists.newArrayListWithExpectedSize((int)query.length);
            if (query.length == 0) {
                return result;
            }
            for (DynamicObject dynObj : query) {
                HashMap param = Maps.newHashMapWithExpectedSize((int)4);
                long id = dynObj.getLong("id");
                if (vaMethodId != null && id == vaMethodId) {
                    param.put("select", "1");
                }
                param.put("text", dynObj.getString("name"));
                param.put("id", String.valueOf(id));
                result.add(param);
            }
            return result;
        }
        return Lists.newArrayList();
    }

    public List<Map<String, String>> queryChangEver(IFormView view) {
        DynamicObject entryClickRowData = this.getEntryClickRowData(view);
        Object entryParentId = entryClickRowData.get("entryparentid");
        String strEntryParId = entryParentId != null ? entryParentId.toString() : null;
        Object pkId = view.getFormShowParameter().getCustomParam("changeId");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtabm_vaapply");
        DynamicObject parentBillDyn = serviceHelper.loadSingle((Object)Long.valueOf(pkId.toString()));
        List<ComboItem> comboItem = VaApplyService.createComboItems(parentBillDyn);
        LOG.info("VaApplyMobBusiness.queryChangEver.comboItem:{}", comboItem);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)comboItem.size());
        if (comboItem.size() == 0) {
            return result;
        }
        for (ComboItem dynObj : comboItem) {
            HashMap param = Maps.newHashMapWithExpectedSize((int)4);
            if (dynObj.getValue() != null && dynObj.getValue().equals(strEntryParId)) {
                param.put("select", "1");
            }
            param.put("text", dynObj.getCaption().toString());
            param.put("id", dynObj.getValue());
            param.put("formid", null);
            result.add(param);
        }
        return result;
    }

    public List<DynamicObject> getEntryEntityDynamicObjects(IFormView view, String entityName) {
        EntryGrid entryGrid = (EntryGrid)view.getControl(entityName);
        EntryData entryData = entryGrid.getEntryData();
        DynamicObject[] dataEntity = entryData.getDataEntitys();
        return Arrays.asList(dataEntity);
    }

    public DynamicObject getEntryClickRowData(IFormView view) {
        CardEntry entryGrid = (CardEntry)view.getControl("entryentity");
        int focusRow = entryGrid.getEntryState().getFocusRow();
        view.getPageCache().put("focusRow", String.valueOf(focusRow));
        List<DynamicObject> entryEntityDynamicObjects = VaApplyMobBusiness.getInstance().getEntryEntityDynamicObjects(view, "entryentity");
        DynamicObject dynamicObject = entryEntityDynamicObjects.get(focusRow);
        return dynamicObject;
    }

    private Map<Long, String> getVacationType() {
        HRBaseServiceHelper typeHelper = new HRBaseServiceHelper("wtbd_vacationtype");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)"C");
        DynamicObject[] vacationType = typeHelper.query(new QFilter[]{enable, status});
        HashMap<Long, String> typeMap = new HashMap<Long, String>(vacationType.length);
        for (DynamicObject type : vacationType) {
            typeMap.put(type.getLong("id"), type.getString("name"));
        }
        return typeMap;
    }

    public void showVaUpdateAppro(IFormView view) {
        String applyType = (String)view.getModel().getValue("applytyperadio");
        String entityNumber = "wtabm_vaapply";
        String targetFormId = "wtabm_vaupdateappro";
        if ("0".equals(applyType)) {
            targetFormId = "wtabm_vaupdateappro_self";
            entityNumber = "wtabm_vaapplyself";
        }
        long pkId = view.getModel().getDataEntity().getLong("id");
        this.releaseMutexIfIsCurrentUser(pkId, entityNumber);
        BillContainerService.getInstance().openDetailPageOfSave(view, targetFormId, pkId, (Map)Maps.newHashMap());
    }

    public void showFeedBackPage(IFormView view) {
        String applyType = (String)view.getModel().getValue("applytyperadio");
        long applyPkId = view.getModel().getDataEntity().getLong("id");
        String applyName = ResManager.loadKDString((String)"\u4f11\u5047\u53d8\u66f4\u7533\u8bf7", (String)"VaUpdateMobChangePlugin_3", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]);
        String targetFormId = "wtabm_vaupdateappro";
        if ("0".equals(applyType)) {
            targetFormId = "wtabm_vaupdateappro_self";
        }
        LOG.info("\u63d0\u4ea4\u6210\u529f\u8df3\u8f6c\u9875\u9762\uff1a applyName:{}, targetFormId:{}, applyPkId:{}", new Object[]{applyName, targetFormId, applyPkId});
        BillContainerService.getInstance().openSuccessPage(view, applyName, targetFormId, applyPkId);
    }

    public void openHomePage(IFormView view) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setFormId("wtss_mobilehomepage");
        view.showForm((FormShowParameter)showParameter);
    }

    public String getVaTotalTimeStr(DynamicObject vaApplyBill) {
        DynamicObjectCollection dynObjCollection = vaApplyBill.getDynamicObjectCollection("entryentity");
        HashMap<Long, ArrayList<SummaryVaTypeVo>> map = new HashMap<Long, ArrayList<SummaryVaTypeVo>>(16);
        for (DynamicObject row : dynObjCollection) {
            if (row.getDynamicObject("entryvacationtype") == null || row.getString("entryunit") == null) continue;
            LOG.info("VaApplyMobBusiness.getVaTotalTimeStr.setDay:{}", (Object)row.getBigDecimal("entryvatimeday"));
            LOG.info("VaApplyMobBusiness.getVaTotalTimeStr.setHour:{}", (Object)row.getBigDecimal("entryvatimehour"));
            LOG.info("VaApplyMobBusiness.getVaTotalTimeStr.unit:{}", (Object)row.getString("entryunit"));
            Long vaTypeId = row.getLong("entryvacationtype.id");
            String vaTypeName = row.getString("entryvacationtype.name");
            ArrayList<SummaryVaTypeVo> summaryVaTypeVos = (ArrayList<SummaryVaTypeVo>)map.get(vaTypeId);
            if (Objects.nonNull(summaryVaTypeVos)) {
                summaryVaTypeVos.add(this.setSummaryVaTypeVo(vaTypeName, row));
                continue;
            }
            summaryVaTypeVos = new ArrayList<SummaryVaTypeVo>(10);
            summaryVaTypeVos.add(this.setSummaryVaTypeVo(vaTypeName, row));
            map.put(vaTypeId, summaryVaTypeVos);
        }
        String totalTime = "";
        if (map.size() > 0) {
            totalTime = VaApplyService.buildSumStr(map.values());
        }
        return totalTime;
    }

    public void setType(String fieldName, IFormView view, Map<String, String> returnData) {
        CardEntry entryGrid = (CardEntry)view.getControl("entryentity");
        int focusRow = entryGrid.getEntryState().getFocusRow();
        DynamicObjectCollection entryEntities = view.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (focusRow < 0 || entryEntities.size() <= focusRow) {
            LOG.info("setType\u91cd\u590d\u70b9\u51fb\uff0cfieldName:{}, returnData:{}", (Object)fieldName, returnData);
            return;
        }
        if (MapUtils.isEmpty(returnData)) {
            return;
        }
        if ("0".equals(returnData.get("id"))) {
            view.getModel().setValue(fieldName, null, focusRow);
            return;
        }
        long id = Long.parseLong(returnData.get("id"));
        view.getModel().setValue(fieldName, (Object)id, focusRow);
    }

    public void setSelectDates(IFormView view, Map<String, String> returnData) {
        String focusRow = view.getPageCache().get("focusRow");
        if (MapUtils.isEmpty(returnData)) {
            view.getModel().setValue("entrystartdate", null, Integer.parseInt(focusRow));
            view.getModel().setValue("entryenddate", null, Integer.parseInt(focusRow));
            view.getModel().setValue("entrystartmethod", null, Integer.parseInt(focusRow));
            view.getModel().setValue("entryendmethod", null, Integer.parseInt(focusRow));
            view.getModel().setValue("entrystarttimetext", null, Integer.parseInt(focusRow));
            view.getModel().setValue("entryendtimetext", null, Integer.parseInt(focusRow));
            view.getModel().setValue("entryapplytimetext", null, Integer.parseInt(focusRow));
            view.getModel().setValue("entryunit", null, Integer.parseInt(focusRow));
            view.getModel().setValue("entryvatimeday", null, Integer.parseInt(focusRow));
            view.getModel().setValue("entryvatimehour", null, Integer.parseInt(focusRow));
        } else {
            view.getPageCache().put("entrystartmethod", returnData.get("startmethod"));
            view.getPageCache().put("entryendmethod", returnData.get("endmethod"));
            if ("3".equals(returnData.get("startmethod"))) {
                view.getPageCache().put("entrystartdate", String.valueOf(this.transferString2Date(returnData.get("startdate"), 1).getTime()));
                view.getPageCache().put("entryenddate", String.valueOf(this.transferString2Date(returnData.get("enddate"), 1).getTime()));
            } else {
                view.getPageCache().put("entrystartdate", String.valueOf(this.transferString2Date(returnData.get("startdate"), 0).getTime()));
                view.getPageCache().put("entryenddate", String.valueOf(this.transferString2Date(returnData.get("enddate"), 0).getTime()));
            }
            view.getModel().setValue("entrystartmethod", (Object)returnData.get("startmethod"), Integer.parseInt(focusRow));
            view.getModel().setValue("entryendmethod", (Object)returnData.get("endmethod"), Integer.parseInt(focusRow));
            if ("3".equals(returnData.get("startmethod"))) {
                view.getModel().setValue("entrystartdate", (Object)this.transferString2Date(returnData.get("startdate"), 1), Integer.parseInt(focusRow));
                view.getModel().setValue("entryenddate", (Object)this.transferString2Date(returnData.get("enddate"), 1), Integer.parseInt(focusRow));
            } else {
                view.getModel().setValue("entrystartdate", (Object)this.transferString2Date(returnData.get("startdate"), 0), Integer.parseInt(focusRow));
                view.getModel().setValue("entryenddate", (Object)this.transferString2Date(returnData.get("enddate"), 0), Integer.parseInt(focusRow));
            }
            if (!"3".equals(returnData.get("startmethod"))) {
                view.getModel().setValue("entrystarttimetext", (Object)this.getVaMethodStr(returnData.get("startmethod")), Integer.parseInt(focusRow));
            } else {
                view.getModel().setValue("entrystarttimetext", (Object)returnData.get("startdatestr"), Integer.parseInt(focusRow));
            }
            if (!"3".equals(returnData.get("endmethod"))) {
                view.getModel().setValue("entryendtimetext", (Object)this.getVaMethodStr(returnData.get("endmethod")), Integer.parseInt(focusRow));
            } else {
                view.getModel().setValue("entryendtimetext", (Object)returnData.get("enddatestr"), Integer.parseInt(focusRow));
            }
        }
    }

    public void setTimeFrame(IFormView view, VaLactationTimeStorage timeStorage) {
        String focusRow = view.getPageCache().get("focusRow");
        String timeStorageText = this.setTimeFrameText(timeStorage);
        view.getModel().setValue("specialextjson", (Object)JSON.toJSONString((Object)timeStorage), Integer.parseInt(focusRow));
        view.getModel().setValue("timeframeshow", (Object)timeStorageText, Integer.parseInt(focusRow));
    }

    public String setTimeFrameText(VaLactationTimeStorage timeStorage) {
        StringBuilder showText = new StringBuilder();
        if (timeStorage.getTimeStartOne() > 0) {
            showText.append(this.getVideoFormat(timeStorage.getTimeStartOne()));
        }
        if (timeStorage.getTimeEndOne() > 0) {
            showText.append('-');
            showText.append(this.getVideoFormat(timeStorage.getTimeEndOne()));
        }
        if (timeStorage.getTimeStartTwo() > 0) {
            showText.append(';');
            showText.append(this.getVideoFormat(timeStorage.getTimeStartTwo()));
        }
        if (timeStorage.getTimeEndTwo() > 0) {
            showText.append('-');
            showText.append(this.getVideoFormat(timeStorage.getTimeEndTwo()));
        }
        if (timeStorage.getTimeStartThree() > 0) {
            showText.append(';');
            showText.append(this.getVideoFormat(timeStorage.getTimeStartThree()));
        }
        if (timeStorage.getTimeEndThree() > 0) {
            showText.append('-');
            showText.append(this.getVideoFormat(timeStorage.getTimeEndThree()));
        }
        if (timeStorage.getTimeStartFour() > 0) {
            showText.append(';');
            showText.append(this.getVideoFormat(timeStorage.getTimeStartFour()));
        }
        if (timeStorage.getTimeEndFour() > 0) {
            showText.append('-');
            showText.append(this.getVideoFormat(timeStorage.getTimeEndFour()));
        }
        if (timeStorage.getTimeStartFive() > 0) {
            showText.append('-');
            showText.append(this.getVideoFormat(timeStorage.getTimeStartFive()));
        }
        if (timeStorage.getTimeEndFive() > 0) {
            showText.append('-');
            showText.append(this.getVideoFormat(timeStorage.getTimeEndFive()));
        }
        return showText.toString();
    }

    public void setVaTime(DynamicObjectCollection vaApplyBillEntry, IDataModel model) {
        for (int index = 0; index < vaApplyBillEntry.size(); ++index) {
            String vaTimeUnit;
            String vaTime;
            if (HRStringUtils.equals((String)((DynamicObject)vaApplyBillEntry.get(index)).getString("entryunit"), (String)"A")) {
                vaTime = ((DynamicObject)vaApplyBillEntry.get(index)).getBigDecimal("entryvatimeday").setScale(2, RoundingMode.HALF_UP).toString();
                vaTimeUnit = String.format(ResManager.loadKDString((String)"%s\u5929", (String)"VaApplyMobBusiness_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), vaTime);
            } else {
                vaTime = ((DynamicObject)vaApplyBillEntry.get(index)).getBigDecimal("entryvatimehour").setScale(2, RoundingMode.HALF_UP).toString();
                vaTimeUnit = String.format(ResManager.loadKDString((String)"%s\u5c0f\u65f6", (String)"VaApplyMobBusiness_6", (String)SYSTEM_TYPE, (Object[])new Object[0]), vaTime);
            }
            if (((DynamicObject)vaApplyBillEntry.get(index)).getString("entryunit") != null) {
                model.setValue("entryapplytimetext", (Object)" ", index);
                model.setValue("entryapplytimetext", (Object)vaTimeUnit, index);
                continue;
            }
            model.setValue("entryapplytimetext", (Object)" ", index);
        }
    }

    public void setShowDate(DynamicObjectCollection vaApplyBillEntry, IDataModel model) {
        for (int index = 0; index < vaApplyBillEntry.size(); ++index) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            String startDate = "";
            String endDate = "";
            if (((DynamicObject)vaApplyBillEntry.get(index)).get("entrystartdate") != null) {
                startDate = simpleDateFormat.format(((DynamicObject)vaApplyBillEntry.get(index)).get("entrystartdate"));
            }
            if (((DynamicObject)vaApplyBillEntry.get(index)).get("entryenddate") != null) {
                endDate = simpleDateFormat.format(((DynamicObject)vaApplyBillEntry.get(index)).get("entryenddate"));
            }
            String startMethod = ((DynamicObject)vaApplyBillEntry.get(index)).getString("entrystartmethod");
            String endMethod = ((DynamicObject)vaApplyBillEntry.get(index)).getString("entryendmethod");
            String startDateParse = this.dateTransformation(startDate, startMethod);
            String endDateParse = this.dateTransformation(endDate, endMethod);
            model.setValue("entrystarttimetext", (Object)startDateParse, index);
            model.setValue("entryendtimetext", (Object)endDateParse, index);
        }
    }

    public void setFieldMustInput(List<String> mustInputFieldList, IFormView view, int focusRow) {
        if (mustInputFieldList.size() > 0) {
            CardEntry entryGrid = (CardEntry)view.getControl("entryentity");
            entryGrid.setChildVisible(true, focusRow, new String[]{"isreasonrequire"});
            view.getModel().setValue("vareasoncheck", (Object)Boolean.TRUE, focusRow);
        }
    }

    public List<String> setMustInpConvert(List<String> mustInputFieldList) {
        ArrayList<String> mustInpList = new ArrayList<String>(16);
        if (mustInputFieldList.contains("isreasonrequire")) {
            mustInpList.add("entryreason");
        }
        return mustInpList;
    }

    private SummaryVaTypeVo setSummaryVaTypeVo(String vaTypeName, DynamicObject row) {
        SummaryVaTypeVo summaryVaTypeVo = new SummaryVaTypeVo();
        summaryVaTypeVo.setVaTypeName(vaTypeName);
        String unit = row.getString("entryunit");
        summaryVaTypeVo.setUnit(unit);
        summaryVaTypeVo.setDay(row.getBigDecimal("entryvatimeday"));
        summaryVaTypeVo.setHour(row.getBigDecimal("entryvatimehour"));
        return summaryVaTypeVo;
    }

    public void setVaApproInfo(DynamicObject mainEntity, IFormView view, int type) {
        this.vaTotalTimeLineFeed(mainEntity, view, "vasumflex", "det");
        Label billHeader = (Label)view.getControl("billheader");
        String billHeaderStr = "";
        switch (type) {
            case 0: {
                billHeaderStr = ResManager.loadKDString((String)"%s\u7684\u4f11\u5047\u7533\u8bf7\u5355", (String)"VaApplyMobBusiness_9", (String)SYSTEM_TYPE, (Object[])new Object[]{mainEntity.getString("personid.name")});
                break;
            }
            case 1: {
                if (mainEntity.getBoolean("isnotleave")) {
                    billHeaderStr = ResManager.loadKDString((String)"%s\u7684\u4f11\u5047\u5931\u6548\u53d8\u66f4\u7533\u8bf7\u5355", (String)"VaApplyMobBusiness_10", (String)SYSTEM_TYPE, (Object[])new Object[]{mainEntity.getString("personid.name")});
                    break;
                }
                billHeaderStr = ResManager.loadKDString((String)"%s\u7684\u4f11\u5047\u53d8\u66f4\u7533\u8bf7\u5355", (String)"VaApplyMobBusiness_11", (String)SYSTEM_TYPE, (Object[])new Object[]{mainEntity.getString("personid.name")});
                break;
            }
        }
        billHeader.setText(billHeaderStr);
        view.updateView("entryentity");
    }

    public void setApproEntity(DynamicObject mainEntity, IDataModel model) {
        DynamicObjectCollection entryEntity = mainEntity.getDynamicObjectCollection("entryentity");
        this.setShowDate(entryEntity, model);
        this.setVaTime(entryEntity, model);
        this.setSeqText(entryEntity, model);
    }

    public void setApplyEntity(DynamicObject mainEntity, IDataModel model) {
        DynamicObjectCollection entryEntity = mainEntity.getDynamicObjectCollection("entryentity");
        this.setShowDate(entryEntity, model);
        this.setVaTime(entryEntity, model);
    }

    public void setBreLeaveInfo(DynamicObject mainEntity, IFormView iFormView) {
        DynamicObjectCollection entryEntity = mainEntity.getDynamicObjectCollection("entryentity");
        for (int index = 0; index < entryEntity.size(); ++index) {
            if (((DynamicObject)entryEntity.get(index)).get("specialvatype") == null || ((DynamicObject)entryEntity.get(index)).get("specialextjson") == null) continue;
            iFormView.setVisible(Boolean.TRUE, new String[]{"flexpanelbreleave"});
            LOG.info("VaApplyMobBusiness.setBreLeaveInfo");
            VaLactationTimeStorage timeStorage = (VaLactationTimeStorage)JSON.parseObject((String)((DynamicObject)entryEntity.get(index)).getString("specialextjson"), VaLactationTimeStorage.class);
            LOG.info("VaApplyMobBusiness.timeStorage {}", (Object)SerializationUtils.toJsonString((Object)timeStorage));
            if (timeStorage == null) continue;
            String timeStorageText = this.setTimeFrameText(timeStorage);
            iFormView.getModel().setValue("timeframeshow", (Object)timeStorageText, index);
            Label label = (Label)iFormView.getControl("lactationdesc");
            label.setText(VaKDStringHelper.lactationDesc(timeStorage.getFetuses(), timeStorage.getBornDate(), timeStorage.getLactationEndDate(), timeStorage.getOffTimePerDay()));
            VaEntityCheckService checkTypeHelper = this.getVaCheckHelper(mainEntity, (DynamicObject)entryEntity.get(index), iFormView);
            DynamicObject matchBaseSet = checkTypeHelper.getBaseSetDy();
            if (matchBaseSet == null || !matchBaseSet.getBoolean("isspecialholiday")) continue;
            VaInfoService.cacheBreastDateTypes(iFormView.getPageCache(), matchBaseSet);
        }
    }

    public VaEntityCheckService getVaCheckHelper(DynamicObject billDataEntity, DynamicObject dataEntity, IFormView iFormView) {
        DynamicObject mainDataEntity = iFormView.getModel().getDataEntity(true);
        long attFileBo = mainDataEntity.getLong("attfile.id");
        ApplyBillCheckEnum checkEnum = ApplyBillCheckEnum.VACATION;
        LOG.info("VaApplyMobDetailPlugin.getVaCheckHelper.attFileBo:{}, entryVacationType:{}", (Object)attFileBo, dataEntity.get("entryvacationtype"));
        boolean needCheckAttFileAuth = StringUtils.equals((CharSequence)billDataEntity.getString("applytyperadio"), (CharSequence)"1");
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(BillCommonService.getInstance().getAuthAppIdForFormPlugin(iFormView), iFormView.getEntityId());
        return VaEntityCheckService.createService(attFileBo, checkEnum, dataEntity, needCheckAttFileAuth, applyAttr);
    }

    public void setSeqText(DynamicObjectCollection vaApplyBillEntry, IDataModel model) {
        for (int index = 0; index < vaApplyBillEntry.size(); ++index) {
            model.setValue("seqtext", (Object)(index + 1), index);
        }
    }

    public void setUpAndDown(String key, IFormView view, IDataModel model) {
        String formId = view.getFormShowParameter().getFormId();
        DynamicObjectCollection entryEntity = model.getDataEntity(true).getDynamicObjectCollection("entryentity");
        CardEntry cardEntry = (CardEntry)view.getControl("entryentity");
        if ("panelup".equals(key) || "lbl_up".equals(key)) {
            for (int index = 0; index < entryEntity.size(); ++index) {
                if (index == 0) continue;
                if (StringUtils.equals((CharSequence)"wtabm_vaapplyappro", (CharSequence)formId)) {
                    cardEntry.setChildVisible(false, index, new String[]{"cardviewpanel"});
                    continue;
                }
                cardEntry.setChildVisible(false, index, new String[]{"cardentryflexpanelap"});
            }
            view.setVisible(Boolean.FALSE, new String[]{"flexdownup"});
            view.setVisible(Boolean.TRUE, new String[]{"paneldown"});
            view.setVisible(Boolean.FALSE, new String[]{"panelup"});
            view.getPageCache().put("updown", "up");
        } else if ("paneldown".equals(key) || "lbl_down".equals(key)) {
            for (int index = 0; index < entryEntity.size(); ++index) {
                if (index == 0) continue;
                if (StringUtils.equals((CharSequence)"wtabm_vaapplyappro", (CharSequence)formId)) {
                    cardEntry.setChildVisible(true, index, new String[]{"cardviewpanel"});
                    continue;
                }
                cardEntry.setChildVisible(true, index, new String[]{"cardentryflexpanelap"});
            }
            view.setVisible(Boolean.TRUE, new String[]{"flexdownup"});
            view.setVisible(Boolean.TRUE, new String[]{"panelup"});
            view.setVisible(Boolean.FALSE, new String[]{"paneldown"});
            view.getPageCache().put("updown", "down");
        }
    }

    public void setChangEver(IFormView view, Map<String, String> returnData) {
        String focusRow = view.getPageCache().get("focusRow");
        if (MapUtils.isEmpty(returnData)) {
            return;
        }
        long id = Long.parseLong(returnData.get("id"));
        String name = returnData.get("text");
        view.getModel().setValue("entryparentid", (Object)id, Integer.parseInt(focusRow));
        view.getModel().setValue("changever", (Object)name, Integer.parseInt(focusRow));
    }

    public void vaTotalTimeLineFeed(DynamicObject mainEntity, IFormView view, String flexId, String pageFlag) {
        String vaTotalCache = view.getPageCache().get("detVaTotalTime");
        if ("vaapply".equals(pageFlag)) {
            vaTotalCache = view.getPageCache().get("vaTotalTime");
        }
        if (vaTotalCache != null) {
            List cacheNames = (List)SerializationUtils.deSerializeFromBase64((String)vaTotalCache);
            for (String cacheName : cacheNames) {
                this.deleteTag(view, flexId, cacheName);
            }
        }
        ArrayList<String> vaTotalLabNames = new ArrayList<String>(16);
        String vaTotalTimeStr = this.getVaTotalTimeStr(mainEntity);
        if (StringUtils.isEmpty((CharSequence)vaTotalTimeStr)) {
            return;
        }
        String[] vaTotalTimes = vaTotalTimeStr.split(",");
        for (int index = 0; index < vaTotalTimes.length; ++index) {
            this.addTag(view, flexId, pageFlag + "vatotaltime" + index, vaTotalTimes[index]);
            vaTotalLabNames.add(pageFlag + "vatotaltime" + index);
        }
        String cacheString = SerializationUtils.serializeToBase64(vaTotalLabNames);
        if ("vaapply".equals(pageFlag)) {
            view.getPageCache().put("vaTotalTime", cacheString);
        } else {
            view.getPageCache().put("detVaTotalTime", cacheString);
        }
    }

    private void addTag(IFormView view, String flexId, String tagId, String name) {
        Container flexpanelap = (Container)view.getControl(flexId);
        FlexPanelAp completeLabelPanelAp = new FlexPanelAp();
        completeLabelPanelAp.setKey(tagId);
        completeLabelPanelAp.setLazyLoad(false);
        completeLabelPanelAp.setClickable(true);
        completeLabelPanelAp.setGrow(0);
        completeLabelPanelAp.setForeColor("#666666");
        Style style = new Style();
        completeLabelPanelAp.setStyle(style);
        ArrayList<Map> listitem = new ArrayList<Map>();
        LabelAp title = new LabelAp();
        title.setKey(tagId);
        title.setName(new LocaleString(name));
        title.setClickable(true);
        title.setForeColor("#212121");
        title.setFontSize(14);
        completeLabelPanelAp.getItems().add(title);
        listitem.add(completeLabelPanelAp.createControl());
        flexpanelap.addControls(listitem);
    }

    private void deleteTag(IFormView view, String flexId, String tagKey) {
        Container flexPanelAp = (Container)view.getControl(flexId);
        flexPanelAp.deleteControls(new String[]{tagKey});
    }

    public String dateTransformation(String dateStr, String dateMethod) {
        if ("".equals(dateStr)) {
            return null;
        }
        if ("0".equals(dateMethod)) {
            return ResManager.loadKDString((String)"\u4e0a\u534a\u5929", (String)"VaApplyMobBusiness_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        }
        if ("1".equals(dateMethod)) {
            return ResManager.loadKDString((String)"\u4e0b\u534a\u5929", (String)"VaApplyMobBusiness_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        }
        if ("2".equals(dateMethod)) {
            return ResManager.loadKDString((String)"\u5168\u5929", (String)"VaApplyMobBusiness_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        }
        return dateStr.substring(dateStr.length() - 6);
    }

    public Date transferString2Date(String str, int type) {
        SimpleDateFormat simpleDateFormat = type == 0 ? WTCInteDateUtil.getUserSimpleDateFormat() : WTCInteDateUtil.getUserDateTimeFormat();
        simpleDateFormat.setTimeZone(WTCInteDateUtil.getSysTimeZone().getTimeZone());
        try {
            return simpleDateFormat.parse(str);
        }
        catch (ParseException e) {
            LOG.warn("transferString2Date.error", (Throwable)e);
            return new Date();
        }
    }

    public String generateOneCodeRule(String numberKey, String entityId, DynamicObject dynamicObject) {
        Assert.notNull((Object)entityId, (String)"entityId");
        Assert.notNull((Object)dynamicObject, (String)"dynamicObject");
        Assert.notNull((Object)numberKey, (String)"numberKey");
        String number = CodeRuleServiceHelper.getNumber((String)entityId, (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)entityId), null);
        Assert.hasText((String)number, (String)"please configure rules on the platform");
        dynamicObject.set(numberKey, (Object)number);
        return number;
    }

    public void setPersonName(IFormView iFormView, Map<String, String> returnData) {
        String personId = returnData.get("personid");
        String attFile = returnData.get("attfile");
        String attFileBase = returnData.get("id");
        LOG.info("VaApplyMobBusiness.setPersonName.personId:{}", (Object)personId);
        LOG.info("VaApplyMobBusiness.setPersonName.attFile:{}", (Object)attFile);
        LOG.info("VaApplyMobBusiness.setPersonName.attFileBase:{}", (Object)attFileBase);
        if (personId != null && attFile != null) {
            iFormView.getModel().setValue("personid", (Object)Long.parseLong(personId));
            iFormView.getModel().setValue("attfilebasef7", (Object)Long.parseLong(attFileBase));
            iFormView.getModel().setValue("attfile", (Object)Long.parseLong(attFile));
        }
    }

    public void validateAttachment(BeforeDoOperationEventArgs args, IFormView iFormView) {
        AttachmentPanel attachmentpanel = (AttachmentPanel)iFormView.getControl("attachmentpanel");
        int attachmentCount = CollectionUtils.isEmpty((Collection)attachmentpanel.getAttachmentData()) ? 0 : attachmentpanel.getAttachmentData().size();
        AbstractOperate source = (AbstractOperate)args.getSource();
        source.getOption().setVariableValue("ATTACHMENT_COUNT", String.valueOf(attachmentCount));
    }

    public boolean validateMustInput(BeforeDoOperationEventArgs args, IFormView iFormView) {
        DynamicObject dataEntity = iFormView.getModel().getDataEntity(true);
        boolean isNotLeave = dataEntity.getBoolean("isnotleave");
        if (isNotLeave) {
            return true;
        }
        DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)collection)) {
            iFormView.showTipNotification(ResManager.loadKDString((String)"\u6700\u5c11\u9700\u8981\u4fdd\u75591\u6761\u4f11\u5047\u4fe1\u606f\u3002", (String)"VaApplyMobDetailPlugin_4", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        for (DynamicObject entryEntity : collection) {
            long entryVacationType = entryEntity.getLong("entryvacationtype.id");
            String entryStartMethod = entryEntity.getString("entrystartmethod");
            String entryEndMethod = entryEntity.getString("entryendmethod");
            Date entryStartDate = entryEntity.getDate("entrystartdate");
            Date entryEndDate = entryEntity.getDate("entryenddate");
            Boolean vaReasonCheck = entryEntity.getBoolean("vareasoncheck");
            String entryReason = entryEntity.getString("entryreason");
            Object speVaType = entryEntity.get("specialvatype");
            LOG.info("VaApplyMobBusiness.validateMustInput.speVaType:{}", speVaType);
            Object speVaMethod = entryEntity.get("specialvamethod");
            LOG.info("VaApplyMobBusiness.validateMustInput.speVaMethod:{}", speVaMethod);
            Object timeFrame = entryEntity.get("timeframeshow");
            LOG.info("VaApplyMobBusiness.validateMustInput.timeFrame:{}", timeFrame);
            VaLactationTimeStorage timeStorage = (VaLactationTimeStorage)JSON.parseObject((String)entryEntity.getString("specialextjson"), VaLactationTimeStorage.class);
            if (timeStorage != null) {
                String timeStorageText = this.setTimeFrameText(timeStorage);
                LOG.info("VaApplyMobBusiness.validateMustInput.timeStorageText:{}", (Object)timeStorageText);
                if ((timeFrame == null || StringUtils.isEmpty((CharSequence)timeFrame.toString())) && StringUtils.isNotEmpty((CharSequence)timeStorageText)) {
                    timeFrame = timeStorageText;
                }
            }
            if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{entryStartMethod, entryEndMethod}) || entryStartDate == null || entryEndDate == null) {
                iFormView.showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9\u201c\u65e5\u671f\u8303\u56f4\u201d\u3002", (String)"VaApplyMobDetailPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                args.setCancel(true);
                return false;
            }
            if (entryVacationType == 0L) {
                iFormView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u4f11\u5047\u7c7b\u578b\u201d\u3002", (String)"VaApplyMobDetailPlugin_11", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                args.setCancel(true);
                return false;
            }
            if (speVaType != null && !StringUtils.isEmpty((CharSequence)speVaType.toString())) {
                if (speVaMethod == null) {
                    iFormView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u54fa\u4e73\u5047\u4f11\u5047\u65b9\u5f0f\u201d\u3002", (String)"VaApplyMobDetailPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    args.setCancel(true);
                    return false;
                }
                long spVaMethodId = entryEntity.getLong("specialvamethod.id");
                LOG.info("VaApplyMobBusiness.validateMustInput.spVaMethodId:{}", (Object)spVaMethodId);
                if (NumberUtils.compare((long)spVaMethodId, (long)BaseSetTimeBreastDayTypeEnum.CUSTOM.id) == 0 && (timeFrame == null || StringUtils.isEmpty((CharSequence)timeFrame.toString()))) {
                    iFormView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u65f6\u95f4\u8303\u56f4\u201d\u3002", (String)"VaApplyMobDetailPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    args.setCancel(true);
                    return false;
                }
            }
            if (!vaReasonCheck.booleanValue() || entryReason != null && !StringUtils.isEmpty((CharSequence)entryReason.trim())) continue;
            iFormView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4f11\u5047\u539f\u56e0\u201d\u3002", (String)"VaApplyMobDetailPlugin_12", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        return this.valiteHandMust(args, iFormView);
    }

    public boolean valiteHandMust(BeforeDoOperationEventArgs args, IFormView iFormView) {
        DynamicObject entry = iFormView.getModel().getDataEntity();
        String handerRson = entry.getString("handperson");
        String handerReason = entry.getString("handreason");
        iFormView.getModel().setValue("isneedhand", (Object)(!HRStringUtils.isEmpty((String)handerRson) || !HRStringUtils.isEmpty((String)handerReason) ? 1 : 0));
        if (!HRStringUtils.isEmpty((String)handerRson) && HRStringUtils.isEmpty((String)handerReason) || HRStringUtils.isEmpty((String)handerRson) && !HRStringUtils.isEmpty((String)handerReason)) {
            iFormView.showTipNotification(ResManager.loadKDString((String)"\u201c\u4ea4\u63a5\u4eba\u201d\u3001\u201c\u4ea4\u63a5\u8bf4\u660e\u201d \u9700\u540c\u65f6\u586b\u5199\u6216\u540c\u65f6\u4e0d\u586b\u5199\u3002", (String)"VaApplyMobBusiness_13", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    public void setHandVisible(IFormView iFormView) {
        DynamicObject entry = iFormView.getModel().getDataEntity();
        String handPerson = entry.getString("handperson");
        iFormView.setVisible(Boolean.valueOf(!HRStringUtils.isEmpty((String)handPerson)), new String[]{"flexpanelapjj"});
        Label handPersonLabel = (Label)iFormView.getControl("labelapperson");
        handPersonLabel.setText(handPerson);
        Label handReasonLabel = (Label)iFormView.getControl("labelapreason");
        handReasonLabel.setText(entry.getString("handreason"));
    }

    public void setHandPanelVisible(IFormView iFormView, String billState) {
        String labelaPperson = iFormView.getPageCache().get("labelapperson");
        iFormView.setVisible(Boolean.valueOf(false), new String[]{"flexpanelaphandinfo"});
        iFormView.setVisible(Boolean.valueOf(true), new String[]{"flexpanelap211"});
    }

    public void setVaType(IFormView iFormView) {
        DynamicObjectCollection collection = iFormView.getModel().getEntryEntity("entryentity");
        DynamicObjectCollection vaTypeCollection = new DynamicObjectCollection();
        for (DynamicObject dynamicObject : collection) {
            if (dynamicObject.getDynamicObject("entryvacationtype") == null) continue;
            vaTypeCollection.add((Object)dynamicObject.getDynamicObject("entryvacationtype"));
        }
        if (!vaTypeCollection.isEmpty()) {
            iFormView.getModel().setValue("vacationtypelist", (Object)vaTypeCollection);
        }
    }

    public void setSubmit(IFormView iFormView) {
        DynamicObject mainDataEntity = iFormView.getModel().getDataEntity();
        mainDataEntity.set("submitter", (Object)RequestContext.get().getCurrUserId());
        mainDataEntity.set("submitdate", (Object)new Date());
    }

    public void billStatusCheck(String operateKey, DynamicObject curBillDyn, BeforeDoOperationEventArgs evt, IFormView iFormView) {
        long billId = curBillDyn.getLong("id");
        DynamicObject dynamicObject = VaApplyServiceHelper.INSTANCE.queryOriginalOne("billstatus", new QFilter("id", "=", (Object)billId));
        if (dynamicObject == null) {
            LOG.info("\u6570\u636e\u5e93\u4e2d\u5355\u636e\u5df2\u4e0d\u5b58\u5728\uff0c billId:{}", (Object)billId);
            iFormView.showErrorNotification(VaKDStringHelper.dataNotExistFail());
            evt.setCancel(true);
            return;
        }
        String billStatus = dynamicObject.getString("billstatus");
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"modify")) {
            if (!StringUtils.equalsAny((CharSequence)billStatus, (CharSequence[])new CharSequence[]{"A", "G"})) {
                iFormView.showTipNotification(VaKDStringHelper.statusCheckForModify());
                evt.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"delete")) {
            if (!StringUtils.equals((CharSequence)billStatus, (CharSequence)"A")) {
                iFormView.showTipNotification(VaKDStringHelper.statusCheckForDelete());
                evt.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit") && !StringUtils.equalsAny((CharSequence)billStatus, (CharSequence[])new CharSequence[]{"A", "G"})) {
            iFormView.showTipNotification(VaKDStringHelper.statusCheckForSubmit());
            evt.setCancel(true);
        }
    }

    public void billStatusCheckForDetail(String operateKey, DynamicObject curBillDyn, BeforeDoOperationEventArgs evt, IFormView iFormView) {
        OperationStatus status = iFormView.getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW == status) {
            return;
        }
        long billId = curBillDyn.getLong("id");
        DynamicObject dynamicObject = VaApplyServiceHelper.INSTANCE.queryOriginalOne("billstatus", new QFilter("id", "=", (Object)billId));
        if (dynamicObject == null) {
            LOG.info("\u6570\u636e\u5e93\u4e2d\u5355\u636e\u5df2\u4e0d\u5b58\u5728\uff0c billId:{}", (Object)billId);
            iFormView.showErrorNotification(VaKDStringHelper.dataNotExistFail());
            evt.setCancel(true);
            return;
        }
        String billStatus = dynamicObject.getString("billstatus");
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit") && !StringUtils.equalsAny((CharSequence)billStatus, (CharSequence[])new CharSequence[]{"A", "G"})) {
            iFormView.showTipNotification(VaKDStringHelper.statusCheckForSubmit());
            evt.setCancel(true);
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"save") && !StringUtils.equalsAny((CharSequence)billStatus, (CharSequence[])new CharSequence[]{"A", "G"})) {
            iFormView.showTipNotification(VaKDStringHelper.statusCheckForModify());
            evt.setCancel(true);
        }
    }

    public void releaseMutexIfIsCurrentUser(Long objectId, String entityType) {
        LOG.info("\u91ca\u653e\u9501\uff1aobjectId:{}, entityType{}", (Object)objectId, (Object)entityType);
        if (this.currentUserHasMutex(objectId, entityType)) {
            LOG.info("\u91ca\u653e\u9501,currentUserHasMutex");
            this.releaseMutex(objectId, entityType);
        }
    }

    public boolean currentUserHasMutex(Long objectId, String EntityType) {
        QFilter operateKeyFilter = new QFilter("operationkey", "=", (Object)"modify");
        QFilter entityKeyFilter = new QFilter("entitykey", "=", (Object)EntityType);
        QFilter objectIdFilter = new QFilter("objectid", "=", (Object)String.valueOf(objectId));
        QFilter userFilter = new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId());
        HRBaseServiceHelper dataLockHelper = new HRBaseServiceHelper("bos_datalock");
        DynamicObject[] dynamicObjects = dataLockHelper.query("id", new QFilter[]{objectIdFilter, operateKeyFilter, entityKeyFilter, userFilter});
        return dynamicObjects != null && dynamicObjects.length > 0;
    }

    public void releaseMutex(Long objectId, String EntityType) {
        boolean release = WTCMutexHelper.release((String)EntityType, (String)"modify", (String)String.valueOf(objectId));
        LOG.info("mobsupsign releaseMutex entityId:{},pkId:{},operateKey:{},result:{}", new Object[]{EntityType, objectId, "modify", release});
    }

    public String getVideoFormat(int time) {
        int hh = time / 3600;
        int mm = time % 3600 / 60;
        return (hh < 10 ? "0" + hh : Integer.valueOf(hh)) + ":" + (mm < 10 ? "0" + mm : Integer.valueOf(mm));
    }

    public void getQuotaInfoStr(IFormView view, DynamicObject rowVaTypeDyn, String remainTime, String remainUnit, int focusRow) {
        String vacationTypeProp;
        CardEntry entryGrid;
        String formId = view.getFormShowParameter().getFormId();
        if (StringUtils.equalsAny((CharSequence)formId, (CharSequence[])new CharSequence[]{"wtabm_vaupdate_change", "wtabm_vaupdateself_change"})) {
            entryGrid = (CardEntry)view.getControl("entryentitychange");
            vacationTypeProp = "entryvacationtypechange";
        } else {
            entryGrid = (CardEntry)view.getControl("entryentity");
            vacationTypeProp = "entryvacationtype";
        }
        IClientViewProxy clientProxy = ((AbstractFormView)view).getClientProxy();
        String unitStr = BaseSetTimeUnitEnum.getLocalName((String)remainUnit);
        String quotaStr = String.format(ResManager.loadKDString((String)"(\u53ef\u7528%1$s%2$s)", (String)"VaApplyMobBusiness_12", (String)SYSTEM_TYPE, (Object[])new Object[0]), remainTime, unitStr);
        String vaTypeNameSrc = rowVaTypeDyn.getString("name");
        String vaTypeNameStd = vaTypeNameSrc + quotaStr;
        OnRenameVaTypeEvent onRenameVaTypeEvent = new OnRenameVaTypeEvent(formId, rowVaTypeDyn, remainTime, remainUnit, unitStr);
        onRenameVaTypeEvent.overrideVaTypeName(vaTypeNameStd);
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, VaTypeRenamePlugin.class, (String)"kd.sdk.wtc.wtabm.business.quota.VaTypeRenamePlugin", null);
        hrPluginProxy.callReplace(plugin -> {
            plugin.onRenameVaTypeName(onRenameVaTypeEvent);
            return null;
        });
        String vaTypeNameExt = onRenameVaTypeEvent.getVaTypeName();
        if (onRenameVaTypeEvent.isCancel()) {
            return;
        }
        clientProxy.setEntryFieldValue((AbstractGrid)entryGrid, vacationTypeProp, focusRow, (Object)new Object[]{rowVaTypeDyn.getString("number"), vaTypeNameExt, rowVaTypeDyn.getString("number"), "", ""});
    }

    private String getVaMethodStr(String vaMethod) {
        String vaMethodStr = ResManager.loadKDString((String)"\u65f6\u5206", (String)"VaApplyMobBusiness_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)vaMethod, (CharSequence)"0")) {
            vaMethodStr = ResManager.loadKDString((String)"\u4e0a\u534a\u5929", (String)"VaApplyMobBusiness_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        } else if (StringUtils.equals((CharSequence)vaMethod, (CharSequence)"1")) {
            vaMethodStr = ResManager.loadKDString((String)"\u4e0b\u534a\u5929", (String)"VaApplyMobBusiness_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        } else if (StringUtils.equals((CharSequence)vaMethod, (CharSequence)"2")) {
            vaMethodStr = ResManager.loadKDString((String)"\u5168\u5929", (String)"VaApplyMobBusiness_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        } else if (StringUtils.equals((CharSequence)vaMethod, (CharSequence)"3")) {
            vaMethodStr = ResManager.loadKDString((String)"\u65f6\u5206", (String)"VaApplyMobBusiness_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        }
        return vaMethodStr;
    }

    public void refreshApplyTimes(IFormView formView) {
        DynamicObject billDyn = formView.getModel().getDataEntity();
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(BillCommonService.getInstance().getAuthAppIdForFormPlugin(formView), formView.getEntityId());
        DynamicObject billDynNew = formView.getModel().getDataEntity(true);
        VaBillCheckService vaBillCheckService = new VaBillCheckService(ApplyBillCheckEnum.VACATION, UnifyBillEnum.VA, Collections.singletonList(billDyn), applyAttr);
        BillResponse billResponse = vaBillCheckService.refresh();
        LOG.info("\u91cd\u65b0\u6821\u9a8c\u6240\u6709\u6821\u9a8c\u9879\u5e76\u751f\u6210\u4f11\u5047\u4fe1\u606f\u7ed3\u679c\uff1a{}\uff0c\u63d0\u793a\u4fe1\u606f\uff1a{}", (Object)billResponse.isSuccess(), (Object)billResponse.getMessage());
    }

    public boolean handleCheckAttFileVersion(AbstractMobFormPlugin billPlugIn, String openConfirmCustomVal) {
        boolean versionChange;
        IFormView view = billPlugIn.getView();
        IDataModel model = view.getModel();
        DynamicObject attFileF7Dy = (DynamicObject)model.getValue("attfilebasef7");
        if (attFileF7Dy == null) {
            return true;
        }
        String appId = BillCommonService.getInstance().getAuthAppIdForFormPlugin(billPlugIn.getView());
        UnifyBillApplyAttr attr = new UnifyBillApplyAttr(appId, billPlugIn.getView().getEntityId());
        DynamicObject attFileBoTop1 = BillCommonService.getInstance().getAttFileBoTop1(attFileF7Dy.getLong("boid"), attr);
        String title = ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"VaApplyMobBusiness_20", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        String msg = ResManager.loadKDString((String)"\u6700\u65b0\u6863\u6848\u7248\u672c\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"VaApplyMobBusiness_21", (String)SYSTEM_TYPE, (Object[])new Object[]{BillTypeEnum.VACATIONBILL.getBillName()});
        if (attFileBoTop1 == null) {
            VaApplyMobBusiness.openConfirmBox(billPlugIn, title, msg, "CONFIRM_TYPE_ATT_VERSION", openConfirmCustomVal);
            model.setValue("attfile", null);
            model.setValue("attfilebasef7", null);
            return false;
        }
        boolean bl = versionChange = attFileF7Dy.getLong("id") == attFileBoTop1.getLong("id");
        if (!versionChange) {
            VaApplyMobBusiness.openConfirmBox(billPlugIn, title, msg, "CONFIRM_TYPE_ATT_VERSION", openConfirmCustomVal);
            model.setValue("attfilebasef7", (Object)attFileBoTop1.getLong("id"));
            return false;
        }
        return true;
    }

    private static void openConfirmBox(AbstractMobFormPlugin billPlugIn, String title, String detail, String callBackId, String openConfirmCustomVal) {
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(callBackId, (IFormPlugin)billPlugIn);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
        for (MessageBoxResult messageBoxResult : MessageBoxResult.values()) {
            btnNameMaps.put(messageBoxResult.getValue(), ResManager.loadKDString((String)"\u6211\u77e5\u9053\u4e86", (String)"VaApplyMobBusiness_22", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        billPlugIn.getView().showConfirm(title, detail, MessageBoxOptions.OK, ConfirmTypes.Save, confirmCallBackListener, btnNameMaps, openConfirmCustomVal);
    }

    private static class Instance {
        private static VaApplyMobBusiness INSTANCE = new VaApplyMobBusiness();

        private Instance() {
        }
    }
}

