/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.business.vaapply;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtabm.business.vaapply.batch.BatchVaApplyHelper;
import kd.wtc.wtbs.common.enums.bill.va.SpecialVaTypeEnum;
import kd.wtc.wtbs.common.model.bill.va.VaBillEntryEntityVo;
import kd.wtc.wtbs.common.model.bill.va.VaBillSubEntryVo;
import kd.wtc.wtbs.common.model.bill.va.VaBillVo;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class VaApplyQueryService {
    private final List<String> auditingStatusList = Collections.unmodifiableList(Arrays.asList("D", "B", "C"));
    private HRBaseServiceHelper vaDetailServiceelper = new HRBaseServiceHelper("wtabm_vadetail");

    public List<VaBillVo> queryHisBillForVa(List<DynamicObject> billDyns) {
        ArrayList<Long> excludeIds = new ArrayList<Long>(4);
        ArrayList personIds = Lists.newArrayListWithExpectedSize((int)billDyns.size());
        Date startDate = null;
        Date endDate = null;
        for (DynamicObject billDyn : billDyns) {
            Date start = WTCDateUtils.addDays((Date)billDyn.getDate("startdate"), (int)-1);
            Date end = WTCDateUtils.addDays((Date)billDyn.getDate("enddate"), (int)1);
            if (startDate == null || startDate.after(start)) {
                startDate = start;
            }
            if (endDate == null || endDate.before(end)) {
                endDate = end;
            }
            excludeIds.add(billDyn.getLong("id"));
            personIds.add(billDyn.getLong("personid.id"));
        }
        QFilter qFilter = new QFilter("personid.id", "in", (Object)personIds).and("billstatus", "in", this.auditingStatusList).and("isnotleave", "=", (Object)Boolean.FALSE).and("id", "not in", excludeIds);
        QFilter timeFilter = new QFilter("entryentity.entrystartdate", "<=", (Object)endDate).and("entryentity.entryenddate", ">=", (Object)startDate);
        qFilter.and(timeFilter);
        QFilter[] qFilters = new QFilter[]{qFilter};
        String properties = "mid,parentid,personid.id,billno,billstatus,attfilebasef7.id,attfilebasef7.textname,attfilebasef7.number,attfile.id,isnotleave, ischange, ishavechange,entryentity.entrystartdate,entryentity.entryenddate,entryentity.owndate,entryentity.entrystartmethod,entryentity.entryendmethod,entryentity.entryvacationtype,entryentity.specialvatype,entryentity.specialvamethod,entryentity.specialextjson,entryentity.isdisposable,entryentity.entryunit,entryentity.seq,entryentity.storageto";
        HRBaseServiceHelper billServiceHelper = new HRBaseServiceHelper("wtabm_vaapply");
        DynamicObject[] query = billServiceHelper.query(properties, qFilters);
        ArrayList lactationEntryIds = Lists.newArrayListWithExpectedSize((int)10);
        HashSet mids = Sets.newHashSetWithExpectedSize((int)query.length);
        for (DynamicObject dynamicObject : query) {
            DynamicObjectCollection entryEntities = dynamicObject.getDynamicObjectCollection("entryentity");
            List specialEntryIds = entryEntities.stream().filter(entryEntity -> SpecialVaTypeEnum.LACTATION_TYPE.vaType.equals(entryEntity.getString("specialvatype"))).map(entryEntity -> entryEntity.getLong("id")).collect(Collectors.toList());
            lactationEntryIds.addAll(specialEntryIds);
            long mid = dynamicObject.getLong("mid");
            if (mid == 0L) continue;
            mids.add(mid);
        }
        DynamicObject[] vaDynamicObjects = new DynamicObject[]{};
        if (lactationEntryIds.size() > 0) {
            QFilter entryIdFilter = new QFilter("entryid", "in", (Object)lactationEntryIds);
            String selectSpecaliProps = "id, entryid, vaentrydate, vaentrystarttime, vaentryendtime, vaentryapplytimehour, vaentryapplytimeday, unit";
            vaDynamicObjects = this.vaDetailServiceelper.queryOriginalArray(selectSpecaliProps, new QFilter[]{entryIdFilter});
        }
        String queryProp = "id,billno";
        Map<Long, DynamicObject> batchVaMap = BatchVaApplyHelper.INSTANCE.queryBatchVaBillByIds(mids, queryProp);
        return this.convertToVo(query, vaDynamicObjects, batchVaMap);
    }

    @Deprecated
    public List<VaBillVo> convertTo(List<DynamicObject> dyns) {
        return this.convertTo(dyns, new HashMap<Long, DynamicObject>(0));
    }

    public List<VaBillVo> convertTo(List<DynamicObject> dyns, Map<Long, DynamicObject> batchVaMap) {
        ArrayList vaBillVos = Lists.newArrayListWithExpectedSize((int)dyns.size());
        for (DynamicObject dyn : dyns) {
            VaBillVo vaBillVo = new VaBillVo();
            vaBillVo.setId(dyn.getLong("id"));
            vaBillVo.setBillNo(dyn.getString("billno"));
            vaBillVo.setAttPersonId(dyn.getLong("personid.id"));
            vaBillVo.setParentId(dyn.getLong("parentid"));
            vaBillVo.setAttFileBoId(dyn.getLong("attfile.id"));
            vaBillVo.setAttFileVid(dyn.getLong("attfilebasef7.id"));
            vaBillVo.setNotLeave(dyn.getBoolean("isnotleave"));
            vaBillVo.setHaveChange(dyn.getBoolean("ishavechange"));
            vaBillVo.setChangeBill(dyn.getBoolean("ischange"));
            long mid = dyn.getLong("mid");
            vaBillVo.setMid(mid);
            DynamicObject batchBillDy = batchVaMap.get(mid);
            DynamicObjectCollection entryEntities = dyn.getDynamicObjectCollection("entryentity");
            ArrayList entities = Lists.newArrayListWithCapacity((int)entryEntities.size());
            vaBillVo.setEntryEntities((List)entities);
            for (DynamicObject entryEntity : entryEntities) {
                VaBillEntryEntityVo vaBillEntryEntityVo = new VaBillEntryEntityVo();
                vaBillEntryEntityVo.setBillNo(vaBillVo.getBillNo());
                vaBillEntryEntityVo.setAttFileBoid(vaBillVo.getAttFileBoId());
                vaBillEntryEntityVo.setBatchBillDy(batchBillDy);
                DynamicObject attFileVDy = dyn.getDynamicObject("attfilebasef7");
                if (attFileVDy != null) {
                    vaBillEntryEntityVo.setName(attFileVDy.getString("textname"));
                    vaBillEntryEntityVo.setAttFileNo(attFileVDy.getString("number"));
                }
                this.convertToEntryVo(entryEntity, vaBillEntryEntityVo);
                entities.add(vaBillEntryEntityVo);
            }
            vaBillVos.add(vaBillVo);
        }
        return vaBillVos;
    }

    private List<VaBillVo> convertToVo(DynamicObject[] dyns, DynamicObject[] vaDynamicObjects, Map<Long, DynamicObject> batchVaMap) {
        List<VaBillVo> vaBillVos = this.convertTo(WTCCollections.modifiableList((Object[])dyns), batchVaMap);
        HashMap<Long, VaBillEntryEntityVo> vaBillEntryMap = new HashMap<Long, VaBillEntryEntityVo>();
        for (VaBillVo vaBillVo : vaBillVos) {
            List entryEntities = vaBillVo.getEntryEntities();
            for (VaBillEntryEntityVo entityVo : entryEntities) {
                vaBillEntryMap.putIfAbsent(entityVo.getId(), entityVo);
            }
        }
        if (vaDynamicObjects.length > 0) {
            for (DynamicObject dyn : vaDynamicObjects) {
                VaBillSubEntryVo subEntryVo = new VaBillSubEntryVo();
                this.convertToSubEntryVo(dyn, subEntryVo);
                VaBillEntryEntityVo vaBillEntryEntityVo = (VaBillEntryEntityVo)vaBillEntryMap.get(subEntryVo.getEntryId());
                if (vaBillEntryEntityVo == null) continue;
                List vaSubEntryVoList = vaBillEntryEntityVo.getVaSubEntryVoList();
                vaSubEntryVoList.add(subEntryVo);
            }
        }
        return vaBillVos;
    }

    private void convertToEntryVo(DynamicObject entryDyn, VaBillEntryEntityVo vo) {
        vo.setId(entryDyn.getLong("id"));
        vo.setVaTypeId(entryDyn.getLong("entryvacationtype.id"));
        vo.setStartMethod(entryDyn.getString("entrystartmethod"));
        vo.setEndMethod(entryDyn.getString("entryendmethod"));
        vo.setStartDate(entryDyn.getDate("entrystartdate"));
        vo.setEndDate(entryDyn.getDate("entryenddate"));
        vo.setSpVaMethodId(entryDyn.getLong("specialvamethod.id"));
        vo.setRowIndex(entryDyn.getInt("seq"));
        String specialVaType = entryDyn.getString("specialvatype");
        vo.setSpecialVaType(specialVaType);
        vo.setSpecialExtJson(entryDyn.getString("specialextjson"));
        vo.setStorageTo(entryDyn.getDate("storageto"));
        if (entryDyn.containsProperty("vadetailentry")) {
            DynamicObjectCollection vaDetails = entryDyn.getDynamicObjectCollection("vadetailentry");
            ArrayList subEntryVos = Lists.newArrayListWithExpectedSize((int)vaDetails.size());
            vo.setVaSubEntryVoList((List)subEntryVos);
            for (DynamicObject vaDetail : vaDetails) {
                VaBillSubEntryVo subEntryVo = new VaBillSubEntryVo();
                this.convertToSubEntryVo(vaDetail, subEntryVo, entryDyn.getLong("id"));
                subEntryVos.add(subEntryVo);
            }
        }
    }

    private void convertToSubEntryVo(DynamicObject dyn, VaBillSubEntryVo subEntryVo) {
        subEntryVo.setDetailId(dyn.getLong("id"));
        subEntryVo.setEntryId(dyn.getLong("entryid"));
        subEntryVo.setVaEntryDate(dyn.getDate("vaentrydate"));
        subEntryVo.setStartDateTime(dyn.getDate("vaentrystarttime"));
        subEntryVo.setEndDateTime(dyn.getDate("vaentryendtime"));
    }

    private void convertToSubEntryVo(DynamicObject dyn, VaBillSubEntryVo subEntryVo, long entryId) {
        subEntryVo.setDetailId(dyn.getLong("id"));
        subEntryVo.setEntryId(entryId);
        subEntryVo.setStartDateTime(dyn.getDate("vaentrystarttime"));
        subEntryVo.setEndDateTime(dyn.getDate("vaentryendtime"));
        subEntryVo.setVaEntryDate(dyn.getDate("vaentrydate"));
    }
}

