/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.business.vaapply;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtabm.business.quota.OnRenameVaTypeEvent;
import kd.sdk.wtc.wtabm.business.va.VaInfoCallBackParam;
import kd.sdk.wtc.wtabm.business.va.VaInfoExpService;
import kd.wtc.wtabm.business.vaapply.BillSystemParamService;
import kd.wtc.wtabm.business.vaapply.VaApplyExtHelper;
import kd.wtc.wtabm.business.vaapply.VaApplyServiceHelper;
import kd.wtc.wtabm.business.vaapply.VaBaseService;
import kd.wtc.wtabm.business.vaapply.VaKDStringHelper;
import kd.wtc.wtabm.business.vaapply.checker.VaBillCheckService;
import kd.wtc.wtabm.business.vaapply.checker.VaEntityCheckService;
import kd.wtc.wtabm.common.entity.vaapply.EndTimeVo;
import kd.wtc.wtabm.common.entity.vaapply.StartTimeVo;
import kd.wtc.wtabm.common.entity.vaapply.SummaryVaTypeVo;
import kd.wtc.wtabm.common.entity.vaapply.VaInfoVo;
import kd.wtc.wtabm.common.entity.vaapply.VaNonQtApplyCache;
import kd.wtc.wtabm.common.entity.vaapply.VaQuotaInfoVo;
import kd.wtc.wtabm.common.entity.vaapply.VaQuotaResInfo;
import kd.wtc.wtabm.common.entity.vaapply.VaTypeSelectVo;
import kd.wtc.wtbs.business.bill.AttfileLimitScopeServiceImpl;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyKDStringHelper;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.bill.IAttfileLimitScopeService;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonCurrModel;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonCurrResult;
import kd.wtc.wtbs.business.model.attendperson.Person;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.applybill.operatecore.va.VaAutoOperator;
import kd.wtc.wtbs.business.web.applybill.service.BillCheckService;
import kd.wtc.wtbs.common.bill.AttfileLimitScope;
import kd.wtc.wtbs.common.deduction.usable.UsableQuotaQueryReq;
import kd.wtc.wtbs.common.deduction.usable.UsableQuotaQueryResp;
import kd.wtc.wtbs.common.deduction.usable.UsableQuotaQueryResult;
import kd.wtc.wtbs.common.enums.ApplyBillBaseSetEnum;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.BusinessTypeEnum;
import kd.wtc.wtbs.common.enums.HisDataStatus;
import kd.wtc.wtbs.common.enums.bill.BillOpenStyleEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.enums.bill.va.SpecialVaTypeEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyInitInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillInfoContext;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtabm.common.entity.VaDetailItemPreviewVo;
import kd.wtc.wtbs.wtabm.common.entity.VaDetailPreviewVo;
import kd.wtc.wtbs.wtabm.common.entity.VaLactationTimeStorage;
import kd.wtc.wtbs.wtp.enums.vaplan.BaseSetTimeBreastDayTypeEnum;
import kd.wtc.wtbs.wtp.enums.vaplan.BaseSetTimeUnitEnum;

public class VaApplyService {
    public static final String QUOTA_INFO = "QUOTA_INFO";
    private static final HRBaseServiceHelper ATTPOLICY_SERVICE = new HRBaseServiceHelper("wtbd_attpolicy");
    private static final String SYSTEM_TYPE = "wtc-wtabm-business";
    private static final Log LOG = LogFactory.getLog(VaApplyService.class);

    public static void showAddNewPage(IFormView view, IFormPlugin formPlugin) {
        DynamicObjectCollection dynamicObjectCollection = view.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        int rowIndex = dynamicObjectCollection.size();
        long parentBillId = view.getModel().getDataEntity().getLong("parentid");
        HashMap<String, String> params = new HashMap<String, String>(16);
        VaInfoVo vaInfoVo = new VaInfoVo();
        vaInfoVo.setAttPersonId(view.getModel().getDataEntity().getLong("personid.id"));
        vaInfoVo.setRowIndex(view.getModel().getEntryEntity("entryentity").size());
        vaInfoVo.setAttFileBoid(view.getModel().getDataEntity().getLong("attfile.boid"));
        vaInfoVo.setParentBillId(parentBillId);
        vaInfoVo.setRowIndex(rowIndex);
        List<VaNonQtApplyCache> vaNonQtApplyCaches = VaApplyService.getFromCache(view);
        vaInfoVo.setNonQtApplyCaches(vaNonQtApplyCaches);
        params.put("VA_INFO_VO", SerializationUtils.serializeToBase64((Object)vaInfoVo));
        params.put("billstatus", view.getModel().getDataEntity().getString("billstatus"));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("wtabm_vainfo");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.setCustomParams(params);
        formShowParameter.setCloseCallBack(new CloseCallBack(formPlugin, "newentry"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u4f11\u5047\u4fe1\u606f", (String)"VaApplyPlugin_12", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        view.showForm(formShowParameter);
    }

    public static void showSinglePageInContainer(IFormView view) {
        String applyRadio = view.getModel().getDataEntity(true).getString("applytyperadio");
        if (!"0".equals(applyRadio)) {
            return;
        }
        BillShowParameter billShowParameter = (BillShowParameter)view.getFormShowParameter();
        BillOperationStatus billStatus = billShowParameter.getBillStatus();
        OperationStatus pageStatus = billShowParameter.getStatus();
        OperationStatus targetStatus = OperationStatus.ADDNEW;
        DynamicObject dataEntity = view.getModel().getDataEntity();
        boolean isChange = dataEntity.getBoolean("ischange");
        boolean isNotLeave = dataEntity.getBoolean("isnotleave");
        if (isChange || BillOperationStatus.EDIT == billStatus) {
            targetStatus = OperationStatus.EDIT;
        }
        if (isNotLeave || OperationStatus.VIEW == pageStatus) {
            targetStatus = OperationStatus.VIEW;
        }
        int rowIndex = 0;
        long parentBillId = dataEntity.getLong("parentid");
        HashMap<String, String> params = new HashMap<String, String>(16);
        VaInfoVo vaInfoVo = new VaInfoVo();
        vaInfoVo.setAttPersonId(dataEntity.getLong("personid.id"));
        vaInfoVo.setAttFileBoid(dataEntity.getLong("attfile.boid"));
        vaInfoVo.setParentBillId(parentBillId);
        vaInfoVo.setBillStyle(BillOpenStyleEnum.SINGLE.getCode());
        vaInfoVo.setRowIndex(rowIndex);
        List<VaNonQtApplyCache> vaNonQtApplyCaches = VaApplyService.getFromCache(view);
        vaInfoVo.setNonQtApplyCaches(vaNonQtApplyCaches);
        DynamicObject billObj = view.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = billObj.getDynamicObjectCollection("entryentity");
        if (WTCCollections.isNotEmpty((Collection)dynamicObjectCollection)) {
            DynamicObject row = (DynamicObject)dynamicObjectCollection.get(0);
            vaInfoVo.setId(row.getLong("id"));
            vaInfoVo.setEndDate(row.getDate("entryenddate"));
            vaInfoVo.setStartDate(row.getDate("entrystartdate"));
            vaInfoVo.setVacationType(row.getLong("entryvacationtype.id"));
            vaInfoVo.setStartMethod(row.getString("entrystartmethod"));
            vaInfoVo.setEndMethod(row.getString("entryendmethod"));
            vaInfoVo.setEntryReason(row.getString("entryreason"));
            vaInfoVo.setEntryVaTimeDay(row.getBigDecimal("entryvatimeday"));
            vaInfoVo.setEntryVaTimeHour(row.getBigDecimal("entryvatimehour"));
            vaInfoVo.setUnit(row.getString("entryunit"));
            vaInfoVo.setEntryParentId(row.getLong("entryparentid"));
            vaInfoVo.setOwnDate(row.getDate("owndate"));
            vaInfoVo.setSpecialVaType(row.getString("specialvatype"));
            long specialVaMethodId = row.getLong("specialvamethod.id");
            vaInfoVo.setSpecialVaMethod(specialVaMethodId);
            vaInfoVo.setVaLactationTimeStorageJson(row.getString("specialextjson"));
            DynamicObjectCollection subRowObjs = row.getDynamicObjectCollection("vadetailentry");
            vaInfoVo.setDetailList(VaApplyService.transFormDetailList(subRowObjs, specialVaMethodId));
            vaInfoVo.setNotLeave(isNotLeave);
        }
        params.put("VA_INFO_VO", SerializationUtils.serializeToBase64((Object)vaInfoVo));
        params.put("billstatus", dataEntity.getString("billstatus"));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("wtabm_vainfosingle");
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("single_flex");
        formShowParameter.setStatus(targetStatus);
        formShowParameter.setCustomParams(params);
        view.showForm(formShowParameter);
        view.getPageCache().put("singlePageId", formShowParameter.getPageId());
    }

    public static void showEditPage(IFormView view, IFormPlugin formPlugin) {
        IDataModel model = view.getModel();
        HashMap<String, String> params = new HashMap<String, String>(16);
        int rowIndex = model.getEntryCurrentRowIndex("entryentity");
        DynamicObject row = model.getEntryRowEntity("entryentity", rowIndex);
        long parentBillId = model.getDataEntity().getLong("parentid");
        VaInfoVo vaInfoVo = new VaInfoVo();
        vaInfoVo.setId(row.getLong("id"));
        vaInfoVo.setEndDate(row.getDate("entryenddate"));
        vaInfoVo.setStartDate(row.getDate("entrystartdate"));
        vaInfoVo.setVacationType(row.getLong("entryvacationtype.id"));
        vaInfoVo.setStartMethod(row.getString("entrystartmethod"));
        vaInfoVo.setEndMethod(row.getString("entryendmethod"));
        vaInfoVo.setAttFileBoid(model.getDataEntity().getLong("attfile.boid"));
        vaInfoVo.setAttPersonId(model.getDataEntity().getLong("personid.id"));
        vaInfoVo.setEntryReason(row.getString("entryreason"));
        vaInfoVo.setEntryVaTimeDay(row.getBigDecimal("entryvatimeday"));
        vaInfoVo.setEntryVaTimeHour(row.getBigDecimal("entryvatimehour"));
        vaInfoVo.setUnit(row.getString("entryunit"));
        vaInfoVo.setRowIndex(rowIndex);
        vaInfoVo.setParentBillId(parentBillId);
        vaInfoVo.setEntryParentId(row.getLong("entryparentid"));
        vaInfoVo.setOwnDate(row.getDate("owndate"));
        vaInfoVo.setSpecialVaType(row.getString("specialvatype"));
        long specialVaMethodId = row.getLong("specialvamethod.id");
        vaInfoVo.setSpecialVaMethod(specialVaMethodId);
        vaInfoVo.setVaLactationTimeStorageJson(row.getString("specialextjson"));
        List<VaNonQtApplyCache> vaNonQtApplyCaches = VaApplyService.getFromCache(view);
        vaInfoVo.setNonQtApplyCaches(vaNonQtApplyCaches);
        DynamicObject billObj = model.getDataEntity(true);
        DynamicObjectCollection parentRowObjs = billObj.getDynamicObjectCollection("entryentity");
        DynamicObject parentRowObj = (DynamicObject)parentRowObjs.get(rowIndex);
        DynamicObjectCollection subRowObjs = parentRowObj.getDynamicObjectCollection("vadetailentry");
        vaInfoVo.setDetailList(VaApplyService.transFormDetailList(subRowObjs, specialVaMethodId));
        params.put("billstatus", model.getDataEntity().getString("billstatus"));
        params.put("VA_INFO_VO", SerializationUtils.serializeToBase64((Object)vaInfoVo));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("wtabm_vainfo");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setCustomParams(params);
        formShowParameter.setCloseCallBack(new CloseCallBack(formPlugin, "editrow"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u4f11\u5047\u4fe1\u606f", (String)"VaApplyPlugin_12", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        view.showForm(formShowParameter);
    }

    private static List<VaNonQtApplyCache> getFromCache(IFormView view) {
        List caches = Lists.newArrayListWithCapacity((int)10);
        String nonQtApplyCacheBase64 = view.getPageCache().get("WTABM_CACHENONAPPLY");
        if (StringUtils.isNotEmpty((CharSequence)nonQtApplyCacheBase64)) {
            caches = (List)SerializationUtils.deSerializeFromBase64((String)nonQtApplyCacheBase64);
        }
        return caches;
    }

    @Deprecated
    public static List<VaDetailPreviewVo> transFormDetailList(DynamicObjectCollection subRowObjs) {
        return VaApplyService.transFormDetailList(subRowObjs, BaseSetTimeBreastDayTypeEnum.CUSTOM.id);
    }

    private static List<VaDetailPreviewVo> transFormDetailList(DynamicObjectCollection subRowObjs, long specialVaMethodId) {
        if (Objects.isNull(subRowObjs)) {
            return Collections.emptyList();
        }
        ArrayList<VaDetailPreviewVo> detailPreviewVos = new ArrayList<VaDetailPreviewVo>(subRowObjs.size());
        String dateField = BaseSetTimeBreastDayTypeEnum.CUSTOM.id == specialVaMethodId ? "vaentrystarttime" : "vaentrydate";
        Map<Date, List<DynamicObject>> rowObjDateMap = subRowObjs.stream().collect(Collectors.groupingBy(key -> WTCDateUtils.getDayBegin((Date)key.getDate(dateField))));
        rowObjDateMap.forEach((date, rowObjs) -> {
            ArrayList<VaDetailItemPreviewVo> itemVos = new ArrayList<VaDetailItemPreviewVo>(10);
            long dateTypeId = 0L;
            BigDecimal applyTimeDay = BigDecimal.ZERO;
            BigDecimal applyTimeHour = BigDecimal.ZERO;
            String unit = null;
            for (DynamicObject rowObj : rowObjs) {
                VaDetailItemPreviewVo itemVo = VaApplyService.parseSubObjToItemVO(rowObj);
                itemVos.add(itemVo);
                dateTypeId = itemVo.getDateTypeId();
                applyTimeDay = applyTimeDay.add(itemVo.getApplyTimeDay());
                applyTimeHour = applyTimeHour.add(itemVo.getApplyTimeHour());
                unit = itemVo.getUnit();
            }
            VaDetailPreviewVo vo = new VaDetailPreviewVo().setDate(date).setApplyTimeDay(applyTimeDay.setScale(2, RoundingMode.HALF_UP)).setApplyTimeHour(applyTimeHour.setScale(2, RoundingMode.HALF_UP)).setDateType(dateTypeId).setUnit(unit).setItemVos(itemVos);
            detailPreviewVos.add(vo);
        });
        detailPreviewVos.sort(Comparator.comparing(VaDetailPreviewVo::getDate));
        return detailPreviewVos;
    }

    private static VaDetailItemPreviewVo parseSubObjToItemVO(DynamicObject subRowObj) {
        VaDetailItemPreviewVo itemVo = new VaDetailItemPreviewVo();
        itemVo.setDate(subRowObj.getDate("vaentrydate")).setStartTime(subRowObj.getDate("vaentrystarttime")).setEndTime(subRowObj.getDate("vaentryendtime")).setDateTypeId(subRowObj.getLong("vaentrydatetype.id")).setApplyTimeHour(subRowObj.getBigDecimal("vaentryapplytimehour")).setApplyTimeDay(subRowObj.getBigDecimal("vaentryapplytimeday")).setUnit(subRowObj.getString("vaentryunit")).setRowSeq(subRowObj.getInt("vaentryseq"));
        return itemVo;
    }

    public static void showVaDetailPage(IFormView view) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("wtabm_vainfodetail");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.VIEW);
        HashMap<String, Integer> params = new HashMap<String, Integer>(16);
        int rowIndex = view.getModel().getEntryCurrentRowIndex("entryentity");
        params.put("ROWINDEX", rowIndex);
        formShowParameter.setCustomParams(params);
        view.showForm(formShowParameter);
    }

    public static void loadAttPolicy(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("entryentity");
        long fileBoId = model.getDataEntity().getLong("attfile.id");
        if (fileBoId == 0L || CollectionUtils.isEmpty((Collection)entryEntity)) {
            view.setVisible(Boolean.FALSE, new String[]{"richtexteditorap"});
            view.setVisible(Boolean.TRUE, new String[]{"lackpageflex"});
            return;
        }
        List<VaTypeSelectVo> vaTypeSelectVos = VaApplyService.getVaTypes(fileBoId, view.getEntityId(), BillCommonService.getInstance().getAuthAppIdForFormPlugin(view));
        view.setVisible(Boolean.TRUE, new String[]{"attachmentpanel"});
        boolean systemDesc = BillSystemParamService.systemDesc();
        HashSet<DynamicObject> vaTypeList = new HashSet<DynamicObject>(16);
        if (!systemDesc) {
            vaTypeList.add(((DynamicObject)entryEntity.get(entryEntity.size() - 1)).getDynamicObject("entryvacationtype"));
        } else {
            vaTypeList.addAll(entryEntity.stream().map(entity -> entity.getDynamicObject("entryvacationtype")).collect(Collectors.toList()));
        }
        Map<Long, DynamicObject> vaTypeMap = vaTypeList.stream().collect(Collectors.toMap(vaTypeDyn -> vaTypeDyn.getLong("id"), vaTypeDyn -> vaTypeDyn, (v1, v2) -> v1));
        Map<Long, Long> vaTypePolicyMaps = vaTypeSelectVos.stream().filter(vaTypeSelectVo -> vaTypeMap.containsKey(vaTypeSelectVo.getVaTypeId())).collect(Collectors.toMap(VaTypeSelectVo::getVaTypeId, VaTypeSelectVo::getAttpolicyId));
        DynamicObject[] attPolicyArr = ATTPOLICY_SERVICE.loadDynamicObjectArray((Object[])vaTypePolicyMaps.values().toArray(new Long[vaTypePolicyMaps.size()]));
        Map<Long, DynamicObject> policyMap = Arrays.stream(attPolicyArr).collect(Collectors.toMap(policy -> policy.getLong("id"), policy -> policy, (p1, p2) -> p1));
        Container attPolicyFlex = (Container)view.getControl("attpolicyflex");
        attPolicyFlex.setCollapse(false);
        if (MapUtils.isEmpty(policyMap)) {
            attPolicyFlex.setCollapse(true);
            view.setVisible(Boolean.FALSE, new String[]{"richtexteditorap"});
            view.setVisible(Boolean.TRUE, new String[]{"lackpageflex"});
            return;
        }
        view.setVisible(Boolean.TRUE, new String[]{"richtexteditorap"});
        view.setVisible(Boolean.FALSE, new String[]{"lackpageflex"});
        int index = 0;
        StringBuilder builder = new StringBuilder();
        for (DynamicObject vaType : vaTypeList) {
            ++index;
            String vaTypeName = vaType.getLocaleString("name").getLocaleValue();
            DynamicObject policyDyn = policyMap.get(vaTypePolicyMaps.get(vaType.getLong("id")));
            if (policyDyn == null) continue;
            String content = policyDyn.getString("content");
            if (index != 0) {
                builder.append("<hr style=\"border-style: dashed;\">");
            }
            builder.append("<b style=\"line-height:40px;font-size:14px;color:#212121\">");
            builder.append(vaTypeName);
            builder.append(":</b>");
            content = content.replace("<p>", "<p style=\"line-height:20px;font-size:12px;color:#666666\">");
            builder.append(content);
        }
        RichTextEditor richTextEditor = (RichTextEditor)view.getControl("richtexteditorap");
        richTextEditor.setText(builder.toString());
    }

    public static void addEntryRow(IFormView view, VaInfoVo vaInfoVo) {
        int rowIndex = view.getModel().createNewEntryRow("entryentity");
        VaApplyService.setValue(view, vaInfoVo, rowIndex);
        DynamicObject dynamicObject = (DynamicObject)view.getModel().getEntryEntity("entryentity").get(rowIndex);
        dynamicObject.set("id", (Object)DB.genGlobalLongId());
    }

    public static void modifyEntryRow(IFormView view, VaInfoVo vaInfoVo) {
        int rowIndex = vaInfoVo.getRowIndex();
        VaApplyService.setValue(view, vaInfoVo, rowIndex);
    }

    public static void addOrModifySingleEntryRow(IFormView view, VaInfoVo vaInfoVo) {
        int rowIndex = vaInfoVo.getRowIndex();
        DynamicObjectCollection dynamicObjectCollection = view.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (WTCCollections.isEmpty((Collection)dynamicObjectCollection)) {
            rowIndex = view.getModel().createNewEntryRow("entryentity");
            DynamicObject dynamicObject = (DynamicObject)view.getModel().getEntryEntity("entryentity").get(rowIndex);
            dynamicObject.set("id", (Object)DB.genGlobalLongId());
        }
        VaApplyService.setValue(view, vaInfoVo, rowIndex);
    }

    private static void setValue(IFormView view, VaInfoVo vaInfoVo, int rowIndex) {
        DynamicObject childPageDynamicObj;
        String endstr;
        String startstr;
        LOG.info("\u8bbe\u7f6e\u4f11\u5047\u4fe1\u606f\u5f00\u59cb\uff0cvaInfoVo:{}", (Object)vaInfoVo);
        view.getModel().setValue("entryvacationtype", (Object)vaInfoVo.getVacationType(), rowIndex);
        view.getModel().setValue("entryunit", (Object)vaInfoVo.getUnit(), rowIndex);
        if (HRStringUtils.equals((String)vaInfoVo.getUnit(), (String)BaseSetTimeUnitEnum.DATE.code)) {
            view.getModel().setValue("entryapplytime", (Object)vaInfoVo.getEntryVaTimeDay(), rowIndex);
        } else {
            view.getModel().setValue("entryapplytime", (Object)vaInfoVo.getEntryVaTimeHour(), rowIndex);
        }
        view.getModel().setValue("entryreason", (Object)vaInfoVo.getEntryReason(), rowIndex);
        view.getModel().setValue("entrystartmethod", (Object)String.valueOf(vaInfoVo.getStartMethod()), rowIndex);
        view.getModel().setValue("entryendmethod", (Object)String.valueOf(vaInfoVo.getEndMethod()), rowIndex);
        view.getModel().setValue("entryvatimeday", (Object)vaInfoVo.getEntryVaTimeDay(), rowIndex);
        view.getModel().setValue("entryvatimehour", (Object)vaInfoVo.getEntryVaTimeHour(), rowIndex);
        view.getModel().setValue("entryvalidtimehour", (Object)vaInfoVo.getEntryValidTimeHour(), rowIndex);
        view.getModel().setValue("entryvalidtimeday", (Object)vaInfoVo.getEntryValidTimeDay(), rowIndex);
        view.getModel().setValue("entrystartdate", (Object)vaInfoVo.getStartDate(), rowIndex);
        view.getModel().setValue("entryenddate", (Object)vaInfoVo.getEndDate(), rowIndex);
        view.getModel().setValue("entryunit", (Object)vaInfoVo.getUnit(), rowIndex);
        view.getModel().setValue("owndate", (Object)vaInfoVo.getOwnDate(), rowIndex);
        view.getModel().setValue("entryparentid", (Object)vaInfoVo.getEntryParentId(), rowIndex);
        view.getModel().setValue("isdisposable", (Object)vaInfoVo.getDisposable(), rowIndex);
        if (StringUtils.equals((CharSequence)vaInfoVo.getStartMethod(), (CharSequence)"2")) {
            startstr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)vaInfoVo.getStartDate());
            endstr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)vaInfoVo.getEndDate());
        } else if (StringUtils.equals((CharSequence)vaInfoVo.getStartMethod(), (CharSequence)"3")) {
            startstr = WTCInteDateUtil.formatBySysTzAndUserFmt((Date)vaInfoVo.getStartDate());
            endstr = WTCInteDateUtil.formatBySysTzAndUserFmt((Date)vaInfoVo.getEndDate());
        } else {
            startstr = StringUtils.equals((CharSequence)vaInfoVo.getStartMethod(), (CharSequence)"0") ? String.format(ResManager.loadKDString((String)"%1$s\u4e0a\u534a\u5929", (String)"VaInfoEdit_05", (String)SYSTEM_TYPE, (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)vaInfoVo.getStartDate())) : String.format(ResManager.loadKDString((String)"%1$s\u4e0b\u534a\u5929", (String)"VaInfoEdit_06", (String)SYSTEM_TYPE, (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)vaInfoVo.getStartDate()));
            endstr = StringUtils.equals((CharSequence)vaInfoVo.getEndMethod(), (CharSequence)"0") ? String.format(ResManager.loadKDString((String)"%1$s\u4e0a\u534a\u5929", (String)"VaInfoEdit_05", (String)SYSTEM_TYPE, (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)vaInfoVo.getEndDate())) : String.format(ResManager.loadKDString((String)"%1$s\u4e0b\u534a\u5929", (String)"VaInfoEdit_06", (String)SYSTEM_TYPE, (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)vaInfoVo.getEndDate()));
        }
        view.getModel().setValue("entrystarttimetext", (Object)startstr, rowIndex);
        view.getModel().setValue("entryendtimetext", (Object)endstr, rowIndex);
        view.getModel().setValue("specialvatype", (Object)vaInfoVo.getSpecialVaType(), rowIndex);
        if (vaInfoVo.getSpecialVaMethod() == 0L) {
            view.getModel().setValue("specialvamethod", null, rowIndex);
        } else {
            view.getModel().setValue("specialvamethod", (Object)vaInfoVo.getSpecialVaMethod(), rowIndex);
        }
        view.getModel().setValue("specialextjson", (Object)vaInfoVo.getVaLactationTimeStorageJson(), rowIndex);
        DynamicObjectCollection entryEntities = view.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        DynamicObject row = (DynamicObject)entryEntities.get(rowIndex);
        VaApplyService.generateVaDetails(vaInfoVo, row);
        String dynamicObjectBase64 = vaInfoVo.getDynamicObjectBase64();
        if (StringUtils.isNotEmpty((CharSequence)dynamicObjectBase64)) {
            LOG.info("\u3010\u4e8c\u5f00\u57cb\u70b9\u3011\u4f11\u5047\u4fe1\u606f\u6269\u5c55\u8c03\u7528\u5f00\u59cb.");
            DynamicObject vaInfoDyn = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)dynamicObjectBase64);
            VaInfoCallBackParam callBackParam = new VaInfoCallBackParam(vaInfoVo.getRowIndex(), vaInfoDyn, view);
            WTCPluginProxy hrPluginProxy = WTCPluginProxyFactory.create(VaInfoExpService.class, (String)"kd.sdk.wtc.wtabm.business.va.VaInfoExpService");
            hrPluginProxy.invokeReplace(hrPlugin -> {
                LOG.info("\u3010\u4e8c\u5f00\u57cb\u70b9\u3011\u4f11\u5047\u4fe1\u606f\u6269\u5c55\u65b9\u6cd5\u8c03\u7528\u5f00\u59cb,\u8c03\u7528\u6269\u5c55\u7c7b\uff1a{}", (Object)hrPlugin.getClass().getName());
                hrPlugin.onCallBackVaInfo(callBackParam);
            });
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{vaInfoVo.getDynamicObjectBase64()}) && (childPageDynamicObj = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)vaInfoVo.getDynamicObjectBase64())) != null) {
            BillCommonService.writeInfo2Model((DynamicObject)childPageDynamicObj, (DynamicObject)view.getModel().getEntryRowEntity("entryentity", vaInfoVo.getRowIndex()));
        }
        view.getModel().updateCache();
    }

    public String getEntryDateStr(Date dateTime, String vaMethod) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String dateStr = StringUtils.equals((CharSequence)vaMethod, (CharSequence)"2") ? simpleDateFormat.format(dateTime) : (StringUtils.equals((CharSequence)vaMethod, (CharSequence)"3") ? simpleDateFormat2.format(dateTime) : (StringUtils.equals((CharSequence)vaMethod, (CharSequence)"0") ? String.format(ResManager.loadKDString((String)"%1$s\u4e0a\u534a\u5929", (String)"VaInfoEdit_05", (String)SYSTEM_TYPE, (Object[])new Object[0]), simpleDateFormat.format(dateTime)) : String.format(ResManager.loadKDString((String)"%1$s\u4e0b\u534a\u5929", (String)"VaInfoEdit_06", (String)SYSTEM_TYPE, (Object[])new Object[0]), simpleDateFormat.format(dateTime))));
        return dateStr;
    }

    public static void generateVaDetails(VaInfoVo vaInfoVo, DynamicObject entryentity) {
        DynamicObjectCollection dynamicObjectCollection = entryentity.getDynamicObjectCollection("vadetailentry");
        dynamicObjectCollection.clear();
        List detailList = vaInfoVo.getDetailList();
        HashMap<Long, DynamicObject> dateTypeMap = new HashMap<Long, DynamicObject>(16);
        if (!CollectionUtils.isEmpty((Collection)detailList)) {
            for (VaDetailPreviewVo previewVo : detailList) {
                List itemVos = previewVo.getItemVos();
                for (VaDetailItemPreviewVo itemVo : itemVos) {
                    DynamicObject dateType = VaApplyService.getDateType(dateTypeMap, itemVo.getDateTypeId());
                    VaApplyService.fillSubEntry(dynamicObjectCollection, itemVo, dateType);
                }
            }
        }
    }

    private static DynamicObject getDateType(Map<Long, DynamicObject> dyMap, long dateTypeId) {
        if (dyMap == null) {
            dyMap = new HashMap<Long, DynamicObject>(16);
        }
        if (!dyMap.containsKey(dateTypeId)) {
            HRBaseServiceHelper dateTypeService = new HRBaseServiceHelper("wtbd_datetype");
            DynamicObject dynamicObject = dateTypeService.loadSingle((Object)dateTypeId);
            dyMap.put(dateTypeId, dynamicObject);
        }
        return dyMap.get(dateTypeId);
    }

    public static void fillSubEntry(DynamicObjectCollection dynamicObjectCollection, VaDetailItemPreviewVo itemVo, DynamicObject dateType) {
        DynamicObject dynamicObject = dynamicObjectCollection.addNew();
        dynamicObject.set("vaentrydate", (Object)itemVo.getDate());
        dynamicObject.set("vaentrystarttime", (Object)itemVo.getStartTime());
        dynamicObject.set("vaentryendtime", (Object)itemVo.getEndTime());
        dynamicObject.set("vaentrydatetype", (Object)dateType);
        dynamicObject.set("vaentryapplytimeday", (Object)itemVo.getApplyTimeDay());
        dynamicObject.set("vaentryapplytimehour", (Object)itemVo.getApplyTimeHour());
        dynamicObject.set("vaentryunit", (Object)itemVo.getUnit());
        dynamicObject.set("vaentryseq", (Object)itemVo.getRowSeq());
    }

    public static void setDateStr(DynamicObject row, boolean isStartDate) {
        String dateStr;
        Date date;
        String json = row.getString(isStartDate ? "startdatestr" : "enddatestr");
        if (StringUtils.isBlank((CharSequence)json)) {
            return;
        }
        StartTimeVo startTimeVo = (StartTimeVo)JSON.parseObject((String)json, StartTimeVo.class);
        EndTimeVo endTimeVo = (EndTimeVo)JSON.parseObject((String)json, EndTimeVo.class);
        String vaMethod = isStartDate ? startTimeVo.getStartVaMethod() : endTimeVo.getEndVaMethod();
        Date date2 = date = isStartDate ? startTimeVo.getMinStartDateTime() : endTimeVo.getMaxEndDateTime();
        if (HRStringUtils.equalsIgnoreCase((String)vaMethod, (String)WtcTimeRangeBtnTypeEnum.DAY.value)) {
            dateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)date);
        } else if (HRStringUtils.equalsIgnoreCase((String)vaMethod, (String)WtcTimeRangeBtnTypeEnum.CUSTOM.value)) {
            Date actualDate = isStartDate ? startTimeVo.getMinStartDateTime() : endTimeVo.getMaxEndDateTime();
            dateStr = WTCInteDateUtil.formatBySysTzAndUserFmt((Date)actualDate);
        } else {
            String vaMethodStr = HRStringUtils.equalsIgnoreCase((String)vaMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) ? ResManager.loadKDString((String)"\u4e0a\u534a\u5929", (String)"VaApplyService_05", (String)SYSTEM_TYPE, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0b\u534a\u5929", (String)"VaApplyService_06", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            dateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)date) + " " + vaMethodStr;
        }
        row.set(isStartDate ? "startdatestr" : "enddatestr", (Object)dateStr);
    }

    public void setEntryEntity(IFormView view) {
        DynamicObject dynamicObject = view.getModel().getDataEntity(true);
        DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("entryentity");
        if (dynamicObject.getPkValue() != null && (Long)dynamicObject.getPkValue() != 0L) {
            VaApplyService.displayEntryEntityFieldInfo(collection);
        }
    }

    private static void displayEntryEntityFieldInfo(DynamicObjectCollection collection) {
        for (DynamicObject row : collection) {
            String endDateStr;
            String startDateStr;
            Date entryStartDate = row.getDate("entrystartdate");
            Date entryEndDate = row.getDate("entryenddate");
            if (HRStringUtils.equalsIgnoreCase((String)row.getString("entrystartmethod"), (String)WtcTimeRangeBtnTypeEnum.DAY.value)) {
                startDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)entryStartDate);
                endDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)entryEndDate);
            } else if (HRStringUtils.equalsIgnoreCase((String)row.getString("entrystartmethod"), (String)WtcTimeRangeBtnTypeEnum.CUSTOM.value)) {
                startDateStr = WTCInteDateUtil.formatBySysTzAndUserFmt((Date)entryStartDate);
                endDateStr = WTCInteDateUtil.formatBySysTzAndUserFmt((Date)entryEndDate);
            } else {
                String startMethodStr = HRStringUtils.equalsIgnoreCase((String)row.getString("entrystartmethod"), (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) ? ResManager.loadKDString((String)"\u4e0a\u534a\u5929", (String)"VaApplyService_05", (String)SYSTEM_TYPE, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0b\u534a\u5929", (String)"VaApplyService_06", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                String endMethodStr = HRStringUtils.equalsIgnoreCase((String)row.getString("entryendmethod"), (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) ? ResManager.loadKDString((String)"\u4e0a\u534a\u5929", (String)"VaApplyService_05", (String)SYSTEM_TYPE, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0b\u534a\u5929", (String)"VaApplyService_06", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                startDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)entryStartDate) + " " + startMethodStr;
                endDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)entryEndDate) + " " + endMethodStr;
            }
            row.set("entrystarttimetext", (Object)startDateStr);
            row.set("entryendtimetext", (Object)endDateStr);
            String entryUnit = row.getString("entryunit");
            row.set("entryapplytime", StringUtils.equals((CharSequence)BaseSetTimeUnitEnum.DATE.code, (CharSequence)entryUnit) ? row.get("entryvatimeday") : row.get("entryvatimehour"));
            row.set("entryvatime", StringUtils.equals((CharSequence)BaseSetTimeUnitEnum.DATE.code, (CharSequence)entryUnit) ? row.get("entryvalidtimeday") : row.get("entryvalidtimehour"));
        }
    }

    public static String getDateStr(DynamicObject row, boolean isStartDate) {
        String dateStr;
        String entryStartVaMethod = row.getString("entrystartmethod");
        String entryEndVaMethod = row.getString("entryendmethod");
        Date entryStartDate = row.getDate("entrystartdate");
        Date entryEndDate = row.getDate("entryenddate");
        if (HRStringUtils.equalsIgnoreCase((String)entryStartVaMethod, (String)WtcTimeRangeBtnTypeEnum.DAY.value)) {
            dateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)(isStartDate ? entryStartDate : entryEndDate));
        } else if (HRStringUtils.equalsIgnoreCase((String)entryStartVaMethod, (String)WtcTimeRangeBtnTypeEnum.CUSTOM.value)) {
            dateStr = WTCInteDateUtil.formatBySysTzAndUserFmt((Date)(isStartDate ? entryStartDate : entryEndDate));
        } else {
            String vaStartMethodStr = HRStringUtils.equalsIgnoreCase((String)entryStartVaMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) ? ResManager.loadKDString((String)"\u4e0a\u534a\u5929", (String)"VaApplyService_05", (String)SYSTEM_TYPE, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0b\u534a\u5929", (String)"VaApplyService_06", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            String vaEndMethodStr = HRStringUtils.equalsIgnoreCase((String)entryEndVaMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) ? ResManager.loadKDString((String)"\u4e0a\u534a\u5929", (String)"VaApplyService_05", (String)SYSTEM_TYPE, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0b\u534a\u5929", (String)"VaApplyService_06", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            String startDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)entryStartDate) + " " + vaStartMethodStr;
            String endDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)entryEndDate) + " " + vaEndMethodStr;
            dateStr = isStartDate ? startDateStr : endDateStr;
        }
        return dateStr;
    }

    public static void summaryVaTypeTime(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObjectCollection collection = model.getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)collection)) {
            Label label = (Label)view.getControl("sumstr");
            label.setText(null);
            return;
        }
        HashMap<Long, ArrayList<SummaryVaTypeVo>> map = new HashMap<Long, ArrayList<SummaryVaTypeVo>>(16);
        for (DynamicObject row : collection) {
            long vaTypeId = row.getLong("entryvacationtype.id");
            String vaTypeName = row.getString("entryvacationtype.name");
            ArrayList<SummaryVaTypeVo> summaryVaTypeVos = (ArrayList<SummaryVaTypeVo>)map.get(vaTypeId);
            if (Objects.nonNull(summaryVaTypeVos)) {
                summaryVaTypeVos.add(VaApplyService.setSummaryVaTypeVo(vaTypeName, row));
                continue;
            }
            summaryVaTypeVos = new ArrayList<SummaryVaTypeVo>(10);
            summaryVaTypeVos.add(VaApplyService.setSummaryVaTypeVo(vaTypeName, row));
            map.put(vaTypeId, summaryVaTypeVos);
        }
        String text = VaApplyService.buildSumStr(map.values());
        Label label = (Label)view.getControl("sumstr");
        label.setText(text);
    }

    private static SummaryVaTypeVo setSummaryVaTypeVo(String vaTypeName, DynamicObject row) {
        SummaryVaTypeVo summaryVaTypeVo = new SummaryVaTypeVo();
        summaryVaTypeVo.setVaTypeName(vaTypeName);
        String unit = row.getString("entryunit");
        summaryVaTypeVo.setUnit(unit);
        summaryVaTypeVo.setDay(row.getBigDecimal("entryvatimeday"));
        summaryVaTypeVo.setHour(row.getBigDecimal("entryvatimehour"));
        return summaryVaTypeVo;
    }

    public static String buildSumStr(Collection<List<SummaryVaTypeVo>> values) {
        StringBuilder builder = new StringBuilder();
        for (List<SummaryVaTypeVo> value : values) {
            BigDecimal totalHour = BigDecimal.ZERO;
            BigDecimal totalDay = BigDecimal.ZERO;
            String maxUnit = null;
            for (SummaryVaTypeVo summaryVaTypeVo : value) {
                totalHour = totalHour.add(summaryVaTypeVo.getHour());
                totalDay = totalDay.add(summaryVaTypeVo.getDay());
                if (!HRStringUtils.isEmpty(maxUnit) && !BaseSetTimeUnitEnum.DATE.code.equalsIgnoreCase(summaryVaTypeVo.getUnit())) continue;
                maxUnit = summaryVaTypeVo.getUnit();
            }
            builder.append(value.get(0).getVaTypeName());
            builder.append(ResManager.loadKDString((String)"\u5171", (String)"VaApplyService_07", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            if (BaseSetTimeUnitEnum.DATE.code.equalsIgnoreCase(maxUnit)) {
                builder.append(totalDay.setScale(2, RoundingMode.HALF_UP));
            } else {
                builder.append(totalHour.setScale(2, RoundingMode.HALF_UP));
            }
            builder.append(BaseSetTimeUnitEnum.getLocalName((String)maxUnit)).append(',').append(' ');
        }
        builder.deleteCharAt(builder.lastIndexOf(","));
        return builder.toString();
    }

    public static BillResponse couldChange(DynamicObject dynamicObject, String entityId, String appId) {
        LOG.info("\u53ef\u53d8\u66f4\u6821\u9a8c\u5f00\u59cb\uff0c pk:{}, entityNumber:{}", dynamicObject.getPkValue(), (Object)entityId);
        if (dynamicObject.getBoolean("ishavechange")) {
            return BillResponse.error((Object)"", (List)Lists.newArrayList((Object[])new String[]{BillUnifyKDStringHelper.changeRepeat((String)BillTypeEnum.VACATIONBILL.getBillName())}));
        }
        boolean isNotLeave = dynamicObject.getBoolean("isnotleave");
        String errorMsg = ResManager.loadKDString((String)"\u8be5\u4f11\u5047\u5355\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"VaApplyService_01", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        if (isNotLeave) {
            LOG.info("\u5df2\u5931\u6548\u5047\u5355\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4.");
            return BillResponse.error(null, Collections.singletonList(errorMsg));
        }
        String applyTypeRadio = dynamicObject.getString("applytyperadio");
        if (StringUtils.equalsAny((CharSequence)entityId, (CharSequence[])new CharSequence[]{"wtabm_vaapplyself"}) && StringUtils.equals((CharSequence)applyTypeRadio, (CharSequence)"1")) {
            errorMsg = ResManager.loadKDString((String)"\u4e0d\u53ef\u5728\u672c\u4eba\u7533\u8bf7\u9875\u9762\u53d8\u66f4\u4ed6\u4eba\u4e3a\u6211\u7533\u8bf7\u7684\u5355\u636e\u3002", (String)"VaApplyService_02", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            return BillResponse.error(null, Collections.singletonList(errorMsg));
        }
        long attFileBoId = dynamicObject.getLong("attfile.id");
        ArrayList dyList = Lists.newArrayList((Object[])new DynamicObject[]{dynamicObject});
        List info = BillCheckService.createUnifyBillApplyInfo((List)dyList, (ApplyBillCheckEnum)ApplyBillCheckEnum.VACATION);
        UnifyBillApplyAttr attr = new UnifyBillApplyAttr(appId, entityId);
        UnifyBillInfoContext billInfoContext = new UnifyBillInfoContext((List)Lists.newArrayList((Iterable)info), attr);
        VaAutoOperator vaAutoOperator = new VaAutoOperator(billInfoContext);
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        boolean couldChange = false;
        boolean needCheckAttFileAuth = "1".equals(dynamicObject.getString("applytyperadio"));
        for (DynamicObject entryRow : entryEntity) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("entryRow:{}", (Object)SerializationUtils.toJsonString((Object)entryRow));
            }
            VaEntityCheckService billEntityCommonCheckService = VaEntityCheckService.createService(attFileBoId, ApplyBillCheckEnum.VACATION, entryRow, needCheckAttFileAuth, vaAutoOperator, attr);
            DynamicObject matchRule = billEntityCommonCheckService.getMatchRule();
            if (LOG.isDebugEnabled()) {
                LOG.debug("matchRule:{}", (Object)SerializationUtils.toJsonString((Object)matchRule));
            }
            if (!Objects.nonNull(matchRule) || matchRule.getDynamicObject("vachangesetid") == null) continue;
            LOG.info("\u68c0\u6d4b\u5230\u5206\u5f55\u53ef\u53d8\u66f4\uff1a{}\uff0cmatchRule vachangesetid:{}", entryRow.getPkValue(), (Object)matchRule.getLong("vachangesetid.id"));
            couldChange = true;
            break;
        }
        if (!couldChange) {
            return BillResponse.error(null, Collections.singletonList(errorMsg));
        }
        return BillResponse.success();
    }

    public static BillResponse couldChange(Object pkValue, String entityId, String appId) {
        DynamicObject dynamicObject = VaApplyServiceHelper.INSTANCE.loadSingle(pkValue);
        return VaApplyService.couldChange(dynamicObject, entityId, appId);
    }

    private static List<VaTypeSelectVo> getVaTypes(long attFileBoid, String attFileF7AuthEntity, String appId) {
        UnifyBillEnum vaUnifyBillEnum = UnifyBillEnum.VA;
        HashMap<Long, VaTypeSelectVo> typeRuleCollection = new HashMap<Long, VaTypeSelectVo>(10);
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(appId, attFileF7AuthEntity);
        UnifyBillApplyInitInfo info = new UnifyBillApplyInitInfo((Object)0L, attFileBoid, Collections.emptyList());
        UnifyBillInfoContext billInfoContext = new UnifyBillInfoContext((List)Lists.newArrayList((Object[])new UnifyBillApplyInitInfo[]{info}), applyAttr);
        VaAutoOperator vaAutoOperator = new VaAutoOperator(billInfoContext);
        List allRule = vaAutoOperator.getAllRule(attFileBoid);
        IAttfileLimitScopeService limitScopeService = (IAttfileLimitScopeService)WTCAppContextHelper.getBean(AttfileLimitScopeServiceImpl.class);
        Map attfileLimitScopeMap = limitScopeService.queryAttfileVersionInfo((Set)Sets.newHashSet((Object[])new Long[]{attFileBoid}), null);
        for (DynamicObject rule : allRule) {
            String dataStatus = rule.getString("datastatus");
            if (StringUtils.equalsAny((CharSequence)dataStatus, (CharSequence[])new CharSequence[]{HisDataStatus.SAVE.code, HisDataStatus.DELETE.code, HisDataStatus.DISCARD.code, HisDataStatus.UNKNOWN.code})) continue;
            for (DynamicObject ruleEntry : rule.getDynamicObjectCollection("entryentity")) {
                VaTypeSelectVo oldVaTypeSelectVo;
                long vaTypeId = ruleEntry.getLong("vatype.id");
                String vaTypeNumber = ruleEntry.getString("vatype.number");
                AttfileLimitScope attfileLimitScope = (AttfileLimitScope)attfileLimitScopeMap.get(attFileBoid);
                boolean matchLimit = limitScopeService.matchLimit(attfileLimitScope, ruleEntry.getString("limitscope"));
                if (!matchLimit) continue;
                long attPolicyId = 0L;
                if (StringUtils.equals((CharSequence)dataStatus, (CharSequence)HisDataStatus.EFFECTIVE.code)) {
                    attPolicyId = ruleEntry.getLong(vaUnifyBillEnum.getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum().getAttPolicy() + "." + "id");
                }
                if ((oldVaTypeSelectVo = (VaTypeSelectVo)typeRuleCollection.get(vaTypeId)) != null && attPolicyId != 0L) {
                    oldVaTypeSelectVo.setAttpolicyId(attPolicyId);
                    continue;
                }
                DynamicObject vaBaseSet = ruleEntry.getDynamicObject(vaUnifyBillEnum.getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum().getBaseSet());
                long vaBaseSetId = (Long)vaBaseSet.getPkValue();
                String unit = vaBaseSet.getString(ApplyBillBaseSetEnum.VACATION.getUnit());
                BigDecimal minApplyTime = vaBaseSet.getBigDecimal(ApplyBillBaseSetEnum.VACATION.getMinApplyTime());
                VaTypeSelectVo vaTypeSelectVo = new VaTypeSelectVo(vaTypeId, vaTypeNumber, attPolicyId, vaBaseSetId, unit, minApplyTime);
                typeRuleCollection.put(vaTypeSelectVo.getVaTypeId(), vaTypeSelectVo);
            }
        }
        ArrayList<VaTypeSelectVo> typeRules = new ArrayList<VaTypeSelectVo>(typeRuleCollection.values());
        return typeRules;
    }

    @Deprecated
    public static List<VaTypeSelectVo> getVaTypes(long attFileBoid, DynamicObject parentBillDyn, long parentEntryId, String attFileF7AuthEntity) {
        return VaApplyService.getVaTypes(attFileBoid, parentBillDyn, parentEntryId, attFileF7AuthEntity, "wtam");
    }

    public static List<VaTypeSelectVo> getVaTypes(long attFileBoid, DynamicObject parentBillDyn, long parentEntryId, String attFileF7AuthEntity, String appId) {
        List<Object> vaTypes = VaApplyService.getVaTypes(attFileBoid, attFileF7AuthEntity, appId);
        Map<Long, VaTypeSelectVo> vaTypeMap = vaTypes.stream().collect(Collectors.toMap(VaTypeSelectVo::getVaTypeId, vaTypeSelectVo -> vaTypeSelectVo));
        HashSet<Long> enumTypeIdSet = new HashSet<Long>(vaTypeMap.keySet());
        if (parentBillDyn != null && parentEntryId != 0L) {
            boolean needCheckAttFileAuth = "1".equals(parentBillDyn.getString("applytyperadio"));
            DynamicObjectCollection dynamicObjectCollection = parentBillDyn.getDynamicObjectCollection("entryentity");
            Optional<DynamicObject> firstOpt = dynamicObjectCollection.stream().filter(dataEntity -> (Long)dataEntity.getPkValue() == parentEntryId).findFirst();
            DynamicObject entryRow = null;
            if (firstOpt.isPresent()) {
                entryRow = firstOpt.get();
            }
            if (entryRow == null) {
                LOG.warn("\u6839\u636eparentEntryId\u6ca1\u83b7\u53d6\u5230\u76f8\u5173\u4fe1\u606f\uff1aparentBillDynId:{}.parentEntryId:{}", parentBillDyn.getPkValue(), (Object)parentEntryId);
                throw new KDBizException(VaKDStringHelper.queryVaTypeFail());
            }
            long parentEntryVaType = entryRow.getLong("entryvacationtype.id");
            UnifyBillApplyAttr attr = new UnifyBillApplyAttr(appId, attFileF7AuthEntity);
            VaEntityCheckService billEntityCheckService = VaEntityCheckService.createService(attFileBoid, ApplyBillCheckEnum.VACATION, entryRow, needCheckAttFileAuth, attr);
            DynamicObject matchChangeSet = billEntityCheckService.getMatchChangeSet();
            VaTypeSelectVo vaTypeSelectVo2 = vaTypeMap.get(parentEntryVaType);
            if (matchChangeSet == null) {
                vaTypes.clear();
                if (vaTypeSelectVo2 != null) {
                    vaTypes.add(vaTypeMap.get(parentEntryVaType));
                }
            } else {
                boolean limit = matchChangeSet.getBoolean("iscloudchangetype");
                if (limit) {
                    vaTypes.clear();
                    DynamicObjectCollection vaChangeTypes = matchChangeSet.getDynamicObjectCollection("entryentity");
                    Set<Long> collect = new HashSet<Long>();
                    if (!CollectionUtils.isEmpty((Collection)vaChangeTypes)) {
                        collect = vaChangeTypes.stream().map(changeType -> changeType.getLong("votypenumber.id")).collect(Collectors.toSet());
                    }
                    collect.add(parentEntryVaType);
                    enumTypeIdSet.retainAll(collect);
                    for (Long vaTypeId : enumTypeIdSet) {
                        vaTypes.add(vaTypeMap.get(vaTypeId));
                    }
                }
            }
        }
        vaTypes = vaTypes.stream().filter(Objects::nonNull).sorted(Comparator.comparing(VaTypeSelectVo::getVaTypeNumber)).collect(Collectors.toList());
        return vaTypes;
    }

    public static List<ComboItem> createComboItems(DynamicObject parentBillDyn) {
        DynamicObjectCollection billEntries = parentBillDyn.getDynamicObjectCollection("entryentity");
        Map<Long, DynamicObject> entryMap = billEntries.stream().collect(Collectors.toMap(entry -> entry.getLong("entryvacationtype.id"), entry -> entry, (e1, e2) -> {
            Date startDate2;
            Date startDate1 = e1.getDate("entrystartdate");
            return startDate1.after(startDate2 = e2.getDate("entrystartdate")) ? e1 : e2;
        }));
        Collection<DynamicObject> entries = entryMap.values();
        ArrayList<ComboItem> appInfos = new ArrayList<ComboItem>(entries.size());
        entries.forEach(entry -> {
            String nameStr = entry.getLocaleString("entryvacationtype.name").getLocaleValue();
            String suffix = ResManager.loadKDString((String)"\u53d8\u66f4\u6821\u9a8c", (String)"VaApplyMobileService_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            LocaleString name = new LocaleString(nameStr + suffix);
            String value = String.valueOf(entry.getLong("id"));
            appInfos.add(new ComboItem(name, value));
        });
        return appInfos;
    }

    public static void showUpdateForm(Long pk, IFormView view) {
        VaApplyService.showUpdateForm(pk, view, null);
    }

    public static void showUpdateForm(Long pk, IFormView view, CloseCallBack closeCallBack) {
        VaApplyServiceHelper vaApplyServiceHelper = (VaApplyServiceHelper)((Object)WTCAppContextHelper.getBean(VaApplyServiceHelper.class));
        DynamicObject billDyn = vaApplyServiceHelper.loadSingle(pk);
        VaApplyService.showUpdateForm(billDyn, view, closeCallBack);
    }

    public static void showUpdateForm(DynamicObject billDyn, IFormView view, CloseCallBack closeCallBack) {
        long personId = billDyn.getLong("personid.id");
        String applyTypeRadio = billDyn.getString("applytyperadio");
        Long userId = BillUnifyService.getUserId();
        if (userId == null || userId != personId) {
            applyTypeRadio = "1";
        }
        BillShowParameter billShowParameter = new BillShowParameter();
        if ("0".equals(applyTypeRadio)) {
            billShowParameter.setFormId("wtabm_vaupdateself");
        } else {
            billShowParameter.setFormId("wtabm_vaupdate");
        }
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setStatus(OperationStatus.ADDNEW);
        DynamicObject attFileF7 = billDyn.getDynamicObject("attfilebasef7");
        if (Objects.nonNull(attFileF7)) {
            billShowParameter.setCustomParam("attfilebasef7", attFileF7.getPkValue());
        }
        billShowParameter.setCustomParam("applytyperadio", billDyn.get("applytyperadio"));
        billShowParameter.setCustomParam("parentid", (Object)billDyn.getLong("id"));
        billShowParameter.setCustomParam("personid", (Object)personId);
        billShowParameter.setCustomParam("applytyperadio", (Object)applyTypeRadio);
        billShowParameter.setCustomParam("billopenfrom", view.getFormShowParameter().getCustomParam("billopenfrom"));
        if (closeCallBack != null) {
            billShowParameter.setCloseCallBack(closeCallBack);
        }
        view.showForm((FormShowParameter)billShowParameter);
    }

    public String getFormId(DynamicObject billDyn) {
        boolean isChange = billDyn.getBoolean("ischange");
        String applyTypeRadio = billDyn.getString("applytyperadio");
        String formId = null;
        formId = StringUtils.equals((CharSequence)applyTypeRadio, (CharSequence)"0") ? (isChange ? "wtabm_vaupdateself" : "wtabm_vaapplyself") : (isChange ? "wtabm_vaupdate" : "wtabm_vaapply");
        return formId;
    }

    public static void genEntryEntities(VaInfoVo vaInfoVo, DynamicObject entry) {
        HRBaseServiceHelper vatypeHelper = new HRBaseServiceHelper("wtbd_vacationtype");
        entry.set("entryvacationtype", (Object)vatypeHelper.loadSingle((Object)vaInfoVo.getVacationType()));
        entry.set("id", (Object)vaInfoVo.getId());
        entry.set("entryunit", (Object)vaInfoVo.getUnit());
        entry.set("entryreason", (Object)vaInfoVo.getEntryReason());
        entry.set("entrystartmethod", (Object)String.valueOf(vaInfoVo.getStartMethod()));
        entry.set("entryendmethod", (Object)String.valueOf(vaInfoVo.getEndMethod()));
        entry.set("entryvatimeday", (Object)vaInfoVo.getEntryVaTimeDay());
        entry.set("entryvatimehour", (Object)vaInfoVo.getEntryVaTimeHour());
        entry.set("entryvalidtimehour", (Object)vaInfoVo.getEntryValidTimeHour());
        entry.set("entryvalidtimeday", (Object)vaInfoVo.getEntryValidTimeDay());
        entry.set("entrystartdate", (Object)vaInfoVo.getStartDate());
        entry.set("entryenddate", (Object)vaInfoVo.getEndDate());
        entry.set("entryunit", (Object)vaInfoVo.getUnit());
        entry.set("owndate", (Object)vaInfoVo.getOwnDate());
        entry.set("entryparentid", (Object)vaInfoVo.getEntryParentId());
        entry.set("specialvatype", (Object)vaInfoVo.getSpecialVaType());
        entry.set("isdisposable", (Object)vaInfoVo.getDisposable());
        if (vaInfoVo.getSpecialVaMethod() != 0L) {
            HRBaseServiceHelper breastTypeHelper = new HRBaseServiceHelper("wtbd_breastdaytype");
            entry.set("specialvamethod", (Object)breastTypeHelper.loadSingle((Object)vaInfoVo.getSpecialVaMethod()));
        }
        entry.set("specialextjson", (Object)vaInfoVo.getVaLactationTimeStorageJson());
        VaApplyService.generateVaDetails(vaInfoVo, entry);
    }

    public void resetBillEntryDisposable(List<DynamicObject> billDys, VaAutoOperator vaAutoOperator) {
        for (DynamicObject billDy : billDys) {
            long attFileBoId = billDy.getLong("attfile.boid");
            DynamicObjectCollection entryEntities = billDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject dyObject : entryEntities) {
                Map ruleCalDyMap;
                DynamicObject ruleCalDy;
                Date useVersionDate = vaAutoOperator.getUseVersionDate(dyObject, ApplyBillCheckEnum.VACATION);
                long vaTypeId = dyObject.getLong("entryvacationtype.id");
                if (vaTypeId == 0L || (ruleCalDy = (DynamicObject)(ruleCalDyMap = vaAutoOperator.getRuleCalDy(attFileBoId, dyObject.getDate("entrystartdate"), dyObject.getDate("entryenddate"), vaTypeId)).get(useVersionDate)) == null) continue;
                boolean isquota = ruleCalDy.getBoolean("isquota");
                boolean disposable = ruleCalDy.getBoolean("isdisposable");
                dyObject.set("isdisposable", (Object)(isquota && disposable ? 1 : 0));
            }
        }
    }

    public AttendPersonCurrModel parseAttendPersonCurrModel(long attPersonId, AttendPersonCurrResult currentAttPerson) {
        if (currentAttPerson == null) {
            return null;
        }
        List attendPersonCurrModels = currentAttPerson.getAttendPersonCurrModels();
        if (CollectionUtils.isNotEmpty((Collection)attendPersonCurrModels)) {
            Map<Long, AttendPersonCurrModel> attendPersonCurrModelMap = attendPersonCurrModels.stream().collect(Collectors.toMap(attendPersonCurrModel -> {
                Person person = attendPersonCurrModel.getPerson();
                Long id = null;
                if (person != null) {
                    id = person.getBid();
                }
                return id;
            }, cur -> cur, (cur1, cur2) -> cur2));
            AttendPersonCurrModel model = attendPersonCurrModelMap.get(attPersonId);
            return model;
        }
        return null;
    }

    public void dealBreastfeedingLeave(IFormView view) {
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("entryentity");
        boolean haveBreastfeedingLeave = false;
        for (int index = 0; index < entryEntity.size(); ++index) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(index);
            String specialVaType = dynamicObject.getString("specialvatype");
            if (!WTCStringUtils.equals((String)specialVaType, (String)SpecialVaTypeEnum.LACTATION_TYPE.vaType)) continue;
            String specialExtJsonStr = dynamicObject.getString("specialextjson");
            VaLactationTimeStorage timeStorage = (VaLactationTimeStorage)JSON.parseObject((String)specialExtJsonStr, VaLactationTimeStorage.class);
            BigDecimal offTimePerDay = timeStorage.getOffTimePerDay();
            boolean isNotLeave = (Boolean)view.getModel().getValue("isnotleave");
            if (!isNotLeave) {
                view.getModel().setValue("offtimeperday", (Object)offTimePerDay, index);
            }
            haveBreastfeedingLeave = true;
        }
        view.setVisible(Boolean.valueOf(haveBreastfeedingLeave), new String[]{"specialvamethod", "offtimeperday"});
    }

    public void openQuotaInfoDetailForBillView(IFormView formView) {
        if (formView == null) {
            return;
        }
        IDataModel model = formView.getModel();
        DynamicObject billDyn = model.getDataEntity(true);
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(BillCommonService.getInstance().getAuthAppIdForFormPlugin(formView), formView.getEntityId());
        DynamicObject newDy = this.updateOwnDateByNewDy(billDyn, applyAttr);
        int rowIndex = model.getEntryCurrentRowIndex("entryentity");
        DynamicObject entryDy = (DynamicObject)newDy.getDynamicObjectCollection("entryentity").get(rowIndex);
        VaApplyService service = new VaApplyService();
        service.openQuotaInfoDetail(newDy, entryDy, applyAttr, formView, ApplyBillCheckEnum.VACATION);
    }

    public void openQuotaInfoDetail(DynamicObject billDyn, DynamicObject entryEntity, UnifyBillApplyAttr applyAttr, IFormView formView, ApplyBillCheckEnum checkEnum) {
        if (entryEntity == null) {
            return;
        }
        if (formView == null) {
            return;
        }
        long vaTypeId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entryEntity, (String)checkEnum.getType());
        long attFileBoId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)billDyn, (String)"attfile");
        Map<Long, Long> deductRuleVidMap = VaBaseService.getInstance().getDeductRuleVids(attFileBoId, entryEntity, vaTypeId, applyAttr, checkEnum);
        Long deductRuleVid = deductRuleVidMap.get(vaTypeId);
        LOG.info("deductRuleVid\u67e5\u8be2\u7ed3\u679c\uff1a{}, vaTypeId:{}", (Object)deductRuleVid, (Object)vaTypeId);
        if (deductRuleVid != null) {
            UsableQuotaQueryReq queryReq = new UsableQuotaQueryReq();
            queryReq.setBillType(BusinessTypeEnum.VACATION.getCode());
            queryReq.setAttFileBoId(Long.valueOf(attFileBoId));
            queryReq.setAttFileVId(Long.valueOf(billDyn.getLong("attfilebasef7.id")));
            queryReq.setId(billDyn.getLong("id"));
            queryReq.setParentId(billDyn.getLong("parentid"));
            queryReq.setPersonId(Long.valueOf(billDyn.getLong("personid.id")));
            queryReq.setDeductionRuleIds((List)Lists.newArrayList((Object[])new Long[]{deductRuleVid}));
            queryReq.setStartDate(entryEntity.getDate(checkEnum.getStartDate()));
            queryReq.setEndDate(entryEntity.getDate(checkEnum.getEndDate()));
            List<UsableQuotaQueryResp> vaQuotaInfos = VaBaseService.getInstance().getVAQuotaInfos(Lists.newArrayList((Object[])new UsableQuotaQueryReq[]{queryReq}));
            if (CollectionUtils.isNotEmpty(vaQuotaInfos)) {
                UsableQuotaQueryResp usableQuotaQueryResp = vaQuotaInfos.get(0);
                List result = usableQuotaQueryResp.getResult();
                ArrayList quotaInfos = Lists.newArrayListWithExpectedSize((int)10);
                for (UsableQuotaQueryResult usableQuotaQueryResult : result) {
                    List useableQuotaInfos = usableQuotaQueryResult.getUseableQuotaInfos();
                    if (!CollectionUtils.isNotEmpty((Collection)useableQuotaInfos)) continue;
                    quotaInfos.addAll(useableQuotaInfos);
                }
                String quotaInfoStr = JSON.toJSONString((Object)quotaInfos);
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("wtabm_vaquotainfo");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setStatus(OperationStatus.VIEW);
                formShowParameter.setCustomParam(QUOTA_INFO, (Object)quotaInfoStr);
                formView.showForm(formShowParameter);
            } else {
                LOG.warn("\u672a\u67e5\u8be2\u5230\u5b9a\u989d\u7ed3\u679c.");
                formView.showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5b9a\u989d\u4fe1\u606f\u3002", (String)"VaApplyService_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
        } else {
            formView.showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5b9a\u989d\u4fe1\u606f\u3002", (String)"VaApplyService_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    public Map<Integer, Boolean> showQuotaInfoDetail(DynamicObject vaBillDy, IFormView formView) {
        if (vaBillDy == null || formView == null) {
            return Collections.emptyMap();
        }
        DynamicObjectCollection entryColl = vaBillDy.getDynamicObjectCollection("entryentity");
        if (WTCCollections.isEmpty((Collection)entryColl)) {
            return Collections.emptyMap();
        }
        HashMap<Integer, Boolean> result = new HashMap<Integer, Boolean>(16);
        ApplyBillCheckEnum checkEnum = ApplyBillCheckEnum.VACATION;
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(BillCommonService.getInstance().getAuthAppIdForFormPlugin(formView), formView.getEntityId());
        DynamicObject newDy = this.updateOwnDateByNewDy(vaBillDy, applyAttr);
        DynamicObjectCollection entryCollNew = newDy.getDynamicObjectCollection("entryentity");
        for (int index = 0; index < entryCollNew.size(); ++index) {
            long vaTypeId;
            Map<Long, VaQuotaResInfo> vaQuotasMap;
            VaQuotaResInfo vaQuotaResInfo;
            boolean quotaInfoBtnVisible = Boolean.FALSE;
            DynamicObject entryDy = (DynamicObject)entryCollNew.get(index);
            DynamicObject vaTypeDy = entryDy.getDynamicObject(checkEnum.getType());
            if (vaTypeDy != null && (vaQuotaResInfo = (vaQuotasMap = this.getQuotaInfo(entryDy, false, applyAttr, ApplyBillCheckEnum.VACATION, vaBillDy)).get(vaTypeId = vaTypeDy.getLong("id"))) != null) {
                OnRenameVaTypeEvent onRenameVaTypeEvent = VaApplyExtHelper.onRenameVaTypeEvent(vaTypeDy, vaTypeId, formView.getEntityId(), vaQuotaResInfo);
                if (onRenameVaTypeEvent != null) {
                    if (!onRenameVaTypeEvent.isCancel()) {
                        quotaInfoBtnVisible = onRenameVaTypeEvent.isShowQuotas();
                    }
                } else {
                    quotaInfoBtnVisible = Boolean.TRUE;
                }
            }
            result.put(index, quotaInfoBtnVisible);
        }
        return result;
    }

    public DynamicObject updateOwnDateByNewDy(DynamicObject vaBillDy, UnifyBillApplyAttr applyAttr) {
        MainEntityType dyType = EntityMetadataCache.getDataEntityType((String)vaBillDy.getDataEntityType().getName());
        DynamicObject instance = (DynamicObject)dyType.createInstance();
        HRDynamicObjectUtils.copy((DynamicObject)vaBillDy, (DynamicObject)instance);
        VaBillCheckService vaBillCheckService = new VaBillCheckService(ApplyBillCheckEnum.VACATION, UnifyBillEnum.VA, Collections.singletonList(instance), applyAttr);
        vaBillCheckService.checkRoster();
        return instance;
    }

    public Map<Long, VaQuotaResInfo> getQuotaInfo(DynamicObject entryDy, boolean isAll, UnifyBillApplyAttr applyAttr, ApplyBillCheckEnum checkEnum, DynamicObject billDy) {
        if (billDy == null) {
            return Collections.emptyMap();
        }
        VaQuotaInfoVo vaQuotaInfoVo = new VaQuotaInfoVo().setBillId(billDy.getLong("id")).setParentBillId(billDy.getLong("parentid")).setUseDate(VaBaseService.getInstance().getUseVersionDate(entryDy, checkEnum)).setAttPersonId(billDy.getLong("personid.id")).setVacationType(isAll ? 0L : WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entryDy, (String)checkEnum.getType())).setAttFileVid(billDy.getLong("attfilebasef7.id")).setApplyAttr(applyAttr);
        vaQuotaInfoVo.setAttFileBoid(billDy.getLong("attfile.id"));
        vaQuotaInfoVo.setStartDate(entryDy.getDate(checkEnum.getStartDate()));
        vaQuotaInfoVo.setEndDate(entryDy.getDate(checkEnum.getEndDate()));
        return VaBaseService.getInstance().getVaTypeQuotaInfo(vaQuotaInfoVo);
    }

    public void handleVisForQuota(IFormView view) {
        block4: {
            block3: {
                BillShowParameter showParameter = (BillShowParameter)view.getFormShowParameter();
                OperationStatus status = showParameter.getStatus();
                if (OperationStatus.VIEW != status) break block3;
                VaApplyService service = new VaApplyService();
                Map<Integer, Boolean> indexAndVis = service.showQuotaInfoDetail(view.getModel().getDataEntity(true), view);
                DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("entryentity");
                EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
                if (!WTCCollections.isNotEmpty((Collection)entryEntity)) break block4;
                for (int index = 0; index < entryEntity.size(); ++index) {
                    boolean vis;
                    boolean bl = vis = indexAndVis.get(index) != null && indexAndVis.get(index) != false;
                    if (vis) continue;
                    entryGrid.hideOperateItems("operationcolumnap1", index, (List)Lists.newArrayList((Object[])new String[]{"quotainfodetail"}));
                    entryGrid.hideOperateItems("operationcolumnap2", index, (List)Lists.newArrayList((Object[])new String[]{"quotainfodetail"}));
                }
                break block4;
            }
            DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("entryentity");
            EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
            if (WTCCollections.isNotEmpty((Collection)entryEntity)) {
                for (int index = 0; index < entryEntity.size(); ++index) {
                    entryGrid.hideOperateItems("operationcolumnap1", index, (List)Lists.newArrayList((Object[])new String[]{"quotainfodetail"}));
                    entryGrid.hideOperateItems("operationcolumnap2", index, (List)Lists.newArrayList((Object[])new String[]{"quotainfodetail"}));
                }
            }
        }
    }
}

