/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.business.vaapply;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtabm.business.vaapply.VaCommonService;
import kd.wtc.wtabm.business.vaapply.VaKDStringHelper;
import kd.wtc.wtabm.common.entity.vaapply.VaNonQtApplyCache;
import kd.wtc.wtabm.common.entity.vaapply.VaQuotaInfoVo;
import kd.wtc.wtabm.common.entity.vaapply.VaQuotaResInfo;
import kd.wtc.wtabm.common.entity.vaapply.VaTypeSelectVo;
import kd.wtc.wtbs.business.bill.batchbill.BatchBillUnifyService;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.web.applybill.commonhelper.UnifyBillCommonHelper;
import kd.wtc.wtbs.business.web.applybill.operatecore.va.VaAutoOperator;
import kd.wtc.wtbs.business.web.applybill.service.BillEntityCheckService;
import kd.wtc.wtbs.common.bill.batchbill.BatchBillKDString;
import kd.wtc.wtbs.common.constants.WTCBaseKDString;
import kd.wtc.wtbs.common.deduction.BillApply;
import kd.wtc.wtbs.common.deduction.BillApplyEntry;
import kd.wtc.wtbs.common.deduction.QTApplyReq;
import kd.wtc.wtbs.common.deduction.QTWarnEvent;
import kd.wtc.wtbs.common.deduction.frozen.BillApplyEntryFrozenResult;
import kd.wtc.wtbs.common.deduction.frozen.FrozenApplyReq;
import kd.wtc.wtbs.common.deduction.frozen.FrozenQTInfo;
import kd.wtc.wtbs.common.deduction.frozen.FrozenResult;
import kd.wtc.wtbs.common.deduction.usable.AffluentUsableQuotaInfo;
import kd.wtc.wtbs.common.deduction.usable.UsableQuotaInfo;
import kd.wtc.wtbs.common.deduction.usable.UsableQuotaQueryReq;
import kd.wtc.wtbs.common.deduction.usable.UsableQuotaQueryResp;
import kd.wtc.wtbs.common.deduction.usable.UsableQuotaQueryResult;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.ApplyBillTimeUnitEnum;
import kd.wtc.wtbs.common.enums.BusinessTypeEnum;
import kd.wtc.wtbs.common.enums.bill.unify.BillSourceTypeEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.bill.BillApplyTimeResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyInitInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyServiceEntryInitInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillExpandInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillInfoContext;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCMaps;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtp.enums.vaplan.BaseSetTimeUnitEnum;
import kd.wtc.wtp.business.cumulate.QTService;
import kd.wtc.wtp.business.cumulate.trading.QTOuterParamUtils;
import kd.wtc.wtp.business.vaqt.VAQuotaHelper;

public class VaBaseService {
    private static final Log LOG = LogFactory.getLog(VaBaseService.class);
    private static final VaBaseService INS = (VaBaseService)WTCAppContextHelper.getBean((String)VaBaseService.class.getName(), VaBaseService.class);

    public static VaBaseService getInstance() {
        return INS;
    }

    public UsableQuotaQueryReq getVaQuotaParam(long billId, long parentBillId, long attFileBoId, long attFileVid, long personId, List<Long> deductRuleVIds) {
        UsableQuotaQueryReq queryReq = new UsableQuotaQueryReq();
        queryReq.setBillType(BusinessTypeEnum.VACATION.getCode());
        queryReq.setAttFileBoId(Long.valueOf(attFileBoId));
        queryReq.setAttFileVId(Long.valueOf(attFileVid));
        queryReq.setId(billId);
        queryReq.setParentId(parentBillId);
        queryReq.setPersonId(Long.valueOf(personId));
        queryReq.setDeductionRuleIds(deductRuleVIds);
        return queryReq;
    }

    public Date getUseVersionDate(DynamicObject dyObject, ApplyBillCheckEnum checkEnum) {
        String startMethod = dyObject.getString(checkEnum.getStartMethod());
        Date date = StringUtils.equalsAny((CharSequence)startMethod, (CharSequence[])new CharSequence[]{WtcTimeRangeBtnTypeEnum.HALF_UP.value, WtcTimeRangeBtnTypeEnum.HALF_DOWN.value, WtcTimeRangeBtnTypeEnum.DAY.value}) ? (BillEntityCheckService.getCheckStartOrEnd() ? dyObject.getDate(checkEnum.getStartDate()) : dyObject.getDate(checkEnum.getEndDate())) : dyObject.getDate(checkEnum.getOwndate());
        if (date == null) {
            return WTCDateUtils.toDate((LocalDate)LocalDate.now());
        }
        return new Date(date.getTime());
    }

    @Deprecated
    public Map<Long, Long> getDeductRuleVids(Long attFileBoId, DynamicObject dataEntity, long vaTypeId, String attFileF7AuthEntity) {
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr("wtam", attFileF7AuthEntity);
        return this.getDeductRuleVids(attFileBoId, dataEntity, vaTypeId, applyAttr);
    }

    public Map<Long, Long> getDeductRuleVids(Long attFileBoId, DynamicObject dataEntity, long vaTypeId, UnifyBillApplyAttr applyAttr) {
        return this.getDeductRuleVids(attFileBoId, dataEntity, vaTypeId, applyAttr, ApplyBillCheckEnum.VACATIONFORM);
    }

    public Map<Long, Long> getDeductRuleVids(Long attFileBoId, DynamicObject dataEntity, long vaTypeId, UnifyBillApplyAttr applyAttr, ApplyBillCheckEnum applyBillCheckEnum) {
        Date useVersionDate = this.getUseVersionDate(dataEntity, applyBillCheckEnum);
        if (useVersionDate == null) {
            // empty if block
        }
        return this.getDeductRuleVids(attFileBoId, useVersionDate, vaTypeId, applyAttr);
    }

    @Deprecated
    public Map<Long, Long> getDeductRuleVids(Long attFileBoId, Date useVersionDate, long vaTypeId, String attFileF7AuthEntity) {
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr("wtam", attFileF7AuthEntity);
        return this.getDeductRuleVids(attFileBoId, useVersionDate, vaTypeId, applyAttr);
    }

    public Map<Long, Long> getDeductRuleVids(Long attFileBoId, Date useVersionDate, long vaTypeId, UnifyBillApplyAttr applyAttr) {
        LOG.info("getDeductRuleVids:attFileBoId:{}, useVersionDate:{}, applyAttr:{}", new Object[]{attFileBoId, useVersionDate, applyAttr});
        VaAutoOperator singleOperator = this.getSingleVaAutoOperator((long)attFileBoId, useVersionDate, useVersionDate, vaTypeId, applyAttr);
        Map ruleDyMap = singleOperator.getRuleDy(attFileBoId.longValue(), useVersionDate, useVersionDate);
        DynamicObject ruleDy = (DynamicObject)ruleDyMap.get(useVersionDate);
        if (ruleDy == null) {
            return new HashMap<Long, Long>(0);
        }
        Map<Long, Long> deductRuleBoIdMap = ruleDy.getDynamicObjectCollection("entryentity").stream().filter(dy -> (vaTypeId == 0L || vaTypeId == dy.getLong("vatype.id")) && dy.getBoolean("isquota")).collect(Collectors.toMap(dy -> dy.getLong("vatype.id"), dy -> dy.getLong("deductrule.id"), (o1, o2) -> o2));
        QFilter dateQFilter = WTCHisServiceHelper.getDateQFilter((Date)useVersionDate);
        Map<Long, List<DynamicObject>> deductHisDyMap = this.getDeductRuleVersionMap(deductRuleBoIdMap.values(), dateQFilter);
        HashMap retMap = Maps.newHashMapWithExpectedSize((int)deductRuleBoIdMap.size());
        for (Map.Entry<Long, Long> deductRuleBoIdEntry : deductRuleBoIdMap.entrySet()) {
            DynamicObject seqHisDyByDate;
            List<DynamicObject> hisDys = deductHisDyMap.get(deductRuleBoIdEntry.getValue());
            if (hisDys == null || (seqHisDyByDate = UnifyBillCommonHelper.getSeqHisDyByDate((Object)deductRuleBoIdEntry.getValue(), (Date)useVersionDate, hisDys)) == null) continue;
            retMap.put(deductRuleBoIdEntry.getKey(), seqHisDyByDate.getLong("id"));
        }
        return retMap;
    }

    private Map<Long, List<DynamicObject>> getDeductRuleVersionMap(Collection<Long> boIds, QFilter dateQFilter) {
        QFilter boQFilter = WTCHisServiceHelper.boQFilter(boIds);
        QFilter dataStatusValidQFilter = WTCHisServiceHelper.dataStatusValidQFilter();
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_qtdeducrule");
        DynamicObject[] deductHisDys = helper.query("id,boid,bsed,bsled", new QFilter[]{dateQFilter, boQFilter, dataStatusValidQFilter});
        return Arrays.stream(deductHisDys).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
    }

    @Deprecated
    public BillResponse popValidateQuota(DynamicObject parentDy, DynamicObject dataEntity, BillApplyTimeResult timeResult, String attFileF7AuthEntity) {
        return BillResponse.success();
    }

    @Deprecated
    public BillResponse popValidateQuota(DynamicObject parentDy, DynamicObject dataEntity, BillApplyTimeResult timeResult, UnifyBillApplyAttr applyAttr) {
        return BillResponse.success();
    }

    public FrozenApplyReq genQuotaFrozeReqs(List<DynamicObject> billDys, String operateType, VaAutoOperator vaAutoOperator) {
        FrozenApplyReq frozenApplyReq = new FrozenApplyReq();
        frozenApplyReq.setBillType(BusinessTypeEnum.VACATION.getCode());
        frozenApplyReq.setOperateType(operateType);
        Map<Object, Object> deductRuleVidMap = Maps.newHashMap();
        if (StringUtils.equalsAny((CharSequence)operateType, (CharSequence[])new CharSequence[]{"FROZEN", "TRYFROZEN"})) {
            deductRuleVidMap = this.getDeductRuleVIdMap(billDys, vaAutoOperator);
        }
        ApplyBillCheckEnum checkEnum = ApplyBillCheckEnum.VACATION;
        ArrayList billApplyList = Lists.newArrayListWithCapacity((int)billDys.size());
        for (DynamicObject billDy : billDys) {
            BillApply billApply = this.getBillApply(deductRuleVidMap, checkEnum, billDy, vaAutoOperator);
            billApplyList.add(billApply);
        }
        frozenApplyReq.setBillApplyList((List)billApplyList);
        return frozenApplyReq;
    }

    public QTApplyReq genQuotaApplyReqs(List<DynamicObject> billDys, String operateType) {
        QTApplyReq applyReq = new QTApplyReq();
        applyReq.setBillType(BusinessTypeEnum.VACATION.getCode());
        applyReq.setOperateType(operateType);
        ApplyBillCheckEnum checkEnum = ApplyBillCheckEnum.VACATION;
        ArrayList billApplyList = Lists.newArrayListWithCapacity((int)billDys.size());
        for (DynamicObject billDy : billDys) {
            BillApply billApply = this.getBillApply(Maps.newHashMap(), checkEnum, billDy);
            billApplyList.add(billApply);
        }
        applyReq.setBillApplyList((List)billApplyList);
        return applyReq;
    }

    private BillApply getBillApply(DynamicObject billDy) {
        BillApply billApply = new BillApply();
        long billId = billDy.getLong("id");
        long parentBillId = billDy.getLong("parentid");
        long personId = billDy.getLong("personid.id");
        String billNo = billDy.getString("billno");
        long attFileBoId = billDy.getLong("attfile.boid");
        long attFileVid = billDy.getLong("attfilebasef7.id");
        long orgId = billDy.getLong("org.id");
        billApply.setBillNo(billNo);
        billApply.setId(billId);
        billApply.setAttFileBoId(attFileBoId);
        billApply.setAttFileVId(attFileVid);
        billApply.setOrgId(orgId);
        billApply.setPersonId(personId);
        billApply.setParentId(parentBillId);
        return billApply;
    }

    private BillApply getBillApply(Map<String, Long> deductRuleVIdMap, ApplyBillCheckEnum checkEnum, DynamicObject billDy) {
        BillApply billApply = this.getBillApply(billDy);
        long billId = billDy.getLong("id");
        DynamicObjectCollection entryEntities = billDy.getDynamicObjectCollection("entryentity");
        ArrayList billApplyEntries = Lists.newArrayListWithCapacity((int)entryEntities.size());
        for (DynamicObject dyObject : entryEntities) {
            long deductRuleVId = deductRuleVIdMap.getOrDefault(this.genEntryKey(billId, dyObject.getInt("seq")), 0L);
            BigDecimal valDay = dyObject.getBigDecimal("entryvatimeday");
            BigDecimal valHour = dyObject.getBigDecimal("entryvatimehour");
            String vacationType = dyObject.getString("entryvacationtype.name");
            Date startDate = dyObject.getDate(checkEnum.getStartDate());
            Date endDate = dyObject.getDate(checkEnum.getEndDate());
            BillApplyEntry billApplyEntry = new BillApplyEntry();
            billApplyEntry.setStartDate(startDate);
            billApplyEntry.setEndDate(endDate);
            billApplyEntry.setDeductionRuleId(deductRuleVId);
            billApplyEntry.setVaTimeDay(valDay);
            billApplyEntry.setVaTimeHour(valHour);
            billApplyEntry.setVacationType(vacationType);
            billApplyEntry.setEntryId(dyObject.getLong("id"));
            billApplyEntry.setDisposable(dyObject.getBoolean("isdisposable"));
            billApplyEntries.add(billApplyEntry);
        }
        billApply.setEntryEntities((List)billApplyEntries);
        return billApply;
    }

    private BillApply getBillApply(Map<String, Long> deductRuleVIdMap, ApplyBillCheckEnum checkEnum, DynamicObject billDy, VaAutoOperator vaAutoOperator) {
        BillApply billApply = this.getBillApply(billDy);
        long billId = billDy.getLong("id");
        DynamicObjectCollection entryEntities = billDy.getDynamicObjectCollection("entryentity");
        ArrayList billApplyEntries = Lists.newArrayListWithCapacity((int)entryEntities.size());
        for (DynamicObject dyObject : entryEntities) {
            Map ruleCalDyMap;
            DynamicObject ruleCalDy;
            Date useVersionDate = vaAutoOperator.getUseVersionDate(dyObject, checkEnum);
            long vaTypeId = dyObject.getLong(checkEnum.getType() + "." + "id");
            if (vaTypeId == 0L || (ruleCalDy = (DynamicObject)(ruleCalDyMap = vaAutoOperator.getRuleCalDy(billDy.getLong("attfile.id"), dyObject.getDate(checkEnum.getStartDate()), dyObject.getDate(checkEnum.getEndDate()), vaTypeId)).get(useVersionDate)) == null) continue;
            boolean isQuota = ruleCalDy.getBoolean("isquota");
            boolean split = ruleCalDy.getBoolean("issplit");
            long deductRuleVId = deductRuleVIdMap.getOrDefault(this.genEntryKey(billId, dyObject.getInt("seq")), 0L);
            BigDecimal valDay = dyObject.getBigDecimal("entryvatimeday");
            BigDecimal valHour = dyObject.getBigDecimal("entryvatimehour");
            String vacationType = dyObject.getString("entryvacationtype.name");
            String startMethod = dyObject.getString(checkEnum.getStartMethod());
            Date startDate = dyObject.getDate(checkEnum.getStartDate());
            Date endDate = dyObject.getDate(checkEnum.getEndDate());
            Date ownDate = dyObject.getDate(checkEnum.getOwndate());
            BillApplyEntry billApplyEntry = new BillApplyEntry();
            if (WtcTimeRangeBtnTypeEnum.CUSTOM.value.equals(startMethod)) {
                billApplyEntry.setStartDate(ownDate);
                billApplyEntry.setEndDate(ownDate);
            } else {
                billApplyEntry.setStartDate(startDate);
                billApplyEntry.setEndDate(endDate);
            }
            billApplyEntry.setDeductionRuleId(deductRuleVId);
            billApplyEntry.setVaTimeDay(valDay);
            billApplyEntry.setVaTimeHour(valHour);
            billApplyEntry.setVacationType(vacationType);
            billApplyEntry.setEntryId(dyObject.getLong("id"));
            billApplyEntry.setDisposable(dyObject.getBoolean("isdisposable"));
            if (!dyObject.getBoolean("isdisposable")) {
                billApplyEntry.setNonQuota(!isQuota);
            }
            billApplyEntry.setSplit(split);
            billApplyEntries.add(billApplyEntry);
        }
        billApply.setEntryEntities((List)billApplyEntries);
        return billApply;
    }

    private DynamicObject getRuleCalDy(VaAutoOperator vaAutoOperator, DynamicObject billDy, DynamicObject dyObject, ApplyBillCheckEnum checkEnum) {
        Date useVersionDate = vaAutoOperator.getUseVersionDate(dyObject, checkEnum);
        long vaTypeId = dyObject.getLong(checkEnum.getType() + "." + "id");
        if (vaTypeId == 0L) {
            LOG.info("\u89e3\u6790\u5904\u7406\u4f11\u5047\u89c4\u5219\u5f02\u5e38\uff01");
            return null;
        }
        Map ruleCalDyMap = vaAutoOperator.getRuleCalDy(billDy.getLong("attfile.id"), dyObject.getDate(checkEnum.getStartDate()), dyObject.getDate(checkEnum.getEndDate()), vaTypeId);
        DynamicObject ruleCalDy = (DynamicObject)ruleCalDyMap.get(useVersionDate);
        return ruleCalDy;
    }

    private Map<String, Long> getDeductRuleVIdMap(List<DynamicObject> billDys, VaAutoOperator vaAutoOperator) {
        Date useVersionDate;
        DynamicObjectCollection entryEntities;
        HashMap deductBoIdMap = Maps.newHashMap();
        ApplyBillCheckEnum checkEnum = ApplyBillCheckEnum.VACATION;
        for (DynamicObject billDy : billDys) {
            long billId = billDy.getLong("id");
            long attFileBoId = billDy.getLong("attfile.boid");
            entryEntities = billDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject dyObject : entryEntities) {
                long deductRuleId;
                Map ruleCalDyMap;
                DynamicObject ruleCalDy;
                useVersionDate = vaAutoOperator.getUseVersionDate(dyObject, checkEnum);
                long vaTypeId = dyObject.getLong(checkEnum.getType() + "." + "id");
                if (vaTypeId == 0L || (ruleCalDy = (DynamicObject)(ruleCalDyMap = vaAutoOperator.getRuleCalDy(attFileBoId, dyObject.getDate(checkEnum.getStartDate()), dyObject.getDate(checkEnum.getEndDate()), vaTypeId)).get(useVersionDate)) == null || (deductRuleId = ruleCalDy.getLong("deductrule.id")) == 0L) continue;
                deductBoIdMap.put(this.genEntryKey(billId, dyObject.getInt("seq")), deductRuleId);
            }
        }
        Map<Long, List<DynamicObject>> deductRuleVersionMap = this.getDeductRuleVersionMap(deductBoIdMap.values(), null);
        HashMap retMap = Maps.newHashMapWithExpectedSize((int)deductBoIdMap.size());
        for (DynamicObject billDy : billDys) {
            long billId = billDy.getLong("id");
            entryEntities = billDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject dyObject : entryEntities) {
                DynamicObject seqHisDyByDate;
                useVersionDate = vaAutoOperator.getUseVersionDate(dyObject, checkEnum);
                String entryKey = this.genEntryKey(billId, dyObject.getInt("seq"));
                Long deductRuleId = (Long)deductBoIdMap.get(entryKey);
                if (deductRuleId == null || (seqHisDyByDate = UnifyBillCommonHelper.getSeqHisDyByDate((Object)deductRuleId, (Date)useVersionDate, deductRuleVersionMap.get(deductRuleId))) == null) continue;
                retMap.put(entryKey, seqHisDyByDate.getLong("id"));
            }
        }
        return retMap;
    }

    @Deprecated
    public VaAutoOperator getSingleVaAutoOperator(long attFileBoId, Date startDate, Date endDate, long typeId, String attFileF7AuthEntity) {
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr("wtam", attFileF7AuthEntity);
        return this.getSingleVaAutoOperator(attFileBoId, startDate, endDate, typeId, applyAttr);
    }

    public VaAutoOperator getSingleVaAutoOperator(long attFileBoId, Date startDate, Date endDate, long typeId, UnifyBillApplyAttr applyAttr) {
        UnifyBillApplyServiceEntryInitInfo unifyBillApplyServiceEntryInitInfo = new UnifyBillApplyServiceEntryInitInfo(startDate, endDate, typeId);
        unifyBillApplyServiceEntryInitInfo.setExpandInfo((Object)new UnifyBillExpandInfo(WtcTimeRangeBtnTypeEnum.DAY.value, WtcTimeRangeBtnTypeEnum.DAY.value));
        return new VaAutoOperator(new UnifyBillInfoContext(Collections.singletonList(new UnifyBillApplyInitInfo((Object)0L, attFileBoId, Collections.singletonList(unifyBillApplyServiceEntryInitInfo))), applyAttr));
    }

    @Deprecated
    public VaAutoOperator getVaAutoOperator(List<DynamicObject> billDys, String attFileF7AuthEntity) {
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr("wtam", attFileF7AuthEntity);
        return this.getVaAutoOperator(billDys, applyAttr);
    }

    public VaAutoOperator getVaAutoOperator(List<DynamicObject> billDys, UnifyBillApplyAttr applyAttr) {
        ApplyBillCheckEnum checkEnum = ApplyBillCheckEnum.VACATION;
        ArrayList billInfos = Lists.newArrayListWithCapacity((int)billDys.size());
        for (DynamicObject billDy : billDys) {
            long attFileBoId = billDy.getLong("attfile.boid");
            DynamicObjectCollection entryEntities = billDy.getDynamicObjectCollection("entryentity");
            ArrayList entryInfos = Lists.newArrayListWithCapacity((int)entryEntities.size());
            for (DynamicObject dyObject : entryEntities) {
                Date startDate = dyObject.getDate(checkEnum.getStartDate());
                Date endDate = dyObject.getDate(checkEnum.getEndDate());
                long type = dyObject.getLong(checkEnum.getType() + "." + "id");
                String startMethod = dyObject.getString(checkEnum.getStartMethod());
                String endMethod = dyObject.getString(checkEnum.getEndMethod());
                UnifyBillApplyServiceEntryInitInfo unifyBillApplyServiceEntryInitInfo = new UnifyBillApplyServiceEntryInitInfo(startDate, endDate, type);
                unifyBillApplyServiceEntryInitInfo.setEntryId((Object)dyObject.getLong("id"));
                unifyBillApplyServiceEntryInitInfo.setExpandInfo((Object)new UnifyBillExpandInfo(startMethod, endMethod));
                entryInfos.add(unifyBillApplyServiceEntryInitInfo);
            }
            billInfos.add(new UnifyBillApplyInitInfo(billDy.getPkValue(), attFileBoId, (List)entryInfos));
        }
        UnifyBillInfoContext unifyBillInfoContext = new UnifyBillInfoContext((List)billInfos, applyAttr);
        return new VaAutoOperator(unifyBillInfoContext);
    }

    @Deprecated
    public Map<Long, String> getQuotaInfo(DynamicObject dataEntity, boolean isAll, DynamicObject parentDy, String attFileF7AuthEntity) {
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr("wtam", attFileF7AuthEntity);
        return this.getQuotaInfo(dataEntity, isAll, parentDy, applyAttr);
    }

    @Deprecated
    public Map<Long, String> getQuotaInfo(DynamicObject dataEntity, boolean isAll, DynamicObject billDy, UnifyBillApplyAttr applyAttr) {
        VaQuotaInfoVo vaQuotaInfoVo = new VaQuotaInfoVo().setBillId(billDy.getLong("id")).setParentBillId(billDy.getLong("parentid")).setUseDate(this.getUseVersionDate(dataEntity, ApplyBillCheckEnum.VACATIONFORM)).setAttPersonId(billDy.getLong("personid.id")).setVacationType(isAll ? 0L : dataEntity.getLong("vacationtype.id")).setAttFileVid(billDy.getLong("attfilebasef7.id")).setApplyAttr(applyAttr);
        vaQuotaInfoVo.setAttFileBoid(billDy.getLong("attfile.id"));
        vaQuotaInfoVo.setStartDate(dataEntity.getDate("startdate"));
        vaQuotaInfoVo.setEndDate(dataEntity.getDate("enddate"));
        return this.getQuotaInfo(vaQuotaInfoVo);
    }

    @Deprecated
    public Map<Long, String> getQuotaInfo(long attFileBoId, Date useDate, long typeId, long attFileVId, long personId, long billId, long parentBillId, String attFileF7AuthEntity) {
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr("wtam", attFileF7AuthEntity);
        return this.getQuotaInfo(attFileBoId, useDate, typeId, attFileVId, personId, billId, parentBillId, applyAttr);
    }

    @Deprecated
    public Map<Long, String> getQuotaInfo(long attFileBoId, Date useDate, long typeId, long attFileVId, long personId, long billId, long parentBillId, UnifyBillApplyAttr applyAttr) {
        Map<Long, Long> deductRuleVidMap = VaBaseService.getInstance().getDeductRuleVids((Long)attFileBoId, useDate, typeId, applyAttr);
        UsableQuotaQueryReq vaQuotaParam = VaBaseService.getInstance().getVaQuotaParam(billId, parentBillId, attFileBoId, attFileVId, personId, new ArrayList<Long>(deductRuleVidMap.values()));
        return VaBaseService.getInstance().getVaQuotasMap(vaQuotaParam, deductRuleVidMap);
    }

    @Deprecated
    public Map<Long, String> getQuotaInfo(VaQuotaInfoVo vaQuotaInfoVo) {
        Map<Long, Long> deductRuleVidMap = VaBaseService.getInstance().getDeductRuleVids((Long)vaQuotaInfoVo.getAttFileBoid(), vaQuotaInfoVo.getUseDate(), vaQuotaInfoVo.getVacationType(), vaQuotaInfoVo.getApplyAttr());
        UsableQuotaQueryReq vaQuotaParam = VaBaseService.getInstance().getVaQuotaParam(vaQuotaInfoVo.getBillId(), vaQuotaInfoVo.getParentBillId(), vaQuotaInfoVo.getAttFileBoid(), vaQuotaInfoVo.getAttFileVid(), vaQuotaInfoVo.getAttPersonId(), new ArrayList<Long>(deductRuleVidMap.values())).setStartDate(vaQuotaInfoVo.getStartDate()).setEndDate(vaQuotaInfoVo.getEndDate());
        return VaBaseService.getInstance().getVaQuotasMap(vaQuotaParam, deductRuleVidMap);
    }

    public Map<Long, VaQuotaResInfo> getVaTypeQuotaInfo(VaQuotaInfoVo vaQuotaInfoVo) {
        Map<Long, Long> deductRuleVidMap = VaBaseService.getInstance().getDeductRuleVids((Long)vaQuotaInfoVo.getAttFileBoid(), vaQuotaInfoVo.getUseDate(), vaQuotaInfoVo.getVacationType(), vaQuotaInfoVo.getApplyAttr());
        UsableQuotaQueryReq vaQuotaParam = VaBaseService.getInstance().getVaQuotaParam(vaQuotaInfoVo.getBillId(), vaQuotaInfoVo.getParentBillId(), vaQuotaInfoVo.getAttFileBoid(), vaQuotaInfoVo.getAttFileVid(), vaQuotaInfoVo.getAttPersonId(), new ArrayList<Long>(deductRuleVidMap.values())).setStartDate(vaQuotaInfoVo.getStartDate()).setEndDate(vaQuotaInfoVo.getEndDate());
        return VaBaseService.getInstance().getVaTypeQuotasMap(vaQuotaParam, deductRuleVidMap);
    }

    private Map<Long, String> getVaQuotasMap(UsableQuotaQueryReq usableQuotaQueryReq, Map<Long, Long> deductRuleVidMap) {
        Map<Long, VaQuotaResInfo> vaTypeQuotasMap = this.getVaTypeQuotasMap(usableQuotaQueryReq, deductRuleVidMap);
        if (WTCMaps.isNotEmpty(vaTypeQuotasMap)) {
            HashMap result = Maps.newHashMapWithExpectedSize((int)vaTypeQuotasMap.size());
            for (Map.Entry<Long, VaQuotaResInfo> vaQuotaResInfoEntry : vaTypeQuotasMap.entrySet()) {
                result.put(vaQuotaResInfoEntry.getKey(), vaQuotaResInfoEntry.getValue().getQuotaStr());
            }
            return result;
        }
        return Collections.emptyMap();
    }

    private Map<Long, VaQuotaResInfo> getVaTypeQuotasMap(UsableQuotaQueryReq usableQuotaQueryReq, Map<Long, Long> deductRuleVidMap) {
        List<UsableQuotaQueryResp> vaQuotaInfos = this.getVAQuotaInfos(Lists.newArrayList((Object[])new UsableQuotaQueryReq[]{usableQuotaQueryReq}));
        UsableQuotaQueryResp usableQuotaQueryResult = vaQuotaInfos.get(0);
        HashMap deductQuotaMap = Maps.newHashMapWithExpectedSize((int)usableQuotaQueryResult.getResult().size());
        for (UsableQuotaQueryResult quotaQueryResult : usableQuotaQueryResult.getResult()) {
            BigDecimal usable = BigDecimal.ZERO;
            if (quotaQueryResult.getUsable() != null) {
                usable = usable.add(quotaQueryResult.getUsable());
            }
            if (quotaQueryResult.getSrcBillUsed() != null) {
                usable = usable.add(quotaQueryResult.getSrcBillUsed());
            }
            if (quotaQueryResult.getSrcBillFrozen() != null) {
                usable = usable.add(quotaQueryResult.getSrcBillFrozen());
            }
            if (quotaQueryResult.getCanBeOverdraft() != null) {
                usable = usable.add(quotaQueryResult.getCanBeOverdraft());
            }
            String quotaStr = MessageFormat.format(WTCBaseKDString.getQuotaFmt(), usable.setScale(2, RoundingMode.HALF_UP).toPlainString() + BaseSetTimeUnitEnum.getLocalName((String)quotaQueryResult.getUnit()));
            VaQuotaResInfo vaTypeQuotaInfo = new VaQuotaResInfo(usable.setScale(2, RoundingMode.HALF_UP).toPlainString(), quotaQueryResult.getUnit(), BaseSetTimeUnitEnum.getLocalName((String)quotaQueryResult.getUnit()), quotaStr);
            deductQuotaMap.put(quotaQueryResult.getDeductionRuleId(), vaTypeQuotaInfo);
        }
        HashMap vaQuotasMaps = Maps.newHashMapWithExpectedSize((int)deductRuleVidMap.size());
        for (Map.Entry<Long, Long> entry : deductRuleVidMap.entrySet()) {
            VaQuotaResInfo vaTypeQuotaInfo = (VaQuotaResInfo)deductQuotaMap.get(entry.getValue());
            if (vaTypeQuotaInfo == null) continue;
            vaQuotasMaps.put(entry.getKey(), vaTypeQuotaInfo);
        }
        return vaQuotasMaps;
    }

    public List<UsableQuotaQueryResp> getVAQuotaInfos(List<UsableQuotaQueryReq> usableQuotaQueryReqs) {
        LOG.info("getVAQuotaInfos.params:{}", usableQuotaQueryReqs);
        List ret = VAQuotaHelper.handleQueryReq(usableQuotaQueryReqs);
        LOG.info("getVAQuotaInfos.result:{}", (Object)ret);
        return ret;
    }

    public String genEntryKey(long billId, int entrySeq) {
        return billId + "-" + entrySeq;
    }

    public void addOpFields(List<String> fieldKeys) {
        fieldKeys.add("isneedhand");
        fieldKeys.add("handperson");
        fieldKeys.add("handreason");
        fieldKeys.add("attfilebasef7");
        fieldKeys.add("entryentity");
        fieldKeys.add("vaplan");
        fieldKeys.add("personid");
        fieldKeys.add("entryentity.seq");
        fieldKeys.add("entryvabeset");
        fieldKeys.add("entryvacationtype");
        fieldKeys.add("entryvacationtype.name");
        fieldKeys.add("entrystartdate");
        fieldKeys.add("entryenddate");
        fieldKeys.add("owndate");
        fieldKeys.add("entryvatimehour");
        fieldKeys.add("entryvatimeday");
        fieldKeys.add("entryvalidtimehour");
        fieldKeys.add("entryvalidtimeday");
        fieldKeys.add("entryreason");
        fieldKeys.add("isreasonrequire");
        fieldKeys.add("vacationtypelist");
        fieldKeys.add("attfile");
        fieldKeys.add("attfile.boid");
        fieldKeys.add("unit");
        fieldKeys.add("applytime");
        fieldKeys.add("vatime");
        fieldKeys.add("startdatestr");
        fieldKeys.add("enddatestr");
        fieldKeys.add("startdate");
        fieldKeys.add("enddate");
        fieldKeys.add("parentid");
        fieldKeys.add("submitter");
        fieldKeys.add("submitdate");
        fieldKeys.add("isnotleave");
        fieldKeys.add("entryvatime");
        fieldKeys.add("entryapplytime");
        fieldKeys.add("entryunit");
        fieldKeys.add("entrystartmethod");
        fieldKeys.add("entryendmethod");
        fieldKeys.add("ischange");
        fieldKeys.add("ishavechange");
        fieldKeys.add("entryparentid");
        fieldKeys.add("specialvatype");
        fieldKeys.add("specialvamethod");
        fieldKeys.add("specialextjson");
        fieldKeys.add("vadetailentry");
        fieldKeys.add("vaentryid");
        fieldKeys.add("vaentrydate");
        fieldKeys.add("vaentrystarttime");
        fieldKeys.add("vaentryendtime");
        fieldKeys.add("vaentrydatetype");
        fieldKeys.add("vaentryapplytimeday");
        fieldKeys.add("vaentryapplytimehour");
        fieldKeys.add("vaentryunit");
        fieldKeys.add("vaentryseq");
        fieldKeys.add("applytyperadio");
        fieldKeys.add("isdisposable");
        fieldKeys.add("storageto");
        fieldKeys.add("mid");
    }

    @Deprecated
    public void invokeQuotaInterface(String operateKey, List<DynamicObject> billDys, VaAutoOperator vaAutoOperator, String attFileF7AuthEntity) {
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr("wtam", attFileF7AuthEntity);
        this.invokeQuotaInterface(operateKey, billDys, vaAutoOperator, applyAttr);
    }

    public void invokeQuotaInterface(String operateKey, List<DynamicObject> billDys, VaAutoOperator vaAutoOperator, UnifyBillApplyAttr applyAttr) {
        LOG.info("invokeQuotaInterface.params:{},{}", (Object)operateKey, billDys.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        if (vaAutoOperator == null && StringUtils.equalsAny((CharSequence)operateKey, (CharSequence[])new CharSequence[]{"submit", "unsubmit", "submiteffect"})) {
            vaAutoOperator = VaBaseService.getInstance().getVaAutoOperator(billDys, applyAttr);
        }
        switch (operateKey) {
            case "submit": {
                List<FrozenResult> frozenResults = this.freezeVAQuota(billDys, "FROZEN", vaAutoOperator);
                this.parseFResult(frozenResults, billDys, vaAutoOperator);
                break;
            }
            case "unsubmit": 
            case "wfauditnotpass": 
            case "wfrejecttosubmit": {
                this.freezeVAQuota(billDys, "UNFROZEN", vaAutoOperator);
                break;
            }
            case "submiteffect": {
                List<FrozenResult> frozenResults = this.freezeVAQuota(billDys, "FROZEN", vaAutoOperator);
                this.parseFResult(frozenResults, billDys, vaAutoOperator);
            }
            case "audit": {
                QTApplyReq qtApplyReq = this.genQuotaApplyReqs(billDys, "USE");
                this.sendBillIncrCalcMessage(qtApplyReq.getBillApplyList());
                LOG.info("VaBaseService.invokeQuotaInterface sendBillIncrCalcMessage end");
                break;
            }
        }
    }

    public List<BillResponse> invokeTryFrozenQuota(List<DynamicObject> billDys, VaAutoOperator vaAutoOperator, UnifyBillApplyAttr applyAttr) {
        LOG.info("invokeTryFrozenQuota.params:{}", billDys.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        if (vaAutoOperator == null) {
            vaAutoOperator = VaBaseService.getInstance().getVaAutoOperator(billDys, applyAttr);
        }
        List<FrozenResult> frozenResults = this.doFreezeVAQuota(billDys, "TRYFROZEN", vaAutoOperator);
        return this.parseTryFrozenResult(frozenResults, billDys, vaAutoOperator, applyAttr);
    }

    private void parseFResult(List<FrozenResult> frozenResults, List<DynamicObject> billDys, VaAutoOperator vaAutoOperator) {
        Map<Long, FrozenResult> collectFrozenResult = frozenResults.stream().collect(Collectors.toMap(FrozenResult::getId, res -> res));
        for (DynamicObject billDy : billDys) {
            FrozenResult frozenResult = collectFrozenResult.get(billDy.getLong("id"));
            List billFrozenResultList = frozenResult.getBillFrozenResultList();
            DynamicObjectCollection entryDyns = billDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryDyn : entryDyns) {
                Optional<BillApplyEntryFrozenResult> first = billFrozenResultList.stream().filter(res -> entryDyn.getLong("id") == res.getEntryId()).findFirst();
                if (!first.isPresent()) continue;
                BillApplyEntryFrozenResult entryFrozenResult = first.get();
                DynamicObject matchRule = this.getRuleCalDy(vaAutoOperator, billDy, entryDyn, ApplyBillCheckEnum.VACATION);
                BillResponse response = this.parseTryFrozenRes(billDy, entryFrozenResult, entryDyn.getDynamicObject("entryvacationtype"), matchRule, Lists.newArrayListWithCapacity((int)10));
                if (response.isSuccess()) continue;
                throw new KDBizException((String)response.getMessage().get(0));
            }
        }
    }

    private List<BillResponse> parseTryFrozenResult(List<FrozenResult> frozenResults, List<DynamicObject> billDys, VaAutoOperator vaAutoOperator, UnifyBillApplyAttr applyAttr) {
        Map<Long, FrozenResult> collectFrozenResult = frozenResults.stream().collect(Collectors.toMap(FrozenResult::getId, res -> res));
        List result = WTCCollections.modifiableList((Object[])new BillResponse[0]);
        VaCommonService vaCommonService = new VaCommonService();
        block0: for (int index = 0; index < billDys.size(); ++index) {
            DynamicObject billDy = billDys.get(index);
            FrozenResult frozenResult = collectFrozenResult.get(billDy.getLong("id"));
            if (frozenResult == null) {
                result.add(BillResponse.error((Object)billDy, (List)WTCCollections.modifiableList((Object[])new String[]{VaKDStringHelper.tryLockErr()})));
                continue;
            }
            String quotaExeptionDesc = this.getQuotaExeptionDesc(frozenResult);
            if (StringUtils.isNotEmpty((CharSequence)quotaExeptionDesc)) {
                BillResponse response = BillResponse.error((Object)billDy, (List)WTCCollections.modifiableList((Object[])new String[]{quotaExeptionDesc}));
                result.add(response);
                continue;
            }
            List billFrozenResultList = frozenResult.getBillFrozenResultList();
            DynamicObjectCollection entryDyns = billDy.getDynamicObjectCollection("entryentity");
            for (int entryIndex = 0; entryIndex < entryDyns.size(); ++entryIndex) {
                DynamicObject entryDyn = (DynamicObject)entryDyns.get(entryIndex);
                Optional<BillApplyEntryFrozenResult> first = billFrozenResultList.stream().filter(res -> entryDyn.getLong("id") == res.getEntryId()).findFirst();
                if (!first.isPresent()) continue;
                BillApplyEntryFrozenResult entryFrozenResult = first.get();
                DynamicObject matchRule = this.getRuleCalDy(vaAutoOperator, billDy, entryDyn, ApplyBillCheckEnum.VACATION);
                BillResponse response = this.parseTryFrozenRes(billDy, entryFrozenResult, entryDyn.getDynamicObject("entryvacationtype"), matchRule, Lists.newArrayListWithCapacity((int)10));
                if (response.isSuccess()) continue;
                if (BillSourceTypeEnum.IMPORT.equals((Object)applyAttr.getSourceType())) {
                    String message = vaCommonService.getMsg(entryDyns.size(), entryIndex, (String)response.getMessage().get(0));
                    response.setMessage(WTCCollections.modifiableList((Object[])new String[]{message}));
                }
                response.setData((Object)billDy);
                result.add(response);
                continue block0;
            }
        }
        return result;
    }

    public String getQuotaExeptionDesc(FrozenResult frozenResult) {
        String errcode = frozenResult.getErrCode();
        String errorMsg = "";
        if (StringUtils.isNotEmpty((CharSequence)errcode)) {
            if ("INSUFFICIENT_QUOTA".equals(errcode)) {
                errorMsg = ResManager.loadKDString((String)"\u5df2\u8d85\u51fa\u53ef\u7528\u65f6\u957f\u3002", (String)"VaBaseService_5", (String)"wtc-wtabm-business", (Object[])new Object[0]);
            } else if ("UN_COVER".equals(errcode)) {
                errorMsg = ResManager.loadKDString((String)"\u7533\u8bf7\u8303\u56f4\u5185\u65e0\u53ef\u7528\u989d\u5ea6\uff0c\u8bf7\u6838\u5bf9\u4e2a\u4eba\u4fe1\u606f\u662f\u5426\u66f4\u65b0\u6216\u8054\u7cfbHR\u8003\u52e4\u5458\u3002", (String)"VaBaseService_2", (String)"wtc-wtabm-business", (Object[])new Object[0]);
            } else if ("CONCURRENT_FAIL".equals(errcode)) {
                errorMsg = ResManager.loadKDString((String)"\u4eba\u5458\u6b63\u5728\u5b9a\u989d\u6838\u7b97\u4efb\u52a1\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"VaBaseService_3", (String)"wtc-wtabm-business", (Object[])new Object[0]);
            } else if ("GRADIENT_LIMIT".equals(errcode)) {
                Map errEntryRetData = frozenResult.getErrEntryRetData();
                BigDecimal gradientValue = (BigDecimal)errEntryRetData.get("gradientValue");
                gradientValue = gradientValue.setScale(2, RoundingMode.HALF_UP);
                Object gradientUnit = errEntryRetData.get("gradientUnit");
                String timeDesc = gradientValue + ApplyBillTimeUnitEnum.getDesc((String)QTOuterParamUtils.convert2OuterBillUnit((String)String.valueOf(gradientUnit)));
                String vaCationType = (String)errEntryRetData.get("vacationType");
                errorMsg = MessageFormat.format(ResManager.loadKDString((String)"{0}\u5bf9\u5e94\u7684\u5b9a\u989d\u6263\u51cf\u5761\u5ea6\u4e3a{1}\uff0c\u8bf7\u4fee\u6539\u7533\u8bf7\u65f6\u957f\u3002", (String)"VaBaseService_31", (String)"wtc-wtabm-business", (Object[])new Object[0]), vaCationType, timeDesc);
            } else {
                errorMsg = "LOCK_FROZEN".equals(errcode) ? ResManager.loadKDString((String)"\u539f\u5355\u5b9a\u989d\u6570\u636e\u672a\u66f4\u65b0\uff0c\u8bf7\u8054\u7cfbHR\u7ba1\u7406\u5458\u8fdb\u884c\u5b9a\u989d\u6838\u7b97\u540e\u518d\u8bd5\u3002", (String)"VaBaseService_6", (String)"wtc-wtabm-business", (Object[])new Object[0]) : ("LOCK_FAIL".equals(errcode) ? ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u4e0d\u80fd\u518d\u6b21\u53d8\u66f4\u3002", (String)"VaBaseService_7", (String)"wtc-wtabm-business", (Object[])new Object[0]) : MessageFormat.format(ResManager.loadKDString((String)"\u5b9a\u989d\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u5931\u8d25\u4ee3\u7801\uff1a{0}\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u6216\u8005\u8054\u7cfb\u7ba1\u7406\u5458\u540e\u518d\u8bd5\u3002", (String)"VaBaseService_0", (String)"wtc-wtabm-business", (Object[])new Object[0]), errcode));
            }
        }
        return errorMsg;
    }

    private List<FrozenResult> freezeVAQuota(List<DynamicObject> billDys, String frozenOp, VaAutoOperator vaAutoOperator) throws KDBizException {
        List<FrozenResult> frozenResults = this.doFreezeVAQuota(billDys, frozenOp, vaAutoOperator);
        for (FrozenResult frozenResult : frozenResults) {
            if (frozenResult.isSuccess()) continue;
            String quotaExeptionDesc = this.getQuotaExeptionDesc(frozenResult);
            quotaExeptionDesc = this.parseBatchQTMsg(vaAutoOperator, billDys, frozenResult, quotaExeptionDesc);
            throw new KDBizException(quotaExeptionDesc);
        }
        return frozenResults;
    }

    private String parseBatchQTMsg(VaAutoOperator vaAutoOperator, List<DynamicObject> billDys, FrozenResult frozenResult, String errMsg) {
        boolean isBatch;
        if (vaAutoOperator == null) {
            return errMsg;
        }
        UnifyBillInfoContext infoContext = vaAutoOperator.getInfoContext();
        if (infoContext == null) {
            return errMsg;
        }
        UnifyBillApplyAttr applyAttr = infoContext.getApplyAttr();
        if (applyAttr == null) {
            return errMsg;
        }
        boolean bl = isBatch = BillSourceTypeEnum.BATCH == applyAttr.getSourceType();
        if (!isBatch) {
            return errMsg;
        }
        long id = frozenResult.getId();
        Optional<DynamicObject> first = billDys.stream().filter(item -> item.getLong("id") == id).findFirst();
        if (first.isPresent()) {
            DynamicObject billDy = first.get();
            errMsg = BatchBillUnifyService.getInstance().handleBatchBillFailMsg(billDy, errMsg, BatchBillKDString.errorPrefix());
        }
        return errMsg;
    }

    private List<FrozenResult> doFreezeVAQuota(List<DynamicObject> billDys, String frozenOp, VaAutoOperator vaAutoOperator) {
        FrozenApplyReq frozenApplyReq = VaBaseService.getInstance().genQuotaFrozeReqs(billDys, frozenOp, vaAutoOperator);
        if (WTCCollections.isEmpty((Collection)frozenApplyReq.getBillApplyList())) {
            return Lists.newArrayListWithCapacity((int)2);
        }
        LOG.info("handleFrozenApplyReq.params:{}", (Object)frozenApplyReq);
        List frozenResults = VAQuotaHelper.handleFrozenApplyReq((FrozenApplyReq)frozenApplyReq);
        LOG.info("handleFrozenApplyReq.result:{}", (Object)frozenResults);
        return frozenResults;
    }

    public FrozenResult freezeVAQuota(DynamicObject billDy, String frozenOp, VaAutoOperator vaAutoOperator) {
        List<FrozenResult> frozenResults = this.doFreezeVAQuota(Lists.newArrayList((Object[])new DynamicObject[]{billDy}), frozenOp, vaAutoOperator);
        FrozenResult result = new FrozenResult();
        result.setFrozenResult("A");
        result.setId(billDy.getLong("id"));
        if (CollectionUtils.isNotEmpty(frozenResults)) {
            result = frozenResults.get(0);
        }
        return result;
    }

    @Deprecated
    public List<VaTypeSelectVo> getVaTypeSelectVos(List<VaTypeSelectVo> vaTypeSelectVos, long attFileBoid, DynamicObject dynamicObject, DynamicObject parentBillDyn, String attFileF7AuthEntity) {
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr("wtam", attFileF7AuthEntity);
        return this.getVaTypeSelectVos(vaTypeSelectVos, attFileBoid, dynamicObject, parentBillDyn, applyAttr);
    }

    public List<VaTypeSelectVo> getVaTypeSelectVos(List<VaTypeSelectVo> vaTypeSelectVos, long attFileBoid, DynamicObject dynamicObject, DynamicObject parentBillDyn, UnifyBillApplyAttr applyAttr) {
        long attFileVId = parentBillDyn == null ? 0L : parentBillDyn.getLong("attfilebasef7.id");
        long personId = parentBillDyn == null ? 0L : parentBillDyn.getLong("personid.id");
        long billId = parentBillDyn == null ? 0L : parentBillDyn.getLong("id");
        long parentBillId = parentBillDyn == null ? 0L : parentBillDyn.getLong("id");
        Date useDate = VaBaseService.getInstance().getUseVersionDate(dynamicObject, ApplyBillCheckEnum.VACATION);
        long typeId = 0L;
        Map<Long, Long> deductRuleVidMap = VaBaseService.getInstance().getDeductRuleVids((Long)attFileBoid, useDate, typeId, applyAttr);
        Map<Object, Object> resultMap = Maps.newHashMap();
        if (MapUtils.isNotEmpty(deductRuleVidMap)) {
            UsableQuotaQueryReq vaQuotaParam = VaBaseService.getInstance().getVaQuotaParam(billId, parentBillId, attFileBoid, attFileVId, personId, new ArrayList<Long>(deductRuleVidMap.values())).setStartDate(dynamicObject.getDate("entrystartdate")).setEndDate(dynamicObject.getDate("entryenddate"));
            List<UsableQuotaQueryResp> vaQuotaInfos = this.getVAQuotaInfos(Lists.newArrayList((Object[])new UsableQuotaQueryReq[]{vaQuotaParam}));
            UsableQuotaQueryResp usableQuotaQueryResult = vaQuotaInfos.get(0);
            List result = usableQuotaQueryResult.getResult();
            resultMap = result.stream().collect(Collectors.toMap(UsableQuotaQueryResult::getDeductionRuleId, quotaRes -> quotaRes, (r1, r2) -> r1));
        }
        for (VaTypeSelectVo typeSelectVo : vaTypeSelectVos) {
            UsableQuotaQueryResult quotaQueryResult;
            Long deductionId = deductRuleVidMap.get(typeSelectVo.getVaTypeId());
            if (deductionId == null || (quotaQueryResult = (UsableQuotaQueryResult)resultMap.get(deductionId)) == null) continue;
            BigDecimal usable = BigDecimal.ZERO;
            if (quotaQueryResult.getUsable() != null) {
                usable = usable.add(quotaQueryResult.getUsable());
            }
            if (quotaQueryResult.getSrcBillUsed() != null) {
                usable = usable.add(quotaQueryResult.getSrcBillUsed());
            }
            if (quotaQueryResult.getSrcBillFrozen() != null) {
                usable = usable.add(quotaQueryResult.getSrcBillFrozen());
            }
            if (quotaQueryResult.getCanBeOverdraft() != null) {
                usable = usable.add(quotaQueryResult.getCanBeOverdraft());
            }
            typeSelectVo.setRemainTime(usable);
            typeSelectVo.setRemainUnit(quotaQueryResult.getUnit());
            typeSelectVo.setDeduction(true);
        }
        return vaTypeSelectVos;
    }

    @Deprecated
    public Map<Long, UsableQuotaQueryResult> getVaTypeSelectVos(long attFileBoid, DynamicObject billDyn, long parentBillId, String attFileF7AuthEntity) {
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr("wtam", attFileF7AuthEntity);
        return this.getVaTypeSelectVos(attFileBoid, billDyn, parentBillId, applyAttr);
    }

    public Map<Long, UsableQuotaQueryResult> getVaTypeSelectVos(long attFileBoid, DynamicObject billDyn, long parentBillId, UnifyBillApplyAttr applyAttr) {
        long attFileVId = billDyn == null ? 0L : billDyn.getLong("attfilebasef7.id");
        long personId = billDyn == null ? 0L : billDyn.getLong("personid.id");
        long billId = billDyn == null ? 0L : billDyn.getLong("id");
        DynamicObjectCollection entryEntities = billDyn == null ? new DynamicObjectCollection() : billDyn.getDynamicObjectCollection("entryentity");
        ArrayList request = Lists.newArrayList();
        HashMap<Long, Long> deductRuleVidMap = new HashMap<Long, Long>(16);
        for (DynamicObject entryDyn : entryEntities) {
            Date useDate = VaBaseService.getInstance().getUseVersionDate(entryDyn, ApplyBillCheckEnum.VACATION);
            long typeId = entryDyn.getLong("entryvacationtype.id");
            Map<Long, Long> deductRuleVids = VaBaseService.getInstance().getDeductRuleVids((Long)attFileBoid, useDate, typeId, applyAttr);
            deductRuleVidMap.putAll(deductRuleVids);
            UsableQuotaQueryReq vaQuotaParam = VaBaseService.getInstance().getVaQuotaParam(billId, parentBillId, attFileBoid, attFileVId, personId, Lists.newArrayList(deductRuleVids.values()));
            vaQuotaParam.setStartDate(entryDyn.getDate("entrystartdate"));
            vaQuotaParam.setEndDate(entryDyn.getDate("entryenddate"));
            request.add(vaQuotaParam);
        }
        List<Object> result = Lists.newArrayList();
        if (MapUtils.isNotEmpty(deductRuleVidMap)) {
            List<UsableQuotaQueryResp> vaQuotaInfos = this.getVAQuotaInfos(request);
            result = vaQuotaInfos.stream().map(UsableQuotaQueryResp::getResult).flatMap(Collection::stream).collect(Collectors.toList());
        }
        HashMap<Long, UsableQuotaQueryResult> resultMap = new HashMap<Long, UsableQuotaQueryResult>(deductRuleVidMap.size());
        Map<Long, UsableQuotaQueryResult> deductionResMap = result.stream().collect(Collectors.toMap(UsableQuotaQueryResult::getDeductionRuleId, quotaRes -> quotaRes, (r1, r2) -> r1));
        deductRuleVidMap.forEach((vaTypeId, deductionRuleId) -> resultMap.put((Long)vaTypeId, (UsableQuotaQueryResult)deductionResMap.get(deductionRuleId)));
        return resultMap;
    }

    public void sendBillIncrCalcMessage(List<BillApply> billApplyList) {
        ArrayList calcList;
        LOG.info("incrCalc.scene=sendMessage,billApplyList={}", billApplyList);
        List<Object> list2 = calcList = CollectionUtils.isEmpty(billApplyList) ? Lists.newArrayList() : billApplyList.stream().filter(list -> CollectionUtils.isNotEmpty((Collection)list.getEntryEntities())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty((Collection)calcList)) {
            BillApply billApply = null;
            try (MessagePublisher mp = null;){
                mp = MQFactory.get().createSimplePublisher("wtc", "wtc_bill_incr_calc_queue");
                Iterator iterator = calcList.iterator();
                while (iterator.hasNext()) {
                    BillApply apply;
                    billApply = apply = (BillApply)iterator.next();
                    LOG.info("incrCalc.billNo={},billId={},scene=sendMessage,billApply={}", new Object[]{billApply.getBillNo(), billApply.getId(), billApply});
                    mp.publishInDbTranscation("wtc", (Object)billApply);
                }
            }
        }
    }

    @Deprecated
    public BillResponse parseTryFrozenRes(BillApplyEntryFrozenResult entryFrozenResult, DynamicObject vaTypeDyn, DynamicObject matchRule, List<VaNonQtApplyCache> cacheVos) {
        return this.parseTryFrozenRes(null, entryFrozenResult, vaTypeDyn, matchRule, cacheVos);
    }

    public BillResponse parseTryFrozenRes(DynamicObject billDyn, BillApplyEntryFrozenResult entryFrozenResult, DynamicObject vaTypeDyn, DynamicObject matchRule, List<VaNonQtApplyCache> cacheVos) {
        boolean isQuota = matchRule.getBoolean("isquota");
        boolean isNonQuotaApply = matchRule.getBoolean("isnonquotaapply");
        boolean isSplit = matchRule.getBoolean("issplit");
        boolean isDisposable = matchRule.getBoolean("isdisposable");
        long deductRuleId = matchRule.getLong("deductrule.id");
        String vaTypeName = "";
        if (vaTypeDyn.containsProperty("name")) {
            vaTypeName = vaTypeDyn.getString("name");
        } else {
            LOG.warn("\u3010\u51bb\u7ed3/\u8bd5\u51bb\u7ed3\u3011vaTypeDyn\u65e0name\u5c5e\u6027\uff0c\u8bf7\u68c0\u67e5!\uff1a{}", vaTypeDyn.getPkValue());
        }
        String applierName = ResManager.loadKDString((String)"\u7533\u8bf7\u4eba", (String)"VaInfoService_10", (String)"wtc-wtabm-business", (Object[])new Object[0]);
        if (billDyn != null && "0".equals(billDyn.getString("applytyperadio"))) {
            applierName = ResManager.loadKDString((String)"\u4f60", (String)"VaInfoService_11", (String)"wtc-wtabm-business", (Object[])new Object[0]);
        }
        if (!isQuota) {
            List quotaInfoList = entryFrozenResult.getQuotaInfoList();
            if (CollectionUtils.isNotEmpty((Collection)quotaInfoList)) {
                quotaInfoList = quotaInfoList.stream().filter(qtInfo -> qtInfo.getActualCanBeUseValue().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
            }
            if (CollectionUtils.isNotEmpty((Collection)quotaInfoList)) {
                String quotaTypeDesc = this.parseAffluentQtInfos(quotaInfoList);
                ArrayList responseMsgs = Lists.newArrayListWithCapacity((int)10);
                if (isNonQuotaApply) {
                    String msg = MessageFormat.format(ResManager.loadKDString((String)"{0}\u5f53\u524d\u6709{1}\u8bf7\u4f18\u5148\u7533\u8bf7\u989d\u5ea6\u5047\u3002\u65e0\u53ef\u7528\u989d\u5ea6\u65f6\uff0c\u53ef\u7533\u8bf7{2}\u3002", (String)"VaInfoService_6", (String)"wtc-wtabm-business", (Object[])new Object[0]), applierName, quotaTypeDesc, vaTypeName);
                    responseMsgs.add(msg);
                } else {
                    String msg = MessageFormat.format(ResManager.loadKDString((String)"{0}\u5f53\u524d\u6709{1}\u8bf7\u5206\u5f00\u7533\u8bf7\u3002", (String)"VaInfoService_7", (String)"wtc-wtabm-business", (Object[])new Object[0]), applierName, quotaTypeDesc);
                    Optional<VaNonQtApplyCache> first = cacheVos.stream().filter(cacheVo -> cacheVo.getDeductRuleId() == deductRuleId && cacheVo.getVaTypeId() == vaTypeDyn.getLong("id")).findFirst();
                    if (!first.isPresent()) {
                        responseMsgs.add(msg);
                        cacheVos.add(new VaNonQtApplyCache(deductRuleId, vaTypeDyn.getLong("id")));
                    }
                }
                return new BillResponse(!isNonQuotaApply, (List)responseMsgs, (Object)"");
            }
        } else {
            String quotaEntryDesc;
            Map<Long, List<FrozenQTInfo>> groupedFrozenQtInfo;
            List frozenQTInfoList;
            if (isSplit && CollectionUtils.isNotEmpty((Collection)(frozenQTInfoList = entryFrozenResult.getFrozenQTInfoList())) && (groupedFrozenQtInfo = frozenQTInfoList.stream().filter(qtInfo -> qtInfo.getApplyFromPool() != null && qtInfo.getApplyFromPool().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.groupingBy(FrozenQTInfo::getQtTypeId))).size() > 1) {
                List beforeQuotaList = entryFrozenResult.getEntryBeforeQuotaInfoList();
                String msg = this.parseQtSplitInfos(applierName, beforeQuotaList, groupedFrozenQtInfo);
                return BillResponse.error((Object)"", (List)Lists.newArrayList((Object[])new String[]{msg}));
            }
            if (isDisposable && StringUtils.isNotEmpty((CharSequence)(quotaEntryDesc = this.getQuotaEntryDesc(entryFrozenResult, vaTypeName)))) {
                return BillResponse.success((Object)"", (List)Lists.newArrayList((Object[])new String[]{quotaEntryDesc}));
            }
        }
        return BillResponse.success();
    }

    private String parseQtSplitInfos(String applierName, List<AffluentUsableQuotaInfo> beforeQuotaList, Map<Long, List<FrozenQTInfo>> groupedFrozenQtInfo) {
        StringBuilder quotaMsgbuilder = new StringBuilder();
        Map<Long, List<AffluentUsableQuotaInfo>> groupedBeforeQtInfo = beforeQuotaList.stream().collect(Collectors.groupingBy(UsableQuotaInfo::getQtTypeId));
        ArrayList qtTypeIds = Lists.newArrayList(groupedFrozenQtInfo.keySet());
        List qtDyns = QTService.queryQtType((List)qtTypeIds);
        Map<Long, DynamicObject> qtDynMap = qtDyns.stream().collect(Collectors.toMap(qtDyn -> qtDyn.getLong("id"), dyn -> dyn));
        for (int idx = 0; idx < qtTypeIds.size(); ++idx) {
            Long qtTypeId = (Long)qtTypeIds.get(idx);
            DynamicObject qtDyn2 = qtDynMap.get(qtTypeId);
            String unit = "";
            BigDecimal sum = BigDecimal.ZERO;
            List<AffluentUsableQuotaInfo> qtInfos = groupedBeforeQtInfo.get(qtTypeId);
            if (CollectionUtils.isNotEmpty(qtInfos)) {
                for (AffluentUsableQuotaInfo qtInfo : qtInfos) {
                    sum = sum.add(qtInfo.getActualCanBeUseValue()).add(qtInfo.getCanBeOdValue());
                    unit = qtInfo.getUnit();
                }
            }
            sum = sum.setScale(2, RoundingMode.HALF_UP);
            quotaMsgbuilder.append(qtDyn2.getString("name")).append(sum);
            quotaMsgbuilder.append(ApplyBillTimeUnitEnum.getDesc((String)unit));
            quotaMsgbuilder.append(WTCSymbolMultiLanguageUtil.getCommonSymbol());
        }
        return ResManager.loadKDString((String)"{0}\u5f53\u524d\u6709{1}\u8bf7\u5206\u5f00\u7533\u8bf7\u3002", (String)"VaInfoService_8", (String)"wtc-wtabm-business", (Object[])new Object[]{applierName, quotaMsgbuilder.toString()});
    }

    private String getQuotaEntryDesc(BillApplyEntryFrozenResult billFrozenResult, String vaTypeName) {
        String errorMsg = "";
        String tipsMsg = "";
        List warnEventList = billFrozenResult.getWarnEventList();
        if (CollectionUtils.isNotEmpty((Collection)warnEventList)) {
            for (QTWarnEvent qtWarnEvent : warnEventList) {
                if (!QTWarnEvent.disposableExtraFreeze.equals((Object)qtWarnEvent)) continue;
                tipsMsg = MessageFormat.format(ResManager.loadKDString((String)"{0}\u4e3a\u4e00\u6b21\u6027\u5047\u671f\uff0c\u5efa\u8bae\u4e00\u6b21\u6027\u4f11\u5b8c\uff0c\u82e5\u672a\u4f11\u5b8c\uff0c\u5269\u4f59\u989d\u5ea6\u5c06\u81ea\u52a8\u5931\u6548\u3002", (String)"VaBaseService_4", (String)"wtc-wtabm-business", (Object[])new Object[0]), vaTypeName);
                break;
            }
        }
        if (StringUtils.isEmpty((CharSequence)errorMsg)) {
            errorMsg = tipsMsg;
        }
        return errorMsg;
    }

    private String parseAffluentQtInfos(List<AffluentUsableQuotaInfo> quotaInfoList) {
        List qtTypeIds = quotaInfoList.stream().map(UsableQuotaInfo::getQtTypeId).collect(Collectors.toList());
        List qtDyns = QTService.queryQtType(qtTypeIds);
        Map<Long, DynamicObject> qtDynMap = qtDyns.stream().collect(Collectors.toMap(qtDyn -> qtDyn.getLong("id"), dyn -> dyn));
        Map<Long, List<AffluentUsableQuotaInfo>> groupedQuotaInfo = quotaInfoList.stream().collect(Collectors.groupingBy(UsableQuotaInfo::getQtTypeId));
        StringBuilder result = new StringBuilder();
        groupedQuotaInfo.forEach((qtTypeId, qtInfos) -> {
            BigDecimal sum = BigDecimal.ZERO;
            String unit = null;
            for (AffluentUsableQuotaInfo qtInfo : qtInfos) {
                sum = sum.add(qtInfo.getActualCanBeUseValue());
                unit = qtInfo.getUnit();
            }
            sum = sum.setScale(2, RoundingMode.HALF_UP);
            DynamicObject qtTypeDyn = (DynamicObject)qtDynMap.get(qtTypeId);
            result.append(qtTypeDyn.getString("name")).append(sum).append(ApplyBillTimeUnitEnum.getDesc((String)unit));
            result.append(WTCSymbolMultiLanguageUtil.getCommonSymbol());
        });
        return result.toString();
    }
}

