/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.business.vaapply;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtabm.business.helper.vaplan.VaPlanRuleQuery;
import kd.sdk.wtc.wtabm.business.helper.vaplan.VaPlanRuleResp;
import kd.wtc.wtabm.business.bo.VaRepeatExtensionParam;
import kd.wtc.wtabm.business.vaapply.BreastfeedingLeaveService;
import kd.wtc.wtabm.business.vaapply.VaApplyQueryService;
import kd.wtc.wtabm.business.vaapply.VaKDStringHelper;
import kd.wtc.wtabm.business.vaplan.VaPlanQueryService;
import kd.wtc.wtabm.common.constants.batch.BatchVaKDString;
import kd.wtc.wtabm.common.entity.vaapply.VaRepeatParam;
import kd.wtc.wtabm.common.entity.vaapply.VaRepeatParseVo;
import kd.wtc.wtbs.business.util.ApplyUtil;
import kd.wtc.wtbs.business.util.ShiftParseUtil;
import kd.wtc.wtbs.business.web.applybill.commonhelper.UnifyBillCommonHelper;
import kd.wtc.wtbs.business.web.applybill.operatecore.va.VaAutoOperator;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.enums.bill.unify.BillSourceTypeEnum;
import kd.wtc.wtbs.common.enums.bill.va.SpecialVaTypeEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.model.bill.BillFailInfo;
import kd.wtc.wtbs.common.model.bill.BillVo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.model.bill.va.VaBillEntryEntityVo;
import kd.wtc.wtbs.common.model.bill.va.VaBillSubEntryVo;
import kd.wtc.wtbs.common.model.bill.va.VaBillVo;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.DateUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class VaBillRepeatService {
    private static final Log LOG = LogFactory.getLog(VaBillRepeatService.class);
    private boolean isBatchVa = false;

    @Deprecated
    public BillFailInfo checkStagingBillRepeat(VaRepeatParam repeatParam) {
        return new BillFailInfo((Map)Maps.newHashMapWithExpectedSize((int)16));
    }

    @Deprecated
    public BillFailInfo checkHisBillRepeat(VaRepeatParam repeatParam) {
        return new BillFailInfo((Map)Maps.newHashMapWithExpectedSize((int)16));
    }

    public BillFailInfo checkStagingBillRepeat(VaRepeatExtensionParam repeatParam) {
        BillFailInfo billFailInfo;
        List<VaBillVo> curVaBillVos;
        this.isBatchVa = BillSourceTypeEnum.BATCH == repeatParam.getBillSourceType();
        BillFailInfo bilLFailInfo = new BillFailInfo((Map)Maps.newHashMapWithExpectedSize((int)16));
        List<DynamicObject> dyList = repeatParam.getDyList();
        if (WTCCollections.isEmpty(dyList = dyList.stream().filter(dy -> !dy.getBoolean("isnotleave")).collect(Collectors.toList()))) {
            return bilLFailInfo;
        }
        ArrayList<DynamicObject> leaveBills = new ArrayList();
        if (this.isBatchVa && WTCCollections.isNotEmpty((Collection)repeatParam.getExpandBillDys()) && WTCCollections.isEmpty(leaveBills = repeatParam.getExpandBillDys().stream().filter(dy -> !dy.getBoolean("isnotleave")).collect(Collectors.toList()))) {
            return bilLFailInfo;
        }
        int entrySize = 0;
        for (DynamicObject dyObject : dyList) {
            DynamicObjectCollection entries = dyObject.getDynamicObjectCollection("entryentity");
            entrySize += entries.size();
        }
        long[] ids = DB.genGlobalLongIds((int)entrySize);
        int index = 0;
        for (DynamicObject dyObject : dyList) {
            DynamicObjectCollection entries = dyObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                if (entry.getLong("id") != 0L) continue;
                entry.set("id", (Object)ids[index]);
                ++index;
            }
        }
        VaApplyQueryService queryService = new VaApplyQueryService();
        List<VaBillVo> targetVaBillVos = curVaBillVos = queryService.convertTo(dyList, Maps.newHashMap());
        if (BillSourceTypeEnum.BATCH == repeatParam.getBillSourceType() && WTCCollections.isNotEmpty(leaveBills)) {
            targetVaBillVos = queryService.convertTo(leaveBills, Maps.newHashMap());
        }
        try {
            billFailInfo = this.checkRepeat(curVaBillVos, targetVaBillVos, true, repeatParam);
        }
        catch (Exception ex) {
            LOG.warn("\u5f53\u524d\u5355\u636e\u95f4\u5224\u5b9a\u91cd\u53e0\u53d1\u751f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)ex);
            billFailInfo = new BillFailInfo((Map)Maps.newHashMapWithExpectedSize((int)16));
            String errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5355\u6bd4\u8f83\u65f6\u6bb5\u91cd\u53e0\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VaBillRepeatService_1", (String)"wtc-wtabm-business", (Object[])new Object[0]);
            if (ex.getClass().isAssignableFrom(KDException.class)) {
                errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5355\u6bd4\u8f83\u65f6\u6bb5\u91cd\u53e0\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002\u5931\u8d25\u4fe1\u606f\uff1a{}", (String)"VaBillRepeatService_2", (String)"wtc-wtabm-business", (Object[])new Object[]{ex.getMessage()});
            }
            for (VaBillVo curVaBillVo : curVaBillVos) {
                billFailInfo.getErrorInfos().put(curVaBillVo.getId(), errMsg);
            }
        }
        return billFailInfo;
    }

    public BillFailInfo checkHisBillRepeat(VaRepeatExtensionParam repeatParam) {
        this.isBatchVa = BillSourceTypeEnum.BATCH == repeatParam.getBillSourceType();
        BillFailInfo billFailInfo = new BillFailInfo((Map)Maps.newHashMapWithExpectedSize((int)16));
        List<DynamicObject> dyList = repeatParam.getDyList();
        if (WTCCollections.isEmpty((Collection)repeatParam.getDyList())) {
            return billFailInfo;
        }
        if (WTCCollections.isEmpty(dyList = dyList.stream().filter(dy -> !dy.getBoolean("isnotleave")).collect(Collectors.toList()))) {
            return billFailInfo;
        }
        VaApplyQueryService queryService = new VaApplyQueryService();
        List<VaBillVo> curVaBillVos = queryService.convertTo(dyList, Maps.newHashMap());
        List<Object> hisVaBillVos = queryService.queryHisBillForVa(dyList);
        if (this.isBatchVa) {
            hisVaBillVos = hisVaBillVos.stream().filter(dy -> dy.getMid() == 0L || repeatParam.getBatchParentId() != dy.getMid()).collect(Collectors.toList());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u3010\u4f11\u5047\u5355\u91cd\u53e0\u6821\u9a8c\u3011\u5224\u5b9a\u5f53\u524d\u63d0\u4ea4\u5355\u636e\u548c\u5386\u53f2\u5355\u636e\u662f\u5426\u6709\u91cd\u53e0\uff0c curVaBillVos\uff1a{}\uff0c  hisVaBillVos:{}", curVaBillVos, hisVaBillVos);
        }
        try {
            return this.checkRepeat(curVaBillVos, hisVaBillVos, false, repeatParam);
        }
        catch (Exception ex) {
            LOG.warn("\u5f53\u524d\u5355\u636e\u548c\u5386\u53f2\u5355\u636e\u5224\u5b9a\u91cd\u53e0\u53d1\u751f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)ex);
            billFailInfo = new BillFailInfo((Map)Maps.newHashMapWithExpectedSize((int)16));
            String errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5355\u6bd4\u8f83\u65f6\u6bb5\u91cd\u53e0\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VaBillRepeatService_1", (String)"wtc-wtabm-business", (Object[])new Object[0]);
            if (ex.getClass().isAssignableFrom(KDException.class)) {
                errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5355\u6bd4\u8f83\u65f6\u6bb5\u91cd\u53e0\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002\u5931\u8d25\u4fe1\u606f\uff1a{}", (String)"VaBillRepeatService_2", (String)"wtc-wtabm-business", (Object[])new Object[]{ex.getMessage()});
            }
            for (VaBillVo curVaBillVo : curVaBillVos) {
                billFailInfo.getErrorInfos().put(curVaBillVo.getId(), errMsg);
            }
            return billFailInfo;
        }
    }

    private BillFailInfo checkRepeat(List<VaBillVo> curVaBillVos, List<VaBillVo> targetVaBillVos, boolean isCurr, VaRepeatExtensionParam repeatParam) {
        VaAutoOperator vaAutoOperator = repeatParam.getVaAutoOperator();
        ArrayList allVaBillVos = Lists.newArrayList(curVaBillVos);
        BillFailInfo billFailInfo = new BillFailInfo((Map)Maps.newHashMapWithExpectedSize((int)16));
        if (!CollectionUtils.isNotEmpty(targetVaBillVos)) {
            return billFailInfo;
        }
        allVaBillVos.addAll(targetVaBillVos);
        VaRepeatParseVo vaRepeatParseVo = this.parseVaBill(allVaBillVos);
        List needShiftAttFileBoIds = vaRepeatParseVo.getAttFileBoIds();
        DutyShiftResponse shiftInfo = null;
        if (CollectionUtils.isNotEmpty((Collection)needShiftAttFileBoIds)) {
            shiftInfo = this.getShiftInfo(needShiftAttFileBoIds, vaRepeatParseVo.getStartDate(), vaRepeatParseVo.getEndDate());
        }
        Map<Long, List<VaBillVo>> curBillPersonGroup = curVaBillVos.stream().collect(Collectors.groupingBy(dy -> dy.getAttPersonId()));
        Map<Long, List<VaBillVo>> targetBillPersonGroup = targetVaBillVos.stream().collect(Collectors.groupingBy(dy -> dy.getAttPersonId()));
        boolean isImport = false;
        UnifyBillApplyAttr billApplyAttr = repeatParam.getBillApplyAttr();
        if (billApplyAttr != null) {
            isImport = billApplyAttr.getSourceType() == BillSourceTypeEnum.IMPORT;
        }
        Map<Long, DynamicObject> targetBaseSetDyMap = WTCCollections.modifiableEmptyMap();
        if (vaAutoOperator == null) {
            targetBaseSetDyMap = this.getTargetBaseSetDyMap(allVaBillVos, repeatParam.isUseStartOrEnd());
        } else if (!isCurr) {
            targetBaseSetDyMap = this.getTargetBaseSetDyMap(targetVaBillVos, repeatParam.isUseStartOrEnd());
        }
        block0: for (Map.Entry<Long, List<VaBillVo>> personGroupEntry : curBillPersonGroup.entrySet()) {
            List<VaBillVo> vaBillVoPersons = personGroupEntry.getValue();
            List<VaBillVo> targetVaBillVoPersons = targetBillPersonGroup.get(personGroupEntry.getKey());
            if (CollectionUtils.isEmpty(targetVaBillVoPersons)) continue;
            block1: for (VaBillVo vaBillVoPerson : vaBillVoPersons) {
                LinkedList targetEntryList = new LinkedList();
                for (VaBillVo targetVaBillVoPerson : targetVaBillVoPersons) {
                    if (vaBillVoPerson.getParentId() == targetVaBillVoPerson.getId() && vaBillVoPerson.getParentId() != 0L) continue;
                    if (vaBillVoPerson.getId() == targetVaBillVoPerson.getId()) {
                        targetEntryList.addAll(0, vaBillVoPerson.getEntryEntities());
                        continue;
                    }
                    targetEntryList.addAll(targetVaBillVoPerson.getEntryEntities());
                }
                if (CollectionUtils.isEmpty(targetEntryList)) continue block0;
                for (VaBillEntryEntityVo entryEntity : vaBillVoPerson.getEntryEntities()) {
                    for (VaBillEntryEntityVo targetEntryVo : targetEntryList) {
                        boolean repeat;
                        boolean needCheckRepeat = this.judgeNeedCheckRepeat(entryEntity, targetEntryVo, repeatParam, vaAutoOperator, isCurr, targetBaseSetDyMap);
                        if (!needCheckRepeat || !(repeat = !this.anyCustom(entryEntity, targetEntryVo) ? this.checkRepeatWithSchedule(entryEntity, targetEntryVo) : this.repeatWithTime(entryEntity, targetEntryVo, shiftInfo))) continue;
                        this.appendFailInfos(billFailInfo, vaBillVoPerson.getId(), this.repeatMessageResp(vaBillVoPerson, entryEntity, targetEntryVo, isCurr, isImport));
                        continue block1;
                    }
                }
            }
        }
        return billFailInfo;
    }

    private Map<Long, DynamicObject> getTargetBaseSetDyMap(List<VaBillVo> targetVaBillVos, boolean useStartOrEnd) {
        Map result = WTCCollections.modifiableEmptyMap();
        List vaPlanRuleQueryList = WTCCollections.modifiableEmptyList();
        Date minStart = null;
        Date maxEnd = null;
        List breastEntryEntities = WTCCollections.modifiableListWithCap((int)10);
        for (VaBillVo targetPersonVaBill : targetVaBillVos) {
            List entryEntities = targetPersonVaBill.getEntryEntities();
            for (VaBillEntryEntityVo entryEntity : entryEntities) {
                if (!WTCStringUtils.equals((String)SpecialVaTypeEnum.LACTATION_TYPE.vaType, (String)entryEntity.getSpecialVaType())) continue;
                breastEntryEntities.add(entryEntity);
                Date targetDate = useStartOrEnd ? entryEntity.getStartDate() : entryEntity.getEndDate();
                vaPlanRuleQueryList.add(new VaPlanRuleQuery(targetPersonVaBill.getAttFileBoId(), targetDate, Long.valueOf(entryEntity.getVaTypeId()), null, null, 0));
                if (minStart == null || minStart.after(targetDate)) {
                    minStart = targetDate;
                }
                if (maxEnd != null && !maxEnd.before(targetDate)) continue;
                maxEnd = targetDate;
            }
        }
        VaPlanQueryService queryService = new VaPlanQueryService();
        List<VaPlanRuleResp> vaPlanAndRules = queryService.getVaPlanAndRule(vaPlanRuleQueryList);
        Set baseSetIds = WTCCollections.modifiableEmptySet();
        for (VaPlanRuleResp vaPlanAndRule : vaPlanAndRules) {
            baseSetIds.addAll(vaPlanAndRule.getRuleCalDys().stream().map(dy -> dy.getLong("vabasesetid.id")).collect(Collectors.toList()));
        }
        DynamicObject[] allSeqHisDys = new DynamicObject[]{};
        if (minStart != null && maxEnd != null) {
            allSeqHisDys = UnifyBillCommonHelper.getAllSeqHisDys((String)"wtp_vabaseset", minStart, maxEnd, (Set)baseSetIds);
        }
        Map<Long, List<DynamicObject>> seqHisDyBoIdMap = Arrays.stream(allSeqHisDys).collect(Collectors.groupingBy(hisDy -> hisDy.getLong("boid")));
        int index = 0;
        for (VaBillEntryEntityVo entryEntity : breastEntryEntities) {
            VaPlanRuleResp vaPlanRuleResp;
            Optional<DynamicObject> first;
            if (!(first = (vaPlanRuleResp = vaPlanAndRules.get(index++)).getRuleCalDys().stream().filter(ruleCalDy -> entryEntity.getVaTypeId() == ruleCalDy.getLong("vatype.id")).findFirst()).isPresent()) continue;
            DynamicObject ruleCalDy2 = first.get();
            Date targetDate = useStartOrEnd ? entryEntity.getStartDate() : entryEntity.getEndDate();
            DynamicObject baseSetHisDy = UnifyBillCommonHelper.getSeqHisDyByDate((Object)ruleCalDy2.getLong("vabasesetid.id"), (Date)targetDate, seqHisDyBoIdMap.get(ruleCalDy2.getLong("vabasesetid.id")));
            result.put(entryEntity.getId(), baseSetHisDy);
        }
        return result;
    }

    private boolean judgeNeedCheckRepeat(VaBillEntryEntityVo src, VaBillEntryEntityVo target, VaRepeatParam repeatParam, VaAutoOperator vaAutoOperator, boolean isCurr, Map<Long, DynamicObject> targetBaseSetDyMap) {
        DynamicObjectCollection srcVaTypeEntries;
        long targetVaTypeId;
        if (src.getId() == target.getId()) {
            return false;
        }
        long srcVaTypeId = src.getVaTypeId();
        if (srcVaTypeId == (targetVaTypeId = target.getVaTypeId())) {
            return true;
        }
        Set needNotCheckedRepeatVaTypes = repeatParam.getNeedNotCheckedRepeatVaTypes();
        if (WTCCollections.isNotEmpty((Collection)needNotCheckedRepeatVaTypes) && (needNotCheckedRepeatVaTypes.contains(srcVaTypeId) || needNotCheckedRepeatVaTypes.contains(targetVaTypeId))) {
            return false;
        }
        if (WTCStringUtils.equals((String)SpecialVaTypeEnum.LACTATION_TYPE.vaType, (String)src.getSpecialVaType()) && WTCStringUtils.equals((String)SpecialVaTypeEnum.LACTATION_TYPE.vaType, (String)target.getSpecialVaType())) {
            return true;
        }
        if (!WTCStringUtils.equals((String)SpecialVaTypeEnum.LACTATION_TYPE.vaType, (String)src.getSpecialVaType()) && !WTCStringUtils.equals((String)SpecialVaTypeEnum.LACTATION_TYPE.vaType, (String)target.getSpecialVaType())) {
            return true;
        }
        DynamicObject srcBaseSetDy = WTCStringUtils.equals((String)SpecialVaTypeEnum.LACTATION_TYPE.vaType, (String)src.getSpecialVaType()) ? (vaAutoOperator != null ? this.getBaseSetDy(src, vaAutoOperator) : targetBaseSetDyMap.get(src.getId())) : (isCurr && vaAutoOperator != null ? this.getBaseSetDy(target, vaAutoOperator) : targetBaseSetDyMap.get(target.getId()));
        if (srcBaseSetDy == null) {
            return true;
        }
        long goalVaTypeId = srcVaTypeId;
        if (WTCStringUtils.equals((String)SpecialVaTypeEnum.LACTATION_TYPE.vaType, (String)src.getSpecialVaType())) {
            srcVaTypeEntries = srcBaseSetDy.getDynamicObjectCollection("vatypeentry");
            goalVaTypeId = targetVaTypeId;
        } else {
            srcVaTypeEntries = srcBaseSetDy.getDynamicObjectCollection("vatypeentry");
        }
        for (DynamicObject srcVaTypeEntry : srcVaTypeEntries) {
            if (goalVaTypeId != srcVaTypeEntry.getLong("vacationtype.id")) continue;
            return false;
        }
        return true;
    }

    private DynamicObject getBaseSetDy(VaBillEntryEntityVo src, VaAutoOperator vaAutoOperator) {
        boolean useStartOrEnd = vaAutoOperator.isUseStartOrEnd();
        Map baseSetDyMap = vaAutoOperator.getBaseSetDy(src.getAttFileBoid(), src.getStartDate(), src.getEndDate(), src.getVaTypeId());
        if (WTCCollections.isNotEmpty((Map)baseSetDyMap)) {
            return useStartOrEnd ? (DynamicObject)baseSetDyMap.get(new Date(src.getStartDate().getTime())) : (DynamicObject)baseSetDyMap.get(new Date(src.getEndDate().getTime()));
        }
        return null;
    }

    private boolean anyCustom(VaBillEntryEntityVo srcEntry, VaBillEntryEntityVo targetEntry) {
        boolean srcIsCustom = StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence)srcEntry.getStartMethod()) || StringUtils.equals((CharSequence)SpecialVaTypeEnum.LACTATION_TYPE.vaType, (CharSequence)srcEntry.getSpecialVaType());
        boolean targetIsCustom = StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence)targetEntry.getStartMethod()) || StringUtils.equals((CharSequence)SpecialVaTypeEnum.LACTATION_TYPE.vaType, (CharSequence)targetEntry.getSpecialVaType());
        return srcIsCustom || targetIsCustom;
    }

    private String repeatMessageResp(VaBillVo vaBillVoPerson, VaBillEntryEntityVo entryEntity, VaBillEntryEntityVo targetEntryVo, boolean isCurr, boolean isImport) {
        DynamicObject batchBillDy;
        String errorMsg = "";
        if (this.isBatchVa && isCurr) {
            errorMsg = BatchVaKDString.repeatCurrEntry();
            errorMsg = MessageFormat.format(errorMsg, targetEntryVo.getRowIndex());
        }
        if ((batchBillDy = targetEntryVo.getBatchBillDy()) != null) {
            errorMsg = BatchVaKDString.repeatHisBatch();
            errorMsg = MessageFormat.format(errorMsg, BillTypeEnum.VACATIONBILL.getBillName(), batchBillDy.getString("billno"));
        }
        if (HRStringUtils.isNotEmpty((String)errorMsg)) {
            return errorMsg;
        }
        int rowIndex = entryEntity.getRowIndex();
        int rowCount = vaBillVoPerson.getEntryEntities().size();
        if (isCurr) {
            errorMsg = VaKDStringHelper.repeatWithAddedEntry();
            if (!targetEntryVo.getBillNo().equals(entryEntity.getBillNo())) {
                errorMsg = isImport ? VaKDStringHelper.repeatWithAddedBill() : VaKDStringHelper.repeatWithHisBill(targetEntryVo.getBillNo());
            }
        } else {
            errorMsg = VaKDStringHelper.repeatWithHisBill(targetEntryVo.getBillNo());
        }
        if (!isImport || rowCount <= 1) {
            return errorMsg;
        }
        StringBuilder sb = new StringBuilder();
        for (int index = 1; index <= rowCount; ++index) {
            String s1 = VaKDStringHelper.entityNumber(index);
            sb.append(s1);
            sb.append(WTCSymbolMultiLanguageUtil.getColonSymbol());
            if (index == rowIndex) {
                sb.append(errorMsg);
                continue;
            }
            String s2 = VaKDStringHelper.fialByOtherEntity();
            sb.append(s2);
        }
        return sb.toString();
    }

    private VaRepeatParseVo parseVaBill(List<VaBillVo> allVaBillVos) {
        Map<Long, Map<Long, List<VaBillVo>>> personBillMap = allVaBillVos.stream().collect(Collectors.groupingBy(BillVo::getAttPersonId, Collectors.groupingBy(BillVo::getAttFileBoId)));
        Date startDate = null;
        Date endDate = null;
        ArrayList attFileBoIds = Lists.newArrayListWithExpectedSize((int)allVaBillVos.size());
        HashSet attPersonIds = Sets.newHashSetWithExpectedSize((int)allVaBillVos.size());
        Set<Map.Entry<Long, Map<Long, List<VaBillVo>>>> personEntries = personBillMap.entrySet();
        for (Map.Entry<Long, Map<Long, List<VaBillVo>>> personEntry : personEntries) {
            Date personStartDate = null;
            Date personEndDate = null;
            boolean anyCustom = false;
            Map<Long, List<VaBillVo>> attFileVaBillMaps = personEntry.getValue();
            Set<Map.Entry<Long, List<VaBillVo>>> attFileGroupEntries = attFileVaBillMaps.entrySet();
            for (Map.Entry<Long, List<VaBillVo>> entry : attFileGroupEntries) {
                List<VaBillVo> vaBillVos = entry.getValue();
                for (VaBillVo vaBillVo : vaBillVos) {
                    List entryEntities = vaBillVo.getEntryEntities();
                    for (VaBillEntryEntityVo entryVo : entryEntities) {
                        if (StringUtils.equals((CharSequence)SpecialVaTypeEnum.LACTATION_TYPE.vaType, (CharSequence)entryVo.getSpecialVaType()) || StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence)entryVo.getStartMethod())) {
                            anyCustom = true;
                        }
                        if (personStartDate == null || personStartDate.after(entryVo.getStartDate())) {
                            personStartDate = entryVo.getStartDate();
                        }
                        if (personEndDate != null && !personEndDate.before(entryVo.getEndDate())) continue;
                        personEndDate = entryVo.getEndDate();
                    }
                }
            }
            if (!anyCustom) continue;
            if (startDate == null || startDate.after(personStartDate)) {
                startDate = personStartDate;
            }
            if (endDate == null || endDate.before(personEndDate)) {
                endDate = personEndDate;
            }
            attFileBoIds.addAll(attFileVaBillMaps.keySet());
            attPersonIds.add(personEntry.getKey());
        }
        return new VaRepeatParseVo((List)attFileBoIds, (Set)attPersonIds, startDate, endDate);
    }

    public DutyShiftResponse getShiftInfo(List<Long> attFileBoIdList, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime) {
        DutyShiftResponse shiftResponse = ApplyUtil.getShift(attFileBoIdList, (Date)HRDateTimeUtils.addDay((Date)dutyDateQueryStartTime, (long)-1L), (Date)HRDateTimeUtils.addDay((Date)dutyDateQueryEndTime, (long)1L));
        return shiftResponse;
    }

    public boolean checkRepeatWithSchedule(VaBillEntryEntityVo src, VaBillEntryEntityVo target) {
        Date targetEnd;
        Date targetStart;
        Date srcEnd;
        if (src.getId() == target.getId()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ID\u76f8\u540c\u8ba4\u4e3a\u662f\u540c\u4e00\u6761\u6570\u636e\uff0c\u4e0d\u5bf9\u6bd4\uff0c targetId:{}, srcId:{}", (Object)target.getId(), (Object)src.getId());
            }
            return false;
        }
        Date srcStart = src.getStartDate();
        if (!WTCDateUtils.hasIntersectionLCRC((Date)srcStart, (Date)(srcEnd = src.getEndDate()), (Date)(targetStart = target.getStartDate()), (Date)(targetEnd = target.getEndDate()))) {
            return false;
        }
        if (StringUtils.equalsAny((CharSequence)WtcTimeRangeBtnTypeEnum.DAY.value, (CharSequence[])new CharSequence[]{src.getStartMethod(), target.getStartMethod()})) {
            return true;
        }
        boolean srcStartIsTargetEnd = DateUtils.isSameDay((Date)srcStart, (Date)targetEnd);
        boolean srcEndIsTargetStart = DateUtils.isSameDay((Date)srcEnd, (Date)targetStart);
        if (srcStartIsTargetEnd && srcEndIsTargetStart) {
            boolean srcHalfUp = StringUtils.equals((CharSequence)src.getStartMethod(), (CharSequence)src.getEndMethod()) && StringUtils.equals((CharSequence)src.getStartMethod(), (CharSequence)WtcTimeRangeBtnTypeEnum.HALF_UP.value);
            boolean srcHalfDown = StringUtils.equals((CharSequence)src.getStartMethod(), (CharSequence)src.getEndMethod()) && StringUtils.equals((CharSequence)src.getStartMethod(), (CharSequence)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value);
            boolean targetHalfUp = StringUtils.equals((CharSequence)target.getStartMethod(), (CharSequence)target.getEndMethod()) && StringUtils.equals((CharSequence)target.getStartMethod(), (CharSequence)WtcTimeRangeBtnTypeEnum.HALF_UP.value);
            boolean targetHalfDown = StringUtils.equals((CharSequence)target.getStartMethod(), (CharSequence)target.getEndMethod()) && StringUtils.equals((CharSequence)target.getStartMethod(), (CharSequence)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value);
            return !(srcHalfUp && targetHalfDown || srcHalfDown && targetHalfUp);
        }
        if (srcStartIsTargetEnd) {
            return StringUtils.compare((String)src.getStartMethod(), (String)target.getEndMethod()) <= 0;
        }
        if (srcEndIsTargetStart) {
            return StringUtils.compare((String)src.getEndMethod(), (String)target.getStartMethod()) >= 0;
        }
        return true;
    }

    public boolean repeatWithTime(VaBillEntryEntityVo srcEntry, VaBillEntryEntityVo targetEntry, DutyShiftResponse shiftInfo) {
        VaBillEntryEntityVo src = srcEntry;
        VaBillEntryEntityVo target = targetEntry;
        LOG.info("\u3010\u4f11\u5047\u5355\u91cd\u53e0\u6821\u9a8c\u3011\u4e24\u4e2a\u5206\u5f55\u5224\u5b9a\u91cd\u53e0\u5f00\u59cb\uff0csrcId:{}, targetId:{}", (Object)src.getId(), (Object)target.getId());
        if (src.getId() == target.getId()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("\u3010\u4f11\u5047\u5355\u91cd\u53e0\u6821\u9a8c\u3011ID\u76f8\u540c\u8ba4\u4e3a\u662f\u540c\u4e00\u6761\u6570\u636e\uff0c\u4e0d\u5bf9\u6bd4\u3002srcBillNo:{}", (Object)src.getBillNo());
            }
            return false;
        }
        VaBillEntryEntityVo temp = src;
        if (StringUtils.equals((CharSequence)SpecialVaTypeEnum.LACTATION_TYPE.vaType, (CharSequence)target.getSpecialVaType())) {
            List<VaBillSubEntryVo> subEntryVos = BreastfeedingLeaveService.generateBreastfeedingTimeRange(target, shiftInfo);
            target.setVaSubEntryVoList(subEntryVos);
        }
        if (StringUtils.equals((CharSequence)SpecialVaTypeEnum.LACTATION_TYPE.vaType, (CharSequence)src.getSpecialVaType())) {
            List<VaBillSubEntryVo> srcSubEntryVos = BreastfeedingLeaveService.generateBreastfeedingTimeRange(src, shiftInfo);
            src.setVaSubEntryVoList(srcSubEntryVos);
        }
        if (StringUtils.equals((CharSequence)SpecialVaTypeEnum.LACTATION_TYPE.vaType, (CharSequence)target.getSpecialVaType())) {
            if (!StringUtils.equals((CharSequence)SpecialVaTypeEnum.LACTATION_TYPE.vaType, (CharSequence)src.getSpecialVaType())) {
                src = target;
                target = temp;
            }
        } else if (StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence)target.getStartMethod()) && !StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence)src.getStartMethod()) && !StringUtils.equals((CharSequence)SpecialVaTypeEnum.LACTATION_TYPE.vaType, (CharSequence)src.getSpecialVaType())) {
            src = target;
            target = temp;
        }
        if (StringUtils.equals((CharSequence)SpecialVaTypeEnum.LACTATION_TYPE.vaType, (CharSequence)src.getSpecialVaType())) {
            if (StringUtils.equals((CharSequence)SpecialVaTypeEnum.LACTATION_TYPE.vaType, (CharSequence)target.getSpecialVaType())) {
                return this.doRepeatLactation(src, target);
            }
            return this.doRepeatLactationWithOther(src, target, shiftInfo);
        }
        if (StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence)src.getStartMethod())) {
            if (StringUtils.equalsAny((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence[])new CharSequence[]{target.getStartMethod()})) {
                return WTCDateUtils.hasIntersectionLCRO((Date)src.getStartDate(), (Date)src.getEndDate(), (Date)target.getStartDate(), (Date)target.getEndDate());
            }
            return this.doRepeatWithTimeAndOther(src.getStartDate(), src.getEndDate(), target, shiftInfo);
        }
        return false;
    }

    private boolean doRepeatLactation(VaBillEntryEntityVo src, VaBillEntryEntityVo target) {
        if (src.getVaTypeId() == target.getVaTypeId()) {
            LOG.info("\u3010\u4f11\u5047\u5355\u91cd\u53e0\u6821\u9a8c\u3011\u4e24\u4e2a\u578b\u54fa\u4e73\u5047\u7684\u4f11\u5047\u7c7b\u578b\u76f8\u540c\u6bd4\u8f83\u91cd\u53e0\u3002src:{}, target:{}", (Object)src.getId(), (Object)target.getId());
            return WTCDateUtils.hasIntersectionLCRC((Date)src.getStartDate(), (Date)src.getEndDate(), (Date)target.getStartDate(), (Date)target.getEndDate());
        }
        List srcVaSubEntryVoList = src.getVaSubEntryVoList();
        List targetVaSubEntryVoList = target.getVaSubEntryVoList();
        for (VaBillSubEntryVo subEntryVo : srcVaSubEntryVoList) {
            for (VaBillSubEntryVo targetSubEntryVo : targetVaSubEntryVoList) {
                boolean repeat = WTCDateUtils.hasIntersectionLCRO((Date)subEntryVo.getStartDateTime(), (Date)subEntryVo.getEndDateTime(), (Date)targetSubEntryVo.getStartDateTime(), (Date)targetSubEntryVo.getEndDateTime());
                if (!repeat) continue;
                LOG.info("\u3010\u4f11\u5047\u5355\u91cd\u53e0\u6821\u9a8c\u3011\u4e24\u4e2a\u4e0d\u540c\u7c7b\u578b\u54fa\u4e73\u5047\u6bd4\u8f83\uff0c\u5b58\u5728\u91cd\u53e0\u3002");
                return true;
            }
        }
        return false;
    }

    private boolean doRepeatLactationWithOther(VaBillEntryEntityVo src, VaBillEntryEntityVo target, DutyShiftResponse shiftInfo) {
        LOG.info("\u3010\u4f11\u5047\u5355\u91cd\u53e0\u6821\u9a8c\u3011\u54fa\u4e73\u5047\u548c\u975e\u54fa\u4e73\u5047\u6821\u9a8c\u91cd\u53e0\uff0c srcBillNo:{}, targetBillNo:{}, targetMethod:{}, src.vaSubEntryVoList:{}", new Object[]{src.getBillNo(), target.getBillNo(), target.getStartMethod(), JSON.toJSONString((Object)src.getVaSubEntryVoList())});
        for (VaBillSubEntryVo srcValidTimeVo : src.getVaSubEntryVoList()) {
            boolean repeat;
            if (!(StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence)target.getStartMethod()) ? (repeat = WTCDateUtils.hasIntersectionLCRO((Date)srcValidTimeVo.getStartDateTime(), (Date)srcValidTimeVo.getEndDateTime(), (Date)target.getStartDate(), (Date)target.getEndDate())) : this.doRepeatWithTimeAndOther(srcValidTimeVo.getStartDateTime(), srcValidTimeVo.getEndDateTime(), target, shiftInfo))) continue;
            return true;
        }
        return false;
    }

    private boolean doRepeatWithTimeAndOther(Date startDateTime, Date endDateTime, VaBillEntryEntityVo target, DutyShiftResponse shiftInfo) {
        LOG.info("\u3010\u4f11\u5047\u5355\u91cd\u53e0\u6821\u9a8c\u3011\u3010\u5e26\u65f6\u6bb5\u7684\u5047\u548c\u4e0a\u4e0b\u534a\u5929/\u5168\u5929\u5047\u5224\u5b9a\u3011target:{},startDateTime:{},endDateTime:{} ", new Object[]{target, startDateTime, endDateTime});
        if (shiftInfo == null) {
            LOG.info("\u3010\u4f11\u5047\u5355\u91cd\u53e0\u6821\u9a8c\u3011\u3010\u5e26\u65f6\u6bb5\u7684\u5047\u548c\u4e0a\u4e0b\u534a\u5929/\u5168\u5929\u5047\u5224\u5b9a\u3011\u6392\u73ed\u4e3anull\uff0c\u8df3\u8fc7\u6821\u9a8c\uff0c\u76f4\u63a5\u8ba4\u4e3a\u91cd\u53e0");
            return true;
        }
        Date prevStartDate = WTCDateUtils.addDays((Date)target.getStartDate(), (int)-1);
        Shift prevStartShift = this.getShift(shiftInfo, target.getAttFileBoid(), prevStartDate);
        Shift startShift = this.getShift(shiftInfo, target.getAttFileBoid(), target.getStartDate());
        Shift endShift = this.getShift(shiftInfo, target.getAttFileBoid(), target.getEndDate());
        Date prevShiftEnd = null;
        if (prevStartShift != null) {
            prevShiftEnd = ShiftParseUtil.getRosterEndDate((Shift)prevStartShift, (Date)prevStartDate, (boolean)true);
        }
        Date entryStartDateTime = ShiftParseUtil.getRosterStartDate((Shift)startShift, (Date)target.getStartDate(), (Date)prevShiftEnd);
        if (StringUtils.equals((CharSequence)target.getStartMethod(), (CharSequence)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value)) {
            entryStartDateTime = ShiftParseUtil.getMiddleDate((Shift)startShift, (Date)target.getStartDate());
        }
        Date entryEndDateTime = ShiftParseUtil.getRosterEndDate((Shift)endShift, (Date)target.getEndDate(), (boolean)true);
        if (StringUtils.equals((CharSequence)target.getEndMethod(), (CharSequence)WtcTimeRangeBtnTypeEnum.HALF_UP.value)) {
            entryEndDateTime = ShiftParseUtil.getMiddleDateEnd((Shift)endShift, (Date)target.getEndDate());
        }
        return WTCDateUtils.hasIntersectionLCRO((Date)startDateTime, (Date)endDateTime, (Date)entryStartDateTime, (Date)entryEndDateTime);
    }

    private Shift getShift(DutyShiftResponse shiftInfo, long attFileBoid, Date date) {
        Optional currShiftHis;
        Optional startDutyShiftOption = shiftInfo.getDutyShift(Long.valueOf(attFileBoid), date);
        if (startDutyShiftOption.isPresent() && (currShiftHis = shiftInfo.getCurrShiftHis(Long.valueOf(attFileBoid), date)).isPresent()) {
            return (Shift)currShiftHis.get();
        }
        return null;
    }

    public void appendFailInfos(BillFailInfo billFailInfo, long billId, String failInfo) {
        Map errorInfos = billFailInfo.getErrorInfos();
        errorInfos.put(billId, failInfo);
    }
}

