/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.business.vaapply;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.sdk.wtc.wtabm.business.helper.VaBillDto;
import kd.sdk.wtc.wtabm.business.helper.VaBillEntryEntityDto;
import kd.sdk.wtc.wtabm.business.helper.VaBillSubEntryDto;
import kd.sdk.wtc.wtabm.business.helper.VaBillsWithTimeInfoParam;
import kd.wtc.wtabm.business.vaapply.BreastfeedingLeaveService;
import kd.wtc.wtabm.business.vaapply.VaApplyServiceHelper;
import kd.wtc.wtbs.business.util.ApplyUtil;
import kd.wtc.wtbs.common.enums.bill.va.SpecialVaTypeEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.model.evaluation.ShiftMiddleRule;
import kd.wtc.wtbs.common.model.shift.RefDateType;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.DateUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class VaBillTimeService {
    private final Log LOG = LogFactory.getLog(VaBillTimeService.class);
    private final List<String> auditStatusList = Collections.unmodifiableList(Arrays.asList("D", "B", "C"));

    public List<VaBillDto> getVaBills(VaBillsWithTimeInfoParam attFileReq) {
        Object[] billDyns;
        this.LOG.info("\u67e5\u8be2\u5df2\u7533\u8bf7\u5047\u5355\u4fe1\u606f\u5f00\u59cb\uff0cattPersonId:{}, fileBoId:{},startDate:{}, endDate:{}", new Object[]{attFileReq.getAttPersonId(), attFileReq.getAttFileBoId(), attFileReq.getStartDate(), attFileReq.getEndDate()});
        if (attFileReq.getAttFileBoId() == 0L && attFileReq.getAttPersonId() == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8003\u52e4\u4ebaID\u548c\u8003\u52e4\u6863\u6848ID\u4e0d\u53ef\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"VaBillTimeService_1", (String)"wtc-wtabm-business", (Object[])new Object[0]));
        }
        attFileReq.setStartDate(DateUtils.addDays((Date)attFileReq.getStartDate(), (int)-1));
        attFileReq.setEndDate(DateUtils.addDays((Date)attFileReq.getEndDate(), (int)1));
        ArrayList resultBills = Lists.newArrayListWithCapacity((int)10);
        VaApplyServiceHelper vaApplyServiceHelper = (VaApplyServiceHelper)((Object)WTCAppContextHelper.getBean(VaApplyServiceHelper.class));
        QFilter qFilter = new QFilter("billstatus", "in", this.auditStatusList).and("enddate", ">=", (Object)attFileReq.getStartDate()).and("startdate", "<=", (Object)attFileReq.getEndDate()).and("entryentity.entryenddate", ">=", (Object)attFileReq.getStartDate()).and("entryentity.entrystartdate", "<=", (Object)attFileReq.getEndDate());
        if (attFileReq.getAttPersonId() != 0L) {
            qFilter.and("personid.id", "=", (Object)attFileReq.getAttPersonId());
        }
        if (attFileReq.getAttFileBoId() != 0L) {
            qFilter.and("attfile.id", "=", (Object)attFileReq.getAttFileBoId());
        }
        if (ArrayUtils.isEmpty((Object[])(billDyns = vaApplyServiceHelper.loadDynamicObjectArray(new QFilter[]{qFilter})))) {
            return resultBills;
        }
        Date startDate = null;
        Date endDate = null;
        for (Object billDyn2 : billDyns) {
            VaBillDto billVo = new VaBillDto();
            resultBills.add(billVo);
            ArrayList entryVos = Lists.newArrayList();
            billVo.setId(billDyn2.getLong("id"));
            billVo.setBillNo(billDyn2.getString("billno"));
            billVo.setAttFileBoId(billDyn2.getLong("attfile.id"));
            billVo.setAttPersonId(billDyn2.getLong("personid.id"));
            billVo.setAttFileVid(billDyn2.getLong(String.join((CharSequence)".", "attfilebasef7", "id")));
            billVo.setParentId(billDyn2.getLong("parentid"));
            billVo.setNotLeave(billDyn2.getBoolean("isnotleave"));
            billVo.setEntryEntities((List)entryVos);
            DynamicObjectCollection entryEntities = billDyn2.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntities) {
                Date entryStartDate = entry.getDate("entrystartdate");
                Date entryEndDate = entry.getDate("entryenddate");
                if (attFileReq.getStartDate().after(entryEndDate) || attFileReq.getEndDate().before(DateUtils.addDays((Date)WTCDateUtils.getDayStartTime((Date)entryStartDate), (int)-1))) continue;
                if (startDate == null || startDate.after(entryStartDate)) {
                    startDate = WTCDateUtils.getDayStartTime((Date)entryStartDate);
                }
                if (endDate == null || endDate.before(entryEndDate)) {
                    endDate = WTCDateUtils.getDayStartTime((Date)entryEndDate);
                }
                VaBillEntryEntityDto entityVo = new VaBillEntryEntityDto();
                entryVos.add(entityVo);
                entityVo.setSpecialVaType(entry.getString("specialvatype"));
                entityVo.setSpVaMethodId(entry.getLong("specialvamethod.id"));
                entityVo.setStartDate(entry.getDate("entrystartdate"));
                entityVo.setEndDate(entry.getDate("entryenddate"));
                entityVo.setStartMethod(entry.getString("entrystartmethod"));
                entityVo.setEndMethod(entry.getString("entryendmethod"));
                entityVo.setAttFileBoid(billVo.getAttFileBoId());
                DynamicObjectCollection vadetailentries = entry.getDynamicObjectCollection("vadetailentry");
                ArrayList subEntryVos = Lists.newArrayList();
                entityVo.setVaSubEntryVoList((List)subEntryVos);
                entityVo.setStorageTo(entry.getDate("storageto"));
                entityVo.setSpecialExtJson(entry.getString("specialextjson"));
                if (!CollectionUtils.isNotEmpty((Collection)vadetailentries)) continue;
                for (DynamicObject vaDetailEntry : vadetailentries) {
                    VaBillSubEntryDto subEntryVo = new VaBillSubEntryDto();
                    subEntryVo.setStartDateTime(vaDetailEntry.getDate("vaentrystarttime")).setEndDateTime(vaDetailEntry.getDate("vaentryendtime")).setVaEntryDate(vaDetailEntry.getDate("vaentrydate")).setDetailId(((Long)vaDetailEntry.getPkValue()).longValue());
                    subEntryVos.add(subEntryVo);
                }
            }
        }
        Set attFileBoIds = Arrays.stream(billDyns).map(billDyn -> billDyn.getLong("attfile.id")).collect(Collectors.toSet());
        DutyShiftResponse dutyShiftResponse = ApplyUtil.getShift((List)Lists.newArrayList(attFileBoIds), startDate, endDate);
        this.dealResultBills(resultBills, dutyShiftResponse);
        this.LOG.info("\u67e5\u8be2\u6570\u636e\u7ed3\u679c\uff1aresultBills.size\uff1a{}, billIdList:{}", (Object)resultBills.size(), resultBills.stream().map(VaBillDto::getId).collect(Collectors.toList()));
        return resultBills;
    }

    private List<VaBillDto> dealResultBills(List<VaBillDto> resultBillVos, DutyShiftResponse dutyShiftResponse) {
        for (VaBillDto vaBillVo : resultBillVos) {
            List entryEntities = vaBillVo.getEntryEntities();
            for (VaBillEntryEntityDto entry : entryEntities) {
                if (StringUtils.equals((CharSequence)entry.getSpecialVaType(), (CharSequence)SpecialVaTypeEnum.LACTATION_TYPE.vaType)) {
                    List<VaBillSubEntryDto> vaBillSubEntryDtos = BreastfeedingLeaveService.generateBreastfeedingTimeRange(entry, dutyShiftResponse);
                    entry.setVaSubEntryVoList(vaBillSubEntryDtos);
                    continue;
                }
                if (StringUtils.equals((CharSequence)entry.getStartMethod(), (CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value)) {
                    entry.setRealStartDate(entry.getStartDate());
                    entry.setRealEndDate(entry.getEndDate());
                    continue;
                }
                Optional startShiftHis = dutyShiftResponse.getCurrShiftHis(Long.valueOf(entry.getAttFileBoid()), WTCDateUtils.getDayStartTime((Date)entry.getStartDate()));
                Optional endShiftHis = dutyShiftResponse.getCurrShiftHis(Long.valueOf(entry.getAttFileBoid()), WTCDateUtils.getDayStartTime((Date)entry.getEndDate()));
                if (startShiftHis.isPresent() && endShiftHis.isPresent()) {
                    Shift startShift = (Shift)startShiftHis.get();
                    if (startShift.getOffNonPlan()) {
                        entry.setStartOffNonPlan(true);
                    } else {
                        Date rosterStart = null;
                        rosterStart = StringUtils.equalsAny((CharSequence)entry.getStartMethod(), (CharSequence[])new CharSequence[]{WtcTimeRangeBtnTypeEnum.HALF_UP.value, WtcTimeRangeBtnTypeEnum.DAY.value}) ? DateUtils.addSeconds((Date)entry.getStartDate(), (int)startShift.getLastShiftStartDate()) : VaBillTimeService.getMiddleDate(entry.getStartDate(), startShift);
                        entry.setRealStartDate(rosterStart);
                    }
                    Shift endShift = (Shift)endShiftHis.get();
                    if (endShift.getOffNonPlan()) {
                        entry.setEndOffNonPlan(true);
                        continue;
                    }
                    Date rosterEnd = null;
                    rosterEnd = StringUtils.equalsAny((CharSequence)entry.getEndMethod(), (CharSequence[])new CharSequence[]{WtcTimeRangeBtnTypeEnum.HALF_DOWN.value, WtcTimeRangeBtnTypeEnum.DAY.value}) ? VaBillTimeService.getRealEndDate(entry.getEndDate(), endShift) : VaBillTimeService.getMiddleDate(entry.getEndDate(), endShift);
                    entry.setRealEndDate(rosterEnd);
                    continue;
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4f11\u5047\u5355\u65f6\u6bb5\u5185\u73ed\u6b21\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002\u6392\u73ed\u65e5\u671f\uff1a%1$s, %2$s\u3002", (String)"VaBillWithTimeService_2", (String)"wtc-wtabm-mservice", (Object[])new Object[0]), entry.getStartDate(), entry.getEndDate()));
            }
        }
        return resultBillVos;
    }

    private static Date getRealEndDate(Date rosterDate, Shift shift) {
        Date rosterEnd = DateUtils.addSeconds((Date)rosterDate, (int)shift.getLastShiftEndDate());
        if (RefDateType.NEXTDAY.code.equals(shift.getLastRefEndDay())) {
            rosterEnd = DateUtils.addDays((Date)rosterEnd, (int)1);
        }
        return rosterEnd;
    }

    private static Date getMiddleDate(Date rosterDate, Shift shift) {
        ShiftMiddleRule shiftMiddleRule = shift.getShiftMiddleRule();
        int middlepoint = shiftMiddleRule.getMiddlepoint();
        Date middleDate = WTCDateUtils.getDate((Date)rosterDate, (Integer)middlepoint);
        RefDateType middleRefDate = shiftMiddleRule.getMiddleRefDate();
        if (RefDateType.NEXTDAY == middleRefDate) {
            middleDate = WTCDateUtils.addDays((Date)middleDate, (int)1);
        }
        return middleDate;
    }
}

