/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.business.vaapply;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.applybill.service.BillUnifyQueryService;
import kd.wtc.wtbs.business.web.billservice.dutyDate.BillOptionalDutyDateService;
import kd.wtc.wtbs.business.web.billservice.shift.BillShiftService;
import kd.wtc.wtbs.common.bill.BillQueryEnum;
import kd.wtc.wtbs.common.bill.BillQueryParam;
import kd.wtc.wtbs.common.bill.VaBillQueryParam;
import kd.wtc.wtbs.common.enums.bill.va.SpecialVaTypeEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.model.billservice.BillDutyDateRealTimeParam;
import kd.wtc.wtbs.common.model.billservice.BillShiftParam;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.wtp.enums.vaplan.BaseSetTimeBreastDayTypeEnum;

public class VaBillUnifyQueryService
extends BillUnifyQueryService {
    private HRBaseServiceHelper service = new HRBaseServiceHelper("wtabm_vaapply");
    private static final Log LOG = LogFactory.getLog(VaBillUnifyQueryService.class);

    public VaBillUnifyQueryService(VaBillQueryParam param) {
        super(BillQueryEnum.VA, (BillQueryParam)param);
        this.initBuildQFilter(param);
        this.defaultQuery(param);
    }

    protected final void initBuildQFilter(VaBillQueryParam param) {
    }

    protected final void defaultQuery(VaBillQueryParam param) {
        super.defaultQuery((BillQueryParam)param, this.service);
    }

    public List<DynamicObject> getBillOfDefault() {
        return Arrays.stream(this.result).collect(Collectors.toList());
    }

    public List<DynamicObject> filterRealTimeByDutyDate(List<DynamicObject> vaBillDyList, LocalDate startDate, LocalDate endDate) {
        if (startDate == null || endDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u4e0e\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VaBillUnifyQueryService_0", (String)"wtc-wtabm-business", (Object[])new Object[0]));
        }
        if (WTCCollections.isEmpty(vaBillDyList)) {
            return Collections.emptyList();
        }
        BillShiftService billShiftService = new BillShiftService();
        List<BillDutyDateRealTimeParam> realTimeParams = this.convertToDutyInfo(vaBillDyList);
        BillOptionalDutyDateService dutyDateService = new BillOptionalDutyDateService();
        List shiftParams = dutyDateService.convertShiftParam(realTimeParams);
        for (int index = 0; index < shiftParams.size(); ++index) {
            Optional dutyOptional = WTCCollectionIndexUtil.getEleFromList(realTimeParams, (int)index);
            if (!dutyOptional.isPresent()) {
                LOG.warn("VaBillUnifyQueryService_filterRealTimeByDutyDate query va error,shiftParams.size = {},realTimeParams.size ={},index = {}", new Object[]{shiftParams.size(), realTimeParams.size(), index});
                throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4f11\u5047\u5355\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VaBillUnifyQueryService_1", (String)"wtc-wtabm-business", (Object[])new Object[0]));
            }
            ((BillDutyDateRealTimeParam)dutyOptional.get()).setShiftParam((BillShiftParam)shiftParams.get(index));
        }
        shiftParams = shiftParams.stream().filter(sf -> sf.getQueryStartDate() != null && sf.getQueryEndDate() != null).collect(Collectors.toList());
        billShiftService.fillShiftInfo(shiftParams);
        dutyDateService.handleRealTimeForDutyDate(realTimeParams);
        Map<Long, BillDutyDateRealTimeParam> realTimeGroup = realTimeParams.stream().collect(Collectors.toMap(BillDutyDateRealTimeParam::getBillId, br -> br, (e1, e2) -> e2));
        ArrayList<DynamicObject> afterFilter = new ArrayList<DynamicObject>(10);
        block1: for (DynamicObject dynamicObject : vaBillDyList) {
            BillDutyDateRealTimeParam billDutyDateRealTimeParam = realTimeGroup.get(dynamicObject.getLong("id"));
            if (billDutyDateRealTimeParam == null) continue;
            Set confirmDutyDate = billDutyDateRealTimeParam.getConfirmDutyDate();
            for (Date date : confirmDutyDate) {
                boolean match = date != null && WTCDateUtils.betweenTimeEquals((Date)WTCDateUtils.getDayStart((Date)date), (Date)WTCDateUtils.toDate((LocalDate)startDate), (Date)WTCDateUtils.toDate((LocalDate)endDate));
                if (!match) continue;
                afterFilter.add(dynamicObject);
                continue block1;
            }
        }
        return afterFilter;
    }

    private List<BillDutyDateRealTimeParam> convertToDutyInfo(List<DynamicObject> vaBillDyList) {
        ArrayList<BillDutyDateRealTimeParam> result = new ArrayList<BillDutyDateRealTimeParam>(10);
        for (DynamicObject vaBillDy : vaBillDyList) {
            BillDutyDateRealTimeParam dateInfoForDy = new BillDutyDateRealTimeParam(vaBillDy.getLong("id"), WTCDynamicObjectUtils.getBaseDataId((DynamicObject)vaBillDy, (String)"attfile"));
            HashSet confirmDate = new HashSet(16);
            ArrayList<Tuples.Tuple2> realTime = new ArrayList<Tuples.Tuple2>(10);
            DynamicObjectCollection entryColl = vaBillDy.getDynamicObjectCollection("entryentity");
            if (WTCCollections.isEmpty((Collection)entryColl)) continue;
            for (DynamicObject entryDy : entryColl) {
                ArrayList dateInEntry = new ArrayList(10);
                Date entryStartDate = entryDy.getDate("entrystartdate");
                Date entryEndDate = entryDy.getDate("entryenddate");
                if (entryStartDate == null || entryEndDate == null) continue;
                dateInEntry.addAll(WTCDateUtils.getDateRange((Date)entryStartDate, (Date)entryEndDate));
                if (HRStringUtils.equals((String)entryDy.getString("specialvatype"), (String)SpecialVaTypeEnum.LACTATION_TYPE.vaType)) {
                    long specialVaMethod = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entryDy, (String)"specialvamethod.id");
                    DynamicObjectCollection detailColl = entryDy.getDynamicObjectCollection("vadetailentry");
                    if (specialVaMethod == BaseSetTimeBreastDayTypeEnum.CUSTOM.id) {
                        if (!WTCCollections.isNotEmpty((Collection)detailColl)) continue;
                        for (DynamicObject detailDy : detailColl) {
                            realTime.add(new Tuples.Tuple2((Object)detailDy.getDate("vaentrystarttime"), (Object)detailDy.getDate("vaentryendtime")));
                        }
                        continue;
                    }
                    confirmDate.addAll(dateInEntry);
                    continue;
                }
                String method = entryDy.getString("entrystartmethod");
                if (HRStringUtils.equals((String)method, (String)WtcTimeRangeBtnTypeEnum.CUSTOM.value)) {
                    realTime.add(new Tuples.Tuple2((Object)entryDy.getDate("entrystartdate"), (Object)entryDy.getDate("entryenddate")));
                    continue;
                }
                confirmDate.addAll(dateInEntry);
            }
            dateInfoForDy.setBillId(vaBillDy.getLong("id"));
            dateInfoForDy.setConfirmDutyDate(confirmDate);
            dateInfoForDy.setNeedQueryRealTime(realTime);
            result.add(dateInfoForDy);
        }
        return result;
    }
}

