/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.business.vaapply;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TimeRangeEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.sdk.wtc.wtabm.business.spva.SpecialVaTimeDto;
import kd.sdk.wtc.wtabm.business.va.OnCheckVaApplyOverlapEvent;
import kd.sdk.wtc.wtabm.business.va.VaApplyTimeCalExtPlugin;
import kd.sdk.wtc.wtabm.business.va.VaTimeResult;
import kd.wtc.wtabm.business.bo.VaRepeatExtensionParam;
import kd.wtc.wtabm.business.ext.OnCalVaApplyTimeEventExtImpl;
import kd.wtc.wtabm.business.vaapply.VaApplyExtHelper;
import kd.wtc.wtabm.business.vaapply.VaApplyService;
import kd.wtc.wtabm.business.vaapply.VaBaseService;
import kd.wtc.wtabm.business.vaapply.VaBillRepeatService;
import kd.wtc.wtabm.business.vaapply.VaKDStringHelper;
import kd.wtc.wtabm.business.vaapply.checker.VaBillCheckService;
import kd.wtc.wtabm.business.vaapply.checker.VaEntityCheckService;
import kd.wtc.wtabm.common.entity.vaapply.VaInfoTimeFiledVo;
import kd.wtc.wtabm.common.entity.vaapply.VaInfoVo;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.WtcTimeRangeControlService;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.web.applybill.operatecore.va.VaAutoOperator;
import kd.wtc.wtbs.business.web.applybill.service.BillEntityCheckService;
import kd.wtc.wtbs.common.bill.ApplyTimeTypeParam;
import kd.wtc.wtbs.common.deduction.frozen.FrozenResult;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.bill.BillOpenStyleEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.enums.bill.va.SpecialVaTypeEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeEventEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeTypeEnum;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.bill.BillApplyTimeResult;
import kd.wtc.wtbs.common.model.bill.BillFailInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.model.wtctimerange.WtcTimeRangeArgsModel;
import kd.wtc.wtbs.common.model.wtctimerange.WtcTimeRangeModel;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCPageCache;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtabm.common.constants.WtabmVaInfoConstants;
import kd.wtc.wtbs.wtabm.common.entity.VaDetailItemPreviewVo;
import kd.wtc.wtbs.wtabm.common.entity.VaDetailPreviewVo;
import kd.wtc.wtbs.wtabm.common.entity.VaInfoTimeFieldEnum;
import kd.wtc.wtbs.wtabm.common.entity.VaLactationTimeStorage;
import kd.wtc.wtbs.wtp.enums.vaplan.BaseSetTimeBreastDayTypeEnum;

public class VaInfoService {
    private static final Log LOG = LogFactory.getLog(VaInfoService.class);

    public static void initPage(IFormView view) {
        VaInfoVo vaInfoVo = VaInfoService.getVaInfoVoFromShowParam(view);
        if (vaInfoVo != null) {
            IDataModel model = view.getModel();
            model.setValue("attpersonid", (Object)vaInfoVo.getAttPersonId());
            model.setValue("attfileboid", (Object)vaInfoVo.getAttFileBoid());
            model.setValue("entryparentid", (Object)vaInfoVo.getEntryParentId());
            model.setValue("rowindex", (Object)vaInfoVo.getRowIndex());
            model.setValue("attfileboid", (Object)vaInfoVo.getAttFileBoid());
            model.setValue("parentid", (Object)vaInfoVo.getParentBillId());
            List nonQtApplyCaches = vaInfoVo.getNonQtApplyCaches();
            if (CollectionUtils.isNotEmpty((Collection)nonQtApplyCaches)) {
                view.getPageCache().put("WTABM_CACHENONAPPLY", SerializationUtils.serializeToBase64((Object)nonQtApplyCaches));
            }
            CustomControl customControl = (CustomControl)view.getControl("wtctimerange");
            WtcTimeRangeModel wtcTimeRangeModel = VaInfoService.initWtcTimeRangeModel(vaInfoVo, WtcTimeRangeTypeEnum.EDIT);
            customControl.setData((Object)wtcTimeRangeModel);
        }
    }

    public static void initPageForEdit(IFormView view) {
        boolean entryIsNotEmpty;
        IDataModel model = view.getModel();
        VaInfoVo vaInfoVo = VaInfoService.getVaInfoVoFromShowParam(view);
        model.setValue("id", (Object)vaInfoVo.getId());
        model.setValue("rowindex", (Object)vaInfoVo.getRowIndex());
        model.setValue("attpersonid", (Object)vaInfoVo.getAttPersonId());
        model.setValue("attfileboid", (Object)vaInfoVo.getAttFileBoid());
        model.setValue("vacationtype", (Object)vaInfoVo.getVacationType());
        model.setValue("startdate", (Object)vaInfoVo.getStartDate());
        model.setValue("enddate", (Object)vaInfoVo.getEndDate());
        model.setValue("startmethod", (Object)vaInfoVo.getStartMethod());
        model.setValue("endmethod", (Object)vaInfoVo.getEndMethod());
        model.setValue("parentid", (Object)vaInfoVo.getParentBillId());
        model.setValue("owndate", (Object)vaInfoVo.getOwnDate());
        model.setValue("entryparentid", (Object)vaInfoVo.getEntryParentId());
        model.setValue("spvacationtype", (Object)vaInfoVo.getSpecialVaType());
        model.setValue("valactattype", (Object)vaInfoVo.getSpecialVaMethod());
        model.setValue("selfAdd", (Object)Boolean.FALSE);
        BillApplyTimeResult data = new BillApplyTimeResult();
        IPageCache pageCache = view.getPageCache();
        List nonQtApplyCaches = vaInfoVo.getNonQtApplyCaches();
        if (CollectionUtils.isNotEmpty((Collection)nonQtApplyCaches)) {
            pageCache.put("WTABM_CACHENONAPPLY", SerializationUtils.serializeToBase64((Object)nonQtApplyCaches));
        }
        boolean notLeave = vaInfoVo.getNotLeave();
        SpecialVaTypeEnum vaTypeEnum = SpecialVaTypeEnum.getByType((String)vaInfoVo.getSpecialVaType());
        boolean isLactation = SpecialVaTypeEnum.LACTATION_TYPE == vaTypeEnum;
        model.setValue("reasontext", (Object)vaInfoVo.getEntryReason());
        if (isLactation) {
            model.setValue("lactatreasontext", (Object)vaInfoVo.getEntryReason());
            model.setValue("lactatstart", (Object)vaInfoVo.getStartDate());
            model.setValue("lactatend", (Object)vaInfoVo.getEndDate());
            VaInfoService.specialLactationFlilVaInVo(model, vaInfoVo, data, pageCache);
            VaLactationTimeStorage timeStorage = (VaLactationTimeStorage)JSON.parseObject((String)vaInfoVo.getVaLactationTimeStorageJson(), VaLactationTimeStorage.class);
            VaInfoService.timeCustomRangeInit(view, timeStorage);
        }
        CustomControl customControl = (CustomControl)view.getControl("wtctimerange");
        FormShowParameter formShowParameter = view.getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        WtcTimeRangeTypeEnum timeRangeType = WtcTimeRangeTypeEnum.EDIT;
        if (status == OperationStatus.VIEW) {
            timeRangeType = WtcTimeRangeTypeEnum.VIEW;
        }
        WtcTimeRangeModel wtcTimeRangeModel = VaInfoService.initWtcTimeRangeModel(vaInfoVo, timeRangeType);
        customControl.setData((Object)wtcTimeRangeModel);
        IFormView parentView = view.getViewNoPlugin(formShowParameter.getParentPageId());
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(BillCommonService.getInstance().getAuthAppIdForFormPlugin(view), parentView.getEntityId());
        VaEntityCheckService vaEntityCheckService = VaEntityCheckService.createService(vaInfoVo.getAttFileBoid(), ApplyBillCheckEnum.VACATIONFORM, model.getDataEntity(), VaInfoService.isNeedCheckAttFileAuth(view), applyAttr);
        BillResponse billResponse = vaEntityCheckService.checkBaseSetBaseInfo();
        if (!CollectionUtils.isEmpty((Collection)billResponse.getMessage()) && status != OperationStatus.VIEW) {
            view.showTipNotification((String)billResponse.getMessage().get(0));
        }
        if (!billResponse.isSuccess()) {
            return;
        }
        VaInfoService.lactationControlInit(view, vaEntityCheckService, isLactation);
        boolean bl = entryIsNotEmpty = view.getParentView() != null && view.getParentView().getModel() != null && view.getParentView().getModel().getDataEntity() != null && view.getParentView().getModel().getDataEntity().containsProperty("entryentity") && WTCCollections.isNotEmpty((Collection)view.getParentView().getModel().getEntryEntity("entryentity"));
        if (entryIsNotEmpty) {
            DynamicObjectCollection entryEntity = view.getParentView().getModel().getEntryEntity("entryentity");
            BillCommonService.writeInfo2Model((DynamicObject)((DynamicObject)entryEntity.get(vaInfoVo.getRowIndex())), (DynamicObject)view.getModel().getDataEntity());
        }
        if (notLeave) {
            VaInfoService.notLeaveInit(view, vaInfoVo, isLactation);
            return;
        }
        if (isLactation) {
            DynamicObject matchBaseSet = vaEntityCheckService.getBaseSetDy();
            VaInfoService.cacheBreastDateTypes(pageCache, matchBaseSet);
            VaLactationTimeStorage timeStorage = VaInfoService.updateLactationInfo(vaInfoVo, view, matchBaseSet);
            if ((timeStorage.getFetuses() == 0 || WTCStringUtils.isEmpty((String)timeStorage.getBornDate()) || " ~ ".equals(timeStorage.getBornDate())) && status != OperationStatus.VIEW) {
                view.showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u751f\u80b2\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VaInfoService_14", (String)"wtc-wtabm-business", (Object[])new Object[0]));
                view.setVisible(Boolean.valueOf(false), new String[]{"flexpanelap11"});
                return;
            }
            view.setVisible(Boolean.valueOf(true), new String[]{"flexpanelap11"});
            billResponse = vaEntityCheckService.checkApplyTime(data);
            if (billResponse.isSuccess()) {
                List detailPreviewVos = vaInfoVo.getDetailList();
                billResponse = VaBillCheckService.checkSpecialTimes(timeStorage.getOffTimePerDay(), detailPreviewVos);
            }
        } else {
            billResponse = VaInfoService.commonFillVaInfoVo(vaInfoVo, vaEntityCheckService, data);
        }
        pageCache.put("startdate", WTCDateUtils.date2Str((Date)vaInfoVo.getStartDate(), (String)"yyyy-MM-dd"));
        pageCache.put("enddate", WTCDateUtils.date2Str((Date)vaInfoVo.getEndDate(), (String)"yyyy-MM-dd"));
        if (billResponse.isSuccess()) {
            VaAutoOperator billAutoOperator;
            model.setValue("unit", (Object)data.getUnit());
            model.setValue("vatime", (Object)data.getTimeByUnit());
            model.setValue("applytime", (Object)data.getDesc());
            List mustInput = vaEntityCheckService.getMustInput();
            FieldEdit control = Objects.nonNull(vaTypeEnum) ? (FieldEdit)view.getControl("lactatreasontext") : (FieldEdit)view.getControl("reasontext");
            control.setMustInput(!CollectionUtils.isEmpty((Collection)mustInput));
            if (!CollectionUtils.isEmpty((Collection)billResponse.getMessage())) {
                view.showTipNotification((String)billResponse.getMessage().get(0));
            }
            if (!(billResponse = VaInfoService.checkBillRepeat(view, billAutoOperator = (VaAutoOperator)vaEntityCheckService.getBillAutoOperator(), vaInfoVo)).isSuccess() && status != OperationStatus.VIEW) {
                String errorMsg = (String)billResponse.getMessage().get(0);
                view.showTipNotification(errorMsg);
            }
        } else {
            if (CollectionUtils.isEmpty((Collection)billResponse.getMessage())) {
                return;
            }
            if (status != OperationStatus.VIEW) {
                view.showTipNotification((String)billResponse.getMessage().get(0));
            }
        }
    }

    private static void notLeaveInit(IFormView view, VaInfoVo vaInfoVo, boolean isLactation) {
        BillApplyTimeResult data = new BillApplyTimeResult();
        data.setUnit(vaInfoVo.getUnit());
        IDataModel model = view.getModel();
        model.setValue("unit", (Object)data.getUnit());
        model.setValue("vatime", (Object)data.getTimeByUnit());
        model.setValue("applytime", (Object)data.getDesc());
        if (isLactation) {
            VaLactationTimeStorage lactationTimeStorage = (VaLactationTimeStorage)JSON.parseObject((String)vaInfoVo.getVaLactationTimeStorageJson(), VaLactationTimeStorage.class);
            Label label = (Label)view.getControl("lactationdesc");
            label.setText(VaKDStringHelper.lactationDesc(lactationTimeStorage.getFetuses(), lactationTimeStorage.getBornDate(), lactationTimeStorage.getLactationEndDate(), lactationTimeStorage.getOffTimePerDay()));
            view.getModel().setValue("lactationtimejson", (Object)JSON.toJSONString((Object)lactationTimeStorage));
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
            if (WTCCollections.isNotEmpty((Collection)entryEntity)) {
                for (int index = 0; index < entryEntity.size(); ++index) {
                    model.setValue("perapplytime", (Object)0, index);
                }
            }
        }
    }

    private static BillResponse commonFillVaInfoVo(VaInfoVo vaInfoVo, VaEntityCheckService vaEntityCheckService, BillApplyTimeResult data) {
        BillApplyTimeResult applyTime = new BillApplyTimeResult();
        applyTime.setValDay(vaInfoVo.getEntryVaTimeDay());
        applyTime.setValHour(vaInfoVo.getEntryVaTimeHour());
        applyTime.setUnit(vaInfoVo.getUnit());
        BillResponse billResponse = vaEntityCheckService.checkApplyTime(applyTime);
        data.setValDay(vaInfoVo.getEntryVaTimeDay());
        data.setValHour(vaInfoVo.getEntryVaTimeHour());
        data.setUnit(vaInfoVo.getUnit());
        return billResponse;
    }

    private static void specialLactationFlilVaInVo(IDataModel model, VaInfoVo vaInfoVo, BillApplyTimeResult data, IPageCache pageCache) {
        data.setUnit(vaInfoVo.getUnit());
        BigDecimal day = BigDecimal.ZERO;
        BigDecimal hour = BigDecimal.ZERO;
        List detailPreviewVos = vaInfoVo.getDetailList();
        for (VaDetailPreviewVo detailPreviewVo : detailPreviewVos) {
            day = day.add(detailPreviewVo.getApplyTimeDay());
            hour = hour.add(detailPreviewVo.getApplyTimeHour());
        }
        data.setValHour(hour);
        data.setValDay(day);
        pageCache.put("vaLactationApplyTimes", JSON.toJSONString((Object)detailPreviewVos));
        BaseSetTimeBreastDayTypeEnum baseSetTimeBreastDayTypeEnum = BaseSetTimeBreastDayTypeEnum.getById((long)vaInfoVo.getSpecialVaMethod());
        if (Objects.equals(BaseSetTimeBreastDayTypeEnum.CUSTOM, baseSetTimeBreastDayTypeEnum)) {
            VaInfoService.fullVaInfoEntry(detailPreviewVos, model);
        }
    }

    public static VaLactationTimeStorage updateLactationInfo(IFormView view, DynamicObject matchBaseSet) {
        VaInfoVo vaInfoVo = new VaInfoVo();
        DynamicObject dataEntity = view.getModel().getDataEntity();
        DynamicObject personDy = dataEntity.getDynamicObject("attpersonid");
        if (personDy != null) {
            vaInfoVo.setAttPersonId(personDy.getLong("id"));
        }
        vaInfoVo.setVaLactationTimeStorageJson(dataEntity.getString("lactationtimejson"));
        return VaInfoService.updateLactationInfo(vaInfoVo, view, matchBaseSet);
    }

    private static VaLactationTimeStorage updateLactationInfo(VaInfoVo vaInfoVo, IFormView view, DynamicObject matchBaseSet) {
        VaLactationTimeStorage lactationTimeStorage = VaEntityCheckService.generateLactationInfo(vaInfoVo.getAttPersonId(), matchBaseSet);
        VaLactationTimeStorage timeStorage = (VaLactationTimeStorage)JSON.parseObject((String)vaInfoVo.getVaLactationTimeStorageJson(), VaLactationTimeStorage.class);
        if (timeStorage != null) {
            lactationTimeStorage.setTimeStartOne(timeStorage.getTimeStartOne()).setTimeEndOne(timeStorage.getTimeEndOne()).setTimeStartTwo(timeStorage.getTimeStartTwo()).setTimeEndTwo(timeStorage.getTimeEndTwo()).setTimeStartThree(timeStorage.getTimeStartThree()).setTimeEndThree(timeStorage.getTimeEndThree()).setTimeStartFour(timeStorage.getTimeStartFour()).setTimeEndFour(timeStorage.getTimeEndFour()).setTimeStartFive(timeStorage.getTimeStartFive()).setTimeEndFive(timeStorage.getTimeEndFive());
        }
        Label label = (Label)view.getControl("lactationdesc");
        label.setText(VaKDStringHelper.lactationDesc(lactationTimeStorage.getFetuses(), lactationTimeStorage.getBornDate(), lactationTimeStorage.getLactationEndDate(), lactationTimeStorage.getOffTimePerDay()));
        view.getModel().setValue("lactationtimejson", (Object)JSON.toJSONString((Object)lactationTimeStorage));
        return lactationTimeStorage;
    }

    public static void timeCustomRangeInit(IFormView view, VaLactationTimeStorage timeStorage) {
        List<VaInfoTimeFiledVo> voList = VaInfoService.transformVaInfo(timeStorage);
        LinkedList<VaInfoTimeFiledVo> visibleList = new LinkedList<VaInfoTimeFiledVo>();
        LinkedList<VaInfoTimeFiledVo> unVisibleList = new LinkedList<VaInfoTimeFiledVo>();
        LinkedList<VaInfoTimeFiledVo> showList = new LinkedList<VaInfoTimeFiledVo>();
        for (VaInfoTimeFiledVo vaInfoTimeFiledVo : voList) {
            VaInfoService.initTimeRangeControl(vaInfoTimeFiledVo, view);
            if (vaInfoTimeFiledVo.isVisible()) {
                visibleList.add(vaInfoTimeFiledVo);
                if (!vaInfoTimeFiledVo.visible()) continue;
                showList.add(vaInfoTimeFiledVo);
                continue;
            }
            unVisibleList.add(vaInfoTimeFiledVo);
        }
        VaInfoService.updateVisibleCache(view, visibleList, unVisibleList, timeStorage);
        VaInfoService.customerEntryShow(showList, view);
    }

    public static void updateVisibleCache(IFormView view, List<VaInfoTimeFiledVo> visibleList, List<VaInfoTimeFiledVo> unVisibleList, VaLactationTimeStorage timeStorage) {
        IPageCache pageCache = view.getPageCache();
        ArrayList<VaInfoTimeFiledVo> vos = new ArrayList<VaInfoTimeFiledVo>(16);
        vos.addAll(visibleList);
        vos.addAll(unVisibleList);
        VaInfoService.buildVaLactationTimeStorage(timeStorage, vos);
        HashMap<String, String> cache = new HashMap<String, String>(16);
        cache.put("UNVISIBLE_LIST", JSON.toJSONString(unVisibleList));
        cache.put("VISIBLE_LIST", JSON.toJSONString(visibleList));
        String timeStorageJson = JSON.toJSONString((Object)timeStorage);
        view.getModel().setValue("lactationtimejson", (Object)timeStorageJson);
        pageCache.put(cache);
    }

    private static void buildVaLactationTimeStorage(VaLactationTimeStorage timeStorage, List<VaInfoTimeFiledVo> vos) {
        if (vos.size() >= 5) {
            timeStorage.setTimeStartOne(vos.get(0).getTimeStart()).setTimeEndOne(vos.get(0).getTimeEnd()).setTimeStartTwo(vos.get(1).getTimeStart()).setTimeEndTwo(vos.get(1).getTimeEnd()).setTimeStartThree(vos.get(2).getTimeStart()).setTimeEndThree(vos.get(2).getTimeEnd()).setTimeStartFour(vos.get(3).getTimeStart()).setTimeEndFour(vos.get(3).getTimeEnd()).setTimeStartFive(vos.get(4).getTimeStart()).setTimeEndFive(vos.get(4).getTimeEnd());
        }
    }

    public static void updateVisibleCache(IFormView view, List<VaInfoTimeFiledVo> visibleList, List<VaInfoTimeFiledVo> unVisibleList) {
        VaLactationTimeStorage timeStorage = (VaLactationTimeStorage)JSON.parseObject((String)view.getModel().getDataEntity().getString("lactationtimejson"), VaLactationTimeStorage.class);
        VaInfoService.updateVisibleCache(view, visibleList, unVisibleList, timeStorage);
    }

    public static void initTimeRangeControl(VaInfoTimeFiledVo vaInfoTimeFiledVo, IFormView view) {
        IDataModel model = view.getModel();
        VaInfoTimeFieldEnum timeFieldEnum = vaInfoTimeFiledVo.getTimeFieldEnum();
        TimeRangeEdit edit = (TimeRangeEdit)view.getControl(timeFieldEnum.controlKey);
        view.setVisible(Boolean.valueOf(vaInfoTimeFiledVo.isVisible()), new String[]{timeFieldEnum.controlKey});
        model.setValue(edit.getStartDateFieldKey(), (Object)vaInfoTimeFiledVo.getTimeStart());
        model.setValue(edit.getEndDateFieldKey(), (Object)vaInfoTimeFiledVo.getTimeEnd());
    }

    public static List<VaInfoTimeFiledVo> transformVaInfo(VaLactationTimeStorage timeStorage) {
        if (timeStorage == null) {
            return Collections.emptyList();
        }
        ArrayList<VaInfoTimeFiledVo> resList = new ArrayList<VaInfoTimeFiledVo>(16);
        for (VaInfoTimeFieldEnum fieldEnum : WtabmVaInfoConstants.FORM_VIEW_TIME_RANGE_FILED_LIST) {
            resList.add(VaInfoService.fullInfoMap(fieldEnum, timeStorage));
        }
        return resList;
    }

    private static VaInfoTimeFiledVo fullInfoMap(VaInfoTimeFieldEnum vaInfoTimeFieldEnum, VaLactationTimeStorage timeStorage) {
        VaInfoTimeFiledVo vo = new VaInfoTimeFiledVo();
        vo.setTimeFieldEnum(vaInfoTimeFieldEnum);
        switch (vaInfoTimeFieldEnum) {
            case TIME_FIELD_1: {
                return vo.setTimeStart(timeStorage.getTimeStartOne()).setTimeEnd(timeStorage.getTimeEndOne()).setVisible(true);
            }
            case TIME_FIELD_2: {
                return vo.setTimeStart(timeStorage.getTimeStartTwo()).setTimeEnd(timeStorage.getTimeEndTwo()).setVisible(true);
            }
            case TIME_FIELD_3: {
                return vo.setTimeStart(timeStorage.getTimeStartThree()).setTimeEnd(timeStorage.getTimeEndThree()).setVisible(vo.visible());
            }
            case TIME_FIELD_4: {
                return vo.setTimeStart(timeStorage.getTimeStartFour()).setTimeEnd(timeStorage.getTimeEndFour()).setVisible(vo.visible());
            }
            case TIME_FIELD_5: {
                return vo.setTimeStart(timeStorage.getTimeStartFive()).setTimeEnd(timeStorage.getTimeEndFive()).setVisible(vo.visible());
            }
        }
        return null;
    }

    public static void customerEntryShow(List<VaInfoTimeFiledVo> showCol, IFormView view) {
        if (showCol.isEmpty()) {
            view.setVisible(Boolean.TRUE, new String[]{((VaInfoTimeFieldEnum)WtabmVaInfoConstants.FORM_ENTRY_TIME_RANGE_FILED_LIST.get((int)0)).controlKey});
            view.setVisible(Boolean.TRUE, new String[]{((VaInfoTimeFieldEnum)WtabmVaInfoConstants.FORM_ENTRY_TIME_RANGE_FILED_LIST.get((int)1)).controlKey});
        }
        HashSet<Integer> set = new HashSet<Integer>(5);
        for (VaInfoTimeFiledVo vaInfoTimeFiledVo : showCol) {
            set.add(WtabmVaInfoConstants.FORM_VIEW_TIME_RANGE_FILED_LIST.indexOf(vaInfoTimeFiledVo.getTimeFieldEnum()));
        }
        for (int i = 0; i < WtabmVaInfoConstants.FORM_ENTRY_TIME_RANGE_FILED_LIST.size(); ++i) {
            VaInfoTimeFieldEnum vaInfoTimeFieldEnum = (VaInfoTimeFieldEnum)WtabmVaInfoConstants.FORM_ENTRY_TIME_RANGE_FILED_LIST.get(i);
            view.setVisible(Boolean.valueOf(set.contains(i)), new String[]{vaInfoTimeFieldEnum.controlKey});
        }
    }

    @Deprecated
    public static BillResponse checkBillRepeat(IFormView view, VaInfoVo vo) {
        return BillResponse.success();
    }

    public static BillResponse checkBillRepeat(IFormView view, VaAutoOperator vaAutoOperator, VaInfoVo vo) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        IFormView parentView = view.getViewNoPlugin(formShowParameter.getParentPageId());
        if (parentView == null) {
            String errorMsg = ResManager.loadKDString((String)"\u9875\u9762\u52a0\u8f7d\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"VaInfoService_3", (String)"wtc-wtabm-business", (Object[])new Object[0]);
            return BillResponse.error((Object)"", Collections.singletonList(errorMsg));
        }
        DynamicObject billDyn = parentView.getModel().getDataEntity(true);
        String actionId = null;
        if (formShowParameter.getCloseCallBack() != null) {
            actionId = formShowParameter.getCloseCallBack().getActionId();
        }
        OperationStatus status = OperationStatus.EDIT;
        if (StringUtils.equalsAny((CharSequence)actionId, (CharSequence[])new CharSequence[]{"newentry"})) {
            status = OperationStatus.ADDNEW;
        }
        DynamicObject bill = VaInfoService.generateVaApplyBill(billDyn, vo, status, null);
        ArrayList dyList = Lists.newArrayList((Object[])new DynamicObject[]{bill});
        VaBillRepeatService repeatService = new VaBillRepeatService();
        OnCheckVaApplyOverlapEvent onCheckVaApplyRepeatEvent = VaApplyExtHelper.onCalVaRepeat();
        VaRepeatExtensionParam vaRepeatParam = new VaRepeatExtensionParam(dyList, new UnifyBillApplyAttr(), onCheckVaApplyRepeatEvent.getNeedNotCheckedOverlapVaTypes());
        vaRepeatParam.setUseStartOrEnd(vaAutoOperator.isUseStartOrEnd());
        String billStyle = parentView.getModel().getDataEntity().getString("billstyle");
        BillFailInfo billFailInfo = new BillFailInfo(WTCCollections.modifiableEmptyMap());
        if (!WTCStringUtils.equals((String)billStyle, (String)BillOpenStyleEnum.SINGLE.getCode())) {
            billFailInfo = repeatService.checkStagingBillRepeat(vaRepeatParam);
        }
        if (billFailInfo.getErrorInfos().isEmpty()) {
            billFailInfo = repeatService.checkHisBillRepeat(vaRepeatParam);
            if (billFailInfo.getErrorInfos().isEmpty()) {
                return BillResponse.success();
            }
            return BillResponse.error(null, Collections.singletonList(billFailInfo.getErrorInfos().get(billDyn.getLong("id"))));
        }
        String errorMsg = VaKDStringHelper.repeatWithAddedEntry();
        return BillResponse.error(null, Collections.singletonList(errorMsg));
    }

    public static DynamicObject generateVaApplyBill(DynamicObject billDyn, VaInfoVo vaInfoVo, OperationStatus status, DynamicObject matchRule) {
        DynamicObject copiedBill = new DynamicObject(billDyn.getDynamicObjectType());
        HRDynamicObjectUtils.copy((DynamicObject)billDyn, (DynamicObject)copiedBill);
        copiedBill.set("id", (Object)billDyn.getLong("id"));
        DynamicObjectCollection billEntries = copiedBill.getDynamicObjectCollection("entryentity");
        billEntries.clear();
        DynamicObjectCollection billEntryList = billDyn.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : billEntryList) {
            DynamicObject copiedEntry = billEntries.addNew();
            HRDynamicObjectUtils.copy((DynamicObject)entry, (DynamicObject)copiedEntry);
            copiedEntry.set("id", (Object)entry.getLong("id"));
        }
        DynamicObject entry = WTCStringUtils.equals((String)BillOpenStyleEnum.SINGLE.getCode(), (String)vaInfoVo.getBillStyle()) ? (WTCCollections.isEmpty((Collection)billEntries) ? billEntries.addNew() : (DynamicObject)billEntries.get(vaInfoVo.getRowIndex())) : (status == OperationStatus.ADDNEW ? billEntries.addNew() : (DynamicObject)billEntries.get(vaInfoVo.getRowIndex()));
        VaApplyService.genEntryEntities(vaInfoVo, entry);
        Date entryStart = entry.getDate("entrystartdate");
        Date entryEnd = entry.getDate("entryenddate");
        if (copiedBill.getDate("startdate") == null || copiedBill.getDate("startdate").after(entryStart)) {
            copiedBill.set("startdate", (Object)entryStart);
        }
        if (copiedBill.getDate("enddate") == null || copiedBill.getDate("enddate").before(entryEnd)) {
            copiedBill.set("enddate", (Object)entryEnd);
        }
        entry.set("id", (Object)vaInfoVo.getId());
        if (matchRule != null) {
            boolean isDisposable = matchRule.getBoolean("isdisposable");
            entry.set("isdisposable", (Object)isDisposable);
        }
        return copiedBill;
    }

    @Deprecated
    public BillResponse checkDisposable(IFormView vaInfoView, VaEntityCheckService checkService, VaInfoVo vo) {
        return BillResponse.success();
    }

    public FrozenResult tryFrozen(VaEntityCheckService checkService, DynamicObject billDyn) {
        LOG.info("\u3010PC\u4f11\u5047\u7533\u8bf7\u5206\u5f55\u7f16\u8f91\u9875\u3011\u8c03\u7528\u8bd5\u6263\u51cf\u6821\u9a8c\u5b9a\u989d\u5b9a\u989d\u5047\u63a5\u53e3\u5f00\u59cb.");
        ArrayList dyList = Lists.newArrayList((Object[])new DynamicObject[]{billDyn});
        UnifyBillApplyAttr billApplyAttr = checkService.getBillApplyAttr();
        VaBillCheckService vaBillCheckService = new VaBillCheckService(ApplyBillCheckEnum.VACATION, UnifyBillEnum.VA, (List<DynamicObject>)dyList, billApplyAttr);
        FrozenResult frozenResult = VaBaseService.getInstance().freezeVAQuota(billDyn, "TRYFROZEN", vaBillCheckService.getAutoOperator());
        return frozenResult;
    }

    public static VaInfoVo getVaInfoVoFromShowParam(IFormView view) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String vaInfoVoStr = (String)customParams.get("VA_INFO_VO");
        return (VaInfoVo)SerializationUtils.deSerializeFromBase64((String)vaInfoVoStr);
    }

    public static VaInfoVo getVaInfoVoFromModel(IFormView view, BillApplyTimeResult timeResult) {
        String applyTimes;
        VaLactationTimeStorage timeStorage;
        VaInfoVo originalVaInfo = VaInfoService.getVaInfoVoFromShowParam(view);
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        VaInfoVo vaInfoVo = new VaInfoVo();
        vaInfoVo.setBillStyle(originalVaInfo.getBillStyle());
        vaInfoVo.setId(dataEntity.getLong("id"));
        vaInfoVo.setEntryValidTimeDay(BigDecimal.ZERO);
        vaInfoVo.setEntryValidTimeHour(BigDecimal.ZERO);
        vaInfoVo.setAttFileBoid(dataEntity.getLong("attfileboid"));
        vaInfoVo.setRowIndex(dataEntity.getInt("rowindex"));
        vaInfoVo.setAttPersonId(dataEntity.getLong("attpersonid.id"));
        vaInfoVo.setEndDate(dataEntity.getDate("enddate"));
        vaInfoVo.setStartDate(dataEntity.getDate("startdate"));
        vaInfoVo.setVacationType(dataEntity.getLong("vacationtype.id"));
        vaInfoVo.setVacationName(dataEntity.getString("vacationtype.name"));
        vaInfoVo.setEntryVaTimeDay(timeResult.getValDay());
        vaInfoVo.setEntryVaTimeHour(timeResult.getValHour());
        vaInfoVo.setUnit(timeResult.getUnit());
        vaInfoVo.setApplyTime(timeResult.getTimeByUnit());
        vaInfoVo.setEntryReason(dataEntity.getString("reasontext"));
        vaInfoVo.setEndMethod(dataEntity.getString("endmethod"));
        vaInfoVo.setStartMethod(dataEntity.getString("startmethod"));
        vaInfoVo.setOwnDate(dataEntity.getDate("owndate"));
        vaInfoVo.setParentBillId(dataEntity.getLong("parentid"));
        vaInfoVo.setEntryParentId(dataEntity.getLong("entryparentid"));
        WTCPageCache pageCache = new WTCPageCache(view.getPageCache());
        String nonQtApplyCache = pageCache.get("WTABM_CACHENONAPPLY");
        if (StringUtils.isNotEmpty((CharSequence)nonQtApplyCache)) {
            List caches = (List)SerializationUtils.deSerializeFromBase64((String)nonQtApplyCache);
            vaInfoVo.setNonQtApplyCaches(caches);
        }
        ArrayList<VaInfoTimeFiledVo> vos = new ArrayList<VaInfoTimeFiledVo>(16);
        String visibleList = pageCache.get("VISIBLE_LIST");
        String unVisibleList = pageCache.get("UNVISIBLE_LIST");
        if (WTCStringUtils.isNotEmpty((String)visibleList) && WTCStringUtils.isNotEmpty((String)unVisibleList)) {
            vos.addAll(JSON.parseArray((String)visibleList, VaInfoTimeFiledVo.class));
            vos.addAll(JSON.parseArray((String)unVisibleList, VaInfoTimeFiledVo.class));
        }
        if ((timeStorage = (VaLactationTimeStorage)JSON.parseObject((String)view.getModel().getDataEntity().getString("lactationtimejson"), VaLactationTimeStorage.class)) != null && BigDecimal.ZERO.compareTo(timeStorage.getOffTimePerDay()) != 0) {
            vaInfoVo.setEntryReason(dataEntity.getString("lactatreasontext"));
            VaInfoService.buildVaLactationTimeStorage(timeStorage, vos);
        }
        vaInfoVo.setVaLactationTimeStorageJson(JSON.toJSONString((Object)timeStorage));
        vaInfoVo.setSpecialVaType(dataEntity.getString("spvacationtype"));
        DynamicObject vaLactationType = dataEntity.getDynamicObject("valactattype");
        if (Objects.nonNull(vaLactationType)) {
            vaInfoVo.setSpecialVaMethod(vaLactationType.getLong("id"));
        }
        if ((applyTimes = pageCache.get("vaLactationApplyTimes")) != null) {
            vaInfoVo.setDetailList(JSON.parseArray((String)applyTimes, VaDetailPreviewVo.class));
            if (vaInfoVo.getDetailList() != null) {
                BigDecimal day = BigDecimal.ZERO;
                BigDecimal hour = BigDecimal.ZERO;
                for (VaDetailPreviewVo detailPreviewVo : vaInfoVo.getDetailList()) {
                    day = day.add(detailPreviewVo.getApplyTimeDay());
                    hour = hour.add(detailPreviewVo.getApplyTimeHour());
                }
                timeResult.setValDay(day);
                timeResult.setValHour(hour);
                vaInfoVo.setEntryVaTimeDay(day);
                vaInfoVo.setEntryVaTimeHour(hour);
                vaInfoVo.setApplyTime(timeResult.getTimeByUnit());
            }
        }
        return vaInfoVo;
    }

    public static void calculateVaInfoDetail(IFormView view, Date startdate, Date enddate, VaEntityCheckService vaEntityCheckService) {
        IPageCache pageCache = view.getPageCache();
        IDataModel model = view.getModel();
        BillApplyTimeResult result = new BillApplyTimeResult();
        VaInfoVo voFromModel = VaInfoService.getVaInfoVoFromModel(view, result);
        model.setValue("lactationtimejson", (Object)voFromModel.getVaLactationTimeStorageJson());
        DynamicObject baseSetDy = vaEntityCheckService.getBaseSetDy();
        VaLactationTimeStorage timeStorage = VaInfoService.updateLactationInfo(view, baseSetDy);
        if (timeStorage.getFetuses() == 0 || StringUtils.isEmpty((CharSequence)timeStorage.getBornDate()) || " ~ ".equals(timeStorage.getBornDate())) {
            view.showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u751f\u80b2\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VaInfoService_02", (String)"wtc-wtabm-business", (Object[])new Object[0]));
            view.setVisible(Boolean.valueOf(false), new String[]{"flexpanelap11"});
            return;
        }
        view.setVisible(Boolean.valueOf(true), new String[]{"flexpanelap11"});
        Date lactationEnd = WTCDateUtils.str2Date((String)timeStorage.getLactationEndDate(), (String)"yyyy-MM-dd");
        Date bornDate = WTCDateUtils.str2Date((String)timeStorage.getBornDate(), (String)"yyyy-MM-dd");
        BillResponse response = VaEntityCheckService.getDateRangeTips(startdate, enddate, lactationEnd, bornDate);
        if (!response.isSuccess()) {
            view.showTipNotification((String)response.getMessage().get(0));
            return;
        }
        result.setUnit(baseSetDy.getString("unit"));
        response = vaEntityCheckService.genVaSubEntity();
        if (!response.isSuccess()) {
            view.showTipNotification((String)response.getMessage().get(0));
            return;
        }
        List detailPreviewVos = (List)response.getData();
        BigDecimal day = BigDecimal.ZERO;
        BigDecimal hour = BigDecimal.ZERO;
        for (VaDetailPreviewVo detailPreviewVo : detailPreviewVos) {
            day = day.add(detailPreviewVo.getApplyTimeDay());
            hour = hour.add(detailPreviewVo.getApplyTimeHour());
        }
        BillResponse billResponse = VaBillCheckService.checkSpecialTimes(timeStorage.getOffTimePerDay(), detailPreviewVos);
        if (billResponse.isSuccess()) {
            result.setValDay(day);
            result.setValHour(hour);
            model.setValue("vatime", (Object)result.getTimeByUnit());
            model.setValue("unit", (Object)result.getUnit());
            model.setValue("applytime", (Object)result.getDesc());
            VaInfoService.fullVaInfoEntry(detailPreviewVos, model);
            pageCache.put("vaLactationApplyTimes", JSON.toJSONString((Object)detailPreviewVos));
        } else {
            List message = billResponse.getMessage();
            view.showTipNotification((String)message.get(0));
        }
    }

    public static WtcTimeRangeModel initWtcTimeRangeModel(VaInfoVo vaInfoVo, WtcTimeRangeTypeEnum rangeTypeEnum) {
        if (vaInfoVo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u4fe1\u606f\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"VaInfoService_12", (String)"wtc-wtabm-business", (Object[])new Object[0]));
        }
        WtcTimeRangeModel wtcTimeRangeModel = new WtcTimeRangeModel();
        WtcTimeRangeArgsModel args = new WtcTimeRangeArgsModel();
        args.setType(rangeTypeEnum.value);
        ArrayList<String> dates = new ArrayList<String>();
        args.setBtnType(WtcTimeRangeBtnTypeEnum.getCodeByValue((String)vaInfoVo.getVaMethod()));
        args.setStartMethod(WtcTimeRangeBtnTypeEnum.getCodeByValue((String)vaInfoVo.getStartMethod()));
        args.setEndMethod(WtcTimeRangeBtnTypeEnum.getCodeByValue((String)vaInfoVo.getEndMethod()));
        wtcTimeRangeModel.setEvent(WtcTimeRangeEventEnum.INIT.value);
        wtcTimeRangeModel.setArgs(args);
        wtcTimeRangeModel.setTimestamp(new Date().getTime());
        args.setDate(dates);
        if (vaInfoVo.getStartDate() == null && vaInfoVo.getEndDate() == null) {
            dates.add(null);
            dates.add(null);
            VaInfoService.handleApplyTimeType(vaInfoVo, args);
            return wtcTimeRangeModel;
        }
        String startDateStr = null;
        String endDateStr = null;
        if (StringUtils.equalsAny((CharSequence)vaInfoVo.getStartMethod(), (CharSequence[])new CharSequence[]{WtcTimeRangeBtnTypeEnum.DAY.value, WtcTimeRangeBtnTypeEnum.HALF_UP.value, WtcTimeRangeBtnTypeEnum.HALF_DOWN.value})) {
            if (vaInfoVo.getStartDate() != null) {
                startDateStr = WTCDateUtils.date2Str((Date)vaInfoVo.getStartDate(), (String)"yyyy-MM-dd");
            }
            if (vaInfoVo.getEndDate() != null) {
                endDateStr = WTCDateUtils.date2Str((Date)vaInfoVo.getEndDate(), (String)"yyyy-MM-dd");
            }
        } else {
            if (vaInfoVo.getStartDate() != null) {
                startDateStr = WTCDateUtils.date2Str((Date)vaInfoVo.getStartDate(), (String)"yyyy-MM-dd HH:mm");
            }
            if (vaInfoVo.getEndDate() != null) {
                endDateStr = WTCDateUtils.date2Str((Date)vaInfoVo.getEndDate(), (String)"yyyy-MM-dd HH:mm");
            }
        }
        dates.add(startDateStr);
        dates.add(endDateStr);
        VaInfoService.handleApplyTimeType(vaInfoVo, args);
        return wtcTimeRangeModel;
    }

    private static void handleApplyTimeType(VaInfoVo vaInfoVo, WtcTimeRangeArgsModel args) {
        WtcTimeRangeControlService controlService = WtcTimeRangeControlService.getInstance();
        ApplyTimeTypeParam applyTimeTypeParam = new ApplyTimeTypeParam();
        applyTimeTypeParam.setEntity("wtbd_vacationtype");
        applyTimeTypeParam.setApplyTimeTypeField("applytimetype");
        applyTimeTypeParam.setJumpStepField("jumpstep");
        applyTimeTypeParam.setTypeId(Long.valueOf(vaInfoVo.getVacationType()));
        applyTimeTypeParam.setAttFileBoId(vaInfoVo.getAttFileBoid());
        applyTimeTypeParam.setOriStartTime(vaInfoVo.getStartDate());
        applyTimeTypeParam.setOriEndTime(vaInfoVo.getEndDate());
        applyTimeTypeParam.setOriStartBtnTypeEnum(WtcTimeRangeBtnTypeEnum.getEnumByValue((String)vaInfoVo.getStartMethod()));
        applyTimeTypeParam.setOriEndBtnTypeEnum(WtcTimeRangeBtnTypeEnum.getEnumByValue((String)vaInfoVo.getEndMethod()));
        applyTimeTypeParam.setDisableTip(controlService.getDisableTip(BillTypeEnum.VACATIONBILL.getBillName()));
        controlService.setApplyTimeTypeData(applyTimeTypeParam, args);
    }

    public static void fullVaInfoEntry(List<VaDetailPreviewVo> detailPreviewVos, IDataModel dataModel) {
        dataModel.deleteEntryData("entryentity");
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        model.beginInit();
        for (int index = 0; index < detailPreviewVos.size(); ++index) {
            VaDetailPreviewVo vaDetailPreviewVo = detailPreviewVos.get(index);
            tvs.set("vaperdate", (Object)vaDetailPreviewVo.getDate(), index);
            List itemVos = vaDetailPreviewVo.getItemVos();
            TreeMap fieldEnum = WtabmVaInfoConstants.FORM_ENTRY_TIME_RANGE_FILED_LIST.stream().collect(Collectors.toMap(ele -> ele.index, element -> element, (element1, element2) -> element1, TreeMap::new));
            for (VaDetailItemPreviewVo itemVo : itemVos) {
                int start = WTCDateUtils.getSecondsOfDay((Date)itemVo.getStartTime());
                int end = WTCDateUtils.getSecondsOfDay((Date)itemVo.getEndTime());
                VaInfoTimeFieldEnum timeFieldEnum = fieldEnum.getOrDefault(itemVo.getRowSeq(), VaInfoTimeFieldEnum.TIME_FIELD_6);
                if (timeFieldEnum == null) continue;
                tvs.set(timeFieldEnum.startKey, (Object)start, index);
                tvs.set(timeFieldEnum.endKey, (Object)end, index);
                tvs.set(timeFieldEnum.applyTime, (Object)itemVo.getApplyTimeHour(), index);
                tvs.set(timeFieldEnum.applyDay, (Object)itemVo.getApplyTimeDay(), index);
            }
            tvs.set("perapplytime", (Object)vaDetailPreviewVo.getApplyTimeHour(), index);
            tvs.set("perunit", (Object)vaDetailPreviewVo.getUnit(), index);
        }
        model.endInit();
        model.batchCreateNewEntryRow("entryentity", tvs);
    }

    public static BillApplyTimeResult genVaDetail(VaEntityCheckService checkHelper, Date ownDate, Date startDateTime, Date endDateTime, List<Tuple<DutyShift, Shift>> dutyShiftsRanges) {
        SpecialVaTimeDto specialVaTimeDto = new SpecialVaTimeDto(WTCDateUtils.toLocalDateTime((Date)startDateTime), WTCDateUtils.toLocalDateTime((Date)endDateTime));
        BillApplyTimeResult standardTimeResult = VaEntityCheckService.calCustomVaApplyTime(checkHelper.getBaseSetDy(), dutyShiftsRanges, startDateTime, endDateTime, ownDate);
        BillApplyTimeResult billApplyTimeResult = VaInfoService.onVaCalTimesExt(checkHelper.getAttfileBo(), checkHelper.getDyObject(), checkHelper.getBaseSetDy(), dutyShiftsRanges, specialVaTimeDto, standardTimeResult);
        if (billApplyTimeResult == null) {
            billApplyTimeResult = standardTimeResult;
        }
        LOG.info("\u624b\u52a8\u4fee\u6539\u4f11\u5047\u660e\u7ec6\uff0c date:{}, startDateTime:{}, endDateTime\uff1a{}, res\uff1a{}", new Object[]{ownDate, startDateTime, endDateTime, billApplyTimeResult});
        return billApplyTimeResult;
    }

    @Deprecated
    public static BillApplyTimeResult onVaCalTimesExt(long attFileBoId, DynamicObject dyObject, DynamicObject baseSetDyn, List<Tuple<DutyShift, Shift>> dutyShiftsRange, SpecialVaTimeDto specialVaTimeDto) {
        return VaInfoService.onVaCalTimesExt(attFileBoId, dyObject, baseSetDyn, dutyShiftsRange, specialVaTimeDto, null);
    }

    public static BillApplyTimeResult onVaCalTimesExt(long attFileBoId, DynamicObject dyObject, DynamicObject baseSetDyn, List<Tuple<DutyShift, Shift>> dutyShiftsRange, SpecialVaTimeDto specialVaTimeDto, BillApplyTimeResult standardTimeResult) {
        WTCPluginProxy vaTimeCalProxy = WTCPluginProxyFactory.create(VaApplyTimeCalExtPlugin.class, (String)"kd.sdk.wtc.wtabm.business.va.VaApplyTimeCalExtPlugin");
        if (vaTimeCalProxy.hasPlugin()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("\u3010\u4f11\u5047\u7533\u8bf7\u65f6\u957f\u8ba1\u7b97\u3011\u8c03\u7528\u4e8c\u5f00\u57cb\u70b9\u63d2\u4ef6\u8ba1\u7b97\u7533\u8bf7\u65f6\u957f.");
            }
            OnCalVaApplyTimeEventExtImpl onCalVaApplyTimeEvent = new OnCalVaApplyTimeEventExtImpl(attFileBoId, dyObject, baseSetDyn, dutyShiftsRange, specialVaTimeDto, standardTimeResult);
            vaTimeCalProxy.invokeReplace(timeCalExtPlugin -> timeCalExtPlugin.onCalVaApplyTimes(onCalVaApplyTimeEvent));
            if (!onCalVaApplyTimeEvent.isCancel()) {
                VaTimeResult vaTimeResult = onCalVaApplyTimeEvent.getVaTimeResult();
                String unit = baseSetDyn.getString("unit");
                BillApplyTimeResult calResult = new BillApplyTimeResult();
                if (vaTimeResult.getValHour() != null) {
                    calResult.setValHour(vaTimeResult.getValHour());
                }
                if (vaTimeResult.getValDay() != null) {
                    calResult.setValDay(vaTimeResult.getValDay());
                }
                calResult.setUnit(unit);
                return calResult;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("\u3010\u4f11\u5047\u7533\u8bf7\u65f6\u957f\u8ba1\u7b97\u3011\u8c03\u7528\u4e8c\u5f00\u57cb\u70b9\u63d2\u4ef6\u53d6\u6d88\u4e86\u8ba1\u7b97\u7533\u8bf7\u65f6\u957f\uff0c\u4f7f\u7528\u6807\u54c1\u65f6\u957f\u903b\u8f91.");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u3010\u4f11\u5047\u7533\u8bf7\u65f6\u957f\u8ba1\u7b97\u3011\u65e0\u4e8c\u5f00\u57cb\u70b9\u63d2\u4ef6\uff0c\u4f7f\u7528\u6807\u54c1\u65f6\u957f\u903b\u8f91.");
        }
        return null;
    }

    public static BillResponse checkSpecialTimes(List<VaInfoTimeFiledVo> visibleTimeFileVos) {
        if (visibleTimeFileVos.isEmpty()) {
            return BillResponse.success();
        }
        BillResponse response = new BillResponse();
        response.setSuccess(true);
        ArrayList<VaInfoTimeFiledVo> generateList = new ArrayList<VaInfoTimeFiledVo>(4);
        VaInfoTimeFiledVo first = visibleTimeFileVos.get(0);
        if (first.getTimeStart() == -1 || first.getTimeEnd() == -1) {
            response.setSuccess(false);
            response.setMessage(Collections.singletonList(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u65f6\u95f4\u8303\u56f4\uff0c\u518d\u751f\u6210\u4f11\u5047\u660e\u7ec6\u3002", (String)"VaInfoService_1", (String)"wtc-wtabm-business", (Object[])new Object[0])));
            return response;
        }
        generateList.add(first);
        for (int i = 1; i < visibleTimeFileVos.size(); ++i) {
            VaInfoTimeFiledVo timeFiledVo = visibleTimeFileVos.get(i);
            if (timeFiledVo.getTimeStart() == -1 || timeFiledVo.getTimeEnd() == -1) continue;
            generateList.add(timeFiledVo);
        }
        for (VaInfoTimeFiledVo curCheck : generateList) {
            if (curCheck.getTimeEnd() > curCheck.getTimeStart()) continue;
            response.setSuccess(false);
            response.setMessage(Collections.singletonList(ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"VaInfoTimeFieldEdit_02", (String)"wtc-wtabm-business", (Object[])new Object[0])));
            return response;
        }
        for (VaInfoTimeFiledVo curCheck : generateList) {
            for (VaInfoTimeFiledVo needCheck : generateList) {
                if (curCheck == needCheck) continue;
                if (curCheck.getTimeEnd() <= curCheck.getTimeStart()) {
                    response.setSuccess(false);
                    response.setMessage(Collections.singletonList(ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"VaInfoTimeFieldEdit_02", (String)"wtc-wtabm-business", (Object[])new Object[0])));
                    return response;
                }
                if (curCheck.getTimeEnd() <= needCheck.getTimeStart() || curCheck.getTimeStart() >= needCheck.getTimeEnd()) continue;
                response.setSuccess(false);
                int index = WtabmVaInfoConstants.FORM_VIEW_TIME_RANGE_FILED_LIST.indexOf(curCheck.getTimeFieldEnum());
                response.setMessage(Collections.singletonList(ResManager.loadKDString((String)"\u65f6\u95f4\u8303\u56f4\u4e4b\u95f4\u5b58\u5728\u91cd\u53e0\uff0c\u8bf7\u8c03\u6574\u3002", (String)"VaInfoService_2", (String)"wtc-wtabm-business", (Object[])new Object[]{index + 1})));
                return response;
            }
        }
        response.setData(generateList);
        return response;
    }

    public static boolean dateRangeCheck(Date startDate, Date endDate, IFormView view) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        boolean selfAdd = dataEntity.getBoolean("selfadd");
        if (startDate == null || endDate == null || selfAdd) {
            VaInfoService.showTipNotification(view, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u4f11\u5047\u5f00\u59cb\u65f6\u95f4~\u7ed3\u675f\u65f6\u95f4\u201d\u3002", (String)"VaInfoService_4", (String)"wtc-wtabm-business", (Object[])new Object[0]));
            WtcTimeRangeModel wtcTimeRangeModel = new WtcTimeRangeModel();
            wtcTimeRangeModel.setEvent(WtcTimeRangeEventEnum.GET_DATA.value);
            wtcTimeRangeModel.setTimestamp(System.currentTimeMillis());
            CustomControl customControl = (CustomControl)view.getControl("wtctimerange");
            customControl.setData((Object)wtcTimeRangeModel);
            return true;
        }
        return false;
    }

    private static void showTipNotification(IFormView iFormView, String message) {
        VaInfoVo vaInfoVo = VaInfoService.getVaInfoVoFromShowParam(iFormView);
        String billStyle = vaInfoVo.getBillStyle();
        IFormView view = iFormView;
        if (BillOpenStyleEnum.SINGLE.getCode().equals(billStyle)) {
            view = iFormView.getParentView();
        }
        view.showTipNotification(message);
    }

    public static void lactationControlInit(IFormView view, BillEntityCheckService billCommonCheckHelper, boolean isLactation) {
        VaInfoService.lactationControlInit(view, billCommonCheckHelper, isLactation, false);
    }

    public static void lactationControlInit(IFormView view, BillEntityCheckService billCommonCheckHelper, boolean isLactation, boolean selfAdd) {
        FieldEdit control = (FieldEdit)view.getControl("lactatreasontext");
        List mustInput = billCommonCheckHelper.getMustInput();
        control.setMustInput(!CollectionUtils.isEmpty((Collection)mustInput) && isLactation);
        control = (FieldEdit)view.getControl("valactattype");
        control.setMustInput(isLactation);
        DateRangeEdit dateRangeEdit = (DateRangeEdit)view.getControl("lactatdaterange");
        dateRangeEdit.setMustInput(isLactation);
        Date startDate = view.getModel().getDataEntity().getDate("startdate");
        Date endDate = view.getModel().getDataEntity().getDate("enddate");
        if (startDate != null && endDate != null && isLactation) {
            startDate = WTCDateUtils.getZeroDate((Date)startDate);
            endDate = WTCDateUtils.getZeroDate((Date)endDate);
            if (!selfAdd) {
                view.getModel().setValue("lactatstart", (Object)startDate);
                view.getModel().setValue("lactatend", (Object)endDate);
            }
            view.getModel().setValue("startdate", (Object)startDate);
            view.getModel().setValue("enddate", (Object)endDate);
        }
    }

    public static boolean isNeedCheckAttFileAuth(IFormView view) {
        String applyTypeRadio;
        boolean needCheckAttFileAuth = true;
        IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
        if (parentView != null && StringUtils.equals((CharSequence)(applyTypeRadio = parentView.getModel().getDataEntity().getString("applytyperadio")), (CharSequence)"0")) {
            needCheckAttFileAuth = false;
        }
        return needCheckAttFileAuth;
    }

    public static void cacheBreastDateTypes(IPageCache pageCache, DynamicObject vaBaseSet) {
        DynamicObjectCollection breastDayTypeData = vaBaseSet.getDynamicObjectCollection("breastdaytypedata");
        String breastDataTypeIds = breastDayTypeData.stream().map(dyn -> dyn.getString("fbasedataid_id")).collect(Collectors.joining(","));
        pageCache.put("breastdaytypedata", breastDataTypeIds);
    }
}

