/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.business.vaapply.batch;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.id.ID;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtabm.common.batch.BatchVaTimeVo;
import kd.wtc.wtabm.common.constants.batch.BatchVaKDString;
import kd.wtc.wtabm.common.entity.vaapply.EndTimeVo;
import kd.wtc.wtabm.common.entity.vaapply.StartTimeVo;
import kd.wtc.wtbs.business.bill.batchbill.BatchBillUnifyService;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.bean.annotations.SingletonBean;
import kd.wtc.wtbs.common.bill.batchbill.BatchBillKDString;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.proxy.Joiner;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtp.enums.vaplan.BaseSetTimeUnitEnum;

@SingletonBean
public class BatchVaApplyService
extends HRBaseServiceHelper {
    public static BatchVaApplyService INSTANCE = new BatchVaApplyService();

    public BatchVaApplyService() {
        super("wtabm_batchvaapply");
    }

    public FormShowParameter getBatchVaInfoForm(boolean isEdit) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("wtabm_batchvainfo");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (isEdit) {
            formShowParameter.setStatus(OperationStatus.EDIT);
        } else {
            formShowParameter.setStatus(OperationStatus.ADDNEW);
        }
        return formShowParameter;
    }

    public void fillVaEntryInfo(IFormView view, int selectIndex) {
        IDataModel model = view.getModel();
        model.beginInit();
        DynamicObjectCollection entryColl = model.getEntryEntity("entryentity");
        if (selectIndex >= 0 && entryColl.size() > selectIndex) {
            DynamicObject entryDy = (DynamicObject)entryColl.get(selectIndex);
            this.fillVaEntryInfo(entryDy);
            return;
        }
        for (DynamicObject entryDy : entryColl) {
            this.fillVaEntryInfo(entryDy);
        }
        model.endInit();
    }

    private void fillVaEntryInfo(DynamicObject entryDy) {
        DynamicObjectCollection subEntryColl = entryDy.getDynamicObjectCollection("subentryentity");
        if (WTCCollections.isEmpty((Collection)subEntryColl)) {
            return;
        }
        DynamicObject subEntryDy = (DynamicObject)subEntryColl.get(0);
        Date startDate = subEntryDy.getDate("entrystartdate");
        Date endDate = subEntryDy.getDate("entryenddate");
        String startMethod = subEntryDy.getString("entrystartmethod");
        String endMethod = subEntryDy.getString("entryendmethod");
        StartTimeVo startTimeVo = new StartTimeVo(startDate, startMethod);
        EndTimeVo endTimeVo = new EndTimeVo(endDate, endMethod);
        entryDy.set("startdatestr", (Object)JSON.toJSONString((Object)startTimeVo));
        entryDy.set("enddatestr", (Object)JSON.toJSONString((Object)endTimeVo));
        String unit = subEntryDy.getString("entryunit");
        entryDy.set("applytime", StringUtils.equals((CharSequence)BaseSetTimeUnitEnum.DATE.code, (CharSequence)unit) ? subEntryDy.get("entryvatimeday") : subEntryDy.get("entryvatimehour"));
        DynamicObject attFileF7 = entryDy.getDynamicObject("attfilebasef7");
        entryDy.set("personid", attFileF7.get("attperson"));
        entryDy.set("attfile", attFileF7.get("boid"));
        entryDy.set("attfile_id", attFileF7.get("boid"));
        DynamicObjectCollection vaTypeColl = entryDy.getDynamicObjectCollection("vacationtypelist");
        DynamicObject dynamicObject = WTCCollections.isEmpty((Collection)vaTypeColl) ? vaTypeColl.addNew() : (DynamicObject)vaTypeColl.get(0);
        dynamicObject.set("fbasedataid", subEntryDy.get("entryvacationtype"));
    }

    public void fillVaEntryDateInfo(IFormView view, int selectIndex) {
        IDataModel model = view.getModel();
        model.beginInit();
        DynamicObjectCollection entryColl = model.getEntryEntity("entryentity");
        if (selectIndex >= 0 && entryColl.size() > selectIndex) {
            DynamicObject entryDy = (DynamicObject)entryColl.get(selectIndex);
            this.fillVaEntryDateInfo(model, entryDy, selectIndex);
            return;
        }
        for (int idx = 0; idx < entryColl.size(); ++idx) {
            this.fillVaEntryDateInfo(model, (DynamicObject)entryColl.get(idx), idx);
        }
        model.endInit();
    }

    private void fillVaEntryDateInfo(IDataModel model, DynamicObject entryDy, int selectIndex) {
        String endDateStr;
        String startDateStr;
        DynamicObjectCollection subEntryColl = entryDy.getDynamicObjectCollection("subentryentity");
        if (WTCCollections.isEmpty((Collection)subEntryColl)) {
            return;
        }
        DynamicObject subEntryDy = (DynamicObject)subEntryColl.get(0);
        String startMethod = subEntryDy.getString("entrystartmethod");
        String endMethod = subEntryDy.getString("entryendmethod");
        Date startDate = subEntryDy.getDate("entrystartdate");
        Date endDate = subEntryDy.getDate("entryenddate");
        if (HRStringUtils.equalsIgnoreCase((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.DAY.value)) {
            startDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startDate);
            endDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endDate);
        } else if (HRStringUtils.equalsIgnoreCase((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.CUSTOM.value)) {
            startDateStr = WTCInteDateUtil.formatBySysTzAndUserFmt((Date)startDate);
            endDateStr = WTCInteDateUtil.formatBySysTzAndUserFmt((Date)endDate);
        } else {
            String startMethodStr = HRStringUtils.equalsIgnoreCase((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) ? ResManager.loadKDString((String)"\u4e0a\u534a\u5929", (String)"VaApplyService_05", (String)"wtc-wtabm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0b\u534a\u5929", (String)"VaApplyService_06", (String)"wtc-wtabm-business", (Object[])new Object[0]);
            String endMethodStr = HRStringUtils.equalsIgnoreCase((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) ? ResManager.loadKDString((String)"\u4e0a\u534a\u5929", (String)"VaApplyService_05", (String)"wtc-wtabm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0b\u534a\u5929", (String)"VaApplyService_06", (String)"wtc-wtabm-business", (Object[])new Object[0]);
            startDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startDate) + " " + startMethodStr;
            endDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endDate) + " " + endMethodStr;
        }
        model.setValue("startdateshowstr", (Object)startDateStr, selectIndex);
        model.setValue("enddateshowstr", (Object)endDateStr, selectIndex);
        BigDecimal applyTime = entryDy.getBigDecimal("applytime");
        if (applyTime != null) {
            model.setValue("applytime", (Object)applyTime.setScale(2, RoundingMode.HALF_UP), selectIndex);
        }
        Object attFileName = entryDy.get("attfilebasef7.textname");
        model.setValue("attfilename", attFileName, selectIndex);
    }

    public void refreshVaInfoSummary(IFormView view) {
        Label sumVaTimeLbl;
        List<BatchVaTimeVo> vaTimeVos = this.statVaPersonAndTime(view);
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        Label countPersonLbl = (Label)view.getControl("labelsumperson");
        if (countPersonLbl != null) {
            int countPerson = dataEntity.getInt("countperson");
            countPersonLbl.setText(BatchVaKDString.totalPersonLbl((int)countPerson));
        }
        if ((sumVaTimeLbl = (Label)view.getControl("labelsumtime")) == null) {
            return;
        }
        if (WTCCollections.isEmpty(vaTimeVos)) {
            sumVaTimeLbl.setText("-");
        } else {
            HashMap groupByVaTypeMap = Maps.newHashMapWithExpectedSize((int)8);
            for (BatchVaTimeVo vaTimeVo : vaTimeVos) {
                String vaTypeName = vaTimeVo.getVacationTypeName();
                Map map = groupByVaTypeMap.computeIfAbsent(vaTypeName, item -> new HashMap(4));
                String unit = vaTimeVo.getVaTimeUnit();
                List vaTimes = map.computeIfAbsent(unit, item -> new ArrayList(16));
                vaTimes.add(vaTimeVo);
            }
            ArrayList<String> vaTimeDescList = new ArrayList<String>(groupByVaTypeMap.size());
            String twoBlackSpace = "&nbsp;&nbsp;";
            for (Map.Entry entry : groupByVaTypeMap.entrySet()) {
                String vaTypeName = (String)entry.getKey();
                Map byUnitMap = (Map)entry.getValue();
                String unit = BaseSetTimeUnitEnum.DATE.code;
                BigDecimal sumVaTime = BigDecimal.ZERO;
                if (byUnitMap.size() == 1) {
                    Iterator iterator = byUnitMap.entrySet().iterator();
                    if (iterator.hasNext()) {
                        Map.Entry next = iterator.next();
                        List vaTimes = (List)next.getValue();
                        unit = (String)next.getKey();
                        sumVaTime = this.sumVaTime(vaTimes, BaseSetTimeUnitEnum.DATE.code.equals(unit));
                    }
                } else {
                    ArrayList<BatchVaTimeVo> vaTimes = new ArrayList<BatchVaTimeVo>(byUnitMap.size());
                    Iterator iterator = byUnitMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        vaTimes.addAll((Collection)iterator.next().getValue());
                    }
                    sumVaTime = this.sumVaTime(vaTimes, true);
                }
                String vaTimeDesc = vaTypeName + twoBlackSpace + sumVaTime + twoBlackSpace + BaseSetTimeUnitEnum.getLocalName((String)unit);
                vaTimeDescList.add(vaTimeDesc);
            }
            if (WTCCollections.isNotEmpty(vaTimeDescList)) {
                String vaTimeDesc = Joiner.on((String)WTCSymbolMultiLanguageUtil.getCommonSymbol()).join(vaTimeDescList);
                sumVaTimeLbl.setText(vaTimeDesc);
            }
        }
        view.updateView("flexvasummary");
    }

    private List<BatchVaTimeVo> statVaPersonAndTime(IFormView view) {
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        DynamicObjectCollection entryColl = model.getEntryEntity("entryentity");
        HashSet attFileIds = Sets.newHashSetWithExpectedSize((int)entryColl.size());
        BigDecimal totalVaTimeDay = BigDecimal.ZERO;
        BigDecimal totalVaTiemHour = BigDecimal.ZERO;
        ArrayList<BatchVaTimeVo> vaTimeVos = new ArrayList<BatchVaTimeVo>(16);
        for (DynamicObject entryDy : entryColl) {
            BigDecimal vaTime;
            DynamicObjectCollection subEntryColl = entryDy.getDynamicObjectCollection("subentryentity");
            if (WTCCollections.isEmpty((Collection)subEntryColl)) continue;
            DynamicObject subEntryDy = (DynamicObject)subEntryColl.get(0);
            BigDecimal vaTimeDay = subEntryDy.getBigDecimal("entryvatimeday");
            BigDecimal vaTimeHour = subEntryDy.getBigDecimal("entryvatimehour");
            String unit = subEntryDy.getString("entryunit");
            BigDecimal bigDecimal = vaTime = StringUtils.equals((CharSequence)BaseSetTimeUnitEnum.DATE.code, (CharSequence)unit) ? vaTimeDay : vaTimeHour;
            if (vaTime.compareTo(BigDecimal.ZERO) > 0) {
                long attFileId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entryDy, (String)"attfile");
                attFileIds.add(attFileId);
            }
            totalVaTimeDay = totalVaTimeDay.add(vaTimeDay);
            totalVaTiemHour = totalVaTiemHour.add(vaTimeHour);
            vaTimeVos.add(new BatchVaTimeVo(subEntryDy.getLong("entryvacationtype.id"), subEntryDy.getString("entryvacationtype.name"), vaTimeDay, vaTimeHour, unit));
        }
        model.setValue("countperson", (Object)attFileIds.size());
        model.setValue("totaltimeinday", (Object)totalVaTimeDay);
        model.setValue("totaltimeinhour", (Object)totalVaTiemHour);
        model.endInit();
        return vaTimeVos;
    }

    private BigDecimal sumVaTime(List<BatchVaTimeVo> vaTimes, boolean byDay) {
        BigDecimal sum = BigDecimal.ZERO;
        for (BatchVaTimeVo vaTimeDy : vaTimes) {
            if (byDay) {
                sum = sum.add(vaTimeDy.getVaTimeDay());
                continue;
            }
            sum = sum.add(vaTimeDy.getVaTimeHour());
        }
        return sum.setScale(2, RoundingMode.HALF_UP);
    }

    public BillResponse checkBatchVaMaxEntry(IDataModel model, int hasCount) {
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection vaInfoEntryColl = dataEntity.getDynamicObjectCollection("entryentity");
        int batchVaMaxEntry = BatchBillUnifyService.getInstance().batchVaMaxEntry();
        String errorMsg = "";
        if (vaInfoEntryColl.size() + hasCount > batchVaMaxEntry) {
            errorMsg = BatchVaKDString.outMaxCountEntry((int)batchVaMaxEntry);
        }
        return BillResponse.emptyIsSuccess((String)errorMsg);
    }

    public void loseEfficacyEntry(IDataModel model, DynamicObject entry, Integer focusRowIndex) {
        DynamicObjectCollection subEntries = entry.getDynamicObjectCollection("subentryentity");
        if (!subEntries.isEmpty()) {
            for (DynamicObject subEntry : subEntries) {
                subEntry.set("entryvatimeday", (Object)0);
                subEntry.set("entryvatimehour", (Object)0);
            }
        }
        model.setValue("applytime", (Object)0, focusRowIndex.intValue());
        model.setValue("isnotleave", (Object)true, focusRowIndex.intValue());
    }

    public BillResponse checkDataRule(DynamicObject dataEntity) {
        DynamicObjectCollection vaInfoColl;
        Object adminOrg;
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        String errorMsg = "";
        BillResponse billResponse = BillResponse.success();
        Object org = dataEntity.get("org");
        if (org == null) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)"org");
            errorMsg = MessageFormat.format(BatchBillKDString.mustInputAsk(), property.getDisplayName());
            billResponse = BillResponse.emptyIsSuccess((String)errorMsg);
        }
        if (billResponse.isSuccess() && (adminOrg = dataEntity.get("adminorg")) == null) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)"adminorg");
            errorMsg = MessageFormat.format(BatchBillKDString.mustInputAsk(), property.getDisplayName());
            billResponse = BillResponse.emptyIsSuccess((String)errorMsg);
        }
        if (billResponse.isSuccess() && WTCCollections.isEmpty((Collection)(vaInfoColl = dataEntity.getDynamicObjectCollection("entryentity")))) {
            errorMsg = BatchVaKDString.pleaseInputVaInfo();
            billResponse = BillResponse.emptyIsSuccess((String)errorMsg);
        }
        return billResponse;
    }

    public void fillEntryId(DynamicObject batchVaDy) {
        if (batchVaDy == null) {
            return;
        }
        DynamicObjectCollection vaInfoEntryColl = batchVaDy.getDynamicObjectCollection("entryentity");
        List enptyEntryIds = vaInfoEntryColl.stream().filter(item -> item.getLong("id") == 0L).collect(Collectors.toList());
        if (WTCCollections.isNotEmpty(enptyEntryIds)) {
            long[] ids = ID.genLongIds((int)enptyEntryIds.size());
            for (int index = 0; index < enptyEntryIds.size(); ++index) {
                DynamicObject subEntryEntity;
                DynamicObject vaInfoEntryDy = (DynamicObject)enptyEntryIds.get(index);
                vaInfoEntryDy.set("id", (Object)ids[index]);
                DynamicObjectCollection subEntryEntityColl = vaInfoEntryDy.getDynamicObjectCollection("subentryentity");
                if (!WTCCollections.isNotEmpty((Collection)subEntryEntityColl) || (subEntryEntity = (DynamicObject)subEntryEntityColl.get(0)).getLong("id") != 0L) continue;
                subEntryEntity.set("id", (Object)ids[index]);
            }
        }
    }

    public void refreshVaTime(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        Date startDate = dataEntity.getDate("startdate");
        Date endDate = dataEntity.getDate("enddate");
        if (startDate == null || endDate == null) {
            model.setValue("applytimetxt", (Object)"-");
        } else {
            Object vaType = dataEntity.get("vacationtype");
            if (vaType != null) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("triggerFrom", "dateChange");
                view.invokeOperation("ensure", option);
                this.setVaTimeText(model);
                view.updateView("flexpanelap3");
            }
        }
    }

    public void setVaTimeText(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection vaInfoColl = dataEntity.getDynamicObjectCollection("entryentity");
        if (WTCCollections.isNotEmpty((Collection)vaInfoColl)) {
            DynamicObject vaInfoDy = (DynamicObject)vaInfoColl.get(0);
            String unit = vaInfoDy.getString("unit");
            BigDecimal vaTimeDay = vaInfoDy.getBigDecimal("vatimeday");
            BigDecimal vaTimeHour = vaInfoDy.getBigDecimal("vatimehour");
            String vaTime = BaseSetTimeUnitEnum.DATE.code.equalsIgnoreCase(unit) ? vaTimeDay.setScale(2, RoundingMode.HALF_UP) + BaseSetTimeUnitEnum.DATE.name.loadKDString() : (BaseSetTimeUnitEnum.HOUR.code.equals(unit) ? vaTimeHour.setScale(2, RoundingMode.HALF_UP) + BaseSetTimeUnitEnum.HOUR.name.loadKDString() : "-");
            model.setValue("applytimetxt", (Object)vaTime);
        }
    }
}

