/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.business.vaapply.batch;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtabm.business.va.OnCheckVaApplyOverlapEvent;
import kd.wtc.wtabm.business.bo.VaRepeatExtensionParam;
import kd.wtc.wtabm.business.vaapply.VaApplyExtHelper;
import kd.wtc.wtabm.business.vaapply.VaApplyService;
import kd.wtc.wtabm.business.vaapply.VaBaseService;
import kd.wtc.wtabm.business.vaapply.VaBillRepeatService;
import kd.wtc.wtabm.business.vaapply.batch.BatchVaApplyService;
import kd.wtc.wtabm.business.vaapply.checker.VaBillCheckService;
import kd.wtc.wtabm.common.constants.batch.BatchVaInfoConstants;
import kd.wtc.wtabm.common.constants.batch.BatchVaKDString;
import kd.wtc.wtabm.common.entity.vaapply.EndTimeVo;
import kd.wtc.wtabm.common.entity.vaapply.StartTimeVo;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.batchbill.BatchBillUnifyService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.business.web.applybill.operatecore.va.VaAutoOperator;
import kd.wtc.wtbs.common.bill.batchbill.BatchBillCheckResult;
import kd.wtc.wtbs.common.bill.batchbill.BatchBillKDString;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.enums.bill.unify.BillSourceTypeEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.bill.BillFailInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.time.StopWatch;

public class BatchVaCheckService
implements BatchVaInfoConstants {
    private static final Log LOG = LogFactory.getLog(BatchVaCheckService.class);
    private List<DynamicObject> orgBillDys = new ArrayList<DynamicObject>();
    private List<DynamicObject> repeatBillDys = new ArrayList<DynamicObject>();
    private List<DynamicObject> billDys = new ArrayList<DynamicObject>();
    private List<BillResponse> resp = Lists.newArrayList();
    private List<Long> failBillIds = new ArrayList<Long>();
    private String preFailMsg = BatchBillKDString.errorPrefix();
    private UnifyBillApplyAttr applyAttr;
    private int editIndex = -1;
    private int changeIndex = -1;
    private String opKey;
    private VaAutoOperator vaAutoOperator = null;

    public BatchVaCheckService(String appId, String authEntityId) {
        this(appId, authEntityId, 0L, 0L);
    }

    public BatchVaCheckService(String appId, String authEntityId, long orgId, long adminOrgId) {
        this.applyAttr = new UnifyBillApplyAttr(appId, authEntityId);
        this.applyAttr.setSourceType(BillSourceTypeEnum.BATCH);
        this.applyAttr.setOrgId(Long.valueOf(orgId));
        this.applyAttr.setAdminOrgId(Long.valueOf(adminOrgId));
    }

    public BatchBillCheckResult checkBatchVaInfo(DynamicObject mainDy, DynamicObject repeatDy, int editIndex, String opKey) {
        LOG.info("BatchVaCheckService.checkBatchVaInfo begin");
        StopWatch stopWatch = StopWatch.createStarted();
        this.orgBillDys = this.transferToVaApply(mainDy);
        this.billDys = Lists.newArrayList(this.orgBillDys);
        this.editIndex = editIndex;
        this.opKey = opKey;
        long parentId = 0L;
        if (repeatDy != null) {
            this.repeatBillDys = this.transferBatchVaEntryToVaApply(repeatDy);
            parentId = repeatDy.getLong("parent");
        }
        BatchBillCheckResult check = this.check(parentId);
        stopWatch.stop();
        LOG.info("BatchVaCheckService.checkBatchVaInfo end,cost time:{}", (Object)stopWatch.getTime());
        return check;
    }

    public BatchBillCheckResult checkBatchApply(DynamicObject mainDy, String opKey) {
        LOG.info("BatchVaCheckService.checkBatchApply begin");
        StopWatch stopWatch = StopWatch.createStarted();
        this.orgBillDys = this.transferBatchVaEntryToVaApply(mainDy);
        this.billDys = Lists.newArrayList(this.orgBillDys);
        this.opKey = opKey;
        BatchBillCheckResult check = this.check(mainDy.getLong("parent"));
        stopWatch.stop();
        LOG.info("BatchVaCheckService.checkBatchApply end,cost time:{}", (Object)stopWatch.getTime());
        return check;
    }

    public BatchBillCheckResult checkChange(DynamicObject mainDy, int changeIndex, String opKey) {
        LOG.info("BatchVaCheckService.checkChange begin");
        StopWatch stopWatch = StopWatch.createStarted();
        this.opKey = opKey;
        this.changeIndex = changeIndex;
        this.orgBillDys = this.transferBatchVaEntryToVaApply(mainDy);
        this.billDys = Lists.newArrayList(this.orgBillDys);
        List<DynamicObject> changeVaBills = this.getChangeVaBill();
        if (WTCCollections.isNotEmpty(changeVaBills)) {
            LOG.info("BatchVaCheckService.checkChange.checkAttFileDiscard\uff0csize:{}", (Object)changeVaBills.size());
            this.checkAttFileDiscard(changeVaBills);
        }
        LOG.info("BatchVaCheckService.checkChange.checkBatchVaBiz");
        this.checkBatchVaBiz();
        if (changeIndex < 0) {
            changeVaBills = this.getChangeVaBill();
            if (WTCCollections.isNotEmpty(changeVaBills)) {
                LOG.info("BatchVaCheckService.checkChange.checkBatchVaRepeat\uff0csize:{}", (Object)changeVaBills.size());
                this.checkBatchVaRepeat(changeVaBills, mainDy.getLong("parent"));
            }
            LOG.info("BatchVaCheckService.checkChange.validateQuotaTryFrozen\uff0csize:{}", (Object)changeVaBills.size());
            this.validateQuotaTryFrozen();
        }
        LOG.info("BatchVaCheckService.checkChange.initBatchBillCheckResult");
        BatchBillCheckResult billCheckResult = this.initBatchBillCheckResult();
        stopWatch.stop();
        LOG.info("BatchVaCheckService.checkChange end ,cost time:{}", (Object)stopWatch.getTime());
        return billCheckResult;
    }

    public void invokeQuotaInterface(DynamicObject[] dataEntities, String operationKey) {
        ArrayList<DynamicObject> billDys = new ArrayList<DynamicObject>(16);
        for (DynamicObject batchBillDy : dataEntities) {
            billDys.addAll(this.transferBatchVaEntryToVaApply(batchBillDy));
        }
        VaAutoOperator vaAutoOperator = VaBaseService.getInstance().getVaAutoOperator(billDys, this.applyAttr);
        VaApplyService vaApplyService = new VaApplyService();
        vaApplyService.resetBillEntryDisposable(billDys, vaAutoOperator);
        VaBaseService.getInstance().invokeQuotaInterface(operationKey, billDys, vaAutoOperator, this.applyAttr);
    }

    private BatchBillCheckResult check(long batchBillParentId) {
        LOG.info("BatchVaCheckService.check.checkAttFileDiscard");
        this.checkAttFileDiscard(this.billDys);
        LOG.info("BatchVaCheckService.check.checkBatchVaBiz");
        this.checkBatchVaBiz();
        LOG.info("BatchVaCheckService.check.checkBatchVaRepeat");
        this.checkBatchVaRepeat(this.billDys, batchBillParentId);
        LOG.info("BatchVaCheckService.check.validateQuotaTryFrozen");
        this.validateQuotaTryFrozen();
        LOG.info("BatchVaCheckService.check.initBatchBillCheckResult");
        return this.initBatchBillCheckResult();
    }

    private BatchBillCheckResult initBatchBillCheckResult() {
        ArrayList errorMsgs = new ArrayList(this.billDys.size());
        for (BillResponse billResponse : this.resp) {
            List messages = billResponse.getMessage();
            if (!WTCCollections.isNotEmpty((Collection)messages)) continue;
            errorMsgs.add(messages.get(0));
        }
        BatchBillCheckResult billCheckResult = new BatchBillCheckResult();
        billCheckResult.setFailMessages(errorMsgs);
        billCheckResult.setFailDataIds(this.failBillIds);
        billCheckResult.setData(this.orgBillDys);
        return billCheckResult;
    }

    private void checkAttFileDiscard(List<DynamicObject> checkBillDys) {
        if (WTCCollections.isEmpty(checkBillDys)) {
            return;
        }
        Map discardAttFileMap = BillCommonService.getInstance().getDiscardAttFileBoId(checkBillDys);
        if (WTCCollections.isNotEmpty((Map)discardAttFileMap)) {
            String errMsg = BatchVaKDString.attFileDiscard();
            String errMsgNoName = BatchVaKDString.attFileDiscardNoName();
            Map<Long, List<DynamicObject>> billByAttFileIdMap = checkBillDys.stream().collect(Collectors.groupingBy(item -> item.getLong("attfile.id")));
            for (Map.Entry attFileEntry : discardAttFileMap.entrySet()) {
                Long attFileId = (Long)attFileEntry.getKey();
                List<DynamicObject> discardBillDys = billByAttFileIdMap.get(attFileId);
                for (DynamicObject discardBillDy : discardBillDys) {
                    this.failBillIds.add(discardBillDy.getLong("id"));
                }
                String errorMsg = this.editIndex > -1 ? errMsgNoName : MessageFormat.format(errMsg, ((Tuple)attFileEntry.getValue()).getKey(), ((Tuple)attFileEntry.getValue()).getValue());
                this.resp.add(BillResponse.emptyIsSuccess((String)errorMsg));
            }
        }
        if (WTCCollections.isNotEmpty(this.failBillIds)) {
            this.billDys.removeIf(item -> this.failBillIds.contains(item.getLong("id")));
        }
    }

    private void checkBatchVaBiz() {
        if (WTCCollections.isEmpty(this.billDys)) {
            return;
        }
        this.vaAutoOperator = VaBaseService.getInstance().getVaAutoOperator(this.billDys, this.applyAttr);
        for (DynamicObject billDy : this.billDys) {
            VaBillCheckService vaBillCheckService = new VaBillCheckService(ApplyBillCheckEnum.VACATION, UnifyBillEnum.VA, (List<DynamicObject>)WTCCollections.modifiableList((Object[])new DynamicObject[]{billDy}), (WtcAbstractUnityBillOperator)this.vaAutoOperator, this.applyAttr);
            BillResponse response = vaBillCheckService.checkAll();
            this.resp.add(response);
            List failMsgs = response.getMessage();
            ArrayList<String> batchFailMsgs = new ArrayList<String>(failMsgs.size());
            for (String failMsg : failMsgs) {
                if (this.editIndex < 0) {
                    failMsg = BatchBillUnifyService.getInstance().handleBatchBillFailMsg(billDy, failMsg, this.preFailMsg);
                }
                batchFailMsgs.add(failMsg);
            }
            response.setMessage(batchFailMsgs);
            if (response.isSuccess()) continue;
            this.failBillIds.add(billDy.getLong("id"));
        }
        if (WTCCollections.isNotEmpty(this.failBillIds)) {
            this.billDys.removeIf(item -> this.failBillIds.contains(item.getLong("id")));
        }
    }

    private void checkBatchVaRepeat(List<DynamicObject> checkBillDys, long batchBillParentId) {
        if (WTCCollections.isNotEmpty(checkBillDys)) {
            VaBillRepeatService repeatService = new VaBillRepeatService();
            OnCheckVaApplyOverlapEvent onCheckVaApplyOverlapEvent = VaApplyExtHelper.onCalVaRepeat();
            VaRepeatExtensionParam repeatParam = new VaRepeatExtensionParam(checkBillDys, this.applyAttr, onCheckVaApplyOverlapEvent.getNeedNotCheckedOverlapVaTypes());
            repeatParam.setExpandBillDys(this.repeatBillDys);
            repeatParam.setBillSourceType(BillSourceTypeEnum.BATCH);
            repeatParam.setVaAutoOperator(this.vaAutoOperator);
            repeatParam.setBatchParentId(batchBillParentId);
            BillFailInfo billFailInfo = repeatService.checkStagingBillRepeat(repeatParam);
            if (billFailInfo.getErrorInfos().isEmpty()) {
                billFailInfo = repeatService.checkHisBillRepeat(repeatParam);
            }
            if (!billFailInfo.getErrorInfos().isEmpty()) {
                Map billDyMap = checkBillDys.stream().collect(Collectors.toMap(item -> item.getLong("id"), Function.identity(), (o1, o2) -> o1));
                Map errorInfos = billFailInfo.getErrorInfos();
                for (Map.Entry errorInfoEntry : errorInfos.entrySet()) {
                    DynamicObject billDy;
                    String failMsg = (String)errorInfoEntry.getValue();
                    Long billId = (Long)errorInfoEntry.getKey();
                    if (!HRStringUtils.isNotEmpty((String)failMsg) || (billDy = (DynamicObject)billDyMap.get(billId)) == null) continue;
                    if (this.editIndex < 0) {
                        failMsg = BatchBillUnifyService.getInstance().handleBatchBillFailMsg(billDy, failMsg, this.preFailMsg);
                    }
                    this.resp.add(BillResponse.emptyIsSuccess((String)failMsg));
                    this.failBillIds.add(billId);
                }
            }
            if (WTCCollections.isNotEmpty(this.failBillIds)) {
                this.billDys.removeIf(item -> this.failBillIds.contains(item.getLong("id")));
            }
        }
    }

    private void validateQuotaTryFrozen() {
        if (WTCStringUtils.equals((String)this.opKey, (String)"save") && WTCCollections.isNotEmpty(this.billDys)) {
            if (this.vaAutoOperator == null) {
                this.vaAutoOperator = VaBaseService.getInstance().getVaAutoOperator(this.billDys, this.applyAttr);
            }
            List<BillResponse> billResponses = VaBaseService.getInstance().invokeTryFrozenQuota(this.billDys, this.vaAutoOperator, this.applyAttr);
            for (BillResponse billResponse : billResponses) {
                String failMsg;
                if (billResponse.isSuccess()) continue;
                DynamicObject billDy = (DynamicObject)billResponse.getData();
                String string = failMsg = CollectionUtils.isEmpty((Collection)billResponse.getMessage()) ? "" : (String)billResponse.getMessage().get(0);
                if (HRStringUtils.isNotEmpty((String)failMsg)) {
                    if (this.editIndex < 0) {
                        failMsg = BatchBillUnifyService.getInstance().handleBatchBillFailMsg(billDy, failMsg, this.preFailMsg);
                    }
                    this.resp.add(BillResponse.emptyIsSuccess((String)failMsg));
                }
                this.failBillIds.add(billDy.getLong("id"));
            }
        }
    }

    private List<DynamicObject> transferToVaApply(DynamicObject batchVaInfo) {
        LOG.info("\u3010\u6279\u91cf\u4f11\u5047\u3011\u3010\u4f11\u5047\u4fe1\u606f\u3011\u3010\u786e\u5b9a\u3011\u5206\u5f55\u8f6c\u6362\u4e3a\u4f11\u5047\u5355\u636eDYN\u5f00\u59cb\u3002");
        String startMethod = batchVaInfo.getString("startmethod");
        String endMethod = batchVaInfo.getString("endmethod");
        Date startDate = batchVaInfo.getDate("startdate");
        Date endDate = batchVaInfo.getDate("enddate");
        StartTimeVo startTimeVo = new StartTimeVo(startDate, startMethod);
        EndTimeVo endTimeVo = new EndTimeVo(endDate, endMethod);
        String startDateStr = JSON.toJSONString((Object)startTimeVo);
        String endDateStr = JSON.toJSONString((Object)endTimeVo);
        DynamicObjectCollection attFileEntries = batchVaInfo.getDynamicObjectCollection("entryentity");
        List dynList = WTCCollections.modifiableList((Object[])new DynamicObject[0]);
        MainEntityType billMET = MetadataServiceHelper.getDataEntityType((String)"wtabm_vaapply");
        boolean isChangeBill = batchVaInfo.getBoolean("ischangebill");
        long parentId = batchVaInfo.getLong("parentid");
        boolean isFromDB = batchVaInfo.getBoolean("isfromdb");
        for (int index = 0; index < attFileEntries.size(); ++index) {
            DynamicObject attFileEntry = (DynamicObject)attFileEntries.get(index);
            DynamicObject attFileDyn = attFileEntry.getDynamicObject("attfilebasef7");
            DynamicObject billDyn = new DynamicObject((DynamicObjectType)billMET);
            billDyn.getDataEntityState().setFromDatabase(isFromDB);
            billDyn.set("startdatestr", (Object)startDateStr);
            billDyn.set("enddatestr", (Object)endDateStr);
            billDyn.set("startdate", (Object)startTimeVo.getMinStartDateTime());
            billDyn.set("enddate", (Object)endTimeVo.getMaxEndDateTime());
            billDyn.set("id", attFileEntry.get("entryid"));
            billDyn.set("org", (Object)batchVaInfo.getDynamicObject("org"));
            billDyn.set("personid", attFileEntry.get("personid"));
            billDyn.set("attfile", attFileEntry.get("attfile"));
            billDyn.set("attfilebasef7", (Object)attFileDyn);
            billDyn.set("applytyperadio", (Object)BillApplyTypeEnum.BATCH.getCode());
            billDyn.set("auditstatus", (Object)"A");
            billDyn.set("billstatus", (Object)"A");
            billDyn.set("isneedhand", (Object)false);
            billDyn.set("ischange", (Object)isChangeBill);
            billDyn.set("parentid", (Object)parentId);
            this.createBillEntryDyn(billDyn, batchVaInfo);
            dynList.add(billDyn);
        }
        return dynList;
    }

    private List<DynamicObject> transferBatchVaEntryToVaApply(DynamicObject batchVaBill) {
        BatchVaApplyService.INSTANCE.fillEntryId(batchVaBill);
        boolean isEdit = batchVaBill.getDataEntityState().getFromDatabase();
        DynamicObjectCollection vaInfoEntryColl = batchVaBill.getDynamicObjectCollection("entryentity");
        MainEntityType billMET = MetadataServiceHelper.getDataEntityType((String)"wtabm_vaapply");
        List dynList = WTCCollections.modifiableList((Object[])new DynamicObject[0]);
        boolean isChangeBill = batchVaBill.getBoolean("ischangebill");
        for (int index = 0; index < vaInfoEntryColl.size(); ++index) {
            if (index == this.editIndex || this.changeIndex >= 0 && index != this.changeIndex) continue;
            DynamicObject vaInfoEntryDy = (DynamicObject)vaInfoEntryColl.get(index);
            DynamicObject billDyn = new DynamicObject((DynamicObjectType)billMET);
            long entryId = vaInfoEntryDy.getLong("id");
            billDyn.set("id", (Object)entryId);
            billDyn.getDataEntityState().setFromDatabase(isEdit);
            String billNo = vaInfoEntryDy.getString("entrybillno");
            if (HRStringUtils.isEmpty((String)billNo)) {
                billNo = batchVaBill.getString("billno");
            }
            billDyn.set("billno", (Object)billNo);
            billDyn.set("startdatestr", vaInfoEntryDy.get("startdatestr"));
            billDyn.set("enddatestr", vaInfoEntryDy.get("enddatestr"));
            billDyn.set("startdate", vaInfoEntryDy.get("startdate"));
            billDyn.set("enddate", vaInfoEntryDy.get("enddate"));
            billDyn.set("applytime", vaInfoEntryDy.get("applytime"));
            billDyn.set("unit", vaInfoEntryDy.get("unit"));
            billDyn.set("org", (Object)batchVaBill.getDynamicObject("org"));
            billDyn.set("personid", vaInfoEntryDy.get("personid"));
            billDyn.set("attfile", vaInfoEntryDy.get("attfile"));
            billDyn.set("attfilebasef7", (Object)vaInfoEntryDy.getDynamicObject("attfilebasef7"));
            billDyn.set("applytyperadio", (Object)BillApplyTypeEnum.BATCH.getCode());
            billDyn.set("auditstatus", batchVaBill.get("auditstatus"));
            billDyn.set("billstatus", batchVaBill.get("billstatus"));
            billDyn.set("isneedhand", (Object)false);
            billDyn.set("ischange", (Object)isChangeBill);
            billDyn.set("parentid", (Object)vaInfoEntryDy.getLong("entryparent"));
            DynamicObjectCollection vaBillEntryColl = billDyn.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection subEntryColl = vaInfoEntryDy.getDynamicObjectCollection("subentryentity");
            for (int subIndex = 0; subIndex < subEntryColl.size(); ++subIndex) {
                DynamicObject batchVaSubEntry = (DynamicObject)subEntryColl.get(subIndex);
                DynamicObject vaBillEntry = vaBillEntryColl.addNew();
                vaBillEntry.set("id", batchVaSubEntry.get("id"));
                vaBillEntry.set("seq", (Object)(index + 1));
                vaBillEntry.set("entryvacationtype", batchVaSubEntry.get("entryvacationtype"));
                vaBillEntry.set("entrystartmethod", batchVaSubEntry.get("entrystartmethod"));
                vaBillEntry.set("entryendmethod", batchVaSubEntry.get("entryendmethod"));
                vaBillEntry.set("entrystartdate", batchVaSubEntry.get("entrystartdate"));
                vaBillEntry.set("entryenddate", batchVaSubEntry.get("entryenddate"));
                vaBillEntry.set("owndate", batchVaSubEntry.get("owndate"));
                vaBillEntry.set("entryparentid", batchVaSubEntry.get("entryparentid"));
                vaBillEntry.set("entryunit", batchVaSubEntry.get("entryunit"));
                vaBillEntry.set("entryvatimeday", batchVaSubEntry.get("entryvatimeday"));
                vaBillEntry.set("entryvatimehour", batchVaSubEntry.get("entryvatimehour"));
                vaBillEntry.set("isdisposable", batchVaSubEntry.get("isdisposable"));
            }
            billDyn.set("isnotleave", vaInfoEntryDy.get("isnotleave"));
            dynList.add(billDyn);
        }
        return dynList;
    }

    private void createBillEntryDyn(DynamicObject billDy, DynamicObject batchVaInfo) {
        DynamicObjectCollection entries = billDy.getDynamicObjectCollection("entryentity");
        DynamicObject vaType = batchVaInfo.getDynamicObject("vacationtype");
        String startMethod = batchVaInfo.getString("startmethod");
        String endMethod = batchVaInfo.getString("endmethod");
        Date startDate = batchVaInfo.getDate("startdate");
        Date endDate = batchVaInfo.getDate("enddate");
        DynamicObject newRow = entries.addNew();
        newRow.set("entryvacationtype", (Object)vaType);
        newRow.set("entrystartmethod", (Object)startMethod);
        newRow.set("entryendmethod", (Object)endMethod);
        newRow.set("seq", (Object)1);
        newRow.set("entrystartdate", (Object)startDate);
        newRow.set("entryenddate", (Object)endDate);
        newRow.set("owndate", (Object)endDate);
        newRow.set("entryparentid", batchVaInfo.get("entryparentid"));
    }

    private boolean isChangeBill(DynamicObject mainDy) {
        boolean isChangeBill = false;
        if (mainDy != null && mainDy.containsProperty("ischangebill")) {
            isChangeBill = mainDy.getBoolean("ischangebill");
        }
        return isChangeBill;
    }

    private List<DynamicObject> getChangeVaBill() {
        return this.billDys.stream().filter(item -> !item.getBoolean("isnotleave")).collect(Collectors.toList());
    }
}

