/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.business.vaapply.batch;

import java.util.Collection;
import java.util.Date;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtabm.business.vaapply.VaInfoService;
import kd.wtc.wtabm.business.vaapply.VaKDStringHelper;
import kd.wtc.wtabm.business.vaapply.batch.BatchVaApplyService;
import kd.wtc.wtabm.business.vaapply.batch.BatchVaPropertyHelper;
import kd.wtc.wtabm.common.constants.batch.BatchVaInfoConstants;
import kd.wtc.wtabm.common.constants.batch.BatchVaKDString;
import kd.wtc.wtabm.common.entity.vaapply.VaInfoVo;
import kd.wtc.wtbs.business.bill.batchbill.BatchBillUnifyService;
import kd.wtc.wtbs.business.bill.batchbill.BillPropertyHelper;
import kd.wtc.wtbs.common.bean.annotations.SingletonBean;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeTypeEnum;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.wtctimerange.WtcTimeRangeModel;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;

@SingletonBean
public class BatchVaInfoService
implements BatchVaInfoConstants {
    private static final Log LOG = LogFactory.getLog(BatchVaInfoService.class);

    public BillResponse checkDateRule(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity(true);
        long vaTypeId = dataEntity.getLong("vacationtype.id");
        String startMethod = dataEntity.getString("startmethod");
        String endMethod = dataEntity.getString("endmethod");
        Date startDate = dataEntity.getDate("startdate");
        Date endDate = dataEntity.getDate("enddate");
        String errorMsg = "";
        if (vaTypeId == 0L) {
            errorMsg = VaKDStringHelper.vaTypeMustInput();
        } else if (WTCStringUtils.isEmpty((String)startMethod) || WTCStringUtils.isEmpty((String)endMethod) || startDate == null || endDate == null) {
            errorMsg = VaKDStringHelper.vaTimePeriodMustInput();
        } else if (startDate.after(endDate) || startDate.compareTo(endDate) == 0 && WtcTimeRangeBtnTypeEnum.HALF_DOWN.value.equals(startMethod) && WtcTimeRangeBtnTypeEnum.HALF_UP.value.equals(endMethod)) {
            errorMsg = VaKDStringHelper.vaTimePeriodValid();
        } else {
            DynamicObjectCollection vaInfoColl = dataEntity.getDynamicObjectCollection("entryentity");
            if (WTCCollections.isEmpty((Collection)vaInfoColl)) {
                errorMsg = BatchVaKDString.mustOneVaPerson();
            }
        }
        BillResponse billResponse = BillResponse.emptyIsSuccess((String)errorMsg);
        if (billResponse.isSuccess()) {
            billResponse = this.checkBatchVaDateRange(model);
        }
        if (billResponse.isSuccess()) {
            int hasCount = dataEntity.getInt("countvaentry");
            billResponse = BatchVaApplyService.INSTANCE.checkBatchVaMaxEntry(model, hasCount);
        }
        return billResponse;
    }

    public BillResponse checkBatchVaDateRange(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity(true);
        Date startDate = dataEntity.getDate("startdate");
        Date endDate = dataEntity.getDate("enddate");
        if (startDate == null || endDate == null) {
            return BillResponse.success();
        }
        Date maxVaDate = dataEntity.getDate("maxvadate");
        Date minVaDate = dataEntity.getDate("minvadate");
        if (minVaDate != null && minVaDate.compareTo(startDate) < 0) {
            startDate = minVaDate;
        }
        if (maxVaDate != null && maxVaDate.compareTo(endDate) > 0) {
            endDate = maxVaDate;
        }
        int dateRange = WTCDateUtils.daysBetween((Date)startDate, (Date)endDate) + 1;
        String errorMsg = "";
        int maxDateRange = BatchBillUnifyService.getInstance().batchVaDateRange();
        if (dateRange > maxDateRange) {
            errorMsg = BatchVaKDString.outMaxDateRange((int)maxDateRange);
        }
        return BillResponse.emptyIsSuccess((String)errorMsg);
    }

    public void initEditVaInfoForm(IFormView view) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Object entryCurrentRowIndexObj = formShowParameter.getCustomParam("entryCurrentRowIndex");
        if (entryCurrentRowIndexObj == null) {
            return;
        }
        int entryCurrentRowIndex = Integer.parseInt(String.valueOf(entryCurrentRowIndexObj));
        DynamicObject billModelDy = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)((String)formShowParameter.getCustomParam("sourcedataentity")));
        IDataModel model = view.getModel();
        model.beginInit();
        Map<String, String> billModelPropertyMap = BatchVaPropertyHelper.getVaInfoFromModelPropertyMap();
        BillPropertyHelper billPropertyHelper = new BillPropertyHelper(model, billModelDy, entryCurrentRowIndex);
        billPropertyHelper.setPropertyMap(billModelPropertyMap);
        billPropertyHelper.setModelDataValue();
        model.updateCache();
        view.updateView("contentpanel");
        model.endInit();
        CustomControl customControl = (CustomControl)view.getControl("wtctimerange");
        VaInfoVo vaInfoVo = this.initVaInfoVo(view);
        WtcTimeRangeModel wtcTimeRangeModel = VaInfoService.initWtcTimeRangeModel(vaInfoVo, WtcTimeRangeTypeEnum.EDIT);
        customControl.setData((Object)wtcTimeRangeModel);
    }

    public VaInfoVo initVaInfoVo(IFormView view) {
        DynamicObjectCollection entryEntityColl;
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        VaInfoVo vaInfoVo = new VaInfoVo();
        vaInfoVo.setStartMethod(dataEntity.getString("startmethod"));
        vaInfoVo.setEndMethod(dataEntity.getString("endmethod"));
        vaInfoVo.setStartDate(dataEntity.getDate("startdate"));
        vaInfoVo.setEndDate(dataEntity.getDate("enddate"));
        vaInfoVo.setVacationType(dataEntity.getLong("vacationtype.id"));
        OperationStatus status = view.getFormShowParameter().getStatus();
        long attFileBoId = 0L;
        if (OperationStatus.ADDNEW != status && WTCCollections.isNotEmpty((Collection)(entryEntityColl = dataEntity.getDynamicObjectCollection("entryentity")))) {
            DynamicObject dynamicObject = (DynamicObject)entryEntityColl.get(0);
            attFileBoId = dynamicObject.getLong("attfile.id");
        }
        vaInfoVo.setAttFileBoid(attFileBoId);
        return vaInfoVo;
    }
}

