/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.business.vaapply.checker;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtabm.business.vaapply.VaApplyService;
import kd.wtc.wtabm.business.vaapply.VaKDStringHelper;
import kd.wtc.wtabm.business.vaapply.checker.VaEntityCheckService;
import kd.wtc.wtabm.common.constants.batch.BatchVaKDString;
import kd.wtc.wtbs.business.bill.batchbill.BatchBillUnifyService;
import kd.wtc.wtbs.business.daterange.DateRangeServiceImpl;
import kd.wtc.wtbs.business.daterange.IDateRangeService;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonCurrModel;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonCurrResult;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.business.web.applybill.operatecore.va.VaAutoOperator;
import kd.wtc.wtbs.business.web.applybill.service.BillCheckService;
import kd.wtc.wtbs.business.web.applybill.service.BillEntityCheckService;
import kd.wtc.wtbs.business.web.attendperson.AttendPersonServiceImpl;
import kd.wtc.wtbs.business.web.billservice.baseset.BillBaseStateLessService;
import kd.wtc.wtbs.common.bill.batchbill.BatchBillKDString;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.bill.BaseSetUnitTypeEnum;
import kd.wtc.wtbs.common.enums.bill.BillAdvanceAfterEnum;
import kd.wtc.wtbs.common.enums.bill.BillAdvanceAfterFieldEnum;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.enums.bill.unify.BillSourceTypeEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.enums.bill.va.SpecialVaTypeEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.bill.BillApplyTimeResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillInfoContext;
import kd.wtc.wtbs.common.model.billservice.BillPeriodInfoResp;
import kd.wtc.wtbs.common.model.billservice.BillServiceAdvAfterResp;
import kd.wtc.wtbs.common.model.billservice.BillServiceBaseNewSetInfo;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtabm.common.entity.VaDetailItemPreviewVo;
import kd.wtc.wtbs.wtabm.common.entity.VaDetailPreviewVo;
import kd.wtc.wtbs.wtabm.common.entity.VaLactationTimeStorage;
import kd.wtc.wtbs.wtabm.common.enums.EnClosureLimitEnum;
import kd.wtc.wtbs.wtp.enums.vaplan.BaseSetTimeUnitEnum;

public class VaBillCheckService
extends BillCheckService {
    private static final Log LOG = LogFactory.getLog(BillCheckService.class);
    private HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("wtabm_vaapply");
    private IDateRangeService dateRangeService = (IDateRangeService)WTCAppContextHelper.getBean(DateRangeServiceImpl.class);

    public HRBaseServiceHelper getBaseServiceHelper() {
        return this.baseServiceHelper;
    }

    public void setBaseServiceHelper(HRBaseServiceHelper baseServiceHelper) {
        this.baseServiceHelper = baseServiceHelper;
    }

    public IDateRangeService getDateRangeService() {
        return this.dateRangeService;
    }

    public void setDateRangeService(IDateRangeService dateRangeService) {
        this.dateRangeService = dateRangeService;
    }

    @Deprecated
    public VaBillCheckService(ApplyBillCheckEnum checkEnum, UnifyBillEnum unifyBillEnum, List<DynamicObject> dyList, String attFileF7AuthEntity) {
        super(checkEnum, unifyBillEnum, dyList, null, new UnifyBillApplyAttr("wtam", attFileF7AuthEntity));
    }

    public VaBillCheckService(ApplyBillCheckEnum checkEnum, UnifyBillEnum unifyBillEnum, List<DynamicObject> dyList, UnifyBillApplyAttr applyAttr) {
        super(checkEnum, unifyBillEnum, dyList, null, applyAttr);
    }

    @Deprecated
    public VaBillCheckService(ApplyBillCheckEnum checkEnum, UnifyBillEnum unifyBillEnum, List<DynamicObject> dyList, WtcAbstractUnityBillOperator operator, String attFileF7AuthEntity) {
        super(checkEnum, unifyBillEnum, dyList, operator, new UnifyBillApplyAttr("wtam", attFileF7AuthEntity));
    }

    public VaBillCheckService(ApplyBillCheckEnum checkEnum, UnifyBillEnum unifyBillEnum, List<DynamicObject> dyList, WtcAbstractUnityBillOperator operator, UnifyBillApplyAttr attr) {
        super(checkEnum, unifyBillEnum, dyList, operator, attr);
    }

    @Deprecated
    public VaBillCheckService(ApplyBillCheckEnum checkEnum, UnifyBillEnum unifyBillEnum, List<DynamicObject> dyList, WtcAbstractUnityBillOperator operator, UnifyBillApplyAttr attr, int fromOP) {
        super(checkEnum, unifyBillEnum, dyList, operator, attr);
        if (fromOP == 1) {
            attr.setSourceType(BillSourceTypeEnum.IMPORT);
        }
    }

    public VaAutoOperator getAutoOperator() {
        return (VaAutoOperator)this.getCheck();
    }

    protected WtcAbstractUnityBillOperator initContext(List<DynamicObject> dyList, UnifyBillApplyAttr attr) {
        List unifyBillApplyInfo = VaBillCheckService.createUnifyBillApplyInfo(dyList, (ApplyBillCheckEnum)this.getCheckEnum());
        UnifyBillInfoContext unifyBillInfoContext = new UnifyBillInfoContext(unifyBillApplyInfo, attr);
        return new VaAutoOperator(unifyBillInfoContext);
    }

    public BillResponse checkBillRepeat() {
        BillResponse response = this.checkStagingBillRepeat();
        if (response.isSuccess()) {
            return this.checkHisBillRepeat(this.getDyList());
        }
        return response;
    }

    public BillResponse checkStagingBillRepeat() {
        return BillResponse.success();
    }

    public BillResponse checkHisBillRepeat(List<DynamicObject> dyList) {
        return BillResponse.success();
    }

    protected void setCustomEntry(DynamicObject entry, BillApplyTimeResult timeResult) {
        ApplyBillCheckEnum checkEnum = this.getCheckEnum();
        entry.set("entryvatimeday", (Object)timeResult.getValDay());
        entry.set("entryvatimehour", (Object)timeResult.getValHour());
        entry.set(checkEnum.getUnit(), (Object)timeResult.getUnit());
    }

    protected BillResponse checkSubEntryInfo(DynamicObject billDyn, DynamicObject row, BillEntityCheckService checkService) {
        VaEntityCheckService entityCheckService = (VaEntityCheckService)checkService;
        SpecialVaTypeEnum vaTypeEnum = SpecialVaTypeEnum.getByType((String)row.getString("specialvatype"));
        if (vaTypeEnum != SpecialVaTypeEnum.LACTATION_TYPE) {
            return BillResponse.success();
        }
        String specialTextJson = row.getString("specialextjson");
        VaLactationTimeStorage timeStorage = (VaLactationTimeStorage)JSON.parseObject((String)specialTextJson, VaLactationTimeStorage.class);
        long personId = billDyn.getLong("personid.id");
        VaLactationTimeStorage vaLactationTimeStorage = VaEntityCheckService.generateLactationInfo(personId, entityCheckService.getBaseSetDy());
        if (vaLactationTimeStorage.getFetuses() == 0 || WTCStringUtils.isEmpty((String)vaLactationTimeStorage.getBornDate()) || " ~ ".equals(vaLactationTimeStorage.getBornDate())) {
            String message = ResManager.loadKDString((String)"\u672a\u627e\u5230\u751f\u80b2\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VaBillCheckService_5", (String)"wtc-wtabm-business", (Object[])new Object[0]);
            return BillResponse.error(null, (List)WTCCollections.modifiableList((Object[])new String[]{message}));
        }
        if (timeStorage != null) {
            vaLactationTimeStorage.setTimeStartOne(timeStorage.getTimeStartOne()).setTimeEndOne(timeStorage.getTimeEndOne()).setTimeStartTwo(timeStorage.getTimeStartTwo()).setTimeEndTwo(timeStorage.getTimeEndTwo()).setTimeStartThree(timeStorage.getTimeStartThree()).setTimeEndThree(timeStorage.getTimeEndThree()).setTimeStartFour(timeStorage.getTimeStartFour()).setTimeEndFour(timeStorage.getTimeEndFour()).setTimeStartFive(timeStorage.getTimeStartFive()).setTimeEndFive(timeStorage.getTimeEndFive());
        }
        row.set("specialextjson", (Object)JSON.toJSONString((Object)vaLactationTimeStorage));
        DynamicObjectCollection subEntries = row.getDynamicObjectCollection("vadetailentry");
        BillResponse billResponse = entityCheckService.checkBaseSetBaseInfo();
        LOG.info("\u5b50\u5355\u636e\u4f53\u6570\u636e\u91cd\u7f6e-\u6821\u9a8c\u4f11\u5047\u57fa\u7840\u914d\u7f6e\uff1a{}", (Object)billResponse.isSuccess());
        if (billResponse.isSuccess()) {
            billResponse = entityCheckService.genVaSubEntity();
            LOG.info("\u5b50\u5355\u636e\u4f53\u6570\u636e\u91cd\u7f6e-\u91cd\u65b0\u751f\u6210\u5b50\u5355\u636e\u4f53\u6570\u636e\uff1a{}", (Object)billResponse.isSuccess());
            if (billResponse.isSuccess()) {
                HRBaseServiceHelper wtbdBaseServiceHelper = new HRBaseServiceHelper("wtbd_datetype");
                HashMap<Long, DynamicObject> dateTypeMap = new HashMap<Long, DynamicObject>(16);
                subEntries.clear();
                List detailList = (List)billResponse.getData();
                for (VaDetailPreviewVo previewVo : detailList) {
                    List itemVos = previewVo.getItemVos();
                    for (VaDetailItemPreviewVo itemVo : itemVos) {
                        DynamicObject dateTypeDyn = dateTypeMap.computeIfAbsent(itemVo.getDateTypeId(), dy -> wtbdBaseServiceHelper.loadSingle((Object)itemVo.getDateTypeId()));
                        VaApplyService.fillSubEntry(subEntries, itemVo, dateTypeDyn);
                    }
                }
            } else {
                return billResponse;
            }
        }
        List vaDetailPreviewVos = VaBillCheckService.transFormDetailList((DynamicObjectCollection)subEntries);
        LOG.info("genLactationInfos.vaDetailPreviewVos:{}", (Object)SerializationUtils.toJsonString((Object)vaDetailPreviewVos));
        return VaBillCheckService.checkSpecialTimes(vaLactationTimeStorage.getOffTimePerDay(), vaDetailPreviewVos);
    }

    public static BillResponse checkSpecialTimes(BigDecimal maxApplyHour, List<VaDetailPreviewVo> vaDetailPreviewVos) {
        BillResponse response = new BillResponse();
        response.setSuccess(true);
        StringJoiner joiner = new StringJoiner(",");
        for (VaDetailPreviewVo vaDetailPreviewVo : vaDetailPreviewVos) {
            if (vaDetailPreviewVo.getApplyTimeHour().compareTo(maxApplyHour) <= 0) continue;
            joiner.add(WTCDateUtils.date2Str((Date)vaDetailPreviewVo.getDate(), (String)"yyyy-MM-dd"));
        }
        if (joiner.length() != 0) {
            response.setSuccess(false);
            response.setMessage((List)Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"%s\u7684\u6bcf\u65e5\u7533\u8bf7\u65f6\u957f\u5927\u4e8e\u6bcf\u65e5\u53ef\u4f11\u65f6\u957f\uff0c\u8bf7\u8c03\u6574\u65f6\u95f4\u8303\u56f4\u3002", (String)"VaInfoService_0", (String)"wtc-wtabm-business", (Object[])new Object[]{joiner.toString()})}));
        }
        return response;
    }

    protected VaEntityCheckService getBillEntityCheckService(Long attfileBo, UnifyBillEnum unifyBillEnum, ApplyBillCheckEnum checkEnum, DynamicObject entryPageDyn, String attFileF7AuthEntity) {
        boolean needCheckAttFileAuth = false;
        VaEntityCheckService billEntityCheckService = null;
        VaAutoOperator operator = (VaAutoOperator)this.getCheck();
        boolean anyMatch = this.getDyList().stream().anyMatch(dyn -> dyn.getDynamicObjectCollection("entryentity").contains((Object)entryPageDyn));
        if (anyMatch) {
            billEntityCheckService = VaEntityCheckService.createService(attfileBo, checkEnum, entryPageDyn, needCheckAttFileAuth, operator, this.getBillApplyAttr());
            billEntityCheckService.setCheckApplySpan(true);
        } else {
            billEntityCheckService = VaEntityCheckService.createService((long)attfileBo, checkEnum, entryPageDyn, needCheckAttFileAuth, this.getBillApplyAttr());
            billEntityCheckService.setCheckApplySpan(true);
        }
        return billEntityCheckService;
    }

    protected BillEntityCheckService getBillEntityCheckService(Long attfileBo, DynamicObject entryPageDyn, UnifyBillEnum unifyBillEnum, ApplyBillCheckEnum checkEnum, String attFileF7AuthEntity) {
        boolean needCheckAttFileAuth = false;
        VaEntityCheckService billEntityCheckService = VaEntityCheckService.createService((long)attfileBo, checkEnum, entryPageDyn, needCheckAttFileAuth, this.getBillApplyAttr());
        return billEntityCheckService;
    }

    public BillResponse checkAll() {
        LOG.info("\u4f11\u5047\u5355\u636echeckAll.");
        BillResponse billResponse = this.checkChangeBill();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        for (DynamicObject dynamicObject : this.getDyList()) {
            boolean checkSuccess = this.checkEntryEntityVacationTypes(dynamicObject);
            if (checkSuccess) continue;
            return BillResponse.error((Object)"", (List)WTCCollections.modifiableList((Object[])new String[]{VaKDStringHelper.vacationTypeCheckErr()}));
        }
        billResponse = super.checkAll();
        this.refreshQuotaInfo();
        return billResponse;
    }

    public BillResponse checkAllForImp() {
        LOG.info("\u4f11\u5047\u5355\u636echeckAllForImp.");
        BillResponse billResponse = super.checkAll();
        return billResponse;
    }

    public BillResponse checkAllForOpenApi() {
        LOG.info("\u4f11\u5047\u5355\u636echeckAllForOpenApi.");
        BillResponse billResponse = super.checkAll();
        return billResponse;
    }

    public BillResponse checkAdviceAndAfter() {
        if (BillSourceTypeEnum.BATCH == this.getBillApplyAttr().getSourceType()) {
            BillResponse response = this.maxAdvancePeroidCheck();
            if (response.isSuccess()) {
                response = super.checkAdviceAndAfter();
            }
            return response;
        }
        BillResponse response = super.checkAdviceAndAfter();
        if (response.isSuccess()) {
            response = this.maxAdvancePeroidCheck();
        }
        return response;
    }

    public boolean checkEntryEntityVacationTypes(DynamicObject billDy) {
        boolean containsLactation = false;
        boolean containsOther = false;
        String entityName = billDy.getDynamicObjectType().getName();
        if (StringUtils.equalsAny((CharSequence)entityName, (CharSequence[])new CharSequence[]{"wtabm_vaapplyself", "wtabm_vaapply"})) {
            DynamicObjectCollection entryEntityDys = billDy.getDynamicObjectCollection("entryentity");
            for (int index = 0; index < entryEntityDys.size(); ++index) {
                DynamicObject entryDy = (DynamicObject)entryEntityDys.get(index);
                String specialVaType = entryDy.getString("specialvatype");
                if (WTCStringUtils.equals((String)SpecialVaTypeEnum.LACTATION_TYPE.vaType, (String)specialVaType)) {
                    containsLactation = true;
                    continue;
                }
                containsOther = true;
            }
        }
        return !containsOther || !containsLactation;
    }

    private BillResponse maxAdvancePeroidCheck() {
        String failMsg;
        ArrayList<DynamicObject> checkDys = new ArrayList<DynamicObject>(this.getDyList().size());
        for (DynamicObject dynamicObject : this.getDyList()) {
            if (!BatchBillUnifyService.getInstance().isNeedCheck(dynamicObject, UnifyCallChainEnum.init)) continue;
            checkDys.add(dynamicObject);
        }
        if (WTCCollections.isEmpty(checkDys)) {
            return BillResponse.success();
        }
        ArrayList<BillServiceBaseNewSetInfo> baseSetQuery = new ArrayList<BillServiceBaseNewSetInfo>(10);
        HashMap<BillAdvanceAfterEnum, Object> advanceAndAfterInfo = new HashMap<BillAdvanceAfterEnum, Object>(16);
        HashMap<BillAdvanceAfterFieldEnum, String> maxField = new HashMap<BillAdvanceAfterFieldEnum, String>(16);
        maxField.put(BillAdvanceAfterFieldEnum.UNIT, "aheadmaxunit");
        maxField.put(BillAdvanceAfterFieldEnum.OFFSET, "aheadmaxval");
        maxField.put(BillAdvanceAfterFieldEnum.CTRL, "isaheadmax");
        advanceAndAfterInfo.put(BillAdvanceAfterEnum.MAX_ADVANCE, maxField);
        if (BillSourceTypeEnum.BATCH == this.getBillApplyAttr().getSourceType()) {
            HashMap advField = new HashMap(16);
            advField.put(BillAdvanceAfterFieldEnum.UNIT, "aheadperiod");
            advField.put(BillAdvanceAfterFieldEnum.OFFSET, "maxaheadtime_real");
            advField.put(BillAdvanceAfterFieldEnum.CTRL, "isahead");
            advanceAndAfterInfo.put(BillAdvanceAfterEnum.ADVANCE, advField);
            HashMap<BillAdvanceAfterFieldEnum, String> afterField = new HashMap<BillAdvanceAfterFieldEnum, String>(16);
            afterField.put(BillAdvanceAfterFieldEnum.UNIT, "repairperiod");
            afterField.put(BillAdvanceAfterFieldEnum.OFFSET, "maxrepairtime_real");
            afterField.put(BillAdvanceAfterFieldEnum.CTRL, "isrepair");
            advanceAndAfterInfo.put(BillAdvanceAfterEnum.AFTER, afterField);
        }
        for (DynamicObject dynamicObject : checkDys) {
            long attFileBoId = dynamicObject.getLong(this.getCheckEnum().getAttfile() + ".id");
            long personId = dynamicObject.getLong("personid.id");
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (int index = 0; index < entryEntity.size(); ++index) {
                VaEntityCheckService entityCheckService;
                DynamicObject baseSetDy;
                DynamicObject entry = (DynamicObject)entryEntity.get(index);
                Date endDutyDate = new Date(entry.getDate(this.getCheckEnum().getEndDate()).getTime());
                Date startDutyDate = new Date(entry.getDate(this.getCheckEnum().getStartDate()).getTime());
                if (StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence)entry.getString(this.getCheckEnum().getStartMethod()))) {
                    endDutyDate = new Date(entry.getDate(this.getCheckEnum().getOwndate()).getTime());
                    startDutyDate = new Date(entry.getDate(this.getCheckEnum().getOwndate()).getTime());
                }
                if ((baseSetDy = (entityCheckService = this.getBillEntityCheckService((Long)attFileBoId, this.getUnifyBillEnum(), this.getCheckEnum(), entry, this.getBillApplyAttr().getAttFileF7AuthEntity())).getBaseSetDy()) == null) continue;
                BillServiceBaseNewSetInfo baseSetInfo = new BillServiceBaseNewSetInfo();
                baseSetInfo.setBaseSetDy(baseSetDy);
                baseSetInfo.setAttFileBoId(attFileBoId);
                baseSetInfo.setPersonId(personId);
                baseSetInfo.setCheckDates(WTCDateUtils.getLocalDateRange((Date)startDutyDate, (Date)endDutyDate));
                baseSetInfo.setBillDy(dynamicObject);
                baseSetQuery.add(baseSetInfo);
            }
        }
        BillBaseStateLessService service = new BillBaseStateLessService();
        Map billAdvanceAfterEnumListMap = service.checkAdvanceAfter(baseSetQuery, advanceAndAfterInfo);
        if (BillSourceTypeEnum.BATCH == this.getBillApplyAttr().getSourceType() && HRStringUtils.isNotEmpty((String)(failMsg = this.checkAdviceAndAfterAll(billAdvanceAfterEnumListMap)))) {
            return BillResponse.error(null, (List)Lists.newArrayList((Object[])new String[]{failMsg}));
        }
        List resps = (List)billAdvanceAfterEnumListMap.get(BillAdvanceAfterEnum.MAX_ADVANCE);
        if (WTCCollections.isEmpty((Collection)resps)) {
            return BillResponse.success();
        }
        for (int index = 0; index < resps.size(); ++index) {
            BillServiceAdvAfterResp limitResp = (BillServiceAdvAfterResp)resps.get(index);
            if (limitResp == null || limitResp.isPassCheck()) continue;
            String maxLimitUnit = limitResp.getLimitUnit();
            BillPeriodInfoResp billPeriodInfoResp = limitResp.getBillPeriodInfoResp();
            if (HRStringUtils.equals((String)maxLimitUnit, (String)BaseSetUnitTypeEnum.PERIOD.getCode()) && billPeriodInfoResp != null) {
                String adviceOrAfter = billPeriodInfoResp.getTipInfo();
                return BillResponse.error(null, (List)Lists.newArrayList((Object[])new String[]{this.getMsg(index, resps.size(), adviceOrAfter)}));
            }
            Integer maxLimitNum = limitResp.getLimitNum();
            String info = VaBillCheckService.buildUnitInfoByBaseSet(maxLimitNum, maxLimitUnit);
            String failMsg2 = "";
            failMsg2 = BillSourceTypeEnum.BATCH == this.getBillApplyAttr().getSourceType() ? BatchBillKDString.maxPro((String)info) : ResManager.loadKDString((String)"\u5df2\u8d85\u51fa\u63d0\u5355\u65e5\u671f\u8303\u56f4\u9650\u5236\uff0c\u6700\u591a\u53ea\u80fd\u63d0\u4ea4{0}\u5185\u7684\u7533\u8bf7\u3002", (String)"VaBillCheckService_3", (String)"wtc-wtabm-business", (Object[])new Object[]{info});
            failMsg2 = this.getMsg(index, resps.size(), failMsg2);
            return BillResponse.error(null, (List)Lists.newArrayList((Object[])new String[]{failMsg2}));
        }
        return BillResponse.success();
    }

    private String checkAdviceAndAfterAll(Map<BillAdvanceAfterEnum, List<BillServiceAdvAfterResp>> billAdvanceAfterEnumListMap) {
        List<BillServiceAdvAfterResp> advanceResps = billAdvanceAfterEnumListMap.get(BillAdvanceAfterEnum.ADVANCE);
        List<BillServiceAdvAfterResp> afterResps = billAdvanceAfterEnumListMap.get(BillAdvanceAfterEnum.AFTER);
        for (int index = 0; index < afterResps.size(); ++index) {
            String failMsg = "";
            BillServiceAdvAfterResp advanceResp = advanceResps.get(index);
            BillServiceAdvAfterResp afterResp = afterResps.get(index);
            if (HRStringUtils.equals((String)advanceResp.getLimitUnit(), (String)BaseSetUnitTypeEnum.PERIOD.getCode()) && advanceResp.getBillPeriodInfoResp() != null) {
                failMsg = advanceResp.getBillPeriodInfoResp().getTipInfo();
            } else if (HRStringUtils.equals((String)afterResp.getLimitUnit(), (String)BaseSetUnitTypeEnum.PERIOD.getCode()) && afterResp.getBillPeriodInfoResp() != null) {
                failMsg = afterResp.getBillPeriodInfoResp().getTipInfo();
            }
            if (HRStringUtils.isEmpty((String)failMsg) && !afterResp.isPassCheck() && !advanceResp.isPassCheck()) {
                String advInfo = VaBillCheckService.buildUnitInfoByBaseSet(advanceResp.getLimitNum(), advanceResp.getLimitUnit());
                String afterInfo = VaBillCheckService.buildUnitInfoByBaseSet(afterResp.getLimitNum(), afterResp.getLimitUnit());
                failMsg = BatchBillKDString.notMatchAdvAfter((String)advInfo, (String)afterInfo);
            }
            if (!HRStringUtils.isNotEmpty((String)failMsg)) continue;
            failMsg = this.getMsg(index, advanceResps.size(), failMsg);
            return failMsg;
        }
        return "";
    }

    private static String buildUnitInfoByBaseSet(Integer failCheckAdvanceAfterNum, String failCheckAdvanceAfterUnit) {
        String info = "";
        if (BaseSetUnitTypeEnum.DAY.getCode().equals(failCheckAdvanceAfterUnit)) {
            info = ResManager.loadKDString((String)"{0}\u4e2a\u81ea\u7136\u65e5", (String)"BustripEntityCheckService_3", (String)"wtc-wtabm-business", (Object[])new Object[]{failCheckAdvanceAfterNum});
        } else if (BaseSetUnitTypeEnum.MONTH.getCode().equals(failCheckAdvanceAfterUnit)) {
            info = ResManager.loadKDString((String)"{0}\u4e2a\u6708", (String)"BustripEntityCheckService_4", (String)"wtc-wtabm-business", (Object[])new Object[]{failCheckAdvanceAfterNum});
        } else if (BaseSetUnitTypeEnum.PERIOD.getCode().equals(failCheckAdvanceAfterUnit)) {
            info = ResManager.loadKDString((String)"{0}\u4e2a\u8003\u52e4\u671f\u95f4", (String)"BustripEntityCheckService_5", (String)"wtc-wtabm-business", (Object[])new Object[]{failCheckAdvanceAfterNum});
        } else if (BaseSetUnitTypeEnum.WEEKDAY.getCode().equals(failCheckAdvanceAfterUnit)) {
            info = ResManager.loadKDString((String)"{0}\u4e2a\u5de5\u4f5c\u65e5", (String)"BustripEntityCheckService_6", (String)"wtc-wtabm-business", (Object[])new Object[]{failCheckAdvanceAfterNum});
        }
        return info;
    }

    public BillResponse checkLactation() {
        if (this.getBillApplyAttr() != null && BillSourceTypeEnum.IMPORT == this.getBillApplyAttr().getSourceType() || BillSourceTypeEnum.OPENAPI == this.getBillApplyAttr().getSourceType() || BillSourceTypeEnum.BATCH == this.getBillApplyAttr().getSourceType()) {
            ArrayList<String> msg = new ArrayList<String>(4);
            List dyList = this.getDyList();
            boolean success = true;
            String batchErrMsg = BatchVaKDString.notSupportVaType();
            block0: for (DynamicObject dynamicObject : dyList) {
                if (!BatchBillUnifyService.getInstance().isNeedCheck(dynamicObject, UnifyCallChainEnum.init)) continue;
                long attfile = dynamicObject.getLong(this.getCheckEnum().getAttfile() + ".id");
                DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
                int index = 0;
                for (DynamicObject entry : entryEntity) {
                    VaEntityCheckService entityCheckService = this.getBillEntityCheckService((Long)attfile, this.getUnifyBillEnum(), this.getCheckEnum(), entry, this.getBillApplyAttr().getAttFileF7AuthEntity());
                    DynamicObject matchBaseSet = entityCheckService.getBaseSetDy();
                    String specialVaType = matchBaseSet.getString("specialdaytype");
                    boolean isSpecialType = matchBaseSet.getBoolean("isspecialholiday");
                    if (isSpecialType && StringUtils.equals((CharSequence)specialVaType, (CharSequence)SpecialVaTypeEnum.LACTATION_TYPE.vaType)) {
                        String entryErrMsg;
                        if (BillSourceTypeEnum.BATCH == this.getBillApplyAttr().getSourceType()) {
                            if (!BatchBillUnifyService.getInstance().isNeedCheck(dynamicObject, UnifyCallChainEnum.init)) continue block0;
                            String vaTypeName = entry.getString("entryvacationtype.name");
                            entryErrMsg = MessageFormat.format(batchErrMsg, vaTypeName);
                            msg.add(entryErrMsg);
                            success = false;
                            continue block0;
                        }
                        entryErrMsg = ResManager.loadKDString((String)"\u7279\u6b8a\u5047\uff08\u5982\uff1a\u54fa\u4e73\u5047\uff09\u6682\u4e0d\u652f\u6301\u5bfc\u5165\u3002", (String)"VaBillCheckService_4", (String)"wtc-wtabm-business", (Object[])new Object[0]);
                        msg.add(this.getMsg(entryEntity.size(), index, entryErrMsg));
                        success = false;
                        continue block0;
                    }
                    ++index;
                }
            }
            if (!success) {
                return BillResponse.error(null, msg);
            }
        }
        return BillResponse.success();
    }

    public BillResponse checkMustInput() {
        LOG.info("\u6821\u9a8c\u4f11\u5047\u539f\u56e0\u548c\u9644\u4ef6\u662f\u5426\u5fc5\u5f55.");
        if (BillSourceTypeEnum.BATCH == this.getBillApplyAttr().getSourceType()) {
            return BillResponse.success();
        }
        for (DynamicObject dynamicObject : this.getDyList()) {
            long attFile = dynamicObject.getLong("attfile.id");
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            int attachCount = this.countAttachmet(dynamicObject);
            boolean needAttachment = false;
            for (int index = 0; index < entryEntity.size(); ++index) {
                boolean success;
                DynamicObject entry = (DynamicObject)entryEntity.get(index);
                VaEntityCheckService entityCheckService = this.getBillEntityCheckService((Long)attFile, UnifyBillEnum.VA, this.getCheckEnum(), entry, this.getAttFileF7AuthEntity());
                DynamicObject baseSetDy = entityCheckService.getBaseSetDy();
                boolean reasonRequire = baseSetDy.getBoolean("isreasonrequire");
                String entryReason = entry.getString("entryreason");
                if (reasonRequire && !(success = StringUtils.isNotBlank((CharSequence)entryReason))) {
                    String errorMsg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u4f11\u5047\u539f\u56e0\u201d\u3002", (String)"VaBillCheckService_0", (String)"wtc-wtabm-business", (Object[])new Object[0]);
                    return BillResponse.error(null, (List)Lists.newArrayList((Object[])new String[]{this.getMsg(entryEntity.size(), index, errorMsg)}));
                }
                String enClosureLimit = baseSetDy.getString("enclosurelimit");
                if (HRStringUtils.equalsIgnoreCase((String)enClosureLimit, (String)EnClosureLimitEnum.NEED.getCode())) {
                    needAttachment = true;
                    continue;
                }
                if (!HRStringUtils.equalsIgnoreCase((String)enClosureLimit, (String)EnClosureLimitEnum.CONDITION.getCode())) continue;
                BigDecimal excessVal = baseSetDy.getBigDecimal("excessval_real");
                String entryUnit = baseSetDy.getString("unit");
                BigDecimal vaTime = entry.getBigDecimal(BaseSetTimeUnitEnum.DATE.code.equalsIgnoreCase(entryUnit) ? "entryvatimeday" : "entryvatimehour");
                if (vaTime.compareTo(excessVal) <= 0) continue;
                needAttachment = true;
            }
            if (!needAttachment || attachCount != 0 || BillSourceTypeEnum.IMPORT == this.getBillApplyAttr().getSourceType() || BillSourceTypeEnum.OPENAPI == this.getBillApplyAttr().getSourceType()) continue;
            String errorMsg = ResManager.loadKDString((String)"\u672a\u4e0a\u4f20\u9644\u4ef6\u3002", (String)"VaBaseSetService_01", (String)"wtc-wtabm-business", (Object[])new Object[0]);
            return BillResponse.error(null, (List)Lists.newArrayList((Object[])new String[]{errorMsg}));
        }
        return BillResponse.success();
    }

    private int countAttachmet(DynamicObject dynamicObject) {
        if (StringUtils.isNumeric((CharSequence)this.getBillApplyAttr().getAttachmentCache())) {
            return Integer.parseInt(this.getBillApplyAttr().getAttachmentCache());
        }
        VaApplyService vaApplyService = (VaApplyService)WTCAppContextHelper.getBean(VaApplyService.class);
        String entityId = vaApplyService.getFormId(dynamicObject);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_attachment");
        QFilter filter = new QFilter("finterid", "=", (Object)String.valueOf(dynamicObject.getPkValue()));
        filter.and("fbilltype", "=", (Object)entityId);
        int count = helper.count(helper.getEntityName(), new QFilter[]{filter});
        return count;
    }

    private BillResponse checkChangeBill() {
        QFilter qFilter;
        String properties;
        DynamicObject[] parentDyns;
        LOG.info("\u63d0\u4ea4\u524d\u6821\u9a8c\u53d8\u66f4\u5f00\u59cb\u3002");
        if (this.getBillApplyAttr() != null && BillSourceTypeEnum.BATCH == this.getBillApplyAttr().getSourceType()) {
            LOG.info("\u6279\u91cf\u4f11\u5047\u4e0d\u6821\u9a8c\u5206\u5f55\u662f\u5426\u5df2\u53d8\u66f4\u3002");
            return BillResponse.success();
        }
        List parentIds = this.getDyList().stream().filter(dy -> dy.getBoolean("ischange") && !dy.getDataEntityState().getFromDatabase() && dy.getLong("parentid") != 0L).map(dynamicObject -> dynamicObject.getLong("parentid")).collect(Collectors.toList());
        boolean isSuccess = true;
        ArrayList<String> messages = new ArrayList<String>(10);
        if (!CollectionUtils.isEmpty(parentIds) && (parentDyns = this.baseServiceHelper.queryOriginalArray(properties = String.join((CharSequence)",", "isnotleave", "ishavechange"), new QFilter[]{qFilter = new QFilter("id", "in", parentIds)})) != null && parentDyns.length != 0) {
            for (DynamicObject parentDyn : parentDyns) {
                boolean isHaveChange = parentDyn.getBoolean("ishavechange");
                boolean isNotLeave = parentDyn.getBoolean("isnotleave");
                if (isHaveChange) {
                    isSuccess = false;
                    messages.add(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u4e0d\u80fd\u518d\u6b21\u53d8\u66f4\u3002", (String)"VaBillCheckService_2", (String)"wtc-wtabm-business", (Object[])new Object[0]));
                    break;
                }
                if (!isNotLeave) continue;
                if (BillSourceTypeEnum.BATCH == this.getBillApplyAttr().getSourceType()) {
                    return BillResponse.success();
                }
                isSuccess = false;
                messages.add(ResManager.loadKDString((String)"\u5df2\u9500\u5047\u7684\u6570\u636e\u4e0d\u80fd\u53d8\u66f4\u3002", (String)"VaBillCheckService_1", (String)"wtc-wtabm-business", (Object[])new Object[0]));
                break;
            }
        }
        return new BillResponse(isSuccess, messages, null);
    }

    public BillResponse refresh() {
        BillResponse refreshResult = super.refresh();
        this.refreshQuotaInfo();
        return refreshResult;
    }

    private BillResponse refreshQuotaInfo() {
        ArrayList msg = new ArrayList(4);
        boolean success = true;
        for (DynamicObject dynamicObject : this.getDyList()) {
            long attfile = dynamicObject.getLong(this.getCheckEnum().getAttfile() + ".id");
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                VaEntityCheckService entityCheckService = this.getBillEntityCheckService((Long)attfile, this.getUnifyBillEnum(), this.getCheckEnum(), entry, this.getBillApplyAttr().getAttFileF7AuthEntity());
                DynamicObject matchRule = entityCheckService.getMatchRule();
                if (matchRule == null) {
                    LOG.warn("\u672a\u67e5\u627e\u5230\u4f11\u5047\u89c4\u5219\u3002");
                    success = false;
                    continue;
                }
                boolean isQuota = matchRule.getBoolean("isquota");
                boolean isDisposable = matchRule.getBoolean("isdisposable");
                entry.set("isdisposable", (Object)(isQuota && isDisposable ? 1 : 0));
            }
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        return BillResponse.success();
    }

    public BillResponse checkPersonInfo() {
        long attPersonId;
        ArrayList msg = new ArrayList(4);
        boolean success = true;
        ArrayList attPersonIds = Lists.newArrayListWithExpectedSize((int)this.getDyList().size());
        for (DynamicObject dynamicObject : this.getDyList()) {
            if (!BatchBillUnifyService.getInstance().isNeedCheck(dynamicObject, UnifyCallChainEnum.init)) continue;
            long attfile = dynamicObject.getLong(this.getCheckEnum().getAttfile() + ".id");
            attPersonId = dynamicObject.getLong("personid.id");
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                VaEntityCheckService entityCheckService = this.getBillEntityCheckService((Long)attfile, this.getUnifyBillEnum(), this.getCheckEnum(), entry, this.getBillApplyAttr().getAttFileF7AuthEntity());
                DynamicObject basesetDy = entityCheckService.getBaseSetDy();
                boolean isCheckPersonInfo = basesetDy.getBoolean("ischeckpersoninfo");
                if (!isCheckPersonInfo) continue;
                attPersonIds.add(attPersonId);
            }
        }
        AttendPersonCurrResult currentAttPerson = null;
        if (CollectionUtils.isNotEmpty((Collection)attPersonIds)) {
            currentAttPerson = AttendPersonServiceImpl.getInstance().getCurrentAttPerson((List)attPersonIds);
        }
        VaApplyService vaApplyService = (VaApplyService)WTCAppContextHelper.getBean(VaApplyService.class);
        for (DynamicObject dynamicObject : this.getDyList()) {
            if (!BatchBillUnifyService.getInstance().isNeedCheck(dynamicObject, UnifyCallChainEnum.init)) continue;
            attPersonId = dynamicObject.getLong("personid.id");
            long attfile = dynamicObject.getLong(this.getCheckEnum().getAttfile() + ".id");
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            String applyTyeRadio = dynamicObject.getString("applytyperadio");
            for (DynamicObject entry : entryEntity) {
                AttendPersonCurrModel model = vaApplyService.parseAttendPersonCurrModel(attPersonId, currentAttPerson);
                VaEntityCheckService entityCheckService = this.getBillEntityCheckService((Long)attfile, this.getUnifyBillEnum(), this.getCheckEnum(), entry, this.getBillApplyAttr().getAttFileF7AuthEntity());
                BillResponse billResponse = entityCheckService.checkPersonInfo(entityCheckService.getBaseSetDy(), applyTyeRadio, model);
                if (billResponse.isSuccess()) continue;
                List message = billResponse.getMessage();
                msg.addAll(message);
                success = false;
            }
        }
        if (success) {
            return BillResponse.success();
        }
        return BillResponse.error((Object)"", msg);
    }
}

