/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.business.vaapply.checker;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtabm.business.spva.SpecialVaExpService;
import kd.sdk.wtc.wtabm.business.spva.SpecialVaTimeDto;
import kd.sdk.wtc.wtabm.business.spva.SpecialVaTimeParam;
import kd.sdk.wtc.wtbs.common.dto.shift.ShiftDto;
import kd.wtc.wtabm.business.vaapply.ConvertUtils;
import kd.wtc.wtabm.business.vaapply.VaBaseService;
import kd.wtc.wtabm.business.vaapply.VaInfoService;
import kd.wtc.wtabm.business.vaapply.VaKDStringHelper;
import kd.wtc.wtbs.business.daterange.DateRangeServiceImpl;
import kd.wtc.wtbs.business.daterange.IDateRangeService;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonCurrModel;
import kd.wtc.wtbs.business.model.attendperson.FertilityInfo;
import kd.wtc.wtbs.business.model.attendperson.PerNonTsProp;
import kd.wtc.wtbs.business.util.ShiftParseUtil;
import kd.wtc.wtbs.business.util.TimeSeqEntityGenerateUtils;
import kd.wtc.wtbs.business.web.applybill.operatecore.extend.WtcAbstractUnityBillAutoOperator;
import kd.wtc.wtbs.business.web.applybill.operatecore.va.VaAutoOperator;
import kd.wtc.wtbs.business.web.applybill.service.BillEntityCheckService;
import kd.wtc.wtbs.business.web.attendperson.AttendPersonServiceImpl;
import kd.wtc.wtbs.common.enums.ApplicationTypeEnum;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.enums.bill.BaseSetUnitTypeEnum;
import kd.wtc.wtbs.common.enums.bill.unify.BillSourceTypeEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.enums.bill.va.SpecialVaTypeEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.bill.BillApplyDayTime;
import kd.wtc.wtbs.common.model.bill.BillApplyTimeResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillInfoContext;
import kd.wtc.wtbs.common.model.common.DateType;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.model.evaluation.ShiftDetail;
import kd.wtc.wtbs.common.model.evaluation.ShiftMiddleRule;
import kd.wtc.wtbs.common.model.shift.RefDateType;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.BooleanUtils;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.DateFormatUtils;
import kd.wtc.wtbs.common.util.third.util.DateUtils;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtbs.common.util.third.util.NumberUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtabm.common.constants.WtabmVaInfoConstants;
import kd.wtc.wtbs.wtabm.common.entity.VaDetailItemPreviewVo;
import kd.wtc.wtbs.wtabm.common.entity.VaDetailPreviewVo;
import kd.wtc.wtbs.wtabm.common.entity.VaInfoTimeFieldEnum;
import kd.wtc.wtbs.wtabm.common.entity.VaLactationTimeStorage;
import kd.wtc.wtbs.wtp.enums.vaplan.BaseSetTimeBreastDayTypeEnum;
import kd.wtc.wtbs.wtte.common.enums.OutWorkType;
import kd.wtc.wtp.business.vacation.VaBaseSetService;

public class VaEntityCheckService
extends BillEntityCheckService {
    private static final Log LOG = LogFactory.getLog(VaEntityCheckService.class);
    private static final BigDecimal DECIMAL_TWO = BigDecimal.valueOf(2L);
    private static final BigDecimal DECIMAL_ONE_HOUR_SECONDS = BigDecimal.valueOf(3600L);
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private boolean checkApplySpan = false;

    @Deprecated
    public static VaEntityCheckService createService(long attfileBo, ApplyBillCheckEnum checkEnum, DynamicObject dyObject, boolean needCheckAttFileAuth, String attFileF7AuthEntity) {
        return (VaEntityCheckService)((Object)WTCAppContextHelper.getBean(VaEntityCheckService.class));
    }

    public static VaEntityCheckService createService(long attfileBo, ApplyBillCheckEnum checkEnum, DynamicObject dyObject, boolean needCheckAttFileAuth, VaAutoOperator operator, UnifyBillApplyAttr applyAttr) {
        VaEntityCheckService vaEntityCheckService = (VaEntityCheckService)((Object)WTCAppContextHelper.getBean(VaEntityCheckService.class));
        vaEntityCheckService.setAttfileBo(attfileBo);
        vaEntityCheckService.setUnifyBillEnum(UnifyBillEnum.VA);
        vaEntityCheckService.setCheckEnum(checkEnum);
        vaEntityCheckService.setDyObject(dyObject);
        vaEntityCheckService.setBillAutoOperator((WtcAbstractUnityBillAutoOperator)operator);
        vaEntityCheckService.init = true;
        vaEntityCheckService.setNeedCheckAttFileAuth(needCheckAttFileAuth);
        vaEntityCheckService.setBillApplyAttr(applyAttr);
        return vaEntityCheckService;
    }

    public static VaEntityCheckService createService(long attfileBo, ApplyBillCheckEnum checkEnum, DynamicObject dyObject, boolean needCheckAttFileAuth, UnifyBillApplyAttr applyAttr) {
        VaEntityCheckService vaEntityCheckService = (VaEntityCheckService)((Object)WTCAppContextHelper.getBean(VaEntityCheckService.class));
        vaEntityCheckService.setAttfileBo(attfileBo);
        vaEntityCheckService.setUnifyBillEnum(UnifyBillEnum.VA);
        vaEntityCheckService.setCheckEnum(checkEnum);
        vaEntityCheckService.setDyObject(dyObject);
        vaEntityCheckService.setBillAutoOperator(vaEntityCheckService.initContext(dyObject, applyAttr));
        vaEntityCheckService.setNeedCheckAttFileAuth(needCheckAttFileAuth);
        vaEntityCheckService.setBillApplyAttr(applyAttr);
        return vaEntityCheckService;
    }

    protected WtcAbstractUnityBillAutoOperator initContext(DynamicObject dyObject, UnifyBillApplyAttr applyAttr) {
        List lst = this.createUnifyBillApplyInfo(dyObject);
        UnifyBillInfoContext unifyBillInfoContext = new UnifyBillInfoContext(lst, applyAttr);
        this.init = true;
        return new VaAutoOperator(unifyBillInfoContext);
    }

    public BillResponse checkPersonInfo(DynamicObject baseSetDy, String applyTypeRadio, AttendPersonCurrModel model) {
        if (baseSetDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4f11\u5047\u57fa\u7840\u914d\u7f6e\u3002", (String)"VaEntityCheckService_3", (String)"wtc-wtabm-business", (Object[])new Object[0]));
        }
        boolean isCheckPersonInfo = baseSetDy.getBoolean("ischeckpersoninfo");
        if (!isCheckPersonInfo) {
            return BillResponse.success();
        }
        if (model == null) {
            LOG.warn("\u6821\u9a8c\u4eba\u5458\u4fe1\u606f\uff0c\u67e5\u8be2\u5230\u7684\u4eba\u5458\u4fe1\u606f\u4e3a\u7a7a\uff01baseSetDy.pk:{}, attfileBo:{}", baseSetDy.getPkValue(), (Object)this.attfileBo);
            return BillResponse.error((Object)"", (List)Lists.newArrayList((Object[])new String[]{VaKDStringHelper.queryPersonFail()}));
        }
        String personInfoField = baseSetDy.getString("personinfo");
        String[] splitedField = personInfoField.split(",");
        HashMap checkResultMap = Maps.newHashMapWithExpectedSize((int)16);
        PerNonTsProp perNonTsProp = model.getPerNonTsProp();
        Date marryDate = perNonTsProp.getMarryDate();
        Date beginServiceDate = perNonTsProp.getBeginServiceDate();
        FertilityInfo fertilityInfo = model.getFertilityInfo();
        for (String personField : splitedField) {
            if (personField.startsWith("hrpi_fertilityinfo.")) {
                if (fertilityInfo == null) {
                    checkResultMap.put(personField, Boolean.FALSE);
                    continue;
                }
                Date childBirthDay = fertilityInfo.getBirthday();
                Integer childrenNumber = fertilityInfo.getChildrenNumber();
                Long procreatMode = fertilityInfo.getProcreatMode();
                String replacement = personField.replace("hrpi_fertilityinfo.", "");
                if (StringUtils.equals((CharSequence)"birthday", (CharSequence)replacement)) {
                    checkResultMap.put(personField, childBirthDay != null);
                }
                if (StringUtils.equals((CharSequence)"childrennumber", (CharSequence)replacement)) {
                    checkResultMap.put(personField, childrenNumber != null);
                }
                if (StringUtils.equals((CharSequence)"procreatmode", (CharSequence)replacement)) {
                    checkResultMap.put(personField, procreatMode != null);
                }
            }
            if (!personField.startsWith("hrpi_pernontspro.")) continue;
            String replacement = personField.replace("hrpi_pernontspro.", "");
            if (StringUtils.equals((CharSequence)"marriageregistdate", (CharSequence)replacement)) {
                checkResultMap.put(personField, marryDate != null);
            }
            if (!StringUtils.equals((CharSequence)"beginservicedate", (CharSequence)replacement)) continue;
            checkResultMap.put(personField, beginServiceDate != null);
        }
        return this.parsePersonInfoResult(baseSetDy, checkResultMap, applyTypeRadio);
    }

    private BillResponse parsePersonInfoResult(DynamicObject baseSetDy, Map<String, Boolean> checkResultMap, String applyTypeRadio) {
        ArrayList checkResults = Lists.newArrayListWithExpectedSize((int)checkResultMap.size());
        ArrayList checkKeys = Lists.newArrayListWithExpectedSize((int)checkResultMap.size());
        Set<Map.Entry<String, Boolean>> entries = checkResultMap.entrySet();
        for (Map.Entry<String, Boolean> entry : entries) {
            checkResults.add(entry.getValue());
            if (!BooleanUtils.isNotTrue((Boolean)entry.getValue())) continue;
            checkKeys.add(entry.getKey());
        }
        ArrayList msgs = Lists.newArrayList();
        String personCondition = baseSetDy.getString("personcondition");
        boolean checkSuccess = StringUtils.equals((CharSequence)"A", (CharSequence)personCondition) ? !checkResults.contains(Boolean.FALSE) : checkResults.contains(Boolean.TRUE);
        if (!checkSuccess) {
            String br = "";
            if (this.getBillApplyAttr().getSourceType() != BillSourceTypeEnum.IMPORT) {
                br = "\n";
            }
            VaBaseSetService vaBaseSetService = new VaBaseSetService();
            Map itemMap = vaBaseSetService.parseVaSceneRule();
            StringBuilder tipMsg = new StringBuilder();
            String splitor = ResManager.loadKDString((String)"\u3001", (String)"VaEntityCheckService_4", (String)"wtc-wtabm-business", (Object[])new Object[0]);
            for (int index = 0; index < checkKeys.size(); ++index) {
                if (index != 0) {
                    tipMsg.append(splitor);
                }
                String checkKey = (String)checkKeys.get(index);
                LocaleString localeString = (LocaleString)itemMap.get(checkKey);
                tipMsg.append(localeString.getLocaleValue());
            }
            String tipsMsg = null;
            if (StringUtils.equals((CharSequence)"A", (CharSequence)personCondition) || CollectionUtils.size((Object)checkKeys) == 1) {
                tipsMsg = ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4{0}\u3002", (String)"VaEntityCheckService_5", (String)"wtc-wtabm-business", (Object[])new Object[]{tipMsg.toString()});
            } else if (CollectionUtils.size((Object)checkKeys) > 1) {
                tipsMsg = ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4{0}\u4e4b\u4e2d\u7684\u4efb\u610f\u4e00\u4e2a\u3002", (String)"VaEntityCheckService_6", (String)"wtc-wtabm-business", (Object[])new Object[]{tipMsg.toString()});
            }
            String message = tipsMsg;
            if (StringUtils.equals((CharSequence)"0", (CharSequence)applyTypeRadio)) {
                message = ResManager.loadKDString((String)"{0}{1}\u53ef\u524d\u5f80HR\u81ea\u52a9\u670d\u52a1\u4e2d\u5fc3-\u6211\u7684\u6863\u6848\u7ef4\u62a4\u66f4\u65b0\u4e2a\u4eba\u4fe1\u606f\u6216\u8054\u7cfbHR\u8003\u52e4\u5458\u3002", (String)"VaEntityCheckService_1", (String)"wtc-wtabm-business", (Object[])new Object[]{tipsMsg, br});
            }
            msgs.add(message);
        }
        return new BillResponse(checkSuccess, (List)msgs, (Object)"");
    }

    public BillResponse checkBeforeGenerateApplyTime() {
        DynamicObject baseSetDyn = this.getBaseSetDy();
        String timeCalcType = baseSetDyn.getString("timecalctype");
        String startMethod = this.dyObject.getString(this.checkEnum.getStartMethod());
        if (StringUtils.equals((CharSequence)startMethod, (CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value) && StringUtils.equals((CharSequence)timeCalcType, (CharSequence)"B")) {
            String vaTypeName = this.dyObject.getString(String.join((CharSequence)".", this.checkEnum.getType(), "name"));
            String msg = VaKDStringHelper.checkCalcTypeFail(vaTypeName);
            return BillResponse.error((Object)"", (List)Lists.newArrayList((Object[])new String[]{msg}));
        }
        return BillResponse.success();
    }

    public BillApplyTimeResult generateApplyTime() {
        BillApplyTimeResult standardTimeResult;
        String startMethod = this.dyObject.getString(this.checkEnum.getStartMethod());
        String endMethod = this.dyObject.getString(this.checkEnum.getEndMethod());
        Date startDate = new Date(this.dyObject.getDate(this.checkEnum.getStartDate()).getTime());
        Date endDate = new Date(this.dyObject.getDate(this.checkEnum.getEndDate()).getTime());
        List dutyShiftsRange = this.billAutoOperator.getDutyShiftsRange(this.attfileBo.longValue(), startDate, endDate);
        DynamicObject baseSetDyn = this.getBaseSetDy();
        String specialVaType = baseSetDyn.getString("specialdaytype");
        boolean isSpecialType = baseSetDyn.getBoolean("isspecialholiday");
        String unit = baseSetDyn.getString(this.checkEnum.getApplyBillBaseSetEnum().getUnit());
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u3010\u4f11\u5047\u7533\u8bf7\u65f6\u957f\u8ba1\u7b97\u3011generateApplyTime, SpecialVaType:{}", (Object)specialVaType);
        }
        if (StringUtils.equals((CharSequence)specialVaType, (CharSequence)SpecialVaTypeEnum.LACTATION_TYPE.vaType) && isSpecialType) {
            this.dyObject.set(this.checkEnum.getSpecialVaType(), (Object)specialVaType);
            this.dyObject.set(this.checkEnum.getStartMethod(), (Object)WtcTimeRangeBtnTypeEnum.DAY.value);
            this.dyObject.set(this.checkEnum.getEndMethod(), (Object)WtcTimeRangeBtnTypeEnum.DAY.value);
            return this.genLactationTimes();
        }
        this.dyObject.set(this.checkEnum.getSpecialVaType(), null);
        this.dyObject.set(this.checkEnum.getSpecialVaMethod(), null);
        this.dyObject.set(this.checkEnum.getSpecialVaJson(), null);
        if (HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.CUSTOM.value)) {
            Date ownDate = this.dyObject.getDate(this.checkEnum.getOwndate());
            standardTimeResult = VaEntityCheckService.calCustomVaApplyTime(baseSetDyn, dutyShiftsRange, startDate, endDate, ownDate);
        } else {
            BillApplyTimeResult startDateCalResult = new BillApplyTimeResult();
            BillApplyTimeResult endDateCalResult = new BillApplyTimeResult();
            if (HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value)) {
                startDateCalResult = this.calHalfDayVaTime(dutyShiftsRange, startDate, baseSetDyn, false);
            }
            if (HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value)) {
                endDateCalResult = this.calHalfDayVaTime(dutyShiftsRange, endDate, baseSetDyn, true);
            }
            Date wholeDayStart = this.beginDayIsHoleDay(startMethod, endMethod, startDate, endDate) ? startDate : DateUtils.addDays((Date)startDate, (int)1);
            Date wholeDayEnd = StringUtils.equalsAny((CharSequence)endMethod, (CharSequence[])new CharSequence[]{WtcTimeRangeBtnTypeEnum.HALF_DOWN.value, WtcTimeRangeBtnTypeEnum.DAY.value}) ? endDate : DateUtils.addDays((Date)endDate, (int)-1);
            BillApplyTimeResult middleCalResult = this.calWholeDayVaTime(dutyShiftsRange, wholeDayStart, wholeDayEnd, baseSetDyn);
            BigDecimal sumDay = startDateCalResult.getValDay().add(middleCalResult.getValDay()).add(endDateCalResult.getValDay());
            BigDecimal sumHour = startDateCalResult.getValHour().add(middleCalResult.getValHour()).add(endDateCalResult.getValHour());
            standardTimeResult = new BillApplyTimeResult(unit, sumHour, sumDay);
            if (WTCCollections.isNotEmpty((Collection)middleCalResult.getDayTimeDetails())) {
                standardTimeResult.getDayTimeDetails().addAll(middleCalResult.getDayTimeDetails());
            }
            if (WTCCollections.isNotEmpty((Collection)startDateCalResult.getDayTimeDetails())) {
                standardTimeResult.getDayTimeDetails().addAll(startDateCalResult.getDayTimeDetails());
            }
            if (WTCCollections.isNotEmpty((Collection)endDateCalResult.getDayTimeDetails())) {
                standardTimeResult.getDayTimeDetails().addAll(endDateCalResult.getDayTimeDetails());
            }
        }
        BillApplyTimeResult billApplyTimeResult = VaInfoService.onVaCalTimesExt(this.attfileBo, this.getDyObject(), baseSetDyn, dutyShiftsRange, null, standardTimeResult);
        if (billApplyTimeResult == null) {
            billApplyTimeResult = standardTimeResult;
        }
        return billApplyTimeResult;
    }

    private BillApplyTimeResult genLactationTimes() {
        DynamicObject baseSetDy = this.getBaseSetDy();
        BillApplyTimeResult billRes = new BillApplyTimeResult(baseSetDy.getString("unit"), BigDecimal.ZERO, BigDecimal.ZERO);
        if (ApplyBillCheckEnum.VACATIONFORM == this.getCheckEnum()) {
            DynamicObjectCollection entryInfoSubCollection = this.dyObject.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryInfoSubCollection)) {
                return billRes;
            }
            for (DynamicObject dyn : entryInfoSubCollection) {
                Date vaperdate = dyn.getDate("vaperdate");
                for (VaInfoTimeFieldEnum timeFieldEnum : WtabmVaInfoConstants.FORM_ENTRY_TIME_RANGE_FILED_LIST) {
                    Date endTime;
                    Date startTime = WTCDateUtils.add((Date)vaperdate, (int)13, (int)dyn.getInt(timeFieldEnum.startKey));
                    if (!startTime.before(endTime = WTCDateUtils.add((Date)vaperdate, (int)13, (int)dyn.getInt(timeFieldEnum.endKey)))) continue;
                    billRes.plus(dyn.getBigDecimal(timeFieldEnum.applyTime), dyn.getBigDecimal(timeFieldEnum.applyDay));
                }
            }
        } else {
            DynamicObjectCollection subEntryEntities = this.dyObject.getDynamicObjectCollection("vadetailentry");
            if (CollectionUtils.isEmpty((Collection)subEntryEntities)) {
                return billRes;
            }
            for (DynamicObject dyn : subEntryEntities) {
                BillApplyTimeResult result = new BillApplyTimeResult(dyn.getString("vaentryunit"), dyn.getBigDecimal("vaentryapplytimehour"), dyn.getBigDecimal("vaentryapplytimeday"));
                billRes.plus(result);
            }
        }
        return billRes;
    }

    private BillApplyTimeResult calHalfDayVaTime(List<Tuple<DutyShift, Shift>> dutyShiftsRange, Date date, DynamicObject baseSetDyn, boolean isHalfUp) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u8ba1\u7b97\u534a\u5929\u73ed\u65f6\u957f\u5f00\u59cb\uff1adate:{}", (Object)DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        Tuple<DutyShift, Shift> tupleDutyShift = null;
        for (Tuple<DutyShift, Shift> truple : dutyShiftsRange) {
            Date rosterDate = ((DutyShift)truple.item1).getRosterDate();
            if (!DateUtils.isSameDay((Date)rosterDate, (Date)date)) continue;
            tupleDutyShift = truple;
            break;
        }
        if (tupleDutyShift == null) {
            LOG.info("\u65e5\u671f\u65e0\u73ed\u6b21\uff0c\u4e0d\u8ba1\u7b97\u534a\u5929\u73ed\u65f6\u957f\uff0cdate:{}, attFileBoId:{}", (Object)date, (Object)this.attfileBo);
            return new BillApplyTimeResult();
        }
        boolean satisfyDateRange = VaEntityCheckService.isSatisfyDateRange((DutyShift)tupleDutyShift.item1, baseSetDyn);
        BigDecimal entryVaTimeHour = BigDecimal.ZERO;
        BigDecimal entryVaTimeDay = BigDecimal.ZERO;
        String unit = baseSetDyn.getString(this.checkEnum.getApplyBillBaseSetEnum().getUnit());
        BillApplyTimeResult billApplyTimeResult = new BillApplyTimeResult(unit, entryVaTimeHour, entryVaTimeDay);
        if (satisfyDateRange) {
            billApplyTimeResult = this.middleRefDateCal((DutyShift)tupleDutyShift.item1, (Shift)tupleDutyShift.item2, date, baseSetDyn, isHalfUp);
        } else if (LOG.isDebugEnabled()) {
            LOG.info("satisfyDateRange\u6821\u9a8c\u672a\u901a\u8fc7,\u4e0d\u8ba1\u5165\u4f11\u5047.attFileBo:{}, date:{}", (Object)this.attfileBo, (Object)date);
        }
        BillApplyDayTime detail = VaEntityCheckService.createBillApplyDayTime(satisfyDateRange, date, billApplyTimeResult.getValDay(), billApplyTimeResult.getValHour(), unit);
        List details = WTCCollections.modifiableList((Object[])new BillApplyDayTime[]{detail});
        billApplyTimeResult.setDayTimeDetails(details);
        return billApplyTimeResult;
    }

    private BillApplyTimeResult calWholeDayVaTime(List<Tuple<DutyShift, Shift>> dutyShifts, Date startDate, Date endDate, DynamicObject baseSetDyn) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("calWholeDayVaTime start startDate: {}, endDate :{}, vaBeSetId: {}, dutyShifts: {}", new Object[]{startDate, endDate, baseSetDyn.getPkValue(), dutyShifts.size()});
        }
        String unit = baseSetDyn.getString(this.checkEnum.getApplyBillBaseSetEnum().getUnit());
        String timeCalcType = baseSetDyn.getString("timecalctype");
        boolean isContainOverTime = baseSetDyn.getBoolean("iscontainovertime");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        BigDecimal entryVaTimeHour = BigDecimal.ZERO;
        BigDecimal entryVaTimeDay = BigDecimal.ZERO;
        boolean before = startDate.before(endDate) || DateUtils.isSameDay((Date)startDate, (Date)endDate);
        List details = WTCCollections.modifiableList((Object[])new BillApplyDayTime[0]);
        Map<String, Tuple> tupleMap = dutyShifts.stream().collect(Collectors.toMap(tuple -> dateFormat.format(((DutyShift)tuple.item1).getRosterDate()), tuple -> tuple, (tuple1, tuple2) -> tuple1));
        while (before) {
            Tuple tuple3 = tupleMap.get(dateFormat.format(startDate));
            if (tuple3 == null) {
                LOG.info("\u83b7\u53d6\u6392\u73ed\u5f02\u5e38\uff0c\u8df3\u8fc7\u5f53\u65e5\u8ba1\u7b97\u7533\u8bf7\u65f6\u957f\u3002date:{}, attFileBoID:{}", (Object)dateFormat.format(startDate), (Object)this.attfileBo);
            } else {
                boolean satisfyDateRange = VaEntityCheckService.isSatisfyDateRange((DutyShift)tuple3.item1, baseSetDyn);
                if (satisfyDateRange) {
                    BigDecimal allDayHour = ((Shift)tuple3.item2).getShiftMiddleRule().getAlldayhour();
                    if (((Shift)tuple3.item2).getOffNonPlan() && ((Shift)tuple3.item2).isOff()) {
                        entryVaTimeDay = entryVaTimeDay.add(((Shift)tuple3.item2).getShiftMiddleRule().getAllday());
                        entryVaTimeHour = entryVaTimeHour.add(allDayHour);
                    } else if (StringUtils.equals((CharSequence)timeCalcType, (CharSequence)"A")) {
                        int standardTime = isContainOverTime ? ((Shift)tuple3.item2).getStandardTime().intValue() : ((Shift)tuple3.item2).getStandardTimeOfNoOt();
                        BigDecimal standardHour = BigDecimal.valueOf(standardTime).divide(DECIMAL_ONE_HOUR_SECONDS, 6, RoundingMode.HALF_UP);
                        BigDecimal standardDay = standardHour.divide(allDayHour, 6, RoundingMode.HALF_UP);
                        entryVaTimeDay = entryVaTimeDay.add(standardDay);
                        entryVaTimeHour = entryVaTimeHour.add(standardHour);
                    } else {
                        entryVaTimeDay = BigDecimal.ONE.add(entryVaTimeDay);
                        entryVaTimeHour = entryVaTimeHour.add(allDayHour);
                    }
                }
                BillApplyDayTime detail = VaEntityCheckService.createBillApplyDayTime(satisfyDateRange, startDate, entryVaTimeDay, entryVaTimeHour, unit);
                details.add(detail);
            }
            startDate = DateUtils.addDays((Date)startDate, (int)1);
            before = startDate.before(endDate) || DateUtils.isSameDay((Date)startDate, (Date)endDate);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("calWholeDayHours end entryVaTimeHour: {}, entryVaTimeDay: {}", (Object)entryVaTimeHour, (Object)entryVaTimeHour);
        }
        BillApplyTimeResult billApplyTimeResult = new BillApplyTimeResult(unit, entryVaTimeHour, entryVaTimeDay);
        billApplyTimeResult.setDayTimeDetails(details);
        return billApplyTimeResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    private BillApplyTimeResult middleRefDateCal(DutyShift dutyShift, Shift shift, Date date, DynamicObject baseSetDyn, boolean isHalfUp) {
        Date refMiddleDate;
        Date rosterBeginDate;
        boolean isContainOverTime;
        ShiftMiddleRule shiftMiddleRule;
        long dateInsectionTimes;
        BigDecimal entryVaTimeDay;
        BigDecimal entryVaTimeHour;
        String unit;
        block10: {
            String halfDayType;
            block9: {
                unit = baseSetDyn.getString("unit");
                String timeCalcType = baseSetDyn.getString("timecalctype");
                halfDayType = baseSetDyn.getString("halfdaytype");
                entryVaTimeHour = BigDecimal.ZERO;
                entryVaTimeDay = BigDecimal.ZERO;
                dateInsectionTimes = 0L;
                shiftMiddleRule = shift.getShiftMiddleRule();
                if (!StringUtils.equals((CharSequence)timeCalcType, (CharSequence)"A")) break block9;
                isContainOverTime = baseSetDyn.getBoolean("iscontainovertime");
                if (shift.getOffNonPlan() && shift.isOff()) {
                    entryVaTimeHour = shiftMiddleRule.getAlldayhour().divide(BigDecimal.valueOf(2L), 6, RoundingMode.HALF_UP);
                    entryVaTimeDay = shiftMiddleRule.getAllday().divide(BigDecimal.valueOf(2L), 6, RoundingMode.HALF_UP);
                    return new BillApplyTimeResult(unit, entryVaTimeHour, entryVaTimeDay);
                }
                if (StringUtils.equals((CharSequence)halfDayType, (CharSequence)"A")) {
                    int lastShiftStartDate = shift.getLastShiftStartDate();
                    rosterBeginDate = WTCDateUtils.getDate((Date)date, (Integer)lastShiftStartDate);
                    RefDateType middleRefDate = shiftMiddleRule.getMiddleRefDate();
                    refMiddleDate = date;
                    if (RefDateType.NEXTDAY == middleRefDate) {
                        refMiddleDate = DateUtils.addDays((Date)date, (int)1);
                    }
                    break block10;
                } else {
                    if (!StringUtils.equals((CharSequence)halfDayType, (CharSequence)"B")) {
                        LOG.warn("timeCalcType\u65b9\u5f0f\u4e3a\u6309\u73ed\u6b21\uff0c\u4f46\u662fhalfDayType\u7684\u503c\u4e3a\uff1a{}", (Object)halfDayType);
                        throw new KDBizException(ResManager.loadKDString((String)"\u4f11\u5047\u57fa\u7840\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VaEntityCheckService_9", (String)"wtc-wtabm-business", (Object[])new Object[0]));
                    }
                    int standardTime = isContainOverTime ? shift.getStandardTime().intValue() : shift.getStandardTimeOfNoOt();
                    entryVaTimeHour = BigDecimal.valueOf(standardTime).divide(DECIMAL_ONE_HOUR_SECONDS.multiply(DECIMAL_TWO), 6, RoundingMode.HALF_UP);
                    if (BigDecimal.ZERO.compareTo(shiftMiddleRule.getAlldayhour()) == 0) return new BillApplyTimeResult(unit, entryVaTimeHour, entryVaTimeDay);
                    entryVaTimeDay = entryVaTimeHour.divide(shiftMiddleRule.getAlldayhour(), 6, RoundingMode.HALF_UP);
                    return new BillApplyTimeResult(unit, entryVaTimeHour, entryVaTimeDay);
                }
            }
            if (StringUtils.equals((CharSequence)halfDayType, (CharSequence)"C")) {
                entryVaTimeHour = shiftMiddleRule.getAlldayhour().divide(DECIMAL_TWO, 6, RoundingMode.HALF_UP);
                entryVaTimeDay = BigDecimal.valueOf(0.5);
                return new BillApplyTimeResult(unit, entryVaTimeHour, entryVaTimeDay);
            }
            LOG.warn("timeCalcType\u65b9\u5f0f\u4e3a\u6309\u65e5\u5386\u5929\uff0c\u4f46\u662fhalfDayType\u7684\u503c\u4e3a\uff1a{}", (Object)halfDayType);
            throw new KDBizException(ResManager.loadKDString((String)"\u4f11\u5047\u57fa\u7840\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VaEntityCheckService_9", (String)"wtc-wtabm-business", (Object[])new Object[0]));
        }
        Date middleDate = WTCDateUtils.getDate((Date)refMiddleDate, (Integer)shiftMiddleRule.getMiddlepoint());
        Date rosterEndDate = ShiftParseUtil.getRosterEndDate((Shift)shift, (Date)date);
        List shiftDetails = shift.getShiftDetailList();
        Iterator iterator = shiftDetails.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                entryVaTimeHour = BigDecimal.valueOf(dateInsectionTimes).divide(DECIMAL_ONE_HOUR_SECONDS, 6, RoundingMode.HALF_UP);
                if (BigDecimal.ZERO.compareTo(shiftMiddleRule.getAlldayhour()) == 0) return new BillApplyTimeResult(unit, entryVaTimeHour, entryVaTimeDay);
                entryVaTimeDay = entryVaTimeHour.divide(shiftMiddleRule.getAlldayhour(), 6, RoundingMode.HALF_UP);
                return new BillApplyTimeResult(unit, entryVaTimeHour, entryVaTimeDay);
            }
            ShiftDetail detail = (ShiftDetail)iterator.next();
            if (StringUtils.equalsAny((CharSequence)detail.getOutWorkType(), (CharSequence[])new CharSequence[]{OutWorkType.BREAK.code}) || !isContainOverTime && StringUtils.equals((CharSequence)detail.getOutWorkType(), (CharSequence)OutWorkType.OT.code)) continue;
            Date detailStartDate = ShiftParseUtil.getRosterStartDate((ShiftDetail)detail, (Date)dutyShift.getRosterDate());
            Date detailEndDate = ShiftParseUtil.getRosterDetailEndDate((ShiftDetail)detail, (Date)dutyShift.getRosterDate());
            if (isHalfUp) {
                dateInsectionTimes += WTCDateUtils.getDateInsectionTimes((Date)rosterBeginDate, (Date)middleDate, (Date)detailStartDate, (Date)detailEndDate);
                continue;
            }
            dateInsectionTimes += WTCDateUtils.getDateInsectionTimes((Date)middleDate, (Date)rosterEndDate, (Date)detailStartDate, (Date)detailEndDate);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BillResponse genVaSubEntity() {
        ArrayList<VaDetailPreviewVo> detailList = new ArrayList<VaDetailPreviewVo>(16);
        if (!this.checkBaseSetSuccess) {
            LOG.info("\u57fa\u7840\u6821\u9a8c\u672a\u901a\u8fc7\uff0c\u4e0d\u751f\u6210\u660e\u7ec6.");
            return BillResponse.error(null, (List)Lists.newArrayListWithExpectedSize((int)1));
        }
        Date startDate = this.getDyObject().getDate(this.getCheckEnum().getStartDate());
        Date endDate = this.getDyObject().getDate(this.getCheckEnum().getEndDate());
        DynamicObject specialVaMethodDyn = this.getDyObject().getDynamicObject(this.getCheckEnum().getSpecialVaMethod());
        long specialVaMethodId = this.getDyObject().getLong(this.getCheckEnum().getSpecialVaMethod() + ".id");
        List dutyShiftsRanges = this.billAutoOperator.getDutyShiftsRange(this.getAttfileBo().longValue(), startDate, endDate);
        Map<Date, Tuple> dateTupleMap = dutyShiftsRanges.stream().collect(Collectors.toMap(range -> ((DutyShift)range.item1).getRosterDate(), range -> range, (r1, r2) -> r1));
        DynamicObject baseSetDy = this.getBaseSetDy();
        VaLactationTimeStorage lactationTimeStorage = (VaLactationTimeStorage)JSON.parseObject((String)this.getDyObject().getString(this.getCheckEnum().getSpecialVaJson()), VaLactationTimeStorage.class);
        try {
            Date lacEndDate = this.simpleDateFormat.parse(lactationTimeStorage.getLactationEndDate());
            Date bornDate = this.simpleDateFormat.parse(lactationTimeStorage.getBornDate());
            BillResponse dateRangeTips = VaEntityCheckService.getDateRangeTips(startDate, endDate, lacEndDate, bornDate);
            if (!dateRangeTips.isSuccess()) {
                LOG.info("\u54fa\u4e73\u5047\u65e5\u671f\u8303\u56f4\u6821\u9a8c\u672a\u901a\u8fc7\uff0c \u4e0d\u751f\u6210\u660e\u7ec6");
                return dateRangeTips;
            }
        }
        catch (ParseException e) {
            LOG.warn("\u54fa\u4e73\u5047\u65e5\u671f\u8303\u56f4\u6821\u9a8c\u5f02\u5e38\uff0c \u4e0d\u751f\u6210\u660e\u7ec6\u3002lacEndDate:{}, bornDate:{}", (Object)lactationTimeStorage.getLactationEndDate(), (Object)lactationTimeStorage.getBornDate());
            return BillResponse.error(null, (List)Lists.newArrayListWithExpectedSize((int)1));
        }
        boolean anySatisfyDateRange = false;
        Date date = startDate;
        while (!date.after(endDate)) {
            Tuple dutyShiftShiftTuple = dateTupleMap.get(date);
            if (dutyShiftShiftTuple == null) {
                LOG.info("\u5f53\u65e5\u65e0\u73ed\u6b21\uff0c\u8df3\u8fc7\u5f53\u65e5\u751f\u6210:{}, attFileBoId:{}", (Object)date, (Object)this.attfileBo);
            } else {
                boolean satisfyDateRange = VaEntityCheckService.isSatisfyDateRange((DutyShift)dutyShiftShiftTuple.item1, baseSetDy);
                if (!satisfyDateRange) {
                    LOG.info("\u5f53\u5929\u6392\u73ed\u4e0d\u7b26\u5408\u4f7f\u7528\u65e5\u671f\u8303\u56f4\uff0c\u8df3\u8fc7\u5f53\u65e5\u751f\u6210.date:{}, attFileBo:{}", (Object)date, (Object)this.attfileBo);
                } else {
                    anySatisfyDateRange = true;
                    if (NumberUtils.compare((long)specialVaMethodId, (long)BaseSetTimeBreastDayTypeEnum.COME_LATE.id) == 0 || NumberUtils.compare((long)specialVaMethodId, (long)BaseSetTimeBreastDayTypeEnum.GO_EARLY.id) == 0) {
                        Tuple<Date, Date> datePeriod = VaEntityCheckService.getStartEndDate(specialVaMethodId, lactationTimeStorage, (Tuple<DutyShift, Shift>)dutyShiftShiftTuple);
                        this.genLactationVaTimes(detailList, datePeriod, date, baseSetDy, dutyShiftsRanges, ((DutyShift)dutyShiftShiftTuple.item1).getDateTypeModel());
                    } else if (BaseSetTimeBreastDayTypeEnum.CUSTOM.id.compareTo(specialVaMethodId) == 0) {
                        BillResponse billResp = this.genLactationVaTimes(date, baseSetDy, dutyShiftsRanges, lactationTimeStorage, ((DutyShift)dutyShiftShiftTuple.item1).getDateTypeModel());
                        if (!billResp.isSuccess()) {
                            LOG.info("\u751f\u6210\u65f6\u6bb5\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)billResp.getMessage());
                            return billResp;
                        }
                        List previewVos = (List)billResp.getData();
                        detailList.addAll(previewVos);
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("\u81ea\u5b9a\u4e49\u7684\u7279\u6b8a\u5047\u4f11\u5047\u65b9\u5f0f\uff1a{}", (Object)specialVaMethodId);
                        }
                        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, SpecialVaExpService.class, (String)"kd.sdk.wtc.wtabm.business.spva.SpecialVaExpService", null);
                        ShiftDto shiftDto = ConvertUtils.convertShift((Shift)dutyShiftShiftTuple.item2);
                        SpecialVaTimeParam req = new SpecialVaTimeParam().setAttFileBoId(this.attfileBo.longValue()).setShiftDate(WTCDateUtils.toLocalDate((Date)date)).setMaxVaTimeInHour(lactationTimeStorage.getOffTimePerDay()).setSpecialVaTypeDyn(specialVaMethodDyn).setShiftVid(((Shift)dutyShiftShiftTuple.item2).getId().longValue()).setShiftDto(shiftDto);
                        List calResult = hrPluginProxy.callReplace(lactationVaService -> lactationVaService.createSubEntry(req));
                        Date finalDate = date;
                        calResult.stream().filter(Objects::nonNull).forEach(extSpvaTypeTimePeriods -> extSpvaTypeTimePeriods.forEach(timeInfo -> {
                            Tuple datePeriod = new Tuple((Object)WTCDateUtils.toDate((LocalDateTime)timeInfo.getStartDateTime()), (Object)WTCDateUtils.toDate((LocalDateTime)timeInfo.getEndDateTime()));
                            this.genLactationVaTimes(detailList, (Tuple<Date, Date>)datePeriod, finalDate, baseSetDy, dutyShiftsRanges, ((DutyShift)dutyShiftShiftTuple.item1).getDateTypeModel());
                        }));
                    }
                }
            }
            date = WTCDateUtils.addDays((Date)date, (int)1);
        }
        if (anySatisfyDateRange) {
            return BillResponse.success(detailList);
        }
        String vaTypeName = this.dyObject.getString(String.join((CharSequence)".", this.checkEnum.getType(), "name"));
        return BillResponse.error(detailList, (List)WTCCollections.modifiableList((Object[])new String[]{VaKDStringHelper.notSatisfyDateRange(vaTypeName)}));
    }

    private static boolean isSatisfyDateRange(DutyShift startShift, DynamicObject basesetDy) {
        IDateRangeService dateRangeService = (IDateRangeService)WTCAppContextHelper.getBean(DateRangeServiceImpl.class);
        Long startShiftDateType = startShift.getDateTypeModel() == null ? null : startShift.getDateTypeModel().getId();
        String fieldDateRangeCondition = basesetDy.getString("daterangecondition");
        return dateRangeService.isSatisfyDateRange(startShiftDateType, startShift.getDateAttribute().getCode(), fieldDateRangeCondition);
    }

    private VaDetailPreviewVo genLactationVaTimes(List<VaDetailPreviewVo> details, Tuple<Date, Date> datePeriod, Date date, DynamicObject baseSetDy, List<Tuple<DutyShift, Shift>> dutyShiftsRanges, DateType dateType) {
        SpecialVaTimeDto specialVaTimeDto = new SpecialVaTimeDto(WTCDateUtils.toLocalDateTime((Date)((Date)datePeriod.item1)), WTCDateUtils.toLocalDateTime((Date)((Date)datePeriod.item2)));
        BillApplyTimeResult standardResult = VaEntityCheckService.calCustomVaApplyTime(baseSetDy, dutyShiftsRanges, (Date)datePeriod.item1, (Date)datePeriod.item2, date);
        BillApplyTimeResult billApplyTimeResult = VaInfoService.onVaCalTimesExt(this.attfileBo, this.dyObject, baseSetDy, dutyShiftsRanges, specialVaTimeDto, standardResult);
        if (billApplyTimeResult == null) {
            billApplyTimeResult = standardResult;
        }
        long dateTypeId = VaEntityCheckService.getdateTypeId(dateType);
        VaDetailPreviewVo view = new VaDetailPreviewVo().setDate(date).setApplyTimeHour(billApplyTimeResult.getValHour()).setApplyTimeDay(billApplyTimeResult.getValDay()).setUnit(billApplyTimeResult.getUnit()).setDateType(dateTypeId);
        VaDetailItemPreviewVo itemVo = new VaDetailItemPreviewVo().setDate(date).setDateTypeId(dateTypeId).setStartTime((Date)datePeriod.item1).setEndTime((Date)datePeriod.item2).setApplyTimeHour(billApplyTimeResult.getValHour()).setApplyTimeDay(billApplyTimeResult.getValDay()).setUnit(billApplyTimeResult.getUnit()).setRowSeq(1);
        view.getItemVos().add(itemVo);
        details.add(view);
        return view;
    }

    private static long getdateTypeId(DateType dateType) {
        long dateTypeId = 0L;
        if (dateType != null && dateType.getId() != null) {
            dateTypeId = dateType.getId();
        }
        return dateTypeId;
    }

    private BillResponse genLactationVaTimes(Date naturalDate, DynamicObject baseSetDy, List<Tuple<DutyShift, Shift>> dutyShiftsRanges, VaLactationTimeStorage lactationTimeStorage, DateType dateType) {
        BillResponse billResponse;
        Date endDate;
        Date startDate;
        ArrayList<VaDetailItemPreviewVo> itemVos = new ArrayList<VaDetailItemPreviewVo>(10);
        if (lactationTimeStorage.getTimeStartOne() != -1) {
            startDate = WTCDateUtils.add((Date)naturalDate, (int)13, (int)lactationTimeStorage.getTimeStartOne());
            billResponse = this.checkAndCalCustomVaApplyTimes(dutyShiftsRanges, startDate, endDate = WTCDateUtils.add((Date)naturalDate, (int)13, (int)lactationTimeStorage.getTimeEndOne()), naturalDate, baseSetDy, dateType, 1);
            if (billResponse.isSuccess()) {
                itemVos.add((VaDetailItemPreviewVo)billResponse.getData());
            } else {
                return billResponse;
            }
        }
        if (lactationTimeStorage.getTimeStartTwo() != -1) {
            startDate = WTCDateUtils.add((Date)naturalDate, (int)13, (int)lactationTimeStorage.getTimeStartTwo());
            billResponse = this.checkAndCalCustomVaApplyTimes(dutyShiftsRanges, startDate, endDate = WTCDateUtils.add((Date)naturalDate, (int)13, (int)lactationTimeStorage.getTimeEndTwo()), naturalDate, baseSetDy, dateType, 2);
            if (billResponse.isSuccess()) {
                itemVos.add((VaDetailItemPreviewVo)billResponse.getData());
            } else {
                return billResponse;
            }
        }
        if (lactationTimeStorage.getTimeStartThree() != -1) {
            startDate = WTCDateUtils.add((Date)naturalDate, (int)13, (int)lactationTimeStorage.getTimeStartThree());
            billResponse = this.checkAndCalCustomVaApplyTimes(dutyShiftsRanges, startDate, endDate = WTCDateUtils.add((Date)naturalDate, (int)13, (int)lactationTimeStorage.getTimeEndThree()), naturalDate, baseSetDy, dateType, 3);
            if (billResponse.isSuccess()) {
                itemVos.add((VaDetailItemPreviewVo)billResponse.getData());
            } else {
                return billResponse;
            }
        }
        if (lactationTimeStorage.getTimeStartFour() != -1) {
            startDate = WTCDateUtils.add((Date)naturalDate, (int)13, (int)lactationTimeStorage.getTimeStartFour());
            billResponse = this.checkAndCalCustomVaApplyTimes(dutyShiftsRanges, startDate, endDate = WTCDateUtils.add((Date)naturalDate, (int)13, (int)lactationTimeStorage.getTimeEndFour()), naturalDate, baseSetDy, dateType, 4);
            if (billResponse.isSuccess()) {
                itemVos.add((VaDetailItemPreviewVo)billResponse.getData());
            } else {
                return billResponse;
            }
        }
        if (lactationTimeStorage.getTimeStartFive() != -1) {
            startDate = WTCDateUtils.add((Date)naturalDate, (int)13, (int)lactationTimeStorage.getTimeStartFive());
            billResponse = this.checkAndCalCustomVaApplyTimes(dutyShiftsRanges, startDate, endDate = WTCDateUtils.add((Date)naturalDate, (int)13, (int)lactationTimeStorage.getTimeEndFive()), naturalDate, baseSetDy, dateType, 5);
            if (billResponse.isSuccess()) {
                itemVos.add((VaDetailItemPreviewVo)billResponse.getData());
            } else {
                return billResponse;
            }
        }
        ArrayList<VaDetailPreviewVo> resultList = new ArrayList<VaDetailPreviewVo>(10);
        long dateTypeId = VaEntityCheckService.getdateTypeId(dateType);
        VaDetailPreviewVo view = new VaDetailPreviewVo().setDate(naturalDate).setUnit(baseSetDy.getString("unit")).setDateType(dateTypeId).setItemVos(itemVos);
        view.adjustApplyTime();
        resultList.add(view);
        return BillResponse.success(resultList);
    }

    @Deprecated
    public static BillResponse checkAndCalCustomVaApplyTime(List<Tuple<DutyShift, Shift>> dutyShiftsRanges, Date startDate, Date endDate, Date naturalDate, DynamicObject baseSetDy, DateType dateType, int rowIndex) {
        return BillResponse.success();
    }

    protected BillResponse checkAndCalCustomVaApplyTimes(List<Tuple<DutyShift, Shift>> dutyShiftsRanges, Date startDate, Date endDate, Date naturalDate, DynamicObject baseSetDy, DateType dateType, int rowIndex) {
        Date matchShiftDate = null;
        for (Tuple<DutyShift, Shift> shiftTuple : dutyShiftsRanges) {
            Date rosterDate = ((DutyShift)shiftTuple.item1).getRosterDate();
            Date rosterStart = DateUtils.addSeconds((Date)rosterDate, (int)((Shift)shiftTuple.item2).getLastShiftStartDate());
            Date rosterEnd = DateUtils.addSeconds((Date)rosterDate, (int)((Shift)shiftTuple.item2).getLastShiftEndDate());
            if (RefDateType.NEXTDAY.code.equals(((Shift)shiftTuple.item2).getLastRefEndDay())) {
                rosterEnd = DateUtils.addDays((Date)rosterEnd, (int)1);
            }
            if (rosterStart.after(endDate)) break;
            if (WTCDateUtils.getDateInsectionTimes((Date)rosterStart, (Date)rosterEnd, (Date)startDate, (Date)endDate) == 0L) continue;
            if (matchShiftDate != null) {
                String failMsg = ResManager.loadKDString((String)"\u6309\u65f6\u5206\u7533\u8bf7\u4e0d\u5141\u8bb8\u8de8\u73ed\u6b21\u63d0\u4f11\u5047\u5355\u3002", (String)"BillCommonCheckHelper_31", (String)"wtc-wtabm-business", (Object[])new Object[0]);
                return BillResponse.error(null, (List)Lists.newArrayList((Object[])new String[]{failMsg}));
            }
            matchShiftDate = rosterDate;
        }
        if (matchShiftDate == null) {
            matchShiftDate = naturalDate;
        }
        SpecialVaTimeDto specialVaTimeDto = new SpecialVaTimeDto(WTCDateUtils.toLocalDateTime((Date)startDate), WTCDateUtils.toLocalDateTime((Date)endDate));
        BillApplyTimeResult standardTimeResult = VaEntityCheckService.calCustomVaApplyTime(baseSetDy, dutyShiftsRanges, startDate, endDate, matchShiftDate);
        BillApplyTimeResult billApplyTimeResult = VaInfoService.onVaCalTimesExt(this.attfileBo, this.dyObject, baseSetDy, dutyShiftsRanges, specialVaTimeDto, standardTimeResult);
        if (billApplyTimeResult == null) {
            billApplyTimeResult = standardTimeResult;
        }
        VaDetailItemPreviewVo itemVo = VaEntityCheckService.generateItemVo(billApplyTimeResult, matchShiftDate, dateType, startDate, endDate, rowIndex);
        return BillResponse.success((Object)itemVo);
    }

    private static VaDetailItemPreviewVo generateItemVo(BillApplyTimeResult billApplyTimeResult, Date ownDate, DateType dateType, Date startDate, Date endDate, int rowSeq) {
        long dateTypeId = VaEntityCheckService.getdateTypeId(dateType);
        VaDetailItemPreviewVo itemVo = new VaDetailItemPreviewVo().setDate(ownDate).setDateTypeId(dateTypeId).setStartTime(startDate).setEndTime(endDate).setApplyTimeHour(billApplyTimeResult.getValHour()).setApplyTimeDay(billApplyTimeResult.getValDay()).setUnit(billApplyTimeResult.getUnit()).setRowSeq(rowSeq);
        return itemVo;
    }

    private static Tuple<Date, Date> getStartEndDate(long spVaMethod, VaLactationTimeStorage lactationTimeStorage, Tuple<DutyShift, Shift> dutyShiftShiftTuple) {
        Date rosterDate = ((DutyShift)dutyShiftShiftTuple.item1).getRosterDate();
        int lastShiftStart = ((Shift)dutyShiftShiftTuple.item2).getOffNonPlan() ? 0 : ((Shift)dutyShiftShiftTuple.item2).getLastShiftStartDate();
        int lastShiftEndDate = ((Shift)dutyShiftShiftTuple.item2).getOffNonPlan() ? 86400 : ((Shift)dutyShiftShiftTuple.item2).getLastShiftEndDate();
        Date shiftStartDate = new Date(rosterDate.getTime() + (long)lastShiftStart * 1000L);
        Date shiftEndDate = new Date(rosterDate.getTime() + (long)lastShiftEndDate * 1000L);
        if (StringUtils.equals((CharSequence)((Shift)dutyShiftShiftTuple.item2).getLastRefEndDay(), (CharSequence)RefDateType.NEXTDAY.code)) {
            shiftEndDate = DateUtils.addDays((Date)shiftEndDate, (int)1);
        }
        BigDecimal offTimePerDay = lactationTimeStorage.getOffTimePerDay();
        BigDecimal offTimeSecondDecimal = offTimePerDay.multiply(BigDecimal.valueOf(3600000L)).setScale(0, RoundingMode.HALF_UP);
        long offTimeSeconds = offTimeSecondDecimal.longValue();
        if (NumberUtils.compare((long)spVaMethod, (long)BaseSetTimeBreastDayTypeEnum.COME_LATE.id) == 0) {
            Date endDate = new Date(shiftStartDate.getTime() + offTimeSeconds);
            if (endDate.after(shiftEndDate)) {
                endDate = shiftEndDate;
            }
            return new Tuple((Object)shiftStartDate, (Object)endDate);
        }
        Date startDate = new Date(shiftEndDate.getTime() - offTimeSeconds);
        if (startDate.before(shiftStartDate)) {
            startDate = shiftStartDate;
        }
        return new Tuple((Object)startDate, (Object)shiftEndDate);
    }

    public static BillResponse getDateRangeTips(Date startdate, Date enddate, Date lactationEnd, Date bornDate) {
        BillResponse response = new BillResponse();
        StringJoiner joiner = new StringJoiner("~");
        if (startdate.before(bornDate) || startdate.after(lactationEnd)) {
            joiner.add(WTCDateUtils.date2Str((Date)startdate, (String)"yyyy-MM-dd"));
        }
        if (enddate.before(bornDate) || enddate.after(lactationEnd)) {
            joiner.add(WTCDateUtils.date2Str((Date)enddate, (String)"yyyy-MM-dd"));
        }
        response.setSuccess(joiner.length() == 0);
        response.setMessage((List)Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"%s\u8d85\u51fa\u4f11\u5047\u6709\u6548\u8303\u56f4\uff0c\u8bf7\u8c03\u6574\u3002", (String)"VaEntityCheckService_12", (String)"wtc-wtabm-business", (Object[])new Object[]{joiner.toString()})}));
        return response;
    }

    public static BillApplyTimeResult calCustomVaApplyTime(DynamicObject baseSetDyn, List<Tuple<DutyShift, Shift>> dutyShiftsRange, Date startDate, Date endDate, Date ownDate) {
        String unit = baseSetDyn.getString("unit");
        String specialVaType = baseSetDyn.getString("specialdaytype");
        boolean isSpecialVaType = baseSetDyn.getBoolean("isspecialholiday");
        List detailList = WTCCollections.modifiableEmptyList();
        boolean isLactationType = isSpecialVaType && StringUtils.equals((CharSequence)SpecialVaTypeEnum.LACTATION_TYPE.vaType, (CharSequence)specialVaType);
        BigDecimal entryVaTimeHour = BigDecimal.ZERO;
        BigDecimal entryVaTimeDay = BigDecimal.ZERO;
        Map<Date, Tuple> dutyShiftsRangeMap = dutyShiftsRange.stream().collect(Collectors.toMap(duty -> ((DutyShift)duty.item1).getRosterDate(), duty -> duty, (d1, d2) -> d1));
        for (Tuple<DutyShift, Shift> dutyShiftTuple : dutyShiftsRange) {
            Date rosterDate = ((DutyShift)dutyShiftTuple.item1).getRosterDate();
            DateAttribute dateAttribute = ((DutyShift)dutyShiftTuple.item1).getDateAttribute();
            boolean satisfyDateRange = VaEntityCheckService.isSatisfyDateRange((DutyShift)dutyShiftTuple.item1, baseSetDyn);
            BigDecimal sumHour = BigDecimal.ZERO;
            BigDecimal sumDay = BigDecimal.ZERO;
            if (satisfyDateRange) {
                ShiftMiddleRule shiftMiddleRule = ((Shift)dutyShiftTuple.item2).getShiftMiddleRule();
                List shiftDetails = ((Shift)dutyShiftTuple.item2).getShiftDetailList();
                BigDecimal dateInsectionTimes = BigDecimal.ZERO;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("\u3010\u4f11\u5047\u7533\u8bf7\u65f6\u957f\u8ba1\u7b97\u3011start calApplyTimes for customer method startDate:{}, ownDate:{}, dateAttribute :{}", new Object[]{startDate, ownDate, dateAttribute});
                }
                if (((Shift)dutyShiftTuple.item2).getOffNonPlan() || CollectionUtils.isEmpty((Collection)shiftDetails)) {
                    Date shiftStartDate = WTCDateUtils.getDayStart((Date)((DutyShift)dutyShiftTuple.item1).getRosterDate());
                    Date shiftEndDate = WTCDateUtils.addDays((Date)shiftStartDate, (int)1);
                    if (!shiftEndDate.after(startDate)) continue;
                    Date prevDay = WTCDateUtils.addDays((Date)WTCDateUtils.getDayStart((Date)rosterDate), (int)-1);
                    Tuple prev = dutyShiftsRangeMap.get(prevDay);
                    Date prevEndDateTime = null;
                    if (prev != null) {
                        boolean prevOffNonPlan = ((Shift)prev.item2).getOffNonPlan();
                        boolean prevIsCrossDay = StringUtils.equals((CharSequence)RefDateType.NEXTDAY.code, (CharSequence)((Shift)prev.item2).getLastRefEndDay());
                        if (!prevOffNonPlan && prevIsCrossDay) {
                            int lastShiftEndDate = ((Shift)prev.item2).getLastShiftEndDate();
                            prevEndDateTime = WTCDateUtils.getDate((Date)WTCDateUtils.addDays((Date)((DutyShift)prev.item1).getRosterDate(), (int)1), (Integer)lastShiftEndDate);
                        }
                    }
                    if (prevEndDateTime != null && prevEndDateTime.after(shiftStartDate)) {
                        shiftStartDate = prevEndDateTime;
                    }
                    long shiftInsectionTimes = WTCDateUtils.getDateInsectionTimes((Date)startDate, (Date)endDate, (Date)shiftStartDate, (Date)shiftEndDate);
                    dateInsectionTimes = dateInsectionTimes.add(BigDecimal.valueOf(shiftInsectionTimes));
                } else {
                    boolean isContainOverTime = baseSetDyn.getBoolean("iscontainovertime");
                    String timeCalcType = baseSetDyn.getString("timecalctype");
                    for (ShiftDetail detail : shiftDetails) {
                        if (StringUtils.equalsAny((CharSequence)detail.getOutWorkType(), (CharSequence[])new CharSequence[]{OutWorkType.BREAK.code}) || !isContainOverTime && StringUtils.equals((CharSequence)detail.getOutWorkType(), (CharSequence)OutWorkType.OT.code) && StringUtils.equals((CharSequence)"A", (CharSequence)timeCalcType) && !isLactationType) continue;
                        Date detailStartDate = ShiftParseUtil.getRosterStartDate((ShiftDetail)detail, (Date)rosterDate);
                        Date detailEndDate = ShiftParseUtil.getRosterDetailEndDate((ShiftDetail)detail, (Date)rosterDate);
                        long shiftDetailInsectionTimes = WTCDateUtils.getDateInsectionTimes((Date)startDate, (Date)endDate, (Date)detailStartDate, (Date)detailEndDate);
                        dateInsectionTimes = dateInsectionTimes.add(BigDecimal.valueOf(shiftDetailInsectionTimes));
                    }
                }
                sumHour = dateInsectionTimes.divide(DECIMAL_ONE_HOUR_SECONDS, 6, RoundingMode.HALF_UP);
                if (shiftMiddleRule.getAlldayhour() != null && BigDecimal.ZERO.compareTo(shiftMiddleRule.getAlldayhour()) != 0) {
                    sumDay = sumHour.divide(shiftMiddleRule.getAlldayhour(), 6, RoundingMode.HALF_UP);
                }
            }
            if (DateUtils.isSameDay((Date)ownDate, (Date)rosterDate)) {
                BillApplyDayTime detail = VaEntityCheckService.createBillApplyDayTime(satisfyDateRange, rosterDate, sumDay, sumHour, unit);
                detailList.add(detail);
            }
            entryVaTimeHour = entryVaTimeHour.add(sumHour);
            entryVaTimeDay = entryVaTimeDay.add(sumDay);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("end calApplyTimes for customer entryVaTimeHour :{}, entryVaTimeDay :{}", (Object)entryVaTimeHour, (Object)entryVaTimeDay);
        }
        BillApplyTimeResult billApplyTimeResult = new BillApplyTimeResult(unit, entryVaTimeHour, entryVaTimeDay);
        billApplyTimeResult.setDayTimeDetails(detailList);
        return billApplyTimeResult;
    }

    private static BillApplyDayTime createBillApplyDayTime(boolean satisfyDateRange, Date rosterDate, BigDecimal valDay, BigDecimal valHour, String unit) {
        BillApplyDayTime detail = new BillApplyDayTime();
        detail.setUnit(unit);
        detail.setValHour(valHour);
        detail.setValDay(valDay);
        detail.setRosterDate(rosterDate);
        detail.setSatisfyDateRange(satisfyDateRange);
        return detail;
    }

    public static VaLactationTimeStorage generateLactationInfo(long attPersonId, DynamicObject matchBaseSet) {
        VaLactationTimeStorage timeStorage = new VaLactationTimeStorage();
        Map personInfoMap = AttendPersonServiceImpl.getInstance().queryFertilityInfoByPersonId(Collections.singletonList(attPersonId), null);
        Map personInfo = (Map)personInfoMap.get(attPersonId);
        if (personInfo == null) {
            return timeStorage;
        }
        int childrenNumber = (Integer)personInfo.get("childrennumber");
        Date bornDate = (Date)personInfo.get("birthday");
        if (childrenNumber == 0 || bornDate == null) {
            return timeStorage;
        }
        timeStorage.setFetuses(childrenNumber);
        timeStorage.setBornDate(WTCDateUtils.date2Str((Date)bornDate, (String)"yyyy-MM-dd"));
        LocalDate date = WTCDateUtils.toLocalDate((Date)bornDate).plus(matchBaseSet.getInt("breasttime"), ChronoUnit.MONTHS);
        String endDateStr = WTCDateUtils.format((LocalDate)date);
        timeStorage.setLactationEndDate(endDateStr);
        Optional<Tuple<BigDecimal, String>> tuple = VaEntityCheckService.analysisVaBaseSet(matchBaseSet, childrenNumber);
        tuple.ifPresent(bigDecimalStringTuple -> timeStorage.setOffTimePerDay(((BigDecimal)bigDecimalStringTuple.item1).setScale(2, RoundingMode.HALF_UP)));
        return timeStorage;
    }

    public static Optional<Tuple<BigDecimal, String>> analysisVaBaseSet(DynamicObject vaBaseSet, int childrenNum) {
        DynamicObjectCollection collection = vaBaseSet.getDynamicObjectCollection("wtp_vabasesetbreast");
        int needRow = Math.min(collection.size() - 1, childrenNum - 1);
        if (collection.isEmpty() || needRow == -1) {
            return Optional.empty();
        }
        DynamicObject matchRow = (DynamicObject)collection.get(needRow);
        return Optional.of(new Tuple((Object)matchRow.getBigDecimal("offtimeperday"), (Object)matchRow.getString("offtimeunit")));
    }

    public BillResponse checkAdviceAndAfter() {
        BillResponse response = super.checkAdviceAndAfter();
        return response;
    }

    private static String buildUnitInfoByBaseSet(Integer failCheckAdvanceAfterNum, String failCheckAdvanceAfterUnit) {
        String info = "";
        if (BaseSetUnitTypeEnum.DAY.getCode().equals(failCheckAdvanceAfterUnit)) {
            info = ResManager.loadKDString((String)"{0}\u4e2a\u81ea\u7136\u65e5", (String)"BustripEntityCheckService_3", (String)"wtc-wtabm-business", (Object[])new Object[]{failCheckAdvanceAfterNum});
        } else if (BaseSetUnitTypeEnum.MONTH.getCode().equals(failCheckAdvanceAfterUnit)) {
            info = ResManager.loadKDString((String)"{0}\u4e2a\u6708", (String)"BustripEntityCheckService_4", (String)"wtc-wtabm-business", (Object[])new Object[]{failCheckAdvanceAfterNum});
        } else if (BaseSetUnitTypeEnum.PERIOD.getCode().equals(failCheckAdvanceAfterUnit)) {
            info = ResManager.loadKDString((String)"{0}\u4e2a\u8003\u52e4\u671f\u95f4", (String)"BustripEntityCheckService_5", (String)"wtc-wtabm-business", (Object[])new Object[]{failCheckAdvanceAfterNum});
        } else if (BaseSetUnitTypeEnum.WEEKDAY.getCode().equals(failCheckAdvanceAfterUnit)) {
            info = ResManager.loadKDString((String)"{0}\u4e2a\u5de5\u4f5c\u65e5", (String)"BustripEntityCheckService_6", (String)"wtc-wtabm-business", (Object[])new Object[]{failCheckAdvanceAfterNum});
        }
        return info;
    }

    public BillResponse checkApplyTime(BillApplyTimeResult applyTimeResult) {
        BillResponse response = this.checkApplyDayTime(applyTimeResult);
        if (!response.isSuccess()) {
            return response;
        }
        response = this.checkApplySpan(applyTimeResult);
        if (!response.isSuccess()) {
            return response;
        }
        return super.checkApplyTime(applyTimeResult);
    }

    private BillResponse checkApplyDayTime(BillApplyTimeResult applyTimeResult) {
        List satisfyDateRange;
        List dayTimeDetails = applyTimeResult.getDayTimeDetails();
        if (WTCCollections.isNotEmpty((Collection)dayTimeDetails) && WTCCollections.isEmpty(satisfyDateRange = dayTimeDetails.stream().filter(BillApplyDayTime::getSatisfyDateRange).collect(Collectors.toList()))) {
            String vaTypeName = this.dyObject.getString(String.join((CharSequence)".", this.checkEnum.getType(), "name"));
            String message = VaKDStringHelper.notSatisfyDateRange(vaTypeName);
            return BillResponse.error((Object)"", (List)WTCCollections.modifiableList((Object[])new String[]{message}));
        }
        return super.checkApplyTime(applyTimeResult);
    }

    public BillResponse checkApplyTime(BigDecimal applyTime) {
        BillResponse billResponse = super.checkApplyTime(applyTime);
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        billResponse = this.checkMaxApplyTime(applyTime);
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        return BillResponse.success((Object)billResponse.getData());
    }

    public void setCheckApplySpan(boolean checkApplySpan) {
        this.checkApplySpan = checkApplySpan;
    }

    private BillResponse checkApplySpan(BillApplyTimeResult applyTimeResult) {
        String timeWithUnit;
        if (!this.checkApplySpan) {
            return BillResponse.success();
        }
        BillResponse billResponse = this.checkApplyMethod();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        DynamicObject rule = this.getMatchRule();
        Date startDate = this.dyObject.getDate(this.checkEnum.getStartDate());
        Date endDate = this.dyObject.getDate(this.checkEnum.getEndDate());
        startDate = VaEntityCheckService.getDate((Date)startDate);
        endDate = VaEntityCheckService.getDate((Date)endDate);
        long type = this.dyObject.getLong(this.checkEnum.getType() + ".id");
        Map baseSetDyMap = this.billAutoOperator.getBaseSetDy(this.attfileBo.longValue(), startDate, endDate, type);
        DynamicObject baseSetDy = (DynamicObject)baseSetDyMap.entrySet().iterator().next().getValue();
        boolean isQuota = rule.getBoolean("isquota");
        BigDecimal applySpan = BigDecimal.ZERO;
        String unit = null;
        String errorMsg = null;
        BigDecimal applyTime = BigDecimal.ZERO;
        DecimalFormat decimalFormat = new DecimalFormat("0.##");
        if (isQuota) {
            DynamicObject deductrule;
            Long deductruleBoID = rule.getLong("deductrule.id");
            Date useVersionDate = VaBaseService.getInstance().getUseVersionDate(this.dyObject, this.checkEnum);
            DynamicObject[] vaRuleHisList = TimeSeqEntityGenerateUtils.getHisDyArr((String)"wtp_qtdeducrule", (Set)Sets.newHashSet((Object[])new Long[]{deductruleBoID}), (LocalDate)WTCDateUtils.toLocalDate((Date)useVersionDate), (LocalDate)WTCDateUtils.toLocalDate((Date)useVersionDate));
            DynamicObject dynamicObject = deductrule = vaRuleHisList != null && vaRuleHisList.length > 0 ? vaRuleHisList[0] : null;
            if (deductrule != null && deductrule.getBigDecimal("lowerlimit") != null) {
                applySpan = deductrule.getBigDecimal("lowerlimit").stripTrailingZeros();
                unit = deductrule.getString("unit");
                String vaTypeName = rule.getString("vatype.name");
                if (StringUtils.equals((CharSequence)unit, (CharSequence)"D")) {
                    unit = "A";
                    applyTime = applyTimeResult.getValDay();
                    timeWithUnit = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u5929", (String)"BillCommonCheckHelper_5", (String)"wtc-wtabm-business", (Object[])new Object[0]), decimalFormat.format(applySpan));
                } else {
                    unit = "B";
                    applyTime = applyTimeResult.getValHour();
                    timeWithUnit = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u5c0f\u65f6", (String)"BillCommonCheckHelper_13", (String)"wtc-wtabm-business", (Object[])new Object[0]), decimalFormat.format(applySpan));
                }
                errorMsg = String.format(ResManager.loadKDString((String)"%1$s\u5bf9\u5e94\u5b9a\u989d\u6263\u51cf\u89c4\u5219\u7684\u5355\u4f4d\u65f6\u957f\u4e3a%2$s\uff0c\u8bf7\u4fee\u6539\u7533\u8bf7\u65f6\u957f\u3002", (String)"VaEntityCheckService_11", (String)"wtc-wtabm-business", (Object[])new Object[0]), vaTypeName, timeWithUnit);
            }
        }
        if (BigDecimal.ZERO.compareTo(applySpan) == 0) {
            boolean isApplySpan = baseSetDy.getBoolean("isapplyspan");
            if (!isApplySpan) {
                return BillResponse.success((Object)applyTime);
            }
            applySpan = baseSetDy.getBigDecimal("applyspan");
            applyTime = applyTimeResult.getTimeByUnit();
            unit = baseSetDy.getString(this.checkEnum.getApplyBillBaseSetEnum().getUnit());
            errorMsg = ResManager.loadKDString((String)"\u7533\u8bf7\u65f6\u957f\u4e0d\u7b26\u5408\u5355\u4f4d\u65f6\u957f%1$s\u7684\u500d\u6570\u3002", (String)"VaInfoService_13", (String)"wtc-wtabm-business", (Object[])new Object[0]);
        }
        if (applySpan != null && BigDecimal.ZERO.compareTo(applySpan) < 0) {
            timeWithUnit = StringUtils.equals(unit, (CharSequence)"A") ? String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u5929", (String)"BillCommonCheckHelper_5", (String)"wtc-wtabm-business", (Object[])new Object[0]), decimalFormat.format(applySpan)) : String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u5c0f\u65f6", (String)"BillCommonCheckHelper_13", (String)"wtc-wtabm-business", (Object[])new Object[0]), decimalFormat.format(applySpan));
            BigDecimal[] remainder = applyTime.divideAndRemainder(applySpan);
            if (BigDecimal.ZERO.compareTo(remainder[1]) < 0) {
                errorMsg = String.format(errorMsg, timeWithUnit);
                ArrayList<String> list = new ArrayList<String>();
                list.add(errorMsg);
                return BillResponse.error(null, list);
            }
        }
        return BillResponse.success((Object)applyTime);
    }

    private BillResponse checkApplyMethod() {
        String applytimetype = this.dyObject.getString(this.checkEnum.getType() + "." + "applytimetype");
        String startMethod = this.dyObject.getString(this.checkEnum.getStartMethod());
        ApplicationTypeEnum startMethodEnum = null;
        List applyTypeEnums = ApplicationTypeEnum.parseStrToEnum((String)applytimetype);
        WtcTimeRangeBtnTypeEnum wtcTimeRangeBtnTypeEnum = WtcTimeRangeBtnTypeEnum.getEnumByValue((String)startMethod);
        StringBuilder typeStr = new StringBuilder();
        for (ApplicationTypeEnum applyTypeEnum : applyTypeEnums) {
            if (applyTypeEnum.equals((Object)wtcTimeRangeBtnTypeEnum.applyTimeTypeEnum)) {
                startMethodEnum = applyTypeEnum;
            }
            typeStr.append(applyTypeEnum.getDescription()).append("\u3001");
        }
        if (startMethodEnum == null) {
            ArrayList<String> msg = new ArrayList<String>();
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4f11\u5047\u65f6\u95f4\u8bf7\u6309%1$s\u7684\u65b9\u5f0f\u7533\u8bf7\u3002", (String)"VaEntityCheckService_10", (String)"wtc-wtabm-business", (Object[])new Object[0]), typeStr.substring(0, typeStr.length() - 1));
            msg.add(errorMsg);
            return BillResponse.error(null, msg);
        }
        return BillResponse.success();
    }

    private BillResponse checkMaxApplyTime(BigDecimal applyTime) {
        if (!this.init) {
            return BillResponse.success();
        }
        ArrayList<String> msg = new ArrayList<String>(4);
        boolean success = true;
        Date startDate = this.dyObject.getDate(this.checkEnum.getStartDate());
        Date endDate = this.dyObject.getDate(this.checkEnum.getEndDate());
        startDate = VaEntityCheckService.getDate((Date)startDate);
        endDate = VaEntityCheckService.getDate((Date)endDate);
        long type = this.dyObject.getLong(this.checkEnum.getType() + ".id");
        Map baseSetDyMap = this.billAutoOperator.getBaseSetDy(this.attfileBo.longValue(), startDate, endDate, type);
        DynamicObject baseSetDy = (DynamicObject)baseSetDyMap.entrySet().iterator().next().getValue();
        BigDecimal maxApplyTime = baseSetDy.getBigDecimal("maxholidaytime");
        if (BigDecimal.ZERO.compareTo(maxApplyTime = maxApplyTime.setScale(2, RoundingMode.HALF_UP)) >= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("\u6700\u5927\u7533\u8bf7\u65f6\u957f\u4e0d\u53c2\u4e0e\u6821\u9a8c\uff1amaxApplyTime:{}", (Object)maxApplyTime);
            }
            return BillResponse.success();
        }
        String unit = baseSetDy.getString(this.checkEnum.getApplyBillBaseSetEnum().getUnit());
        if ((applyTime = applyTime.setScale(2, RoundingMode.HALF_UP)).compareTo(BigDecimal.ZERO) == 0) {
            String errorMsg = ResManager.loadKDString((String)"\u7533\u8bf7\u65f6\u957f\u4e0d\u80fd\u4e3a0\u3002", (String)"BillCommonCheckHelper_12", (String)"wtc-wtabm-business", (Object[])new Object[0]);
            msg.add(errorMsg);
            success = false;
        }
        if (applyTime.compareTo(maxApplyTime) > 0) {
            String timeWithUnit = StringUtils.equals((CharSequence)unit, (CharSequence)"A") ? String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u5929", (String)"BillCommonCheckHelper_5", (String)"wtc-wtabm-business", (Object[])new Object[0]), maxApplyTime) : String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u5c0f\u65f6", (String)"BillCommonCheckHelper_13", (String)"wtc-wtabm-business", (Object[])new Object[0]), maxApplyTime);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u65f6\u957f\u4e0d\u53ef\u8d85\u8fc7%1$s\u3002", (String)"BillCommonCheckHelper_14", (String)"wtc-wtabm-business", (Object[])new Object[0]), timeWithUnit);
            msg.add(errorMsg);
            success = false;
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        this.checkBaseSetSuccess = true;
        return BillResponse.success();
    }

    public DynamicObject getBaseSetDy() {
        Date startDate = new Date(this.dyObject.getDate(this.checkEnum.getStartDate()).getTime());
        Date endDate = new Date(this.dyObject.getDate(this.checkEnum.getEndDate()).getTime());
        long type = this.dyObject.getLong(this.checkEnum.getType() + ".id");
        DynamicObject baseSetDyn = null;
        Map baseSetDy = this.billAutoOperator.getBaseSetDy(this.attfileBo.longValue(), startDate, endDate, type);
        if (MapUtils.isNotEmpty((Map)baseSetDy)) {
            List sortedKeys = baseSetDy.keySet().stream().sorted().collect(Collectors.toList());
            DynamicObject dynamicObject = baseSetDyn = this.billAutoOperator.isUseStartOrEnd() ? (DynamicObject)baseSetDy.get(sortedKeys.get(0)) : (DynamicObject)baseSetDy.get(sortedKeys.get(sortedKeys.size() - 1));
        }
        if (baseSetDyn == null) {
            LOG.info("\u672a\u67e5\u8be2\u5230\u4f11\u5047\u57fa\u7840\u914d\u7f6e\u3002startDate\uff1a{}\uff0c endDate:{}, type:{}, attfileBo:{}", new Object[]{startDate, endDate, type, this.attfileBo});
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4f11\u5047\u57fa\u7840\u914d\u7f6e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BillCommonCheckHelper_34", (String)"wtc-wtabm-business", (Object[])new Object[0]));
        }
        return baseSetDyn;
    }

    public BillResponse checkChangeSet(DynamicObject newEntryDy) {
        boolean hasChanged;
        String newEntryName = newEntryDy.getDynamicObjectType().getName();
        ApplyBillCheckEnum newEntryCheckEnum = StringUtils.equalsAny((CharSequence)newEntryName, (CharSequence[])new CharSequence[]{"wtabm_vainfo", "wtabm_vainfosingle"}) ? ApplyBillCheckEnum.VACATIONFORM : this.checkEnum;
        Date startDate = new Date(this.getDyObject().getDate(this.checkEnum.getStartDate()).getTime());
        Date endDate = new Date(this.getDyObject().getDate(this.checkEnum.getEndDate()).getTime());
        String startMethod = this.getDyObject().getString(this.checkEnum.getStartMethod());
        String endMethod = this.getDyObject().getString(this.checkEnum.getEndMethod());
        Date newStart = new Date(newEntryDy.getDate(newEntryCheckEnum.getStartDate()).getTime());
        Date newEnd = new Date(newEntryDy.getDate(newEntryCheckEnum.getEndDate()).getTime());
        String newStartMethod = newEntryDy.getString(newEntryCheckEnum.getStartMethod());
        String newEndMethod = newEntryDy.getString(newEntryCheckEnum.getEndMethod());
        long type = this.getDyObject().getLong(this.checkEnum.getType() + ".id");
        long newType = newEntryDy.getLong(newEntryCheckEnum.getType() + ".id");
        String newTypeName = newEntryDy.getLocaleString(newEntryCheckEnum.getType() + ".name").getLocaleValue();
        long specialVaMethodId = this.getDyObject().getLong(this.checkEnum.getSpecialVaMethod() + ".id");
        long newSpecialVaMethodId = newEntryDy.getLong(newEntryCheckEnum.getSpecialVaMethod() + ".id");
        String specialExtJson = this.getDyObject().getString(this.checkEnum.getSpecialVaJson());
        String newSpecialExtJson = newEntryDy.getString(newEntryCheckEnum.getSpecialVaJson());
        boolean timeChanged = this.specialExtJsonTimeChanged(specialExtJson, newSpecialExtJson);
        String reason = this.getDyObject().getString("entryreason");
        String reasonKey = newEntryCheckEnum == ApplyBillCheckEnum.VACATION ? "entryreason" : "reasontext";
        String newReason = newEntryDy.getString(reasonKey);
        boolean success = true;
        ArrayList msg = Lists.newArrayListWithExpectedSize((int)4);
        boolean bl = hasChanged = startDate.compareTo(newStart) != 0 || endDate.compareTo(newEnd) != 0 || newType != type || !StringUtils.equals((CharSequence)startMethod, (CharSequence)newStartMethod) || !StringUtils.equals((CharSequence)endMethod, (CharSequence)newEndMethod) || specialVaMethodId != newSpecialVaMethodId || !StringUtils.equals((CharSequence)reason, (CharSequence)newReason) || timeChanged;
        if (!hasChanged) {
            LOG.info("\u672a\u68c0\u6d4b\u5230\u53d8\u66f4\u4fe1\u606f\uff0c\u53d8\u66f4\u6821\u9a8c\u901a\u8fc7\uff0cnewEntryDy.pkValue:{}", newEntryDy.getPkValue());
            return BillResponse.success();
        }
        Map changeSetDy = this.billAutoOperator.getChangeSetDy(this.attfileBo.longValue(), startDate, endDate, type);
        if (MapUtils.isNotEmpty((Map)changeSetDy)) {
            DynamicObject value = (DynamicObject)changeSetDy.entrySet().iterator().next().getValue();
            if (Objects.nonNull(value)) {
                DynamicObjectCollection entryEntity;
                Set changeSet;
                String failMsg;
                LOG.info("\u627e\u5230\u4f11\u5047\u53d8\u66f4\u914d\u7f6e\uff1a{}", value.getPkValue());
                boolean ischangetime = value.getBoolean(this.checkEnum.getApplyBillChangeSetEnum().getIschangetime());
                boolean istypechange = value.getBoolean(this.checkEnum.getApplyBillChangeSetEnum().getIstypechange());
                if (ischangetime) {
                    String bgtimetype = value.getString(this.checkEnum.getApplyBillChangeSetEnum().getBgtimetype());
                    Map shiftMap = this.billAutoOperator.getShift(this.attfileBo.longValue(), startDate, endDate);
                    this.firstDateShift = this.getfirstShift(shiftMap);
                    this.lastDateShift = this.getlastShift(shiftMap);
                    if (HRStringUtils.equals((String)bgtimetype, (String)"A") && (this.checkStartNotBefore(startDate, startMethod, newStart, newStartMethod) || this.checkEndNotAfter(endDate, endMethod, newEnd, newEndMethod))) {
                        success = false;
                        LOG.info("endDate:{}, endMethod:{}, newEnd:{}, newEndMethod:{}", new Object[]{endDate, endMethod, newEnd, newEndMethod});
                        failMsg = VaKDStringHelper.changedOverTimePeriod(this.unifyBillEnum.getDescriptionStr());
                        msg.add(failMsg);
                    }
                } else if (startDate.compareTo(newStart) != 0 || endDate.compareTo(newEnd) != 0 || !HRStringUtils.equals((String)newStartMethod, (String)startMethod) || !HRStringUtils.equals((String)newEndMethod, (String)endMethod)) {
                    LOG.info("\u53d1\u751f\u53d8\u66f4");
                    success = false;
                    String failMsg2 = VaKDStringHelper.changedTimePeriod(this.unifyBillEnum.getDescriptionStr());
                    msg.add(failMsg2);
                }
                if (istypechange && !(changeSet = (entryEntity = value.getDynamicObjectCollection(this.checkEnum.getApplyBillChangeSetEnum().getEntryentity())).stream().map(dynamicObject -> dynamicObject.getLong(this.checkEnum.getApplyBillChangeSetEnum().getType() + ".id")).collect(Collectors.toSet())).contains(newType) && newType != type) {
                    success = false;
                    failMsg = VaKDStringHelper.changedVaType(this.unifyBillEnum.getDescriptionStr(), newTypeName);
                    msg.add(failMsg);
                }
            } else {
                success = false;
                String failMsg = VaKDStringHelper.canNotChange(this.unifyBillEnum.getDescriptionStr());
                msg.add(failMsg);
            }
        } else {
            success = false;
            String failMsg = VaKDStringHelper.canNotChange(this.unifyBillEnum.getDescriptionStr());
            msg.add(failMsg);
        }
        if (!success) {
            return BillResponse.error(null, (List)msg);
        }
        return BillResponse.success();
    }

    private boolean specialExtJsonTimeChanged(String specialExtJson, String newSpecialExtJson) {
        boolean timeEndFiveChanged;
        VaLactationTimeStorage lactationTimeStorage = (VaLactationTimeStorage)JSON.parseObject((String)specialExtJson, VaLactationTimeStorage.class);
        VaLactationTimeStorage newLactationTimeStorage = (VaLactationTimeStorage)JSON.parseObject((String)newSpecialExtJson, VaLactationTimeStorage.class);
        if (lactationTimeStorage == null) {
            return newLactationTimeStorage != null;
        }
        if (newLactationTimeStorage == null) {
            return true;
        }
        boolean timeStartOneChanged = lactationTimeStorage.getTimeStartOne() != newLactationTimeStorage.getTimeStartOne();
        boolean timeStartTwoChanged = lactationTimeStorage.getTimeStartTwo() != newLactationTimeStorage.getTimeStartTwo();
        boolean timeStartThreeChanged = lactationTimeStorage.getTimeStartThree() != newLactationTimeStorage.getTimeStartThree();
        boolean timeStartFourChanged = lactationTimeStorage.getTimeStartFour() != newLactationTimeStorage.getTimeStartFour();
        boolean timeStartFiveChanged = lactationTimeStorage.getTimeStartFive() != newLactationTimeStorage.getTimeStartFive();
        boolean timeEndOneChanged = lactationTimeStorage.getTimeEndOne() != newLactationTimeStorage.getTimeEndOne();
        boolean timeEndTwoChanged = lactationTimeStorage.getTimeEndTwo() != newLactationTimeStorage.getTimeEndTwo();
        boolean timeEndThreeChanged = lactationTimeStorage.getTimeEndThree() != newLactationTimeStorage.getTimeEndThree();
        boolean timeEndFourChanged = lactationTimeStorage.getTimeEndFour() != newLactationTimeStorage.getTimeEndFour();
        boolean bl = timeEndFiveChanged = lactationTimeStorage.getTimeEndFive() != newLactationTimeStorage.getTimeEndFive();
        return timeStartOneChanged || timeStartTwoChanged || timeStartThreeChanged || timeStartFourChanged || timeStartFiveChanged || timeEndOneChanged || timeEndTwoChanged || timeEndThreeChanged || timeEndFourChanged || timeEndFiveChanged;
    }
}

