/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.business.vaplan;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.sdk.wtc.wtabm.business.helper.vaplan.VaPlanRuleQuery;
import kd.sdk.wtc.wtabm.business.helper.vaplan.VaPlanRuleResp;
import kd.sdk.wtc.wtabm.business.helper.vaplan.VaRuleCalInfo;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.applybill.commonhelper.UnifyBillCommonHelper;
import kd.wtc.wtbs.business.web.billservice.common.BillSetCommonService;
import kd.wtc.wtbs.business.web.billservice.plan.BillPlanService;
import kd.wtc.wtbs.business.web.billservice.rule.BillRuleService;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.bill.PlanSceneEnum;
import kd.wtc.wtbs.common.model.billservice.BillDutyDatePlanInfo;
import kd.wtc.wtbs.common.model.billservice.BillDutyDateRuleInfo;
import kd.wtc.wtbs.common.model.billservice.BillRuleField;
import kd.wtc.wtbs.common.model.billservice.BillSetSpiltRangeQuery;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class VaPlanQueryService {
    public List<VaPlanRuleResp> getVaPlanAndRule(List<VaPlanRuleQuery> vaPlanRuleParams) {
        if (WTCCollections.isEmpty(vaPlanRuleParams)) {
            return new ArrayList<VaPlanRuleResp>(0);
        }
        List<BillDutyDatePlanInfo> billDutyDatePlanInfos = this.convertToBillPlanServiceParams(vaPlanRuleParams);
        BillPlanService billPlanService = BillPlanService.getInstance();
        billPlanService.fillPlanByAttFileAndDate(billDutyDatePlanInfos, AttFileScheduleEnum.VP, "wtp_vacationplan");
        BillRuleService billRuleService = new BillRuleService();
        List<BillDutyDateRuleInfo> billDutyDateRuleInfos = this.convertToBillRuleServiceParams(billDutyDatePlanInfos, vaPlanRuleParams);
        BillRuleField field = new BillRuleField();
        field.setRuleEntityName("wtp_varule");
        field.setRuleInPlan("varule");
        field.setRuleCalEntryKeyName("entryentity");
        field.setLimitJsonKeyName("limitscope");
        field.setTypeKeyName("vatype");
        billRuleService.fillRuleCalByRetrieval(billDutyDateRuleInfos, PlanSceneEnum.VP, field, true);
        return this.setResultToRequestParams(billDutyDatePlanInfos, billDutyDateRuleInfos, vaPlanRuleParams);
    }

    private List<BillDutyDatePlanInfo> convertToBillPlanServiceParams(List<VaPlanRuleQuery> vaPlanRuleParams) {
        ArrayList<BillDutyDatePlanInfo> result = new ArrayList<BillDutyDatePlanInfo>(vaPlanRuleParams.size());
        for (VaPlanRuleQuery vaPlanRuleParam : vaPlanRuleParams) {
            result.add(new BillDutyDatePlanInfo(vaPlanRuleParam.getAttFileBoId(), vaPlanRuleParam.getTargetDate()));
        }
        return result;
    }

    private List<BillDutyDateRuleInfo> convertToBillRuleServiceParams(List<BillDutyDatePlanInfo> billDutyDatePlanInfos, List<VaPlanRuleQuery> vaPlanRuleParams) {
        ArrayList<BillDutyDateRuleInfo> result = new ArrayList<BillDutyDateRuleInfo>(billDutyDatePlanInfos.size());
        for (int index = 0; index < billDutyDatePlanInfos.size(); ++index) {
            VaPlanRuleQuery ruleParam = vaPlanRuleParams.get(index);
            BillDutyDatePlanInfo billDutyDatePlanInfo = billDutyDatePlanInfos.get(index);
            BillDutyDateRuleInfo ruleInfo = new BillDutyDateRuleInfo(billDutyDatePlanInfo.getAttFileBoId(), billDutyDatePlanInfo.getQueryDate(), billDutyDatePlanInfo.getPlanDy(), ruleParam.getVaTypeId());
            ruleInfo.setBillDy(ruleParam.getBillDy());
            ruleInfo.setEntryIndex(ruleParam.getEntryIndex().intValue());
            ruleInfo.setEntryKey(ruleParam.getEntryKey());
            result.add(ruleInfo);
        }
        return result;
    }

    private List<VaPlanRuleResp> setResultToRequestParams(List<BillDutyDatePlanInfo> billDutyDatePlanInfos, List<BillDutyDateRuleInfo> billDutyDateRuleInfos, List<VaPlanRuleQuery> vaPlanRuleParams) {
        ArrayList<VaPlanRuleResp> respList = new ArrayList<VaPlanRuleResp>(vaPlanRuleParams.size());
        ArrayList<DynamicObject> engineQuery = new ArrayList<DynamicObject>(10);
        for (BillDutyDatePlanInfo billDutyDatePlanInfo : billDutyDatePlanInfos) {
            if (billDutyDatePlanInfo.getPlanDy() == null) continue;
            engineQuery.add(billDutyDatePlanInfo.getPlanDy());
        }
        Map planIdAndUseEngine = BillPlanService.getInstance().usePlanEngine(engineQuery);
        Object[] hisBaseSet = this.getHisDyByCal("vabasesetid", "wtp_vabaseset", billDutyDateRuleInfos);
        for (int index = 0; index < vaPlanRuleParams.size(); ++index) {
            Tuples.Tuple2 ruleRange;
            BillDutyDateRuleInfo billDutyDateRuleInfo;
            if (index >= billDutyDateRuleInfos.size() || (billDutyDateRuleInfo = billDutyDateRuleInfos.get(index)) == null) continue;
            VaPlanRuleResp vaPlanRuleResp = new VaPlanRuleResp(vaPlanRuleParams.get(index), billDutyDateRuleInfo.getPlanDy(), billDutyDateRuleInfo.getRuleDy(), billDutyDateRuleInfo.getRuleCalList());
            DynamicObject attFileVersionDy = billDutyDateRuleInfo.getAttFileVersionDy();
            DynamicObject planVersionDy = billDutyDateRuleInfo.getPlanDy();
            boolean usedEngine = false;
            if (planVersionDy != null) {
                usedEngine = (Boolean)planIdAndUseEngine.get(planVersionDy.getLong("id"));
            }
            String engineCondition = usedEngine ? "usedEngine" : "";
            DynamicObject ruleVersionDy = billDutyDateRuleInfo.getRuleDy();
            Optional sideDyOption = BillPlanService.getInstance().getSideDy(billDutyDatePlanInfos, billDutyDateRuleInfo.getAttFileBoId(), billDutyDateRuleInfo.getQueryDate());
            DynamicObject sideDy = sideDyOption.orElse(null);
            LocalDate baseDate = WTCDateUtils.toLocalDate((Date)billDutyDateRuleInfo.getQueryDate());
            Tuples.Tuple2 planRange = BillSetCommonService.getInstance().splitHisPlanRange(attFileVersionDy, sideDy, planVersionDy, baseDate);
            if (planRange != null) {
                if (planRange.item1 != null) {
                    vaPlanRuleResp.setPlanEffectStart(WTCDateUtils.toDate((LocalDate)((LocalDate)planRange.item1)));
                }
                if (planRange.item2 != null) {
                    vaPlanRuleResp.setPlanEffectEnd(WTCDateUtils.toDate((LocalDate)((LocalDate)planRange.item2)));
                }
            }
            if ((ruleRange = BillSetCommonService.getInstance().splitHisRuleRange(attFileVersionDy, sideDy, planVersionDy, engineCondition, ruleVersionDy, baseDate)) != null) {
                if (ruleRange.item1 != null) {
                    vaPlanRuleResp.setRuleEffectStart(WTCDateUtils.toDate((LocalDate)((LocalDate)ruleRange.item1)));
                }
                if (ruleRange.item2 != null) {
                    vaPlanRuleResp.setRuleEffectEnd(WTCDateUtils.toDate((LocalDate)((LocalDate)ruleRange.item2)));
                }
            }
            List ruleCalList = billDutyDateRuleInfo.getRuleCalList();
            ArrayList<VaRuleCalInfo> vaRuleCalInfos = new ArrayList<VaRuleCalInfo>(10);
            if (WTCCollections.isNotEmpty((Collection)ruleCalList)) {
                for (DynamicObject calDy : ruleCalList) {
                    VaRuleCalInfo vaRuleCalInfo = new VaRuleCalInfo();
                    DynamicObject baseSet = UnifyBillCommonHelper.getSeqHisDyByDate((Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)calDy, (String)"vabasesetid"), (Date)billDutyDateRuleInfo.getQueryDate(), (List)Lists.newArrayList((Object[])hisBaseSet));
                    vaRuleCalInfo.setRuleEntryCalDy(calDy);
                    vaRuleCalInfo.setBaseSetDy(baseSet);
                    String limitCondition = calDy.getString("limitscope");
                    BillSetSpiltRangeQuery billSetSpiltRangeQuery = new BillSetSpiltRangeQuery();
                    billSetSpiltRangeQuery.setAttFileVersionDy(attFileVersionDy);
                    billSetSpiltRangeQuery.setSideTableDy(sideDy);
                    billSetSpiltRangeQuery.setPlanVersionDy(planVersionDy);
                    billSetSpiltRangeQuery.setEngineCondition(engineCondition);
                    billSetSpiltRangeQuery.setRuleVersionDy(ruleVersionDy);
                    billSetSpiltRangeQuery.setLimitCondition(limitCondition);
                    billSetSpiltRangeQuery.setCalSetVersionDy(baseSet);
                    billSetSpiltRangeQuery.setBaseDate(baseDate);
                    Tuples.Tuple2 rangeTime = BillSetCommonService.getInstance().splitHisBaseSet(billSetSpiltRangeQuery);
                    if (rangeTime != null) {
                        if (rangeTime.item1 != null) {
                            vaRuleCalInfo.setBaseSetEffectStart(WTCDateUtils.toDate((LocalDate)((LocalDate)rangeTime.item1)));
                        }
                        if (rangeTime.item2 != null) {
                            vaRuleCalInfo.setBaseSetEffectEnd(WTCDateUtils.toDate((LocalDate)((LocalDate)rangeTime.item2)));
                        }
                    }
                    vaRuleCalInfos.add(vaRuleCalInfo);
                }
            }
            vaPlanRuleResp.setVaRuleCalInfos(vaRuleCalInfos);
            respList.add(vaPlanRuleResp);
        }
        return respList;
    }

    private DynamicObject[] getHisDyByCal(String keyInCal, String queryEntity, List<BillDutyDateRuleInfo> billDutyDateRuleInfos) {
        HashSet<Long> allBaseSet = new HashSet<Long>(16);
        Tuples.Tuple2<Date, Date> minAndMax = this.minAndMax(billDutyDateRuleInfos);
        for (BillDutyDateRuleInfo billDutyDateRuleInfo : billDutyDateRuleInfos) {
            List ruleCalList = billDutyDateRuleInfo.getRuleCalList();
            if (ruleCalList == null || ruleCalList.size() <= 0) continue;
            for (DynamicObject dynamicObject : ruleCalList) {
                Object obj = dynamicObject.get(keyInCal);
                if (obj == null) continue;
                allBaseSet.add(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dynamicObject, (String)keyInCal));
            }
        }
        return UnifyBillCommonHelper.getAllSeqHisDys((String)queryEntity, (Date)((Date)minAndMax.item1), (Date)((Date)minAndMax.item2), allBaseSet);
    }

    private Tuples.Tuple2<Date, Date> minAndMax(List<BillDutyDateRuleInfo> billDutyDateRuleInfos) {
        Date min = WTCDateUtils.getDayStart((Date)WTCDateUtils.getMaxEndDate());
        Date max = WTCDateUtils.getDayStart((Date)WTCDateUtils.getMinEndDate());
        for (BillDutyDateRuleInfo ruleInfo : billDutyDateRuleInfos) {
            Date queryDate = ruleInfo.getQueryDate();
            if (queryDate == null) continue;
            if (queryDate.before(min)) {
                min = queryDate;
            }
            if (!queryDate.after(max)) continue;
            max = queryDate;
        }
        return new Tuples.Tuple2((Object)min, (Object)max);
    }
}

