/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.business.wf;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.WTCCollections;

public class LeaveAuditConditionPlugin
implements IWorkflowPlugin {
    private static final Log LOG = LogFactory.getLog(LeaveAuditConditionPlugin.class);
    private static final String SQL = "select sum(t.fvatimeday) as day from t_wtabm_vaapply t2 left join t_wtabm_vaapplyentry t on t2.fid = t.fid where t2.fattfileid = ? and t2.fbillstatus = 'C'  and t.fstartdate >= ? and t.fenddate >= ? and t.fvacationtypeid = ?";

    public boolean hasTrueCondition(AgentExecution execution) {
        try {
            return this.hasTrueConditionInner(execution);
        }
        catch (Exception e) {
            LOG.warn("\u4f11\u5047\u5de5\u4f5c\u6d41\u89c4\u5219\u63d2\u4ef6\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    private boolean hasTrueConditionInner(AgentExecution execution) {
        DynamicObject billObj = this.getBillById(execution);
        if (billObj == null) {
            return false;
        }
        DynamicObjectCollection billEntries = billObj.getDynamicObjectCollection("entryentity");
        long billTypeId = this.getBillTypeId(execution);
        BigDecimal applyCnt = this.getApplyCnt(execution);
        if (billTypeId == 0L || WTCCollections.isEmpty((Collection)billEntries) || applyCnt.compareTo(BigDecimal.ZERO) <= 0) {
            return false;
        }
        HashMap<Date, BigDecimal> year2ApplyDateMap = new HashMap<Date, BigDecimal>(2);
        for (DynamicObject billEntry : billEntries) {
            long billEntryTypeId;
            DynamicObject billEntryTypeObj = billEntry.getDynamicObject("entryvacationtype");
            if (billEntryTypeObj == null || (billEntryTypeId = ((Long)billEntryTypeObj.getPkValue()).longValue()) != billTypeId) continue;
            Date startDate = billEntry.getDate("entrystartdate");
            Date firstDateOfYear = LeaveAuditConditionPlugin.getBeginDayOfYear(startDate);
            BigDecimal entryvatimeday = billEntry.getBigDecimal("entryvatimeday");
            year2ApplyDateMap.compute(firstDateOfYear, (key, value) -> value == null ? entryvatimeday : value.add(entryvatimeday));
        }
        if (year2ApplyDateMap.isEmpty()) {
            return false;
        }
        long attfileBoid = billObj.getLong("attfile.id");
        for (Map.Entry entry : year2ApplyDateMap.entrySet()) {
            BigDecimal appliedDate = this.summaryAppliedDateInOneYear((Date)entry.getKey(), attfileBoid, billTypeId);
            if (((BigDecimal)entry.getValue()).add(appliedDate).compareTo(applyCnt) <= 0) continue;
            return true;
        }
        return false;
    }

    private long getBillTypeId(AgentExecution execution) {
        String billTypeNumber;
        Map currentWFPluginParams = execution.getCurrentWFPluginParams();
        long billTypeId = 1427604815994683392L;
        if (currentWFPluginParams != null && !LeaveAuditConditionPlugin.isEmpty(billTypeNumber = Objects.toString(currentWFPluginParams.get("billType"), ""))) {
            billTypeId = this.getBillTypeIdByNumber(billTypeNumber);
        }
        return billTypeId;
    }

    private BigDecimal getApplyCnt(AgentExecution execution) {
        String applyCntStr;
        Map currentWFPluginParams = execution.getCurrentWFPluginParams();
        BigDecimal applyCnt = BigDecimal.valueOf(5L);
        if (currentWFPluginParams != null && !LeaveAuditConditionPlugin.isEmpty(applyCntStr = Objects.toString(currentWFPluginParams.get("applyCnt"), ""))) {
            try {
                applyCnt = new BigDecimal(applyCntStr);
            }
            catch (Exception e) {
                LOG.warn("\u4f11\u5047\u5de5\u4f5c\u6d41\u89c4\u5219\u63d2\u4ef6\u5f02\u5e38\uff0c\u53c2\u6570\u503c\u3010\u4f11\u5047\u6b21\u6570applyCnt\u3011\u914d\u7f6e\u4e0d\u5408\u6cd5\uff0capplyCnt={}", (Object)applyCnt);
            }
        }
        return applyCnt;
    }

    private DynamicObject getBillById(AgentExecution execution) {
        String entityNumber = execution.getEntityNumber();
        HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)entityNumber);
        String billIdStr = execution.getBusinessKey();
        long billId = Long.parseLong(billIdStr);
        return serviceHelper.queryOne("attfile.id,entryentity.entryvacationtype,entryentity.entrystartdate,entryentity.entryenddate,entryentity.entryvatimeday", (Object)billId);
    }

    private long getBillTypeIdByNumber(String billTypeNumber) {
        QFilter filter = new QFilter("number", "=", (Object)billTypeNumber);
        DynamicObject obj = HRBaseServiceHelper.create((String)"wtbd_vacationtype").queryOne("id", filter);
        if (obj != null) {
            return (Long)obj.getPkValue();
        }
        return 0L;
    }

    private BigDecimal summaryAppliedDateInOneYear(Date year, long attfileBoid, long billTypeId) {
        try {
            return (BigDecimal)DB.query((DBRoute)DBRoute.of((String)"wtc"), (String)SQL, (Object[])new Object[]{attfileBoid, year, year, billTypeId}, resultSet -> {
                if (resultSet.next()) {
                    Object obj = resultSet.getObject(1);
                    if (obj != null) {
                        return new BigDecimal(obj.toString());
                    }
                    return BigDecimal.ZERO;
                }
                return BigDecimal.ZERO;
            });
        }
        catch (Exception e) {
            LOG.warn("\u4f11\u5047\u5de5\u4f5c\u6d41\u89c4\u5219\u63d2\u4ef6\u5f02\u5e38\uff0c\u7edf\u8ba1\u5df2\u4f11\u5929\u6570\u5f02\u5e38\uff0cSQL={}, params=[{},{},{}]", new Object[]{SQL, attfileBoid, year, year, billTypeId});
            return BigDecimal.ZERO;
        }
    }

    private static Date getBeginDayOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, 0);
        cal.set(5, 1);
        return LeaveAuditConditionPlugin.getDayStartTime(cal.getTime());
    }

    private static Date getDayStartTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTimeInMillis());
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }
}

