/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.formplugin.web.vaapply;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Container;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.wtc.wtabm.business.vaapply.VaApplyService;
import kd.wtc.wtabm.business.vaapply.VaApplyServiceHelper;
import kd.wtc.wtabm.business.vaapply.VaKDStringHelper;
import kd.wtc.wtabm.business.vaapply.checker.VaBillCheckService;
import kd.wtc.wtabm.business.vaapply.checker.VaEntityCheckService;
import kd.wtc.wtabm.common.entity.vaapply.VaInfoVo;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyKDStringHelper;
import kd.wtc.wtbs.business.bill.WtcTimeRangeControlService;
import kd.wtc.wtbs.common.bill.batchbill.BatchBillKDString;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.bill.BillOpenStyleEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.enums.bill.va.SpecialVaTypeEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.formplugin.web.WTCBaseBillCommon;
import kd.wtc.wtbs.wtp.enums.vaplan.BaseSetTimeBreastDayTypeEnum;
import kd.wtc.wtbs.wtp.enums.vaplan.BaseSetTimeUnitEnum;

public class VaApplyBillEdit
extends HRCoreBaseBillEdit
implements Consumer<PackageDataEvent> {
    private static final Log LOG = LogFactory.getLog(VaApplyBillEdit.class);
    private static final String BACK_ID = "back";
    protected static final String FORCE_CLOSE = "force_close";
    private static final String WTABM_FORMPLUGIN = "wtc-wtabm-formplugin";
    VaApplyService vaApplyService = (VaApplyService)WTCAppContextHelper.getBean(VaApplyService.class);
    private final Set<String> unChangeSet = Sets.newHashSet((Object[])new String[]{"datechange", "spvacationtype"});

    public void preOpenForm(PreOpenFormEventArgs ee) {
        Object pkId;
        super.preOpenForm(ee);
        FormShowParameter formShowParameter = ee.getFormShowParameter();
        if (formShowParameter instanceof BillShowParameter && (pkId = ((BillShowParameter)formShowParameter).getPkId()) != null) {
            String caption;
            String formId = formShowParameter.getFormId();
            HRBaseServiceHelper helper = new HRBaseServiceHelper("wtabm_vaapply");
            DynamicObject dy = helper.queryOne(pkId);
            if (dy == null) {
                return;
            }
            String applyType = dy.getString("applytyperadio");
            if ("2".equals(applyType)) {
                boolean isChange = dy.getBoolean("ischange");
                caption = isChange ? BatchBillKDString.batchVaChange() : BatchBillKDString.batchVa();
            } else if (HRStringUtils.equals((String)"wtabm_vaapply", (String)formId)) {
                caption = ResManager.loadKDString((String)"\u4e3a\u4ed6\u4eba\u7533\u8bf7\u4f11\u5047", (String)"VaApplyBillEdit_09", (String)WTABM_FORMPLUGIN, (Object[])new Object[0]);
            } else if (HRStringUtils.equals((String)"wtabm_vaupdate", (String)formId)) {
                caption = ResManager.loadKDString((String)"\u4e3a\u4ed6\u4eba\u7533\u8bf7\u4f11\u5047\u53d8\u66f4", (String)"VaApplyBillEdit_10", (String)WTABM_FORMPLUGIN, (Object[])new Object[0]);
            } else if (HRStringUtils.equals((String)"wtabm_vaapplyself", (String)formId)) {
                caption = ResManager.loadKDString((String)"\u4f11\u5047\u7533\u8bf7", (String)"VaApplyBillEdit_11", (String)WTABM_FORMPLUGIN, (Object[])new Object[0]);
            } else if (HRStringUtils.equals((String)"wtabm_vaupdateself", (String)formId)) {
                caption = ResManager.loadKDString((String)"\u4f11\u5047\u7533\u8bf7\u53d8\u66f4", (String)"VaApplyBillEdit_12", (String)WTABM_FORMPLUGIN, (Object[])new Object[0]);
            } else {
                return;
            }
            DynamicObject attFile = dy.getDynamicObject("attfile");
            if (attFile != null) {
                caption = caption + "-" + attFile.getLocaleString("name");
            }
            formShowParameter.setCaption(caption);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        long beginTime = System.currentTimeMillis();
        LOG.info("vaapply beforeDoOperation begin, opkey:{}, time:{}", (Object)operateKey, (Object)beginTime);
        if (!WTCBaseBillCommon.verifyAttFileExist((BeforeDoOperationEventArgs)args, (IFormView)this.getView())) {
            return;
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"opaddnewpage")) {
            long attfileBo = this.getView().getModel().getDataEntity().getLong("attfile.id");
            if (attfileBo != 0L) {
                VaApplyService.showAddNewPage((IFormView)this.getView(), (IFormPlugin)this);
            }
            args.setCancel(true);
        } else if (HRStringUtils.equals((String)"editrow", (String)operateKey)) {
            VaApplyService.showEditPage((IFormView)this.getView(), (IFormPlugin)this);
            args.setCancel(true);
        } else if (HRStringUtils.equals((String)"deleteentry", (String)operateKey)) {
            int[] selectRows = ((EntryGrid)this.getControl("entryentity")).getSelectRows();
            int entrySize = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").size();
            if (entrySize < 2 || entrySize - selectRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u5c11\u9700\u8981\u4fdd\u75591\u6761\u4f11\u5047\u4fe1\u606f\u3002", (String)"VaApplyBillEdit_05", (String)WTABM_FORMPLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (HRStringUtils.equals((String)"save", (String)operateKey) || HRStringUtils.equals((String)"submit", (String)operateKey) || HRStringUtils.equals((String)"submit-audit", (String)operateKey) || HRStringUtils.equals((String)"submiteffect", (String)operateKey)) {
            this.saveOrSubmit(args);
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"vadetail")) {
            VaApplyService.showVaDetailPage((IFormView)this.getView());
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"update")) {
            DynamicObject dynamicObject = this.getModel().getDataEntity(true);
            Object pkValue = dynamicObject.getPkValue();
            BillResponse billResponse = VaApplyService.couldChange((DynamicObject)dynamicObject, (String)op.getEntityId(), (String)BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView()));
            if (!billResponse.isSuccess()) {
                this.getView().showTipNotification((String)billResponse.getMessage().get(0));
                args.setCancel(true);
                return;
            }
            VaApplyServiceHelper vaApplyServiceHelper = (VaApplyServiceHelper)WTCAppContextHelper.getBean(VaApplyServiceHelper.class);
            DynamicObject billDyn = vaApplyServiceHelper.loadSingle(pkValue);
            boolean isHaveChange = billDyn.getBoolean("ishavechange");
            if (isHaveChange) {
                this.getView().showTipNotification(BillUnifyKDStringHelper.changeRepeat((String)BillTypeEnum.VACATIONBILL.getBillName()));
                return;
            }
            String billStatus = billDyn.getString("billstatus");
            if (!"C".equals(billStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u53d8\u66f4\u5ba1\u6838\u901a\u8fc7\u7684\u6570\u636e\u3002", (String)"VaApplyBillEdit_13", (String)WTABM_FORMPLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            VaApplyService.showUpdateForm((Long)((Long)pkValue), (IFormView)this.getView());
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"quotainfodetail")) {
            LOG.info("\u8df3\u8f6c\u989d\u5ea6\u8be6\u60c5\u5f00\u59cb");
            VaApplyService service = new VaApplyService();
            service.openQuotaInfoDetailForBillView(this.getView());
        }
        LOG.info("vaapply beforeDoOperation end, opkey:{}, time:{}, usingTime:{}", new Object[]{operateKey, System.currentTimeMillis(), System.currentTimeMillis() - beginTime});
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        AbstractOperate op = (AbstractOperate)afterDoOperationEventArgs.getSource();
        String operateKey = op.getOperateKey();
        if (StringUtils.equalsAny((CharSequence)operateKey, (CharSequence[])new CharSequence[]{"save", "submit", "unsubmit", "submit-audit", "submiteffect", "discard"}) && afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.refreshEntryEntity();
            this.vaApplyService.handleVisForQuota(this.getView());
        }
    }

    private void saveOrSubmit(BeforeDoOperationEventArgs args) {
        boolean isNotLeave = (Boolean)this.getModel().getValue("isnotleave");
        boolean singleOpSuccess = this.dealSingle();
        if (!singleOpSuccess) {
            args.setCancel(true);
            return;
        }
        this.validateAttachment(args);
        if (isNotLeave) {
            return;
        }
        DynamicObjectCollection collection = this.getView().getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)collection)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u5c11\u9700\u8981\u4fdd\u75591\u6761\u4f11\u5047\u4fe1\u606f\u3002", (String)"VaApplyBillEdit_05", (String)WTABM_FORMPLUGIN, (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObject object = this.getView().getModel().getDataEntity();
        if (object.getBoolean("isneedhand")) {
            if (StringUtils.isBlank((CharSequence)object.getString("handperson"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u4ea4\u63a5\u4eba\u201d\u3002", (String)"VaApplyBillEdit_07", (String)WTABM_FORMPLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (StringUtils.isBlank((CharSequence)object.getString("handreason"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5de5\u4f5c\u4ea4\u63a5\u8bf4\u660e\u201d\u3002", (String)"VaApplyBillEdit_08", (String)WTABM_FORMPLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        this.billStatusCheckForDetail(operateKey, object, args, this.getView());
    }

    private boolean dealSingle() {
        String singlePageId;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String billStyle = dataEntity.getString("billstyle");
        if (StringUtils.equals((CharSequence)billStyle, (CharSequence)BillOpenStyleEnum.SINGLE.getCode()) && StringUtils.isNotEmpty((CharSequence)(singlePageId = this.getPageCache().get("singlePageId")))) {
            OperationResult operationResult;
            IFormView childPageView = this.getView().getView(singlePageId);
            if (childPageView == null) {
                throw new KDBizException(VaKDStringHelper.singlePageClosedErr());
            }
            Tuples.Tuple2 passTimeCheck = WtcTimeRangeControlService.getInstance().passCheckTime(childPageView.getModel().getDataEntity(true), ApplyBillCheckEnum.VACATIONFORM, BillTypeEnum.VACATIONBILL.getBillName());
            if (!((Boolean)passTimeCheck.item1).booleanValue()) {
                this.getView().showTipNotification((String)passTimeCheck.item2);
                return false;
            }
            try {
                operationResult = childPageView.invokeOperation("ensure");
            }
            catch (Exception e) {
                LOG.warn("invokeSinglePageOperation.fail,error:{}", (Object)e.getMessage());
                throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"VaApplyBillEdit_14", (String)WTABM_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (!operationResult.isSuccess()) {
                if (WTCCollections.isNotEmpty((Collection)operationResult.getAllErrorOrValidateInfo())) {
                    this.getView().showTipNotification(((IOperateInfo)operationResult.getAllErrorOrValidateInfo().get(0)).getMessage());
                }
                return false;
            }
            String returnData = childPageView.getPageCache().get("VA_INFO_VO");
            if (StringUtils.isNotEmpty((CharSequence)returnData)) {
                VaInfoVo vaInfoVo = (VaInfoVo)SerializationUtils.deSerializeFromBase64((String)returnData);
                VaApplyService.addOrModifySingleEntryRow((IFormView)this.getView(), (VaInfoVo)vaInfoVo);
            }
            this.getView().getPageCache().put(FORCE_CLOSE, "1");
        }
        return true;
    }

    private void billStatusCheckForDetail(String operateKey, DynamicObject curBillDyn, BeforeDoOperationEventArgs evt, IFormView iFormView) {
        BillOperationStatus billPageStatus = ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus();
        if (billPageStatus == BillOperationStatus.ADDNEW) {
            return;
        }
        long billId = curBillDyn.getLong("id");
        DynamicObject dynamicObject = VaApplyServiceHelper.INSTANCE.queryOriginalOne("billstatus", new QFilter("id", "=", (Object)billId));
        if (dynamicObject == null) {
            LOG.info("\u6570\u636e\u5e93\u4e2d\u5355\u636e\u5df2\u4e0d\u5b58\u5728\uff0c billId:{}", (Object)billId);
            iFormView.showErrorNotification(VaKDStringHelper.dataNotExistFail());
            evt.setCancel(true);
            return;
        }
        String billStatus = dynamicObject.getString("billstatus");
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit") && !StringUtils.equalsAny((CharSequence)billStatus, (CharSequence[])new CharSequence[]{"A", "G"})) {
            iFormView.showTipNotification(VaKDStringHelper.statusCheckForSubmit());
            evt.setCancel(true);
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"save") && !StringUtils.equalsAny((CharSequence)billStatus, (CharSequence[])new CharSequence[]{"A", "G"})) {
            iFormView.showTipNotification(VaKDStringHelper.statusCheckForModify());
            evt.setCancel(true);
        }
    }

    private void validateAttachment(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        AttachmentPanel attachmentpanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        int attachmentCount = CollectionUtils.isEmpty((Collection)attachmentpanel.getAttachmentData()) ? 0 : attachmentpanel.getAttachmentData().size();
        AbstractOperate source = (AbstractOperate)args.getSource();
        LOG.info("ATTACHMENT_COUNT:{}", (Object)attachmentCount);
        source.getOption().setVariableValue("ATTACHMENT_COUNT", String.valueOf(attachmentCount));
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if (StringUtils.equalsAny((CharSequence)actionId, (CharSequence[])new CharSequence[]{"newentry", "editrow"})) {
            String returnData = (String)evt.getReturnData();
            if (StringUtils.isNotEmpty((CharSequence)returnData)) {
                VaInfoVo vaInfoVo = (VaInfoVo)SerializationUtils.deSerializeFromBase64((String)returnData);
                this.getView().getModel().beginInit();
                if (HRStringUtils.equals((String)actionId, (String)"newentry")) {
                    VaApplyService.addEntryRow((IFormView)this.getView(), (VaInfoVo)vaInfoVo);
                    VaApplyService.summaryVaTypeTime((IFormView)this.getView());
                    VaApplyService.loadAttPolicy((IFormView)this.getView());
                } else if (HRStringUtils.equals((String)actionId, (String)"editrow")) {
                    VaApplyService.modifyEntryRow((IFormView)this.getView(), (VaInfoVo)vaInfoVo);
                    VaApplyService.summaryVaTypeTime((IFormView)this.getView());
                    VaApplyService.loadAttPolicy((IFormView)this.getView());
                }
                this.vaApplyService.dealBreastfeedingLeave(this.getView());
                this.getView().getModel().endInit();
                if (vaInfoVo != null) {
                    DynamicObject childPageDynamicObj;
                    this.getView().getModel().setValue("entryapplytime", (Object)0, vaInfoVo.getRowIndex());
                    if (HRStringUtils.equals((String)vaInfoVo.getUnit(), (String)BaseSetTimeUnitEnum.DATE.code)) {
                        this.getView().getModel().setValue("entryapplytime", (Object)vaInfoVo.getEntryVaTimeDay(), vaInfoVo.getRowIndex());
                    } else {
                        this.getModel().setValue("entryapplytime", (Object)vaInfoVo.getEntryVaTimeHour(), vaInfoVo.getRowIndex());
                    }
                    if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{vaInfoVo.getDynamicObjectBase64()}) && (childPageDynamicObj = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)vaInfoVo.getDynamicObjectBase64())) != null) {
                        BillCommonService.writeInfo2Model((DynamicObject)childPageDynamicObj, (DynamicObject)this.getModel().getEntryRowEntity("entryentity", vaInfoVo.getRowIndex()));
                    }
                }
            }
            this.getView().updateView("entryentity");
            this.vaApplyService.handleVisForQuota(this.getView());
        }
    }

    public void initialize() {
        super.initialize();
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addPackageDataListener((Consumer)this);
    }

    private static boolean canEdit(String billStatus) {
        return StringUtils.equalsAny((CharSequence)billStatus, (CharSequence[])new CharSequence[]{"A", "G"});
    }

    private static boolean canEdit(String billStatus, OperationStatus operationStatus) {
        boolean canEdit = VaApplyBillEdit.canEdit(billStatus);
        if (canEdit) {
            canEdit = !OperationStatus.VIEW.equals((Object)operationStatus);
        }
        return canEdit;
    }

    public void beforeBindData(EventObject object) {
        super.beforeBindData(object);
        IDataEntityProperty hasVaPlanProp = (IDataEntityProperty)EntityMetadataCache.getDataEntityType((String)this.getView().getFormShowParameter().getFormId()).getFields().get("hasvaplan");
        if (hasVaPlanProp != null) {
            BillOperationStatus billStatus = ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus();
            this.getModel().setValue("hasvaplan", (Object)(BillOperationStatus.ADDNEW != billStatus ? 1 : 0));
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        BillShowParameter formShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        String entityId = this.getView().getEntityId();
        BillOperationStatus billStatus = formShowParameter.getBillStatus();
        boolean isChange = this.getModel().getDataEntity().getBoolean("ischange");
        if (BillOperationStatus.ADDNEW.equals((Object)billStatus) && !isChange) {
            this.voidData();
        }
        DynamicObjectCollection entryCollection = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        if (VaApplyBillEdit.canEdit(this.getModel().getDataEntity().getString("billstatus")) && CollectionUtils.isNotEmpty((Collection)entryCollection)) {
            this.refreshApplyTimes();
        }
        this.vaApplyService.setEntryEntity(this.getView());
        VaApplyService.summaryVaTypeTime((IFormView)this.getView());
        VaApplyService.loadAttPolicy((IFormView)this.getView());
        long attfileBo = this.getView().getModel().getDataEntity().getLong("attfile.id");
        if (attfileBo != 0L) {
            UnifyBillApplyAttr applyAttr;
            boolean needCheckAttFileAuth = "1".equals(this.getModel().getDataEntity(true).getString("applytyperadio"));
            VaEntityCheckService billEntityCheckService = VaEntityCheckService.createService((long)attfileBo, (ApplyBillCheckEnum)ApplyBillCheckEnum.VACATION, null, (boolean)needCheckAttFileAuth, (UnifyBillApplyAttr)(applyAttr = new UnifyBillApplyAttr(BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView()), entityId)));
            BillResponse billResponse = billEntityCheckService.checkAttfile();
            if (!billResponse.isSuccess()) {
                this.getView().showTipNotification((String)billResponse.getMessage().get(0));
            } else {
                IDataEntityProperty hasVaPlanProp = (IDataEntityProperty)EntityMetadataCache.getDataEntityType((String)this.getView().getFormShowParameter().getFormId()).getFields().get("hasvaplan");
                if (hasVaPlanProp != null) {
                    this.getModel().setValue("hasvaplan", (Object)true);
                }
            }
            boolean isSingle = WTCStringUtils.equals((String)this.getModel().getDataEntity().getString("billstyle"), (String)BillOpenStyleEnum.SINGLE.getCode());
            if (isSingle) {
                VaApplyService.showSinglePageInContainer((IFormView)this.getView());
            }
        }
        this.vaApplyService.dealBreastfeedingLeave(this.getView());
        boolean isNeedHand = this.getModel().getDataEntity().getBoolean("isneedhand");
        FieldEdit handPerson = (FieldEdit)this.getView().getControl("handperson");
        FieldEdit handReason = (FieldEdit)this.getView().getControl("handreason");
        handPerson.setMustInput(isNeedHand);
        handReason.setMustInput(isNeedHand);
        this.getView().setVisible(Boolean.valueOf(isNeedHand), new String[]{"handperson", "handreason"});
        this.getView().updateView("entryentity");
        this.getModel().setDataChanged(false);
        this.vaApplyService.handleVisForQuota(this.getView());
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"entryapplytime")) {
            LOG.info("Changed Property:{}", (Object)name);
            return;
        }
        if (StringUtils.equals((CharSequence)name, (CharSequence)"attfile")) {
            this.voidData();
            long attfileBo = this.getView().getModel().getDataEntity().getLong("attfile.id");
            boolean needCheckAttFileAuth = "1".equals(this.getModel().getDataEntity(true).getString("applytyperadio"));
            if (attfileBo != 0L) {
                List message;
                UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView()), this.getView().getEntityId());
                VaEntityCheckService billCommonCheckHelper = VaEntityCheckService.createService((long)attfileBo, (ApplyBillCheckEnum)ApplyBillCheckEnum.VACATION, null, (boolean)needCheckAttFileAuth, (UnifyBillApplyAttr)applyAttr);
                BillResponse billResponse = billCommonCheckHelper.checkAttfile();
                IDataEntityProperty hasVaPlanProp = (IDataEntityProperty)EntityMetadataCache.getDataEntityType((String)this.getView().getFormShowParameter().getFormId()).getFields().get("hasvaplan");
                if (hasVaPlanProp != null) {
                    this.getModel().setValue("hasvaplan", (Object)billResponse.isSuccess());
                }
                if (!billResponse.isSuccess() && !CollectionUtils.isEmpty((Collection)(message = billResponse.getMessage()))) {
                    this.getView().showTipNotification((String)message.get(0));
                    return;
                }
                Container attachFlex = (Container)this.getView().getControl("attachflex");
                attachFlex.setCollapse(true);
                this.getView().setVisible(Boolean.TRUE, new String[]{"attachmentpanel"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"attlackflex"});
                Container attPolicyFlex = (Container)this.getView().getControl("attpolicyflex");
                attPolicyFlex.setCollapse(true);
            }
        }
        if (HRStringUtils.equals((String)name, (String)"isneedhand")) {
            this.setHandleMustInput(this.getView());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes.equals((Object)result) && BACK_ID.equals(messageBoxClosedEvent.getCallBackId())) {
            this.getView().getPageCache().put(FORCE_CLOSE, "1");
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        ArrayList prop = Lists.newArrayList((Object[])new String[]{"personid", "attfile", "vacationtypelist", "hasvaplan"});
        VaApplyBillEdit.setDataChangedFalse(this.getModel().getDataEntity(), prop);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String billStyle = dataEntity.getString("billstyle");
        String forceClose = this.getPageCache().get(FORCE_CLOSE);
        if (StringUtils.equals((CharSequence)billStyle, (CharSequence)BillOpenStyleEnum.SINGLE.getCode()) && !StringUtils.equals((CharSequence)forceClose, (CharSequence)"1")) {
            this.dealSingleClosed(event);
        }
    }

    private void dealSingleClosed(BeforeClosedEvent evt) {
        String singlePageId = this.getPageCache().get("singlePageId");
        if (StringUtils.isNotEmpty((CharSequence)singlePageId)) {
            DynamicObject childDataEntity;
            IFormView childPageView = this.getView().getView(singlePageId);
            if (childPageView == null) {
                throw new KDBizException(VaKDStringHelper.singlePageClosedErr());
            }
            Iterable bizChangedProperties = this.getView().getModel().getDataEntity().getDataEntityState().getBizChangedProperties();
            String split = VaKDStringHelper.split();
            String changeHeadDesc = VaKDStringHelper.changeSetDesc();
            int maxChangeSet = 4;
            ArrayList localValues = Lists.newArrayListWithCapacity((int)10);
            for (IDataEntityProperty bizChangedProperty : bizChangedProperties) {
                LocaleString displayName = bizChangedProperty.getDisplayName();
                if (displayName == null) continue;
                String localeValue = displayName.getLocaleValue();
                if (localValues.size() >= maxChangeSet) continue;
                localValues.add(localeValue);
            }
            IDataModel childModel = childPageView.getModel();
            try {
                childDataEntity = childModel.getDataEntity();
            }
            catch (KDException ex) {
                LOG.info("\u5b50\u9875\u9762\u5f02\u5e38\u5173\u95ed\u6216\u8005\u8fd8\u672a\u52a0\u8f7d\u6210\u529f\u3002", (Object)ex);
                return;
            }
            boolean childDataChanged = childModel.getDataChanged();
            if (childDataChanged) {
                Iterable childChangedProperties = childDataEntity.getDataEntityState().getBizChangedProperties();
                for (IDataEntityProperty bizChangedProperty : childChangedProperties) {
                    LocaleString displayName = bizChangedProperty.getDisplayName();
                    if (displayName == null || this.unChangeSet.contains(bizChangedProperty.getName())) continue;
                    String localeValue = displayName.getLocaleValue();
                    if (localValues.size() >= maxChangeSet) continue;
                    localValues.add(localeValue);
                }
            }
            if (WTCCollections.isNotEmpty((Collection)localValues)) {
                String join = String.join((CharSequence)split, localValues);
                String changeDescResult = changeHeadDesc.concat(join);
                if (localValues.size() >= maxChangeSet) {
                    changeDescResult = changeDescResult.concat(VaKDStringHelper.omit());
                }
                if (WTCStringUtils.isNotEmpty((String)changeDescResult)) {
                    this.showDateChangeNotifyAndCancelClose(evt, changeDescResult);
                }
            }
        }
    }

    private void showDateChangeNotifyAndCancelClose(BeforeClosedEvent evt, String changeDesc) {
        HashMap btnNameMaps = Maps.newHashMapWithExpectedSize((int)2);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"VaApplyBillEdit_15", (String)WTABM_FORMPLUGIN, (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"VaApplyBillEdit_16", (String)WTABM_FORMPLUGIN, (Object[])new Object[0]));
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(BACK_ID, (IFormPlugin)this);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String changeMsg = VaKDStringHelper.checkedChange();
        changeMsg = changeMsg + "\r\n";
        changeMsg = changeMsg + VaKDStringHelper.lostChange();
        this.getView().showConfirm(changeMsg, changeDesc, options, ConfirmTypes.Save, confirmCallBackListener, (Map)btnNameMaps);
        evt.setCancel(true);
    }

    private static void setDataChangedFalse(DynamicObject dataEntity, List<String> propList) {
        IDataEntityType dataEntityType = dataEntity.getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        String _id = "_id";
        for (String prop : propList) {
            IDataEntityProperty iDataEntityProperty_id;
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)prop);
            if (iDataEntityProperty == null) continue;
            if (iDataEntityProperty instanceof DynamicComplexProperty && (iDataEntityProperty_id = (IDataEntityProperty)properties.get((Object)(prop + _id))) != null) {
                dataEntityState.setBizChanged(iDataEntityProperty_id.getOrdinal(), false);
            }
            dataEntityState.setBizChanged(iDataEntityProperty.getOrdinal(), false);
        }
    }

    private void setHandleMustInput(IFormView view) {
        boolean isNeedHand = (Boolean)view.getModel().getValue("isneedhand");
        ((TextEdit)view.getControl("handperson")).setMustInput(isNeedHand);
        ((TextEdit)view.getControl("handreason")).setMustInput(isNeedHand);
        if (!isNeedHand) {
            view.getModel().setValue("handperson", null);
            view.getModel().setValue("handreason", null);
        }
        view.setVisible(Boolean.valueOf(isNeedHand), new String[]{"handperson", "handreason"});
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs args) {
        VaApplyService.loadAttPolicy((IFormView)this.getView());
        VaApplyService.summaryVaTypeTime((IFormView)this.getView());
    }

    private void voidData() {
        this.getModel().deleteEntryData("entryentity");
        this.getModel().setValue("isneedhand", null);
        this.getModel().setValue("handreason", null);
        this.getModel().setValue("handperson", null);
        this.getView().setVisible(Boolean.FALSE, new String[]{"richtexteditorap"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"lackpageflex"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        List attachmentDataList = attachmentPanel.getAttachmentData();
        attachmentDataList.clear();
        this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentpanel"});
        Label label = (Label)this.getView().getControl("sumstr");
        label.setText(null);
        String entityName = this.getModel().getDataEntity().getDynamicObjectType().getName();
        if (StringUtils.equalsAny((CharSequence)entityName, (CharSequence[])new CharSequence[]{"wtabm_vaapplyself", "wtabm_vaupdateself"})) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"attachmentpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"attlackflex"});
        }
    }

    private void refreshApplyTimes() {
        DynamicObject billDyn = this.getModel().getDataEntity();
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView()), this.getView().getEntityId());
        VaBillCheckService vaBillCheckService = new VaBillCheckService(ApplyBillCheckEnum.VACATION, UnifyBillEnum.VA, Collections.singletonList(billDyn), applyAttr);
        BillResponse billResponse = vaBillCheckService.refresh();
        LOG.info("\u91cd\u65b0\u6821\u9a8c\u6240\u6709\u6821\u9a8c\u9879\u5e76\u751f\u6210\u4f11\u5047\u4fe1\u606f\u7ed3\u679c\uff1a{}\uff0c\u63d0\u793a\u4fe1\u606f\uff1a{}", (Object)billResponse.isSuccess(), (Object)billResponse.getMessage());
    }

    private void refreshEntryEntity() {
        this.getView().updateView("entryentity");
        DynamicObjectCollection entries = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        for (int rowIndex = 0; rowIndex < entries.size(); ++rowIndex) {
            DynamicObject entry = (DynamicObject)entries.get(rowIndex);
            if (HRStringUtils.equals((String)entry.getString("entryunit"), (String)BaseSetTimeUnitEnum.DATE.code)) {
                this.getView().getModel().setValue("entryapplytime", (Object)entry.getBigDecimal("entryvatimeday"), rowIndex);
            } else {
                this.getView().getModel().setValue("entryapplytime", (Object)entry.getBigDecimal("entryvatimehour"), rowIndex);
            }
            ArrayList prop = Lists.newArrayList((Object[])new String[]{"entryapplytime"});
            VaApplyBillEdit.setDataChangedFalse(entry, prop);
        }
        VaApplyService.summaryVaTypeTime((IFormView)this.getView());
    }

    @Override
    public void accept(PackageDataEvent pkEvent) {
        String spVaType = pkEvent.getRowData().getString("specialvatype");
        long specialVaMethodId = pkEvent.getRowData().getLong("specialvamethod.id");
        DynamicObject bill = (DynamicObject)pkEvent.getRowData().getParent();
        if (pkEvent.getSource() instanceof OperationColumn) {
            List operationColItems = (List)pkEvent.getFormatValue();
            for (OperationColItem operationColItem : operationColItems) {
                if ("vadetail".equalsIgnoreCase(operationColItem.getOperationKey())) {
                    if (!StringUtils.equals((CharSequence)spVaType, (CharSequence)SpecialVaTypeEnum.LACTATION_TYPE.vaType) || BaseSetTimeBreastDayTypeEnum.COME_LATE.id == specialVaMethodId || BaseSetTimeBreastDayTypeEnum.GO_EARLY.id == specialVaMethodId) {
                        operationColItem.setVisible(false);
                        operationColItem.setLocked(true);
                        continue;
                    }
                    operationColItem.setVisible(true);
                    operationColItem.setLocked(false);
                    continue;
                }
                if (!"editrow".equalsIgnoreCase(operationColItem.getOperationKey())) continue;
                OperationStatus status = this.getView().getFormShowParameter().getStatus();
                if (bill == null || VaApplyBillEdit.canEdit(bill.getString("billstatus"), status)) continue;
                operationColItem.setVisible(false);
                operationColItem.setLocked(true);
            }
        }
    }
}

