/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.formplugin.web.vaapply;

import com.alibaba.fastjson.JSON;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.EnableCustomSumEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.wtc.wtabm.business.vaapply.VaApplyService;
import kd.wtc.wtabm.business.vaapply.VaApplyServiceHelper;
import kd.wtc.wtabm.business.vaapply.VaKDStringHelper;
import kd.wtc.wtabm.formplugin.web.vaapply.VaApplyListProvider;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.common.bill.batchbill.BatchBillKDString;
import kd.wtc.wtbs.common.enums.ApplyBillTimeUnitEnum;
import kd.wtc.wtbs.common.enums.BillSystemParamConfigEnum;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.bill.BillSystemParamRange;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class VaApplyBillList
extends HRCoreBaseBillList {
    private static final int DETAULT_PAGESIZE = 2000;
    private static final Log LOG = LogFactory.getLog(VaApplyBillList.class);
    private final HRBaseServiceHelper vaApplyServiceHelper = (HRBaseServiceHelper)WTCAppContextHelper.getBean(VaApplyServiceHelper.class);
    private final VaApplyService vaApplyService = (VaApplyService)WTCAppContextHelper.getBean(VaApplyService.class);
    private final Set<CompareTypeEnum> compareTypeEnums = Sets.newHashSet((Object[])new CompareTypeEnum[]{CompareTypeEnum.TODAY, CompareTypeEnum.YESTERDAY, CompareTypeEnum.THISWEEK, CompareTypeEnum.LASTWEEK, CompareTypeEnum.THISMONTH, CompareTypeEnum.LASTMONTH, CompareTypeEnum.LASTONEMONTH, CompareTypeEnum.LASTTHREEMONTH, CompareTypeEnum.THISQUARTER, CompareTypeEnum.LASTQUARTER, CompareTypeEnum.THISYEAR, CompareTypeEnum.LASTYEAR, CompareTypeEnum.TOMORROW, CompareTypeEnum.NEXTWEEK, CompareTypeEnum.NEXTMONTH, CompareTypeEnum.FUTUREONEMONTH, CompareTypeEnum.FUTURETHREEMONTH, CompareTypeEnum.NEXTYEAR, CompareTypeEnum.NEXTQUARTER, CompareTypeEnum.BETWEEN});
    private QFilter dateFilter = null;
    private boolean isFieldsControlList = false;
    private String selectFields = "";

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        QFilter statusEqual = new QFilter("ishavechange", "=", (Object)Boolean.FALSE);
        event.addCustomQFilter(statusEqual);
        event.setOrderBy("id desc");
        List qFilters = event.getQFilters();
        LOG.info("VaApplyBillList.setFilter,qFilters:{}", (Object)qFilters);
        Date startDate = null;
        Date endDate = null;
        Set filters = event.getQFilters().stream().map(filter -> filter.getNests(true).stream().map(QFilter.QFilterNest::getFilter).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet());
        filters.addAll(qFilters);
        for (QFilter filter2 : filters) {
            if (!StringUtils.equals((CharSequence)"vadate", (CharSequence)filter2.getProperty())) continue;
            if (StringUtils.equalsAny((CharSequence)filter2.getCP(), (CharSequence[])new CharSequence[]{">=", ">"})) {
                startDate = (Date)filter2.getValue();
            } else if (filter2.getValue() != null && filter2.getValue() instanceof Date) {
                endDate = (Date)filter2.getValue();
            } else {
                LOG.warn("filter\u7c7b\u578b\u4e0d\u662f\u65e5\u671f\u7c7b\u578b\uff0c\uff1afilter.getValue\uff1a{}", filter2.getValue());
            }
            filter2.__setProperty("1");
            filter2.__setCP("=");
            filter2.__setValue((Object)1);
        }
        if (startDate != null && endDate != null) {
            this.dateFilter = new QFilter("startdate", "<", endDate).and(new QFilter("enddate", ">=", startDate));
            this.dateFilter = this.dateFilter.and(new QFilter("entryentity.entrystartdate", "<", endDate).and(new QFilter("entryentity.entryenddate", ">=", (Object)startDate)));
        }
        if (this.dateFilter != null) {
            if (event.getCustomQFilters() == null) {
                event.setCustomQFilters(new ArrayList(1));
            }
            event.getCustomQFilters().add(this.dateFilter);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new VaApplyListProvider());
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        this.createListColumn(args);
    }

    public void setEnableCustomSum(EnableCustomSumEvent args) {
        super.setEnableCustomSum(args);
        args.setEnableCustomSum(false);
    }

    private void createListColumn(BeforeCreateListColumnsArgs args) {
        List listColumns = args.getListColumns();
        for (int index = 0; index < listColumns.size(); ++index) {
            IListColumn listColumn = (IListColumn)listColumns.get(index);
            if (!"edit".equalsIgnoreCase(listColumn.getListFieldKey())) continue;
            if (this.isFieldsControlList) {
                listColumns.remove(listColumn);
                this.isFieldsControlList = false;
            } else {
                listColumn.setForeColor("blue");
                listColumn.setHyperlink(true);
            }
            return;
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        BillListHyperLinkClickEvent clickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        String fieldName = clickEvent.getFieldName();
        if ("edit".equalsIgnoreCase(fieldName)) {
            Long rowId = (Long)clickEvent.getCurrentRow().getPrimaryKeyValue();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtabm_vaapply");
            DynamicObject currentRow = serviceHelper.queryOne((Object)rowId);
            args.setCancel(true);
            Long parentId = currentRow.getLong("parentid");
            ArrayList<Long> list = new ArrayList<Long>();
            list.add((Long)currentRow.getPkValue());
            this.getIdList(list, parentId);
            ListShowParameter lsp = new ListShowParameter();
            ListFilterParameter fParameter = new ListFilterParameter();
            QFilter filter = new QFilter("id", "in", list);
            fParameter.setFilter(filter);
            lsp.setListFilterParameter(fParameter);
            lsp.getOpenStyle().setShowType(ShowType.Modal);
            lsp.setBillFormId("wtabm_vaupdate");
            OpenStyle openStyle = lsp.getOpenStyle();
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth("1050px");
            styleCss.setHeight("400px");
            openStyle.setInlineStyleCss(styleCss);
            lsp.setHasRight(true);
            lsp.setCaption(ResManager.loadKDString((String)"\u4f11\u5047\u53d8\u66f4\u5386\u53f2", (String)"VaApplyBillList_13", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
            ListView listView = (ListView)this.getView();
            if (HRStringUtils.equals((String)"wtabm_vaapplyself", (String)listView.getBillFormId())) {
                lsp.setCustomParam("wtcbill_hasright", (Object)"1");
            }
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BillList control = (BillList)this.getView().getControl("billlistap");
        control.addListFieldsControlListeners(event -> {
            this.isFieldsControlList = true;
        });
    }

    private void getIdList(List<Long> list, Long parentId) {
        DynamicObject parentDynamicObject = this.vaApplyServiceHelper.loadDynamicObject(new QFilter("id", "=", (Object)parentId));
        if (parentDynamicObject != null) {
            boolean isChange = parentDynamicObject.getBoolean("ischange");
            list.add(parentId);
            if (isChange) {
                Long id = parentDynamicObject.getLong("parentid");
                this.getIdList(list, id);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        this.refreshListPage();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        IListView view;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        ListSelectedRowCollection selectedRows = ((IListView)operate.getView()).getSelectedRows();
        if (StringUtils.equals((CharSequence)"viewflowchart", (CharSequence)operateKey)) {
            this.viewFlowChart(args, selectedRows);
        }
        if (StringUtils.equals((CharSequence)(view = (IListView)this.getView()).getBillFormId(), (CharSequence)"wtabm_vaapply")) {
            FormOperate formOperate = (FormOperate)args.getSource();
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            Tuple booleanOperationResultTuple = BillUnifyService.opTargetBillForm((BeforeDoOperationEventArgs)args, (IListView)view, null);
            if (((Boolean)booleanOperationResultTuple.getKey()).booleanValue()) {
                OperationResult operationResult = (OperationResult)booleanOperationResultTuple.getValue();
                if (operationResult != null) {
                    if (operationResult.isSuccess()) {
                        String opSuccessTip = BillUnifyService.getOpSuccessTip((String)listShowParameter.getBillFormId(), (String)formOperate.getOperateKey());
                        if (HRStringUtils.isNotEmpty((String)opSuccessTip)) {
                            this.getView().showSuccessNotification(opSuccessTip);
                            this.getView().invokeOperation("refresh");
                        }
                    } else {
                        this.getView().showOperationResult(operationResult);
                    }
                }
                args.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)view.getBillFormId(), (CharSequence)"wtabm_vaapplyself") && StringUtils.equalsAny((CharSequence)operateKey, (CharSequence[])new CharSequence[]{"submit", "unsubmit"})) {
            this.handleOpSelfApply(args, operate);
        }
        if (!args.isCancel() && StringUtils.equalsAny((CharSequence)operateKey, (CharSequence[])new CharSequence[]{"update"})) {
            this.beforeChangeCheck(args);
        }
    }

    private void handleOpSelfApply(BeforeDoOperationEventArgs args, FormOperate formOperate) {
        String operateKey = formOperate.getOperateKey();
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        List selectRowIds = listSelectedData.stream().map(item -> (Long)item.getPrimaryKeyValue()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", selectRowIds);
        String properties = String.join((CharSequence)",", "ischange", "billno", "applytyperadio");
        DynamicObject[] queryRes = this.vaApplyServiceHelper.query(properties, new QFilter[]{qFilter});
        Map<Boolean, List<DynamicObject>> groupedResult = Arrays.stream(queryRes).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getBoolean("ischange")));
        if (MapUtils.isNotEmpty(groupedResult) && groupedResult.size() > 1) {
            String errorTips = StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit") ? VaKDStringHelper.submitTips() : VaKDStringHelper.unSubmitTips();
            this.getView().showTipNotification(errorTips);
            args.setCancel(true);
            return;
        }
        Set<Boolean> booleans = groupedResult.keySet();
        if (WTCCollections.isNotEmpty(booleans) && booleans.contains(Boolean.TRUE)) {
            formOperate.setEntityId(this.vaApplyService.getFormId(queryRes[0]));
        }
    }

    private void viewFlowChart(BeforeDoOperationEventArgs args, ListSelectedRowCollection selectedRows) {
        FormOperate operate = (FormOperate)args.getSource();
        if (selectedRows.size() != 1) {
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\uff0c\u60a8\u5f53\u524d\u9009\u62e9\u4e86[%1$s]\u884c\u3002", (String)"VaApplyBillList_17", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]), selectedRows.size());
            this.getView().showTipNotification(message);
            args.setCancel(true);
            return;
        }
        Object primaryKeyValue = selectedRows.get(0).getPrimaryKeyValue();
        String selectedProperties = String.join((CharSequence)",", "applytyperadio", "ischange", "ishavechange");
        DynamicObject dynamicObject = this.vaApplyServiceHelper.queryOne(selectedProperties, primaryKeyValue);
        if (dynamicObject == null) {
            LOG.info("\u67e5\u770b\u6d41\u7a0b\u56fe\uff0c\u6570\u636e\u4e0d\u5b58\u5728, pk:{}", primaryKeyValue);
            return;
        }
        String applyType = dynamicObject.getString("applytyperadio");
        if (BillApplyTypeEnum.BATCH.getCode().equals(applyType)) {
            String errMsg = BatchBillKDString.batchBillCannotViewFLowChart();
            this.getView().showTipNotification(errMsg);
            args.setCancel(true);
            return;
        }
        String targetBillFormId = this.vaApplyService.getFormId(dynamicObject);
        operate.setEntityId(targetBillFormId);
    }

    private void beforeChangeCheck(BeforeDoOperationEventArgs evt) {
        boolean cancel = evt.isCancel();
        if (cancel) {
            return;
        }
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Set collect = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        FormOperate source = (FormOperate)evt.getSource();
        if (CollectionUtils.isEmpty(collect) || collect.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5355\u636e\u53d8\u66f4\u3002", (String)"VaApplyBillList_04", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        } else {
            Long userPersonId;
            Long pk = (Long)selectedRows.get(0).getPrimaryKeyValue();
            String billStatus = selectedRows.get(0).getBillStatus();
            if (!HRStringUtils.equals((String)billStatus, (String)"C")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u53d8\u66f4\u5ba1\u6279\u901a\u8fc7\u7684\u5355\u636e\u3002", (String)"VaApplyBillList_05", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject dynamicObject = VaApplyServiceHelper.INSTANCE.loadSingle((Object)pk);
            String applyType = dynamicObject.getString("applytyperadio");
            if ("2".equals(applyType)) {
                String errMsg = BatchBillKDString.canNotOpBatchBIll((String)source.getOperateName().getLocaleValue());
                this.getView().showTipNotification(errMsg);
                evt.setCancel(true);
                return;
            }
            IListView view = (IListView)this.getView();
            if (StringUtils.equals((CharSequence)view.getBillFormId(), (CharSequence)"wtabm_vaapply") && (userPersonId = BillUnifyService.getUserId()) != null && userPersonId.equals(dynamicObject.getLong("personid.id"))) {
                String errMsg = ResManager.loadKDString((String)"\u4e0d\u53ef\u5728\u4e3a\u4ed6\u4eba\u7533\u8bf7\u9875\u9762\u53d8\u66f4\u672c\u4eba\u7533\u8bf7\u7684\u5355\u636e\u3002", (String)"VaApplyBillList_18", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(errMsg);
                evt.setCancel(true);
                return;
            }
            BillResponse billResponse = VaApplyService.couldChange((DynamicObject)dynamicObject, (String)source.getEntityId(), (String)BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView()));
            if (!billResponse.isSuccess()) {
                this.getView().showTipNotification((String)billResponse.getMessage().get(0));
                evt.setCancel(true);
                return;
            }
            evt.setCancel(true);
            VaApplyService.showUpdateForm((DynamicObject)dynamicObject, (IFormView)this.getView(), (CloseCallBack)new CloseCallBack((IFormPlugin)this, "close"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        boolean success = false;
        if (operationResult != null) {
            success = operationResult.isSuccess();
        }
        if (StringUtils.equalsAny((CharSequence)operateKey, (CharSequence[])new CharSequence[]{"save", "submit", "submiteffect", "discard", "unsubmit", "wfauditing", "wfauditnotpass", "wfrejecttosubmit", "delete"}) && success) {
            this.refreshListPage();
        }
    }

    private void refreshListPage() {
        BillList billlistap = (BillList)this.getView().getControl("billlistap");
        if (billlistap != null) {
            billlistap.clearSelection();
            billlistap.refresh();
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map currentCommonFilter;
        super.filterContainerSearchClick(args);
        Map filterValues = args.getFilterValues();
        List schemeFilters = (List)filterValues.get("schemefilter");
        if (CollectionUtils.isNotEmpty((Collection)schemeFilters)) {
            for (Map schemeFilter : schemeFilters) {
                String compare;
                CompareTypeEnum compareTypeEnum;
                List fieldName = (List)schemeFilter.get("FieldName");
                List compares = (List)schemeFilter.get("Compare");
                if (CollectionUtils.isEmpty((Collection)fieldName) || CollectionUtils.isEmpty((Collection)compares)) {
                    LOG.warn("\u83b7\u53d6\u7684\u65b9\u6848\u67e5\u8be2\u6761\u4ef6\u5f02\u5e38, schemeFilters:{}", (Object)JSON.toJSONString((Object)schemeFilters));
                    continue;
                }
                if (!fieldName.contains("vadate") || this.compareTypeEnums.contains(compareTypeEnum = CompareTypeEnum.createCompareTypeEnum((String)(compare = (String)compares.get(0))))) continue;
                String errMsg = ResManager.loadKDString((String)"\u4f11\u5047\u65e5\u671f\u5b57\u6bb5\u4ec5\u652f\u6301\u4eca\u5929\u3001\u6628\u5929\u3001\u672c\u5468\u3001\u4e0a\u5468\u3001\u672c\u6708\u3001\u4e0a\u6708\u3001\u8fc7\u53bb\u4e00\u4e2a\u6708\u3001\u8fc7\u53bb\u4e09\u4e2a\u6708\u3001\u672c\u5b63\u5ea6\u3001\u4e0a\u5b63\u5ea6\u3001\u4eca\u5e74\u3001\u53bb\u5e74\u3001\u660e\u5929\u3001\u4e0b\u5468\u3001\u4e0b\u4e2a\u6708\u3001\u672a\u6765\u4e00\u4e2a\u6708\u3001\u672a\u6765\u4e09\u4e2a\u6708\u3001\u4e0b\u5b63\u5ea6\u3001\u660e\u5e74\u3001\u4ece...\u5230...\u7684\u6761\u4ef6\u67e5\u8be2\u3002", (String)"VaApplyBillList_19", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]);
                throw new KDBizException(errMsg);
            }
        }
        if (MapUtils.isEmpty((Map)(currentCommonFilter = args.getCurrentCommonFilter()))) {
            LOG.info("\u65e0commonFilter");
            return;
        }
        List fieldNames = (List)currentCommonFilter.get("FieldName");
        for (Object fieldName : fieldNames) {
            List values;
            if (!"vadate".equals(fieldName)) continue;
            BillSystemParamRange range = SystemParamQueryUtil.getBillSystemParamRange((BillSystemParamConfigEnum)BillSystemParamConfigEnum.ABS);
            boolean checkSuccess = this.dateCheckSuccess(range, values = (List)currentCommonFilter.get("Value"));
            if (checkSuccess) break;
            String unit = VaApplyBillList.genUnitStr(range);
            this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6700\u5927\u53ef\u67e5\u8be2\u65e5\u671f\u8303\u56f4\u4e3a%1$s\u3002", (String)"VaApplyBillList_02", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]), range.getRange() + unit));
            values.clear();
            values.add("63");
            break;
        }
        args.setCurrentCommonFilter(currentCommonFilter);
    }

    private static String genUnitStr(BillSystemParamRange range) {
        String unitStr = StringUtils.equals((CharSequence)range.getUnit(), (CharSequence)"year") ? ResManager.loadKDString((String)"\u5e74", (String)"VaApplyBillList_14", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]) : (StringUtils.equals((CharSequence)range.getUnit(), (CharSequence)"month") ? ResManager.loadKDString((String)"\u4e2a\u6708", (String)"VaApplyBillList_15", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u65e5", (String)"VaApplyBillList_16", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
        return unitStr;
    }

    private boolean dateCheckSuccess(BillSystemParamRange range, List<Object> dateRange) {
        if (range == null || CollectionUtils.isEmpty(dateRange) || dateRange.size() != 2) {
            return true;
        }
        String startDateStr = (String)dateRange.get(0);
        String endDateStr = (String)dateRange.get(1);
        DateTimeFormatter ft = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate startDate = LocalDate.parse(startDateStr, ft);
        LocalDate endDate = LocalDate.parse(endDateStr, ft);
        LocalDate goalDate = startDate;
        switch (range.getUnit()) {
            case "year": {
                goalDate = startDate.plusYears(range.getRange().intValue());
                break;
            }
            case "month": {
                goalDate = startDate.plusMonths(range.getRange().intValue());
                break;
            }
            case "day": {
                goalDate = startDate.plusDays(range.getRange().intValue());
                break;
            }
        }
        goalDate = goalDate.plusDays(-1L);
        return !goalDate.isBefore(endDate);
    }

    public void beforeQueryOfExport(BeforeQueryOfExportEvent evt) {
        String joinedSelectFields;
        super.beforeQueryOfExport(evt);
        String selectFields = evt.getSelectFields();
        this.selectFields = joinedSelectFields = String.join((CharSequence)",", selectFields, "parentid", "ischange", "ishavechange", "originalid", "entryentity.entrystartdate", "entryentity.entryenddate", "entryentity.entrystartmethod", "entryentity.entryendmethod", "entryentity.entryvatimeday", "entryentity.entryvatimehour", "entryentity.entryunit");
        evt.setSelectFields(joinedSelectFields);
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent evt) {
        super.afterQueryOfExport(evt);
        evt.setCustomOrder(true);
        DynamicObject[] queryResults = evt.getQueryValues();
        if (queryResults.length == 0) {
            return;
        }
        List originalIdArr = Arrays.stream(queryResults).filter(queryRes -> queryRes.getBoolean("ischange")).map(result -> result.getLong("originalid")).collect(Collectors.toList());
        ArrayList newResults = Lists.newArrayListWithExpectedSize((int)(queryResults.length * 2));
        Map<Long, Map<Long, DynamicObject>> groupedTwiceMap = Collections.EMPTY_MAP;
        if (CollectionUtils.isNotEmpty(originalIdArr)) {
            List originalIds = Lists.partition(originalIdArr, (int)2000);
            ArrayList changeBillOriginals = Lists.newArrayListWithExpectedSize((int)originalIdArr.size());
            for (List originalIdList : originalIds) {
                DynamicObject[] queryOriRes = StringUtils.isEmpty((CharSequence)this.selectFields) ? this.vaApplyServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("originalid", "in", (Object)originalIdList)}) : this.vaApplyServiceHelper.query(this.selectFields, new QFilter[]{new QFilter("originalid", "in", (Object)originalIdList)});
                changeBillOriginals.addAll(Arrays.asList(queryOriRes));
            }
            groupedTwiceMap = changeBillOriginals.stream().collect(Collectors.groupingBy(res -> res.getLong("originalid"), Collectors.toMap(re -> re.getLong("id"), re -> re)));
        }
        String originalBillDesc = ResManager.loadKDString((String)"\u539f\u5355", (String)"VaApplyBillList_20", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]);
        for (DynamicObject queryResult : queryResults) {
            long originalId = queryResult.getLong("originalid");
            Map<Long, DynamicObject> parentBillMap = groupedTwiceMap.get(originalId);
            if (!queryResult.containsProperty("changenum")) continue;
            if (!queryResult.getBoolean("ischange")) {
                queryResult.set("changenum", (Object)originalBillDesc);
                newResults.add(queryResult);
                this.parseBillEntry(queryResult);
                continue;
            }
            this.resetChangeBillDesc(queryResult, parentBillMap, originalBillDesc, newResults);
        }
        evt.setQueryValues(newResults.toArray(new DynamicObject[0]));
    }

    private void resetChangeBillDesc(DynamicObject queryResult, Map<Long, DynamicObject> parentBillMap, String originalBillDesc, List<DynamicObject> newResults) {
        if (MapUtils.isNotEmpty(parentBillMap)) {
            newResults.add(queryResult);
            this.parseBillEntry(queryResult);
            long parentId = queryResult.getLong("parentid");
            int index = 1;
            while (parentId != 0L) {
                DynamicObject parentBillDyn = parentBillMap.get(parentId);
                if (parentBillDyn != null) {
                    if (parentBillDyn.getBoolean("ischange")) {
                        parentBillDyn.set("changenum", (Object)ResManager.loadKDString((String)"\u7b2c{0}\u6b21\u53d8\u66f4", (String)"VaApplyBillList_21", (String)"wtc-wtabm-formplugin", (Object[])new Object[]{index}));
                    } else {
                        parentBillDyn.set("changenum", (Object)originalBillDesc);
                    }
                    newResults.add(parentBillDyn);
                    this.parseBillEntry(parentBillDyn);
                    parentId = parentBillDyn.getLong("parentid");
                } else {
                    parentId = 0L;
                }
                ++index;
            }
            String changeBillDesc = ResManager.loadKDString((String)"\u7b2c{0}\u6b21\u53d8\u66f4", (String)"VaApplyBillList_21", (String)"wtc-wtabm-formplugin", (Object[])new Object[]{index - 1});
            queryResult.set("changenum", (Object)changeBillDesc);
        }
    }

    private void parseBillEntry(DynamicObject dyn) {
        if (dyn.containsProperty("entryentity")) {
            DynamicObjectCollection entryDyns = dyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryDyn : entryDyns) {
                if (entryDyn.containsProperty("entrystarttimetext") && entryDyn.containsProperty("entrystartdate") && entryDyn.containsProperty("entrystartmethod")) {
                    String entryDateStr = this.vaApplyService.getEntryDateStr(entryDyn.getDate("entrystartdate"), entryDyn.getString("entrystartmethod"));
                    entryDyn.set("entrystarttimetext", (Object)entryDateStr);
                }
                if (entryDyn.containsProperty("entryendtimetext") && entryDyn.containsProperty("entryenddate") && entryDyn.containsProperty("entryendmethod")) {
                    String entryENdDateStr = this.vaApplyService.getEntryDateStr(entryDyn.getDate("entryenddate"), entryDyn.getString("entryendmethod"));
                    entryDyn.set("entryendtimetext", (Object)entryENdDateStr);
                }
                if (!entryDyn.containsProperty("entryapplytime") || !entryDyn.containsProperty("entryvatimeday") || !entryDyn.containsProperty("entryvatimehour") || !entryDyn.containsProperty("entryunit")) continue;
                String entryUnit = entryDyn.getString("entryunit");
                if (StringUtils.equals((CharSequence)ApplyBillTimeUnitEnum.DAY.unit, (CharSequence)entryUnit)) {
                    entryDyn.set("entryapplytime", (Object)entryDyn.getBigDecimal("entryvatimeday").setScale(2, RoundingMode.HALF_UP));
                    continue;
                }
                entryDyn.set("entryapplytime", (Object)entryDyn.getBigDecimal("entryvatimehour").setScale(2, RoundingMode.HALF_UP));
            }
        }
    }
}

