/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.formplugin.web.vaapply;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.wtc.wtabm.business.vaapply.VaApplyMobBusiness;
import kd.wtc.wtabm.business.vaapply.VaApplyService;
import kd.wtc.wtabm.business.vaapply.VaApplyServiceHelper;
import kd.wtc.wtabm.business.vaapply.VaKDStringHelper;
import kd.wtc.wtabm.common.vaapply.VaApplyMobConstants;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.mobile.BillContainerService;
import kd.wtc.wtbs.business.mobile.MobileCommonServiceHelper;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.enums.bill.BillOpenStyleEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtabm.common.constants.VaApplyConstants;

public class VaApplyMobApproPlugin
extends AbstractMobFormPlugin
implements VaApplyMobConstants,
VaApplyConstants {
    private static final Log logger = LogFactory.getLog(VaApplyMobApproPlugin.class);
    private VaApplyMobBusiness vaApplyMobBusiness = VaApplyMobBusiness.getInstance();

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"panelup", "paneldown", "lbl_up", "lbl_down", "tblmodity", "tblchange"});
    }

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        MobileBillShowParameter formShowParameter = (MobileBillShowParameter)evt.getFormShowParameter();
        long pkId = formShowParameter.getPkId() == null && formShowParameter.getCustomParam("businessKey") != null ? (Long)formShowParameter.getCustomParam("businessKey") : Long.parseLong(formShowParameter.getPkId().toString());
        logger.info("VaApplyMobApproPlugin.preOpenForm.pkId:{}", (Object)pkId);
        formShowParameter.setBillStatus(BillOperationStatus.VIEW);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u4f11\u5047\u7533\u8bf7", (String)"VaApplyMobApproPlugin_0", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
        formShowParameter.setPkId((Object)pkId);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        DynamicObject vaApplyBill = this.getModel().getDataEntity(true);
        this.vaApplyMobBusiness.setVaApproInfo(vaApplyBill, this.getView(), 0);
        this.vaApplyMobBusiness.setApproEntity(vaApplyBill, this.getModel());
        this.initPage(vaApplyBill);
        VaApplyMobBusiness.getInstance().setHandVisible(this.getView());
    }

    public void beforeClick(BeforeClickEvent evt) {
        long pkValue;
        VaApplyServiceHelper vaApplyServiceHelper;
        DynamicObject dynamicObject;
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (StringUtils.equals((CharSequence)"tblmodity", (CharSequence)key) && (dynamicObject = (vaApplyServiceHelper = new VaApplyServiceHelper()).queryOriginalOne("id", new QFilter("id", "=", (Object)(pkValue = this.getModel().getDataEntity().getLong("id"))))) == null) {
            this.getView().showErrorNotification(VaKDStringHelper.dataNotExistFail());
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        this.vaApplyMobBusiness.setUpAndDown(key, this.getView(), this.getModel());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        MobileBillShowParameter formShowParameter = (MobileBillShowParameter)this.getView().getFormShowParameter();
        String applyType = (String)this.getView().getModel().getValue("applytyperadio");
        DynamicObject vaUpdateBill = this.getModel().getDataEntity(true);
        this.vaApplyMobBusiness.billStatusCheck(operateKey, vaUpdateBill, args, this.getView());
        if (args.isCancel()) {
            return;
        }
        switch (operateKey) {
            case "modify": {
                String type = "wtabm_vaapply";
                if ("0".equals(applyType)) {
                    type = "wtabm_vaapplyself";
                }
                if (!MobileCommonServiceHelper.getInstance().judgeAttFile(this.getView(), BillTypeEnum.VACATIONBILL.getBillName())) {
                    args.setCancel(true);
                    return;
                }
                this.vaApplyMobBusiness.releaseMutexIfIsCurrentUser((Long)formShowParameter.getPkId(), type);
                this.showVaApplyMob();
                break;
            }
            case "update": {
                if (!MobileCommonServiceHelper.getInstance().judgeAttFile(this.getView(), BillTypeEnum.VACATIONBILL.getBillName())) {
                    args.setCancel(true);
                    return;
                }
                BillResponse billResponse = VaApplyService.couldChange((Object)vaUpdateBill.getPkValue(), (String)this.getView().getEntityId(), (String)BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView()));
                if (!billResponse.isSuccess()) {
                    this.getView().showTipNotification((String)billResponse.getMessage().get(0));
                    args.setCancel(true);
                    return;
                }
                long pkId = this.getModel().getDataEntity().getLong("id");
                BillCommonService billCommonService = new BillCommonService();
                BillApplyTypeEnum billApplyTypeEnum = billCommonService.billChangeOpenType(this.getModel().getDataEntity(true));
                String openChangePage = billApplyTypeEnum == BillApplyTypeEnum.SELF ? "wtabm_vaupdateself_change" : "wtabm_vaupdate_change";
                HashMap customParams = Maps.newHashMap();
                customParams.put("changeId", pkId);
                logger.info("\u70b9\u51fb\u53d8\u66f4\u8df3\u8f6c\u9875\u9762.pkId:{}, openChangePage:{}", (Object)pkId, (Object)openChangePage);
                BillContainerService.getInstance().openChangePage(this.getView(), openChangePage, (Map)customParams);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if ("delete".equals(operateKey) && operationResult.isSuccess()) {
            logger.info("\u5220\u9664\u6210\u529f\u8df3\u8f6c\u3002");
            BillContainerService.getInstance().returnSource(this.getView());
        } else if ("submit".equals(operateKey) && operationResult.isSuccess()) {
            String applyType = (String)this.getView().getModel().getValue("applytyperadio");
            String type = "wtabm_vaapplyappro";
            if ("0".equals(applyType)) {
                type = "wtabm_vaapplyappro_self";
            }
            String applyName = ResManager.loadKDString((String)"\u4f11\u5047\u7533\u8bf7", (String)"VaApplyMobApproPlugin_0", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]);
            long pkValue = this.getModel().getDataEntity().getLong("id");
            logger.info("\u63d0\u4ea4\u6210\u529f\u8df3\u8f6c\u67e5\u770b\u9875\uff0c applyName:{}, type:{}, id:{}", new Object[]{applyName, type, pkValue});
            BillContainerService.getInstance().openSuccessPage(this.getView(), applyName, type, pkValue);
        } else if ("unsubmit".equals(operateKey) && operationResult.isSuccess()) {
            String applyType = (String)this.getView().getModel().getValue("applytyperadio");
            String type = "0".equals(applyType) ? "wtabm_vaapplyappro_self" : "wtabm_vaapplyappro";
            HashMap<String, Boolean> customParams = new HashMap<String, Boolean>(2);
            customParams.put("flagWorkFlow", Boolean.FALSE);
            customParams.put("flagFromMyBill", Boolean.TRUE);
            long pkValue = this.getModel().getDataEntity().getLong("id");
            logger.info("\u64a4\u9500\u6210\u529f\u8df3\u8f6c\uff0c type:{}, id:{}", (Object)type, (Object)pkValue);
            BillContainerService.getInstance().openDetailPage(this.getView(), type, pkValue, customParams);
        }
    }

    public void initPage(DynamicObject mainEntity) {
        String applyType;
        Object flagWorkFlow;
        String billStatus = mainEntity.getString("billstatus");
        this.getView().setVisible(Boolean.FALSE, new String[]{"headerflex", "buttonflex", "changebuttonflex", "approvalflex", "leftflex", "rightflex", "unsubmitbuttonflex"});
        if ("A".equals(billStatus) || "G".equals(billStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"headerflex", "buttonflex", "approvalflex"});
        }
        if ((flagWorkFlow = this.getView().getFormShowParameter().getCustomParam("flagWorkFlow")) != null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"leftflex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"rightflex"});
            boolean editable = MobileCommonServiceHelper.getInstance().isEditable(this.getModel());
            if (editable) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"headerflex", "buttonflex", "approvalflex"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"headerflex", "approvalflex"});
                if ("C".equals(billStatus)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"changebuttonflex"});
                } else if ("D".equals(billStatus)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"unsubmitbuttonflex"});
                }
            }
        }
        if ("A".equals(billStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"headerflex", "buttonflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"approvalflex"});
        }
        if (mainEntity.getDynamicObjectCollection("entryentity").size() <= 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"panelup"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"paneldown"});
        String billStyle = mainEntity.getString("billstyle");
        if (WTCStringUtils.equals((String)billStyle, (String)BillOpenStyleEnum.SINGLE.getCode())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap20"});
        }
        if ("2".equals(applyType = mainEntity.getString("applytyperadio"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap20"});
        }
    }

    private void showVaApplyMob() {
        String applyType = (String)this.getView().getModel().getValue("applytyperadio");
        String targetFormId = "0".equals(applyType) ? "wtabm_vaapplymob_self" : "wtabm_vaapplymob";
        long pkId = this.getModel().getDataEntity().getLong("id");
        HashMap<String, Boolean> customParams = new HashMap<String, Boolean>(2);
        customParams.put("isAbnormal", Boolean.FALSE);
        logger.info("\u8df3\u8f6c\u4fee\u6539\u9875\uff0c targetFormId:{}, pkId:{}, customParams:{}", new Object[]{targetFormId, pkId, customParams});
        BillContainerService.getInstance().openEditPage(this.getView(), targetFormId, pkId, customParams);
    }
}

